/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.util;

import com.arms.egovframework.javaservice.treeframework.util.EgovBasicLogger;
import java.io.Closeable;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Wrapper;

public class EgovResourceCloseHelper {
    public static void close(Closeable ... resources) {
        Closeable[] var1 = resources;
        int var2 = resources.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            Closeable resource = var1[var3];
            if (resource == null) continue;
            try {
                resource.close();
                continue;
            }
            catch (Exception var6) {
                EgovBasicLogger.ignore((String)"Occurred Exception to close resource is ingored!!");
            }
        }
    }

    public static void closeDBObjects(Wrapper ... objects) {
        Wrapper[] var1 = objects;
        int var2 = objects.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            Wrapper object = var1[var3];
            if (object == null) continue;
            if (object instanceof ResultSet) {
                try {
                    ((ResultSet)object).close();
                }
                catch (Exception var7) {
                    EgovBasicLogger.ignore((String)"Occurred Exception to close resource is ingored!!");
                }
                continue;
            }
            if (object instanceof Statement) {
                try {
                    ((Statement)object).close();
                }
                catch (Exception var8) {
                    EgovBasicLogger.ignore((String)"Occurred Exception to close resource is ingored!!");
                }
                continue;
            }
            if (!(object instanceof Connection)) {
                throw new IllegalArgumentException("Wrapper type is not found : " + object.toString());
            }
            try {
                ((Connection)object).close();
                continue;
            }
            catch (Exception var6) {
                EgovBasicLogger.ignore((String)"Occurred Exception to close resource is ingored!!");
            }
        }
    }

    public static void closeSocketObjects(Socket socket, ServerSocket server) {
        if (socket != null) {
            try {
                socket.shutdownOutput();
            }
            catch (Exception var5) {
                EgovBasicLogger.ignore((String)"Occurred Exception to shutdown ouput is ignored!!");
            }
            try {
                socket.close();
            }
            catch (Exception var4) {
                EgovBasicLogger.ignore((String)"Occurred Exception to close resource is ignored!!");
            }
        }
        if (server != null) {
            try {
                server.close();
            }
            catch (Exception var3) {
                EgovBasicLogger.ignore((String)"Occurred Exception to close resource is ignored!!");
            }
        }
    }

    public static void closeSockets(Socket ... sockets) {
        Socket[] var1 = sockets;
        int var2 = sockets.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            Socket socket = var1[var3];
            if (socket == null) continue;
            try {
                socket.shutdownOutput();
            }
            catch (Exception var7) {
                EgovBasicLogger.ignore((String)"Occurred Exception to shutdown ouput is ignored!!");
            }
            try {
                socket.close();
                continue;
            }
            catch (Exception var6) {
                EgovBasicLogger.ignore((String)"Occurred Exception to close resource is ignored!!");
            }
        }
    }
}

