/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.controller;

import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.model.TreeBaseDTO;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.remote.Chat;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import com.arms.egovframework.javaservice.treeframework.util.Util_TitleChecker;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.AlterNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.AlterNodeType;
import com.arms.egovframework.javaservice.treeframework.validation.group.MoveNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.RemoveNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.UpdateNode;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Api(value="TreeFramework")
public abstract class TreeAbstractController<T extends TreeService, D extends TreeBaseDTO, V extends TreeSearchEntity> {
    private static final Logger log = LoggerFactory.getLogger(TreeAbstractController.class);
    private T treeService;
    private Class<V> treeEntity;
    @Autowired
    protected ModelMapper modelMapper;
    @Autowired
    protected Chat chat;

    public void setTreeService(T treeService) {
        this.treeService = treeService;
    }

    public void setTreeEntity(Class<V> treeEntity) {
        this.treeEntity = treeEntity;
    }

    @ApiOperation(value="[Select] TreeFramework\uc758 GetNode")
    @ResponseBody
    @RequestMapping(value={"/getNode.do"}, method={RequestMethod.GET})
    public ModelAndView getNode(D treeBaseDTO, HttpServletRequest request) throws Exception {
        log.info("TreeAbstractController :: getNode");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        TreeSearchEntity returnVO = this.treeService.getNode(treeSearchEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)returnVO);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/getChildNode.do"}, method={RequestMethod.GET})
    public ModelAndView getChildNode(D treeBaseDTO, HttpServletRequest request) throws Exception {
        log.info("TreeAbstractController :: getChildNode");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        treeSearchEntity.setWhere("c_parentid", (Object)new Long(parser.get("c_id")));
        treeSearchEntity.setOrder(Order.desc((String)"c_position"));
        List list = this.treeService.getChildNode(treeSearchEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)list);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/getNodesWithoutRoot.do"}, method={RequestMethod.GET})
    public ModelAndView getNodesWithoutRoot(D treeBaseDTO) throws Exception {
        log.info("TreeAbstractController :: getNodesWithoutRoot");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        treeSearchEntity.setOrder(Order.desc((String)"c_position"));
        Criterion criterion = Restrictions.not((Criterion)Restrictions.in((String)"c_id", (Object[])new Object[]{TreeConstant.ROOT_CID, TreeConstant.First_Node_CID}));
        treeSearchEntity.getCriterions().add(criterion);
        List list = this.treeService.getChildNode(treeSearchEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("paginationInfo", treeSearchEntity.getPaginationInfo());
        resultMap.put("result", list);
        modelAndView.addObject("result", (Object)resultMap);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/getPaginatedChildNode.do"}, method={RequestMethod.GET})
    public ModelAndView getPaginatedChildNode(D treeBaseDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("TreeAbstractController :: getPaginatedChildNode");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        if (treeSearchEntity.getC_id() <= 0L || treeSearchEntity.getPageIndex() <= 0 || treeSearchEntity.getPageUnit() <= 0 || treeSearchEntity.getPageSize() <= 0) {
            throw new RuntimeException();
        }
        treeSearchEntity.setWhere("c_parentid", (Object)treeSearchEntity.getC_id());
        List resultChildNodes = this.treeService.getPaginatedChildNode(treeSearchEntity);
        treeSearchEntity.getPaginationInfo().setTotalRecordCount(resultChildNodes.size());
        ModelAndView modelAndView = new ModelAndView("jsonView");
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("paginationInfo", treeSearchEntity.getPaginationInfo());
        resultMap.put("result", resultChildNodes);
        modelAndView.addObject("result", (Object)resultMap);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/searchNode.do"}, method={RequestMethod.GET})
    public ModelAndView searchNode(D treeBaseDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("TreeAbstractController :: searchNode");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (!StringUtils.hasText((String)request.getParameter("searchString"))) {
            throw new RuntimeException("searchString is null");
        }
        treeSearchEntity.setWhereLike("c_title", parser.get("parser"));
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.treeService.searchNode(treeSearchEntity));
        return modelAndView;
    }

    @ApiOperation(value="[Insert] TreeFramework\uc758 AddNode")
    @ResponseBody
    @RequestMapping(value={"/addNode.do"}, method={RequestMethod.POST})
    public ModelAndView addNode(@Validated(value={AddNode.class}) D treeBaseDTO, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("TreeAbstractController :: addNode");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        treeSearchEntity.setC_title(Util_TitleChecker.StringReplace((String)treeSearchEntity.getC_title()));
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.treeService.addNode(treeSearchEntity));
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/removeNode.do"}, method={RequestMethod.DELETE})
    public ModelAndView removeNode(@Validated(value={RemoveNode.class}) D treeBaseDTO, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("TreeAbstractController :: removeNode");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        treeSearchEntity.setStatus((long)this.treeService.removeNode(treeSearchEntity));
        this.setJsonDefaultSetting(treeSearchEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)treeSearchEntity);
        return modelAndView;
    }

    public void setJsonDefaultSetting(V treeSearchEntity) {
        long defaultSettingValue = 0L;
        treeSearchEntity.setC_parentid(Long.valueOf(defaultSettingValue));
        treeSearchEntity.setC_position(Long.valueOf(defaultSettingValue));
        treeSearchEntity.setC_left(Long.valueOf(defaultSettingValue));
        treeSearchEntity.setC_right(Long.valueOf(defaultSettingValue));
        treeSearchEntity.setC_level(Long.valueOf(defaultSettingValue));
        treeSearchEntity.setRef(defaultSettingValue);
    }

    @ResponseBody
    @RequestMapping(value={"/updateNode.do"}, method={RequestMethod.PUT})
    public ModelAndView updateNode(@Validated(value={UpdateNode.class}) D treeBaseDTO, BindingResult bindingResult, HttpServletRequest request, ModelMap model) throws Exception {
        log.info("TreeAbstractController :: updateNode");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.treeService.updateNode(treeSearchEntity));
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/alterNode.do"}, method={RequestMethod.PUT})
    public ModelAndView alterNode(@Validated(value={AlterNode.class}) D treeBaseDTO, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("TreeAbstractController :: alterNode");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        treeSearchEntity.setC_title(Util_TitleChecker.StringReplace((String)treeSearchEntity.getC_title()));
        treeSearchEntity.setStatus((long)this.treeService.alterNode(treeSearchEntity));
        this.setJsonDefaultSetting(treeSearchEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)treeSearchEntity);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/alterNodeType.do"}, method={RequestMethod.PUT})
    public ModelAndView alterNodeType(@Validated(value={AlterNodeType.class}) D treeBaseDTO, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("TreeAbstractController :: alterNodeType");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        this.treeService.alterNodeType(treeSearchEntity);
        this.setJsonDefaultSetting(treeSearchEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)treeSearchEntity);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/moveNode.do"}, method={RequestMethod.POST})
    public ModelAndView moveNode(@Validated(value={MoveNode.class}) D treeBaseDTO, BindingResult bindingResult, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("TreeAbstractController :: moveNode");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        this.treeService.moveNode(treeSearchEntity, request);
        this.setJsonDefaultSetting(treeSearchEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)treeSearchEntity);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/analyzeNode.do"}, method={RequestMethod.GET})
    public ModelAndView analyzeNode(ModelMap model) {
        log.info("TreeAbstractController :: analyzeNode");
        model.addAttribute("analyzeResult", (Object)"");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)"true");
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/getMonitor.do"}, method={RequestMethod.GET})
    public ModelAndView getMonitor(D treeBaseDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("TreeAbstractController :: getMonitor");
        TreeSearchEntity treeSearchEntity = (TreeSearchEntity)this.modelMapper.map(treeBaseDTO, this.treeEntity);
        treeSearchEntity.setOrder(Order.desc((String)"c_position"));
        List list = this.treeService.getChildNode(treeSearchEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)list);
        return modelAndView;
    }

    @ResponseBody
    @GetMapping(value={"/send-message"})
    public ResponseEntity<?> sendMessage(@RequestParam(value="message") String message) {
        this.chat.sendMessageByEngine(message);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)"OK"));
    }
}

