/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class KafkaShutdownManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    ApplicationEventPublisher applicationEventPublisher;

    public KafkaShutdownManager(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void refusingTraffic() {
        AvailabilityChangeEvent.publish((ApplicationEventPublisher)this.applicationEventPublisher, (Object)this, (AvailabilityState)ReadinessState.REFUSING_TRAFFIC);
    }

    public void acceptTraffic() {
        AvailabilityChangeEvent.publish((ApplicationEventPublisher)this.applicationEventPublisher, (Object)this, (AvailabilityState)ReadinessState.ACCEPTING_TRAFFIC);
    }

    @Async
    @EventListener
    public void waitForAWhileFromRefusingTraffic(AvailabilityChangeEvent<ReadinessState> readiness) throws InterruptedException {
        if (readiness.getState() == ReadinessState.REFUSING_TRAFFIC) {
            Thread.sleep(3000L);
            this.acceptTraffic();
        }
    }

    public KafkaShutdownManager() {
    }
}

