/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.service;

import com.arms.api.util.filerepository.model.FileRepositoryEntity;
import com.arms.api.util.filerepository.service.FileRepository;
import com.arms.api.wiki.service.WikiService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import com.arms.egovframework.javaservice.treeframework.util.EgovFileUploadUtil;
import com.arms.egovframework.javaservice.treeframework.util.EgovFormBasedFileVo;
import com.arms.egovframework.javaservice.treeframework.util.PropertiesReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="WikiService")
public class WikiServiceImpl
extends TreeServiceImpl
implements WikiService {
    private static final Logger log = LoggerFactory.getLogger(WikiServiceImpl.class);
    private final FileRepository fileRepository;

    public List<FileRepositoryEntity> imageUpload(MultipartHttpServletRequest multiRequest) {
        try {
            PropertiesReader propertiesReader = new PropertiesReader("com/arms/egovframework/property/globals.properties");
            String uploadDir = propertiesReader.getProperty("Globals.fileStorePath");
            long maxFileSize = TreeConstant.MAX_UPLOAD_FILESIZE;
            List uploadFiles = EgovFileUploadUtil.uploadFiles((HttpServletRequest)multiRequest, (String)uploadDir, (long)maxFileSize);
            ArrayList<FileRepositoryEntity> fileRepositoryEntities = new ArrayList<FileRepositoryEntity>();
            for (EgovFormBasedFileVo uploadFile : uploadFiles) {
                FileRepositoryEntity fileRepositoryEntity = FileRepositoryEntity.builder().fileName(uploadFile.getFileName()).contentType(uploadFile.getContentType()).serverSubPath(uploadFile.getServerSubPath()).physicalName(uploadFile.getPhysicalName()).size(Long.valueOf(uploadFile.getSize())).name(uploadFile.getName()).url(uploadFile.getUrl()).thumbnailUrl(uploadFile.getThumbnailUrl()).delete_url(uploadFile.getDelete_url()).delete_type(uploadFile.getDelete_type()).build();
                fileRepositoryEntity.setRef(TreeConstant.First_Node_CID.longValue());
                fileRepositoryEntity.setC_title("for Wiki");
                fileRepositoryEntity.setC_type("default");
                FileRepositoryEntity uploadedFile = (FileRepositoryEntity)this.fileRepository.addNode((TreeSearchEntity)fileRepositoryEntity);
                fileRepositoryEntity.setUrl("/auth-user/api/arms/fileRepository/downloadFileByNode/" + uploadedFile.getId());
                fileRepositoryEntity.setThumbnailUrl("/auth-user/api/arms/fileRepository/thumbnailUrlFileToNode/" + uploadedFile.getId());
                fileRepositoryEntity.setDelete_url("/auth-user/api/arms/pdServiceDetail/deleteFileNode.do/" + uploadedFile.getId());
                this.fileRepository.updateNode((TreeSearchEntity)fileRepositoryEntity);
                fileRepositoryEntities.add(fileRepositoryEntity);
            }
            return fileRepositoryEntities;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public WikiServiceImpl(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }
}

