/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.filerepository.controller;

import com.arms.api.product_service.pdservice.service.PdService;
import com.arms.api.util.filerepository.model.FileRepositoryDTO;
import com.arms.api.util.filerepository.model.FileRepositoryEntity;
import com.arms.api.util.filerepository.service.FileRepository;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.util.EgovFormBasedFileUtil;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import com.arms.egovframework.javaservice.treeframework.util.PropertiesReader;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/arms/fileRepository"})
public class FileRepositoryController
extends TreeAbstractController<FileRepository, FileRepositoryDTO, FileRepositoryEntity> {
    private static final Logger log = LoggerFactory.getLogger(FileRepositoryController.class);
    @Autowired
    @Qualifier(value="fileRepository")
    private FileRepository fileRepository;
    @Autowired
    @Qualifier(value="pdService")
    private PdService pdService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.fileRepository);
        this.setTreeEntity(FileRepositoryEntity.class);
    }

    @ResponseBody
    @RequestMapping(value={"/getFilesByNode.do"}, method={RequestMethod.GET})
    public ModelAndView getFilesByNode(FileRepositoryDTO fileRepositoryDTO, HttpServletRequest request) throws Exception {
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        HashMap returnMap = this.fileRepository.getFileSetByFileIdLink(parser);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)returnMap);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/deleteFileByNode/{fileId}"}, method={RequestMethod.POST})
    public ModelAndView deleteFileByNode(@PathVariable(value="fileId") Long fileId, ModelMap model, HttpServletRequest request) throws Exception {
        FileRepositoryEntity fileRepositoryEntity = new FileRepositoryEntity();
        fileRepositoryEntity.setC_id(fileId);
        int result = this.fileRepository.removeNode((TreeSearchEntity)fileRepositoryEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)result);
        return modelAndView;
    }

    @RequestMapping(value={"/downloadFileByNode/{fileId}"}, method={RequestMethod.GET})
    public void downloadFile(@PathVariable(value="fileId") Long fileId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PropertiesReader propertiesReader = new PropertiesReader("com/arms/egovframework/property/globals.properties");
        String uploadPath = propertiesReader.getProperty("Globals.fileStorePath");
        FileRepositoryEntity fileRepositoryEntity = new FileRepositoryEntity();
        fileRepositoryEntity.setWhere("c_id", (Object)fileId);
        FileRepositoryEntity returnFileRepositoryEntity = (FileRepositoryEntity)this.fileRepository.getNode((TreeSearchEntity)fileRepositoryEntity);
        EgovFormBasedFileUtil.downloadFile((HttpServletResponse)response, (String)uploadPath, (String)returnFileRepositoryEntity.getServerSubPath(), (String)returnFileRepositoryEntity.getPhysicalName(), (String)returnFileRepositoryEntity.getContentType(), (String)returnFileRepositoryEntity.getFileName());
    }
}

