/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.dynamicscheduler.service;

import com.arms.api.jira.jiraproject.model.JiraProjectEntity;
import com.arms.api.jira.jiraproject.service.JiraProject;
import com.arms.api.jira.jiraserver.model.JiraServerEntity;
import com.arms.api.requirement.reqadd.model.dto.ReqAddDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusEntity;
import com.arms.api.requirement.reqstatus.service.ReqStatus;
import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.api.util.aspect.SlackSendAlarm;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import com.arms.api.util.communicate.external.response.jira.CReqProperty;
import com.arms.api.util.communicate.external.response.jira.\uc9c0\ub77c\uc774\uc288\uc0dd\uc131_\ub370\uc774\ud130;
import com.arms.api.util.communicate.external.response.jira.\uc9c0\ub77c\uc774\uc288\ud544\ub4dc_\ub370\uc774\ud130;
import com.arms.api.util.communicate.internal.InternalService;
import com.arms.api.util.dynamicscheduler.service.ReqStatusSyncService;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ReqStatusSyncServiceImpl
implements ReqStatusSyncService {
    private static final Logger log = LoggerFactory.getLogger(ReqStatusSyncServiceImpl.class);
    private final InternalService internalService;
    private final JiraProject jiraProject;
    private final ModelMapper modelMapper;
    private final EngineService engineService;
    private final ReqStatus reqStatus;

    @Async
    @DwrSendAlarm(messageOnStart="ALM \uc694\uad6c\uc0ac\ud56d \uc774\uc288 \ub3d9\uae30\ud654\ub97c \uc2dc\uc791 \ud569\ub2c8\ub2e4.(ALM TO DB)", messageOnEnd="ALM \uc694\uad6c\uc0ac\ud56d \uc774\uc288 \ub3d9\uae30\ud654\uac00 \uc644\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4.(ALM TO DB)")
    @SlackSendAlarm(messageOnStart="ALM \uc694\uad6c\uc0ac\ud56d \uc774\uc288 \ub3d9\uae30\ud654\ub97c \uc2dc\uc791 \ud569\ub2c8\ub2e4.(ALM TO DB)", messageOnEnd="ALM \uc694\uad6c\uc0ac\ud56d \uc774\uc288 \ub3d9\uae30\ud654\uac00 \uc644\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4.(ALM TO DB)")
    public void \uc5d4\uc9c4\uc218\uc9d1\uacb0\uacfc_\ub3d9\uae30\ud654(List<AlmIssue> almIssues) throws Exception {
        String logMessagePrefix = "[ ReqStatusSyncService :: \uc774\uc288\ub3d9\uae30\ud654_ReqStatus\uc5c5\ub370\uc774\ud2b8 ]";
        List jiraProjectEntities = this.jiraProject.getNodesWithoutRoot((TreeSearchEntity)new JiraProjectEntity());
        ArrayList updatedReqStatusEntities = new ArrayList();
        almIssues.stream().filter(jiraIssue -> jiraIssue != null && jiraIssue.getRecentId() != null).forEach(jiraIssue -> {
            ReqStatusDTO reqStatusDTO = new ReqStatusDTO();
            reqStatusDTO.setC_id(jiraIssue.getCReqStatusId());
            List reqStatusEntities = (List)this.internalService.getStatusNode("T_ARMS_REQSTATUS_" + jiraIssue.getPdServiceId(), reqStatusDTO).getBody();
            if (reqStatusEntities == null || reqStatusEntities.isEmpty()) {
                log.info("{} :: ReqStatus \uc870\ud68c \uacb0\uacfc \uc5c6\uc74c. pdServiceId = {}, cReqStatusId = {}", new Object[]{logMessagePrefix, jiraIssue.getPdServiceId(), jiraIssue.getCReqStatusId()});
                return;
            }
            reqStatusEntities.forEach(reqStatusEntity -> {
                Optional<JiraProjectEntity> optionalJiraProjectEntity = jiraProjectEntities.stream().filter(project -> project.getC_jira_key().equals(jiraIssue.getProject().getKey())).findFirst();
                optionalJiraProjectEntity.ifPresent(jiraProjectEntity -> {
                    if (this.isReqStatusNeedsUpdate(reqStatusEntity, jiraIssue)) {
                        boolean issueNameMisMatch;
                        boolean bl = issueNameMisMatch = reqStatusEntity.getC_title() != null && !reqStatusEntity.getC_title().equals(jiraIssue.getSummary());
                        if (issueNameMisMatch) {
                            updatedReqStatusEntities.add(reqStatusEntity);
                        }
                        reqStatusEntity.setC_jira_project_link(jiraProjectEntity.getC_id());
                        reqStatusEntity.setC_jira_project_url(jiraProjectEntity.getC_jira_url());
                        reqStatusEntity.setC_jira_project_name(jiraProjectEntity.getC_jira_name());
                        reqStatusEntity.setC_jira_project_key(jiraProjectEntity.getC_jira_key());
                        reqStatusEntity.setC_issue_key(jiraIssue.getKey());
                        reqStatusEntity.setC_issue_update_date(new Date());
                        reqStatusEntity.setC_title(jiraIssue.getSummary());
                        this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc218\uc815\ud558\uae30("T_ARMS_REQSTATUS_" + jiraIssue.getPdServiceId(), (ReqStatusDTO)this.modelMapper.map(reqStatusEntity, ReqStatusDTO.class));
                        log.info("{} :: ReqStatus \uc5c5\ub370\uc774\ud2b8 \uc644\ub8cc. issueKey = {}, projectKey = {}", new Object[]{logMessagePrefix, jiraIssue.getKey(), jiraIssue.getProject().getKey()});
                    }
                });
            });
        });
        for (ReqStatusEntity updatedReqStatusEntity : updatedReqStatusEntities) {
            ReqStatusDTO reqStatusDTO = new ReqStatusDTO();
            reqStatusDTO.setC_req_link(updatedReqStatusEntity.getC_req_link());
            List reqStatusEntities = (List)this.internalService.REQSTATUS_CID_\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\uc870\ud68c("T_ARMS_REQSTATUS_" + updatedReqStatusEntity.getC_pdservice_link(), reqStatusDTO).getBody();
            if (reqStatusEntities == null) continue;
            reqStatusEntities.stream().max(Comparator.comparing(ReqStatusEntity::getC_issue_update_date)).stream().findFirst().ifPresent(reqStatusEntity -> {
                String cTitle = reqStatusEntity.getC_title();
                reqStatusEntities.stream().filter(a -> !reqStatusEntity.getC_id().equals(a.getC_id())).forEach(updateReqStatusEntity -> {
                    ReqStatusDTO updatedReqStatusDTO = new ReqStatusDTO();
                    updatedReqStatusDTO.setC_id(updateReqStatusEntity.getC_id());
                    updatedReqStatusDTO.setC_title(cTitle);
                    this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc218\uc815\ud558\uae30("T_ARMS_REQSTATUS_" + updatedReqStatusEntity.getC_pdservice_link(), updatedReqStatusDTO);
                    \uc9c0\ub77c\uc774\uc288\ud544\ub4dc_\ub370\uc774\ud130.\uc9c0\ub77c\uc774\uc288\ud544\ub4dc_\ub370\uc774\ud130Builder \uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ud544\ub4dc\ube4c\ub354 = \uc9c0\ub77c\uc774\uc288\ud544\ub4dc_\ub370\uc774\ud130.builder().summary(cTitle);
                    \uc9c0\ub77c\uc774\uc288\ud544\ub4dc_\ub370\uc774\ud130 \uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ud544\ub4dc = \uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ud544\ub4dc\ube4c\ub354.build();
                    \uc9c0\ub77c\uc774\uc288\uc0dd\uc131_\ub370\uc774\ud130 \uc694\uad6c\uc0ac\ud56d_\uc774\uc288 = \uc9c0\ub77c\uc774\uc288\uc0dd\uc131_\ub370\uc774\ud130.builder().fields(\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ud544\ub4dc).build();
                    JiraServerEntity jiraServerEntity = this.reqStatus.ALM\uc11c\ubc84_\uac80\uc0c9(updateReqStatusEntity.getC_jira_server_link());
                    this.engineService.\uc774\uc288_\uc218\uc815\ud558\uae30(Long.valueOf(Long.parseLong(jiraServerEntity.getC_jira_server_etc())), updateReqStatusEntity.getC_issue_key(), \uc694\uad6c\uc0ac\ud56d_\uc774\uc288);
                    this.engineService.saveRequirementIssueKeyOnlyFirst(jiraServerEntity.getC_jira_server_etc(), cTitle, updateReqStatusEntity.getC_id(), updateReqStatusEntity.getC_issue_key(), updateReqStatusEntity.getC_pdservice_link(), this.convertVersionToArray(updateReqStatusEntity.getC_req_pdservice_versionset_link()), updateReqStatusEntity.getC_req_link(), updateReqStatusEntity.getC_jira_project_key(), CReqProperty.of((ReqStatusEntity)updateReqStatusEntity));
                });
                ReqAddDTO reqAddDTO = new ReqAddDTO();
                reqAddDTO.setC_id(reqStatusEntity.getC_req_link());
                reqAddDTO.setC_title(cTitle);
                this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc218\uc815\ud558\uae30("T_ARMS_REQADD_" + updatedReqStatusEntity.getC_pdservice_link(), reqAddDTO);
            });
        }
    }

    private boolean isReqStatusNeedsUpdate(ReqStatusEntity reqStatusEntity, AlmIssue jiraIssue) {
        boolean issueKeyMismatch = reqStatusEntity.getC_issue_key() != null && !reqStatusEntity.getC_issue_key().equals(jiraIssue.getKey());
        boolean projectKeyMismatch = reqStatusEntity.getC_jira_project_key() != null && !reqStatusEntity.getC_jira_project_key().equals(jiraIssue.getProject().getKey());
        boolean issueNameMisMatch = reqStatusEntity.getC_title() != null && !reqStatusEntity.getC_title().equals(jiraIssue.getSummary());
        return issueKeyMismatch || projectKeyMismatch || issueNameMisMatch;
    }

    private Long[] convertVersionToArray(String versionList) {
        return (Long[])Arrays.stream(versionList.split("[\\[\\],\"]")).filter(s -> !s.isEmpty()).map(Long::valueOf).toArray(Long[]::new);
    }

    public ReqStatusSyncServiceImpl(InternalService internalService, JiraProject jiraProject, ModelMapper modelMapper, EngineService engineService, ReqStatus reqStatus) {
        this.internalService = internalService;
        this.jiraProject = jiraProject;
        this.modelMapper = modelMapper;
        this.engineService = engineService;
        this.reqStatus = reqStatus;
    }
}

