/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.aspect;

import com.arms.api.util.aspect.SlackSendAlarm;
import com.arms.api.util.slack.SlackNotificationService;
import com.arms.api.util.slack.SlackProperty;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Aspect
@Component
public class SlackSendAdvice {
    private static final Logger log = LoggerFactory.getLogger(SlackSendAdvice.class);
    private final SlackNotificationService slackNotificationService;

    @Before(value="@annotation(slackSendAlarm)")
    public void before(JoinPoint joinPoint, SlackSendAlarm slackSendAlarm) {
        try {
            if (!ObjectUtils.isEmpty((Object)slackSendAlarm.messageOnStart())) {
                this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.backend, slackSendAlarm.messageOnStart());
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage());
        }
    }

    @AfterReturning(value="@annotation(slackSendAlarm)")
    public void afterReturning(JoinPoint joinPoint, SlackSendAlarm slackSendAlarm) {
        try {
            if (!ObjectUtils.isEmpty((Object)slackSendAlarm.messageOnEnd())) {
                this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.backend, slackSendAlarm.messageOnEnd());
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage());
        }
    }

    @AfterThrowing(value="@annotation(slackSendAlarm)", throwing="e")
    public void afterThrowing(JoinPoint joinPoint, SlackSendAlarm slackSendAlarm, Exception e) {
        try {
            this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.backend, e.getMessage());
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    public SlackSendAdvice(SlackNotificationService slackNotificationService) {
        this.slackNotificationService = slackNotificationService;
    }
}

