/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.aspect;

import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.egovframework.javaservice.treeframework.remote.Chat;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Aspect
@Component
public class DwrSendAdvice {
    private static final Logger log = LoggerFactory.getLogger(DwrSendAdvice.class);
    protected final Chat chat;

    @Before(value="@annotation(dwrSendAlarm)")
    public void beforeMethod(JoinPoint joinPoint, DwrSendAlarm dwrSendAlarm) {
        try {
            if (!ObjectUtils.isEmpty((Object)dwrSendAlarm.messageOnStart())) {
                this.chat.sendMessageByEngine(dwrSendAlarm.messageOnStart());
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage());
        }
    }

    @AfterReturning(value="@annotation(dwrSendAlarm)")
    public void afterMethod(JoinPoint joinPoint, DwrSendAlarm dwrSendAlarm) {
        try {
            if (!ObjectUtils.isEmpty((Object)dwrSendAlarm.messageOnEnd())) {
                this.chat.sendMessageByEngine(dwrSendAlarm.messageOnEnd());
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage());
        }
    }

    public DwrSendAdvice(Chat chat) {
        this.chat = chat;
    }
}

