/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.reqadd_state_pure.service;

import com.arms.api.product_service.pdservice.model.PdServiceEntity;
import com.arms.api.product_service.pdservice.service.PdService;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.requirement.reqadd.model.dto.ReqAnalysisDTO;
import com.arms.api.requirement.reqadd_state_pure.model.ReportReqAddEntity;
import com.arms.api.requirement.reqadd_state_pure.model.ReqAddStatePureEntity;
import com.arms.api.requirement.reqadd_state_pure.model.vo.ProgressResultVO;
import com.arms.api.requirement.reqadd_state_pure.model.vo.ReportReqAddVO;
import com.arms.api.requirement.reqadd_state_pure.model.vo.ReqProgressVO;
import com.arms.api.requirement.reqadd_state_pure.model.vo.WeeklyReportReqAddVO;
import com.arms.api.requirement.reqadd_state_pure.service.ReqAddStatePure;
import com.arms.api.requirement.reqstate.service.ReqState;
import com.arms.api.util.VersionUtil;
import com.arms.api.util.communicate.external.AggregationService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.remote.Chat;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import com.arms.egovframework.javaservice.treeframework.util.DateUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="reqAddStatePure")
public class ReqAddStatePureImpl
extends TreeServiceImpl
implements ReqAddStatePure {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AggregationService aggregationService;
    @Autowired
    private PdService pdService;
    @Autowired
    @Qualifier(value="reqState")
    private ReqState reqState;
    @Autowired
    protected Chat chat;

    public List<ReqAddStatePureEntity> reqProgress(ReqAddStatePureEntity reqAddStatePureEntity, String changeReqTableName, Long pdServiceId, String c_req_pdservice_versionset_link) throws Exception {
        List \uc804\uccb4\uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d;
        String[] versionStrArr = StringUtils.split((String)c_req_pdservice_versionset_link, (String)",");
        SessionUtil.setAttribute((String)"reqProgress", (Object)changeReqTableName);
        if (versionStrArr == null || versionStrArr.length == 0) {
            reqAddStatePureEntity.setOrder(Order.asc((String)"c_position"));
            \uc804\uccb4\uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d = this.getNodesWithoutRoot((TreeSearchEntity)reqAddStatePureEntity);
        } else {
            Disjunction orCondition = Restrictions.disjunction();
            for (String string : versionStrArr) {
                String string2 = "\\\"" + string + "\\\"";
                orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)string2, (MatchMode)MatchMode.ANYWHERE));
            }
            orCondition.add((Criterion)Restrictions.eq((String)"c_type", (Object)"folder"));
            reqAddStatePureEntity.getCriterions().add(orCondition);
            reqAddStatePureEntity.setOrder(Order.asc((String)"c_position"));
            \uc804\uccb4\uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d = this.getChildNode((TreeSearchEntity)reqAddStatePureEntity);
        }
        SessionUtil.removeAttribute((String)"reqProgress");
        List pdServiceVersionLinks = null;
        if (versionStrArr != null && versionStrArr.length > 0) {
            pdServiceVersionLinks = Arrays.stream(versionStrArr).map(Long::valueOf).collect(Collectors.toList());
        }
        PdServiceAndIsReqDTO pdServiceAndIsReq = new PdServiceAndIsReqDTO();
        pdServiceAndIsReq.setPdServiceLink(pdServiceId);
        pdServiceAndIsReq.setPdServiceVersionLinks(pdServiceVersionLinks);
        ReqAnalysisDTO reqAnalysisDTO = new ReqAnalysisDTO();
        reqAnalysisDTO.setPdServiceAndIsReq(pdServiceAndIsReq);
        ResponseEntity \uc77c\ubc18_\ubc84\uc804\ud544\ud130_\uc9d1\uacc4 = this.aggregationService.\uc81c\ud488\uc11c\ube44\uc2a4_\uc77c\ubc18_\ubc84\uc804_\ud574\uacb0\ucc45\uc720\ubb34_\ud1b5\uacc4_V2(reqAnalysisDTO, null);
        ResponseEntity responseEntity = this.aggregationService.\uc81c\ud488\uc11c\ube44\uc2a4_\uc77c\ubc18_\ubc84\uc804_\ud574\uacb0\ucc45\uc720\ubb34_\ud1b5\uacc4_V2(reqAnalysisDTO, "resolutiondate");
        HashMap \uc9c4\ud589\ub960\uacc4\uc0b0\ub9f5 = new HashMap();
        List \uc77c\ubc18_\ubc84\uc804\ud544\ud130_\uc9d1\uacc4\uacb0\uacfc\ubaa9\ub85d = Optional.ofNullable((List)\uc77c\ubc18_\ubc84\uc804\ud544\ud130_\uc9d1\uacc4.getBody()).orElse(new ArrayList());
        this.\uc9d1\uacc4\uacb0\uacfc\ucc98\ub9ac(\uc9c4\ud589\ub960\uacc4\uc0b0\ub9f5, \uc77c\ubc18_\ubc84\uc804\ud544\ud130_\uc9d1\uacc4\uacb0\uacfc\ubaa9\ub85d, "\uc804\uccb4");
        List \uc644\ub8cc\uc0c1\ud0dc\uc9d1\uacc4\uacb0\uacfc\ubaa9\ub85d = Optional.ofNullable((List)responseEntity.getBody()).orElse(new ArrayList());
        this.\uc9d1\uacc4\uacb0\uacfc\ucc98\ub9ac(\uc9c4\ud589\ub960\uacc4\uc0b0\ub9f5, \uc644\ub8cc\uc0c1\ud0dc\uc9d1\uacc4\uacb0\uacfc\ubaa9\ub85d, "\uc644\ub8cc");
        Map \uc644\ub8cc\uc0c1\ud0dc\ub9f5 = this.reqState.\uc644\ub8cc\uc0c1\ud0dc\uc870\ud68c();
        List<ReqAddStatePureEntity> \uc2e4\uc801\uacc4\uc0b0_\uacb0\uacfc\ubaa9\ub85d = \uc804\uccb4\uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d.stream().map(\uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0 -> {
            if (\uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.getC_req_start_date() != null && \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.getC_req_end_date() != null) {
                Date \uc2dc\uc791\uc77c = \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.getC_req_start_date();
                Date \uc885\ub8cc\uc77c = \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.getC_req_end_date();
                Date \uc624\ub298 = new Date();
                long \ucd1d\uc791\uc5c5\ub7c9 = DateUtils.getRoundedDiffDays((Date)\uc2dc\uc791\uc77c, (Date)\uc885\ub8cc\uc77c);
                long \uc9c4\ud589\uc728 = this.\uacc4\ud68d\uc9c4\ud589\ub960_\uacc4\uc0b0(\uc2dc\uc791\uc77c, \uc885\ub8cc\uc77c, \uc624\ub298);
                long \uacc4\ud68d\uc791\uc5c5\ub7c9 = 0L;
                if (\uc9c4\ud589\uc728 > 0L && \uc9c4\ud589\uc728 < 100L) {
                    \uacc4\ud68d\uc791\uc5c5\ub7c9 = DateUtils.getRoundedDiffDays((Date)\uc2dc\uc791\uc77c, (Date)\uc624\ub298);
                } else if (\uc9c4\ud589\uc728 == 100L) {
                    \uacc4\ud68d\uc791\uc5c5\ub7c9 = \ucd1d\uc791\uc5c5\ub7c9;
                }
                \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.setC_req_total_resource(Long.valueOf(\ucd1d\uc791\uc5c5\ub7c9));
                \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.setC_req_plan_resource(Long.valueOf(\uacc4\ud68d\uc791\uc5c5\ub7c9));
                \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.setC_req_plan_progress(Long.valueOf(\uc9c4\ud589\uc728));
            } else {
                \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.setC_req_total_resource(Long.valueOf(0L));
                \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.setC_req_plan_resource(Long.valueOf(0L));
                \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.setC_req_plan_progress(Long.valueOf(0L));
            }
            if (\uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.getC_type() != null && StringUtils.equals((String)\uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.getC_type(), (String)"folder")) {
                return \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0;
            }
            if (\uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.getReqStateEntity() != null && \uc644\ub8cc\uc0c1\ud0dc\ub9f5.get(\uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.getReqStateEntity().getC_id()) != null) {
                \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.setC_req_performance_progress(Long.valueOf(100L));
            } else {
                Map \uc804\uccb4\uc644\ub8cc\ub9f5 = (Map)\uc9c4\ud589\ub960\uacc4\uc0b0\ub9f5.get(\uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.getC_id());
                if (\uc804\uccb4\uc644\ub8cc\ub9f5 != null) {
                    Long \uc804\uccb4\uac1c\uc218 = \uc804\uccb4\uc644\ub8cc\ub9f5.getOrDefault("\uc804\uccb4", 0L);
                    Long \uc644\ub8cc\uac1c\uc218 = \uc804\uccb4\uc644\ub8cc\ub9f5.getOrDefault("\uc644\ub8cc", 0L);
                    Long \uc9c4\ud589\ub960 = this.\uc2e4\uc801\uacc4\uc0b0(\uc804\uccb4\uac1c\uc218, \uc644\ub8cc\uac1c\uc218);
                    \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0.setC_req_performance_progress(\uc9c4\ud589\ub960);
                }
            }
            return \uc694\uad6c\uc0ac\ud56d_\uc5d4\ud2f0\ud2f0;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return \uc2e4\uc801\uacc4\uc0b0_\uacb0\uacfc\ubaa9\ub85d;
    }

    private void \uc9d1\uacc4\uacb0\uacfc\ucc98\ub9ac(Map<Long, Map<String, Long>> \uc9c4\ud589\ub960\uacc4\uc0b0\ub9f5, List<ReqProgressVO> reqProgressListByEngine, String \uc0c1\ud0dc2) {
        if (reqProgressListByEngine.isEmpty()) {
            this.logger.error("[ReqAddStatePureImpl ::\uc9d1\uacc4\uacb0\uacfc\ucc98\ub9ac] :: reqProgressListByEngine is empty");
            return;
        }
        for (ReqProgressVO reqProgressVO : reqProgressListByEngine) {
            \uc9c4\ud589\ub960\uacc4\uc0b0\ub9f5.computeIfAbsent(reqProgressVO.getCReqLink(), k -> new HashMap()).put(\uc0c1\ud0dc2, reqProgressVO.getDocCount());
        }
    }

    private Long \uc2e4\uc801\uacc4\uc0b0(Long \uc804\uccb4\uac1c\uc218, Long \uc644\ub8cc\uac1c\uc218) {
        return \uc804\uccb4\uac1c\uc218 > 0L ? \uc644\ub8cc\uac1c\uc218 * 100L / \uc804\uccb4\uac1c\uc218 : 0L;
    }

    private long \uacc4\ud68d\uc9c4\ud589\ub960_\uacc4\uc0b0(Date \uc2dc\uc791\uc77c, Date \uc885\ub8cc\uc77c, Date \uc624\ub298) {
        if (!\uc2dc\uc791\uc77c.before(\uc885\ub8cc\uc77c)) {
            return 0L;
        }
        if (\uc624\ub298.before(\uc2dc\uc791\uc77c)) {
            return 0L;
        }
        if (\uc624\ub298.after(\uc885\ub8cc\uc77c)) {
            return 100L;
        }
        long \uc804\uccb4\uc77c\uc218 = DateUtils.getRoundedDiffDays((Date)\uc2dc\uc791\uc77c, (Date)\uc885\ub8cc\uc77c);
        long \uc9c4\ud589\uc77c\uc218 = DateUtils.getRoundedDiffDays((Date)\uc2dc\uc791\uc77c, (Date)\uc624\ub298);
        long \uc9c4\ud589\uc728 = this.\uc2e4\uc801\uacc4\uc0b0(Long.valueOf(\uc804\uccb4\uc77c\uc218), Long.valueOf(\uc9c4\ud589\uc77c\uc218));
        return Math.min(\uc9c4\ud589\uc728, 100L);
    }

    public ProgressResultVO calculateProgress(ReqAddStatePureEntity reqAddStatePureEntity, String changeReqTableName, Long pdServiceId, String c_req_pdservice_versionset_link) throws Exception {
        int totalWork = 0;
        int planWork = 0;
        double totalPerformanceProgress = 0.0;
        int reqCount = 0;
        Date today = new Date();
        List performanceCalcReqList = this.reqProgress(reqAddStatePureEntity, changeReqTableName, pdServiceId, c_req_pdservice_versionset_link);
        for (ReqAddStatePureEntity cur : performanceCalcReqList) {
            if (!"default".equals(cur.getC_type())) continue;
            totalWork = (int)((long)totalWork + cur.getC_req_total_resource());
            planWork = (int)((long)planWork + cur.getC_req_plan_resource());
            if (cur.getC_req_start_date() == null || cur.getC_req_end_date() == null || !cur.getC_req_start_date().before(today)) continue;
            totalPerformanceProgress += cur.getC_req_performance_progress() != null ? (double)cur.getC_req_performance_progress().longValue() : 0.0;
            ++reqCount;
        }
        double performanceProgressRate = reqCount > 0 ? totalPerformanceProgress / (double)reqCount : 0.0;
        double planProgressRate = totalWork > 0 ? (double)planWork / (double)totalWork * 100.0 : 0.0;
        double projectProgress = performanceProgressRate - planProgressRate;
        double performanceCapability = (double)totalWork * performanceProgressRate / 100.0;
        return ProgressResultVO.builder().totalWork(totalWork).planWork(planWork).performanceCapability(performanceCapability).planProgressRate(planProgressRate).performanceProgressRate(performanceProgressRate).projectProgress(projectProgress).build();
    }

    public List<ReportReqAddVO> reportReqStatus(ReportReqAddEntity reportReqAddEntity, String changeReqTableName, Long pdServiceId, String c_req_pdservice_versionset_link) throws Exception {
        List reportReqAddList;
        PdServiceEntity pdServiceForSearch = new PdServiceEntity();
        pdServiceForSearch.setC_id(pdServiceId);
        PdServiceEntity pdServiceEntity = (PdServiceEntity)this.pdService.getNode((TreeSearchEntity)pdServiceForSearch);
        Set pdServiceVersionEntities = pdServiceEntity.getPdServiceVersionEntities();
        HashMap<Long, String> versionIdNameMap = new HashMap<Long, String>();
        for (PdServiceVersionEntity entity : pdServiceVersionEntities) {
            versionIdNameMap.put(entity.getC_id(), entity.getC_title());
        }
        String[] versionStrArr = StringUtils.split((String)c_req_pdservice_versionset_link, (String)",");
        SessionUtil.setAttribute((String)"reportReqStatus", (Object)changeReqTableName);
        if (versionStrArr == null || versionStrArr.length == 0) {
            reportReqAddEntity.setOrder(Order.asc((String)"c_position"));
            reportReqAddList = this.getNodesWithoutRoot((TreeSearchEntity)reportReqAddEntity);
        } else {
            Disjunction orCondition = Restrictions.disjunction();
            for (String string : versionStrArr) {
                String string2 = "\\\"" + string + "\\\"";
                orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)string2, (MatchMode)MatchMode.ANYWHERE));
            }
            orCondition.add((Criterion)Restrictions.eq((String)"c_type", (Object)"folder"));
            reportReqAddEntity.getCriterions().add(orCondition);
            reportReqAddEntity.setOrder(Order.asc((String)"c_position"));
            reportReqAddList = this.getChildNode((TreeSearchEntity)reportReqAddEntity);
        }
        SessionUtil.removeAttribute((String)"reportReqStatus");
        List<ReportReqAddVO> reportReqAddVOList = reportReqAddList.stream().filter(Objects::nonNull).map(reqAdd -> ReportReqAddVO.builder().title(reqAdd.getC_title() == null ? null : reqAdd.getC_id() + ". " + reqAdd.getC_title()).versions(this.getVersionNames(versionIdNameMap, VersionUtil.stringToLongArray((String)reqAdd.getC_req_pdservice_versionset_link()))).status(reqAdd.getReqStateEntity() == null ? null : reqAdd.getReqStateEntity().getC_title()).priority(reqAdd.getReqPriorityEntity() == null ? null : reqAdd.getReqPriorityEntity().getC_title()).difficulty(reqAdd.getReqDifficultyEntity() == null ? null : reqAdd.getReqDifficultyEntity().getC_title()).start_date(reqAdd.getC_req_start_date()).end_date(reqAdd.getC_req_end_date()).build()).collect(Collectors.toList());
        return reportReqAddVOList;
    }

    public List<WeeklyReportReqAddVO> weeklyReportReqStatus(ReqAddStatePureEntity reqAddStatePureEntity, String changeReqTableName, Long pdServiceId, String c_req_pdservice_versionset_link) throws Exception {
        SessionUtil.setAttribute((String)"weeklyReportReqStatus", (Object)changeReqTableName);
        List performanceCalcReqList = this.reqProgress(reqAddStatePureEntity, changeReqTableName, pdServiceId, c_req_pdservice_versionset_link);
        SessionUtil.removeAttribute((String)"weeklyReportReqStatus");
        WeekFields weekFields = WeekFields.of(Locale.getDefault());
        HashMap<String, WeeklyReportReqAddVO> weeklyDataMap = new HashMap<String, WeeklyReportReqAddVO>();
        performanceCalcReqList.stream().filter(Objects::nonNull).forEach(reqAdd -> {
            Date cReqStartDate = reqAdd.getC_req_start_date();
            Date cReqEndDate = reqAdd.getC_req_end_date();
            LocalDate startDate = cReqStartDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate endDate = cReqEndDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM.dd");
            LocalDate weekStart = startDate.with(weekFields.dayOfWeek(), 1L);
            LocalDate weekEnd = endDate;
            while (!weekStart.isAfter(weekEnd)) {
                int year = weekStart.get(weekFields.weekBasedYear());
                int week = weekStart.get(weekFields.weekOfWeekBasedYear());
                LocalDate weekEndDate = weekStart.with(weekFields.dayOfWeek(), 7L);
                String dateRange = formatter.format(weekStart) + "~" + formatter.format(weekEndDate);
                String key = year + "\ub144 " + week + "\uc8fc\ucc28";
                String weekLabel = year + "\ub144 " + week + "\uc8fc\ucc28(" + dateRange + ")";
                WeeklyReportReqAddVO weeklyReportReqAddVO = weeklyDataMap.getOrDefault(key, WeeklyReportReqAddVO.builder().key(key).weekLabel(weekLabel).year(year).week(week).plan(new WeeklyReportReqAddVO.PlanAmount(0, 0, 0, 0.0)).actual(new WeeklyReportReqAddVO.ActualAmount(0, 0, 0.0)).build());
                int planCount = weeklyReportReqAddVO.getPlan().getCount() + 1;
                int newPlanTotal = weeklyReportReqAddVO.getPlan().getTotal() + reqAdd.getC_req_total_resource().intValue();
                int newPlanResource = weeklyReportReqAddVO.getPlan().getResource() + reqAdd.getC_req_plan_resource().intValue();
                weeklyReportReqAddVO.getPlan().setCount(planCount);
                weeklyReportReqAddVO.getPlan().setTotal(newPlanTotal);
                weeklyReportReqAddVO.getPlan().setResource(newPlanResource);
                int actualCount = weeklyReportReqAddVO.getActual().getCount() + 1;
                int performanceProgress = reqAdd.getC_req_performance_progress() == null ? 0 : reqAdd.getC_req_performance_progress().intValue();
                int actualResource = weeklyReportReqAddVO.getActual().getResource() + reqAdd.getC_req_total_resource().intValue() * performanceProgress / 100;
                weeklyReportReqAddVO.getActual().setCount(actualCount);
                weeklyReportReqAddVO.getActual().setResource(actualResource);
                weeklyDataMap.put(key, weeklyReportReqAddVO);
                weekStart = weekStart.plusWeeks(1L);
            }
        });
        AtomicInteger planAccumulation = new AtomicInteger();
        AtomicInteger actualAccumulation = new AtomicInteger();
        weeklyDataMap.forEach((s, weeklyReportReqAddVO) -> {
            planAccumulation.addAndGet(weeklyReportReqAddVO.getPlan().getResource());
            actualAccumulation.addAndGet(weeklyReportReqAddVO.getActual().getResource());
        });
        ArrayList weeklyReportReqAddVOs = new ArrayList(weeklyDataMap.values());
        List<WeeklyReportReqAddVO> weeklyReportReqAddList = weeklyReportReqAddVOs.stream().map(weeklyReportReqAddVO -> {
            int planResource = weeklyReportReqAddVO.getPlan().getResource();
            int totalPlan = planAccumulation.intValue();
            if (totalPlan > 0) {
                weeklyReportReqAddVO.getPlan().setProgress((double)planResource * 100.0 / (double)totalPlan);
            } else {
                weeklyReportReqAddVO.getPlan().setProgress(0.0);
            }
            int actualResource = weeklyReportReqAddVO.getActual().getResource();
            if (totalPlan > 0) {
                weeklyReportReqAddVO.getActual().setProgress((double)actualResource * 100.0 / (double)totalPlan);
            } else {
                weeklyReportReqAddVO.getActual().setProgress(0.0);
            }
            return weeklyReportReqAddVO;
        }).collect(Collectors.toList());
        weeklyReportReqAddList.sort(Comparator.comparing(WeeklyReportReqAddVO::getYear).thenComparing(WeeklyReportReqAddVO::getWeek));
        return weeklyReportReqAddList;
    }

    private String getVersionNames(Map<Long, String> versionNameMap, Long[] versionArr) {
        String key = Arrays.stream(versionArr).map(version -> versionNameMap.getOrDefault(version, "")).filter(name -> !name.isEmpty()).collect(Collectors.joining(","));
        return key;
    }

    public ReqAddStatePureImpl(AggregationService aggregationService, PdService pdService, ReqState reqState, Chat chat) {
        this.aggregationService = aggregationService;
        this.pdService = pdService;
        this.reqState = reqState;
        this.chat = chat;
    }
}

