/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.reqadd_pure.controller;

import com.arms.api.requirement.reqadd.excelupload.ExcelGantUpload;
import com.arms.api.requirement.reqadd.excelupload.WbsSchedule;
import com.arms.api.requirement.reqadd_pure.model.ReqAddPureDTO;
import com.arms.api.requirement.reqadd_pure.model.ReqAddPureEntity;
import com.arms.api.requirement.reqadd_pure.service.ReqAddPure;
import com.arms.api.util.filerepository.model.FileRepositoryDTO;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import com.arms.egovframework.javaservice.treeframework.validation.group.MoveNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.UpdateNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/arms/reqAddPure"})
public class ReqAddPureController
extends TreeAbstractController<ReqAddPure, ReqAddPureDTO, ReqAddPureEntity> {
    private static final Logger log = LoggerFactory.getLogger(ReqAddPureController.class);
    @Autowired
    @Qualifier(value="reqAddPure")
    private ReqAddPure reqAddPure;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.reqAddPure);
        this.setTreeEntity(ReqAddPureEntity.class);
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getMonitor.do"}, method={RequestMethod.GET})
    public ModelAndView getMonitor(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqAddPureDTO reqAddPureDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqAddPureController :: getMonitor");
        ReqAddPureEntity reqAddPureEntity = (ReqAddPureEntity)this.modelMapper.map((Object)reqAddPureDTO, ReqAddPureEntity.class);
        SessionUtil.setAttribute((String)"getMonitor", (Object)changeReqTableName);
        reqAddPureEntity.setOrder(Order.asc((String)"c_position"));
        List list = this.reqAddPure.getChildNodeWithoutPaging((TreeSearchEntity)reqAddPureEntity);
        SessionUtil.removeAttribute((String)"getMonitor");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)list);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getChildNode.do"}, method={RequestMethod.GET})
    public ModelAndView getSwitchDBChildNode(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqAddPureDTO reqAddPureDTO, HttpServletRequest request) throws Exception {
        log.info("ReqAddPureController :: getSwitchDBChildNode");
        ReqAddPureEntity reqAddPureEntity = (ReqAddPureEntity)this.modelMapper.map((Object)reqAddPureDTO, ReqAddPureEntity.class);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException();
        }
        SessionUtil.setAttribute((String)"getChildNode", (Object)changeReqTableName);
        reqAddPureEntity.setWhere("c_parentid", (Object)new Long(parser.get("c_id")));
        reqAddPureEntity.setOrder(Order.asc((String)"c_position"));
        List list = this.reqAddPure.getChildNode((TreeSearchEntity)reqAddPureEntity);
        SessionUtil.removeAttribute((String)"getChildNode");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)list);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getChildNodeWithParent.do"}, method={RequestMethod.GET})
    public ModelAndView getSwitchDBChildNodeWithParent(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqAddPureDTO reqAddPureDTO, HttpServletRequest request) throws Exception {
        log.info("ReqAddPureController :: getSwitchDBChildNodeWithParent");
        ReqAddPureEntity reqAddPureEntity = (ReqAddPureEntity)this.modelMapper.map((Object)reqAddPureDTO, ReqAddPureEntity.class);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException();
        }
        SessionUtil.setAttribute((String)"getChildNodeWithParent", (Object)changeReqTableName);
        Long targetId = new Long(parser.get("c_id"));
        SimpleExpression criterion1 = Restrictions.eq((String)"c_parentid", (Object)targetId);
        SimpleExpression criterion2 = Restrictions.eq((String)"c_id", (Object)targetId);
        LogicalExpression criterion3 = Restrictions.or((Criterion)criterion1, (Criterion)criterion2);
        reqAddPureEntity.getCriterions().add(criterion3);
        reqAddPureEntity.setOrder(Order.asc((String)"c_position"));
        List list = this.reqAddPure.getChildNode((TreeSearchEntity)reqAddPureEntity);
        SessionUtil.removeAttribute((String)"getChildNodeWithParent");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)list);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getNode.do"}, method={RequestMethod.GET})
    public ModelAndView getSwitchDBNode(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqAddPureDTO reqAddPureDTO, HttpServletRequest request) throws Exception {
        log.info("ReqAddPureController :: getSwitchDBNode");
        ReqAddPureEntity reqAddPureEntity = (ReqAddPureEntity)this.modelMapper.map((Object)reqAddPureDTO, ReqAddPureEntity.class);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException();
        }
        SessionUtil.setAttribute((String)"getNode", (Object)changeReqTableName);
        ReqAddPureEntity returnVO = (ReqAddPureEntity)this.reqAddPure.getNode((TreeSearchEntity)reqAddPureEntity);
        SessionUtil.removeAttribute((String)"getNode");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)returnVO);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getReqAddListByFilter"}, method={RequestMethod.GET})
    public ModelAndView getReqAddListByFilter(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqAddPureDTO reqAddPureDTO, HttpServletRequest request) throws Exception {
        log.info("[ ReqAddPureController :: getSwitchDBNode ]");
        ReqAddPureEntity reqAddPureEntity = (ReqAddPureEntity)this.modelMapper.map((Object)reqAddPureDTO, ReqAddPureEntity.class);
        SessionUtil.setAttribute((String)"getReqAddListByFilter", (Object)changeReqTableName);
        String[] versionStrArr = StringUtils.split((String)reqAddPureEntity.getC_req_pdservice_versionset_link(), (String)",");
        if (versionStrArr == null || versionStrArr.length == 0) {
            ModelAndView modelAndView = new ModelAndView("jsonView");
            modelAndView.addObject("result", (Object)"result is empty");
            return modelAndView;
        }
        Disjunction orCondition = Restrictions.disjunction();
        for (String string : versionStrArr) {
            String string2 = "\\\"" + string + "\\\"";
            orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)string2, (MatchMode)MatchMode.ANYWHERE));
        }
        reqAddPureEntity.getCriterions().add(orCondition);
        List savedList = this.reqAddPure.getChildNode((TreeSearchEntity)reqAddPureEntity);
        SessionUtil.removeAttribute((String)"getReqAddListByFilter");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)savedList);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/removeNode.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> removeReqNode(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={UpdateNode.class}) ReqAddPureDTO reqAddPureDTO, HttpServletRequest request, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("ReqAddPureController :: removeNode");
        ReqAddPureEntity reqAddPureEntity = (ReqAddPureEntity)this.modelMapper.map((Object)reqAddPureDTO, ReqAddPureEntity.class);
        SessionUtil.setAttribute((String)"removeNode", (Object)changeReqTableName);
        int removedReqAddPureEntity = this.reqAddPure.removeNode((TreeSearchEntity)reqAddPureEntity);
        SessionUtil.removeAttribute((String)"removeNode");
        log.info("ReqAddPureController :: removeNode");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)removedReqAddPureEntity));
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/moveNode.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> moveReqNode(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={MoveNode.class}) ReqAddPureDTO reqAddPureDTO, HttpServletRequest request, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("ReqAddPureController :: moveReqNode");
        ReqAddPureEntity reqAddPureEntity = (ReqAddPureEntity)this.modelMapper.map((Object)reqAddPureDTO, ReqAddPureEntity.class);
        SessionUtil.setAttribute((String)"moveNode", (Object)changeReqTableName);
        ReqAddPureEntity savedReqAddPureEntity = (ReqAddPureEntity)this.reqAddPure.moveNode((TreeSearchEntity)reqAddPureEntity, request);
        SessionUtil.removeAttribute((String)"moveNode");
        log.info("ReqAddPureController :: moveReqNode");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)savedReqAddPureEntity));
    }

    @ResponseBody
    @RequestMapping(value={"/uploadFileToNode.do"}, method={RequestMethod.POST})
    public ModelAndView uploadFileToNode(MultipartHttpServletRequest multiRequest, HttpServletRequest request, Model model) throws Exception {
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        long pdservice_link = parser.getLong("pdservice_link");
        HashMap map = new HashMap();
        Set entitySet = Collections.emptySet();
        map.put("files", entitySet);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", map);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/getFilesByNode.do"}, method={RequestMethod.GET})
    public ModelAndView getFilesByNode(FileRepositoryDTO fileRepositoryDTO, HttpServletRequest request) throws Exception {
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        HashMap returnMap = new HashMap();
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", returnMap);
        return modelAndView;
    }

    @ResponseBody
    @PostMapping(value={"/sample/excel-to-list"})
    public ResponseEntity excelUpload(@RequestPart(value="excelFile") MultipartFile excelFile, HttpServletRequest request) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success(new ExcelGantUpload(excelFile.getInputStream()).getGetWebScheduleList().stream().sorted(Comparator.comparing(WbsSchedule::getDepth).reversed()).collect(Collectors.toList())));
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/updateDrawIOContents.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateDrawIOContents(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={UpdateNode.class}) ReqAddPureDTO reqAddPureDTO, HttpServletRequest request) throws Exception {
        ReqAddPureEntity reqAddPureEntity = (ReqAddPureEntity)this.modelMapper.map((Object)reqAddPureDTO, ReqAddPureEntity.class);
        SessionUtil.setAttribute((String)"updateDrawIOContents", (Object)changeReqTableName);
        int result = this.reqAddPure.updateNode((TreeSearchEntity)reqAddPureEntity);
        SessionUtil.removeAttribute((String)"updateDrawIOContents");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/updateDrawDBContents.do"}, method={RequestMethod.PUT})
    public ResponseEntity<?> updateDrawDBContents(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={UpdateNode.class}) ReqAddPureDTO reqAddPureDTO, HttpServletRequest request) throws Exception {
        ReqAddPureEntity reqAddPureEntity = (ReqAddPureEntity)this.modelMapper.map((Object)reqAddPureDTO, ReqAddPureEntity.class);
        int result = this.reqAddPure.updateDrawDB(reqAddPureEntity, changeReqTableName);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }
}

