/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.reqadd.service;

import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalTreeMapService;
import com.arms.api.jira.jiraproject.model.JiraProjectEntity;
import com.arms.api.jira.jiraproject.service.JiraProject;
import com.arms.api.jira.jiraserver.model.JiraServerEntity;
import com.arms.api.jira.jiraserver.model.enums.TextFormattingType;
import com.arms.api.jira.jiraserver.service.JiraServer;
import com.arms.api.product_service.pdservice.model.PdServiceEntity;
import com.arms.api.product_service.pdservice.service.PdService;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.product_service.pdserviceversion.service.PdServiceVersion;
import com.arms.api.requirement.reqadd.model.dto.FollowReqLinkDTO;
import com.arms.api.requirement.reqadd.model.dto.ReqAddDetailDTO;
import com.arms.api.requirement.reqadd.model.dto.RequirementDTO;
import com.arms.api.requirement.reqadd.model.entity.ReqAddEntity;
import com.arms.api.requirement.reqadd.model.vo.ReqAddVO;
import com.arms.api.requirement.reqadd.model.\uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790;
import com.arms.api.requirement.reqadd.service.ReqAdd;
import com.arms.api.requirement.reqadd_pure.model.ReqAddPureEntity;
import com.arms.api.requirement.reqstatus.model.CRUDType;
import com.arms.api.requirement.reqstatus.model.ReqStatusDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusEntity;
import com.arms.api.requirement.reqstatus.service.ReqStatus;
import com.arms.api.util.TreeServiceUtils;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.internal.InternalService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.config.ArmsDetailUrlConfig;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.model.TreeBaseEntity;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.remote.Chat;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import com.arms.egovframework.javaservice.treeframework.util.DateUtils;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="reqAdd")
public class ReqAddImpl
extends TreeServiceImpl
implements ReqAdd {
    private static final Logger log = LoggerFactory.getLogger(ReqAddImpl.class);
    @Autowired
    private EngineService engineService;
    @Autowired
    private InternalService internalService;
    @Autowired
    private GlobalTreeMapService globalTreeMapService;
    @Autowired
    @Qualifier(value="pdServiceVersion")
    private PdServiceVersion pdServiceVersion;
    @Autowired
    @Qualifier(value="jiraProject")
    private JiraProject jiraProject;
    @Autowired
    @Qualifier(value="jiraServer")
    private JiraServer jiraServer;
    @Autowired
    protected Chat chat;
    @Autowired
    private ArmsDetailUrlConfig armsDetailUrlConfig;
    @Autowired
    private PdService pdService;
    @Autowired
    @Qualifier(value="reqStatus")
    private ReqStatus reqStatus;

    @Transactional
    public ReqAddEntity addReqNode(ReqAddEntity reqAddEntity, String changeReqTableName) throws Exception {
        SessionUtil.setAttribute((String)"addNode", (Object)changeReqTableName);
        ReqAddEntity savedReqAddEntity = (ReqAddEntity)this.addNode((TreeSearchEntity)reqAddEntity);
        SessionUtil.removeAttribute((String)"addNode");
        return savedReqAddEntity;
    }

    @Transactional
    public ReqAddEntity moveReqNode(ReqAddEntity reqAddEntity, String changeReqTableName, HttpServletRequest request) throws Exception {
        SessionUtil.setAttribute((String)"moveNode", (Object)changeReqTableName);
        ReqAddEntity savedReqAddEntity = (ReqAddEntity)this.moveNode((TreeSearchEntity)reqAddEntity, request);
        SessionUtil.removeAttribute((String)"moveNode");
        return savedReqAddEntity;
    }

    @Transactional
    public int removeReqNode(ReqAddEntity reqAddEntity, String changeReqTableName, HttpServletRequest request) throws Exception {
        SessionUtil.setAttribute((String)"removeNode", (Object)changeReqTableName);
        int removedReqAddEntity = this.removeNode((TreeSearchEntity)reqAddEntity);
        SessionUtil.removeAttribute((String)"removeNode");
        return removedReqAddEntity;
    }

    public ReqAddDetailDTO getDetail(FollowReqLinkDTO followReqLinkDTO, String changeReqTableName) throws Exception {
        Long targetTableId = followReqLinkDTO.getPdService();
        String targetReqAddTableName = changeReqTableName + targetTableId;
        SessionUtil.setAttribute((String)"getDetail", (Object)targetReqAddTableName);
        ReqAddEntity searchReqAddEntity = new ReqAddEntity();
        searchReqAddEntity.setC_id(followReqLinkDTO.getReqAdd());
        ReqAddEntity reqAddEntity = (ReqAddEntity)this.getNode((TreeSearchEntity)searchReqAddEntity);
        SessionUtil.removeAttribute((String)"getDetail");
        PdServiceEntity pdServiceEntity = reqAddEntity.getPdServiceEntity();
        String pdServiceVersionTitles = pdServiceEntity.getPdServiceVersionEntities().stream().filter(a -> followReqLinkDTO.getPdServiceVersion().contains(a.getC_id())).map(TreeBaseEntity::getC_title).collect(Collectors.joining(","));
        ReqAddDetailDTO.ReqAddDetailDTOBuilder reqAddDetailDTOBuilder = ReqAddDetailDTO.builder().pdService_c_title(pdServiceEntity.getC_title()).pdServiceVersion_c_title(pdServiceVersionTitles).pdService_c_id(pdServiceEntity.getC_id()).reqAdd_c_title(reqAddEntity.getC_title()).reqAdd_c_req_writer(reqAddEntity.getC_req_writer()).reqAdd_c_req_create_date(reqAddEntity.getC_req_create_date()).reqAdd_c_req_reviewer01(reqAddEntity.getC_req_reviewer01()).reqAdd_c_req_reviewer02(reqAddEntity.getC_req_reviewer02()).reqAdd_c_req_reviewer03(reqAddEntity.getC_req_reviewer03()).reqAdd_c_req_reviewer04(reqAddEntity.getC_req_reviewer04()).reqAdd_c_req_reviewer05(reqAddEntity.getC_req_reviewer05()).reqAdd_c_req_contents(reqAddEntity.getC_req_contents()).reqAdd_c_req_start_date(reqAddEntity.getC_req_start_date()).reqAdd_c_req_end_date(reqAddEntity.getC_req_end_date()).c_drawio_contents(reqAddEntity.getC_drawio_contents()).c_drawio_image_raw(reqAddEntity.getC_drawio_image_raw());
        if (reqAddEntity.getReqStateEntity() != null && reqAddEntity.getReqStateEntity().getC_id() != null) {
            reqAddDetailDTOBuilder.reqAdd_c_req_state_link(reqAddEntity.getReqStateEntity().getC_id());
        }
        if (reqAddEntity.getReqDifficultyEntity() != null && reqAddEntity.getReqDifficultyEntity().getC_id() != null) {
            reqAddDetailDTOBuilder.reqAdd_c_req_difficulty_link(reqAddEntity.getReqDifficultyEntity().getC_id());
        }
        if (reqAddEntity.getReqPriorityEntity() != null && reqAddEntity.getReqPriorityEntity().getC_id() != null) {
            reqAddDetailDTOBuilder.reqAdd_c_req_priority_link(reqAddEntity.getReqPriorityEntity().getC_id());
        }
        return reqAddDetailDTOBuilder.build();
    }

    @Transactional
    public Integer updateReqNode(ReqAddEntity reqAddEntity, String changeReqTableName) throws Exception {
        SessionUtil.setAttribute((String)"updateNode", (Object)changeReqTableName);
        this.updateNode((TreeSearchEntity)reqAddEntity);
        SessionUtil.removeAttribute((String)"updateNode");
        return 1;
    }

    @Transactional
    public Integer updateDataBase(ReqAddEntity reqAddEntity, String changeReqTableName) throws Exception {
        SessionUtil.setAttribute((String)"updateDataBase", (Object)changeReqTableName);
        int \uc694\uad6c\uc0ac\ud56d_\uc5c5\ub370\uc774\ud2b8_\uacb0\uacfc = this.updateNode((TreeSearchEntity)reqAddEntity);
        SessionUtil.removeAttribute((String)"updateDataBase");
        if (\uc694\uad6c\uc0ac\ud56d_\uc5c5\ub370\uc774\ud2b8_\uacb0\uacfc == 0) {
            log.info("ReqAddImpl :: updateDataBase :: \uc694\uad6c\uc0ac\ud56d \uc5c5\ub370\uc774\ud2b8\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc694\uad6c\uc0ac\ud56d ID : {}", (Object)reqAddEntity.getC_id());
            throw new Exception("\uc694\uad6c\uc0ac\ud56d \uc5c5\ub370\uc774\ud2b8\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uad00\ub9ac\uc790\uc5d0\uac8c \ubb38\uc758\ud574 \uc8fc\uc138\uc694.");
        }
        return \uc694\uad6c\uc0ac\ud56d_\uc5c5\ub370\uc774\ud2b8_\uacb0\uacfc;
    }

    public void \uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc_\ub514\ube44_\uc5c5\ub370\uc774\ud2b8(ReqAddEntity reqAddEntity, String changeReqTableName) throws Exception {
        String pdServiceId = changeReqTableName.replace("T_ARMS_REQADD_", "");
        PdServiceEntity \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4 = this.\uc81c\ud488\ub370\uc774\ud130\uc870\ud68c(pdServiceId);
        ReqStatusDTO searchDTO = new ReqStatusDTO();
        searchDTO.setC_req_link(reqAddEntity.getC_id());
        ResponseEntity \uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc\ubaa9\ub85d = this.internalService.REQSTATUS_CID_\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\uc870\ud68c("T_ARMS_REQSTATUS_" + pdServiceId, searchDTO);
        List reqStatusEntityList = (List)\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc\ubaa9\ub85d.getBody();
        for (ReqStatusEntity reqStatusEntity : reqStatusEntityList) {
            if (reqAddEntity.getReqStateEntity() != null) {
                reqStatusEntity.setC_req_state_name(reqAddEntity.getReqStateEntity().getC_title());
                reqStatusEntity.setC_req_state_link(reqAddEntity.getReqStateEntity().getC_id());
            }
            if (reqAddEntity.getReqPriorityEntity() != null) {
                reqStatusEntity.setC_req_priority_name(reqAddEntity.getReqPriorityEntity().getC_title());
                reqStatusEntity.setC_req_priority_link(reqAddEntity.getReqPriorityEntity().getC_id());
            }
            if (reqAddEntity.getReqDifficultyEntity() != null) {
                reqStatusEntity.setC_req_difficulty_name(reqAddEntity.getReqDifficultyEntity().getC_title());
                reqStatusEntity.setC_req_difficulty_link(reqAddEntity.getReqDifficultyEntity().getC_id());
            }
            ModelMapper modelMapper = new ModelMapper();
            ReqStatusDTO reqStatusDTO = (ReqStatusDTO)modelMapper.map((Object)reqStatusEntity, ReqStatusDTO.class);
            ResponseEntity \uacb0\uacfc = this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc218\uc815\ud558\uae30("T_ARMS_REQSTATUS_" + \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_id(), reqStatusDTO);
            if (!\uacb0\uacfc.getStatusCode().is2xxSuccessful()) {
                log.error("T_ARMS_REQSTATUS_{} :: \uc0ad\uc81c \uc624\ub958 :: {}", (Object)\uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_id(), (Object)reqStatusDTO.toString());
            }
            if (reqAddEntity.getReqStateEntity() == null) continue;
            this.reqStatus.ALM_\uc774\uc288\uc0c1\ud0dc_\uc5c5\ub370\uc774\ud2b8(reqStatusEntity);
        }
    }

    public List<\uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790> getRequirementAssignee(RequirementDTO requirementDTO) {
        ArrayList<\uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790> \uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790_\ubaa9\ub85d = new ArrayList<\uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790>();
        PdServiceAndIsReqDTO pdServiceAndIsReq = requirementDTO.getPdServiceAndIsReq();
        pdServiceAndIsReq.setIsReq(Boolean.valueOf(true));
        \uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790_\ubaa9\ub85d.addAll(this.\uc9d1\uacc4\ub370\uc774\ud130_\uac00\uc838\uc624\uae30(requirementDTO));
        pdServiceAndIsReq.setIsReq(Boolean.valueOf(false));
        \uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790_\ubaa9\ub85d.addAll(this.\uc9d1\uacc4\ub370\uc774\ud130_\uac00\uc838\uc624\uae30(requirementDTO));
        return \uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790_\ubaa9\ub85d;
    }

    private List<\uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790> \uc9d1\uacc4\ub370\uc774\ud130_\uac00\uc838\uc624\uae30(RequirementDTO requirementDTO) {
        return Optional.ofNullable((List)this.engineService.\uc81c\ud488_\uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790(requirementDTO).getBody()).orElseGet(Collections::emptyList).stream().map(\uc694\uad6c\uc0ac\ud56d_\ub2f4\ub2f9\uc790::fromRequirementVO).collect(Collectors.toList());
    }

    public void \uc694\uad6c\uc0ac\ud56d_\uc0dd\uc131_\uc774\ud6c4_\uc0c1\ud0dc\uc815\ubcf4_\ucc98\ub9ac_\ud504\ub85c\uc138\uc2a4(ReqAddEntity savedReqAddEntity) throws Exception {
        Long \uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514 = savedReqAddEntity.getC_id();
        PdServiceEntity \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4 = savedReqAddEntity.getPdServiceEntity();
        Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_id();
        ObjectMapper objectMapper = new ObjectMapper();
        String \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804\ubaa9\ub85d_JSON = savedReqAddEntity.getC_req_pdservice_versionset_link();
        List<String> \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804\ubaa9\ub85d = Arrays.asList((String[])objectMapper.readValue(\uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804\ubaa9\ub85d_JSON, String[].class));
        HashSet<Long> \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\uc14b = new HashSet<Long>();
        for (String \ub514\ube44\uc5d0\uc800\uc7a5\ub41c_\uc81c\ud488\uc11c\ube44\uc2a4\ud558\uc704_\ubc84\uc804 : \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804\ubaa9\ub85d) {
            GlobalTreeMapEntity globalTreeMap = new GlobalTreeMapEntity();
            globalTreeMap.setPdserviceversion_link(Long.valueOf(Long.parseLong(\ub514\ube44\uc5d0\uc800\uc7a5\ub41c_\uc81c\ud488\uc11c\ube44\uc2a4\ud558\uc704_\ubc84\uc804)));
            List \ubc84\uc804_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = this.globalTreeMapService.findAllBy(globalTreeMap).stream().filter(\uc5d4\ud2f0\ud2f0 -> \uc5d4\ud2f0\ud2f0.getJiraproject_link() != null).collect(Collectors.toList());
            for (GlobalTreeMapEntity \uc5d4\ud2f0\ud2f02 : \ubc84\uc804_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d) {
                Long \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514 = \uc5d4\ud2f0\ud2f02.getJiraproject_link();
                \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\uc14b.add(\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514);
            }
        }
        this.\uc5f0\uacb0\ub41c_\ubc84\uc804\uc758_\ud504\ub85c\uc81d\ud2b8\ubcc4_REQSTATUS_\ub370\uc774\ud130\ucd94\uac00(savedReqAddEntity, \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\uc14b, \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4);
        ReqStatusDTO reqStatusDTO = new ReqStatusDTO();
        reqStatusDTO.setC_req_link(\uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514);
        this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc_\ud655\uc778\ud6c4_ALM\ucc98\ub9ac_\ubc0f_REQSTATUS_\uc5c5\ub370\uc774\ud2b8("T_ARMS_REQSTATUS_" + \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, reqStatusDTO);
    }

    public void \uc5f0\uacb0\ub41c_\ubc84\uc804\uc758_\ud504\ub85c\uc81d\ud2b8\ubcc4_REQSTATUS_\ub370\uc774\ud130\ucd94\uac00(ReqAddEntity savedReqAddEntity, Set<Long> \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\uc14b, PdServiceEntity \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4) throws Exception {
        Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_id();
        for (Long ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514 : \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\uc14b) {
            ReqStatusDTO reqStatusDTO = this.REQSTATUS_\ub370\uc774\ud130_\uc124\uc815(ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, savedReqAddEntity, \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4, CRUDType.\uc0dd\uc131.getType());
            ResponseEntity \uacb0\uacfc = this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc_\uc815\ubcf4_\uc800\uc7a5\ud558\uae30("T_ARMS_REQSTATUS_" + \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, reqStatusDTO);
            if (\uacb0\uacfc.getStatusCode().is2xxSuccessful()) continue;
            log.error("T_ARMS_REQSTATUS_{} :: \uc0dd\uc131 \uc624\ub958 :: {}", (Object)\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, (Object)reqStatusDTO.toString());
        }
    }

    public void \uc694\uad6c\uc0ac\ud56d_\uc218\uc815_\uc774\ud6c4_\uc0c1\ud0dc\uc815\ubcf4_\ucc98\ub9ac_\ud504\ub85c\uc138\uc2a4(String changeReqTableName, ReqAddEntity reqAddEntity, ReqAddVO reqAddVO) throws Exception {
        String pdServiceId = changeReqTableName.replace("T_ARMS_REQADD_", "");
        ObjectMapper objectMapper = new ObjectMapper();
        Set \uc218\uc815\uc804\ubc84\uc804\uc14b = (Set)objectMapper.readValue(reqAddVO.getC_req_pdservice_versionset_link(), Set.class);
        Set \ud604\uc7ac\ubc84\uc804\uc14b = (Set)objectMapper.readValue(reqAddEntity.getC_req_pdservice_versionset_link(), Set.class);
        Set \ub8e8\ud504\uc6a9\ubc84\uc804\uc14b = (Set)objectMapper.readValue(reqAddVO.getC_req_pdservice_versionset_link(), Set.class);
        \ub8e8\ud504\uc6a9\ubc84\uc804\uc14b.addAll(\ud604\uc7ac\ubc84\uc804\uc14b);
        List \uc218\uc815\uc804\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8 = \uc218\uc815\uc804\ubc84\uc804\uc14b.stream().map(Long::valueOf).collect(Collectors.toList());
        List \ud604\uc7ac\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8 = \ud604\uc7ac\ubc84\uc804\uc14b.stream().map(Long::valueOf).collect(Collectors.toList());
        List \ub8e8\ud504\uc6a9\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8 = \ub8e8\ud504\uc6a9\ubc84\uc804\uc14b.stream().map(Long::valueOf).collect(Collectors.toList());
        log.info("\uc218\uc815\uc804\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8 : {}", \uc218\uc815\uc804\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8);
        log.info("\ud604\uc7ac\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8 : {}", \ud604\uc7ac\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8);
        log.info("\ub8e8\ud504\uc6a9\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8 : {}", \ub8e8\ud504\uc6a9\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8);
        List globalTreeMapEntities = this.globalTreeMapService.findAllByIds(\ub8e8\ud504\uc6a9\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8, "pdserviceversion_link").stream().filter(globalTreeMap -> globalTreeMap.getJiraproject_link() != null).collect(Collectors.toList());
        Set \uc218\uc815\uc804\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 = globalTreeMapEntities.stream().filter(globalTreeMap -> \uc218\uc815\uc804\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8.contains(globalTreeMap.getPdserviceversion_link())).map(GlobalTreeMapEntity::getJiraproject_link).collect(Collectors.toSet());
        log.info("\uc218\uc815\uc804\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 : {}", \uc218\uc815\uc804\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514);
        Set \ud604\uc7ac\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 = globalTreeMapEntities.stream().filter(globalTreeMap -> \ud604\uc7ac\ubc84\uc804\uc14b\ub9ac\uc2a4\ud2b8.contains(globalTreeMap.getPdserviceversion_link())).map(GlobalTreeMapEntity::getJiraproject_link).collect(Collectors.toSet());
        log.info("\ud604\uc7ac\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 : {}", \ud604\uc7ac\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514);
        Set \ucd94\uac00\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 = this.\ucd94\uac00\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\ucc3e\uae30(\uc218\uc815\uc804\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514, \ud604\uc7ac\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514);
        Set \uc720\uc9c0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 = this.\uc720\uc9c0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\ucc3e\uae30(\uc218\uc815\uc804\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514, \ud604\uc7ac\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514);
        Set \uc0ad\uc81c\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 = this.\uc0ad\uc81c\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\ucc3e\uae30(\uc218\uc815\uc804\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514, \ud604\uc7ac\ubc84\uc804\uc5d0\uc5f0\uacb0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514);
        log.info("\uc720\uc9c0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 : {}", (Object)\uc720\uc9c0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514);
        log.info("\ucd94\uac00\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 : {}", (Object)\ucd94\uac00\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514);
        log.info("\uc0ad\uc81c\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514 : {}", (Object)\uc0ad\uc81c\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514);
        PdServiceEntity \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4 = this.\uc81c\ud488\ub370\uc774\ud130\uc870\ud68c(pdServiceId);
        Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_id();
        ReqStatusDTO reqStatusDTO = new ReqStatusDTO();
        reqStatusDTO.setC_req_link(reqAddEntity.getC_id());
        ResponseEntity \uacb0\uacfc = this.internalService.REQSTATUS_CID_\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\uc870\ud68c("T_ARMS_REQSTATUS_" + pdServiceId, reqStatusDTO);
        List reqStatusEntityList = (List)\uacb0\uacfc.getBody();
        List \uc720\uc9c0\ub41c_REQSTATUS_\ubaa9\ub85d = Optional.ofNullable(reqStatusEntityList).orElse(Collections.emptyList()).stream().filter(reqStatusEntity -> \uc720\uc9c0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514.contains(reqStatusEntity.getC_jira_project_link())).filter(reqStatusEntity -> reqStatusEntity.getC_issue_delete_date() == null).collect(Collectors.toList());
        List \uc0ad\uc81c\ub41c_REQSTATUS_\ubaa9\ub85d = Optional.ofNullable(reqStatusEntityList).orElse(Collections.emptyList()).stream().filter(reqStatusEntity -> \uc0ad\uc81c\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514.contains(reqStatusEntity.getC_jira_project_link())).filter(reqStatusEntity -> reqStatusEntity.getC_issue_delete_date() == null).collect(Collectors.toList());
        this.\uc5f0\uacb0\ub41c_\ubc84\uc804\uc758_\ud504\ub85c\uc81d\ud2b8\ubcc4_REQSTATUS_\ub370\uc774\ud130\ucd94\uac00(reqAddEntity, \ucd94\uac00\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc544\uc774\ub514, \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4);
        this.\uc5f0\uacb0\ub41c_\ubc84\uc804\uc758_\ud504\ub85c\uc81d\ud2b8\ubcc4_REQSTATUS_\ub370\uc774\ud130\uc218\uc815(reqAddEntity, \uc720\uc9c0\ub41c_REQSTATUS_\ubaa9\ub85d, \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4, CRUDType.\uc218\uc815.getType());
        this.\uc5f0\uacb0\ub41c_\ubc84\uc804\uc758_\ud504\ub85c\uc81d\ud2b8\ubcc4_REQSTATUS_\ub370\uc774\ud130\uc218\uc815(reqAddEntity, \uc0ad\uc81c\ub41c_REQSTATUS_\ubaa9\ub85d, \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4, CRUDType.\uc218\uc815.getType());
        this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc_\ud655\uc778\ud6c4_ALM\ucc98\ub9ac_\ubc0f_REQSTATUS_\uc5c5\ub370\uc774\ud2b8("T_ARMS_REQSTATUS_" + \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, reqStatusDTO);
    }

    public void \uc694\uad6c\uc0ac\ud56d_\uc0ad\uc81c_\uc774\ud6c4_\uc0c1\ud0dc\uc815\ubcf4_\ucc98\ub9ac_\ud504\ub85c\uc138\uc2a4(String changeReqTableName, ReqAddEntity reqAddEntity, ReqAddVO reqAddVO) throws Exception {
        reqAddEntity.setC_req_pdservice_versionset_link(reqAddVO.getC_req_pdservice_versionset_link());
        reqAddEntity.setC_title(reqAddVO.getC_title());
        reqAddEntity.setC_req_contents(reqAddVO.getC_req_contents());
        String pdServiceId = changeReqTableName.replace("T_ARMS_REQADD_", "");
        PdServiceEntity \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4 = this.\uc81c\ud488\ub370\uc774\ud130\uc870\ud68c(pdServiceId);
        Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_id();
        ReqStatusDTO reqStatusDTO = new ReqStatusDTO();
        reqStatusDTO.setC_req_link(reqAddVO.getC_id());
        String deleteType = StringUtils.isEmpty((String)this.armsDetailUrlConfig.getDeleteType()) ? CRUDType.\uc18c\ud504\ud2b8_\uc0ad\uc81c.getType() : this.armsDetailUrlConfig.getDeleteType();
        ResponseEntity \uacb0\uacfc = this.internalService.REQSTATUS_CID_\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\uc870\ud68c("T_ARMS_REQSTATUS_" + pdServiceId, reqStatusDTO);
        List reqStatusEntityList = (List)\uacb0\uacfc.getBody();
        this.\uc5f0\uacb0\ub41c_\ubc84\uc804\uc758_\ud504\ub85c\uc81d\ud2b8\ubcc4_REQSTATUS_\ub370\uc774\ud130\uc218\uc815(reqAddEntity, reqStatusEntityList, \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4, deleteType);
        this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc_\ud655\uc778\ud6c4_ALM\ucc98\ub9ac_\ubc0f_REQSTATUS_\uc5c5\ub370\uc774\ud2b8("T_ARMS_REQSTATUS_" + \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, reqStatusDTO);
    }

    public void \uc5f0\uacb0\ub41c_\ubc84\uc804\uc758_\ud504\ub85c\uc81d\ud2b8\ubcc4_REQSTATUS_\ub370\uc774\ud130\uc218\uc815(ReqAddEntity reqAddEntity, List<ReqStatusEntity> reqStatusEntityList, PdServiceEntity \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4, String CRUD_\ud0c0\uc785) throws Exception {
        for (ReqStatusEntity reqStatusEntity : reqStatusEntityList) {
            ResponseEntity \uacb0\uacfc;
            Long ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514 = reqStatusEntity.getC_jira_project_link();
            ReqStatusDTO reqStatusDTO = this.REQSTATUS_\ub370\uc774\ud130_\uc124\uc815(ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, reqAddEntity, \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4, CRUD_\ud0c0\uc785);
            reqStatusDTO.setC_id(reqStatusEntity.getC_id());
            if ((StringUtils.equals((String)CRUD_\ud0c0\uc785, (String)CRUDType.\ud558\ub4dc_\uc0ad\uc81c.getType()) || StringUtils.equals((String)CRUD_\ud0c0\uc785, (String)CRUDType.\uc18c\ud504\ud2b8_\uc0ad\uc81c.getType())) && reqStatusEntity.getC_issue_key() == null) {
                reqStatusDTO.setC_etc(CRUD_\ud0c0\uc785);
            } else if (reqStatusEntity.getC_issue_key() == null) {
                reqStatusDTO.setC_etc(CRUDType.\uc0dd\uc131.getType());
            } else {
                reqStatusDTO.setC_etc(CRUD_\ud0c0\uc785);
            }
            if ((\uacb0\uacfc = this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc218\uc815\ud558\uae30("T_ARMS_REQSTATUS_" + \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_id(), reqStatusDTO)).getStatusCode().is2xxSuccessful()) continue;
            log.error("T_ARMS_REQSTATUS_{} :: \uc0ad\uc81c \uc624\ub958 :: {}", (Object)\uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_id(), (Object)reqStatusDTO.toString());
        }
    }

    private ReqStatusDTO REQSTATUS_\ub370\uc774\ud130_\uc124\uc815(Long ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, ReqAddEntity savedReqAddEntity, PdServiceEntity \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4, String CRUD_\ud0c0\uc785) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        Long \uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514 = savedReqAddEntity.getC_id();
        String \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804\ubaa9\ub85d_JSON = savedReqAddEntity.getC_req_pdservice_versionset_link();
        List<String> \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804\ubaa9\ub85d = Arrays.asList((String[])objectMapper.readValue(\uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804\ubaa9\ub85d_JSON, String[].class));
        Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_id();
        Set \uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804_\uc138\ud2b8 = \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getPdServiceVersionEntities();
        Map<Long, String> \uc81c\ud488_\ubc84\uc804\uc544\uc774\ub514_\ubc84\uc804\uba85_\ub9f5 = \uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804_\uc138\ud2b8.stream().collect(Collectors.toMap(PdServiceVersionEntity::getC_id, TreeBaseEntity::getC_title));
        Map \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubc84\uc804\uc544\uc774\ub514_\ub9f5 = this.\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubc84\uc804\uc544\uc774\ub514_\ub9f5\ub9cc\ub4e4\uae30(\uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804\ubaa9\ub85d);
        Set \ubc84\uc804\uc544\uc774\ub514_\uc138\ud2b8 = (Set)\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubc84\uc804\uc544\uc774\ub514_\ub9f5.get(ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514);
        GlobalTreeMapEntity globalTreeMap = new GlobalTreeMapEntity();
        globalTreeMap.setJiraproject_link(ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514);
        List \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc5d0_\uc5f0\uacb0\ub41c\uc815\ubcf4\ub4e4 = this.globalTreeMapService.findAllBy(globalTreeMap);
        GlobalTreeMapEntity \uc9c0\ub77c\uc11c\ubc84_\uae00\ub85c\ubc8c\ud2b8\ub9ac\ub9f5 = \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\uc5d0_\uc5f0\uacb0\ub41c\uc815\ubcf4\ub4e4.stream().filter(\uae00\ub85c\ubc8c\ud2b8\ub9ac\ub9f5 -> \uae00\ub85c\ubc8c\ud2b8\ub9ac\ub9f5.getJiraserver_link() != null).findFirst().orElse(null);
        Long ALM\uc11c\ubc84_\uc544\uc774\ub514 = null;
        if (\uc9c0\ub77c\uc11c\ubc84_\uae00\ub85c\ubc8c\ud2b8\ub9ac\ub9f5 != null) {
            ALM\uc11c\ubc84_\uc544\uc774\ub514 = \uc9c0\ub77c\uc11c\ubc84_\uae00\ub85c\ubc8c\ud2b8\ub9ac\ub9f5.getJiraserver_link();
        }
        ReqStatusDTO reqStatusDTO = new ReqStatusDTO();
        if (StringUtils.equals((String)CRUD_\ud0c0\uc785, (String)CRUDType.\uc0dd\uc131.getType())) {
            reqStatusDTO.setRef(TreeConstant.First_Node_CID.longValue());
            reqStatusDTO.setC_type("default");
        }
        List \ubc84\uc804\uc544\uc774\ub514_\ub0b4\ub9bc\ucc28\uc21c_\ubaa9\ub85d = null;
        String \ubc84\uc804\uc544\uc774\ub514_\ub0b4\ub9bc\ucc28\uc21c_\ubb38\uc790\uc5f4 = null;
        String \ubc84\uc804\uba85_\ub0b4\ub9bc\ucc28\uc21c_\ubb38\uc790\uc5f4 = null;
        String \ubc84\uc804ID\ubaa9\ub85d = null;
        if (\ubc84\uc804\uc544\uc774\ub514_\uc138\ud2b8 != null) {
            \ubc84\uc804\uc544\uc774\ub514_\ub0b4\ub9bc\ucc28\uc21c_\ubaa9\ub85d = \ubc84\uc804\uc544\uc774\ub514_\uc138\ud2b8.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            \ubc84\uc804\uc544\uc774\ub514_\ub0b4\ub9bc\ucc28\uc21c_\ubb38\uc790\uc5f4 = \ubc84\uc804\uc544\uc774\ub514_\ub0b4\ub9bc\ucc28\uc21c_\ubaa9\ub85d.stream().map(String::valueOf).collect(Collectors.joining("\",\"", "[\"", "\"]"));
            \ubc84\uc804\uba85_\ub0b4\ub9bc\ucc28\uc21c_\ubb38\uc790\uc5f4 = \ubc84\uc804\uc544\uc774\ub514_\ub0b4\ub9bc\ucc28\uc21c_\ubaa9\ub85d.stream().map(\uc81c\ud488_\ubc84\uc804\uc544\uc774\ub514_\ubc84\uc804\uba85_\ub9f5::get).collect(Collectors.joining("\",\"", "[\"", "\"]"));
            \ubc84\uc804ID\ubaa9\ub85d = \ubc84\uc804\uc544\uc774\ub514_\ub0b4\ub9bc\ucc28\uc21c_\ubaa9\ub85d.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        reqStatusDTO.setC_pds_version_name(\ubc84\uc804\uba85_\ub0b4\ub9bc\ucc28\uc21c_\ubb38\uc790\uc5f4);
        reqStatusDTO.setC_req_pdservice_versionset_link(\ubc84\uc804\uc544\uc774\ub514_\ub0b4\ub9bc\ucc28\uc21c_\ubb38\uc790\uc5f4);
        JiraProjectEntity \uac80\uc0c9\ub41c_ALM\ud504\ub85c\uc81d\ud2b8 = this.ALM\ud504\ub85c\uc81d\ud2b8_\uac80\uc0c9(ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514);
        Optional.ofNullable(\uac80\uc0c9\ub41c_ALM\ud504\ub85c\uc81d\ud2b8).ifPresent(\ud504\ub85c\uc81d\ud2b82 -> {
            Optional.ofNullable(\ud504\ub85c\uc81d\ud2b82.getC_id()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_jira_project_link(arg_0));
            Optional.ofNullable(\ud504\ub85c\uc81d\ud2b82.getC_jira_name()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_jira_project_name(arg_0));
            Optional.ofNullable(\ud504\ub85c\uc81d\ud2b82.getC_jira_key()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_jira_project_key(arg_0));
            Optional.ofNullable(\ud504\ub85c\uc81d\ud2b82.getC_jira_url()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_jira_project_url(arg_0));
        });
        JiraServerEntity \uac80\uc0c9\ub41c_ALM\uc11c\ubc84 = this.ALM\uc11c\ubc84_\uac80\uc0c9(ALM\uc11c\ubc84_\uc544\uc774\ub514);
        Optional.ofNullable(\uac80\uc0c9\ub41c_ALM\uc11c\ubc84).ifPresent(ALM\uc11c\ubc84 -> {
            Optional.ofNullable(ALM\uc11c\ubc84.getC_id()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_jira_server_link(arg_0));
            Optional.ofNullable(ALM\uc11c\ubc84.getC_jira_server_name()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_jira_server_name(arg_0));
            Optional.ofNullable(ALM\uc11c\ubc84.getC_jira_server_base_url()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_jira_server_url(arg_0));
        });
        String \uc694\uad6c\uc0ac\ud56d_\uc81c\ubaa9 = savedReqAddEntity.getC_title();
        reqStatusDTO.setC_title(\uc694\uad6c\uc0ac\ud56d_\uc81c\ubaa9);
        TextFormattingType \ubcf8\ubb38\ud615\uc2dd = Optional.ofNullable(\uac80\uc0c9\ub41c_ALM\uc11c\ubc84).map(JiraServerEntity::getC_server_contents_text_formatting_type).map(TextFormattingType::fromString).orElse(TextFormattingType.TEXT);
        String \uc774\uc288\ubcf8\ubb38 = this.\uc774\uc288_\ubcf8\ubb38_\uc124\uc815(\ubcf8\ubb38\ud615\uc2dd, CRUD_\ud0c0\uc785, savedReqAddEntity, \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, ALM\uc11c\ubc84_\uc544\uc774\ub514, ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, \ubc84\uc804ID\ubaa9\ub85d);
        reqStatusDTO.setC_contents(\uc774\uc288\ubcf8\ubb38);
        reqStatusDTO.setC_pdservice_link(\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514);
        reqStatusDTO.setC_pdservice_name(\uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_title());
        reqStatusDTO.setC_req_link(\uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514);
        reqStatusDTO.setC_req_name(savedReqAddEntity.getC_title());
        String \uc694\uad6c\uc0ac\ud56d_\uc624\ub108 = "admin";
        if (\uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_pdservice_owner() != null) {
            \uc694\uad6c\uc0ac\ud56d_\uc624\ub108 = \uc694\uad6c\uc0ac\ud56d_\uc81c\ud488\uc11c\ube44\uc2a4.getC_pdservice_owner();
        }
        reqStatusDTO.setC_req_owner(\uc694\uad6c\uc0ac\ud56d_\uc624\ub108);
        Optional.ofNullable(savedReqAddEntity.getC_req_writer()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_issue_reporter(arg_0));
        Optional.ofNullable(savedReqAddEntity.getC_req_start_date()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_start_date(arg_0));
        Optional.ofNullable(savedReqAddEntity.getC_req_end_date()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_end_date(arg_0));
        Optional.ofNullable(savedReqAddEntity.getReqPriorityEntity()).ifPresent(reqPriority -> {
            Optional.ofNullable(reqPriority.getC_id()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_priority_link(arg_0));
            Optional.ofNullable(reqPriority.getC_title()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_priority_name(arg_0));
        });
        Optional.ofNullable(savedReqAddEntity.getReqStateEntity()).ifPresent(reqState -> {
            Optional.ofNullable(reqState.getC_id()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_state_link(arg_0));
            Optional.ofNullable(reqState.getC_title()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_state_name(arg_0));
        });
        Optional.ofNullable(savedReqAddEntity.getReqDifficultyEntity()).ifPresent(reqDifficulty -> {
            Optional.ofNullable(reqDifficulty.getC_id()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_difficulty_link(arg_0));
            Optional.ofNullable(reqDifficulty.getC_title()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_difficulty_name(arg_0));
        });
        Optional.ofNullable(savedReqAddEntity.getC_req_total_resource()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_total_resource(arg_0));
        Optional.ofNullable(savedReqAddEntity.getC_req_plan_resource()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_plan_resource(arg_0));
        Optional.ofNullable(savedReqAddEntity.getC_req_total_time()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_total_time(arg_0));
        Optional.ofNullable(savedReqAddEntity.getC_req_plan_time()).ifPresent(arg_0 -> ((ReqStatusDTO)reqStatusDTO).setC_req_plan_time(arg_0));
        Date date = new Date();
        reqStatusDTO.setC_issue_update_date(date);
        if (StringUtils.equals((String)CRUD_\ud0c0\uc785, (String)CRUDType.\uc0dd\uc131.getType())) {
            reqStatusDTO.setC_issue_create_date(date);
        } else if (StringUtils.equals((String)CRUD_\ud0c0\uc785, (String)CRUDType.\ud558\ub4dc_\uc0ad\uc81c.getType()) || StringUtils.equals((String)CRUD_\ud0c0\uc785, (String)CRUDType.\uc18c\ud504\ud2b8_\uc0ad\uc81c.getType())) {
            reqStatusDTO.setC_issue_delete_date(date);
        }
        if (StringUtils.equals((String)CRUD_\ud0c0\uc785, (String)CRUDType.\uc0dd\uc131.getType())) {
            reqStatusDTO.setC_etc(CRUD_\ud0c0\uc785);
        }
        log.info("ReqStatusImpl = reqStatusDTO :: {}", (Object)objectMapper.writeValueAsString((Object)reqStatusDTO));
        return reqStatusDTO;
    }

    private Map<Long, Set<Long>> \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubc84\uc804\uc544\uc774\ub514_\ub9f5\ub9cc\ub4e4\uae30(List<String> \ub514\ube44\uc5d0\uc800\uc7a5\ub41c_\uc81c\ud488\uc11c\ube44\uc2a4_\ud558\uc704\uc758_\ubc84\uc804\ub9ac\uc2a4\ud2b8) {
        HashMap<Long, Set<Long>> \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubc84\uc804\uc544\uc774\ub514_\ub9f5 = new HashMap<Long, Set<Long>>();
        for (String \ub514\ube44\uc5d0\uc800\uc7a5\ub41c_\uc81c\ud488\uc11c\ube44\uc2a4\ud558\uc704_\ubc84\uc804 : \ub514\ube44\uc5d0\uc800\uc7a5\ub41c_\uc81c\ud488\uc11c\ube44\uc2a4_\ud558\uc704\uc758_\ubc84\uc804\ub9ac\uc2a4\ud2b8) {
            GlobalTreeMapEntity globalTreeMap = new GlobalTreeMapEntity();
            globalTreeMap.setPdserviceversion_link(Long.valueOf(Long.parseLong(\ub514\ube44\uc5d0\uc800\uc7a5\ub41c_\uc81c\ud488\uc11c\ube44\uc2a4\ud558\uc704_\ubc84\uc804)));
            List \ubc84\uc804_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = this.globalTreeMapService.findAllBy(globalTreeMap).stream().filter(\uc5d4\ud2f0\ud2f0 -> \uc5d4\ud2f0\ud2f0.getJiraproject_link() != null).collect(Collectors.toList());
            for (GlobalTreeMapEntity \uc5d4\ud2f0\ud2f02 : \ubc84\uc804_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d) {
                Long ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514 = \uc5d4\ud2f0\ud2f02.getJiraproject_link();
                Long \ubc84\uc804_\uc544\uc774\ub514 = \uc5d4\ud2f0\ud2f02.getPdserviceversion_link();
                if (\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubc84\uc804\uc544\uc774\ub514_\ub9f5.containsKey(ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514)) {
                    ((Set)\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubc84\uc804\uc544\uc774\ub514_\ub9f5.get(ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514)).add(\ubc84\uc804_\uc544\uc774\ub514);
                    continue;
                }
                HashSet<Long> \ubc84\uc804_\uc14b = new HashSet<Long>();
                \ubc84\uc804_\uc14b.add(\ubc84\uc804_\uc544\uc774\ub514);
                \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubc84\uc804\uc544\uc774\ub514_\ub9f5.put(ALM\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, \ubc84\uc804_\uc14b);
            }
        }
        return \uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubc84\uc804\uc544\uc774\ub514_\ub9f5;
    }

    public JiraProjectEntity ALM\ud504\ub85c\uc81d\ud2b8_\uac80\uc0c9(Long ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514) {
        if (ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514 == null) {
            return null;
        }
        JiraProjectEntity jiraProjectEntity = null;
        try {
            jiraProjectEntity = (JiraProjectEntity)TreeServiceUtils.getNode((TreeService)this.jiraProject, (Long)ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, JiraProjectEntity.class);
            boolean isSoftDelete = Optional.ofNullable(jiraProjectEntity).map(JiraProjectEntity::getC_etc).map("delete"::equals).orElse(false);
            if (isSoftDelete) {
                jiraProjectEntity = null;
            }
        }
        catch (Exception e) {
            log.error("ALM\ud504\ub85c\uc81d\ud2b8_\uac80\uc0c9 :: \ud504\ub85c\uc81d\ud2b8 \uc544\uc774\ub514 :: {} :: {}", (Object)ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, (Object)e.getMessage());
        }
        return jiraProjectEntity;
    }

    public JiraServerEntity ALM\uc11c\ubc84_\uac80\uc0c9(Long ALM\uc11c\ubc84_\uc544\uc774\ub514) {
        if (ALM\uc11c\ubc84_\uc544\uc774\ub514 == null) {
            return null;
        }
        JiraServerEntity jiraServerEntity = null;
        try {
            jiraServerEntity = (JiraServerEntity)TreeServiceUtils.getNode((TreeService)this.jiraServer, (Long)ALM\uc11c\ubc84_\uc544\uc774\ub514, JiraServerEntity.class);
        }
        catch (Exception e) {
            log.error("ALM\uc11c\ubc84_\uac80\uc0c9 :: \uc11c\ubc84 \uc544\uc774\ub514 :: {} :: {}", (Object)ALM\uc11c\ubc84_\uc544\uc774\ub514, (Object)e.getMessage());
        }
        return jiraServerEntity;
    }

    private String \uc774\uc288_\ubcf8\ubb38_\uc124\uc815(TextFormattingType \ubcf8\ubb38\ud615\uc2dd, String CRUD_\ud0c0\uc785, ReqAddEntity reqAddEntity, Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, Long ALM\uc11c\ubc84_\uc544\uc774\ub514, Long ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, String \ubc84\uc804\uc544\uc774\ub514\ubaa9\ub85d) {
        Object \uc774\uc288_\ubcf8\ubb38_\uc804\uccb4 = StringUtils.equals((String)CRUD_\ud0c0\uc785, (String)CRUDType.\uc18c\ud504\ud2b8_\uc0ad\uc81c.getType()) || StringUtils.equals((String)CRUD_\ud0c0\uc785, (String)CRUDType.\ud558\ub4dc_\uc0ad\uc81c.getType()) ? this.\uc0ad\uc81c_\uc774\uc288_ARMS_\uc548\ub0b4\ubb38\uac00\uc838\uc624\uae30() : this.\ub4f1\ub85d_\ubc0f_\uc218\uc815_ARMS_\uc548\ub0b4\ubb38\uac00\uc838\uc624\uae30(reqAddEntity, \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, ALM\uc11c\ubc84_\uc544\uc774\ub514, ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, \ubc84\uc804\uc544\uc774\ub514\ubaa9\ub85d);
        String ARMS_\uc694\uad6c\uc0ac\ud56d_\uc124\uba85 = Optional.ofNullable(reqAddEntity.getC_req_contents()).orElse("\uc774\uc288 \ubcf8\ubb38 \ub0b4\uc6a9 \ubb34");
        \uc774\uc288_\ubcf8\ubb38_\uc804\uccb4 = \ubcf8\ubb38\ud615\uc2dd == TextFormattingType.MARKDOWN || \ubcf8\ubb38\ud615\uc2dd == TextFormattingType.HTML ? ((String)\uc774\uc288_\ubcf8\ubb38_\uc804\uccb4).replaceAll("\n", "<br>") + ARMS_\uc694\uad6c\uc0ac\ud56d_\uc124\uba85 : (String)\uc774\uc288_\ubcf8\ubb38_\uc804\uccb4 + StringUtils.replaceText((String)StringUtils.removeHtmlTags((String)Jsoup.clean((String)ARMS_\uc694\uad6c\uc0ac\ud56d_\uc124\uba85, (Whitelist)Whitelist.basic())), (String)"&nbsp;", (String)" ");
        return \uc774\uc288_\ubcf8\ubb38_\uc804\uccb4;
    }

    private String \uc0ad\uc81c_\uc774\uc288_ARMS_\uc548\ub0b4\ubb38\uac00\uc838\uc624\uae30() {
        String \uc774\uc288\ub0b4\uc6a9 = "\u2600 \uc8fc\uc758 : \ubcf8 \uc774\uc288\ub294 a-RMS\uc5d0\uc11c \uc81c\uacf5\ud558\ub294 \uc694\uad6c\uc0ac\ud56d \uc774\uc288 \uc785\ub2c8\ub2e4.\n\n\u2714 \ubcf8 \uc774\uc288\ub294 \uc0ad\uc81c \ub41c \uc774\uc288\uc785\ub2c8\ub2e4.,\n\u2714 \uc0ad\uc81c \ub41c \uc774\uc288\ub294 \ud1b5\uacc4\uc5d0 \uc218\uc9d1\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \n\n\n";
        return \uc774\uc288\ub0b4\uc6a9;
    }

    private String \ub4f1\ub85d_\ubc0f_\uc218\uc815_ARMS_\uc548\ub0b4\ubb38\uac00\uc838\uc624\uae30(ReqAddEntity reqAddEntity, Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, Long ALM\uc11c\ubc84_\uc544\uc774\ub514, Long ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514, String \ubc84\uc804\uc544\uc774\ub514\ubaa9\ub85d) {
        JiraServerEntity jiraServerEntity = this.reqStatus.ALM\uc11c\ubc84_\uac80\uc0c9(ALM\uc11c\ubc84_\uc544\uc774\ub514);
        String cJiraServerType = jiraServerEntity.getC_jira_server_type();
        String \ucd94\uac00\ub41c_\uc694\uad6c\uc0ac\ud56d\uc758_\uc544\uc774\ub514 = reqAddEntity.getC_id().toString();
        String \ubc84\uc804\uc544\uc774\ub514\ubaa9\ub85d_\ud30c\uc2f1 = \ubc84\uc804\uc544\uc774\ub514\ubaa9\ub85d.replaceAll("\\[|\\]|\"", "").replaceAll(",", ",");
        String \uc2dc\uc791\uc77c = Optional.ofNullable(reqAddEntity.getC_req_start_date()).map(date -> DateUtils.format((String)"yyyy-MM-dd", (Date)date)).orElse("\uc2dc\uc791\uc77c \ub370\uc774\ud130\ub97c \ud655\uc778\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ubc84\uc804\uc758 \uc2dc\uc791\uc77c \ud655\uc778\uc774 \ud544\uc694\ud569\ub2c8\ub2e4");
        String \uc885\ub8cc\uc77c = Optional.ofNullable(reqAddEntity.getC_req_end_date()).map(date -> DateUtils.format((String)"yyyy-MM-dd", (Date)date)).orElse("\uc885\ub8cc\uc77c \ub370\uc774\ud130\ub97c \ud655\uc778\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ubc84\uc804\uc758 \uc885\ub8cc\uc77c \ud655\uc778\uc774 \ud544\uc694\ud569\ub2c8\ub2e4");
        String ALM\uc11c\ubc84_\uc544\uc774\ub514_\uae00\uc790 = Optional.ofNullable(ALM\uc11c\ubc84_\uc544\uc774\ub514).map(Object::toString).orElse("");
        String ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\uae00\uc790 = Optional.ofNullable(ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514).map(Object::toString).orElse("");
        String \uc774\uc288\ub0b4\uc6a9 = "\u2600 \uc8fc\uc758 : \ubcf8 \uc774\uc288\ub294 A-RMS\uc5d0\uc11c \uc81c\uacf5\ud558\ub294 \uc694\uad6c\uc0ac\ud56d \uc774\uc288 \uc785\ub2c8\ub2e4.\n\n\u2714 \ubcf8 \uc774\uc288\ub294 \uc790\ub3d9\uc73c\ub85c \uad00\ub9ac\ub418\ubbc0\ub85c,\n\u2714 \uc774\uc288\ub97c \uac15\uc81c\ub85c \uc0ad\uc81c\uc2dc \u2192 \uc5f0\uacb0\ub41c \uc774\uc288 \uc218\uc9d1\uc774 \ub418\uc9c0 \uc54a\uc73c\ubbc0\ub85c\n\u2714 \ud604\ud669 \ud1b5\uacc4\uc5d0\uc11c \ubc30\uc81c\ub418\uc5b4 \ubd88\uc774\uc775\uc744 \ubc1b\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.\n\u2714 \uc544\ub798 \ub9c1\ud06c\uc5d0\uc11c \uc694\uad6c\uc0ac\ud56d\uc744 \ub0b4\uc6a9\uc744 \ud655\uc778 \ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.\n\n\u203b \ubcf8 \uc774\uc288 \ud558\uc704\ub85c Sub-Task\ub97c \ub9cc\ub4e4\uc5b4\uc11c \uac1c\ubc1c(\uc5c5\ubb34)\uc744 \uc9c4\ud589 \ud558\uc2dc\uac70\ub098, \n\u203b \uad00\ub828\ud55c \uc774\uc288\ub97c \uc5f0\uacb0 (LINK) \ud558\uc2dc\uba74, \ud604\ud669 \ud1b5\uacc4\uc5d0 \uc790\ub3d9\uc73c\ub85c \uc218\uc9d1\ub429\ub2c8\ub2e4.\n(\ub2e8, \uc694\uad6c\uc0ac\ud56d \uc774\uc288(A-RMS\uc5d0\uc11c \uc81c\uacf5\ud55c \uc774\uc288)\uac04 \uc5f0\uacb0(LINK)\uc740 \ud1b5\uacc4\uc5d0\uc11c \ubc30\uc81c\ub418\uc5b4 \uad8c\uc7a5\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.)\n\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\n\uc790\uc138\ud55c \uc694\uad6c\uc0ac\ud56d \ub0b4\uc6a9 \ud655\uc778 \u21d2 " + this.armsDetailUrlConfig.getAddress() + "/arms/detail.html?page=detail&pdService=" + \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 + "&pdServiceVersion=" + \ubc84\uc804\uc544\uc774\ub514\ubaa9\ub85d_\ud30c\uc2f1 + "&reqAdd=" + \ucd94\uac00\ub41c_\uc694\uad6c\uc0ac\ud56d\uc758_\uc544\uc774\ub514 + "&jiraServer=" + ALM\uc11c\ubc84_\uc544\uc774\ub514_\uae00\uc790 + "&jiraProject=" + ALM_\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\uae00\uc790 + "\n\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\u2015\n\n\uc2dc\uc791 \uc77c\uc790 : " + \uc2dc\uc791\uc77c + "\n\uc885\ub8cc \uc77c\uc790 : " + \uc885\ub8cc\uc77c + "\n\n\u203b \u300e \uc544\ub798\ub294 \uc785\ub825\ub41c \uc694\uad6c\uc0ac\ud56d \ub0b4\uc6a9\uc785\ub2c8\ub2e4. \u300f\n\n\n";
        return \uc774\uc288\ub0b4\uc6a9;
    }

    private PdServiceEntity \uc81c\ud488\ub370\uc774\ud130\uc870\ud68c(String pdServiceId) throws Exception {
        return (PdServiceEntity)TreeServiceUtils.getNode((TreeService)this.pdService, (Long)Long.valueOf(pdServiceId), PdServiceEntity.class);
    }

    private Set<Long> \uc720\uc9c0\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\ucc3e\uae30(Set<Long> \ud604\uc7ac\ubc84\uc804, Set<Long> \uc218\uc815\ud560\ubc84\uc804) {
        HashSet<Long> \uc720\uc9c0\ub41c\ubc84\uc804 = new HashSet<Long>(\ud604\uc7ac\ubc84\uc804);
        \uc720\uc9c0\ub41c\ubc84\uc804.retainAll(\uc218\uc815\ud560\ubc84\uc804);
        return \uc720\uc9c0\ub41c\ubc84\uc804;
    }

    private Set<Long> \ucd94\uac00\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\ucc3e\uae30(Set<Long> \ud604\uc7ac\ubc84\uc804, Set<Long> \uc218\uc815\ud560\ubc84\uc804) {
        HashSet<Long> \ucd94\uac00\ub41c\ubc84\uc804 = new HashSet<Long>(\uc218\uc815\ud560\ubc84\uc804);
        \ucd94\uac00\ub41c\ubc84\uc804.removeAll(\ud604\uc7ac\ubc84\uc804);
        return \ucd94\uac00\ub41c\ubc84\uc804;
    }

    private Set<Long> \uc0ad\uc81c\ub41c\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8\ucc3e\uae30(Set<Long> \ud604\uc7ac\ubc84\uc804, Set<Long> \uc218\uc815\ud560\ubc84\uc804) {
        HashSet<Long> \uc0ad\uc81c\ub41c\ubc84\uc804 = new HashSet<Long>(\ud604\uc7ac\ubc84\uc804);
        \uc0ad\uc81c\ub41c\ubc84\uc804.removeAll(\uc218\uc815\ud560\ubc84\uc804);
        return \uc0ad\uc81c\ub41c\ubc84\uc804;
    }

    @Async
    public void \uc0c1\ud0dc\uc0ad\uc81c_\ud6c4_\uc804\uccb4_\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc\ubcc0\uacbd(Long \ubcc0\uacbd_\uc804_\uc0c1\ud0dc\uc544\uc774\ub514, Long \ubcc0\uacbd_\ud6c4_\uc0c1\ud0dc\uc544\uc774\ub514) throws Exception {
        PdServiceEntity \uc81c\ud488\uc11c\ube44\uc2a4_\uc870\ud68c = new PdServiceEntity();
        List \uc81c\ud488\uc11c\ube44\uc2a4_\ub9ac\uc2a4\ud2b8 = this.pdService.getNodesWithoutRoot((TreeSearchEntity)\uc81c\ud488\uc11c\ube44\uc2a4_\uc870\ud68c);
        for (PdServiceEntity \uc81c\ud488\uc11c\ube44\uc2a4 : \uc81c\ud488\uc11c\ube44\uc2a4_\ub9ac\uc2a4\ud2b8) {
            Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = \uc81c\ud488\uc11c\ube44\uc2a4.getC_id();
            ResponseEntity \uacb0\uacfc = this.internalService.\uc804\uccb4_\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc\ubcc0\uacbd("T_ARMS_REQADD_" + \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, \ubcc0\uacbd_\uc804_\uc0c1\ud0dc\uc544\uc774\ub514, \ubcc0\uacbd_\ud6c4_\uc0c1\ud0dc\uc544\uc774\ub514);
            if (\uacb0\uacfc.getStatusCode().is2xxSuccessful()) continue;
            log.error("\uc0c1\ud0dc \ubcc0\uacbd \uc624\ub958 :: {}, {}", (Object)\uacb0\uacfc.getStatusCodeValue(), \uacb0\uacfc.getBody());
        }
    }

    @Transactional
    public List<ReqAddPureEntity> \uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc\ubcc0\uacbd(Long \ubcc0\uacbd_\uc804_\uc0c1\ud0dc\uc544\uc774\ub514, Long \ubcc0\uacbd\ud560_\uc0c1\ud0dc\uc544\uc774\ub514) throws Exception {
        ReqAddPureEntity reqAddPureEntity = new ReqAddPureEntity();
        SimpleExpression criterion1 = Restrictions.eq((String)"c_type", (Object)"default");
        SimpleExpression criterion2 = Restrictions.eq((String)"c_req_state_link", (Object)\ubcc0\uacbd_\uc804_\uc0c1\ud0dc\uc544\uc774\ub514);
        LogicalExpression criterion = Restrictions.and((Criterion)criterion1, (Criterion)criterion2);
        reqAddPureEntity.getCriterions().add(criterion);
        List \uc804\uccb4_\uc694\uad6c\uc0ac\ud56d\ubaa9\ub85d = this.getNodesWithoutRoot((TreeSearchEntity)reqAddPureEntity);
        List \uc0c1\ud0dc\ubcc0\uacbd_\uc694\uad6c\uc0ac\ud56d\ubaa9\ub85d = \uc804\uccb4_\uc694\uad6c\uc0ac\ud56d\ubaa9\ub85d.stream().map(\uc694\uad6c\uc0ac\ud56d -> {
            if (\uc694\uad6c\uc0ac\ud56d.getC_req_state_link() == null || Objects.equals(\uc694\uad6c\uc0ac\ud56d.getC_req_state_link(), \ubcc0\uacbd_\uc804_\uc0c1\ud0dc\uc544\uc774\ub514)) {
                \uc694\uad6c\uc0ac\ud56d.setC_req_state_link(\ubcc0\uacbd\ud560_\uc0c1\ud0dc\uc544\uc774\ub514);
                return \uc694\uad6c\uc0ac\ud56d;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List reqAddEntities = this.saveOrUpdateList(\uc0c1\ud0dc\ubcc0\uacbd_\uc694\uad6c\uc0ac\ud56d\ubaa9\ub85d);
        return reqAddEntities;
    }

    public ReqAddImpl(EngineService engineService, InternalService internalService, GlobalTreeMapService globalTreeMapService, PdServiceVersion pdServiceVersion, JiraProject jiraProject, JiraServer jiraServer, Chat chat, ArmsDetailUrlConfig armsDetailUrlConfig, PdService pdService, ReqStatus reqStatus) {
        this.engineService = engineService;
        this.internalService = internalService;
        this.globalTreeMapService = globalTreeMapService;
        this.pdServiceVersion = pdServiceVersion;
        this.jiraProject = jiraProject;
        this.jiraServer = jiraServer;
        this.chat = chat;
        this.armsDetailUrlConfig = armsDetailUrlConfig;
        this.pdService = pdService;
        this.reqStatus = reqStatus;
    }
}

