/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.reqadd.kafka;

import com.arms.api.requirement.reqadd.model.dto.ReqAddDTO;
import com.arms.api.util.DataSerializer;
import com.arms.api.util.communicate.internal.InternalService;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.PostConstruct;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

@Component
public class ReqAddConsumer {
    private static final Logger log = LoggerFactory.getLogger(ReqAddConsumer.class);
    private final InternalService internalService;

    @PostConstruct
    public void init() {
        log.info("========================================");
        log.info("\u2705 ReqAddConsumer Bean initialized successfully!");
        log.info("\ud83d\udce1 Listening on topic: ${spring.kafka.topic.reqadd:REQADD}");
        log.info("\ud83d\udc65 Consumer group: requirement-consumer-group");
        log.info("========================================");
    }

    @KafkaListener(topics={"${spring.kafka.topic.reqadd:REQADD}"}, containerFactory="reqAddKafkaListenerContainerFactory")
    public void consumeReqAddAddNodeRequest(ConsumerRecord<String, String> record, Acknowledgment ack) {
        Instant startTime = Instant.now();
        String key = (String)record.key();
        String uuid = "unknown";
        try {
            log.info("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            log.info("\ud83d\udfe1 [RECEIVED] Kafka message received");
            log.info("   Key: {}", (Object)key);
            log.info("   Partition: {}, Offset: {}", (Object)record.partition(), (Object)record.offset());
            log.info("   Timestamp: {}", (Object)Instant.ofEpochMilli(record.timestamp()));
            if (key == null || key.isEmpty()) {
                log.error("\u274c [INVALID] Received message with null or empty key");
                ack.acknowledge();
                return;
            }
            String[] parts = key.split(":");
            if (parts.length < 4) {
                log.error("\u274c [INVALID] Invalid key format: {}. Expected: requirement:tableName:eventType:uuid", (Object)key);
                ack.acknowledge();
                return;
            }
            String messageType = parts[0];
            String tableName = parts[1];
            String eventType = parts[2];
            uuid = parts[3];
            log.info("\ud83d\udccb [PARSED] Message details:");
            log.info("   Type: {}", (Object)messageType);
            log.info("   Table: {}", (Object)tableName);
            log.info("   Event: {}", (Object)eventType);
            log.info("   UUID: {}", (Object)uuid);
            String value = (String)record.value();
            log.info("\ud83d\udce6 [PAYLOAD] Raw JSON: {}", (Object)value);
            ReqAddDTO payload = (ReqAddDTO)DataSerializer.deserialize((String)value, ReqAddDTO.class);
            if (payload == null) {
                log.error("\u274c [FAILED] Failed to deserialize payload - UUID: {}", (Object)uuid);
                ack.acknowledge();
                return;
            }
            log.info("\u2705 [DESERIALIZED] Payload: {}", (Object)payload);
            log.info("\ud83d\udd04 [PROCESSING] Starting {} processing - UUID: {}", (Object)eventType, (Object)uuid);
            switch (eventType) {
                case "CREATE": {
                    log.info("   [CREATE] Processing create event");
                    log.info("   Table: {}", (Object)tableName);
                    log.info("   Data: {}", (Object)payload);
                    break;
                }
                case "UPDATE": {
                    log.info("   [UPDATE] Processing update event");
                    log.info("   Table: {}", (Object)tableName);
                    log.info("   Data: {}", (Object)payload);
                    break;
                }
                case "DELETE": {
                    log.info("   [DELETE] Processing delete event");
                    log.info("   Table: {}", (Object)tableName);
                    log.info("   Data: {}", (Object)payload);
                    break;
                }
                default: {
                    log.warn("\u26a0\ufe0f  [UNKNOWN] Unknown event type: {} - UUID: {}", (Object)eventType, (Object)uuid);
                    ack.acknowledge();
                    return;
                }
            }
            Duration processingTime = Duration.between(startTime, Instant.now());
            log.info("\u2705 [SUCCESS] Message processed successfully");
            log.info("   UUID: {}", (Object)uuid);
            log.info("   Processing time: {} ms", (Object)processingTime.toMillis());
            log.info("   Event: {}", (Object)eventType);
        }
        catch (Exception e) {
            Duration processingTime = Duration.between(startTime, Instant.now());
            log.error("\u274c [FAILED] Message processing failed");
            log.error("   UUID: {}", (Object)uuid);
            log.error("   Key: {}", (Object)key);
            log.error("   Processing time: {} ms", (Object)processingTime.toMillis());
            log.error("   Error: {}", (Object)e.getMessage(), (Object)e);
        }
        ack.acknowledge();
        log.info("\ud83d\udfe2 [COMMITTED] Offset committed - UUID: {}", (Object)uuid);
        log.info("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    public ReqAddConsumer(InternalService internalService) {
        this.internalService = internalService;
    }
}

