/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.reqadd.kafka;

import com.arms.config.KafkaLagMonitor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/kafka"})
public class KafkaMonitorController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private KafkaLagMonitor kafkaLagMonitor;

    @GetMapping(value={"/lag/{topic}"})
    public ResponseEntity<Map<String, Object>> getTopicLag(@PathVariable String topic) {
        this.logger.info("Getting lag for topic: {}", (Object)topic);
        long totalLag = this.kafkaLagMonitor.getConsumerLag(topic);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("topic", topic);
        response.put("totalLag", totalLag);
        response.put("timestamp", System.currentTimeMillis());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/lag/{topic}/detail"})
    public ResponseEntity<Map<String, Object>> getDetailedTopicLag(@PathVariable String topic) {
        this.logger.info("Getting detailed lag for topic: {}", (Object)topic);
        Map detailedLag = this.kafkaLagMonitor.getDetailedLag(topic);
        long totalLag = detailedLag.values().stream().mapToLong(Long::longValue).sum();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("topic", topic);
        response.put("totalLag", totalLag);
        response.put("partitionCount", detailedLag.size());
        response.put("partitionLags", detailedLag);
        response.put("timestamp", System.currentTimeMillis());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/status/{topic}"})
    public ResponseEntity<Map<String, Object>> getConsumerStatus(@PathVariable String topic) {
        this.logger.info("Getting consumer status for topic: {}", (Object)topic);
        Map status = this.kafkaLagMonitor.getConsumerStatus(topic);
        return ResponseEntity.ok((Object)status);
    }

    @GetMapping(value={"/lag/reqadd"})
    public ResponseEntity<Map<String, Object>> getReqAddLag() {
        return this.getTopicLag("REQADD");
    }

    @GetMapping(value={"/health"})
    public ResponseEntity<Map<String, Object>> health() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "UP");
        response.put("service", "kafka-monitor");
        response.put("timestamp", System.currentTimeMillis());
        return ResponseEntity.ok(response);
    }
}

