/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.reqadd.excelupload;

import com.arms.api.requirement.reqadd.excelupload.ExcelGantUpload;
import com.arms.api.requirement.reqadd.excelupload.WbsSchedule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelGantUpload {
    private static int WBS_NAME_INDEX = 3;
    private static int HEADER_ROW = 4;
    private final Sheet sheet;
    private final List<WbsSchedule> getWebScheduleList;

    public ExcelGantUpload(InputStream inputStream) throws IOException {
        try (Workbook workbook = null;){
            workbook = WorkbookFactory.create((InputStream)inputStream);
            this.sheet = workbook.getSheet("Schedule");
            this.getWebScheduleList = new ArrayList(this.convertExcelToWbsSchedule());
        }
    }

    private List<WbsSchedule> convertExcelToWbsSchedule() {
        return StreamSupport.stream(this.sheet.spliterator(), false).skip(HEADER_ROW).flatMap(arg_0 -> this.rowToWbsSchedule(arg_0)).collect(Collectors.toList());
    }

    private Stream<WbsSchedule> rowToWbsSchedule(Row row) {
        return IntStream.range(WBS_NAME_INDEX, row.getLastCellNum()).mapToObj(index -> row.getCell(index)).filter(cell -> cell.getColumnIndex() == WBS_NAME_INDEX && !cell.getStringCellValue().isEmpty()).map(cell -> {
            String wbsName = this.getValueFromCell(cell);
            Cell jobNameCell = row.getCell(cell.getColumnIndex() + this.getJobIndex(wbsName));
            return WbsSchedule.builder().wbsName(wbsName).jobName(this.getValueFromCell(jobNameCell)).depth(this.getJobIndex(wbsName)).build();
        }).filter(Objects::nonNull);
    }

    private int getJobIndex(String wbsName) {
        return wbsName.split("\\.").length;
    }

    private String getValueFromCell(Cell cell) {
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1: {
                return String.valueOf(cell.getStringCellValue());
            }
            case 2: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 3: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return String.valueOf(cell.getDateCellValue());
                }
                return String.valueOf(cell.getNumericCellValue());
            }
            case 4: {
                return String.valueOf(cell.getCellFormula());
            }
            case 5: {
                return "";
            }
        }
        return "";
    }

    public List<WbsSchedule> getGetWebScheduleList() {
        return this.getWebScheduleList;
    }
}

