/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.fulldata.service;

import com.arms.api.jira.jiraproject_pure.model.JiraProjectPureEntity;
import com.arms.api.jira.jiraproject_pure.service.JiraProjectPure;
import com.arms.api.product_service.pdservice.model.PdServiceAndVersionListDTO;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.report.fulldata.model.ExcelDataDTO;
import com.arms.api.report.fulldata.model.FullDataRequestDTO;
import com.arms.api.report.fulldata.model.FullDataResponseDTO;
import com.arms.api.report.fulldata.model.\uc791\uc5c5\uc790_\uc815\ubcf4;
import com.arms.api.report.fulldata.service.FullDataService;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import com.arms.api.util.communicate.internal.InternalService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="FullDataService")
public class FullDataServiceImpl
implements FullDataService {
    private static final Logger log = LoggerFactory.getLogger(FullDataServiceImpl.class);
    private final InternalService internalCommunicator;
    private final EngineService engineService;
    private final JiraProjectPure jiraProjectPure;

    public List<\uc791\uc5c5\uc790_\uc815\ubcf4> getAssigneeList() {
        ResponseEntity listResponseEntity = this.engineService.getAssigneeList();
        return (List)listResponseEntity.getBody();
    }

    public List<ExcelDataDTO> getExcelDataDown(FullDataRequestDTO fullDataRequestDTO) throws Exception {
        return this.getExcelDataMapping(fullDataRequestDTO, arg_0 -> ((EngineService)this.engineService).\uc774\uc288\ubaa9\ub85d_\uac00\uc838\uc624\uae30(arg_0));
    }

    public List<ExcelDataDTO> getExcelData(FullDataRequestDTO fullDataRequestDTO) throws Exception {
        return this.getExcelDataMapping(fullDataRequestDTO, arg_0 -> ((EngineService)this.engineService).\uc774\uc288\ubaa9\ub85d_\uac00\uc838\uc624\uae30(arg_0));
    }

    private Map<Long, String> \ubc84\uc804\uc544\uc774\ub514_\uc774\ub984\ubc0f\uc77c\uc815_\ub9f5_\uad6c\uc131(List<PdServiceVersionEntity> \ubc84\uc804\uc5d4\ud2f0\ud2f0_\uc138\ud2b8) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<Long, String> \ubc84\uc804\ud0a4_\uc774\ub984\ubc0f\uc77c\uc815_\ub9f5 = new HashMap<Long, String>();
        for (PdServiceVersionEntity entity : \ubc84\uc804\uc5d4\ud2f0\ud2f0_\uc138\ud2b8) {
            Long key = entity.getC_id();
            String startDate = outputFormat.format(inputFormat.parse(entity.getC_pds_version_start_date()));
            String endDate = outputFormat.format(inputFormat.parse(entity.getC_pds_version_end_date()));
            String value = entity.getC_title() + " (" + startDate + " ~ " + endDate + ")";
            \ubc84\uc804\ud0a4_\uc774\ub984\ubc0f\uc77c\uc815_\ub9f5.put(key, value);
        }
        return \ubc84\uc804\ud0a4_\uc774\ub984\ubc0f\uc77c\uc815_\ub9f5;
    }

    private String \uc774\uc288_\ud0a4_\uac00\uc838\uc624\uae30(String docId) {
        if (docId == null || docId.isEmpty()) {
            return "(\uc54c\uc218\uc5c6\uc74c)";
        }
        String[] parts = docId.split("_");
        return parts[parts.length - 1];
    }

    private List<ExcelDataDTO> getExcelDataMapping(FullDataRequestDTO fullDataRequestDTO, Function<FullDataRequestDTO, ResponseEntity<FullDataResponseDTO>> function) throws Exception {
        ResponseEntity<FullDataResponseDTO> excelDataFromEngine;
        List AlmIssue_\ubaa9\ub85d;
        ArrayList<ExcelDataDTO> result = new ArrayList<ExcelDataDTO>();
        ResponseEntity internalResponse = this.internalCommunicator.getPdServiceEntityAndVersionList();
        if (internalResponse.getBody() == null) {
            log.error("[ FullDataServiceImpl :: getExcelData ] :: internalCommunicator.result => Information of PdServiceAndVersion is null.");
            return result;
        }
        List \uc81c\ud488\uc11c\ube44\uc2a4_\uc5d4\ud2f0\ud2f0_\ubc84\uc804\ubaa9\ub85d = (List)internalResponse.getBody();
        HashMap<Long, String> \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514_\uc774\ub984_\ub9f5 = new HashMap<Long, String>();
        HashMap<Long, String> \ubc84\uc804_\uc544\uc774\ub514_\uc774\ub984_\ub9f5 = new HashMap<Long, String>();
        for (PdServiceAndVersionListDTO dto : \uc81c\ud488\uc11c\ube44\uc2a4_\uc5d4\ud2f0\ud2f0_\ubc84\uc804\ubaa9\ub85d) {
            \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514_\uc774\ub984_\ub9f5.put(dto.getC_id(), dto.getC_title());
            List pdServiceVersionEntityList = dto.getPdServiceVersionEntityList();
            Map \ubc84\uc804\uc544\uc774\ub514_\uc774\ub984\ubc0f\uc77c\uc815_\ub9f5_\uad6c\uc131 = this.\ubc84\uc804\uc544\uc774\ub514_\uc774\ub984\ubc0f\uc77c\uc815_\ub9f5_\uad6c\uc131(pdServiceVersionEntityList);
            for (Map.Entry entry : \ubc84\uc804\uc544\uc774\ub514_\uc774\ub984\ubc0f\uc77c\uc815_\ub9f5_\uad6c\uc131.entrySet()) {
                \ubc84\uc804_\uc544\uc774\ub514_\uc774\ub984_\ub9f5.put((Long)entry.getKey(), (String)entry.getValue());
            }
        }
        List almProjectList = Optional.ofNullable(fullDataRequestDTO.getAlmProjectIds()).orElse(Collections.emptyList());
        if (!almProjectList.isEmpty()) {
            log.info("[ FullDataServiceImpl :: getExcelDataMapping ] :: almProjectList.size() => {}", (Object)almProjectList.size());
            List almProjects = this.jiraProjectPure.getJiraProjects(fullDataRequestDTO.getAlmProjectIds());
            List almProjectUrls = almProjects.stream().map(JiraProjectPureEntity::getC_jira_url).collect(Collectors.toList());
            fullDataRequestDTO.setAlmProjectUrls(almProjectUrls);
            log.info(fullDataRequestDTO.getAlmProjectUrls().toString());
        }
        if ((AlmIssue_\ubaa9\ub85d = ((FullDataResponseDTO)(excelDataFromEngine = function.apply(fullDataRequestDTO)).getBody()).getIssueEntityList()).isEmpty()) {
            log.info("[ FullDataServiceImpl :: getExcelData ] :: issue list is empty => 0");
            return result;
        }
        List \uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d = this.\ub0a0\uc9dc_\ud3ec\uba54\ud305\ub41c_\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\ubaa9\ub85d(AlmIssue_\ubaa9\ub85d);
        for (AlmIssue \uc694\uad6c\uc0ac\ud56d_\uc774\uc288 : \uc694\uad6c\uc0ac\ud56d_\ubaa9\ub85d) {
            ExcelDataDTO \uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ub370\uc774\ud130 = this.mapping(\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, \ubc84\uc804_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, \uc694\uad6c\uc0ac\ud56d_\uc774\uc288);
            result.add(\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ub370\uc774\ud130);
            List \ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d = AlmIssue_\ubaa9\ub85d.stream().filter(\uc9c0\ub77c\uc774\uc288 -> \uc9c0\ub77c\uc774\uc288.getParentReqKey() != null && \uc9c0\ub77c\uc774\uc288.getParentReqKey().equals(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getKey())).collect(Collectors.toList());
            String[] linkedIssues = \uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getLinkedIssues();
            if (linkedIssues != null && linkedIssues.length > 0) {
                Set linkedIssuesSet = Arrays.stream(linkedIssues).collect(Collectors.toSet());
                for (AlmIssue \ud558\uc704_\ub610\ub294_\uc5f0\uacb0\uc774\uc288 : \ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d) {
                    if (linkedIssuesSet.contains(\ud558\uc704_\ub610\ub294_\uc5f0\uacb0\uc774\uc288.getRecentId())) {
                        String etcContent = \uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getKey() + "\uc758 \uc5f0\uacb0\uc774\uc288";
                        AlmIssue \uc5f0\uacb0\uc774\uc288 = \ud558\uc704_\ub610\ub294_\uc5f0\uacb0\uc774\uc288.create\uc5f0\uacb0\uc774\uc288();
                        \uc5f0\uacb0\uc774\uc288.setEtc((Object)etcContent);
                        ExcelDataDTO \uc5f0\uacb0\uc774\uc288_\ub370\uc774\ud130 = this.mapping(\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, \ubc84\uc804_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, \uc5f0\uacb0\uc774\uc288);
                        \uc5f0\uacb0\uc774\uc288_\ub370\uc774\ud130.setReqTitle(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getSummary());
                        \uc5f0\uacb0\uc774\uc288_\ub370\uc774\ud130.setReqState(Optional.ofNullable(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getCReqProperty()).map(AlmIssue.\uc554\uc2a4_\uc694\uad6c\uc0ac\ud56d_\uc18d\uc131::getCReqStateName).orElse(""));
                        result.add(\uc5f0\uacb0\uc774\uc288_\ub370\uc774\ud130);
                        log.warn("[ FullDataServiceImpl :: getExcelDataMapping ] :: \uc5f0\uacb0\uc774\uc288 \ubc1c\uacac => {}", (Object)\uc5f0\uacb0\uc774\uc288_\ub370\uc774\ud130.toString());
                        continue;
                    }
                    ExcelDataDTO \ud558\uc704\uc774\uc288_\ub370\uc774\ud130 = this.mapping(\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, \ubc84\uc804_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, \ud558\uc704_\ub610\ub294_\uc5f0\uacb0\uc774\uc288);
                    \ud558\uc704\uc774\uc288_\ub370\uc774\ud130.setReqTitle(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getSummary());
                    \ud558\uc704\uc774\uc288_\ub370\uc774\ud130.setReqState(Optional.ofNullable(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getCReqProperty()).map(AlmIssue.\uc554\uc2a4_\uc694\uad6c\uc0ac\ud56d_\uc18d\uc131::getCReqStateName).orElse(""));
                    result.add(\ud558\uc704\uc774\uc288_\ub370\uc774\ud130);
                }
                continue;
            }
            for (AlmIssue \ud558\uc704\uc774\uc288 : \ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_\ubaa9\ub85d) {
                ExcelDataDTO \ud558\uc704\uc774\uc288_\ub370\uc774\ud130 = this.mapping(\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, \ubc84\uc804_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, \ud558\uc704\uc774\uc288);
                \ud558\uc704\uc774\uc288_\ub370\uc774\ud130.setReqTitle(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getSummary());
                \ud558\uc704\uc774\uc288_\ub370\uc774\ud130.setReqState(Optional.ofNullable(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getCReqProperty()).map(AlmIssue.\uc554\uc2a4_\uc694\uad6c\uc0ac\ud56d_\uc18d\uc131::getCReqStateName).orElse(""));
                result.add(\ud558\uc704\uc774\uc288_\ub370\uc774\ud130);
            }
        }
        for (ExcelDataDTO excelDataDTO : result) {
            log.warn(excelDataDTO.getEtc());
        }
        return result;
    }

    private List<AlmIssue> \ub0a0\uc9dc_\ud3ec\uba54\ud305\ub41c_\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\ubaa9\ub85d(List<AlmIssue> AlmIssue_\ubaa9\ub85d) {
        AlmIssue_\ubaa9\ub85d.stream().filter(\uc9c0\ub77c\uc774\uc288 -> \uc9c0\ub77c\uc774\uc288.getIsReq().equals(Boolean.TRUE)).forEach(\uc9c0\ub77c\uc774\uc288 -> {
            \uc9c0\ub77c\uc774\uc288.setCreated(Optional.ofNullable(\uc9c0\ub77c\uc774\uc288.getCreated()).map(arg_0 -> this.timeFormatting(arg_0)).orElse(""));
            \uc9c0\ub77c\uc774\uc288.setUpdated(Optional.ofNullable(\uc9c0\ub77c\uc774\uc288.getUpdated()).map(arg_0 -> this.timeFormatting(arg_0)).orElse(""));
            \uc9c0\ub77c\uc774\uc288.setResolutiondate(Optional.ofNullable(\uc9c0\ub77c\uc774\uc288.getResolutiondate()).map(arg_0 -> this.timeFormatting(arg_0)).orElse(""));
        });
        return AlmIssue_\ubaa9\ub85d.stream().filter(\uc9c0\ub77c\uc774\uc288 -> \uc9c0\ub77c\uc774\uc288.getIsReq().equals(Boolean.TRUE)).sorted(Comparator.comparing(AlmIssue::getUpdated, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
    }

    private ExcelDataDTO mapping(Map<Long, String> \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, Map<Long, String> \ubc84\uc804_\uc544\uc774\ub514_\uc774\ub984_\ub9f5, AlmIssue issue) {
        if (issue.getKey() == null) {
            System.out.println(issue);
        }
        Long[] pdServiceVersions = issue.getPdServiceVersions();
        String \ubc84\uc804\uba85 = Optional.ofNullable(pdServiceVersions).map(versions -> Arrays.stream(versions).filter(\ubc84\uc804_\uc544\uc774\ub514_\uc774\ub984_\ub9f5::containsKey).map(\ubc84\uc804_\uc544\uc774\ub514_\uc774\ub984_\ub9f5::get).collect(Collectors.joining(","))).filter(result -> !result.isEmpty()).orElse("\ubc84\uc804 \uc815\ubcf4 \uc5c6\uc74c");
        ExcelDataDTO.ExcelDataDTOBuilder \uc5d1\uc140\ub370\uc774\ud130_\ube4c\ub354 = ExcelDataDTO.builder().pdServiceId(issue.getPdServiceId()).pdServiceName(Optional.ofNullable(\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514_\uc774\ub984_\ub9f5.get(issue.getPdServiceId())).orElse("\uc81c\ud488(\uc11c\ube44\uc2a4) \uc815\ubcf4 \uc5c6\uc74c")).pdServiceVersionNames(\ubc84\uc804\uba85).cReqLink(issue.getCReqLink());
        \uc5d1\uc140\ub370\uc774\ud130_\ube4c\ub354.upperKey(issue.getUpperKey()).parentReqKey(issue.getParentReqKey());
        \uc5d1\uc140\ub370\uc774\ud130_\ube4c\ub354.almProjectName(issue.projectName()).key(issue.getKey()).issueID(issue.getIssueID()).docId(issue.getRecentId()).issueTitle(issue.getSummary()).issueStatus(issue.statusName()).assigneeName(Optional.ofNullable(issue.getAssignee()).map(AlmIssue.\ub2f4\ub2f9\uc790::getDisplayName).orElse("\ub2f4\ub2f9\uc790 \uc815\ubcf4 \uc5c6\uc74c")).assigneeEmail(Optional.ofNullable(issue.getAssignee()).map(AlmIssue.\ub2f4\ub2f9\uc790::getEmailAddress).orElse("\ub2f4\ub2f9\uc790 \uba54\uc77c \uc5c6\uc74c"));
        Object isReqName = "";
        if (issue.getIsReq().equals(Boolean.TRUE)) {
            isReqName = "\uc694\uad6c\uc0ac\ud56d";
            \uc5d1\uc140\ub370\uc774\ud130_\ube4c\ub354.reqTitle(issue.getSummary()).isReq(Boolean.TRUE).isReqName((String)isReqName).createDate(Optional.ofNullable(issue.getCreated()).orElse("\uc0dd\uc131\uc77c \uc815\ubcf4 \uc5c6\uc74c")).updatedDate(Optional.ofNullable(issue.getUpdated()).orElse("\uc218\uc815\uc77c \uc815\ubcf4 \uc5c6\uc74c")).resolutionDate(Optional.ofNullable(issue.getResolutiondate()).orElse("")).reqState(Optional.ofNullable(issue.getCReqProperty()).map(AlmIssue.\uc554\uc2a4_\uc694\uad6c\uc0ac\ud56d_\uc18d\uc131::getCReqStateName).orElse("\uc0c1\ud0dc \uc815\ubcf4 \uc5c6\uc74c"));
        } else if (issue.getEtc() != null) {
            isReqName = String.valueOf(issue.getEtc());
            \uc5d1\uc140\ub370\uc774\ud130_\ube4c\ub354.isReq(Boolean.FALSE).isReqName((String)isReqName).reqTitle("").reqState("").createDate(Optional.ofNullable(issue.getCreated()).map(arg_0 -> this.timeFormatting(arg_0)).orElse("\uc0dd\uc131\uc77c \uc815\ubcf4 \uc5c6\uc74c")).updatedDate(Optional.ofNullable(issue.getUpdated()).map(arg_0 -> this.timeFormatting(arg_0)).orElse("\uc218\uc815\uc77c \uc815\ubcf4 \uc5c6\uc74c")).resolutionDate(Optional.ofNullable(issue.getResolutiondate()).map(arg_0 -> this.timeFormatting(arg_0)).orElse("")).etc(String.valueOf(issue.getEtc()));
        } else {
            isReqName = !Objects.equals(issue.getParentReqKey(), issue.getUpperKey()) && issue.getUpperKey() != null ? issue.getUpperKey() + "\uc758 \ud558\uc704\uc774\uc288" : issue.getParentReqKey() + "\uc758 \ud558\uc704\uc774\uc288";
            \uc5d1\uc140\ub370\uc774\ud130_\ube4c\ub354.reqTitle("").reqState("").isReq(Boolean.FALSE).isReqName((String)isReqName).createDate(Optional.ofNullable(issue.getCreated()).map(arg_0 -> this.timeFormatting(arg_0)).orElse("\uc0dd\uc131\uc77c \uc815\ubcf4 \uc5c6\uc74c")).updatedDate(Optional.ofNullable(issue.getUpdated()).map(arg_0 -> this.timeFormatting(arg_0)).orElse("\uc218\uc815\uc77c \uc815\ubcf4 \uc5c6\uc74c")).resolutionDate(Optional.ofNullable(issue.getResolutiondate()).map(arg_0 -> this.timeFormatting(arg_0)).orElse(""));
        }
        return \uc5d1\uc140\ub370\uc774\ud130_\ube4c\ub354.build();
    }

    private String timeFormatting(String inputDate) {
        ZonedDateTime zonedDateTime;
        DateTimeFormatter formatterWithMillisNoColon = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        DateTimeFormatter formatterWithMillisWithColon = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        DateTimeFormatter formatterWithoutMillisNoColon = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
        DateTimeFormatter formatterWithoutMillisWithColon = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
        if (inputDate.matches(".*\\.\\d{3}\\+\\d{4}")) {
            zonedDateTime = ZonedDateTime.parse(inputDate, formatterWithMillisNoColon);
        } else if (inputDate.matches(".*\\.\\d{3}\\+\\d{2}:\\d{2}")) {
            zonedDateTime = ZonedDateTime.parse(inputDate, formatterWithMillisWithColon);
        } else if (inputDate.matches(".*\\+\\d{4}")) {
            zonedDateTime = ZonedDateTime.parse(inputDate, formatterWithoutMillisNoColon);
        } else if (inputDate.matches(".*\\+\\d{2}:\\d{2}")) {
            zonedDateTime = ZonedDateTime.parse(inputDate, formatterWithoutMillisWithColon);
        } else {
            log.error("[ FullDataServiceImpl :: timeFormatting ] :: \uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ub0a0\uc9dc \ud615\uc2dd. \ub4e4\uc5b4\uc628 \uac12 => {}", (Object)inputDate);
            return inputDate;
        }
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String outputDate = zonedDateTime.format(outputFormatter);
        return outputDate;
    }

    public FullDataServiceImpl(InternalService internalCommunicator, EngineService engineService, JiraProjectPure jiraProjectPure) {
        this.internalCommunicator = internalCommunicator;
        this.engineService = engineService;
        this.jiraProjectPure = jiraProjectPure;
    }
}

