/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.fulldata.controller;

import com.arms.api.report.fulldata.model.ExcelDataDTO;
import com.arms.api.report.fulldata.model.FullDataRequestDTO;
import com.arms.api.report.fulldata.model.\uc791\uc5c5\uc790_\uc815\ubcf4;
import com.arms.api.report.fulldata.service.FullDataService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsBase;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsFactory;
import feign.Param;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/arms/report/full-data"})
public class FullDataController {
    private static final Logger log = LoggerFactory.getLogger(FullDataController.class);
    private final FullDataService fullDataService;

    @GetMapping(value={"/assignee-list"})
    public ResponseEntity<CommonResponse.ApiResult<List<\uc791\uc5c5\uc790_\uc815\ubcf4>>> getAssignees() throws Exception {
        List assigneeList = this.fullDataService.getAssigneeList();
        return ResponseEntity.ok((Object)CommonResponse.success((Object)assigneeList));
    }

    @GetMapping(value={"/excel-data"})
    public ResponseEntity<CommonResponse.ApiResult<List<ExcelDataDTO>>> getExcelData(FullDataRequestDTO fullDataRequestDTO) throws Exception {
        List response = this.fullDataService.getExcelData(fullDataRequestDTO);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)response));
    }

    @GetMapping(value={"/excel-data-down"})
    public void getExcelDataDown(FullDataRequestDTO fullDataRequestDTO, @Param(value="fileName") String fileName, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.addHeader("Content-Disposition", "attachment; filename=" + fileName);
        httpServletResponse.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpServletResponse.addHeader("Pragma", "no-cache");
        httpServletResponse.addHeader("Expires", "0");
        httpServletResponse.setContentType("application/octet-stream");
        ExcelUtilsBase excelUtilsBase = ExcelUtilsFactory.getInstance((OutputStream)httpServletResponse.getOutputStream());
        List excelDataDown = this.fullDataService.getExcelDataDown(fullDataRequestDTO);
        log.info("[ FullDataController :: getExcelDataDown ] :: excelData.count=> {}", (Object)excelDataDown.size());
        excelUtilsBase.create(List.of(excelDataDown));
    }

    public FullDataController(FullDataService fullDataService) {
        this.fullDataService = fullDataService;
    }
}

