/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.template;

import com.arms.api.report.export_service.config.ReportConfig;
import com.arms.api.report.export_service.exception.TemplateNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class TemplateLoader {
    private static final Logger log = LoggerFactory.getLogger(TemplateLoader.class);
    private final ReportConfig reportConfig;

    public XMLSlideShow loadPptTemplate(String templateName) {
        XMLSlideShow xMLSlideShow;
        block9: {
            Resource templateResource = this.reportConfig.getTemplateResource(templateName);
            if (!templateResource.exists()) {
                log.error("Template not found: {}", (Object)templateName);
                throw new TemplateNotFoundException(templateName);
            }
            InputStream is = templateResource.getInputStream();
            try {
                log.info("Loading PPT template: {}", (Object)templateName);
                xMLSlideShow = new XMLSlideShow(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to load template: {}", (Object)templateName, (Object)e);
                    throw new TemplateNotFoundException(templateName, (Throwable)e);
                }
            }
            is.close();
        }
        return xMLSlideShow;
    }

    public XMLSlideShow loadDefaultTemplate() {
        return this.loadPptTemplate("default");
    }

    public XMLSlideShow createEmptyPresentation() {
        log.info("Creating empty presentation (no template)");
        return new XMLSlideShow();
    }

    public boolean templateExists(String templateName) {
        Resource templateResource = this.reportConfig.getTemplateResource(templateName);
        boolean exists = templateResource.exists();
        log.debug("Template '{}' exists: {}", (Object)templateName, (Object)exists);
        return exists;
    }

    public InputStream loadFont(String fontName) throws IOException {
        Resource fontResource = this.reportConfig.getFontResource(fontName);
        if (!fontResource.exists()) {
            log.error("Font not found: {}", (Object)fontName);
            throw new IOException("Font not found: " + fontName);
        }
        log.debug("Loading font: {}", (Object)fontName);
        return fontResource.getInputStream();
    }

    public InputStream loadDefaultFont() throws IOException {
        Resource fontResource = this.reportConfig.getDefaultFontResource();
        return fontResource.getInputStream();
    }

    public TemplateLoader(ReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }
}

