/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFGroupShape;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PlaceholderResolver {
    private static final Logger log = LoggerFactory.getLogger(PlaceholderResolver.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{\\{([^}]+)\\}\\}");

    public void resolvePlaceholders(XSLFSlide slide, Map<String, String> placeholders) {
        for (XSLFShape shape : slide.getShapes()) {
            if (shape instanceof XSLFTextShape) {
                XSLFTextShape textShape = (XSLFTextShape)shape;
                this.resolveTextShape(textShape, placeholders);
                continue;
            }
            if (shape instanceof XSLFTable) {
                XSLFTable table = (XSLFTable)shape;
                this.resolveTable(table, placeholders);
                continue;
            }
            if (!(shape instanceof XSLFGroupShape)) continue;
            XSLFGroupShape groupShape = (XSLFGroupShape)shape;
            this.resolveGroupShape(groupShape, placeholders);
        }
    }

    private void resolveTextShape(XSLFTextShape textShape, Map<String, String> placeholders) {
        for (XSLFTextParagraph paragraph : textShape.getTextParagraphs()) {
            for (XSLFTextRun run : paragraph.getTextRuns()) {
                String text = run.getRawText();
                if (text == null || !this.containsPlaceholder(text)) continue;
                String resolved = this.resolvePlaceholderString(text, placeholders);
                run.setText(resolved);
                log.debug("Replaced placeholder: '{}' -> '{}'", (Object)text, (Object)resolved);
            }
        }
    }

    private void resolveTable(XSLFTable table, Map<String, String> placeholders) {
        for (XSLFTableRow row : table.getRows()) {
            for (XSLFTableCell cell : row.getCells()) {
                this.resolveTextShape((XSLFTextShape)cell, placeholders);
            }
        }
    }

    private void resolveGroupShape(XSLFGroupShape groupShape, Map<String, String> placeholders) {
        for (XSLFShape shape : groupShape.getShapes()) {
            if (shape instanceof XSLFTextShape) {
                XSLFTextShape textShape = (XSLFTextShape)shape;
                this.resolveTextShape(textShape, placeholders);
                continue;
            }
            if (shape instanceof XSLFTable) {
                XSLFTable table = (XSLFTable)shape;
                this.resolveTable(table, placeholders);
                continue;
            }
            if (!(shape instanceof XSLFGroupShape)) continue;
            XSLFGroupShape nestedGroup = (XSLFGroupShape)shape;
            this.resolveGroupShape(nestedGroup, placeholders);
        }
    }

    public String resolvePlaceholderString(String text, Map<String, String> placeholders) {
        if (text == null || placeholders == null) {
            return text;
        }
        String result = text;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String value;
            Object key = entry.getKey();
            String string = value = entry.getValue() != null ? entry.getValue() : "";
            if (!((String)key).startsWith("{{")) {
                key = "{{" + (String)key + "}}";
            }
            result = result.replace((CharSequence)key, value);
        }
        return result;
    }

    public boolean containsPlaceholder(String text) {
        if (text == null) {
            return false;
        }
        return PLACEHOLDER_PATTERN.matcher(text).find();
    }

    public List<String> extractPlaceholderKeys(String text) {
        ArrayList<String> keys = new ArrayList<String>();
        if (text == null) {
            return keys;
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(text);
        while (matcher.find()) {
            keys.add(matcher.group(1));
        }
        return keys;
    }

    public void resolveAllSlides(XMLSlideShow ppt, Map<String, String> placeholders) {
        for (XSLFSlide slide : ppt.getSlides()) {
            this.resolvePlaceholders(slide, placeholders);
        }
        log.info("Resolved placeholders in {} slides", (Object)ppt.getSlides().size());
    }
}

