/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.service;

import com.arms.api.report.export_service.enums.ExportType;
import com.arms.api.report.export_service.exception.ReportExportException;
import com.arms.api.report.export_service.service.ReportExportService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportExportServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(ReportExportServiceFactory.class);
    private final List<ReportExportService> exportServices;

    public ReportExportService getService(ExportType type) {
        log.debug("Looking for export service for type: {}", (Object)type);
        for (ReportExportService service : this.exportServices) {
            if (!service.supports(type)) continue;
            log.debug("Found service: {}", (Object)service.getClass().getSimpleName());
            return service;
        }
        throw new ReportExportException("UNSUPPORTED_TYPE", "No export service found for type: " + String.valueOf(type));
    }

    public ReportExportService getService(String typeName) {
        ExportType type = ExportType.fromString((String)typeName);
        return this.getService(type);
    }

    public ReportExportServiceFactory(List<ReportExportService> exportServices) {
        this.exportServices = exportServices;
    }
}

