/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.service;

import com.arms.api.report.export_service.enums.ExportType;
import com.arms.api.report.export_service.generator.PptGenerator;
import com.arms.api.report.export_service.model.ReportData;
import com.arms.api.report.export_service.service.ReportExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PptExportService
implements ReportExportService {
    private static final Logger log = LoggerFactory.getLogger(PptExportService.class);
    private final PptGenerator pptGenerator;

    public byte[] export(ReportData data) {
        log.info("Exporting report to PPT: {}", (Object)data.getTitle());
        long startTime = System.currentTimeMillis();
        byte[] result = this.pptGenerator.generate(data);
        long elapsed = System.currentTimeMillis() - startTime;
        log.info("PPT export completed - size: {} bytes, time: {}ms", (Object)result.length, (Object)elapsed);
        return result;
    }

    public ExportType getExportType() {
        return ExportType.PPT;
    }

    public PptExportService(PptGenerator pptGenerator) {
        this.pptGenerator = pptGenerator;
    }
}

