/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.controller;

import com.arms.api.report.export_service.dto.ReportExportRequest;
import com.arms.api.report.export_service.dto.ReportExportResponse;
import com.arms.api.report.export_service.enums.ExportType;
import com.arms.api.report.export_service.model.ReportData;
import com.arms.api.report.export_service.service.ReportExportService;
import com.arms.api.report.export_service.service.ReportExportServiceFactory;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/arms/export/reports"})
@Tag(name="PPT Export", description="PPT \ub0b4\ubcf4\ub0b4\uae30 API")
public class ReportExportController {
    private static final Logger log = LoggerFactory.getLogger(ReportExportController.class);
    private final ReportExportServiceFactory exportServiceFactory;

    @Operation(summary="PPT\ub85c \ub0b4\ubcf4\ub0b4\uae30")
    @PostMapping(value={"/export/ppt"})
    public ResponseEntity<byte[]> exportToPpt(@Valid @RequestBody ReportExportRequest request) {
        log.info("PPT Export request received - title: {}", (Object)request.getTitle());
        ReportExportService exportService = this.exportServiceFactory.getService(ExportType.PPT);
        ReportData reportData = request.toReportData();
        byte[] content = exportService.export(reportData);
        String filename = this.generateFilename(reportData.getTitle(), exportService.getFileExtension());
        log.info("PPT exported - filename: {}, size: {} bytes", (Object)filename, (Object)content.length);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).header("Access-Control-Expose-Headers", new String[]{"Content-Disposition"})).contentType(MediaType.parseMediaType((String)exportService.getContentType())).contentLength((long)content.length).body((Object)content);
    }

    @Operation(summary="PPT \uba54\ud0c0\ub370\uc774\ud130 \uc870\ud68c")
    @PostMapping(value={"/export/ppt/metadata"})
    public ResponseEntity<ReportExportResponse> exportPptMetadata(@Valid @RequestBody ReportExportRequest request) {
        ReportExportService exportService = this.exportServiceFactory.getService(ExportType.PPT);
        ReportData reportData = request.toReportData();
        byte[] content = exportService.export(reportData);
        String filename = this.generateFilename(reportData.getTitle(), exportService.getFileExtension());
        return ResponseEntity.ok((Object)ReportExportResponse.success((String)reportData.getReportId(), (String)filename, (ExportType)ExportType.PPT, (long)content.length));
    }

    private String generateFilename(String title, String extension) {
        String safeName = title != null ? title.replaceAll("[^a-zA-Z0-9\uac00-\ud7a3\\s]", "").replaceAll("\\s+", "_") : "report";
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        String filename = safeName + "_" + timestamp + extension;
        return URLEncoder.encode(filename, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public ReportExportController(ReportExportServiceFactory exportServiceFactory) {
        this.exportServiceFactory = exportServiceFactory;
    }
}

