/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.product_service.pdserviceversion.service;

import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalTreeMapService;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionVO;
import com.arms.api.product_service.pdserviceversion.service.PdServiceVersion;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pdServiceVersion")
public class PdServiceVersionImpl
extends TreeServiceImpl
implements PdServiceVersion {
    private static final Logger log = LoggerFactory.getLogger(PdServiceVersionImpl.class);
    private final GlobalTreeMapService globalTreeMapService;

    public List<PdServiceVersionVO> findAllByPdServiceId(Long pdServiceId) throws Exception {
        List globalTreeMapEntities = this.globalTreeMapService.findAllByIds(List.of(pdServiceId), "pdservice_link");
        List cids = globalTreeMapEntities.stream().filter(globalTreeMapEntity -> globalTreeMapEntity.getPdserviceversion_link() != null).map(GlobalTreeMapEntity::getPdserviceversion_link).collect(Collectors.toList());
        if (cids.isEmpty()) {
            return Collections.emptyList();
        }
        PdServiceVersionEntity pdServiceVersionEntity = new PdServiceVersionEntity();
        Criterion criterion = Restrictions.in((String)"c_id", cids);
        pdServiceVersionEntity.getCriterions().add(criterion);
        List pdServiceVersionEntities = this.getNodesWithoutRoot((TreeSearchEntity)pdServiceVersionEntity);
        return pdServiceVersionEntities.stream().map(PdServiceVersionVO::toVO).collect(Collectors.toList());
    }

    public List<PdServiceVersionEntity> getVersionListByCids(List<Long> cids) throws Exception {
        PdServiceVersionEntity \uac80\uc0c9\uc6a9_\uc5d4\ud2f0\ud2f0 = new PdServiceVersionEntity();
        Criterion criterion = Restrictions.in((String)"c_id", cids);
        \uac80\uc0c9\uc6a9_\uc5d4\ud2f0\ud2f0.getCriterions().add(criterion);
        List fetchedVersions = this.getChildNode((TreeSearchEntity)\uac80\uc0c9\uc6a9_\uc5d4\ud2f0\ud2f0);
        if (fetchedVersions.isEmpty()) {
            return Collections.emptyList();
        }
        log.info("[ PdServiceVersionImpl :: getVersionListByCids ] :: \uac00\uc838\uc628 \ubc84\uc804\uc5d4\ud2f0\ud2f0\uc758 \uc218 = {}", (Object)fetchedVersions.size());
        return fetchedVersions;
    }

    public Map<String, String> versionPeriod(List<Long> c_ids) throws Exception {
        PdServiceVersionEntity \ubc84\uc804_\uac80\uc0c9\uc138\ud305 = new PdServiceVersionEntity();
        \ubc84\uc804_\uac80\uc0c9\uc138\ud305.setWhereIn("c_id", c_ids);
        List \uac80\uc0c9\uacb0\uacfc_\ubaa9\ub85d = this.getChildNode((TreeSearchEntity)\ubc84\uc804_\uac80\uc0c9\uc138\ud305);
        log.info("PdServiceVersionImpl ::  versionPeriod.size = {}", (Object)\uac80\uc0c9\uacb0\uacfc_\ubaa9\ub85d.size());
        HashMap<String, String> map = new HashMap<String, String>();
        String earliestDate = null;
        String latestDate = null;
        for (PdServiceVersionEntity \ubc84\uc804\uc5d4\ud2f0\ud2f0 : \uac80\uc0c9\uacb0\uacfc_\ubaa9\ub85d) {
            String start = \ubc84\uc804\uc5d4\ud2f0\ud2f0.getC_pds_version_start_date();
            String end = \ubc84\uc804\uc5d4\ud2f0\ud2f0.getC_pds_version_end_date();
            if (earliestDate == null || start.compareTo(earliestDate) < 0) {
                earliestDate = start;
            }
            if (latestDate != null && end.compareTo(latestDate) <= 0) continue;
            latestDate = end;
        }
        map.put("earliestDate", earliestDate);
        map.put("latestDate", latestDate);
        log.info("[PdServiceVersionImpl ::  versionPeriod] :: earliestDate -> {}, latestDate -> {}", (Object)earliestDate, latestDate);
        return map;
    }

    public PdServiceVersionImpl(GlobalTreeMapService globalTreeMapService) {
        this.globalTreeMapService = globalTreeMapService;
    }
}

