/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.product_service.pdservice_detail.controller;

import com.arms.api.product_service.pdservice_detail.model.PdServiceDetailDTO;
import com.arms.api.product_service.pdservice_detail.model.PdServiceDetailEntity;
import com.arms.api.product_service.pdservice_detail.service.PdServiceDetail;
import com.arms.api.util.filerepository.model.FileRepositoryEntity;
import com.arms.api.util.filerepository.service.FileRepository;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/arms/pdServiceDetail"})
public class PdServiceDetailController
extends TreeAbstractController<PdServiceDetail, PdServiceDetailDTO, PdServiceDetailEntity> {
    private static final Logger log = LoggerFactory.getLogger(PdServiceDetailController.class);
    private final PdServiceDetail pdServiceDetail;
    private final FileRepository fileRepository;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.pdServiceDetail);
        this.setTreeEntity(PdServiceDetailEntity.class);
    }

    @GetMapping(value={"getNodes.do/{pdServiceId}"})
    public ResponseEntity<CommonResponse.ApiResult<List<PdServiceDetailDTO>>> getNodesByPdService(@PathVariable(value="pdServiceId") Long pdServiceId) throws Exception {
        log.info("[ PdServiceDetailController :: getNodesByPdService ] :: pdServiceId => {}", (Object)pdServiceId);
        List nodesByPdService = this.pdServiceDetail.getNodesByPdService(pdServiceId);
        List pdServiceDetailDTOS = nodesByPdService.stream().map(entity -> (PdServiceDetailDTO)this.modelMapper.map(entity, PdServiceDetailDTO.class)).collect(Collectors.toList());
        return ResponseEntity.ok((Object)CommonResponse.success(pdServiceDetailDTOS));
    }

    @PostMapping(value={"addNode.do/{pdServiceId}"})
    public ResponseEntity<CommonResponse.ApiResult<PdServiceDetailEntity>> addNodeByPdService(@PathVariable(value="pdServiceId") Long pdServiceId, PdServiceDetailDTO pdServiceDetailDTO) throws Exception {
        log.info("[ PdServiceDetailController :: addNodeByPdService ] :: pdServiceId => {}", (Object)pdServiceId);
        PdServiceDetailEntity pdServiceDetailEntity = (PdServiceDetailEntity)this.modelMapper.map((Object)pdServiceDetailDTO, PdServiceDetailEntity.class);
        PdServiceDetailEntity result = this.pdServiceDetail.addNodeWithGlobalContentsTreeMap(pdServiceId, pdServiceDetailEntity);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    @PostMapping(value={"/uploadFileToNode.do"})
    public ModelAndView uploadFileToNode(MultipartHttpServletRequest multiRequest, HttpServletRequest request) throws Exception {
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        long pdServiceDetailId = parser.getLong("pdServiceDetailId");
        log.info("[ PdServiceDetailController :: uploadFileToNode ] :: pdServiceDetailId => {}", (Object)pdServiceDetailId);
        HashMap<String, Set> map = new HashMap<String, Set>();
        map.put("files", this.pdServiceDetail.uploadFileForPdServiceNode(Long.valueOf(pdServiceDetailId), multiRequest));
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", map);
        return modelAndView;
    }

    @GetMapping(value={"/getFilesByNode.do"})
    public ResponseEntity<CommonResponse.ApiResult<HashMap<String, Set<FileRepositoryEntity>>>> getFilesByNode(HttpServletRequest request) throws Exception {
        log.info("[ PdServiceDetailController :: getFilesByNode ]");
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        HashMap returnMap = this.fileRepository.getFileSetByFileIdLinkWithGlobalContentsMap(parser);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)returnMap));
    }

    @PostMapping(value={"/deleteNode.do/{pdServiceDetailId}"})
    public ResponseEntity<CommonResponse.ApiResult<Integer>> deleteNode(@PathVariable(value="pdServiceDetailId") Long pdServiceDetailId) throws Exception {
        log.info("[ PdServiceDetailController :: deleteNode ] :: pdServiceDetailId => {}", (Object)pdServiceDetailId);
        int result = this.pdServiceDetail.deleteAll(pdServiceDetailId);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    @PostMapping(value={"/deleteFileNode.do/{fileId}"})
    public ResponseEntity<CommonResponse.ApiResult<Integer>> deleteFileNode(@PathVariable(value="fileId") Long fileId) throws Exception {
        log.info("[ PdServiceDetailController :: deleteFileNode ] :: fileId => {}", (Object)fileId);
        int result = this.pdServiceDetail.deleteFile(fileId);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    public PdServiceDetailController(PdServiceDetail pdServiceDetail, FileRepository fileRepository) {
        this.pdServiceDetail = pdServiceDetail;
        this.fileRepository = fileRepository;
    }
}

