/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.product_service.pdservice.controller;

import com.arms.api.product_service.pdservice.model.PdServiceAndVersionListDTO;
import com.arms.api.product_service.pdservice.model.PdServiceDTO;
import com.arms.api.product_service.pdservice.model.PdServiceEntity;
import com.arms.api.product_service.pdservice.service.PdService;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionDTO;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RestController
@RequestMapping(value={"/arms/pdService"})
public class PdServiceController
extends TreeAbstractController<PdService, PdServiceDTO, PdServiceEntity> {
    private static final Logger log = LoggerFactory.getLogger(PdServiceController.class);
    private final PdService pdService;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.pdService);
        this.setTreeEntity(PdServiceEntity.class);
    }

    @GetMapping(value={"/getNodeWithVersionOrderByCidDesc"})
    public ResponseEntity<?> getNodeWithVersionOrderByCidDesc(PdServiceDTO pdServiceDTO) throws Exception {
        log.info("[ PdServiceController :: getNodeWithVersionOrderByCidDesc ]");
        PdServiceEntity pdServiceEntity = (PdServiceEntity)this.modelMapper.map((Object)pdServiceDTO, PdServiceEntity.class);
        return ResponseEntity.ok((Object)this.pdService.getNodeWithVersionOrderByCidDesc(pdServiceEntity));
    }

    @PostMapping(value={"/addPdServiceNode.do"})
    public ResponseEntity<?> addPdServiceNode(@Validated(value={AddNode.class}) PdServiceDTO pdServiceDTO) throws Exception {
        log.info("[ PdServiceController :: addPdServiceNode ]");
        PdServiceEntity pdServiceEntity = (PdServiceEntity)this.modelMapper.map((Object)pdServiceDTO, PdServiceEntity.class);
        this.chat.sendMessageByEngine("\uc81c\ud488(\uc11c\ube44\uc2a4)\uac00 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pdService.addPdServiceAndVersion(pdServiceEntity)));
    }

    @PostMapping(value={"/addVersionToNode.do"})
    public ResponseEntity<?> addVersionToNode(@RequestBody PdServiceDTO pdServiceDTO) throws Exception {
        log.info("[ PdServiceController :: addVersionToNode ]");
        PdServiceEntity pdServiceEntity = (PdServiceEntity)this.modelMapper.map((Object)pdServiceDTO, PdServiceEntity.class);
        this.chat.sendMessageByEngine("\ubc84\uc804\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pdService.addPdServiceVersion(pdServiceEntity)));
    }

    @PutMapping(value={"/updateVersionToNode.do"})
    public ModelAndView updateVersionNode(@RequestBody PdServiceVersionDTO pdServiceVersionDTO, HttpServletRequest request) throws Exception {
        log.info("[ PdServiceController :: updateVersionNode ]");
        PdServiceVersionEntity pdServiceVersionEntity = (PdServiceVersionEntity)this.modelMapper.map((Object)pdServiceVersionDTO, PdServiceVersionEntity.class);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        long pdservice_link = parser.getLong("pdservice_link");
        modelAndView.addObject("result", (Object)this.pdService.updatePdServiceVersion(Long.valueOf(pdservice_link), pdServiceVersionEntity));
        this.chat.sendMessageByEngine("\uc81c\ud488(\uc11c\ube44\uc2a4) \ubc84\uc804\uc774 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        return modelAndView;
    }

    @PostMapping(value={"/uploadFileToNode.do"})
    public ModelAndView uploadFileToNode(MultipartHttpServletRequest multiRequest, HttpServletRequest request) throws Exception {
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        long pdservice_link = parser.getLong("pdservice_link");
        HashMap<String, Set> map = new HashMap<String, Set>();
        map.put("files", this.pdService.uploadFileForPdServiceNode(Long.valueOf(pdservice_link), multiRequest));
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", map);
        return modelAndView;
    }

    @GetMapping(value={"/getVersionList"})
    public ResponseEntity<?> getVersionList(PdServiceDTO pdServiceDTO) throws Exception {
        log.info("[ PdServiceController :: getVersionList ] :: pdServiceDTO.c_id => {}", (Object)pdServiceDTO.getC_id());
        PdServiceEntity pdServiceEntity = (PdServiceEntity)this.modelMapper.map((Object)pdServiceDTO, PdServiceEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pdService.versionListByCId(pdServiceEntity)));
    }

    @GetMapping(value={"/versions-with-date"})
    public ResponseEntity<?> getVersionListWithDate(PdServiceDTO pdServiceDTO) throws Exception {
        log.info("[ PdServiceController :: getVersionListWithDate ] :: pdServiceDTO.c_id => {}", (Object)pdServiceDTO.getC_id());
        PdServiceEntity pdServiceEntity = (PdServiceEntity)this.modelMapper.map((Object)pdServiceDTO, PdServiceEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pdService.versionListWithDateByCId(pdServiceEntity)));
    }

    @GetMapping(value={"/getPdServiceEntityAndVersionList"})
    public ResponseEntity<List<PdServiceAndVersionListDTO>> getPdServiceEntityAndVersionList(PdServiceDTO pdServiceDTO) throws Exception {
        log.info("[ PdServiceController :: getPdServiceEntityAndVersionList ]");
        PdServiceEntity pdServiceEntity = (PdServiceEntity)this.modelMapper.map((Object)pdServiceDTO, PdServiceEntity.class);
        return ResponseEntity.ok((Object)this.pdService.getPdServiceEntityAndVersionList(pdServiceEntity));
    }

    @DeleteMapping(value={"/removeVersion.do"})
    public ModelAndView removeVersion(HttpServletRequest request) throws Exception {
        log.info("[ PdServiceController :: removeVersion ]");
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        long pdServiceID = parser.getLong("pdservice_c_id");
        long versionID = parser.getLong("version_c_id");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.pdService.removeVersionNode(Long.valueOf(pdServiceID), Long.valueOf(versionID)));
        return modelAndView;
    }

    @GetMapping(value={"/getD3ChartData.do"})
    public ResponseEntity<?> getD3ChartData() throws Exception {
        log.info("[ PdServiceController :: getD3ChartData ]");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pdService.getD3ChartData()));
    }

    @PostMapping(value={"/removeAll.do/{pdServiceId}"})
    public ResponseEntity<?> removeAll(@PathVariable(value="pdServiceId") Long pdServiceId) throws Exception {
        log.info("[ PdServiceController :: removeAll ] :: pdServiceId => {}", (Object)pdServiceId);
        int result = this.pdService.removeAll(pdServiceId);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    public PdServiceController(PdService pdService) {
        this.pdService = pdService;
    }
}

