/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.patchnote.service;

import com.arms.api.patchnote.model.PatchnoteDTO;
import com.arms.api.patchnote.model.PatchnoteEntity;
import com.arms.api.patchnote.service.PatchnoteService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import java.util.Date;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="patchnoteService")
public class PatchnoteServiceImpl
extends TreeServiceImpl
implements PatchnoteService {
    private static final Logger log = LoggerFactory.getLogger(PatchnoteServiceImpl.class);
    private final ModelMapper modelMapper;

    @Transactional
    public PatchnoteEntity addPatchnote(PatchnoteDTO patchnoteDTO) throws Exception {
        log.info("[ PatchnoteService :: addPatchnote ] {}", (Object)patchnoteDTO);
        PatchnoteEntity patchnoteEntity = (PatchnoteEntity)this.modelMapper.map((Object)patchnoteDTO, PatchnoteEntity.class);
        patchnoteEntity.setRef(TreeConstant.First_Node_CID.longValue());
        patchnoteEntity.setC_type("default");
        patchnoteEntity.setC_patchnote_created(new Date());
        return (PatchnoteEntity)this.addNode((TreeSearchEntity)patchnoteEntity);
    }

    @Transactional
    public PatchnoteEntity updatePatchnote(PatchnoteDTO patchnoteDTO) throws Exception {
        log.info("[ PatchnoteService :: updatePatchnote ] {}", (Object)patchnoteDTO);
        PatchnoteEntity patchnoteEntity = (PatchnoteEntity)this.modelMapper.map((Object)patchnoteDTO, PatchnoteEntity.class);
        patchnoteEntity.setC_patchnote_updated(new Date());
        this.updateNode((TreeSearchEntity)patchnoteEntity);
        return patchnoteEntity;
    }

    public PatchnoteServiceImpl(ModelMapper modelMapper) {
        this.modelMapper = modelMapper;
    }
}

