/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.newsletter.service;

import com.arms.api.newsletter.model.NewsletterContentsDTO;
import com.arms.api.newsletter.model.NewsletterDTO;
import com.arms.api.newsletter.model.NewsletterEntity;
import com.arms.api.newsletter.service.Newsletter;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="newsletter")
public class NewsletterImpl
extends TreeServiceImpl
implements Newsletter {
    private static final Logger log = LoggerFactory.getLogger(NewsletterImpl.class);
    private final ModelMapper modelMapper;
    private final EngineService engineService;

    @Transactional
    public NewsletterEntity addNewsletter(NewsletterEntity newsletterEntity) throws Exception {
        newsletterEntity.setRef(TreeConstant.First_Node_CID.longValue());
        newsletterEntity.setC_type("default");
        newsletterEntity.setC_newsletter_created(LocalDateTime.now());
        newsletterEntity.setC_newsletter_hit(Integer.valueOf(0));
        NewsletterEntity savedEntity = (NewsletterEntity)this.addNode((TreeSearchEntity)newsletterEntity);
        try {
            ResponseEntity responseEntity = this.engineService.addNewsletter(NewsletterContentsDTO.builder().id(String.valueOf(savedEntity.getC_id())).contents(newsletterEntity.getC_newsletter_contents()).build());
        }
        catch (Exception e) {
            newsletterEntity.setC_newsletter_contents("");
            log.error("Failed to add newsletter with ID: {}", (Object)newsletterEntity);
        }
        return savedEntity;
    }

    @Transactional
    public NewsletterEntity getNewsletter(Long newsletterId) throws Exception {
        NewsletterEntity newsletterEntity = new NewsletterEntity();
        newsletterEntity.setC_id(newsletterId);
        newsletterEntity = (NewsletterEntity)this.getNode((TreeSearchEntity)newsletterEntity);
        try {
            ResponseEntity apiResultResponseEntity = this.engineService.getNewsletter(String.valueOf(newsletterId));
            log.info("apiResultResponseEntity.getBody()={}", apiResultResponseEntity.getBody());
            String contents = Optional.ofNullable((CommonResponse.ApiResult)apiResultResponseEntity.getBody()).map(CommonResponse.ApiResult::getResponse).map(NewsletterContentsDTO::getContents).orElse("");
            newsletterEntity.setC_newsletter_contents(contents);
        }
        catch (Exception e) {
            newsletterEntity.setC_newsletter_contents("");
            log.error("Failed to get newsletter with ID: {}", (Object)newsletterId);
        }
        newsletterEntity.setC_newsletter_hit(Integer.valueOf(Optional.ofNullable(newsletterEntity.getC_newsletter_hit()).orElse(0) + 1));
        this.updateNode((TreeSearchEntity)newsletterEntity);
        return newsletterEntity;
    }

    @Transactional
    public NewsletterEntity updateNewsletter(NewsletterEntity newsletterEntity) throws Exception {
        newsletterEntity.setC_newsletter_updated(LocalDateTime.now());
        int result = this.updateNode((TreeSearchEntity)newsletterEntity);
        if (result != 1) {
            log.error("Failed to update newsletter with ID: {}", (Object)newsletterEntity.getC_id());
            throw new Exception("Failed to update newsletter with ID: " + newsletterEntity.getC_id());
        }
        try {
            ResponseEntity apiResultResponseEntity = this.engineService.updateNewsletter(NewsletterContentsDTO.builder().id(String.valueOf(newsletterEntity.getC_id())).contents(newsletterEntity.getC_newsletter_contents()).build());
            log.info("apiResultResponseEntity.getBody()={}", apiResultResponseEntity.getBody());
        }
        catch (Exception e) {
            newsletterEntity.setC_newsletter_contents("");
            log.error("Failed to update newsletter with ID: {}", (Object)newsletterEntity.getC_id());
        }
        return newsletterEntity;
    }

    @Transactional
    public NewsletterEntity removeNewsletter(Long newsletterId) throws Exception {
        NewsletterEntity newsletterEntity = new NewsletterEntity();
        newsletterEntity.setC_id(newsletterId);
        int result = this.removeNode((TreeSearchEntity)newsletterEntity);
        if (result != 0) {
            log.error("Failed to remove newsletter with ID: {}", (Object)newsletterEntity.getC_id());
            throw new Exception("Failed to remove newsletter with ID: " + newsletterEntity.getC_id());
        }
        try {
            ResponseEntity apiResultResponseEntity = this.engineService.deleteNewsletter(String.valueOf(newsletterId));
            log.info("apiResultResponseEntity.getBody()={}", apiResultResponseEntity.getBody());
        }
        catch (Exception e) {
            log.error("Failed to remove newsletter with ID: {}", (Object)newsletterId);
        }
        return newsletterEntity;
    }

    @Transactional
    public List<NewsletterDTO> getNewsletters(NewsletterEntity newsletterEntity, int pageIndex, int pageUnit) throws Exception {
        this.setDefaultRestriction(newsletterEntity);
        Disjunction orCondition = Restrictions.disjunction();
        if (newsletterEntity.getC_newsletter_etc() != null) {
            orCondition.add((Criterion)Restrictions.like((String)"c_newsletter_etc", (Object)("%" + newsletterEntity.getC_newsletter_etc() + "%")));
            newsletterEntity.getCriterions().add(orCondition);
        }
        newsletterEntity.getOrder().add(Order.desc((String)"c_newsletter_created"));
        newsletterEntity.setPageIndex(pageIndex);
        newsletterEntity.setPageUnit(pageUnit);
        List<NewsletterDTO> newsletterDTOList = this.getPaginatedChildNode((TreeSearchEntity)newsletterEntity).stream().map(entity -> {
            NewsletterDTO dto = (NewsletterDTO)this.modelMapper.map(entity, NewsletterDTO.class);
            Document doc = Jsoup.parse((String)dto.getC_newsletter_contents());
            Element firstImage = doc.selectFirst("img");
            if (firstImage != null) {
                dto.setC_newsletter_thumbnail_url(firstImage.attr("src"));
                dto.setC_newsletter_thumbnail_alt(firstImage.attr("alt"));
                doc.select("img").remove();
                doc.select("p, div").stream().filter(e -> e.text().trim().isEmpty()).filter(e -> e.html().replace("&nbsp;", "").trim().isEmpty()).forEach(Node::remove);
                dto.setC_newsletter_contents(doc.body().html());
            }
            return dto;
        }).collect(Collectors.toList());
        return newsletterDTOList;
    }

    public Long getNewsletterCount(NewsletterEntity newsletterEntity) throws Exception {
        this.setDefaultRestriction(newsletterEntity);
        Disjunction orCondition = Restrictions.disjunction();
        if (newsletterEntity.getC_newsletter_etc() != null) {
            orCondition.add((Criterion)Restrictions.like((String)"c_newsletter_etc", (String)newsletterEntity.getC_newsletter_etc(), (MatchMode)MatchMode.ANYWHERE));
            newsletterEntity.getCriterions().add(orCondition);
        }
        return this.getNodesWithoutRoot((TreeSearchEntity)newsletterEntity).stream().count();
    }

    @Transactional
    public List<NewsletterDTO> getPopularNewsletters(NewsletterEntity newsletterEntity, int pageIndex, int pageUnit) throws Exception {
        this.setDefaultRestriction(newsletterEntity);
        newsletterEntity.getOrder().add(Order.desc((String)"c_newsletter_hit"));
        newsletterEntity.setPageIndex(pageIndex);
        newsletterEntity.setPageUnit(pageUnit);
        List paginatedChildNode = this.getPaginatedChildNode((TreeSearchEntity)newsletterEntity);
        ArrayList<NewsletterDTO> newsletterDTOList = new ArrayList<NewsletterDTO>();
        for (NewsletterEntity entity : paginatedChildNode) {
            NewsletterDTO dto = (NewsletterDTO)this.modelMapper.map((Object)entity, NewsletterDTO.class);
            Document doc = Jsoup.parse((String)dto.getC_newsletter_contents());
            Element firstImage = doc.selectFirst("img");
            if (firstImage != null) {
                dto.setC_newsletter_thumbnail_url(firstImage.attr("src"));
                dto.setC_newsletter_thumbnail_alt(firstImage.attr("alt"));
                doc.select("img").remove();
                Elements selected = doc.select("p, div");
                for (Element e : selected) {
                    if (e.text().trim().isEmpty()) {
                        e.remove();
                        continue;
                    }
                    if (!e.html().replace("&nbsp;", "").trim().isEmpty()) continue;
                    e.remove();
                }
            }
            dto.setC_newsletter_contents(doc.body().html());
            newsletterDTOList.add(dto);
        }
        return newsletterDTOList;
    }

    private void setDefaultRestriction(NewsletterEntity newsletterEntity) {
        newsletterEntity.getCriterions().add(Restrictions.eq((String)"c_type", (Object)"default"));
    }

    public NewsletterImpl(ModelMapper modelMapper, EngineService engineService) {
        this.modelMapper = modelMapper;
        this.engineService = engineService;
    }
}

