/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.newsletter.controller;

import com.arms.api.newsletter.model.NewsletterDTO;
import com.arms.api.newsletter.model.NewsletterEntity;
import com.arms.api.newsletter.service.Newsletter;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RestController
@RequestMapping(value={"/anonymous/cover/newsletter"})
public class NewsletterController
extends TreeAbstractController<Newsletter, NewsletterDTO, NewsletterEntity> {
    private static final Logger log = LoggerFactory.getLogger(NewsletterController.class);
    private final Newsletter newsletter;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.newsletter);
        this.setTreeEntity(NewsletterEntity.class);
    }

    @PostMapping(value={"/addNewsletter"})
    public ResponseEntity<?> addNewsletter(@Validated(value={AddNode.class}) NewsletterDTO newsletterDTO) throws Exception {
        log.info("[ NewsletterController :: addNewsletter ]");
        NewsletterEntity newsletterEntity = (NewsletterEntity)this.modelMapper.map((Object)newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.newsletter.addNewsletter(newsletterEntity)));
    }

    @GetMapping(value={"/getNewsletter/{newsletterId}"})
    public ResponseEntity<?> getNewsletter(@PathVariable(value="newsletterId") Long newsletterId) throws Exception {
        log.info("[ NewsletterController :: getNewsletter ]");
        return ResponseEntity.ok((Object)this.newsletter.getNewsletter(newsletterId));
    }

    @PutMapping(value={"/updateNewsletter"})
    public ResponseEntity<?> updateNewsletter(NewsletterDTO newsletterDTO) throws Exception {
        log.info("[ NewsletterController :: updateNewsletter ]");
        NewsletterEntity newsletterEntity = (NewsletterEntity)this.modelMapper.map((Object)newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.newsletter.updateNewsletter(newsletterEntity)));
    }

    @DeleteMapping(value={"/removeNewsletter/{newsletterId}"})
    public ResponseEntity<?> removeNewsletter(@PathVariable(value="newsletterId") Long newsletterId) throws Exception {
        log.info("[ NewsletterController :: removeNewsletter ]");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.newsletter.removeNewsletter(newsletterId)));
    }

    @GetMapping(value={"/getNewsletters"})
    public ResponseEntity<?> getNewsletters(NewsletterDTO newsletterDTO, @RequestParam int pageIndex, @RequestParam int pageUnit) throws Exception {
        log.info("[ NewsletterController :: getNewsletters ]");
        NewsletterEntity newsletterEntity = (NewsletterEntity)this.modelMapper.map((Object)newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok((Object)this.newsletter.getNewsletters(newsletterEntity, pageIndex, pageUnit));
    }

    @GetMapping(value={"/getPopularNewsletters"})
    public ResponseEntity<?> getPopularNewsletters(NewsletterDTO newsletterDTO, @RequestParam int pageIndex, @RequestParam int pageUnit) throws Exception {
        log.info("[ NewsletterController :: getPopularNewsletters ]");
        NewsletterEntity newsletterEntity = (NewsletterEntity)this.modelMapper.map((Object)newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok((Object)this.newsletter.getPopularNewsletters(newsletterEntity, pageIndex, pageUnit));
    }

    @GetMapping(value={"/countNewsletters"})
    public ResponseEntity<?> countNewsletters(NewsletterDTO newsletterDTO) throws Exception {
        log.info("[ NewsletterController :: countNewsletters ]");
        NewsletterEntity newsletterEntity = (NewsletterEntity)this.modelMapper.map((Object)newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok((Object)this.newsletter.getNewsletterCount(newsletterEntity));
    }

    public NewsletterController(Newsletter newsletter) {
        this.newsletter = newsletter;
    }
}

