/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.jira.jiraserver_pure.service;

import com.arms.api.jira.jiraserver.model.AlmAccount;
import com.arms.api.jira.jiraserver_pure.model.JiraServerPureEntity;
import com.arms.api.jira.jiraserver_pure.model.VerifyALMAccountDTO;
import com.arms.api.jira.jiraserver_pure.service.JiraServerPure;
import com.arms.api.util.aes.AES256Encryption;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.request.ServerInfo;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jiraServerPure")
public class JiraServerPureImpl
extends TreeServiceImpl
implements JiraServerPure {
    @Autowired
    private EngineService engineService;
    @Autowired
    private AES256Encryption aes256Encryption;

    public Map<String, String> ALM\uc11c\ubc84_\uc544\uc774\ub514_\uc11c\ubc84\uc720\ud615_\ub9f5_\uac00\uc838\uc624\uae30() {
        return this.engineService.\uc11c\ubc84_\uc5f0\uacb0\uc544\uc774\ub514_\uc720\ud615\uc815\ubcf4_\ub9f5_\uc870\ud68c();
    }

    @Transactional(readOnly=true)
    public List<JiraServerPureEntity> getNodesWithoutRoot(JiraServerPureEntity jiraServerPureEntity) throws Exception {
        jiraServerPureEntity.setOrder(Order.desc((String)"c_id"));
        Criterion criterion = Restrictions.not((Criterion)Restrictions.in((String)"c_id", (Object[])new Object[]{TreeConstant.ROOT_CID, TreeConstant.First_Node_CID}));
        jiraServerPureEntity.getCriterions().add(criterion);
        return this.getChildNode((TreeSearchEntity)jiraServerPureEntity);
    }

    public AlmAccount verifyNewALMServerAccount(VerifyALMAccountDTO accountDTO) {
        ServerInfo serverInfo = ServerInfo.builder().uri(accountDTO.getUri()).type(accountDTO.getType()).userId(accountDTO.getUserId()).passwordOrToken(this.aes256Encryption.encrypt(accountDTO.getPasswordOrToken())).build();
        return (AlmAccount)this.engineService.verifyAccount(serverInfo).getBody();
    }

    public AlmAccount verifyExistingALMServerAccount(VerifyALMAccountDTO accountDTO) throws Exception {
        JiraServerPureEntity entityForSearch = new JiraServerPureEntity();
        entityForSearch.setC_id(accountDTO.getServerCId());
        JiraServerPureEntity fetchedEntity = (JiraServerPureEntity)this.getNode((TreeSearchEntity)entityForSearch);
        String encryptedPW = fetchedEntity.getC_jira_server_connect_pw();
        ServerInfo serverInfo = ServerInfo.builder().uri(accountDTO.getUri()).type(accountDTO.getType()).userId(accountDTO.getUserId()).passwordOrToken(encryptedPW).build();
        return (AlmAccount)this.engineService.verifyAccount(serverInfo).getBody();
    }

    public JiraServerPureImpl(EngineService engineService, AES256Encryption aes256Encryption) {
        this.engineService = engineService;
        this.aes256Encryption = aes256Encryption;
    }
}

