/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.jira.jiraserver_pure.controller;

import com.arms.api.jira.jiraserver.model.JiraServerDTO;
import com.arms.api.jira.jiraserver_pure.model.JiraServerPureDTO;
import com.arms.api.jira.jiraserver_pure.model.JiraServerPureEntity;
import com.arms.api.jira.jiraserver_pure.model.VerifyALMAccountDTO;
import com.arms.api.jira.jiraserver_pure.service.JiraServerPure;
import com.arms.api.util.aes.AES256Decryption;
import com.arms.api.util.aes.AES256Encryption;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/arms/jiraServerPure"})
public class JiraServerPureController
extends TreeAbstractController<JiraServerPure, JiraServerPureDTO, JiraServerPureEntity> {
    private static final Logger log = LoggerFactory.getLogger(JiraServerPureController.class);
    @Autowired
    @Qualifier(value="jiraServerPure")
    private JiraServerPure jiraServerPure;
    @Autowired
    AES256Decryption aes256Decryption;
    @Autowired
    AES256Encryption aes256Encryption;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.jiraServerPure);
        this.setTreeEntity(JiraServerPureEntity.class);
    }

    @ResponseBody
    @RequestMapping(value={"/getNodeExceptPW.do"}, method={RequestMethod.GET})
    public ResponseEntity<JiraServerPureEntity> getNodeWithoutPW(JiraServerPureDTO jiraServerPureDTO) throws Exception {
        log.info("JiraServerPureController :: getNodeWithoutPW");
        JiraServerPureEntity jiraServerPureEntity = (JiraServerPureEntity)this.modelMapper.map((Object)jiraServerPureDTO, JiraServerPureEntity.class);
        JiraServerPureEntity fetchedEntity = (JiraServerPureEntity)this.jiraServerPure.getNode((TreeSearchEntity)jiraServerPureEntity);
        fetchedEntity.setC_jira_server_connect_pw(null);
        return ResponseEntity.ok((Object)fetchedEntity);
    }

    @ResponseBody
    @PostMapping(value={"/verifyAccount.do"})
    public ResponseEntity<?> verifyALMAccount(@RequestBody VerifyALMAccountDTO accountDTO) {
        log.info("JiraServerController :: verifyALMAccount");
        try {
            return ResponseEntity.ok((Object)CommonResponse.success((Object)this.jiraServerPure.verifyExistingALMServerAccount(accountDTO)));
        }
        catch (Exception e) {
            log.error("[JiraServerController :: verifyALMAccount] :: error occurred :: {} ", (Object)e.getMessage());
            CommonResponse.ApiResult errorResult = CommonResponse.error((String)e.getMessage(), (HttpStatus)HttpStatus.BAD_REQUEST);
            return new ResponseEntity((Object)errorResult, HttpStatus.BAD_REQUEST);
        }
    }

    @ResponseBody
    @PostMapping(value={"/verifyNewAccount.do"})
    public ResponseEntity<?> verifyNewALMAccount(@RequestBody VerifyALMAccountDTO accountDTO) {
        log.info("JiraServerController :: verifyNewALMAccount");
        try {
            return ResponseEntity.ok((Object)CommonResponse.success((Object)this.jiraServerPure.verifyNewALMServerAccount(accountDTO)));
        }
        catch (Exception e) {
            log.error("[JiraServerController :: verifyNewALMAccount] :: error occurred :: {} ", (Object)e.getMessage());
            CommonResponse.ApiResult errorResult = CommonResponse.error((String)e.getMessage(), (HttpStatus)HttpStatus.BAD_REQUEST);
            return new ResponseEntity((Object)errorResult, HttpStatus.BAD_REQUEST);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/getNodeWithDecryption.do"}, method={RequestMethod.GET})
    public ResponseEntity<JiraServerPureEntity> getNodeWithDecryption(JiraServerPureDTO jiraServerPureDTO) throws Exception {
        log.info("JiraServerPureController :: getNodeWithDecryption");
        JiraServerPureEntity jiraServerPureEntity = (JiraServerPureEntity)this.modelMapper.map((Object)jiraServerPureDTO, JiraServerPureEntity.class);
        JiraServerPureEntity fetchedEntity = (JiraServerPureEntity)this.jiraServerPure.getNode((TreeSearchEntity)jiraServerPureEntity);
        log.info("[JiraServerPureController :: getNodeWithDecryption] :: fetchedEntity.connectId => {}, fetchedEntity.connectPw => {}", (Object)fetchedEntity.getC_jira_server_connect_id(), (Object)fetchedEntity.getC_jira_server_connect_pw());
        String decryptedAlmConnectId = fetchedEntity.getC_jira_server_connect_id();
        String decryptedAlmConnectPw = this.aes256Decryption.decrypt(fetchedEntity.getC_jira_server_connect_pw());
        log.info("[JiraServerPureController :: getNodeWithDecryption] :: fetchedEntity.decryptedAlmConnectId => {}, fetchedEntity.decryptedAlmConnectPw => {}", (Object)decryptedAlmConnectId, (Object)decryptedAlmConnectPw);
        fetchedEntity.setC_jira_server_connect_id(decryptedAlmConnectId);
        fetchedEntity.setC_jira_server_connect_pw(decryptedAlmConnectPw);
        return ResponseEntity.ok((Object)fetchedEntity);
    }

    @ResponseBody
    @GetMapping(value={"/getJiraServerMonitor.do"})
    public ResponseEntity<List<JiraServerPureEntity>> getJiraServerMonitor(JiraServerDTO jiraServerDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("JiraServerPureController :: getJiraServerMonitor");
        JiraServerPureEntity jiraServerEntity = (JiraServerPureEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerPureEntity.class);
        return ResponseEntity.ok((Object)this.jiraServerPure.getNodesWithoutRoot(jiraServerEntity));
    }

    @ResponseBody
    @RequestMapping(value={"/serverTypeMap.do"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> getServerTypeMap(JiraServerDTO jiraServerDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("JiraServerPureController :: getServerTypeMap");
        return ResponseEntity.ok((Object)this.jiraServerPure.ALM\uc11c\ubc84_\uc544\uc774\ub514_\uc11c\ubc84\uc720\ud615_\ub9f5_\uac00\uc838\uc624\uae30());
    }

    @ResponseBody
    @RequestMapping(value={"/makeEncryption.do"}, method={RequestMethod.GET})
    public ResponseEntity<String> makeEncryption(String str) throws Exception {
        log.info("JiraServerPureController :: getServerTypeMap");
        return ResponseEntity.ok((Object)this.aes256Encryption.encrypt(str));
    }
}

