/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.jira.jiraserver.service;

import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalTreeMapService;
import com.arms.api.jira.jiraissuepriority.model.JiraIssuePriorityEntity;
import com.arms.api.jira.jiraissuepriority.service.JiraIssuePriority;
import com.arms.api.jira.jiraissueresolution.model.JiraIssueResolutionEntity;
import com.arms.api.jira.jiraissueresolution.service.JiraIssueResolution;
import com.arms.api.jira.jiraissuestatus.model.JiraIssueStatusEntity;
import com.arms.api.jira.jiraissuestatus.model.StatusRuleSetEntity;
import com.arms.api.jira.jiraissuestatus.service.JiraIssueStatus;
import com.arms.api.jira.jiraissuestatuscategorymap.model.JiraIssueStatusCategoryMapEntity;
import com.arms.api.jira.jiraissuestatuscategorymap.service.JiraIssueStatusCategoryMap;
import com.arms.api.jira.jiraissuetype.model.JiraIssueTypeEntity;
import com.arms.api.jira.jiraissuetype.service.JiraIssueType;
import com.arms.api.jira.jiraproject.model.JiraProjectEntity;
import com.arms.api.jira.jiraproject.service.JiraProject;
import com.arms.api.jira.jiraproject_pure.model.JiraProjectPureEntity;
import com.arms.api.jira.jiraserver.model.JiraServerEntity;
import com.arms.api.jira.jiraserver.model.enums.EntityType;
import com.arms.api.jira.jiraserver.model.enums.ServerType;
import com.arms.api.jira.jiraserver.model.pure.JiraServerIssuePriorityOnlyEntity;
import com.arms.api.jira.jiraserver.model.pure.JiraServerIssueStatusOnlyEntity;
import com.arms.api.jira.jiraserver.model.pure.JiraServerIssueTypeOnlyEntity;
import com.arms.api.jira.jiraserver.model.pure.JiraServerProjectOnlyEntity;
import com.arms.api.jira.jiraserver.service.JiraServer;
import com.arms.api.jira.jiraserver.service.JiraServerImpl;
import com.arms.api.util.aes.AES256Encryption;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.MiddleProxyService;
import com.arms.api.util.communicate.external.request.ServerInfo;
import com.arms.api.util.communicate.external.request.redis.AlmDataRequestDTO;
import com.arms.api.util.communicate.external.request.redis.IssueStatusDTO;
import com.arms.api.util.communicate.external.response.jira.ALM_\ub370\uc774\ud130;
import com.arms.api.util.communicate.external.response.jira.ServerInfoEntity;
import com.arms.api.util.communicate.external.response.jira.\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130;
import com.arms.api.util.communicate.external.response.jira.\uc9c0\ub77c\uc774\uc288\uc6b0\uc120\uc21c\uc704_\ub370\uc774\ud130;
import com.arms.api.util.communicate.external.response.jira.\uc9c0\ub77c\uc774\uc288\uc720\ud615_\ub370\uc774\ud130;
import com.arms.api.util.communicate.external.response.jira.\uc9c0\ub77c\uc774\uc288\ud574\uacb0\ucc45_\ub370\uc774\ud130;
import com.arms.api.util.communicate.external.response.jira.\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ub370\uc774\ud130;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.model.TreeBaseEntity;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.remote.Global;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import com.arms.egovframework.javaservice.treeframework.util.Util_TitleChecker;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="jiraServer")
public class JiraServerImpl
extends TreeServiceImpl
implements JiraServer {
    private static final Logger log = LoggerFactory.getLogger(JiraServerImpl.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private final GlobalTreeMapService globalTreeMapService;
    private final EngineService engineService;
    private final MiddleProxyService middleProxyService;
    private final JiraProject jiraProject;
    private final JiraIssueType jiraIssueType;
    private final JiraIssueStatus jiraIssueStatus;
    private final JiraIssuePriority jiraIssuePriority;
    private final JiraIssueResolution jiraIssueResolution;
    private final JiraIssueStatusCategoryMap jiraIssueStatusCategoryMap;
    private final AES256Encryption aes256Encryption;

    @Transactional
    public JiraServerEntity setDefaultValueForTarget(EntityType entityType, Long targetCId, JiraServerEntity searchEntity) throws Exception {
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.getNode((TreeSearchEntity)searchEntity);
        if (jiraServerEntity == null) {
            throw new Exception(String.valueOf(entityType) + " \ud56d\ubaa9 \uae30\ubcf8\uac12 \uc124\uc815\uc5d0 \ud544\uc694\ud55c \uc11c\ubc84 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. :: " + targetCId);
        }
        if (EntityType.\uc774\uc288\uc720\ud615 == entityType) {
            Optional.ofNullable(jiraServerEntity.getJiraIssueTypeEntities()).orElse(Collections.emptySet()).forEach(issueType -> {
                if (Objects.equals(issueType.getC_id(), targetCId)) {
                    issueType.setC_check("true");
                } else {
                    issueType.setC_check("false");
                }
            });
        }
        if (EntityType.\uc774\uc288\uc0c1\ud0dc == entityType) {
            Optional.ofNullable(jiraServerEntity.getJiraIssueStatusEntities()).orElse(Collections.emptySet()).forEach(issueStatus -> {
                if (Objects.equals(issueStatus.getC_id(), targetCId)) {
                    issueStatus.setC_check("true");
                } else {
                    issueStatus.setC_check("false");
                }
            });
        }
        if (EntityType.\uc774\uc288\uc6b0\uc120\uc21c\uc704 == entityType) {
            Optional.ofNullable(jiraServerEntity.getJiraIssuePriorityEntities()).orElse(Collections.emptySet()).forEach(issuePriority -> {
                if (Objects.equals(issuePriority.getC_id(), targetCId)) {
                    issuePriority.setC_check("true");
                } else {
                    issuePriority.setC_check("false");
                }
            });
        }
        if (EntityType.\uc774\uc288\ud574\uacb0\ucc45 == entityType) {
            Optional.ofNullable(jiraServerEntity.getJiraIssueResolutionEntities()).orElse(Collections.emptySet()).forEach(issueResolution -> {
                if (Objects.equals(issueResolution.getC_id(), targetCId)) {
                    issueResolution.setC_check("true");
                } else {
                    issueResolution.setC_check("false");
                }
            });
        }
        this.updateNode((TreeSearchEntity)jiraServerEntity);
        return jiraServerEntity;
    }

    public List<JiraProjectPureEntity> getProjectPureList(JiraServerEntity jiraServerEntity) throws Exception {
        JiraServerProjectOnlyEntity searchEntity = new JiraServerProjectOnlyEntity();
        searchEntity.setC_id(jiraServerEntity.getC_id());
        JiraServerProjectOnlyEntity jiraServerProjectOnlyEntity = (JiraServerProjectOnlyEntity)this.getNode((TreeSearchEntity)searchEntity);
        List<JiraProjectPureEntity> projectPureList = Optional.ofNullable(jiraServerProjectOnlyEntity.getJiraProjectPureEntities()).orElseGet(Collections::emptySet).stream().filter(Objects::nonNull).filter(project -> project.getC_etc() == null || !StringUtils.equals((String)"delete", (String)project.getC_etc())).collect(Collectors.toList());
        return projectPureList;
    }

    public List<JiraIssueTypeEntity> getIssueTypeOnlyList(JiraServerEntity jiraServerEntity) throws Exception {
        JiraServerIssueTypeOnlyEntity searchEntity = new JiraServerIssueTypeOnlyEntity();
        searchEntity.setC_id(jiraServerEntity.getC_id());
        JiraServerIssueTypeOnlyEntity jiraServerIssueTypeOnlyEntity = (JiraServerIssueTypeOnlyEntity)this.getNode((TreeSearchEntity)searchEntity);
        List<JiraIssueTypeEntity> issueTypeList = Optional.ofNullable(jiraServerIssueTypeOnlyEntity.getJiraIssueTypeEntities()).orElseGet(Collections::emptySet).stream().filter(Objects::nonNull).filter(issueType -> issueType.getC_etc() == null || !StringUtils.equals((String)"delete", (String)issueType.getC_etc())).filter(issueType -> issueType.getC_desc() == null || !StringUtils.equals((String)"true", (String)issueType.getC_desc())).collect(Collectors.toList());
        return issueTypeList;
    }

    public List<JiraIssueStatusEntity> getServerIssueStatusOnlyList(JiraServerEntity jiraServerEntity) throws Exception {
        JiraServerIssueStatusOnlyEntity searchEntity = new JiraServerIssueStatusOnlyEntity();
        searchEntity.setC_id(jiraServerEntity.getC_id());
        JiraServerIssueStatusOnlyEntity jiraServerIssueStatusOnlyEntity = (JiraServerIssueStatusOnlyEntity)this.getNode((TreeSearchEntity)searchEntity);
        List<JiraIssueStatusEntity> jiraIssueStatusList = Optional.ofNullable(jiraServerIssueStatusOnlyEntity.getJiraIssueStatusEntities()).orElseGet(Collections::emptySet).stream().filter(Objects::nonNull).filter(issueStatus -> issueStatus.getC_etc() == null || !StringUtils.equals((String)"delete", (String)issueStatus.getC_etc())).collect(Collectors.toList());
        return jiraIssueStatusList;
    }

    public List<JiraIssuePriorityEntity> getServerIssuePriorityOnlyList(JiraServerEntity jiraServerEntity) throws Exception {
        JiraServerIssuePriorityOnlyEntity searchEntity = new JiraServerIssuePriorityOnlyEntity();
        searchEntity.setC_id(jiraServerEntity.getC_id());
        JiraServerIssuePriorityOnlyEntity jiraServerIssuePriorityOnlyEntity = (JiraServerIssuePriorityOnlyEntity)this.getNode((TreeSearchEntity)searchEntity);
        List<JiraIssuePriorityEntity> issuePriorityList = Optional.ofNullable(jiraServerIssuePriorityOnlyEntity.getJiraIssuePriorityEntities()).orElseGet(Collections::emptySet).stream().filter(Objects::nonNull).filter(issuePriority -> issuePriority.getC_etc() == null || !StringUtils.equals((String)"delete", (String)issuePriority.getC_etc())).collect(Collectors.toList());
        return issuePriorityList;
    }

    public List<JiraIssueResolutionEntity> getServerIssueResolutionList(JiraServerEntity jiraServerEntity) throws Exception {
        GlobalTreeMapEntity searchEntity = new GlobalTreeMapEntity();
        searchEntity.setJiraserver_link(jiraServerEntity.getC_id());
        List globalTreeMapList = this.globalTreeMapService.findAllBy(searchEntity);
        ArrayList<Long> issueResolutionCIdList = new ArrayList<Long>();
        for (GlobalTreeMapEntity globalTreeMapEntity : globalTreeMapList) {
            if (globalTreeMapEntity.getJiraissueresolution_link() == null) continue;
            issueResolutionCIdList.add(globalTreeMapEntity.getJiraissueresolution_link());
        }
        JiraIssueResolutionEntity issueResolutionEntity = new JiraIssueResolutionEntity();
        Criterion criterion1 = Restrictions.in((String)"c_id", issueResolutionCIdList);
        LogicalExpression criterion2 = Restrictions.or((Criterion)Restrictions.isNull((String)"c_etc"), (Criterion)Restrictions.ne((String)"c_etc", (Object)"delete"));
        LogicalExpression criterion = Restrictions.and((Criterion)criterion1, (Criterion)criterion2);
        issueResolutionEntity.getCriterions().add(criterion);
        List issueResolutionList = this.jiraIssueResolution.getChildNode((TreeSearchEntity)issueResolutionEntity);
        return issueResolutionList;
    }

    @Transactional
    public int updateArmsAndEngineServerData(JiraServerEntity updateServerEntity) throws Exception {
        if (updateServerEntity.getC_jira_server_connect_pw() != null && !updateServerEntity.getC_jira_server_connect_pw().trim().isEmpty()) {
            updateServerEntity.setC_jira_server_connect_pw(this.aes256Encryption.encrypt(updateServerEntity.getC_jira_server_connect_pw()));
        }
        int result = this.updateNode((TreeSearchEntity)updateServerEntity);
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.getNode((TreeSearchEntity)updateServerEntity);
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setConnectId(jiraServerEntity.getC_jira_server_etc());
        serverInfo.setType(jiraServerEntity.getC_jira_server_type());
        serverInfo.setUri(jiraServerEntity.getC_jira_server_base_url());
        serverInfo.setUserId(jiraServerEntity.getC_jira_server_connect_id());
        serverInfo.setPasswordOrToken(jiraServerEntity.getC_jira_server_connect_pw());
        ServerInfoEntity updateResult = this.engineService.registerOrUpdateAlmServerInfo(serverInfo);
        if (updateResult != null) {
            log.info(" [ " + this.getClass().getName() + " :: \uc554\uc2a4_\ubc0f_\uc5d4\uc9c4_\uc11c\ubc84\uc815\ubcf4\uc218\uc815 ] :: \uc218\uc815\uacb0\uacfc -> " + updateResult.toString());
        }
        return result;
    }

    @Transactional
    public JiraServerEntity addJiraServer(JiraServerEntity jiraServerEntity) throws Exception {
        String randomConnectId = String.valueOf(RANDOM.nextLong() & Long.MAX_VALUE);
        if (jiraServerEntity.getC_jira_server_connect_pw() != null && !jiraServerEntity.getC_jira_server_connect_pw().trim().isEmpty()) {
            jiraServerEntity.setC_jira_server_connect_pw(this.aes256Encryption.encrypt(jiraServerEntity.getC_jira_server_connect_pw()));
        }
        String serverUrl = StringUtils.removeTrailingSlash((String)jiraServerEntity.getC_jira_server_base_url());
        jiraServerEntity.setC_jira_server_base_url(serverUrl);
        jiraServerEntity.setC_title(Util_TitleChecker.StringReplace((String)jiraServerEntity.getC_title()));
        jiraServerEntity.setC_jira_server_etc(randomConnectId);
        JiraServerEntity addedNodeEntity = (JiraServerEntity)this.addNode((TreeSearchEntity)jiraServerEntity);
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setConnectId(randomConnectId);
        serverInfo.setType(addedNodeEntity.getC_jira_server_type());
        serverInfo.setUri(addedNodeEntity.getC_jira_server_base_url());
        serverInfo.setUserId(addedNodeEntity.getC_jira_server_connect_id());
        serverInfo.setPasswordOrToken(addedNodeEntity.getC_jira_server_connect_pw());
        ServerInfoEntity result = this.engineService.registerOrUpdateAlmServerInfo(serverInfo);
        if (result != null) {
            log.info(" [ \uc554\uc2a4_\ubc0f_\uc5d4\uc9c4_\uc11c\ubc84\uc815\ubcf4\ub4f1\ub85d ] :: \ub4f1\ub85d\uacb0\uacfc -> " + result.toString());
            Global.chat.sendMessageByEngine("\uc11c\ubc84 \ub4f1\ub85d\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. ALM \uc11c\ubc84 \ub370\uc774\ud130 \uac31\uc2e0\uc5d0 \uc2dc\uac04\uc774 \uac78\ub9b4 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
        }
        return addedNodeEntity;
    }

    @Transactional
    public JiraServerEntity \uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ud56d\ubaa9\ubcc4_\uac31\uc2e0(EntityType \uac31\uc2e0\ud560_\ud56d\ubaa9, String projectCId, JiraServerEntity jiraServerEntity) throws Exception {
        Object \uac31\uc2e0_\uba54\uc138\uc9c0;
        JiraServerEntity \uac80\uc0c9\uc6a9_\uc11c\ubc84_\uc5d4\ud2f0\ud2f0 = new JiraServerEntity();
        \uac80\uc0c9\uc6a9_\uc11c\ubc84_\uc5d4\ud2f0\ud2f0.setC_id(jiraServerEntity.getC_id());
        JiraServerEntity \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84 = (JiraServerEntity)this.getNode((TreeSearchEntity)\uac80\uc0c9\uc6a9_\uc11c\ubc84_\uc5d4\ud2f0\ud2f0);
        if (\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84 == null || \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_type() == null || \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_etc() == null) {
            throw new Exception("\uac31\uc2e0\uc5d0 \ud544\uc694\ud55c \uc11c\ubc84 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        String \uc11c\ubc84\uc720\ud615 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_type();
        log.info("[ JiraServerImpl :: \uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ud56d\ubaa9\ubcc4_\uac31\uc2e0 ] :: \uac31\uc2e0\ud560_\ud56d\ubaa9 \u2192 {}, \uc11c\ubc84\uc720\ud615 \u2192 {}", (Object)\uac31\uc2e0\ud560_\ud56d\ubaa9.getType(), (Object)\uc11c\ubc84\uc720\ud615);
        switch (1.$SwitchMap$com$arms$api$jira$jiraserver$model$enums$EntityType[\uac31\uc2e0\ud560_\ud56d\ubaa9.ordinal()]) {
            case 1: {
                \uac31\uc2e0_\uba54\uc138\uc9c0 = this.\ud504\ub85c\uc81d\ud2b8_\uac31\uc2e0(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84);
                break;
            }
            case 2: {
                \uac31\uc2e0_\uba54\uc138\uc9c0 = this.\uc774\uc288\uc720\ud615_\uac31\uc2e0(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, projectCId);
                break;
            }
            case 3: {
                \uac31\uc2e0_\uba54\uc138\uc9c0 = this.\uc774\uc288\uc0c1\ud0dc_\uac31\uc2e0(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, projectCId);
                break;
            }
            case 4: {
                \uac31\uc2e0_\uba54\uc138\uc9c0 = this.\uc774\uc288\uc6b0\uc120\uc21c\uc704_\uac31\uc2e0(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84);
                break;
            }
            case 5: {
                \uac31\uc2e0_\uba54\uc138\uc9c0 = this.\uc774\uc288\ud574\uacb0\ucc45_\uac31\uc2e0(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84);
                break;
            }
            default: {
                throw new IllegalArgumentException("\uc54c \uc218 \uc5c6\ub294 \uac31\uc2e0 \ud56d\ubaa9: " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9));
            }
        }
        if (\uac31\uc2e0_\uba54\uc138\uc9c0 == null) {
            this.updateNode((TreeSearchEntity)\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84);
            \uac31\uc2e0_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        }
        Global.chat.sendMessageByEngine((String)\uac31\uc2e0_\uba54\uc138\uc9c0);
        return \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84;
    }

    private String \ud504\ub85c\uc81d\ud2b8_\uac31\uc2e0(JiraServerEntity \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84) {
        List \uac00\uc838\uc628_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d;
        EntityType \uac31\uc2e0\ud560_\ud56d\ubaa9 = EntityType.\ud504\ub85c\uc81d\ud2b8;
        String \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_etc();
        Set \ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = Optional.ofNullable(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraProjectEntities()).orElse(new HashSet());
        Map<String, JiraProjectEntity> \uae30\uc874\ud504\ub85c\uc81d\ud2b8_\ub9f5 = \ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\ud504\ub85c\uc81d\ud2b82 -> \ud504\ub85c\uc81d\ud2b82.getC_jira_url(), \ud504\ub85c\uc81d\ud2b82 -> \ud504\ub85c\uc81d\ud2b82));
        try {
            \uac00\uc838\uc628_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = this.engineService.ALM_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d_\uac00\uc838\uc624\uae30(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514);
        }
        catch (Exception e) {
            String \uc624\ub958_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0 \uc2e4\ud328\ud558\uc2b5\ub2c8\ub2e4." + e.getMessage();
            log.error(\uc624\ub958_\uba54\uc138\uc9c0);
            return \uc624\ub958_\uba54\uc138\uc9c0;
        }
        Set \ud504\ub85c\uc81d\ud2b8_\ub3d9\uae30\ud654\ubaa9\ub85d = this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(\ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d, \uae30\uc874\ud504\ub85c\uc81d\ud2b8_\ub9f5, \uac00\uc838\uc628_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d, \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \uac31\uc2e0\ud560_\ud56d\ubaa9);
        \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraProjectEntities(\ud504\ub85c\uc81d\ud2b8_\ub3d9\uae30\ud654\ubaa9\ub85d);
        return null;
    }

    private String \uc774\uc288\uc720\ud615_\uac31\uc2e0(JiraServerEntity \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, String \ud504\ub85c\uc81d\ud2b8_C\uc544\uc774\ub514) throws Exception {
        EntityType \uac31\uc2e0\ud560_\ud56d\ubaa9 = EntityType.\uc774\uc288\uc720\ud615;
        String \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_etc();
        String \uc11c\ubc84\uc720\ud615 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_type();
        if (StringUtils.equals((String)ServerType.JIRA_ON_PREMISE.getType(), (String)\uc11c\ubc84\uc720\ud615)) {
            List \uac00\uc838\uc628_\uc774\uc288\uc720\ud615_\ubaa9\ub85d;
            Set \ud574\ub2f9_\uc11c\ubc84_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = Optional.ofNullable(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraIssueTypeEntities()).orElse(new HashSet());
            Map<String, JiraIssueTypeEntity> \uae30\uc874\uc774\uc288\uc720\ud615_\ub9f5 = \ud574\ub2f9_\uc11c\ubc84_\uc774\uc288\uc720\ud615_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152.getC_issue_type_url(), \uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152));
            try {
                \uac00\uc838\uc628_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = this.engineService.ALM_\uc774\uc288_\uc720\ud615_\uac00\uc838\uc624\uae30(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514);
            }
            catch (Exception e) {
                String \uc624\ub958_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0 \uc2e4\ud328\ud558\uc2b5\ub2c8\ub2e4." + e.getMessage();
                log.error(\uc624\ub958_\uba54\uc138\uc9c0);
                return \uc624\ub958_\uba54\uc138\uc9c0;
            }
            Set \uc774\uc288\uc720\ud615_\ub3d9\uae30\ud654\ubaa9\ub85d = this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(\ud574\ub2f9_\uc11c\ubc84_\uc774\uc288\uc720\ud615_\ubaa9\ub85d, \uae30\uc874\uc774\uc288\uc720\ud615_\ub9f5, \uac00\uc838\uc628_\uc774\uc288\uc720\ud615_\ubaa9\ub85d, \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \uac31\uc2e0\ud560_\ud56d\ubaa9);
            \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraIssueTypeEntities(\uc774\uc288\uc720\ud615_\ub3d9\uae30\ud654\ubaa9\ub85d);
        } else if (StringUtils.equals((String)ServerType.JIRA_CLOUD.getType(), (String)\uc11c\ubc84\uc720\ud615) || StringUtils.equals((String)ServerType.REDMINE_ON_PREMISE.getType(), (String)\uc11c\ubc84\uc720\ud615)) {
            if (\ud504\ub85c\uc81d\ud2b8_C\uc544\uc774\ub514 == null || \ud504\ub85c\uc81d\ud2b8_C\uc544\uc774\ub514.isEmpty()) {
                Set \ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = Optional.ofNullable(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraProjectEntities()).orElse(new HashSet());
                for (JiraProjectEntity \ud504\ub85c\uc81d\ud2b82 : \ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d) {
                    List \uac00\uc838\uc628_\uc774\uc288\uc720\ud615_\ubaa9\ub85d;
                    if (\ud504\ub85c\uc81d\ud2b82.getC_etc() != null && StringUtils.equals((String)\ud504\ub85c\uc81d\ud2b82.getC_etc(), (String)"delete")) continue;
                    Set \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = Optional.ofNullable(\ud504\ub85c\uc81d\ud2b82.getJiraIssueTypeEntities()).orElse(new HashSet());
                    Map<String, JiraIssueTypeEntity> \uae30\uc874\uc774\uc288\uc720\ud615_\ub9f5 = \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152.getC_issue_type_url(), \uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152));
                    try {
                        \uac00\uc838\uc628_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = this.engineService.\ud074\ub77c\uc6b0\ub4dc_\ud504\ub85c\uc81d\ud2b8\ubcc4_\uc774\uc288_\uc720\ud615_\ubaa9\ub85d(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \ud504\ub85c\uc81d\ud2b82.getC_desc());
                    }
                    catch (Exception e) {
                        String \uc624\ub958_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0 \uc2e4\ud328\ud558\uc2b5\ub2c8\ub2e4." + e.getMessage();
                        log.error(\uc624\ub958_\uba54\uc138\uc9c0);
                        return \uc624\ub958_\uba54\uc138\uc9c0;
                    }
                    Set \uc774\uc288\uc720\ud615_\ub3d9\uae30\ud654\ubaa9\ub85d = this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(\ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d, \uae30\uc874\uc774\uc288\uc720\ud615_\ub9f5, \uac00\uc838\uc628_\uc774\uc288\uc720\ud615_\ubaa9\ub85d, \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \uac31\uc2e0\ud560_\ud56d\ubaa9);
                    \ud504\ub85c\uc81d\ud2b82.setJiraIssueTypeEntities(\uc774\uc288\uc720\ud615_\ub3d9\uae30\ud654\ubaa9\ub85d);
                    \ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d.add(\ud504\ub85c\uc81d\ud2b82);
                }
                \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraProjectEntities(\ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d);
            } else {
                List \uac00\uc838\uc628_\uc774\uc288\uc720\ud615_\ubaa9\ub85d;
                JiraProjectEntity \ud504\ub85c\uc81d\ud2b8_\uac80\uc0c9\uc804\uc6a9 = new JiraProjectEntity();
                \ud504\ub85c\uc81d\ud2b8_\uac80\uc0c9\uc804\uc6a9.setC_id(Long.valueOf(Long.parseLong(\ud504\ub85c\uc81d\ud2b8_C\uc544\uc774\ub514)));
                JiraProjectEntity \ud504\ub85c\uc81d\ud2b83 = (JiraProjectEntity)this.jiraProject.getNode((TreeSearchEntity)\ud504\ub85c\uc81d\ud2b8_\uac80\uc0c9\uc804\uc6a9);
                Set \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = Optional.ofNullable(\ud504\ub85c\uc81d\ud2b83.getJiraIssueTypeEntities()).orElse(new HashSet());
                Map<String, JiraIssueTypeEntity> \uae30\uc874\uc774\uc288\uc720\ud615_\ub9f5 = \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152.getC_issue_type_url(), \uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152));
                try {
                    \uac00\uc838\uc628_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = this.engineService.\ud074\ub77c\uc6b0\ub4dc_\ud504\ub85c\uc81d\ud2b8\ubcc4_\uc774\uc288_\uc720\ud615_\ubaa9\ub85d(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \ud504\ub85c\uc81d\ud2b83.getC_desc());
                }
                catch (Exception e) {
                    String \uc624\ub958_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0 \uc2e4\ud328\ud558\uc2b5\ub2c8\ub2e4." + e.getMessage();
                    log.error(\uc624\ub958_\uba54\uc138\uc9c0);
                    return \uc624\ub958_\uba54\uc138\uc9c0;
                }
                Set \uc774\uc288\uc720\ud615_\ub3d9\uae30\ud654\ubaa9\ub85d = this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(\ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d, \uae30\uc874\uc774\uc288\uc720\ud615_\ub9f5, \uac00\uc838\uc628_\uc774\uc288\uc720\ud615_\ubaa9\ub85d, \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \uac31\uc2e0\ud560_\ud56d\ubaa9);
                \ud504\ub85c\uc81d\ud2b83.setJiraIssueTypeEntities(\uc774\uc288\uc720\ud615_\ub3d9\uae30\ud654\ubaa9\ub85d);
                Set jiraProjectEntities = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraProjectEntities();
                if (jiraProjectEntities.removeIf(entity -> Objects.equals(entity.getC_id(), \ud504\ub85c\uc81d\ud2b83.getC_id()))) {
                    jiraProjectEntities.add(\ud504\ub85c\uc81d\ud2b83);
                }
                \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraProjectEntities(jiraProjectEntities);
            }
        }
        return null;
    }

    private String \uc774\uc288\uc0c1\ud0dc_\uac31\uc2e0(JiraServerEntity \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, String \ud504\ub85c\uc81d\ud2b8_C\uc544\uc774\ub514) throws Exception {
        EntityType \uac31\uc2e0\ud560_\ud56d\ubaa9 = EntityType.\uc774\uc288\uc0c1\ud0dc;
        String \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_etc();
        String \uc11c\ubc84\uc720\ud615 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_type();
        if (StringUtils.equals((String)ServerType.JIRA_ON_PREMISE.getType(), (String)\uc11c\ubc84\uc720\ud615) || StringUtils.equals((String)ServerType.REDMINE_ON_PREMISE.getType(), (String)\uc11c\ubc84\uc720\ud615)) {
            List \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d;
            Set \ud574\ub2f9_\uc11c\ubc84_\uc774\uc288_\uc0c1\ud0dc_\ubaa9\ub85d = Optional.ofNullable(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraIssueStatusEntities()).orElse(new HashSet());
            Map<String, JiraIssueStatusEntity> \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5 = \ud574\ub2f9_\uc11c\ubc84_\uc774\uc288_\uc0c1\ud0dc_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc0c1\ud0dc -> \uc774\uc288\uc0c1\ud0dc.getC_issue_status_url(), \uc774\uc288\uc0c1\ud0dc -> \uc774\uc288\uc0c1\ud0dc));
            try {
                \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d = this.engineService.ALM_\uc774\uc288_\uc0c1\ud0dc_\uac00\uc838\uc624\uae30(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514);
            }
            catch (Exception e) {
                String \uc624\ub958_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0 \uc2e4\ud328\ud558\uc2b5\ub2c8\ub2e4." + e.getMessage();
                log.error(\uc624\ub958_\uba54\uc138\uc9c0);
                return \uc624\ub958_\uba54\uc138\uc9c0;
            }
            Set \uc774\uc288\uc0c1\ud0dc_\ub3d9\uae30\ud654\ubaa9\ub85d = this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(\ud574\ub2f9_\uc11c\ubc84_\uc774\uc288_\uc0c1\ud0dc_\ubaa9\ub85d, \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5, \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d, \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \uac31\uc2e0\ud560_\ud56d\ubaa9);
            \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraIssueStatusEntities(\uc774\uc288\uc0c1\ud0dc_\ub3d9\uae30\ud654\ubaa9\ub85d);
        } else if (StringUtils.equals((String)ServerType.JIRA_CLOUD.getType(), (String)\uc11c\ubc84\uc720\ud615)) {
            if (\ud504\ub85c\uc81d\ud2b8_C\uc544\uc774\ub514 == null || \ud504\ub85c\uc81d\ud2b8_C\uc544\uc774\ub514.isEmpty()) {
                HashSet<JiraProjectEntity> \ub3d9\uae30\ud654_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = new HashSet<JiraProjectEntity>();
                Set \ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = Optional.ofNullable(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraProjectEntities()).orElse(new HashSet());
                for (JiraProjectEntity \ud504\ub85c\uc81d\ud2b82 : \ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d) {
                    List \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d;
                    if (\ud504\ub85c\uc81d\ud2b82.getC_etc() != null && StringUtils.equals((String)\ud504\ub85c\uc81d\ud2b82.getC_etc(), (String)"delete")) continue;
                    Set \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = Optional.ofNullable(\ud504\ub85c\uc81d\ud2b82.getJiraIssueTypeEntities()).orElse(new HashSet());
                    try {
                        \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d = this.engineService.\ud074\ub77c\uc6b0\ub4dc_\ud504\ub85c\uc81d\ud2b8\ubcc4_\uc774\uc288_\uc0c1\ud0dc_\ubaa9\ub85d(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \ud504\ub85c\uc81d\ud2b82.getC_desc());
                    }
                    catch (Exception e) {
                        String \uc624\ub958_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0 \uc2e4\ud328\ud558\uc2b5\ub2c8\ub2e4." + e.getMessage();
                        log.error(\uc624\ub958_\uba54\uc138\uc9c0);
                        return \uc624\ub958_\uba54\uc138\uc9c0;
                    }
                    Map<String, List> \uc774\uc288\uc720\ud615\ubcc4_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d_\ub9f5 = \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152.getId(), \uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152.getStatuses().stream().map(issueStatus -> {
                        issueStatus.setIssueTypeId(\uc774\uc288\uc720\ud6152.getId());
                        return issueStatus;
                    }).collect(Collectors.toList())));
                    for (JiraIssueTypeEntity issueType : \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d) {
                        List \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d = \uc774\uc288\uc720\ud615\ubcc4_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d_\ub9f5.get(issueType.getC_issue_type_id());
                        Map<String, JiraIssueStatusEntity> \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5 = Optional.ofNullable(issueType.getJiraIssueStatusEntities()).orElse(Collections.emptySet()).stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc0c1\ud0dc -> \uc774\uc288\uc0c1\ud0dc.getC_issue_status_url(), \uc774\uc288\uc0c1\ud0dc -> \uc774\uc288\uc0c1\ud0dc));
                        Set \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d = ((Set)Optional.ofNullable(issueType.getJiraIssueStatusEntities()).orElse(new HashSet())).stream().filter(Objects::nonNull).collect(Collectors.toSet());
                        Set \uc774\uc288\uc0c1\ud0dc_\ub3d9\uae30\ud654\ubaa9\ub85d = this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(\uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d, \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5, \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d, \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \uac31\uc2e0\ud560_\ud56d\ubaa9);
                        issueType.setJiraIssueStatusEntities(\uc774\uc288\uc0c1\ud0dc_\ub3d9\uae30\ud654\ubaa9\ub85d);
                    }
                    \ud504\ub85c\uc81d\ud2b82.setJiraIssueTypeEntities(\ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d);
                    \ub3d9\uae30\ud654_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d.add(\ud504\ub85c\uc81d\ud2b82);
                }
                \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraProjectEntities(\ub3d9\uae30\ud654_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d);
            } else {
                List \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d;
                JiraProjectEntity \ud504\ub85c\uc81d\ud2b8_\uac80\uc0c9\uc804\uc6a9 = new JiraProjectEntity();
                \ud504\ub85c\uc81d\ud2b8_\uac80\uc0c9\uc804\uc6a9.setC_id(Long.valueOf(Long.parseLong(\ud504\ub85c\uc81d\ud2b8_C\uc544\uc774\ub514)));
                JiraProjectEntity \ud504\ub85c\uc81d\ud2b83 = (JiraProjectEntity)this.jiraProject.getNode((TreeSearchEntity)\ud504\ub85c\uc81d\ud2b8_\uac80\uc0c9\uc804\uc6a9);
                Set \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = Optional.ofNullable(\ud504\ub85c\uc81d\ud2b83.getJiraIssueTypeEntities()).orElse(new HashSet());
                try {
                    \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d = this.engineService.\ud074\ub77c\uc6b0\ub4dc_\ud504\ub85c\uc81d\ud2b8\ubcc4_\uc774\uc288_\uc0c1\ud0dc_\ubaa9\ub85d(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \ud504\ub85c\uc81d\ud2b83.getC_desc());
                }
                catch (Exception e) {
                    String \uc624\ub958_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0 \uc2e4\ud328\ud558\uc2b5\ub2c8\ub2e4." + e.getMessage();
                    log.error(\uc624\ub958_\uba54\uc138\uc9c0);
                    return \uc624\ub958_\uba54\uc138\uc9c0;
                }
                Map<String, List> \uc774\uc288\uc720\ud615\ubcc4_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d_\ub9f5 = \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152.getId(), \uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152.getStatuses()));
                for (JiraIssueTypeEntity issueType : \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d) {
                    List \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d = \uc774\uc288\uc720\ud615\ubcc4_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d_\ub9f5.get(issueType.getC_issue_type_id());
                    Map<String, JiraIssueStatusEntity> \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5 = issueType.getJiraIssueStatusEntities().stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc0c1\ud0dc -> \uc774\uc288\uc0c1\ud0dc.getC_issue_status_url(), \uc774\uc288\uc0c1\ud0dc -> \uc774\uc288\uc0c1\ud0dc));
                    Set \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d = ((Set)Optional.ofNullable(issueType.getJiraIssueStatusEntities()).orElse(new HashSet())).stream().filter(Objects::nonNull).collect(Collectors.toSet());
                    Set \uc774\uc288\uc0c1\ud0dc_\ub3d9\uae30\ud654\ubaa9\ub85d = this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(\uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d, \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5, \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d, \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \uac31\uc2e0\ud560_\ud56d\ubaa9);
                    issueType.setJiraIssueStatusEntities(\uc774\uc288\uc0c1\ud0dc_\ub3d9\uae30\ud654\ubaa9\ub85d);
                }
                \ud504\ub85c\uc81d\ud2b83.setJiraIssueTypeEntities(\ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d);
                Set jiraProjectEntities = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraProjectEntities();
                if (jiraProjectEntities.removeIf(entity -> Objects.equals(entity.getC_id(), \ud504\ub85c\uc81d\ud2b83.getC_id()))) {
                    jiraProjectEntities.add(\ud504\ub85c\uc81d\ud2b83);
                }
                \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraProjectEntities(jiraProjectEntities);
            }
        }
        return null;
    }

    private String \uc774\uc288\uc6b0\uc120\uc21c\uc704_\uac31\uc2e0(JiraServerEntity \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84) {
        EntityType \uac31\uc2e0\ud560_\ud56d\ubaa9 = EntityType.\uc774\uc288\uc6b0\uc120\uc21c\uc704;
        String \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_etc();
        Set \ud574\ub2f9_\uc11c\ubc84_\uc774\uc288_\uc6b0\uc120\uc21c\uc704_\ubaa9\ub85d = Optional.ofNullable(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraIssuePriorityEntities()).orElse(new HashSet());
        Map<String, JiraIssuePriorityEntity> \uae30\uc874\uc774\uc288\uc6b0\uc120\uc21c\uc704_\ub9f5 = \ud574\ub2f9_\uc11c\ubc84_\uc774\uc288_\uc6b0\uc120\uc21c\uc704_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc6b0\uc120\uc21c\uc7042 -> \uc6b0\uc120\uc21c\uc7042.getC_issue_priority_url(), \uc6b0\uc120\uc21c\uc7042 -> \uc6b0\uc120\uc21c\uc7042));
        List \uac00\uc838\uc628_\uc774\uc288\uc6b0\uc120\uc21c\uc704_\ubaa9\ub85d = null;
        try {
            \uac00\uc838\uc628_\uc774\uc288\uc6b0\uc120\uc21c\uc704_\ubaa9\ub85d = this.engineService.ALM_\uc774\uc288_\uc6b0\uc120\uc21c\uc704_\uac00\uc838\uc624\uae30(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514);
        }
        catch (Exception e) {
            String \uc624\ub958_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0 \uc2e4\ud328\ud558\uc2b5\ub2c8\ub2e4." + e.getMessage();
            log.error(\uc624\ub958_\uba54\uc138\uc9c0);
            return \uc624\ub958_\uba54\uc138\uc9c0;
        }
        Set \uc6b0\uc120\uc21c\uc704_\ub3d9\uae30\ud654\ubaa9\ub85d = this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(\ud574\ub2f9_\uc11c\ubc84_\uc774\uc288_\uc6b0\uc120\uc21c\uc704_\ubaa9\ub85d, \uae30\uc874\uc774\uc288\uc6b0\uc120\uc21c\uc704_\ub9f5, \uac00\uc838\uc628_\uc774\uc288\uc6b0\uc120\uc21c\uc704_\ubaa9\ub85d, \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \uac31\uc2e0\ud560_\ud56d\ubaa9);
        \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraIssuePriorityEntities(\uc6b0\uc120\uc21c\uc704_\ub3d9\uae30\ud654\ubaa9\ub85d);
        return null;
    }

    private String \uc774\uc288\ud574\uacb0\ucc45_\uac31\uc2e0(JiraServerEntity \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84) {
        List \uac00\uc838\uc628_\uc774\uc288\ud574\uacb0\ucc45_\ubaa9\ub85d;
        EntityType \uac31\uc2e0\ud560_\ud56d\ubaa9 = EntityType.\uc774\uc288\ud574\uacb0\ucc45;
        String \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_etc();
        Set \ud574\ub2f9_\uc11c\ubc84_\uc774\uc288_\ud574\uacb0\ucc45_\ubaa9\ub85d = Optional.ofNullable(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraIssueResolutionEntities()).orElse(new HashSet());
        Map<String, JiraIssueResolutionEntity> \uae30\uc874\uc774\uc288\ud574\uacb0\ucc45_\ub9f5 = \ud574\ub2f9_\uc11c\ubc84_\uc774\uc288_\ud574\uacb0\ucc45_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\ud574\uacb0\ucc45 -> \uc774\uc288\ud574\uacb0\ucc45.getC_issue_resolution_url(), \uc774\uc288\ud574\uacb0\ucc45 -> \uc774\uc288\ud574\uacb0\ucc45));
        try {
            \uac00\uc838\uc628_\uc774\uc288\ud574\uacb0\ucc45_\ubaa9\ub85d = this.engineService.ALM_\uc774\uc288_\ud574\uacb0\ucc45_\uac00\uc838\uc624\uae30(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514);
        }
        catch (Exception e) {
            String \uc624\ub958_\uba54\uc138\uc9c0 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 " + String.valueOf(\uac31\uc2e0\ud560_\ud56d\ubaa9) + " \uc774(\uac00) \uac31\uc2e0 \uc2e4\ud328\ud558\uc2b5\ub2c8\ub2e4." + e.getMessage();
            log.error(\uc624\ub958_\uba54\uc138\uc9c0);
            return \uc624\ub958_\uba54\uc138\uc9c0;
        }
        Set \ud574\uacb0\ucc45_\ub3d9\uae30\ud654\ubaa9\ub85d = this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(\ud574\ub2f9_\uc11c\ubc84_\uc774\uc288_\ud574\uacb0\ucc45_\ubaa9\ub85d, \uae30\uc874\uc774\uc288\ud574\uacb0\ucc45_\ub9f5, \uac00\uc838\uc628_\uc774\uc288\ud574\uacb0\ucc45_\ubaa9\ub85d, \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \uac31\uc2e0\ud560_\ud56d\ubaa9);
        \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraIssueResolutionEntities(\ud574\uacb0\ucc45_\ub3d9\uae30\ud654\ubaa9\ub85d);
        return null;
    }

    private <E extends TreeSearchEntity, T extends ALM_\ub370\uc774\ud130> Set<E> \uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654(Set<E> \ub4f1\ub85d\ub41c_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d, Map<String, E> \uae30\uc874_\ub9f5, List<T> \uac00\uc838\uc628_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d, JiraServerEntity \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84, String \uc5d4\uc9c4_\uc5f0\uacb0_\uc544\uc774\ub514, EntityType \uac31\uc2e0\ud56d\ubaa9) {
        String \uc11c\ubc84\uc720\ud615 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_type();
        if (\uac00\uc838\uc628_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d == null || \uac00\uc838\uc628_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d.size() == 0) {
            return null;
        }
        for (ALM_\ub370\uc774\ud130 \uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0 : \uac00\uc838\uc628_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d) {
            boolean \uc5d4\ud2f0\ud2f0\uc874\uc7ac\uc5ec\ubd80 = \uae30\uc874_\ub9f5 != null && \uae30\uc874_\ub9f5.containsKey(\uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0.getSelf());
            TreeSearchEntity \ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0 = \uc5d4\ud2f0\ud2f0\uc874\uc7ac\uc5ec\ubd80 ? (TreeSearchEntity)\uae30\uc874_\ub9f5.get(\uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0.getSelf()) : null;
            JiraProjectEntity \uacb0\uacfc = null;
            try {
                if (\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0 instanceof JiraProjectEntity || EntityType.\ud504\ub85c\uc81d\ud2b8 == \uac31\uc2e0\ud56d\ubaa9) {
                    \uacb0\uacfc = this.\ud504\ub85c\uc81d\ud2b8_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8((\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ub370\uc774\ud130)\uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0, (JiraProjectEntity)\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0);
                } else if (\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0 instanceof JiraIssueTypeEntity || EntityType.\uc774\uc288\uc720\ud615 == \uac31\uc2e0\ud56d\ubaa9) {
                    \uacb0\uacfc = this.\uc774\uc288\uc720\ud615_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8((\uc9c0\ub77c\uc774\uc288\uc720\ud615_\ub370\uc774\ud130)\uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0, (JiraIssueTypeEntity)\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0, \uc11c\ubc84\uc720\ud615);
                } else if (\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0 instanceof JiraIssueStatusEntity || EntityType.\uc774\uc288\uc0c1\ud0dc == \uac31\uc2e0\ud56d\ubaa9) {
                    \uacb0\uacfc = this.\uc774\uc288\uc0c1\ud0dc_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8((\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130)\uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0, (JiraIssueStatusEntity)\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0);
                } else if (\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0 instanceof JiraIssuePriorityEntity || EntityType.\uc774\uc288\uc6b0\uc120\uc21c\uc704 == \uac31\uc2e0\ud56d\ubaa9) {
                    \uacb0\uacfc = this.\uc774\uc288\uc6b0\uc120\uc21c\uc704_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8((\uc9c0\ub77c\uc774\uc288\uc6b0\uc120\uc21c\uc704_\ub370\uc774\ud130)\uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0, (JiraIssuePriorityEntity)\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0, \uc11c\ubc84\uc720\ud615);
                } else if (\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0 instanceof JiraIssueResolutionEntity || EntityType.\uc774\uc288\ud574\uacb0\ucc45 == \uac31\uc2e0\ud56d\ubaa9) {
                    \uacb0\uacfc = this.\uc774\uc288\ud574\uacb0\ucc45_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8((\uc9c0\ub77c\uc774\uc288\ud574\uacb0\ucc45_\ub370\uc774\ud130)\uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0, (JiraIssueResolutionEntity)\ubc31\uc5d4\ub4dc_\uc5d4\ud2f0\ud2f0, \uc11c\ubc84\uc720\ud615);
                }
            }
            catch (Exception e) {
                log.error("\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ub3d9\uae30\ud654 \uc624\ub958 \ubc1c\uc0dd :: \uc5f0\uacb0\uc544\uc774\ub514 :: {} \uc11c\ubc84\uc720\ud615 :: {} :: \uac31\uc2e0\ud56d\ubaa9 ::  {} :: \uc5d4\ud2f0\ud2f0 :: {}", new Object[]{\uc5d4\uc9c4_\uc5f0\uacb0_\uc544\uc774\ub514, \uc11c\ubc84\uc720\ud615, \uac31\uc2e0\ud56d\ubaa9, \uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0.toString()});
                log.error(e.getMessage());
            }
            if (\uacb0\uacfc != null && !\uc5d4\ud2f0\ud2f0\uc874\uc7ac\uc5ec\ubd80) {
                \ub4f1\ub85d\ub41c_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d.add(\uacb0\uacfc);
            }
            \uae30\uc874_\ub9f5.remove(\uc5d4\uc9c4_\uc5d4\ud2f0\ud2f0.getSelf());
        }
        Set \ubc18\ud658\ud560_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d = this.\uc18c\ud504\ud2b8_\ub51c\ub9ac\ud2b8(\uae30\uc874_\ub9f5, \ub4f1\ub85d\ub41c_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d);
        return \ubc18\ud658\ud560_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d;
    }

    private <T extends TreeSearchEntity> Set<T> \uc18c\ud504\ud2b8_\ub51c\ub9ac\ud2b8(Map<String, T> \uae30\uc874_\ub9f5, Set<T> \ub4f1\ub85d\ub41c_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d) {
        if (\uae30\uc874_\ub9f5 != null && \uae30\uc874_\ub9f5.size() > 0) {
            \uae30\uc874_\ub9f5.forEach((\uc5d4\ud2f0\ud2f0\ud0a4, \uc5d4\ud2f0\ud2f0) -> {
                JiraProjectEntity \ubc18\ud658\uacb0\uacfc = null;
                try {
                    int \ucc98\ub9ac\uacb0\uacfc = 0;
                    if (\uc5d4\ud2f0\ud2f0 instanceof JiraProjectEntity) {
                        JiraProjectEntity \ud504\ub85c\uc81d\ud2b82 = (JiraProjectEntity)\uc5d4\ud2f0\ud2f0;
                        if (\ud504\ub85c\uc81d\ud2b82.getC_etc() == null || !StringUtils.equals((String)"delete", (String)\ud504\ub85c\uc81d\ud2b82.getC_etc())) {
                            \ud504\ub85c\uc81d\ud2b82.setC_etc("delete");
                        }
                        \ucc98\ub9ac\uacb0\uacfc = this.jiraProject.updateNode((TreeSearchEntity)\ud504\ub85c\uc81d\ud2b82);
                        \ubc18\ud658\uacb0\uacfc = \ud504\ub85c\uc81d\ud2b82;
                    } else if (\uc5d4\ud2f0\ud2f0 instanceof JiraIssueTypeEntity) {
                        JiraIssueTypeEntity \uc774\uc288\uc720\ud6152 = (JiraIssueTypeEntity)\uc5d4\ud2f0\ud2f0;
                        if (\uc774\uc288\uc720\ud6152.getC_etc() == null || !StringUtils.equals((String)"delete", (String)\uc774\uc288\uc720\ud6152.getC_etc())) {
                            \uc774\uc288\uc720\ud6152.setC_etc("delete");
                            \uc774\uc288\uc720\ud6152.setC_check("false");
                        }
                        \ucc98\ub9ac\uacb0\uacfc = this.jiraIssueType.updateNode((TreeSearchEntity)\uc774\uc288\uc720\ud6152);
                        \ubc18\ud658\uacb0\uacfc = \uc774\uc288\uc720\ud6152;
                    } else if (\uc5d4\ud2f0\ud2f0 instanceof JiraIssueStatusEntity) {
                        JiraIssueStatusEntity \uc774\uc288\uc0c1\ud0dc = (JiraIssueStatusEntity)\uc5d4\ud2f0\ud2f0;
                        if (\uc774\uc288\uc0c1\ud0dc.getC_etc() == null || !StringUtils.equals((String)"delete", (String)\uc774\uc288\uc0c1\ud0dc.getC_etc())) {
                            \uc774\uc288\uc0c1\ud0dc.setC_etc("delete");
                            \uc774\uc288\uc0c1\ud0dc.setC_check("false");
                        }
                        \ucc98\ub9ac\uacb0\uacfc = this.jiraIssueStatus.updateNode((TreeSearchEntity)\uc774\uc288\uc0c1\ud0dc);
                        \ubc18\ud658\uacb0\uacfc = \uc774\uc288\uc0c1\ud0dc;
                    } else if (\uc5d4\ud2f0\ud2f0 instanceof JiraIssuePriorityEntity) {
                        JiraIssuePriorityEntity \uc774\uc288\uc6b0\uc120\uc21c\uc704 = (JiraIssuePriorityEntity)\uc5d4\ud2f0\ud2f0;
                        if (\uc774\uc288\uc6b0\uc120\uc21c\uc704.getC_etc() == null || !StringUtils.equals((String)"delete", (String)\uc774\uc288\uc6b0\uc120\uc21c\uc704.getC_etc())) {
                            \uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_etc("delete");
                            \uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_check("false");
                        }
                        \ucc98\ub9ac\uacb0\uacfc = this.jiraIssuePriority.updateNode((TreeSearchEntity)\uc774\uc288\uc6b0\uc120\uc21c\uc704);
                        \ubc18\ud658\uacb0\uacfc = \uc774\uc288\uc6b0\uc120\uc21c\uc704;
                    } else if (\uc5d4\ud2f0\ud2f0 instanceof JiraIssueResolutionEntity) {
                        JiraIssueResolutionEntity \uc774\uc288\ud574\uacb0\ucc45 = (JiraIssueResolutionEntity)\uc5d4\ud2f0\ud2f0;
                        if (\uc774\uc288\ud574\uacb0\ucc45.getC_etc() == null || !StringUtils.equals((String)"delete", (String)\uc774\uc288\ud574\uacb0\ucc45.getC_etc())) {
                            \uc774\uc288\ud574\uacb0\ucc45.setC_etc("delete");
                            \uc774\uc288\ud574\uacb0\ucc45.setC_check("false");
                        }
                        \ucc98\ub9ac\uacb0\uacfc = this.jiraIssueResolution.updateNode((TreeSearchEntity)\uc774\uc288\ud574\uacb0\ucc45);
                        \ubc18\ud658\uacb0\uacfc = \uc774\uc288\ud574\uacb0\ucc45;
                    }
                    if (\ucc98\ub9ac\uacb0\uacfc == 1) {
                        \ub4f1\ub85d\ub41c_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d.add(\ubc18\ud658\uacb0\uacfc);
                    }
                }
                catch (Exception e) {
                    log.error("\uc18c\ud504\ud2b8 \ub51c\ub9ac\ud2b8 \ucc98\ub9ac \uc624\ub958 \ubc1c\uc0dd :: \uc5d4\ud2f0\ud2f0 ::  {}", (Object)\uc5d4\ud2f0\ud2f0.toString());
                    log.error(e.getMessage());
                }
            });
        }
        return \ub4f1\ub85d\ub41c_\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d;
    }

    private JiraProjectEntity \ud504\ub85c\uc81d\ud2b8_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8(\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ub370\uc774\ud130 \uc5d4\uc9c4_\ud504\ub85c\uc81d\ud2b8, JiraProjectEntity \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8) throws Exception {
        int \uc5c5\ub370\uc774\ud2b8\uacb0\uacfc;
        boolean isNew = false;
        if (\ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8 == null) {
            isNew = true;
            \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8 = new JiraProjectEntity();
        }
        \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.setC_jira_key(\uc5d4\uc9c4_\ud504\ub85c\uc81d\ud2b8.getKey());
        \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.setC_desc(\uc5d4\uc9c4_\ud504\ub85c\uc81d\ud2b8.getId());
        \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.setC_jira_url(\uc5d4\uc9c4_\ud504\ub85c\uc81d\ud2b8.getSelf());
        String projectName = \uc5d4\uc9c4_\ud504\ub85c\uc81d\ud2b8.getName();
        if (projectName != null) {
            String formattedProjectName = projectName.replaceAll("&nbsp;-&nbsp;", " - ");
            \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.setC_title(formattedProjectName);
            \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.setC_jira_name(formattedProjectName);
        }
        if (isNew) {
            \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.setRef(TreeConstant.First_Node_CID.longValue());
            \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.setC_type("default");
            return (JiraProjectEntity)this.jiraProject.addNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8);
        }
        if (\ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.getC_etc() != null && StringUtils.equals((String)"delete", (String)\ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.getC_etc())) {
            \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8.setC_etc(null);
        }
        return (\uc5c5\ub370\uc774\ud2b8\uacb0\uacfc = this.jiraProject.updateNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8)) == 1 ? \ubc31\uc5d4\ub4dc_\ud504\ub85c\uc81d\ud2b8 : null;
    }

    private JiraIssueTypeEntity \uc774\uc288\uc720\ud615_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8(\uc9c0\ub77c\uc774\uc288\uc720\ud615_\ub370\uc774\ud130 \uc5d4\uc9c4_\uc774\uc288\uc720\ud615, JiraIssueTypeEntity \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615, String \uc11c\ubc84\uc720\ud615) throws Exception {
        int \uc5c5\ub370\uc774\ud2b8\uacb0\uacfc;
        boolean isNew = false;
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615 == null) {
            isNew = true;
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615 = new JiraIssueTypeEntity();
        }
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_issue_type_id(\uc5d4\uc9c4_\uc774\uc288\uc720\ud615.getId());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_issue_type_name(\uc5d4\uc9c4_\uc774\uc288\uc720\ud615.getName());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_issue_type_url(\uc5d4\uc9c4_\uc774\uc288\uc720\ud615.getSelf());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_issue_type_desc(\uc5d4\uc9c4_\uc774\uc288\uc720\ud615.getDescription());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_desc(\uc5d4\uc9c4_\uc774\uc288\uc720\ud615.getSubtask().toString());
        if (StringUtils.equals((String)ServerType.JIRA_CLOUD.getType(), (String)\uc11c\ubc84\uc720\ud615)) {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_contents(\uc5d4\uc9c4_\uc774\uc288\uc720\ud615.getHierarchyLevel().toString());
        }
        if (isNew) {
            if (\uc5d4\uc9c4_\uc774\uc288\uc720\ud615.getName().equals("arms-requirement")) {
                \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_check("true");
            } else {
                \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_check("false");
            }
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setRef(TreeConstant.First_Node_CID.longValue());
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_type("default");
            return (JiraIssueTypeEntity)this.jiraIssueType.addNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615);
        }
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.getC_etc() != null && StringUtils.equals((String)"delete", (String)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.getC_etc())) {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615.setC_etc(null);
        }
        return (\uc5c5\ub370\uc774\ud2b8\uacb0\uacfc = this.jiraIssueType.updateNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615)) == 1 ? \ubc31\uc5d4\ub4dc_\uc774\uc288\uc720\ud615 : null;
    }

    private JiraIssueStatusEntity \uc774\uc288\uc0c1\ud0dc_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8(\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130 \uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc, JiraIssueStatusEntity \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc) throws Exception {
        int \uc5c5\ub370\uc774\ud2b8\uacb0\uacfc;
        boolean isNew = false;
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc == null) {
            isNew = true;
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc = new JiraIssueStatusEntity();
        }
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_status_id(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getId());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_status_name(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getName());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_status_url(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getSelf());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_status_desc(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getDescription());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_type_mapping_id(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getIssueTypeId());
        if (isNew) {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_check("false");
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setRef(TreeConstant.First_Node_CID.longValue());
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_type("default");
            return (JiraIssueStatusEntity)this.jiraIssueStatus.addNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc);
        }
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.getC_etc() != null && StringUtils.equals((String)"delete", (String)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.getC_etc())) {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_etc(null);
        }
        return (\uc5c5\ub370\uc774\ud2b8\uacb0\uacfc = this.jiraIssueStatus.updateNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc)) == 1 ? \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc : null;
    }

    private JiraIssuePriorityEntity \uc774\uc288\uc6b0\uc120\uc21c\uc704_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8(\uc9c0\ub77c\uc774\uc288\uc6b0\uc120\uc21c\uc704_\ub370\uc774\ud130 \uc5d4\uc9c4_\uc774\uc288\uc6b0\uc120\uc21c\uc704, JiraIssuePriorityEntity \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704, String \uc11c\ubc84\uc720\ud615) throws Exception {
        int \uc5c5\ub370\uc774\ud2b8\uacb0\uacfc;
        boolean isNew = false;
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704 == null) {
            isNew = true;
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704 = new JiraIssuePriorityEntity();
        }
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_issue_priority_id(\uc5d4\uc9c4_\uc774\uc288\uc6b0\uc120\uc21c\uc704.getId());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_issue_priority_name(\uc5d4\uc9c4_\uc774\uc288\uc6b0\uc120\uc21c\uc704.getName());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_issue_priority_url(\uc5d4\uc9c4_\uc774\uc288\uc6b0\uc120\uc21c\uc704.getSelf());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_issue_priority_desc(\uc5d4\uc9c4_\uc774\uc288\uc6b0\uc120\uc21c\uc704.getDescription());
        if (StringUtils.equals((String)ServerType.JIRA_CLOUD.getType(), (String)\uc11c\ubc84\uc720\ud615) || StringUtils.equals((String)ServerType.REDMINE_ON_PREMISE.getType(), (String)\uc11c\ubc84\uc720\ud615)) {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_desc(String.valueOf(\uc5d4\uc9c4_\uc774\uc288\uc6b0\uc120\uc21c\uc704.isDefault()));
        }
        if (isNew) {
            if (StringUtils.equals((String)ServerType.JIRA_CLOUD.getType(), (String)\uc11c\ubc84\uc720\ud615) || StringUtils.equals((String)ServerType.REDMINE_ON_PREMISE.getType(), (String)\uc11c\ubc84\uc720\ud615)) {
                \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_check(String.valueOf(\uc5d4\uc9c4_\uc774\uc288\uc6b0\uc120\uc21c\uc704.isDefault()));
            }
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.setRef(TreeConstant.First_Node_CID.longValue());
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_type("default");
            return (JiraIssuePriorityEntity)this.jiraIssuePriority.addNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704);
        }
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.getC_etc() != null && StringUtils.equals((String)"delete", (String)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.getC_etc())) {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704.setC_etc(null);
        }
        return (\uc5c5\ub370\uc774\ud2b8\uacb0\uacfc = this.jiraIssuePriority.updateNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704)) == 1 ? \ubc31\uc5d4\ub4dc_\uc774\uc288\uc6b0\uc120\uc21c\uc704 : null;
    }

    private JiraIssueResolutionEntity \uc774\uc288\ud574\uacb0\ucc45_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8(\uc9c0\ub77c\uc774\uc288\ud574\uacb0\ucc45_\ub370\uc774\ud130 \uc5d4\uc9c4_\uc774\uc288\ud574\uacb0\ucc45, JiraIssueResolutionEntity \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45, String \uc11c\ubc84\uc720\ud615) throws Exception {
        int \uc5c5\ub370\uc774\ud2b8\uacb0\uacfc;
        boolean isNew = false;
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45 == null) {
            isNew = true;
            \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45 = new JiraIssueResolutionEntity();
        }
        \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.setC_issue_resolution_id(\uc5d4\uc9c4_\uc774\uc288\ud574\uacb0\ucc45.getId());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.setC_issue_resolution_name(\uc5d4\uc9c4_\uc774\uc288\ud574\uacb0\ucc45.getName());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.setC_issue_resolution_url(\uc5d4\uc9c4_\uc774\uc288\ud574\uacb0\ucc45.getSelf());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.setC_issue_resolution_desc(\uc5d4\uc9c4_\uc774\uc288\ud574\uacb0\ucc45.getDescription());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.setC_desc(String.valueOf(\uc5d4\uc9c4_\uc774\uc288\ud574\uacb0\ucc45.isDefault()));
        if (isNew) {
            if (StringUtils.equals((String)ServerType.JIRA_CLOUD.getType(), (String)\uc11c\ubc84\uc720\ud615) || StringUtils.equals((String)ServerType.REDMINE_ON_PREMISE.getType(), (String)\uc11c\ubc84\uc720\ud615)) {
                \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.setC_check(String.valueOf(\uc5d4\uc9c4_\uc774\uc288\ud574\uacb0\ucc45.isDefault()));
            }
            \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.setRef(TreeConstant.First_Node_CID.longValue());
            \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.setC_type("default");
            return (JiraIssueResolutionEntity)this.jiraIssueResolution.addNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45);
        }
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.getC_etc() != null && StringUtils.equals((String)"delete", (String)\ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.getC_etc())) {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45.setC_etc(null);
        }
        return (\uc5c5\ub370\uc774\ud2b8\uacb0\uacfc = this.jiraIssueResolution.updateNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45)) == 1 ? \ubc31\uc5d4\ub4dc_\uc774\uc288\ud574\uacb0\ucc45 : null;
    }

    @Async
    @Transactional
    public CompletableFuture<Boolean> refreshALMServer(JiraServerEntity jiraServerEntity) {
        boolean \uacb0\uacfc = false;
        try {
            Global.chat.sendMessageByEngine("\uc11c\ubc84 \uac31\uc2e0\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4. \uc11c\ubc84 \ub370\uc774\ud130\uc5d0 \ub530\ub77c \uac78\ub9ac\ub294 \uc2dc\uac04 \ucc28\uac00 \ubc1c\uc0dd\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
            this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ud56d\ubaa9\ubcc4_\uac31\uc2e0(EntityType.\ud504\ub85c\uc81d\ud2b8, null, jiraServerEntity);
            this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ud56d\ubaa9\ubcc4_\uac31\uc2e0(EntityType.\uc774\uc288\uc720\ud615, null, jiraServerEntity);
            this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ud56d\ubaa9\ubcc4_\uac31\uc2e0(EntityType.\uc774\uc288\uc0c1\ud0dc, null, jiraServerEntity);
            this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ud56d\ubaa9\ubcc4_\uac31\uc2e0(EntityType.\uc774\uc288\uc6b0\uc120\uc21c\uc704, null, jiraServerEntity);
            this.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ud56d\ubaa9\ubcc4_\uac31\uc2e0(EntityType.\uc774\uc288\ud574\uacb0\ucc45, null, jiraServerEntity);
            \uacb0\uacfc = true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            Global.chat.sendMessageByEngine("\uc11c\ubc84 \uac31\uc2e0 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. :: " + e.getMessage());
        }
        if (\uacb0\uacfc) {
            Global.chat.sendMessageByEngine("\uc804\uccb4 \uc11c\ubc84 \ub370\uc774\ud130 \uac31\uc2e0\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        }
        return CompletableFuture.completedFuture(true);
    }

    @Transactional
    public Map<String, Map<String, StatusRuleSetEntity>> getStatusRuleSet(JiraServerEntity searchEntity) throws Exception {
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.getNode((TreeSearchEntity)searchEntity);
        if (jiraServerEntity == null || jiraServerEntity.getC_jira_server_type() == null || jiraServerEntity.getC_jira_server_etc() == null) {
            throw new Exception("\ub8f0\uc14b \uc124\uc815\uc5d0 \ud544\uc694\ud55c \uc11c\ubc84 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        String \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514 = jiraServerEntity.getC_jira_server_etc();
        String \uc11c\ubc84\uc720\ud615 = jiraServerEntity.getC_jira_server_type();
        if (!StringUtils.equals((String)ServerType.JIRA_CLOUD.getType(), (String)\uc11c\ubc84\uc720\ud615)) {
            throw new Exception("\uc0c1\ud0dc \ud504\ub9ac\uc14b \ubc29\uc2dd\uc740 \ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c \uc11c\ubc84 \ud0c0\uc785\uc758 \uacbd\uc6b0\uc5d0\ub9cc \uc0ac\uc6a9\ub429\ub2c8\ub2e4.");
        }
        HashMap<String, Map<String, StatusRuleSetEntity>> statusRuleSetMap = new HashMap<String, Map<String, StatusRuleSetEntity>>();
        Set almProjectEntities = Optional.ofNullable(jiraServerEntity.getJiraProjectEntities()).orElse(Collections.emptySet());
        for (JiraProjectEntity almProjectEntity : almProjectEntities) {
            if (almProjectEntity.getC_etc() != null && StringUtils.equals((String)almProjectEntity.getC_etc(), (String)"delete")) continue;
            List almProjectIssueStatusList = null;
            try {
                almProjectIssueStatusList = this.engineService.\ud074\ub77c\uc6b0\ub4dc_\ud504\ub85c\uc81d\ud2b8\ubcc4_\uc774\uc288_\uc0c1\ud0dc_\ubaa9\ub85d(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, almProjectEntity.getC_desc());
            }
            catch (Exception e) {
                log.error("Error updating " + jiraServerEntity.getC_jira_server_name() + ": " + e.getMessage(), (Throwable)e);
            }
            Optional.ofNullable(almProjectIssueStatusList).orElseGet(Collections::emptyList).forEach(issueType -> Optional.ofNullable(issueType.getStatuses()).orElseGet(Collections::emptyList).forEach(status -> statusRuleSetMap.computeIfAbsent(status.getStatusCategory().getKey(), k -> new HashMap()).compute(status.getName(), (name, existingStatus) -> {
                if (existingStatus == null) {
                    StatusRuleSetEntity ruleSetEntity = new StatusRuleSetEntity();
                    ruleSetEntity.setStatusCategoryKey(status.getStatusCategory().getKey());
                    ruleSetEntity.setStatusName(status.getName());
                    ruleSetEntity.setCount(1);
                    return ruleSetEntity;
                }
                existingStatus.setCount(existingStatus.getCount() + 1);
                return existingStatus;
            })));
        }
        statusRuleSetMap.forEach((key, stateMap) -> {
            ArrayList stateList = new ArrayList(stateMap.values());
            stateList.sort(Comparator.comparingInt(StatusRuleSetEntity::getCount).reversed().thenComparing(StatusRuleSetEntity::getStatusName));
            int priority = 1;
            for (StatusRuleSetEntity entity : stateList) {
                entity.setPriority(priority++);
            }
        });
        return statusRuleSetMap;
    }

    @Async
    @Transactional
    public void preSetIssueStatusMapping(String projectCid, JiraServerEntity jiraServer) throws Exception {
        boolean \ud504\ub9ac\uc14b_\uacb0\uacfc = false;
        JiraServerEntity \uac80\uc0c9\uc6a9_\uc11c\ubc84_\uc5d4\ud2f0\ud2f0 = new JiraServerEntity();
        \uac80\uc0c9\uc6a9_\uc11c\ubc84_\uc5d4\ud2f0\ud2f0.setC_id(jiraServer.getC_id());
        JiraServerEntity \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84 = (JiraServerEntity)this.getNode((TreeSearchEntity)\uac80\uc0c9\uc6a9_\uc11c\ubc84_\uc5d4\ud2f0\ud2f0);
        if (\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84 == null || \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_type() == null || \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_etc() == null) {
            throw new Exception("\ud504\ub9ac\uc14b \uc124\uc815\uc5d0 \ud544\uc694\ud55c \uc11c\ubc84 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        String \uc11c\ubc84_\uc720\ud615 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_type();
        if (StringUtils.equals((String)ServerType.JIRA_CLOUD.getType(), (String)\uc11c\ubc84_\uc720\ud615) && (projectCid == null || projectCid.isEmpty())) {
            \ud504\ub9ac\uc14b_\uacb0\uacfc = this.setCloudJiraProjectPreset(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84);
        }
        String \uacb0\uacfc_\uba54\uc138\uc9c0 = \ud504\ub9ac\uc14b_\uacb0\uacfc ? \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 \uc0c1\ud0dc \ud504\ub9ac\uc14b \uc5f0\uacb0\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4." : \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_name() + "\uc758 \uc0c1\ud0dc \ud504\ub9ac\uc14b \uc5f0\uacb0\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.";
        Global.chat.sendMessageByEngine(\uacb0\uacfc_\uba54\uc138\uc9c0);
    }

    private boolean setCloudJiraProjectPreset(JiraServerEntity \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84) throws Exception {
        boolean result = false;
        String \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514 = \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getC_jira_server_etc();
        Map \ub8f0\uc14b = this.getStatusRuleSet(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84);
        JiraIssueStatusCategoryMapEntity \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ud14c\uc774\ube14_\uac80\uc0c9 = new JiraIssueStatusCategoryMapEntity();
        List \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ubaa9\ub85d = this.jiraIssueStatusCategoryMap.getNodesWithoutRoot((TreeSearchEntity)\uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ud14c\uc774\ube14_\uac80\uc0c9);
        Map<String, Long> \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ub9f5 = \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(TreeBaseEntity::getC_title, JiraIssueStatusCategoryMapEntity::getC_req_state_mapping_id));
        HashSet<JiraProjectEntity> \ub3d9\uae30\ud654_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = new HashSet<JiraProjectEntity>();
        Set \ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = Optional.ofNullable(\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.getJiraProjectEntities()).orElse(new HashSet());
        for (JiraProjectEntity \ud504\ub85c\uc81d\ud2b82 : \ud574\ub2f9_\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d) {
            if (\ud504\ub85c\uc81d\ud2b82.getC_etc() != null && StringUtils.equals((String)\ud504\ub85c\uc81d\ud2b82.getC_etc(), (String)"delete")) continue;
            Set \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = this.setCloudJiraIssueType(\ud504\ub85c\uc81d\ud2b82, \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, \ub8f0\uc14b, \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ub9f5);
            if (\ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d != null) {
                \ud504\ub85c\uc81d\ud2b82.setJiraIssueTypeEntities(\ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d);
            }
            \ub3d9\uae30\ud654_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d.add(\ud504\ub85c\uc81d\ud2b82);
        }
        \uac80\uc0c9\ub41c_ALM_\uc11c\ubc84.setJiraProjectEntities(\ub3d9\uae30\ud654_\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d);
        try {
            this.updateNode((TreeSearchEntity)\uac80\uc0c9\ub41c_ALM_\uc11c\ubc84);
            result = true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return result;
    }

    private Set<JiraIssueTypeEntity> setCloudJiraIssueType(JiraProjectEntity jiraProjectEntity, String \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, Map<String, Map<String, StatusRuleSetEntity>> \ub8f0\uc14b, Map<String, Long> \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ub9f5) {
        List \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d;
        Set \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d = Optional.ofNullable(jiraProjectEntity.getJiraIssueTypeEntities()).orElse(new HashSet());
        try {
            \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d = this.engineService.\ud074\ub77c\uc6b0\ub4dc_\ud504\ub85c\uc81d\ud2b8\ubcc4_\uc774\uc288_\uc0c1\ud0dc_\ubaa9\ub85d(\uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514, jiraProjectEntity.getC_desc());
        }
        catch (Exception e) {
            String \uc624\ub958_\uba54\uc138\uc9c0 = \uc5d4\uc9c4_\ud1b5\uc2e0_\uc544\uc774\ub514 + "\uc11c\ubc84\uc758 " + jiraProjectEntity.getC_desc() + " \ud504\ub85c\uc81d\ud2b8 \uc774\uc288\uc0c1\ud0dc \uac31\uc2e0\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \ud504\ub85c\uc81d\ud2b8 \uc804\uccb4 \ud504\ub9ac\uc14b \uc911 \uc774\uc288 \uc0c1\ud0dc \uc870\ud68c \uc624\ub958 \ubc1c\uc0dd" + e.getMessage();
            log.error(\uc624\ub958_\uba54\uc138\uc9c0);
            Global.chat.sendMessageByEngine(\uc624\ub958_\uba54\uc138\uc9c0);
            return null;
        }
        Map<String, List> \uc774\uc288\uc720\ud615\ubcc4_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d_\ub9f5 = \uac00\uc838\uc628_\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d.stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152.getId(), \uc774\uc288\uc720\ud6152 -> \uc774\uc288\uc720\ud6152.getStatuses().stream().map(issueStatus -> {
            issueStatus.setIssueTypeId(\uc774\uc288\uc720\ud6152.getId());
            return issueStatus;
        }).collect(Collectors.toList())));
        for (JiraIssueTypeEntity issueType : \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d) {
            List \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d = \uc774\uc288\uc720\ud615\ubcc4_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d_\ub9f5.get(issueType.getC_issue_type_id());
            if (\uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d == null || \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d.size() == 0) continue;
            Set \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d = ((Set)Optional.ofNullable(issueType.getJiraIssueStatusEntities()).orElse(new HashSet())).stream().filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, JiraIssueStatusEntity> \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5 = Optional.ofNullable(\uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d).orElse(Collections.emptySet()).stream().filter(Objects::nonNull).collect(Collectors.toMap(\uc774\uc288\uc0c1\ud0dc -> \uc774\uc288\uc0c1\ud0dc.getC_issue_status_url(), \uc774\uc288\uc0c1\ud0dc -> \uc774\uc288\uc0c1\ud0dc));
            Set \uc774\uc288\uc0c1\ud0dc_\ub3d9\uae30\ud654\ubaa9\ub85d = this.setIssueStatusEntitiesOfIssueType(\uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d, \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5, \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d, \ub8f0\uc14b, \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ub9f5);
            issueType.setJiraIssueStatusEntities(\uc774\uc288\uc0c1\ud0dc_\ub3d9\uae30\ud654\ubaa9\ub85d);
        }
        return \ud504\ub85c\uc81d\ud2b8\uc758_\uc774\uc288\uc720\ud615_\ubaa9\ub85d;
    }

    private Set<JiraIssueStatusEntity> setIssueStatusEntitiesOfIssueType(Set<JiraIssueStatusEntity> \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d, Map<String, JiraIssueStatusEntity> \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5, List<\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130> \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d, Map<String, Map<String, StatusRuleSetEntity>> \ub8f0\uc14b, Map<String, Long> \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ub9f5) {
        Map \uc6b0\uc120\uc21c\uc704_\uac00\uc7a5\ub192\uc740_\uc0c1\ud0dc_\ub9f5 = \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d.stream().collect(Collectors.toMap(\uc870\ud68c\ub41c_\uc774\uc288\uc0c1\ud0dc -> \uc870\ud68c\ub41c_\uc774\uc288\uc0c1\ud0dc.getStatusCategory().getKey(), Function.identity(), (existing, replacement) -> {
            int \uae30\uc874_\uc6b0\uc120\uc21c\uc704 = ((StatusRuleSetEntity)((Map)\ub8f0\uc14b.get(existing.getStatusCategory().getKey())).get(existing.getName())).getPriority();
            int \uc0c8\ub85c\uc6b4_\uc6b0\uc120\uc21c\uc704 = ((StatusRuleSetEntity)((Map)\ub8f0\uc14b.get(replacement.getStatusCategory().getKey())).get(replacement.getName())).getPriority();
            return \uc0c8\ub85c\uc6b4_\uc6b0\uc120\uc21c\uc704 < \uae30\uc874_\uc6b0\uc120\uc21c\uc704 ? replacement : existing;
        }));
        for (\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130 \uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130 : \uc774\uc288\uc720\ud615_\uc774\uc288\uc0c1\ud0dc\ubaa9\ub85d) {
            boolean \uc5d4\ud2f0\ud2f0\uc874\uc7ac\uc5ec\ubd80 = \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5 != null && \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5.containsKey(\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130.getSelf());
            JiraIssueStatusEntity jiraIssueStatusEntity = \uc5d4\ud2f0\ud2f0\uc874\uc7ac\uc5ec\ubd80 ? \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5.get(\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130.getSelf()) : null;
            JiraIssueStatusEntity \uacb0\uacfc = null;
            String \uc0c1\ud0dc_\uce74\ud14c\uace0\ub9ac = \uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130.getStatusCategory().getKey();
            \uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130 \uc6b0\uc120\uc21c\uc704_\uac00\uc7a5\ub192\uc740_\uc0c1\ud0dc = (\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130)\uc6b0\uc120\uc21c\uc704_\uac00\uc7a5\ub192\uc740_\uc0c1\ud0dc_\ub9f5.get(\uc0c1\ud0dc_\uce74\ud14c\uace0\ub9ac);
            try {
                \uacb0\uacfc = this.\uc774\uc288\uc0c1\ud0dc_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8_\ub9e4\ud551(\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130, jiraIssueStatusEntity, \uc6b0\uc120\uc21c\uc704_\uac00\uc7a5\ub192\uc740_\uc0c1\ud0dc, \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac\ub9e4\ud551_\ub9f5);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            if (\uacb0\uacfc != null && !\uc5d4\ud2f0\ud2f0\uc874\uc7ac\uc5ec\ubd80) {
                \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d.add(\uacb0\uacfc);
            }
            \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5.remove(\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130.getSelf());
        }
        return this.\uc18c\ud504\ud2b8_\ub51c\ub9ac\ud2b8(\uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ub9f5, \uae30\uc874\uc774\uc288\uc0c1\ud0dc_\ubaa9\ub85d);
    }

    private JiraIssueStatusEntity \uc774\uc288\uc0c1\ud0dc_\uc800\uc7a5_\ub610\ub294_\uc5c5\ub370\uc774\ud2b8_\ub9e4\ud551(\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130 \uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc, JiraIssueStatusEntity \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc, \uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130 \uc6b0\uc120\uc21c\uc704_\uac00\uc7a5\ub192\uc740_\uc0c1\ud0dc, Map<String, Long> \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac_\ud14c\uc774\ube14_\ub9f5) throws Exception {
        int \uc5c5\ub370\uc774\ud2b8\uacb0\uacfc;
        boolean isNew = false;
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc == null) {
            isNew = true;
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc = new JiraIssueStatusEntity();
        }
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_status_id(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getId());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_status_name(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getName());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_status_url(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getSelf());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_status_desc(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getDescription());
        \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_issue_type_mapping_id(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc.getIssueTypeId());
        if (this.isHighestPriorityStatus(\uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc, \uc6b0\uc120\uc21c\uc704_\uac00\uc7a5\ub192\uc740_\uc0c1\ud0dc)) {
            this.setStatusPresetMapping(\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc, \uc5d4\uc9c4_\uc774\uc288\uc0c1\ud0dc, \uc0c1\ud0dc\uce74\ud14c\uace0\ub9ac_\ud14c\uc774\ube14_\ub9f5);
        } else {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_req_state_mapping_link(Long.valueOf(14L));
        }
        if (isNew) {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_check("false");
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setRef(TreeConstant.First_Node_CID.longValue());
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_type("default");
            return (JiraIssueStatusEntity)this.jiraIssueStatus.addNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc);
        }
        if (\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.getC_etc() != null && StringUtils.equals((String)"delete", (String)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.getC_etc())) {
            \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc.setC_etc(null);
        }
        return (\uc5c5\ub370\uc774\ud2b8\uacb0\uacfc = this.jiraIssueStatus.updateNode((TreeSearchEntity)\ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc)) == 1 ? \ubc31\uc5d4\ub4dc_\uc774\uc288\uc0c1\ud0dc : null;
    }

    private boolean isHighestPriorityStatus(\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130 currentStatus, \uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130 highestPriorityStatus) {
        return highestPriorityStatus != null && currentStatus.getSelf().equals(highestPriorityStatus.getSelf());
    }

    private void setStatusPresetMapping(JiraIssueStatusEntity issueStatus, \uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ub370\uc774\ud130 engineIssueStatus, Map<String, Long> statusCategoryMap) {
        String statusCategory = engineIssueStatus.getStatusCategory().getKey();
        Long mappingValue = statusCategoryMap.get(statusCategory);
        if (mappingValue != null) {
            issueStatus.setC_req_state_mapping_link(mappingValue);
        }
    }

    public void cacheStatusMappingData(JiraServerEntity jiraServerEntity) throws Exception {
        List jiraServerEntityList = this.getNodesWithoutRoot((TreeSearchEntity)jiraServerEntity);
        jiraServerEntityList.stream().filter(Objects::nonNull).forEach(arg_0 -> this.processAlmServer(arg_0));
    }

    private void processAlmServer(JiraServerEntity jiraServerEntity) {
        ServerType serverType = ServerType.fromString((String)jiraServerEntity.getC_jira_server_type());
        String serverId = jiraServerEntity.getC_jira_server_etc();
        if (serverType == ServerType.JIRA_CLOUD) {
            this.processJiraCloud(serverId, jiraServerEntity);
        } else if (serverType == ServerType.JIRA_ON_PREMISE || serverType == ServerType.REDMINE_ON_PREMISE) {
            this.processOnPremise(serverId, jiraServerEntity);
        }
    }

    private void processJiraCloud(String serverId, JiraServerEntity jiraServerEntity) {
        jiraServerEntity.getJiraProjectEntities().forEach(jiraProjectEntity -> jiraProjectEntity.getJiraIssueTypeEntities().forEach(jiraIssueTypeEntity -> this.cacheALMServerDTO(this.convertToIssueStatusDTOs(jiraIssueTypeEntity.getJiraIssueStatusEntities()), serverId, jiraProjectEntity.getC_jira_key(), jiraIssueTypeEntity.getC_issue_type_id())));
    }

    private List<IssueStatusDTO> convertToIssueStatusDTOs(Set<JiraIssueStatusEntity> issueStatusEntities) {
        return issueStatusEntities.stream().filter(Objects::nonNull).map(issueStatus -> new IssueStatusDTO(issueStatus.getC_issue_status_id(), issueStatus.getC_issue_status_name(), issueStatus.getC_req_state_mapping_link() != null ? issueStatus.getC_req_state_mapping_link().toString() : null)).collect(Collectors.toList());
    }

    private void processOnPremise(String serverId, JiraServerEntity jiraServerEntity) {
        this.cacheALMServerDTO(this.convertToIssueStatusDTOs(jiraServerEntity.getJiraIssueStatusEntities()), serverId, null, null);
    }

    public void cacheALMServerDTO(List<IssueStatusDTO> issueStatusDTOs, String serverId, String projectKeyOrId, String issueTypeId) {
        log.info("cacheALMServerDTO :: serverId = {}, projectKeyOrId = {}, issueTypeId = {}", new Object[]{serverId, projectKeyOrId, issueTypeId});
        this.middleProxyService.setAlmIssueStatusDTO(AlmDataRequestDTO.builder().serverId(serverId).projectKeyOrId(projectKeyOrId).issueTypeId(issueTypeId).issueStatusDTOs(issueStatusDTOs).build());
    }

    public JiraServerImpl(GlobalTreeMapService globalTreeMapService, EngineService engineService, MiddleProxyService middleProxyService, JiraProject jiraProject, JiraIssueType jiraIssueType, JiraIssueStatus jiraIssueStatus, JiraIssuePriority jiraIssuePriority, JiraIssueResolution jiraIssueResolution, JiraIssueStatusCategoryMap jiraIssueStatusCategoryMap, AES256Encryption aes256Encryption) {
        this.globalTreeMapService = globalTreeMapService;
        this.engineService = engineService;
        this.middleProxyService = middleProxyService;
        this.jiraProject = jiraProject;
        this.jiraIssueType = jiraIssueType;
        this.jiraIssueStatus = jiraIssueStatus;
        this.jiraIssuePriority = jiraIssuePriority;
        this.jiraIssueResolution = jiraIssueResolution;
        this.jiraIssueStatusCategoryMap = jiraIssueStatusCategoryMap;
        this.aes256Encryption = aes256Encryption;
    }
}

