/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.globaltreemap.controller;

import com.arms.api.globaltreemap.model.GlobalTreeMapDTO;
import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalTreeMapService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="TreeMapFramework")
public abstract class TreeMapAbstractController {
    private static final Logger log = LoggerFactory.getLogger(TreeMapAbstractController.class);
    @Autowired
    protected ModelMapper modelMapper;
    @Autowired
    protected GlobalTreeMapService globalTreeMapService;

    @GetMapping(value={"/find"})
    public ResponseEntity<?> findMapList(GlobalTreeMapDTO globalTreeMapDTO) {
        GlobalTreeMapEntity globalTreeMapEntity = (GlobalTreeMapEntity)this.modelMapper.map((Object)globalTreeMapDTO, GlobalTreeMapEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.globalTreeMapService.findAllBy(globalTreeMapEntity)));
    }

    @GetMapping(value={"/findBy"})
    public ResponseEntity<CommonResponse.ApiResult<GlobalTreeMapEntity>> findMap(@PathVariable Long mapKey) {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.globalTreeMapService.findById(mapKey)));
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<CommonResponse.ApiResult<List<GlobalTreeMapEntity>>> saveMapList(@RequestBody List<GlobalTreeMapDTO> globalTreeMapDTOs) {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.globalTreeMapService.saveAll(globalTreeMapDTOs.stream().map(dto -> (GlobalTreeMapEntity)this.modelMapper.map(dto, GlobalTreeMapEntity.class)).collect(Collectors.toList()))));
    }

    @PostMapping(value={"/saveOne"})
    public ResponseEntity<CommonResponse.ApiResult<GlobalTreeMapEntity>> saveMapOne(@RequestBody GlobalTreeMapDTO globalTreeMapDTO) {
        GlobalTreeMapEntity globalTreeMapEntity = (GlobalTreeMapEntity)this.modelMapper.map((Object)globalTreeMapDTO, GlobalTreeMapEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.globalTreeMapService.saveOne(globalTreeMapEntity)));
    }

    @DeleteMapping(value={"/delete/{mapKey}"})
    public ResponseEntity<CommonResponse.ApiResult<String>> deleteMapList(@PathVariable Long mapKey) {
        this.globalTreeMapService.delete(mapKey);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)"OK"));
    }

    @ResponseBody
    @RequestMapping(value={"/getAllGlobalTreeMap.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getAllGlobalTreeMap(GlobalTreeMapDTO globalTreeMapDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("GlobalTreeMapController :: getAllGlobalTreeMap");
        GlobalTreeMapEntity globalTreeMapEntity = (GlobalTreeMapEntity)this.modelMapper.map((Object)globalTreeMapDTO, GlobalTreeMapEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.globalTreeMapService.findAllBy(globalTreeMapEntity)));
    }

    @ResponseBody
    @RequestMapping(value={"/addGlobalTreeMap.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> addGlobalTreeMap(GlobalTreeMapDTO globalTreeMapDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("GlobalTreeMapController :: addGlobalTreeMap");
        GlobalTreeMapEntity globalTreeMapEntity = (GlobalTreeMapEntity)this.modelMapper.map((Object)globalTreeMapDTO, GlobalTreeMapEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.globalTreeMapService.saveOne(globalTreeMapEntity)));
    }

    @ResponseBody
    @RequestMapping(value={"/alterGlobalTreeMap.do"}, method={RequestMethod.PUT})
    public ResponseEntity<?> alterGlobalTreeMap(GlobalTreeMapDTO globalTreeMapDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("GlobalTreeMapController :: alterGlobalTreeMap");
        GlobalTreeMapEntity globalTreeMapEntity = (GlobalTreeMapEntity)this.modelMapper.map((Object)globalTreeMapDTO, GlobalTreeMapEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.globalTreeMapService.update(globalTreeMapEntity)));
    }

    @ResponseBody
    @RequestMapping(value={"/removeGlobalTreeMap.do"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> removeGlobalTreeMap(GlobalTreeMapDTO globalTreeMapDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("GlobalTreeMapController :: removeGlobalTreeMap");
        GlobalTreeMapEntity globalTreeMapEntity = (GlobalTreeMapEntity)this.modelMapper.map((Object)globalTreeMapDTO, GlobalTreeMapEntity.class);
        List globalTreeMapEntityList = this.globalTreeMapService.findAllBy(globalTreeMapEntity);
        if (globalTreeMapEntityList == null || globalTreeMapEntityList.isEmpty()) {
            return ResponseEntity.ok((Object)CommonResponse.error((String)"not found, thus not delete", (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
        }
        if (globalTreeMapEntityList.size() > 1) {
            return ResponseEntity.ok((Object)CommonResponse.error((String)"not found, thus not delete", (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
        }
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.globalTreeMapService.delete((GlobalTreeMapEntity)globalTreeMapEntityList.get(0))));
    }
}

