/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.dashboard.service;

import com.arms.api.analysis.resource.model.dto.ResourceDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.dto.VersionIdNameDTO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.analysis.resource.service.ResourceService;
import com.arms.api.dashboard.model.RequirementJiraIssueAggregationResponse;
import com.arms.api.dashboard.model.SankeyData;
import com.arms.api.dashboard.model.dto.DashboardDTO;
import com.arms.api.dashboard.model.vo.Top5AssigneeReqStatusInfoVO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeReqLinkVO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeVO;
import com.arms.api.dashboard.service.DashboardService;
import com.arms.api.product_service.pdserviceversion.service.PdServiceVersion;
import com.arms.api.requirement.reqadd.model.entity.ReqAddEntity;
import com.arms.api.requirement.reqadd.service.ReqAdd;
import com.arms.api.util.communicate.external.AggregationService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DashboardServiceImpl
implements DashboardService {
    private static final Logger log = LoggerFactory.getLogger(DashboardServiceImpl.class);
    private final AggregationService aggregationService;
    private final PdServiceVersion pdServiceVersion;
    private final ReqAdd reqAdd;
    private final ResourceService resourceService;

    public Map<String, RequirementJiraIssueAggregationResponse> requirementsJiraIssueStatuses(DashboardDTO dashboardDTO) {
        return (Map)this.aggregationService.aggregateWeeklyReqIssueStatus(dashboardDTO).getBody();
    }

    public SankeyData sankeyChartAPIWithTopN(DashboardDTO dashboardDTO, Integer topN) throws Exception {
        ResourceDTO resourceDTO = new ResourceDTO();
        resourceDTO.setPdServiceAndIsReq(dashboardDTO.getPdServiceAndIsReq());
        return this.resourceService.sankeyChartAPIWithTopN(resourceDTO, topN);
    }

    public List<TreeMapWorkerVO> findTreeMapChartDataV3(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception {
        PdServiceAndIsReqDTO pdServiceAndIsReq = resourceWithVersionIdNamesDTO.getPdServiceAndIsReq();
        List versionIdNames = this.pdServiceVersion.getVersionListByCids(pdServiceAndIsReq.getPdServiceVersionLinks()).stream().map(entity -> {
            VersionIdNameDTO dto = new VersionIdNameDTO();
            dto.setC_id(String.valueOf(entity.getC_id()));
            dto.setC_title(entity.getC_title());
            return dto;
        }).collect(Collectors.toList());
        resourceWithVersionIdNamesDTO.setVersionIdNames(versionIdNames);
        return this.resourceService.findTreeMapChartDataV3(resourceWithVersionIdNamesDTO);
    }

    public List<TopNReqAssigneeVO> findTopNReqAssignee(DashboardDTO dashboardDTO, Integer topN) {
        return this.aggregationService.topNReqAssignee(dashboardDTO, topN);
    }

    public List<Top5AssigneeReqStatusInfoVO> findTopNAssigneeReqStateInfo(String changeReqTableName, DashboardDTO dashboardDTO, Integer topN) throws Exception {
        Map reqLinkReqStateMap = this.getReqLinkReqState(changeReqTableName, dashboardDTO);
        List topNReqAssigneeReqLinkVOS = this.aggregationService.topNAssigneeReqLinks(dashboardDTO, topN);
        ArrayList<Top5AssigneeReqStatusInfoVO> result = new ArrayList<Top5AssigneeReqStatusInfoVO>();
        for (TopNReqAssigneeReqLinkVO topNReqAssigneeReqLinkVO : topNReqAssigneeReqLinkVOS) {
            String nameWithEmailId = topNReqAssigneeReqLinkVO.getNameWithEmailId();
            List reqLinks = topNReqAssigneeReqLinkVO.getReqLinks().stream().map(Long::parseLong).collect(Collectors.toList());
            Map statusCounts = this.calculateStatusCounts(reqLinks, reqLinkReqStateMap);
            statusCounts.forEach((statusId, count) -> result.add(Top5AssigneeReqStatusInfoVO.builder().assignee(nameWithEmailId).issueStatusId(statusId).issueStatusCount(count).build()));
        }
        return result;
    }

    private Map<Long, Long> calculateStatusCounts(List<Long> reqLinkIds, Map<Long, Long> reqLinkStatusMap) {
        HashMap<Long, Long> statusCountMap = new HashMap<Long, Long>();
        for (Long reqLinkId : reqLinkIds) {
            Long statusId;
            if (!reqLinkStatusMap.containsKey(reqLinkId) || (statusId = reqLinkStatusMap.get(reqLinkId)) == null) continue;
            statusCountMap.put(statusId, statusCountMap.getOrDefault(statusId, 0L) + 1L);
        }
        return statusCountMap;
    }

    private Map<Long, Long> getReqLinkReqState(String changeReqTableName, DashboardDTO dashboardDTO) throws Exception {
        SessionUtil.setAttribute((String)"getReqAddListByFilter", (Object)changeReqTableName);
        List pdServiceVersionLinks = dashboardDTO.pdServiceVersionLinks();
        ReqAddEntity searchEntity = new ReqAddEntity();
        if (pdServiceVersionLinks != null && !pdServiceVersionLinks.isEmpty()) {
            Disjunction orCondition = Restrictions.disjunction();
            for (Long version : pdServiceVersionLinks) {
                String versionString = "\\\"" + String.valueOf(version) + "\\\"";
                orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)versionString, (MatchMode)MatchMode.ANYWHERE));
            }
            searchEntity.getCriterions().add(orCondition);
        }
        List searchResult = this.reqAdd.getChildNode((TreeSearchEntity)searchEntity);
        HashMap<Long, Long> reqLinkReqStateMap = new HashMap<Long, Long>();
        for (ReqAddEntity entity : searchResult) {
            if (!StringUtils.equals((String)entity.getC_type(), (String)"default")) continue;
            Long reqAddId = entity.getC_id();
            Long stateId = Optional.ofNullable(entity).map(e -> e.getReqStateEntity()).map(e -> e.getC_id()).orElse(null);
            reqLinkReqStateMap.put(reqAddId, stateId);
        }
        SessionUtil.removeAttribute((String)"getReqAddListByFilter");
        return reqLinkReqStateMap;
    }

    public DashboardServiceImpl(AggregationService aggregationService, PdServiceVersion pdServiceVersion, ReqAdd reqAdd, ResourceService resourceService) {
        this.aggregationService = aggregationService;
        this.pdServiceVersion = pdServiceVersion;
        this.reqAdd = reqAdd;
        this.resourceService = resourceService;
    }
}

