/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.dashboard.controller;

import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.dashboard.model.RequirementJiraIssueAggregationResponse;
import com.arms.api.dashboard.model.SankeyData;
import com.arms.api.dashboard.model.dto.DashboardDTO;
import com.arms.api.dashboard.model.vo.Top5AssigneeReqStatusInfoVO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeVO;
import com.arms.api.dashboard.service.DashboardService;
import com.arms.api.util.GlobalConfig;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/arms/dashboard"})
public class DashboardController {
    private static final Logger log = LoggerFactory.getLogger(DashboardController.class);
    private final DashboardService dashboardService;
    private final GlobalConfig globalConfig;

    @GetMapping(value={"/aggregate-weekly-req-issue-status"})
    public ResponseEntity<CommonResponse.ApiResult<Map<String, RequirementJiraIssueAggregationResponse>>> requirementsJiraIssueStatuses(DashboardDTO dashboardDTO) {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.dashboardService.requirementsJiraIssueStatuses(dashboardDTO)));
    }

    @GetMapping(value={"/version-assignee-summary"}, name="dashboard-version-assignee-summary")
    public ResponseEntity<CommonResponse.ApiResult<SankeyData>> versionAssigneeIssueSummary(DashboardDTO dashboardDTO, @RequestParam(required=false) Integer topN) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.dashboardService.sankeyChartAPIWithTopN(dashboardDTO, topN)));
    }

    @GetMapping(value={"/assignees-requirements-involvements-v3"}, name="dashboard-treemap-v3")
    ResponseEntity<CommonResponse.ApiResult<List<TreeMapWorkerVO>>> findTreeMapChartDataV3(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.dashboardService.findTreeMapChartDataV3(resourceWithVersionIdNamesDTO)));
    }

    @GetMapping(value={"/top-req-assignee"})
    public ResponseEntity<CommonResponse.ApiResult<List<TopNReqAssigneeVO>>> findTopNReqAssignee(DashboardDTO dashboardDTO, @RequestParam(required=false) Integer topN) {
        log.info("[ DashboardController :: findTopNReqAssignee ] :: top {}", (Object)topN);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.dashboardService.findTopNReqAssignee(dashboardDTO, topN)));
    }

    @GetMapping(value={"/top-req-state-info/{changeReqTableName}/getReqAddListByFilter"})
    ResponseEntity<CommonResponse.ApiResult<List<Top5AssigneeReqStatusInfoVO>>> findTopNAssigneeReqStateInfo(@PathVariable(value="changeReqTableName") String changeReqTableName, DashboardDTO dashboardDTO, @RequestParam(required=false) Integer topN) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.dashboardService.findTopNAssigneeReqStateInfo(changeReqTableName, dashboardDTO, topN)));
    }

    @GetMapping(value={"/global/config/test"})
    public String getConfigTest() {
        return this.globalConfig.getConfigTest();
    }

    public DashboardController(DashboardService dashboardService, GlobalConfig globalConfig) {
        this.dashboardService = dashboardService;
        this.globalConfig = globalConfig;
    }
}

