/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.clientcase.controller;

import com.arms.api.clientcase.model.ClientCaseDTO;
import com.arms.api.clientcase.model.ClientCaseEntity;
import com.arms.api.clientcase.service.ClientCaseService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.UpdateNode;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RestController
@RequestMapping(value={"/anonymous/cover/experience"})
public class ClientCaseController
extends TreeAbstractController<ClientCaseService, ClientCaseDTO, ClientCaseEntity> {
    private static final Logger log = LoggerFactory.getLogger(ClientCaseController.class);
    private final ClientCaseService clientCaseService;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.clientCaseService);
        this.setTreeEntity(ClientCaseEntity.class);
    }

    @PostMapping(value={"/addExperience"})
    public ResponseEntity<CommonResponse.ApiResult<ClientCaseEntity>> addClientCase(@Validated(value={AddNode.class}) ClientCaseDTO clientCaseDTO) throws Exception {
        ClientCaseEntity clientCaseEntity = (ClientCaseEntity)this.modelMapper.map((Object)clientCaseDTO, ClientCaseEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.clientCaseService.addClientCase(clientCaseEntity)));
    }

    @GetMapping(value={"/getExperience/{clientCaseId}"})
    public ResponseEntity<CommonResponse.ApiResult<ClientCaseEntity>> getClientCase(@PathVariable(value="clientCaseId") Long clientCaseId) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.clientCaseService.getClientCase(clientCaseId)));
    }

    @PutMapping(value={"/updateExperience"})
    public ResponseEntity<CommonResponse.ApiResult<ClientCaseEntity>> updateClientCase(@Validated(value={UpdateNode.class}) ClientCaseDTO clientCaseDTO) throws Exception {
        ClientCaseEntity clientCaseEntity = (ClientCaseEntity)this.modelMapper.map((Object)clientCaseDTO, ClientCaseEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.clientCaseService.updateClientCase(clientCaseEntity)));
    }

    @DeleteMapping(value={"/removeExperience/{clientCaseId}"})
    public ResponseEntity<CommonResponse.ApiResult<ClientCaseEntity>> removeClientCase(@PathVariable(value="clientCaseId") Long clientCaseId) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.clientCaseService.removeClientCase(clientCaseId)));
    }

    @GetMapping(value={"/getExperienceList"})
    public ResponseEntity<CommonResponse.ApiResult<Map<String, Object>>> getClientCaseList(@ModelAttribute ClientCaseDTO clientCaseDTO, @RequestParam(defaultValue="1") int pageIndex, @RequestParam(defaultValue="12") int pageUnit) throws Exception {
        log.info("getClientCaseList - pageIndex={}, pageUnit={}", (Object)pageIndex, (Object)pageUnit);
        Map result = this.clientCaseService.getPaginatedClientCaseList(clientCaseDTO, pageIndex, pageUnit);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    public ClientCaseController(ClientCaseService clientCaseService) {
        this.clientCaseService = clientCaseService;
    }
}

