/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.blog.service;

import com.arms.api.blog.model.BlogDTO;
import com.arms.api.blog.model.BlogEntity;
import com.arms.api.blog.model.BlogVO;
import com.arms.api.blog.service.BlogService;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityNotFoundException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blogService")
public class BlogServiceImpl
extends TreeServiceImpl
implements BlogService {
    private static final Logger log = LoggerFactory.getLogger(BlogServiceImpl.class);
    private final ModelMapper modelMapper;
    private final EngineService engineService;

    @Transactional(readOnly=true)
    public BlogDTO getBlog(BlogDTO blogDTO) throws Exception {
        BlogEntity existingBlogEntity = (BlogEntity)this.getNode((TreeSearchEntity)((BlogEntity)this.modelMapper.map((Object)blogDTO, BlogEntity.class)));
        if (existingBlogEntity == null) {
            throw new EntityNotFoundException(blogDTO.getC_id() + "\ub294 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 Blog\uc785\ub2c8\ub2e4.");
        }
        BlogDTO resultDTO = (BlogDTO)this.modelMapper.map((Object)existingBlogEntity, BlogDTO.class);
        BlogDTO existingBlogDTOByEngine = (BlogDTO)this.engineService.getBlog(resultDTO).getBody();
        if (existingBlogDTOByEngine != null) {
            resultDTO.setC_blog_contents(existingBlogDTOByEngine.getC_blog_contents());
            resultDTO.setC_blog_view_count(existingBlogDTOByEngine.getC_blog_view_count());
        }
        return resultDTO;
    }

    @Transactional
    public BlogEntity addBlog(BlogDTO blogDTO) throws Exception {
        BlogEntity blogEntity = (BlogEntity)this.modelMapper.map((Object)blogDTO, BlogEntity.class);
        blogEntity.setRef(TreeConstant.First_Node_CID.longValue());
        blogEntity.setC_blog_created(new Date());
        blogEntity.setC_type("default");
        BlogEntity createdEntity = (BlogEntity)this.addNode((TreeSearchEntity)blogEntity);
        this.engineService.addBlog((BlogDTO)this.modelMapper.map((Object)createdEntity, BlogDTO.class));
        return createdEntity;
    }

    @Transactional
    public BlogEntity updateBlog(BlogDTO blogDTO) throws Exception {
        BlogEntity blogEntity = (BlogEntity)this.modelMapper.map((Object)blogDTO, BlogEntity.class);
        if (blogDTO.getC_id() == null || this.getNode((TreeSearchEntity)blogEntity) == null) {
            throw new EntityNotFoundException(blogDTO.getC_id() + "\ub294 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 Blog\uc785\ub2c8\ub2e4.");
        }
        blogEntity.setC_blog_updated(new Date());
        this.updateNode((TreeSearchEntity)blogEntity);
        this.updateBlogEngine(blogDTO);
        return blogEntity;
    }

    @Async
    protected void updateBlogEngine(BlogDTO blogDTO) {
        try {
            this.engineService.updateBlog(blogDTO);
        }
        catch (Exception e) {
            log.error("\ube14\ub85c\uadf8 \uc5d4\uc9c4 \uc5c5\ub370\uc774\ud2b8 \uc2e4\ud328: {}", (Object)e.getMessage());
        }
    }

    @Transactional
    public int removeBlog(BlogDTO blogDTO) throws Exception {
        BlogEntity blogEntity = (BlogEntity)this.modelMapper.map((Object)blogDTO, BlogEntity.class);
        if (blogDTO.getC_id() == null || this.getNode((TreeSearchEntity)blogEntity) == null) {
            throw new EntityNotFoundException(blogDTO.getC_id() + "\ub294 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 Blog\uc785\ub2c8\ub2e4.");
        }
        this.removeBlogEngine(blogDTO);
        return this.removeNode((TreeSearchEntity)blogEntity);
    }

    @Async
    protected void removeBlogEngine(BlogDTO blogDTO) {
        try {
            this.engineService.deleteBlog(blogDTO.getC_id().toString());
        }
        catch (Exception e) {
            log.error("\ube14\ub85c\uadf8 \uc5d4\uc9c4 \uc0ad\uc81c  \uc2e4\ud328: {}", (Object)e.getMessage());
        }
    }

    @Transactional(readOnly=true)
    public List<BlogEntity> getLatestBlogList(BlogDTO blogDto) throws Exception {
        BlogEntity blogEntity = (BlogEntity)this.modelMapper.map((Object)blogDto, BlogEntity.class);
        this.ignoreRootAndFirstNode(blogEntity);
        this.orderByCreatedDesc(blogEntity);
        this.updatePageInfo(blogEntity, 1, 4);
        return this.getPaginatedChildNode((TreeSearchEntity)blogEntity);
    }

    public List<BlogDTO> getPopularBlogList(BlogDTO blogDTO) {
        return (List)this.engineService.getBlogListByViewCountDesc(blogDTO).getBody();
    }

    @Transactional(readOnly=true)
    public Map<String, Object> getPaginatedBlogList(BlogDTO blogDTO, int pageIndex, int pageUnit) throws Exception {
        BlogEntity blogEntity = (BlogEntity)this.modelMapper.map((Object)blogDTO, BlogEntity.class);
        this.ignoreRootAndFirstNode(blogEntity);
        this.orderByCreatedDesc(blogEntity);
        this.updatePageInfo(blogEntity, pageIndex, pageUnit);
        List blogList = this.getPaginatedChildNode((TreeSearchEntity)blogEntity);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (blogList != null && !blogList.isEmpty()) {
            resultMap.put("paginationInfo", blogEntity.getPaginationInfo());
        } else {
            resultMap.put("paginationInfo", Map.of("totalRecordCount", 0, "lastPageNo", 0));
        }
        resultMap.put("data", blogList);
        return resultMap;
    }

    @Transactional(readOnly=true)
    public List<BlogEntity> getRecommendedBlogList(BlogDTO blogDTO) throws Exception {
        BlogEntity blogEntity = (BlogEntity)this.modelMapper.map((Object)blogDTO, BlogEntity.class);
        this.ignoreRootAndFirstNode(blogEntity);
        this.orderByCreatedDesc(blogEntity);
        this.updatePageInfo(blogEntity, 1, 5);
        return this.getPaginatedChildNode((TreeSearchEntity)blogEntity);
    }

    @Transactional(readOnly=true)
    public BlogVO searchBlogList(BlogDTO blogDTO) {
        return (BlogVO)this.engineService.getBlogListBySearchAfter(blogDTO).getBody();
    }

    private void ignoreRootAndFirstNode(BlogEntity blogEntity) {
        blogEntity.getCriterions().add(Restrictions.not((Criterion)Restrictions.in((String)"c_id", (Object[])new Object[]{TreeConstant.ROOT_CID, TreeConstant.First_Node_CID})));
    }

    private void orderByCreatedDesc(BlogEntity blogEntity) {
        blogEntity.getOrder().add(Order.desc((String)"c_blog_created"));
    }

    private void updatePageInfo(BlogEntity blogEntity, int pageIndex, int pageUnit) {
        blogEntity.setPageIndex(pageIndex);
        blogEntity.setPageUnit(pageUnit);
    }

    public BlogServiceImpl(ModelMapper modelMapper, EngineService engineService) {
        this.modelMapper = modelMapper;
        this.engineService = engineService;
    }
}

