/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.blog.controller;

import com.arms.api.blog.model.BlogDTO;
import com.arms.api.blog.model.BlogEntity;
import com.arms.api.blog.model.BlogVO;
import com.arms.api.blog.service.BlogService;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RestController
@RequestMapping(value={"/anonymous/arms/blog"})
public class BlogController
extends TreeAbstractController<BlogService, BlogDTO, BlogEntity> {
    private static final Logger log = LoggerFactory.getLogger(BlogController.class);
    private final BlogService blogService;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.blogService);
        this.setTreeEntity(BlogEntity.class);
    }

    @GetMapping(value={"/getBlog.do"})
    public ResponseEntity<BlogDTO> getBlog(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok((Object)this.blogService.getBlog(blogDTO));
    }

    @PostMapping(value={"/addBlog.do"})
    public ResponseEntity<BlogEntity> addBlog(@RequestBody BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok((Object)this.blogService.addBlog(blogDTO));
    }

    @PutMapping(value={"/updateBlog.do"})
    public ResponseEntity<BlogEntity> updateBlog(@RequestBody BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok((Object)this.blogService.updateBlog(blogDTO));
    }

    @DeleteMapping(value={"/removeBlog.do"})
    public ResponseEntity<Integer> removeBlog(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok((Object)this.blogService.removeBlog(blogDTO));
    }

    @GetMapping(value={"/latest/getBlogList.do"})
    public ResponseEntity<List<BlogEntity>> getLatestBlogList(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok((Object)this.blogService.getLatestBlogList(blogDTO));
    }

    @GetMapping(value={"/popular/getBlogList.do"})
    public ResponseEntity<List<BlogDTO>> getPopularBlogList(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok((Object)this.blogService.getPopularBlogList(blogDTO));
    }

    @GetMapping(value={"/recommended/getBlogList.do"})
    public ResponseEntity<List<BlogEntity>> getRecommendedBlogList(BlogDTO blogDTO) throws Exception {
        return ResponseEntity.ok((Object)this.blogService.getRecommendedBlogList(blogDTO));
    }

    @GetMapping(value={"/getPaginatedBlogList.do"})
    public ResponseEntity<Map<String, Object>> getPaginatedBlogList(BlogDTO blogDTO, @RequestParam(defaultValue="1") int pageIndex, @RequestParam(defaultValue="5") int pageUnit) throws Exception {
        return ResponseEntity.ok((Object)this.blogService.getPaginatedBlogList(blogDTO, pageIndex, pageUnit));
    }

    @GetMapping(value={"/hot/getKeywordList.do"})
    public ResponseEntity<List<String>> getHotKeywordList() throws Exception {
        ArrayList<String> demoKeywords = new ArrayList<String>();
        demoKeywords.add("\uc77c\uc815 \ubd84\uc11d");
        demoKeywords.add("\ubc94\uc704 \ubd84\uc11d");
        demoKeywords.add("\uc790\uc6d0 \ubd84\uc11d");
        demoKeywords.add("\uac04\ud2b8 \ubd84\uc11d");
        demoKeywords.add("\uc694\uad6c \ubd84\uc11d");
        demoKeywords.add("\uce78\ubc18 \uad00\ub9ac");
        demoKeywords.add("\ubc84\uc804 \ub9f5\ud551");
        demoKeywords.add("\uc778\uacf5\uc9c0\ub2a5 \ubd84\uc11d");
        return ResponseEntity.ok(demoKeywords);
    }

    @GetMapping(value={"/searchBlogList.do"})
    public ResponseEntity<BlogVO> searchBlogList(BlogDTO blogDTO) throws Exception {
        log.info("[BlogController :: searchBlogList ] :: blogDTO => {}", (Object)this.blogService.searchBlogList(blogDTO));
        return ResponseEntity.ok((Object)this.blogService.searchBlogList(blogDTO));
    }

    public BlogController(BlogService blogService) {
        this.blogService = blogService;
    }
}

