/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.topmenu.service;

import com.arms.api.analysis.resource.model.dto.ResourceDTO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeIssueStatusVO;
import com.arms.api.analysis.topmenu.model.dto.TopMenuAnalysisDTO;
import com.arms.api.analysis.topmenu.model.vo.ReqAndIssueTotalCountVO;
import com.arms.api.analysis.topmenu.model.vo.ReqAndSubtaskByAssigneeTotalVO;
import com.arms.api.analysis.topmenu.model.vo.ReqStatusCountVO;
import com.arms.api.analysis.topmenu.model.vo.TopMenuVO;
import com.arms.api.analysis.topmenu.model.vo.VersionPeriodVO;
import com.arms.api.analysis.topmenu.service.TopMenuService;
import com.arms.api.product_service.pdserviceversion.service.PdServiceVersion;
import com.arms.api.requirement.reqadd.model.entity.ReqAddEntity;
import com.arms.api.requirement.reqadd.service.ReqAdd;
import com.arms.api.util.RangeUtil;
import com.arms.api.util.communicate.external.AggregationService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TopMenuServiceImpl
implements TopMenuService {
    private static final Logger log = LoggerFactory.getLogger(TopMenuServiceImpl.class);
    private final AggregationService aggregationService;
    private final ReqAdd reqAdd;
    private final PdServiceVersion pdServiceVersion;

    public TopMenuVO getTopMenuData(String changeReqTableName, TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {
        PdServiceAndIsReqDTO pdServiceAndIsReq = topMenuAnalysisDTO.getPdServiceAndIsReq();
        List pdServiceVersionLinks = pdServiceAndIsReq.getPdServiceVersionLinks();
        SessionUtil.setAttribute((String)"getReqAddListByFilter", (Object)changeReqTableName);
        ReqAddEntity reqAddEntity = new ReqAddEntity();
        if (pdServiceVersionLinks != null && !pdServiceVersionLinks.isEmpty()) {
            Disjunction orCondition = Restrictions.disjunction();
            for (Long version : pdServiceVersionLinks) {
                orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)("\\\"" + version + "\\\""), (MatchMode)MatchMode.ANYWHERE));
            }
            reqAddEntity.getCriterions().add(orCondition);
        }
        ReqStatusCountVO reqStatusCountVO = new ReqStatusCountVO(this.reqAdd.getChildNode((TreeSearchEntity)reqAddEntity));
        SessionUtil.removeAttribute((String)"getReqAddListByFilter");
        VersionPeriodVO versionPeriodVO = this.topMenuVersionPeriod(topMenuAnalysisDTO);
        ReqAndIssueTotalCountVO reqAndIssueTotalCountVO = this.topMenuTotalCountWithReqAndSubtask(topMenuAnalysisDTO);
        ReqAndSubtaskByAssigneeTotalVO reqAndSubtaskByAssigneeTotalVO = this.topMenuResourceInfoWithReqAndSubtask(topMenuAnalysisDTO);
        return TopMenuVO.builder().reqStatusCountVO(reqStatusCountVO).versionPeriodVO(versionPeriodVO).reqAndIssueTotalCountVO(reqAndIssueTotalCountVO).reqAndSubtaskByAssigneeTotalVO(reqAndSubtaskByAssigneeTotalVO).build();
    }

    public ReqStatusCountVO analysisTopMenuReqStatusSummary(String changeReqTableName, Long pdServiceId, List<Long> pdServiceVersionLinks) throws Exception {
        SessionUtil.setAttribute((String)"getReqAddListByFilter", (Object)changeReqTableName);
        ReqAddEntity reqAddEntity = new ReqAddEntity();
        if (pdServiceVersionLinks != null && !pdServiceVersionLinks.isEmpty()) {
            Disjunction orCondition = Restrictions.disjunction();
            for (Long version : pdServiceVersionLinks) {
                orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)("\\\"" + version + "\\\""), (MatchMode)MatchMode.ANYWHERE));
            }
            reqAddEntity.getCriterions().add(orCondition);
        }
        ReqStatusCountVO reqStatusCountVO = new ReqStatusCountVO(this.reqAdd.getChildNode((TreeSearchEntity)reqAddEntity));
        SessionUtil.removeAttribute((String)"getReqAddListByFilter");
        log.info("[TopMenuServiceImpl  :: \ud1b1\uba54\ub274_\ubc84\uc804\ubcc4_\uc694\uad6c\uc0ac\ud56d_\uc790\ub8cc] :: \ubc84\uc804_\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc\ubcc4_\ud569\uacc4 :: \ucd1d\ud569 = {}, \uc5f4\ub9bc_\uc694\uad6c\uc0ac\ud56d = {}, \uc5f4\ub9bc\uc544\ub2cc_\uc694\uad6c\uc0ac\ud56d = {}", new Object[]{reqStatusCountVO.getTotalCount(), reqStatusCountVO.getOpenCount(), reqStatusCountVO.getTotalCount() - reqStatusCountVO.getOpenCount()});
        return reqStatusCountVO;
    }

    public ReqAndIssueTotalCountVO topMenuTotalCountWithReqAndSubtask(TopMenuAnalysisDTO topMenuAnalysisDTO) {
        return (ReqAndIssueTotalCountVO)this.aggregationService.topMenuTotalCountWithReqAndSubtask(topMenuAnalysisDTO).getBody();
    }

    public ReqAndSubtaskByAssigneeTotalVO topMenuResourceInfoWithReqAndSubtask(TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {
        PdServiceAndIsReqDTO pdServiceAndIsReq = topMenuAnalysisDTO.getPdServiceAndIsReq();
        ResourceDTO resourceDTO = new ResourceDTO();
        resourceDTO.setPdServiceAndIsReq(pdServiceAndIsReq);
        List uniqueAssigneeIssueStatusList = this.aggregationService.issueStatusDataByAssignee(resourceDTO);
        if (uniqueAssigneeIssueStatusList == null || uniqueAssigneeIssueStatusList.isEmpty()) {
            return ReqAndSubtaskByAssigneeTotalVO.builder().resource(Long.valueOf(0L)).reqIssue(Long.valueOf(0L)).reqIssueMax(Long.valueOf(0L)).reqIssueMin(Long.valueOf(0L)).notReqIssue(Long.valueOf(0L)).notReqIssueMax(Long.valueOf(0L)).notReqIssueMin(Long.valueOf(0L)).build();
        }
        Long resource = uniqueAssigneeIssueStatusList.size();
        Long reqTotal = 0L;
        Long notReqTotal = 0L;
        Long reqIssueMax = 0L;
        Long reqIssueMin = 1000000L;
        Long notReqIssueMax = 0L;
        Long notReqIssueMin = 1000000L;
        for (UniqueAssigneeIssueStatusVO vo : uniqueAssigneeIssueStatusList) {
            Long reqIssueCount = vo.getReqIssueCount();
            Long notReqIssueCount = vo.getNotReqIssueCount();
            reqTotal = reqTotal + reqIssueCount;
            notReqTotal = notReqTotal + notReqIssueCount;
            reqIssueMax = RangeUtil.returnIfGreater((Long)reqIssueCount, (Long)reqIssueMax);
            reqIssueMin = RangeUtil.returnIfLess((Long)reqIssueCount, (Long)reqIssueMin);
            notReqIssueMax = RangeUtil.returnIfGreater((Long)notReqIssueCount, (Long)notReqIssueMax);
            notReqIssueMin = RangeUtil.returnIfLess((Long)notReqIssueCount, (Long)notReqIssueMin);
        }
        return ReqAndSubtaskByAssigneeTotalVO.builder().resource(resource).reqIssue(reqTotal).reqIssueMax(reqIssueMax).reqIssueMin(reqIssueMin).notReqIssue(notReqTotal).notReqIssueMax(notReqIssueMax).notReqIssueMin(notReqIssueMin).build();
    }

    public VersionPeriodVO topMenuVersionPeriod(TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {
        List pdServiceVersionList = this.pdServiceVersion.getVersionListByCids(topMenuAnalysisDTO.pdServiceVersionLinks());
        LocalDate today = LocalDate.now();
        Optional<LocalDate> optionalEarliestStartDate = pdServiceVersionList.stream().map(versionEntity -> this.parseDateOrDefault(versionEntity.getC_pds_version_start_date(), today)).min(LocalDate::compareTo);
        Optional<LocalDate> optionalLatestEndDate = pdServiceVersionList.stream().map(versionEntity -> this.parseDateOrDefault(versionEntity.getC_pds_version_end_date(), today)).max(LocalDate::compareTo);
        String earliestStartDate = optionalEarliestStartDate.orElse(today).toString();
        String latestEndDate = optionalLatestEndDate.orElse(today).toString();
        return new VersionPeriodVO(earliestStartDate, latestEndDate);
    }

    private LocalDate parseDateOrDefault(String dateString, LocalDate defaultDate) {
        if ("start".equalsIgnoreCase(dateString) || "end".equalsIgnoreCase(dateString)) {
            return defaultDate;
        }
        return LocalDateTime.parse(dateString, DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm")).toLocalDate();
    }

    public TopMenuServiceImpl(AggregationService aggregationService, ReqAdd reqAdd, PdServiceVersion pdServiceVersion) {
        this.aggregationService = aggregationService;
        this.reqAdd = reqAdd;
        this.pdServiceVersion = pdServiceVersion;
    }
}

