/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.topmenu.controller;

import com.arms.api.analysis.topmenu.model.dto.TopMenuAnalysisDTO;
import com.arms.api.analysis.topmenu.model.vo.TopMenuVO;
import com.arms.api.analysis.topmenu.service.TopMenuService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/arms/analysis"})
public class TopMenuController {
    private static final Logger log = LoggerFactory.getLogger(TopMenuController.class);
    private final TopMenuService topMenuService;

    @PostMapping(value={"/top-menu/{changeReqTableName}/getReqAddListByFilter"})
    public ResponseEntity<?> analysisTopMenuReqStatusSummary(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {
        String pdServiceStr = StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQADD_", (String)"");
        log.info("TopMenuController :: analysisTopMenuReqStatusSummary.pdServiceId ==> {}, pdServiceVersionLinks ==> {}", (Object)pdServiceStr, (Object)topMenuAnalysisDTO.pdServiceVersionLinks());
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.topMenuService.analysisTopMenuReqStatusSummary(changeReqTableName, topMenuAnalysisDTO.pdServiceLink(), topMenuAnalysisDTO.pdServiceVersionLinks())));
    }

    @PostMapping(value={"/top-menu/{changeReqTableName}/comprehensive-data"})
    public ResponseEntity<TopMenuVO> analysisTopMenuData(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {
        log.info("TopMenuController :: pdServiceId ==> {}, pdServiceVersionLinks ==> {}", (Object)topMenuAnalysisDTO.pdServiceLink(), (Object)topMenuAnalysisDTO.pdServiceVersionLinks());
        return ResponseEntity.ok((Object)this.topMenuService.getTopMenuData(changeReqTableName, topMenuAnalysisDTO));
    }

    @GetMapping(value={"/top-menu/issue/req-and-subtask"})
    public ResponseEntity<?> analysisTopMenuSubTaskStatusSummary(TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {
        log.info("TopMenuController :: \ubd84\uc11d_\ud1b1\uba54\ub274_\uc774\uc288_\uc9d1\uacc4.pdServiceId ==> {}, pdServiceVersionLinks ==> {}", (Object)topMenuAnalysisDTO.pdServiceLink(), (Object)topMenuAnalysisDTO.pdServiceVersionLinks());
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.topMenuService.topMenuTotalCountWithReqAndSubtask(topMenuAnalysisDTO)));
    }

    @GetMapping(value={"/top-menu/resource-info"})
    public ResponseEntity<?> topMenuResourceInfoWithReqAndSubtask(TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {
        log.info("TopMenuController :: \ud1b1\uba54\ub274_\uc791\uc5c5\uc790\ubcc4_\uc694\uad6c\uc0ac\ud56d_\ud558\uc704\uc774\uc288_\uc9d1\uacc4 ==> {}, pdServiceVersionLinks ==> {}", (Object)topMenuAnalysisDTO.pdServiceLink(), (Object)topMenuAnalysisDTO.pdServiceVersionLinks());
        return ResponseEntity.ok((Object)this.topMenuService.topMenuResourceInfoWithReqAndSubtask(topMenuAnalysisDTO));
    }

    @GetMapping(value={"/top-menu/version/period"})
    public ResponseEntity<?> analysisTopMenuVersionPeriod(TopMenuAnalysisDTO topMenuAnalysisDTO) throws Exception {
        if (topMenuAnalysisDTO == null) {
            throw new RuntimeException("parameter is null");
        }
        if (topMenuAnalysisDTO.pdServiceVersionLinks() == null) {
            throw new RuntimeException("parameter pdSerivceVersionIds is null");
        }
        log.info("TopMenuController :: analysisTopMenuVersionPeriod.pdServiceVersionLinks ==> {}", (Object)topMenuAnalysisDTO.pdServiceVersionLinks());
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.topMenuService.topMenuVersionPeriod(topMenuAnalysisDTO)));
    }

    public TopMenuController(TopMenuService topMenuService) {
        this.topMenuService = topMenuService;
    }
}

