/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.time.service;

import com.arms.api.analysis.time.model.RidgeLineVO;
import com.arms.api.analysis.time.model.dto.TimeDTO;
import com.arms.api.analysis.time.model.vo.AlmIssueStatVO;
import com.arms.api.analysis.time.model.vo.AlmIssuesByVersionVO;
import com.arms.api.analysis.time.model.vo.HeatMapVO;
import com.arms.api.analysis.time.model.vo.ScatterChartVO;
import com.arms.api.analysis.time.service.TimeService;
import com.arms.api.util.communicate.external.AggregationService;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import com.arms.api.util.communicate.internal.InternalService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class TimeServiceImpl
implements TimeService {
    private static final Logger log = LoggerFactory.getLogger(TimeServiceImpl.class);
    private final InternalService internalService;
    private final EngineService engineService;
    private final AggregationService aggregationService;

    public HeatMapVO getHeatMapDataByUpdated(TimeDTO timeDTO) {
        return (HeatMapVO)this.engineService.getHeatMapDataByUpdated(timeDTO).getBody();
    }

    public List<ScatterChartVO> getScatterChartData(TimeDTO timeDTO) {
        return (List)this.engineService.getScatterData(timeDTO).getBody();
    }

    public List<AlmIssueStatVO> getMultiCombinationChartData(TimeDTO timeDTO) {
        return (List)this.aggregationService.getMultiCombinationChartData(timeDTO).getBody();
    }

    public List<AlmIssuesByVersionVO> getUpdatedPdServiceVersionAlmIssueByDate(TimeDTO timeDTO) {
        ResponseEntity searchDateRangeData = this.aggregationService.getUpdatedIssueByDateRange(timeDTO);
        Map<Long, List<AlmIssue>> versionGroupedResult = Optional.ofNullable((List)searchDateRangeData.getBody()).orElseGet(Collections::emptyList).stream().flatMap(issue -> issue.flattenPerVersionByVersions().stream()).collect(Collectors.groupingBy(AlmIssue::getPdServiceVersion));
        return versionGroupedResult.entrySet().stream().map(entry -> AlmIssuesByVersionVO.builder().pdServiceVersion((Long)entry.getKey()).issues((List)entry.getValue()).build()).collect(Collectors.toList());
    }

    public List<RidgeLineVO> getRidgeLineData(TimeDTO timeDTO) {
        return (List)this.aggregationService.getRidgeLineData(timeDTO).getBody();
    }

    public TimeServiceImpl(InternalService internalService, EngineService engineService, AggregationService aggregationService) {
        this.internalService = internalService;
        this.engineService = engineService;
        this.aggregationService = aggregationService;
    }
}

