/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.scope.service;

import com.arms.api.analysis.scope.model.dto.ScopeDTO;
import com.arms.api.analysis.scope.model.vo.CircularPackingChartVO;
import com.arms.api.analysis.scope.model.vo.CountByVersionNamesVO;
import com.arms.api.analysis.scope.model.vo.IssueVO;
import com.arms.api.analysis.scope.model.vo.NetworkChartExcelDataVO;
import com.arms.api.analysis.scope.model.vo.NetworkChartVO;
import com.arms.api.analysis.scope.model.vo.PdServiceVersionsAndReqVO;
import com.arms.api.analysis.scope.model.vo.ReqAddWithPropertyVO;
import com.arms.api.analysis.scope.model.vo.ReqDataTableIssuesVO;
import com.arms.api.analysis.scope.model.vo.TreeBarIssueVO;
import com.arms.api.analysis.scope.model.vo.TreeBarVO;
import com.arms.api.analysis.scope.model.vo.TreeNodeVO;
import com.arms.api.analysis.scope.service.ScopeService;
import com.arms.api.product_service.pdservice.model.PdServiceEntity;
import com.arms.api.product_service.pdservice.service.PdService;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.requirement.reqadd.model.entity.ReqAddEntity;
import com.arms.api.requirement.reqadd.model.vo.ReqAddVO;
import com.arms.api.requirement.reqadd.service.ReqAdd;
import com.arms.api.requirement.reqadd_pure.model.ReqAddPureEntity;
import com.arms.api.util.TreeServiceUtils;
import com.arms.api.util.VersionUtil;
import com.arms.api.util.communicate.external.AggregationService;
import com.arms.api.util.communicate.internal.InternalService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.treeframework.errors.exception.InvalidParamException;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.model.TreeBaseDTO;
import com.arms.egovframework.javaservice.treeframework.model.TreeBaseEntity;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.CallSite;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScopeServiceImpl
implements ScopeService {
    private static final Logger log = LoggerFactory.getLogger(ScopeServiceImpl.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private final ReqAdd reqAdd;
    private final PdService pdService;
    private final InternalService internalService;
    private final AggregationService aggregationService;

    public NetworkChartVO getReqNetworkFullData(String changeReqTableName, ScopeDTO scopeDTO) throws Exception {
        List reqList = this.getReqAddPureList(changeReqTableName, scopeDTO);
        List pdServiceVersionsAndReq = this.aggregationService.getPdServiceVersionsAndReq(scopeDTO);
        return this.generateNetworkChartData(scopeDTO, pdServiceVersionsAndReq, reqList);
    }

    public NetworkChartVO getReqNetworkVersionData(String changeReqTableName, ScopeDTO scopeDTO) throws Exception {
        List reqList = this.getReqAddList(changeReqTableName, scopeDTO);
        List issueData = this.aggregationService.getVersionsAndIssueList(scopeDTO);
        return this.generateNetworkChartWithIssueData(scopeDTO, issueData, reqList);
    }

    public NetworkChartVO getReqNetworkIssueData(String changeReqTableName, ScopeDTO scopeDTO) throws Exception {
        List reqList = this.getReqAddList(changeReqTableName, scopeDTO);
        List issueData = this.aggregationService.getIssueList(scopeDTO);
        return this.generateNetworkChartWithIssueData(scopeDTO, issueData, reqList);
    }

    private List<ReqAddPureEntity> getReqAddPureList(String changeReqTableName, ScopeDTO scopeDTO) throws Exception {
        SessionUtil.setAttribute((String)"issue-network", (Object)changeReqTableName);
        List reqList = this.getReqAddPureEntities(scopeDTO);
        SessionUtil.removeAttribute((String)"issue-network");
        return reqList;
    }

    private List<ReqAddPureEntity> getReqAddList(String changeReqTableName, ScopeDTO scopeDTO) throws Exception {
        SessionUtil.setAttribute((String)"getReqAddListByFilter", (Object)changeReqTableName);
        List reqList = this.getReqAddPureEntities(scopeDTO);
        SessionUtil.removeAttribute((String)"getReqAddListByFilter");
        return reqList;
    }

    private NetworkChartVO generateNetworkChartData(ScopeDTO scopeDTO, List<PdServiceVersionsAndReqVO> pdServiceVersionsAndReq, List<ReqAddPureEntity> reqList) throws Exception {
        String pdServiceId = "pdService-" + scopeDTO.getPdServiceAndIsReq().getPdServiceLink();
        List pdServiceVersionLinks = scopeDTO.getPdServiceAndIsReq().getPdServiceVersionLinks();
        ArrayList links = new ArrayList();
        HashMap<CallSite, NetworkChartVO.Node> nodeMap = new HashMap<CallSite, NetworkChartVO.Node>();
        nodeMap.put((CallSite)((Object)pdServiceId), this.createNode(pdServiceId, String.valueOf(scopeDTO.getPdServiceAndIsReq().getPdServiceLink()), "pdService"));
        pdServiceVersionLinks.forEach(versionLink -> {
            String versionId = "version-" + versionLink;
            links.add(this.createLink(versionId, pdServiceId));
            nodeMap.put((CallSite)((Object)versionId), this.createNode(versionId, String.valueOf(versionLink), "version"));
        });
        ObjectMapper objectMapper = new ObjectMapper();
        reqList.stream().filter(req -> req.getC_req_pdservice_versionset_link() != null && !req.getC_req_pdservice_versionset_link().trim().isEmpty()).forEach(req -> {
            try {
                String reqNodeId = "requirement-" + req.getC_id();
                List versionIdList = (List)objectMapper.readValue(req.getC_req_pdservice_versionset_link(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                versionIdList.forEach(versionId -> {
                    NetworkChartVO.Node versionNode = (NetworkChartVO.Node)nodeMap.get("version-" + versionId);
                    if (versionNode != null) {
                        links.add(this.createLink(reqNodeId, versionNode.getId()));
                    }
                });
                nodeMap.put((CallSite)((Object)reqNodeId), this.createNode(reqNodeId, req.getC_title(), "requirement"));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        });
        pdServiceVersionsAndReq.forEach(reqVO -> {
            Long cReqLink = reqVO.getCReqLink();
            String reqNodeId = "requirement-" + cReqLink;
            NetworkChartVO.Node reqNode = (NetworkChartVO.Node)nodeMap.get(reqNodeId);
            if (reqNode != null && reqVO.getReqId() != null) {
                nodeMap.put((CallSite)((Object)reqVO.getRecentId()), this.createIssueNode(reqVO));
                links.add(this.createLink(reqVO.getRecentId(), reqNodeId));
            }
        });
        return NetworkChartVO.builder().links(links).nodes(new ArrayList(nodeMap.values())).build();
    }

    private NetworkChartVO generateNetworkChartWithIssueData(ScopeDTO scopeDTO, List<IssueVO> issueData, List<ReqAddPureEntity> reqList) throws Exception {
        String pdServiceId = "pdService-" + scopeDTO.getPdServiceAndIsReq().getPdServiceLink();
        List pdServiceVersionLinks = scopeDTO.getPdServiceAndIsReq().getPdServiceVersionLinks();
        ArrayList links = new ArrayList();
        HashMap<Object, NetworkChartVO.Node> nodeMap = new HashMap<Object, NetworkChartVO.Node>();
        HashSet linkSeen = new HashSet();
        nodeMap.put(pdServiceId, this.createNode(pdServiceId, String.valueOf(scopeDTO.getPdServiceAndIsReq().getPdServiceLink()), "pdService"));
        for (Long versionLink : pdServiceVersionLinks) {
            String versionId = "version-" + versionLink;
            nodeMap.putIfAbsent(versionId, this.createNode(versionId, String.valueOf(versionLink), "version"));
            this.addLinkDedup(links, linkSeen, versionId, pdServiceId, "sub");
        }
        ObjectMapper om = new ObjectMapper();
        Map reqById = reqList.stream().collect(Collectors.toMap(ReqAddPureEntity::getC_id, Function.identity()));
        Set<Long> aliveReqIds = reqById.keySet();
        for (ReqAddPureEntity req : reqList) {
            List versions;
            Long cId = req.getC_id();
            String reqNodeId = "requirement-" + cId;
            nodeMap.putIfAbsent(reqNodeId, this.createNode(reqNodeId, req.getC_title(), "requirement"));
            String raw = req.getC_req_pdservice_versionset_link();
            if (raw == null || raw.trim().isEmpty() || (versions = (List)om.readValue(raw, List.class)) == null) continue;
            for (String v : versions) {
                String versionId = "version-" + v;
                nodeMap.putIfAbsent(versionId, this.createNode(versionId, v, "version"));
                this.addLinkDedup(links, linkSeen, reqNodeId, versionId, "sub");
            }
        }
        for (IssueVO issue : issueData) {
            Long cReqId;
            if (Boolean.TRUE.equals(issue.getIsReq()) && ((cReqId = issue.getCReqLink()) == null || !aliveReqIds.contains(cReqId))) continue;
            nodeMap.putIfAbsent(issue.getRecentId(), this.createIssueNode(issue));
        }
        Map<String, String> issueKeyToRecentId = issueData.stream().filter(i -> i.getIssueKey() != null && !i.getIssueKey().isEmpty()).filter(i -> nodeMap.containsKey(i.getRecentId())).collect(Collectors.toMap(IssueVO::getIssueKey, IssueVO::getRecentId, (a, b) -> a));
        for (IssueVO issue : issueData) {
            Long cReqId;
            if (!Boolean.TRUE.equals(issue.getIsReq()) || issue.getCReqLink() == null || !aliveReqIds.contains(cReqId = issue.getCReqLink())) continue;
            String reqNodeId = "requirement-" + cReqId;
            ReqAddPureEntity req = (ReqAddPureEntity)reqById.get(cReqId);
            if (req == null) continue;
            nodeMap.putIfAbsent(reqNodeId, this.createNode(reqNodeId, req.getC_title(), "requirement"));
            this.addLinkDedup(links, linkSeen, issue.getRecentId(), reqNodeId, "sub");
        }
        for (IssueVO issue : issueData) {
            String parentRecentId;
            String parentKey;
            if (!"SUB".equals(issue.getIssueType()) || (parentKey = issue.getParentReqKey()) == null || parentKey.isEmpty() || (parentRecentId = issueKeyToRecentId.get(parentKey)) == null || !nodeMap.containsKey(parentRecentId)) continue;
            this.addLinkDedup(links, linkSeen, issue.getRecentId(), parentRecentId, "sub");
        }
        for (IssueVO issue : issueData) {
            List linked = issue.getLinkedIssueKeys();
            if (linked == null || linked.isEmpty()) continue;
            for (String other : linked) {
                String otherId;
                if (other == null || other.isEmpty() || (otherId = nodeMap.containsKey(other) ? other : issueKeyToRecentId.get(other)) == null || otherId.equals(issue.getRecentId()) || !nodeMap.containsKey(otherId)) continue;
                this.addLinkDedup(links, linkSeen, issue.getRecentId(), otherId, "link");
            }
        }
        return NetworkChartVO.builder().links(links).nodes(new ArrayList(nodeMap.values())).build();
    }

    private NetworkChartVO.Link createLink(String source, String target) {
        return NetworkChartVO.Link.builder().source(source).target(target).build();
    }

    private NetworkChartVO.Link createLink(String source, String target, String relation) {
        return NetworkChartVO.Link.builder().source(source).target(target).relation(relation).build();
    }

    private NetworkChartVO.Node createNode(String id, String key, String type) {
        return NetworkChartVO.Node.builder().id(id).key(key).type(type).build();
    }

    private NetworkChartVO.Node createIssueNode(PdServiceVersionsAndReqVO reqVO) {
        Object key = reqVO.getReqId();
        if (key == null) {
            log.error("key is null, cReqLink => {}", (Object)reqVO.getCReqLink());
        }
        if (reqVO.getRelatedIssueCount() > 0L) {
            key = (String)key + "(" + reqVO.getRelatedIssueCount() + ")";
        }
        return NetworkChartVO.Node.builder().id(reqVO.getRecentId()).key((String)key).type("REQ").isReq(Boolean.valueOf(true)).build();
    }

    private NetworkChartVO.Node createIssueNode(IssueVO issueVO) {
        return NetworkChartVO.Node.builder().id(issueVO.getRecentId()).type(issueVO.getIssueType()).key(issueVO.getIssueKey()).parentReqKey(issueVO.getParentReqKey()).isReq(issueVO.getIsReq()).reqLink(issueVO.getCReqLink()).build();
    }

    private void addLinkDedup(List<NetworkChartVO.Link> links, Set<String> seen, String source, String target, String relation) {
        String b;
        if (source == null || target == null || source.equals(target)) {
            return;
        }
        String a = source.compareTo(target) <= 0 ? source : target;
        String key = relation + "|" + a + "|" + (b = source.compareTo(target) <= 0 ? target : source);
        if (seen.add(key)) {
            links.add(this.createLink(source, target, relation));
        }
    }

    public List<TreeNodeVO> getReqNetworkFilterData(String changeReqTableName, ScopeDTO scopeDTO) throws Exception {
        SessionUtil.setAttribute((String)"getReqAddListByFilter", (Object)changeReqTableName);
        List reqList = this.getReqAddPureEntities(scopeDTO);
        HashMap<String, Map> serviceVersionMap = new HashMap<String, Map>();
        ObjectMapper objectMapper = new ObjectMapper();
        for (ReqAddPureEntity req : reqList) {
            String serviceId = req.getC_req_pdservice_link();
            String versionIds = req.getC_req_pdservice_versionset_link();
            if (versionIds == null || versionIds.trim().isEmpty()) continue;
            List versionIdList = (List)objectMapper.readValue(versionIds, List.class);
            serviceVersionMap.putIfAbsent(serviceId, new HashMap());
            Map versionMap = serviceVersionMap.computeIfAbsent(serviceId, k -> new HashMap());
            for (String versionId : versionIdList) {
                List reqListForVersion = versionMap.computeIfAbsent(versionId, k -> new ArrayList());
                reqListForVersion.add(req);
            }
        }
        SessionUtil.removeAttribute((String)"getReqAddListByFilter");
        return serviceVersionMap.entrySet().stream().map(serviceEntry -> new TreeNodeVO("service_" + (String)serviceEntry.getKey(), List.of(String.valueOf(serviceEntry.getKey())), "service", new TreeNodeVO.TreeNodeAttributes("service", String.valueOf(serviceEntry.getKey()), String.valueOf(serviceEntry.getKey())), "opened", 0, ((Map)serviceEntry.getValue()).entrySet().stream().map(versionEntry -> new TreeNodeVO("version_" + (String)versionEntry.getKey(), List.of(String.valueOf(versionEntry.getKey())), "version", new TreeNodeVO.TreeNodeAttributes("version", String.valueOf(versionEntry.getKey()), (String)versionEntry.getKey()), "opened", 0, ((List)versionEntry.getValue()).stream().map(req -> new TreeNodeVO("req_" + req.getId(), List.of(req.getC_title()), "requirement", new TreeNodeVO.TreeNodeAttributes("requirement", String.valueOf(req.getC_id()), req.getC_title()), "opened", 0, null)).collect(Collectors.toList()))).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public List<CircularPackingChartVO> getCircularPackingChartData(String changeReqTableName, ScopeDTO scopeDTO) throws Exception {
        List reqList = this.getReqAddList(changeReqTableName, scopeDTO);
        List reqIdList = reqList.stream().map(ReqAddPureEntity::getC_id).filter(Objects::nonNull).collect(Collectors.toList());
        scopeDTO.setReqIdList(reqIdList);
        List reqData = this.aggregationService.getCircularPackingChartData(scopeDTO);
        Stream<CircularPackingChartVO> almStream = reqData.stream().map(req -> CircularPackingChartVO.builder().almState(req.getAlmState()).linkedIssueCount(req.getLinkedIssueCount()).subTaskCount(req.getSubTaskCount()).workersList(req.getWorkersList()).recentId(req.getRecentId()).issueKey(req.getIssueKey()).cReqLink(req.getCReqLink()).serviceId(req.getServiceId()).versions(req.getVersions()).type(req.getType()).build());
        Stream<CircularPackingChartVO> armsStream = reqList.stream().map(req -> CircularPackingChartVO.builder().title(req.getC_title()).stateLink(String.valueOf(req.getC_req_state_link())).cReqLink(req.getC_id()).versions(this.parseVersionList(req.getC_req_pdservice_versionset_link())).serviceId(Long.valueOf(req.getC_req_pdservice_link())).type("ARMS").build());
        return Stream.concat(almStream, armsStream).collect(Collectors.toList());
    }

    private List<Long> parseVersionList(String versionSetLink) {
        return Optional.of(VersionUtil.stringToLongArray((String)versionSetLink)).map(Arrays::asList).orElse(Collections.emptyList());
    }

    private String getVersionNames(Map<Long, String> versionNameMap, Long[] versionArr) {
        String key = Arrays.stream(versionArr).map(version -> versionNameMap.getOrDefault(version, "")).collect(Collectors.joining(","));
        log.info("[ScopeServiceImple  :: \ubc84\uc804_\uc694\uad6c\uc0ac\ud56d_\uc790\ub8cc] :: \ub9cc\ub4e4\uc5b4\uc9c4Key ==> {}", (Object)key);
        return key;
    }

    private PdServiceEntity getPdServiceEntity(Long pdServiceId) throws Exception {
        PdServiceEntity pdServiceEntity = new PdServiceEntity();
        pdServiceEntity.setC_id(pdServiceId);
        return (PdServiceEntity)this.pdService.getNode((TreeSearchEntity)pdServiceEntity);
    }

    public List<CountByVersionNamesVO> countByVersionNames(String changeReqTableName, ScopeDTO scopeDTO) throws Exception {
        Long pdServiceId = scopeDTO.getPdServiceAndIsReq().getPdServiceLink();
        SessionUtil.setAttribute((String)"getReqAddListByFilter", (Object)changeReqTableName);
        Map verserionNameMap = this.getPdServiceEntity(pdServiceId).versionNameMap();
        List reqAddEntities = this.getReqAddEntitiesWithDate(scopeDTO);
        Map<String, Long> countByVersionNamesMap = reqAddEntities.stream().collect(Collectors.groupingBy(entity -> this.getVersionNames(verserionNameMap, VersionUtil.stringToLongArray((String)entity.getC_req_pdservice_versionset_link())), Collectors.counting()));
        SessionUtil.removeAttribute((String)"getReqAddListByFilter");
        log.info("[ScopeServiceImple  :: \ubc84\uc804_\uc694\uad6c\uc0ac\ud56d_\uc790\ub8cc] :: \ubc84\uc804_\uc694\uad6c\uc0ac\ud56d_\ub9f5 ==> {}", countByVersionNamesMap);
        return this.countByVersionNames(countByVersionNamesMap);
    }

    private List<CountByVersionNamesVO> countByVersionNames(Map<String, Long> countByVersionNamesMap) {
        return countByVersionNamesMap.entrySet().stream().map(CountByVersionNamesVO::new).collect(Collectors.toList());
    }

    public List<ReqAddWithPropertyVO> reqAddWithPropertyListPerVersion(String changeReqTableName, Long pdServiceId, List<Long> pdServiceVersionLinks) throws Exception {
        SessionUtil.setAttribute((String)"req-property-list", (Object)changeReqTableName);
        Map versionNameMap = this.getPdServiceEntity(pdServiceId).versionNameMap();
        List<ReqAddWithPropertyVO> voList = this.getReqAddEntities(pdServiceVersionLinks).stream().map(reqAddEntity -> {
            String versionNames = this.getVersionNames(versionNameMap, VersionUtil.stringToLongArray((String)reqAddEntity.getC_req_pdservice_versionset_link()));
            return ReqAddWithPropertyVO.builder().pdServiceId(pdServiceId).reqId(reqAddEntity.getC_id()).versionNames(versionNames).reqTitle(reqAddEntity.getC_title()).priorityName(reqAddEntity.getReqPriorityEntity().getC_title()).difficultyName(reqAddEntity.getReqDifficultyEntity().getC_title()).stateName(reqAddEntity.getReqStateEntity().getC_title()).build();
        }).collect(Collectors.toList());
        SessionUtil.removeAttribute((String)"req-property-list");
        return voList;
    }

    private List<ReqAddEntity> getReqAddEntities(List<Long> pdServiceVersionLinks) throws Exception {
        ReqAddEntity reqAddEntity = new ReqAddEntity();
        Disjunction orCondition = Restrictions.disjunction();
        for (Long version : pdServiceVersionLinks) {
            orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)("\\\"" + String.valueOf(version) + "\\\""), (MatchMode)MatchMode.ANYWHERE));
        }
        reqAddEntity.getCriterions().add(orCondition);
        reqAddEntity.getCriterions().add(Restrictions.eq((String)"c_type", (Object)"default"));
        return this.reqAdd.getChildNode((TreeSearchEntity)reqAddEntity);
    }

    private List<ReqAddEntity> getReqAddEntitiesWithDate(ScopeDTO scopeDTO) throws Exception {
        Date tempDate;
        List pdServiceVersionLinks = scopeDTO.getPdServiceAndIsReq().getPdServiceVersionLinks();
        ReqAddEntity reqAddEntity = new ReqAddEntity();
        Disjunction orCondition = Restrictions.disjunction();
        for (Long version : pdServiceVersionLinks) {
            orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)("\\\"" + String.valueOf(version) + "\\\""), (MatchMode)MatchMode.ANYWHERE));
        }
        reqAddEntity.getCriterions().add(orCondition);
        reqAddEntity.getCriterions().add(Restrictions.eq((String)"c_type", (Object)"default"));
        SimpleDateFormat inputFormat = new SimpleDateFormat("yy-MM-dd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = null;
        Date endDate = null;
        if (scopeDTO.getStartDate() != null) {
            tempDate = inputFormat.parse(scopeDTO.getStartDate());
            startDate = outputFormat.parse(outputFormat.format(tempDate));
        }
        if (scopeDTO.getEndDate() != null) {
            tempDate = inputFormat.parse(scopeDTO.getEndDate());
            endDate = outputFormat.parse(outputFormat.format(tempDate));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            endDate = calendar.getTime();
        }
        if (startDate != null && endDate != null) {
            reqAddEntity.getCriterions().add(Restrictions.between((String)"c_req_create_date", (Object)startDate, endDate));
        } else if (startDate != null) {
            reqAddEntity.getCriterions().add(Restrictions.ge((String)"c_req_create_date", (Object)startDate));
        } else if (endDate != null) {
            reqAddEntity.getCriterions().add(Restrictions.le((String)"c_req_create_date", (Object)endDate));
        }
        return this.reqAdd.getChildNode((TreeSearchEntity)reqAddEntity);
    }

    private List<ReqAddPureEntity> getReqAddPureEntities(ScopeDTO scopeDTO) throws Exception {
        List pdServiceVersionLinks = scopeDTO.getPdServiceAndIsReq().getPdServiceVersionLinks();
        ReqAddPureEntity reqAddEntity = new ReqAddPureEntity();
        Disjunction orCondition = Restrictions.disjunction();
        if (scopeDTO.getReqId() != null && !scopeDTO.getReqId().isEmpty()) {
            orCondition.add((Criterion)Restrictions.eq((String)"c_id", (Object)Long.parseLong(scopeDTO.getReqId())));
        } else {
            for (Long version : pdServiceVersionLinks) {
                orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)("\\\"" + String.valueOf(version) + "\\\""), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        reqAddEntity.getCriterions().add(orCondition);
        reqAddEntity.getCriterions().add(Restrictions.eq((String)"c_type", (Object)"default"));
        return this.reqAdd.getChildNode((TreeSearchEntity)reqAddEntity);
    }

    public List<ReqDataTableIssuesVO> getDataTableIssues(ScopeDTO scopeDTO) throws Exception {
        return this.aggregationService.getDataTableIssues(scopeDTO);
    }

    public List<TreeBarVO> treeBarData(ScopeDTO scopeDTO) throws Exception {
        Long pdServiceId = scopeDTO.getPdServiceAndIsReq().getPdServiceLink();
        PdServiceEntity pdServiceEntity = (PdServiceEntity)TreeServiceUtils.getNodeOptional((TreeService)this.pdService, (Long)pdServiceId, PdServiceEntity.class).orElseThrow(() -> {
            throw new InvalidParamException("ScopeServiceImpl :: treebar :: product is null");
        });
        ArrayList<TreeBarVO> treeBars = new ArrayList<TreeBarVO>(List.of(this.createTreeBarVO(pdServiceEntity)));
        List treeBarIssueVOS = Optional.ofNullable((List)this.aggregationService.treeBarData(scopeDTO).getBody()).orElseGet(() -> {
            log.info("No data returned from treeBarTopData");
            return Collections.emptyList();
        });
        assert (treeBarIssueVOS != null);
        List cReqLinksTop10 = treeBarIssueVOS.stream().map(TreeBarIssueVO::getCReqLink).distinct().collect(Collectors.toList());
        List reqAddVOS = Optional.ofNullable((List)this.internalService.reqAddList("T_ARMS_REQADD_" + pdServiceId, cReqLinksTop10).getBody()).orElseGet(() -> {
            log.info("No data returned from reqAddList");
            return Collections.emptyList();
        });
        treeBars.addAll(this.getTreeBarVOSWithVersionLinks(pdServiceEntity, scopeDTO, reqAddVOS));
        treeBars.addAll(this.getReqAddVOToTreeBarVO(reqAddVOS));
        treeBars.addAll(this.getAssignees(treeBarIssueVOS, reqAddVOS));
        return treeBars;
    }

    private List<TreeBarVO> getTreeBarVOSWithVersionLinks(PdServiceEntity pdServiceEntity, ScopeDTO scopeDTO, List<ReqAddVO> reqAddVOS) {
        PdServiceAndIsReqDTO pdServiceAndIsReq = scopeDTO.getPdServiceAndIsReq();
        List pdServiceVersionLinks = pdServiceAndIsReq.getPdServiceVersionLinks();
        return this.getReqAddVOToTreeBarVO(reqAddVOS).stream().map(filteredRequirement -> {
            Set reqVersionLinks = filteredRequirement.reqVersionLinks();
            return TreeBarVO.builder().id(filteredRequirement.getParent()).name(this.getReqVersionName(pdServiceEntity.versionList(pdServiceVersionLinks), reqVersionLinks)).color("").type("version").parent(String.valueOf(pdServiceEntity.getC_id())).build();
        }).distinct().collect(Collectors.toList());
    }

    private TreeBarVO createTreeBarVO(PdServiceEntity product) {
        return TreeBarVO.builder().id(product.getC_id().toString()).name(product.getC_title()).type("product").color("").parent("").build();
    }

    private List<TreeBarVO> getReqAddVOToTreeBarVO(List<ReqAddVO> reqAddVOS) {
        return Optional.ofNullable(reqAddVOS).orElse(Collections.emptyList()).stream().map(TreeBarVO::new).collect(Collectors.toList());
    }

    private String getReqVersionName(List<PdServiceVersionEntity> productVersions, Set<Long> reqVersionLinks) {
        return productVersions.stream().filter(version -> reqVersionLinks.contains(version.getC_id())).map(TreeBaseEntity::getC_title).collect(Collectors.joining(","));
    }

    private List<TreeBarVO> getAssignees(List<TreeBarIssueVO> treeBarIssueVOS, List<ReqAddVO> reqAddVOS) {
        HashMap assigneeToColorMap = new HashMap();
        Set reqAddCidSet = Optional.ofNullable(reqAddVOS).orElse(Collections.emptyList()).stream().map(TreeBaseDTO::getC_id).collect(Collectors.toSet());
        return treeBarIssueVOS.stream().filter(issueVO -> reqAddCidSet.contains(issueVO.getCReqLink())).map(top10Requirement -> {
            String parent = "requirement-" + top10Requirement.getCReqLink();
            String name = top10Requirement.getAssigneeDisplayName();
            String color = assigneeToColorMap.computeIfAbsent(name, k -> String.format("#%02x%02x%02x", RANDOM.nextInt(256), RANDOM.nextInt(256), RANDOM.nextInt(256)));
            long value = top10Requirement.getAssigneeCount();
            return TreeBarVO.builder().id(parent + top10Requirement.getAssigneeDisplayName()).parent(parent).type("assignee").name(name + " (" + value + ")").value(value).color(color).build();
        }).collect(Collectors.toList());
    }

    public List<NetworkChartExcelDataVO> getNetworkChartExcelData(ScopeDTO scopeDTO) throws Exception {
        return this.aggregationService.getNetworkChartExcelData(scopeDTO);
    }

    public ScopeServiceImpl(ReqAdd reqAdd, PdService pdService, InternalService internalService, AggregationService aggregationService) {
        this.reqAdd = reqAdd;
        this.pdService = pdService;
        this.internalService = internalService;
        this.aggregationService = aggregationService;
    }
}

