/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.scope.model.vo;

import com.arms.api.analysis.scope.model.vo.TreeBarVO;
import com.arms.api.requirement.reqadd.model.vo.ReqAddVO;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class TreeBarVO {
    private String id;
    private String name;
    private String parent;
    private long value;
    private String color;
    private String type;

    public TreeBarVO(ReqAddVO reqAddVO) {
        this.id = "requirement-" + reqAddVO.getC_id();
        this.name = reqAddVO.getC_title();
        this.parent = reqAddVO.getC_req_pdservice_versionset_link();
        this.value = 0L;
        this.color = "";
        this.type = "requirement";
    }

    public Set<Long> reqVersionLinks() {
        return Arrays.stream(this.getParent().replaceAll("\"", "").replace("[", "").replace("]", "").split(",")).map(str -> Long.valueOf(str.trim())).collect(Collectors.toSet());
    }

    public static TreeBarVOBuilder builder() {
        return new TreeBarVOBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public long getValue() {
        return this.value;
    }

    public String getColor() {
        return this.color;
    }

    public String getType() {
        return this.type;
    }

    public TreeBarVO() {
    }

    public TreeBarVO(String id, String name, String parent, long value, String color, String type) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.value = value;
        this.color = color;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeBarVO)) {
            return false;
        }
        TreeBarVO other = (TreeBarVO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeBarVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

