/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.scope.controller;

import com.arms.api.analysis.scope.model.dto.ScopeDTO;
import com.arms.api.analysis.scope.model.vo.NetworkChartVO;
import com.arms.api.analysis.scope.model.vo.ReqAddWithPropertyVO;
import com.arms.api.analysis.scope.model.vo.ReqDataTableIssuesVO;
import com.arms.api.analysis.scope.model.vo.TreeBarVO;
import com.arms.api.analysis.scope.model.vo.TreeNodeVO;
import com.arms.api.analysis.scope.service.ScopeService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/arms/analysis/scope"})
public class ScopeController {
    private static final Logger log = LoggerFactory.getLogger(ScopeController.class);
    private final ScopeService scopeService;

    @PostMapping(value={"/{changeReqTableName}/issue-network"})
    public ResponseEntity<NetworkChartVO> getReqNetworkFullData(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody ScopeDTO scopeDTO) throws Exception {
        log.info(" [ ScopeController :: getReqNetworkFullData ] ");
        NetworkChartVO result = this.scopeService.getReqNetworkFullData(changeReqTableName, scopeDTO);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/getReqNetworkVersionData/{changeReqTableName}/getReqAddListByFilter"})
    public ResponseEntity<NetworkChartVO> getReqNetworkVersionData(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody ScopeDTO scopeDTO) throws Exception {
        log.info(" [ ScopeController :: getReqNetworkVersionData ] ");
        NetworkChartVO result = this.scopeService.getReqNetworkVersionData(changeReqTableName, scopeDTO);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/getReqNetworkIssueData/{changeReqTableName}/getReqAddListByFilter"})
    public ResponseEntity<NetworkChartVO> getReqNetworkIssueData(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody ScopeDTO scopeDTO) throws Exception {
        log.info(" [ ScopeController :: getReqNetworkIssueData ] ");
        NetworkChartVO result = this.scopeService.getReqNetworkIssueData(changeReqTableName, scopeDTO);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/getReqNetworkFilterData/{changeReqTableName}/getReqAddListByFilter"})
    public ResponseEntity<List<TreeNodeVO>> getReqNetworkFilterData(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestParam(value="pdServiceId") Long pdServiceId, @RequestParam(value="pdServiceVersionLinks") List<Long> pdServiceVersionLink) throws Exception {
        log.info(" [ ScopeController :: getReqNetworkFilterData ] ");
        PdServiceAndIsReqDTO pdServiceAndIsReqDTO = new PdServiceAndIsReqDTO();
        pdServiceAndIsReqDTO.setPdServiceLink(pdServiceId);
        pdServiceAndIsReqDTO.setPdServiceVersionLinks(pdServiceVersionLink);
        ScopeDTO scopeDTO = new ScopeDTO();
        scopeDTO.setPdServiceAndIsReq(pdServiceAndIsReqDTO);
        List result = this.scopeService.getReqNetworkFilterData(changeReqTableName, scopeDTO);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/req-per-version/{changeReqTableName}/getReqAddListByFilter"})
    public ResponseEntity<?> countByVersionNames(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody ScopeDTO scopeDTO) throws Exception {
        String pdServiceStr = StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQADD_", (String)"");
        log.info("[ ScopeController :: countByVersionNames ] :: countByVersionNames.pdServiceId ==> {}, pdServiceVersionLinks ==> {}", (Object)pdServiceStr, (Object)scopeDTO.getPdServiceAndIsReq().getPdServiceVersionLinks());
        List countByVersionNamesVOS = this.scopeService.countByVersionNames(changeReqTableName, scopeDTO);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)countByVersionNamesVOS));
    }

    @GetMapping(value={"/{changeReqTableName}/req-property-list"})
    public ResponseEntity<List<ReqAddWithPropertyVO>> reqAddWithPropertyListPerVersion(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestParam(value="pdServiceId") Long pdServiceId, @RequestParam(value="pdServiceVersionLinks") List<Long> pdServiceVersionLink) throws Exception {
        log.info("[ ScopeController :: reqAddWithPropertyListPerVersion ] :: changeReqTableName ==> {} pdServiceId ==> {}, pdServiceVersionLinks ==> {}", new Object[]{changeReqTableName, pdServiceId, pdServiceVersionLink});
        return ResponseEntity.ok((Object)this.scopeService.reqAddWithPropertyListPerVersion(changeReqTableName, pdServiceId, pdServiceVersionLink));
    }

    @GetMapping(value={"/getDataTableIssues"})
    public ResponseEntity<List<ReqDataTableIssuesVO>> getDataTableIssues(@RequestParam(value="pdServiceId") Long pdServiceId, @RequestParam(value="pdServiceVersionLinks") List<Long> pdServiceVersionLink, @RequestParam(value="startDate") String startDate, @RequestParam(value="endDate") String endDate) throws Exception {
        PdServiceAndIsReqDTO pdServiceAndIsReqDTO = new PdServiceAndIsReqDTO();
        pdServiceAndIsReqDTO.setPdServiceLink(pdServiceId);
        pdServiceAndIsReqDTO.setPdServiceVersionLinks(pdServiceVersionLink);
        ScopeDTO scopeDTO = new ScopeDTO();
        scopeDTO.setPdServiceAndIsReq(pdServiceAndIsReqDTO);
        scopeDTO.setStartDate(startDate);
        scopeDTO.setEndDate(endDate);
        return ResponseEntity.ok((Object)this.scopeService.getDataTableIssues(scopeDTO));
    }

    @PostMapping(value={"/getCircularPackingChartData/{changeReqTableName}/getReqAddListByFilter"})
    public ResponseEntity<?> getCircularPackingChartData(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody ScopeDTO scopeDTO) throws Exception {
        List result = this.scopeService.getCircularPackingChartData(changeReqTableName, scopeDTO);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    @PostMapping(value={"/tree-bar-data"})
    public ResponseEntity<CommonResponse.ApiResult<List<TreeBarVO>>> reqTreeBarData(@RequestBody ScopeDTO scopeDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.scopeService.treeBarData(scopeDTO)));
    }

    @PostMapping(value={"/getNetworkChartExcelData"})
    public ResponseEntity<?> getNetworkChartExcelDataVO(@RequestBody ScopeDTO scopeDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.scopeService.getNetworkChartExcelData(scopeDTO)));
    }

    public ScopeController(ScopeService scopeService) {
        this.scopeService = scopeService;
    }
}

