/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.cost.service;

import com.arms.api.analysis.cost.model.dto.SalaryLogJdbcDTO;
import com.arms.api.analysis.cost.service.SalaryLog;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="salaryLog")
public class SalaryLogImpl
extends TreeServiceImpl
implements SalaryLog {
    private static final Logger log = LoggerFactory.getLogger(SalaryLogImpl.class);
    private final JdbcTemplate jdbcTemplate;

    public List<SalaryLogJdbcDTO> findAllLogs(String cMethod, String startDate, String endDate) {
        String sql = "SELECT     c_date,     DATE_FORMAT(c_date, '%Y-%m-%d') AS formatted_date,     c_method,     c_name,     c_state,     c_key,     c_annual_income FROM     T_ARMS_ANNUAL_INCOME_LOG WHERE     c_method = ? AND     c_date BETWEEN ? AND ? AND c_type = 'default' ORDER BY c_date ASC";
        return this.jdbcTemplate.query(sql, new Object[]{cMethod, startDate, endDate}, (rs, rowNum) -> {
            SalaryLogJdbcDTO entry = new SalaryLogJdbcDTO();
            entry.setC_date((Date)rs.getTimestamp("c_date"));
            entry.setFormatted_date(rs.getString("formatted_date"));
            entry.setC_method(rs.getString("c_method"));
            entry.setC_name(rs.getString("c_name"));
            entry.setC_key(rs.getString("c_key"));
            entry.setC_state(rs.getString("c_state"));
            entry.setC_annual_income(Integer.valueOf(rs.getInt("c_annual_income")));
            return entry;
        });
    }

    public Map<String, SalaryLogJdbcDTO> findAllLogsToMap(String cMethod, String endDate) {
        String sql = "SELECT     c_date,     DATE_FORMAT(c_date, '%Y-%m-%d') AS formatted_date,     c_method,     c_name,     c_state,     c_key,     c_annual_income FROM     T_ARMS_ANNUAL_INCOME_LOG WHERE     c_method = ? AND     c_date < ?     AND c_type = 'default' ORDER BY c_date ASC";
        List results = this.jdbcTemplate.query(sql, new Object[]{cMethod, endDate}, (rs, rowNum) -> {
            SalaryLogJdbcDTO entry = new SalaryLogJdbcDTO();
            entry.setC_date((Date)rs.getTimestamp("c_date"));
            entry.setFormatted_date(rs.getString("formatted_date"));
            entry.setC_method(rs.getString("c_method"));
            entry.setC_name(rs.getString("c_name"));
            entry.setC_key(rs.getString("c_key"));
            entry.setC_state(rs.getString("c_state"));
            entry.setC_annual_income(Integer.valueOf(rs.getInt("c_annual_income")));
            return entry;
        });
        HashMap<String, SalaryLogJdbcDTO> resultMap = new HashMap<String, SalaryLogJdbcDTO>();
        for (SalaryLogJdbcDTO result : results) {
            resultMap.put(result.getC_key(), result);
        }
        return resultMap;
    }

    public SalaryLogImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

