/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.cost.service;

import com.arms.api.analysis.cost.model.dto.AssigneeSalaryDTO;
import com.arms.api.analysis.cost.model.dto.CalculationCostDTO;
import com.arms.api.analysis.cost.model.dto.CostDTO;
import com.arms.api.analysis.cost.model.dto.SalaryLogJdbcDTO;
import com.arms.api.analysis.cost.model.vo.AllAssigneeVO;
import com.arms.api.analysis.cost.model.vo.AssigneeSalaryVO;
import com.arms.api.analysis.cost.model.vo.AssigneeTimeDiffVO;
import com.arms.api.analysis.cost.model.vo.CandleStickVO;
import com.arms.api.analysis.cost.model.vo.CostCalculationVO;
import com.arms.api.analysis.cost.model.vo.CostVO;
import com.arms.api.analysis.cost.model.vo.LinkedJiraIssueVO;
import com.arms.api.analysis.cost.model.vo.PdServiceVersionCostVO;
import com.arms.api.analysis.cost.model.vo.ProductCostResponseVO;
import com.arms.api.analysis.cost.model.vo.ReqAddCostVO;
import com.arms.api.analysis.cost.model.vo.RequirementDifficultyAndPriorityVO;
import com.arms.api.analysis.cost.model.vo.SalaryEntity;
import com.arms.api.analysis.cost.model.vo.VersionRequirementAssigneeVO;
import com.arms.api.analysis.cost.service.CostService;
import com.arms.api.analysis.cost.service.SalaryLog;
import com.arms.api.analysis.cost.service.SalaryService;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.product_service.pdserviceversion.service.PdServiceVersion;
import com.arms.api.requirement.reqadd.model.entity.ReqAddCostEntity;
import com.arms.api.requirement.reqadd.service.ReqAdd;
import com.arms.api.requirement.reqdifficulty.model.ReqDifficultyEntity;
import com.arms.api.requirement.reqpriority.model.ReqPriorityEntity;
import com.arms.api.requirement.reqstate.model.ReqStateEntity;
import com.arms.api.requirement.reqstate.service.ReqState;
import com.arms.api.requirement.reqstatus.model.ReqStatusDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusEntity;
import com.arms.api.requirement.reqstatus.service.ReqStatus;
import com.arms.api.util.VersionUtil;
import com.arms.api.util.communicate.external.AggregationService;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.internal.InternalService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.remote.Chat;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CostServiceImpl
implements CostService {
    private static final Logger log = LoggerFactory.getLogger(CostServiceImpl.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private final AggregationService aggregationService;
    private final PdServiceVersion pdServiceVersion;
    protected final Chat chat;
    private final SalaryLog salaryLog;
    private final InternalService internalCommunicator;
    private final ReqAdd reqAdd;
    private final ReqStatus reqStatus;
    private final ReqState reqStateService;
    private final SalaryService salaryService;
    protected final ModelMapper modelMapper;
    private final EngineService engineService;

    public AllAssigneeVO getAssigneeList(CostDTO costDTO) throws Exception {
        Map salaryEntityMap = this.salaryService.getAllSalariesMap();
        if (salaryEntityMap.isEmpty()) {
            log.info(" [ " + this.getClass().getName() + " :: \ubc84\uc804\ubcc4_\uc694\uad6c\uc0ac\ud56d\ubcc4_\ub2f4\ub2f9\uc790\uac00\uc838\uc624\uae30 ] :: \ub514\ube44\uc5d0\uc11c \uc5f0\ubd09 \uc815\ubcf4\ub97c \uc870\ud68c\ud558\ub294 \ub370 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
            this.chat.sendMessageByEngine("\ub4f1\ub85d \ub41c \uc5f0\ubd09 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return new AllAssigneeVO(new ArrayList());
        }
        ResponseEntity responseEntity = this.aggregationService.getAssigneeList(costDTO);
        ArrayList costVOs = new ArrayList();
        costVOs.addAll((Collection)responseEntity.getBody());
        ArrayList<AssigneeSalaryVO> allAssigneeList = new ArrayList<AssigneeSalaryVO>();
        for (CostVO costVO : costVOs) {
            String assigneeAccountId = costVO.getAssigneeKey();
            String assigneeDisplayName = costVO.getDisplayNameKey();
            Long salary = Optional.ofNullable(salaryEntityMap).flatMap(map -> Optional.ofNullable((SalaryEntity)map.get(assigneeAccountId))).map(SalaryEntity::getC_annual_income).filter(s -> !s.trim().isEmpty()).map(NumberUtils::toLong).orElse(0L);
            AssigneeSalaryVO assigneeSalaryVO = AssigneeSalaryVO.builder().id(assigneeAccountId).name(assigneeDisplayName).salary(salary).build();
            allAssigneeList.add(assigneeSalaryVO);
        }
        return new AllAssigneeVO(allAssigneeList);
    }

    public RequirementDifficultyAndPriorityVO getRequirementListStats(CostDTO costDTO) throws Exception {
        String string;
        PdServiceAndIsReqDTO pdServiceAndIsReq = costDTO.getPdServiceAndIsReq();
        List pdServiceVersionLinks = pdServiceAndIsReq.getPdServiceVersionLinks();
        if (pdServiceVersionLinks == null || pdServiceVersionLinks.isEmpty()) {
            return null;
        }
        String[] versionStrArr = (String[])pdServiceVersionLinks.stream().map(Object::toString).toArray(String[]::new);
        RequirementDifficultyAndPriorityVO response = new RequirementDifficultyAndPriorityVO();
        Disjunction orCondition = Restrictions.disjunction();
        for (String string2 : versionStrArr) {
            String string3 = "\\\"" + string2 + "\\\"";
            orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)string3, (MatchMode)MatchMode.ANYWHERE));
        }
        ReqAddCostEntity reqAddCostEntity = new ReqAddCostEntity();
        reqAddCostEntity.getCriterions().add(orCondition);
        List<ReqAddCostEntity> reqAddCostEntities = this.reqAdd.getChildNode((TreeSearchEntity)reqAddCostEntity);
        String startDate = costDTO.getStartDate();
        if (StringUtils.isNullCheck((String)startDate)) {
            Date date = this.parseDate(startDate);
            reqAddCostEntities = reqAddCostEntities.stream().filter(srr -> {
                Date reqStartDate = srr.getC_req_start_date();
                return reqStartDate != null && !reqStartDate.before(searchStartDate);
            }).collect(Collectors.toList());
        }
        if (StringUtils.isNullCheck((String)(string = costDTO.getEndDate()))) {
            Date searchEndDate = this.parseDate(string);
            reqAddCostEntities = reqAddCostEntities.stream().filter(srr -> {
                Date reqEndDate = srr.getC_req_end_date();
                return reqEndDate != null && !reqEndDate.after(searchEndDate);
            }).collect(Collectors.toList());
        }
        List reqAddCostVOs = reqAddCostEntities.stream().map(arg_0 -> this.convertEntityToReqAddCostVO(arg_0)).collect(Collectors.toList());
        response.setRequirement(reqAddCostVOs);
        HashMap difficultyMap = new HashMap();
        HashMap priorityMap = new HashMap();
        reqAddCostEntities.forEach(reqAddCost -> {
            ReqDifficultyEntity reqDifficultyEntity = reqAddCost.getReqDifficultyEntity();
            ReqPriorityEntity reqPriorityEntity = reqAddCost.getReqPriorityEntity();
            if (reqDifficultyEntity != null) {
                difficultyMap.merge(reqDifficultyEntity.getC_title(), 1L, Long::sum);
            }
            if (reqPriorityEntity != null) {
                priorityMap.merge(reqPriorityEntity.getC_title(), 1L, Long::sum);
            }
        });
        if (!priorityMap.isEmpty()) {
            response.setPriority(priorityMap);
        }
        if (!difficultyMap.isEmpty()) {
            response.setDifficulty(difficultyMap);
        }
        return response;
    }

    private ReqAddCostVO convertEntityToReqAddCostVO(ReqAddCostEntity reqAddCostEntity) {
        String stateName = reqAddCostEntity.getReqStatePureEntity() != null ? reqAddCostEntity.getReqStatePureEntity().getC_title() : null;
        return ReqAddCostVO.builder().c_id(reqAddCostEntity.getC_id()).c_title(reqAddCostEntity.getC_title()).c_req_start_date(reqAddCostEntity.getC_req_start_date()).c_req_end_date(reqAddCostEntity.getC_req_end_date()).c_req_pdservice_versionset_link(reqAddCostEntity.getC_req_pdservice_versionset_link()).c_req_state_title(stateName).reqAmount(Long.valueOf(0L)).build();
    }

    private Date parseDate(String dateStr) {
        if (StringUtils.isNullCheck((String)dateStr)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            try {
                return dateFormat.parse(dateStr);
            }
            catch (ParseException e) {
                log.error("\uc798\ubabb\ub41c \ub0a0\uc9dc \ud615\uc2dd: {} (yyyy-MM-dd \ud615\uc2dd \ud544\uc694)", (Object)dateStr);
            }
        }
        return null;
    }

    public LinkedJiraIssueVO getLinkedJiraIssuesByVersionAndRequirement(CostDTO costDTO) throws Exception {
        PdServiceAndIsReqDTO pdServiceAndIsReq = costDTO.getPdServiceAndIsReq();
        Long pdServiceLink = pdServiceAndIsReq.getPdServiceLink();
        List pdServiceVersionLinks = pdServiceAndIsReq.getPdServiceVersionLinks();
        List reqStatusEntities = this.getReqStatusListByVersionAndDateFilter(pdServiceLink, pdServiceVersionLinks, costDTO.getStartDate(), costDTO.getEndDate());
        LinkedJiraIssueVO linkedJiraIssueVO = new LinkedJiraIssueVO();
        Map groupingMap = reqStatusEntities.stream().map(LinkedJiraIssueVO::createRequirementData).filter(\ub370\uc774\ud130 -> \ub370\uc774\ud130.getC_req_pdservice_versionset_link() != null && !\ub370\uc774\ud130.getC_req_pdservice_versionset_link().isEmpty()).flatMap(\ub370\uc774\ud130 -> Arrays.stream(\ub370\uc774\ud130.getC_req_pdservice_versionset_link().split("[\\[\\],\"]")).filter(s -> !s.isEmpty()).map(\ubc84\uc804\ub370\uc774\ud130 -> new AbstractMap.SimpleImmutableEntry<String, LinkedJiraIssueVO.RequirementData>((String)\ubc84\uc804\ub370\uc774\ud130, (LinkedJiraIssueVO.RequirementData)\ub370\uc774\ud130))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.groupingBy(entry -> ((LinkedJiraIssueVO.RequirementData)entry.getValue()).getC_req_link(), Collectors.mapping(Map.Entry::getValue, Collectors.toList()))));
        linkedJiraIssueVO.setLinkedJiraIssueData(groupingMap);
        return linkedJiraIssueVO;
    }

    private List<ReqStatusEntity> getReqStatusListByVersionAndDateFilter(Long \uc81c\ud488\ubc0f\uc11c\ube44\uc2a4, List<Long> \ubc84\uc804, String startDate, String endDate) throws Exception {
        ReqStatusEntity reqStatusEntity = new ReqStatusEntity();
        String \uc870\ud68c\ub300\uc0c1_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ud14c\uc774\ube14 = "T_ARMS_REQSTATUS_" + \uc81c\ud488\ubc0f\uc11c\ube44\uc2a4;
        log.info("\uc870\ud68c \ub300\uc0c1 \ud14c\uc774\ube14 searchTable :" + \uc870\ud68c\ub300\uc0c1_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ud14c\uc774\ube14);
        String[] versionStrArr = (String[])\ubc84\uc804.stream().map(Object::toString).toArray(String[]::new);
        Disjunction orCondition = Restrictions.disjunction();
        for (String string : versionStrArr) {
            String string2 = "\\\"" + string + "\\\"";
            orCondition.add((Criterion)Restrictions.like((String)"c_req_pdservice_versionset_link", (String)string2, (MatchMode)MatchMode.ANYWHERE));
        }
        reqStatusEntity.getCriterions().add(orCondition);
        List searchResultReq = this.reqStatus.getChildNode((TreeSearchEntity)reqStatusEntity);
        if (StringUtils.isNullCheck((String)startDate)) {
            Date searchStartDate = this.parseDate(startDate);
            searchResultReq = searchResultReq.stream().filter(srr -> {
                Date reqStartDate = srr.getC_req_start_date();
                return reqStartDate != null && !reqStartDate.before(searchStartDate);
            }).collect(Collectors.toList());
        }
        if (StringUtils.isNullCheck((String)endDate)) {
            Date searchEndDate = this.parseDate(endDate);
            searchResultReq = searchResultReq.stream().filter(srr -> {
                Date reqEndDate = srr.getC_req_end_date();
                return reqEndDate != null && !reqEndDate.after(searchEndDate);
            }).collect(Collectors.toList());
        }
        return searchResultReq;
    }

    public ProductCostResponseVO candleStickChartAPI(CostDTO costDTO) throws Exception {
        PdServiceAndIsReqDTO pdServiceAndIsReqDTO = costDTO.getPdServiceAndIsReq();
        Long pdServiceLink = pdServiceAndIsReqDTO.getPdServiceLink();
        List pdServiceVersionLinks = pdServiceAndIsReqDTO.getPdServiceVersionLinks();
        Map \uc644\ub8cc\uc0c1\ud0dc\ub9f5 = this.reqStateService.\uc644\ub8cc\uc0c1\ud0dc\uc870\ud68c();
        List filteredReqStateId = this.filterResolvedStateIds(\uc644\ub8cc\uc0c1\ud0dc\ub9f5);
        List reqStatusEntities = this.internalCommunicator.\uc81c\ud488\ubcc4_\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc870\ud68c("T_ARMS_REQSTATUS_" + pdServiceLink, new ReqStatusDTO());
        List filteredReqStatusEntities = this.filterResolvedReqStatusEntities(reqStatusEntities, filteredReqStateId);
        List cReqLinks = filteredReqStatusEntities.stream().map(ReqStatusEntity::getC_req_link).distinct().collect(Collectors.toList());
        List engineResponse = Optional.ofNullable((List)this.aggregationService.aggregationByReqLinkAndAssigneeAccountId(costDTO).getBody()).orElseGet(ArrayList::new);
        List groupByCReqLink = engineResponse.stream().filter(response -> response.getReqLinkKey() != null && response.getAssigneeKey() != null).filter(response -> cReqLinks.contains(Long.parseLong(response.getReqLinkKey()))).collect(Collectors.toList());
        List pdServiceVersionEntities = this.pdServiceVersion.getNodesWithoutRoot((TreeSearchEntity)new PdServiceVersionEntity()).stream().filter(pdServiceVersionEntity -> pdServiceVersionLinks.contains(pdServiceVersionEntity.getC_id())).collect(Collectors.toList());
        String startDateOrNull = pdServiceVersionEntities.stream().filter(pdServiceVersionEntity -> !pdServiceVersionEntity.getC_pds_version_start_date().equals("start")).map(PdServiceVersionEntity::getC_pds_version_start_date).min(String::compareTo).orElse(null);
        String endDateOrNull = pdServiceVersionEntities.stream().filter(pdServiceVersionEntity -> !pdServiceVersionEntity.getC_pds_version_end_date().equals("end")).map(PdServiceVersionEntity::getC_pds_version_end_date).max(String::compareTo).orElse(null);
        if (startDateOrNull == null || endDateOrNull == null) {
            this.chat.sendMessageByEngine("\uc81c\ud488 \ubc84\uc804\uc758 \uc2dc\uc791\uc77c\uacfc \uc885\ub8cc\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return new ProductCostResponseVO(new TreeMap(), new TreeMap(), new TreeMap());
        }
        String formattedStartDate = this.convertDateTimeFormat(startDateOrNull);
        String formattedEndDate = this.convertDateTimeFormat(endDateOrNull);
        LocalDate versionStartDate = LocalDate.parse(formattedStartDate);
        LocalDate versionEndDate = LocalDate.parse(formattedEndDate);
        Set getAssignees = this.getAssignees(pdServiceLink, pdServiceVersionLinks);
        Map salaryCreateLogs = this.salaryLog.findAllLogsToMap("create", endDateOrNull);
        Map<String, SalaryLogJdbcDTO> filteredSalaryCreateLogs = salaryCreateLogs.entrySet().stream().filter(entry -> getAssignees.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (filteredSalaryCreateLogs.isEmpty()) {
            this.chat.sendMessageByEngine("\ubc84\uc804\uc758 \uae30\uac04 \uc774\ud6c4 \uc5f0\ubd09\uc744 \ub4f1\ub85d\ud55c \uacbd\uc6b0, \ud574\ub2f9 \ubc84\uc804\uc740 \ube44\uc6a9 \uc0b0\uc815\uc774 \ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            SortedMap dailyCost = this.generateDailyCostsMap(formattedStartDate, formattedEndDate, Integer.valueOf(0));
            return new ProductCostResponseVO(dailyCost, dailyCost, this.generateDailyCostsCandleStick(versionStartDate, versionEndDate));
        }
        List salaryUpdateLogs = this.salaryLog.findAllLogs("update", formattedStartDate, formattedEndDate);
        List filteredLogs = this.getLatestSalaryUpdates(salaryUpdateLogs, getAssignees);
        filteredLogs.sort(Comparator.comparing(SalaryLogJdbcDTO::getFormatted_date));
        Map allAssigneeSalaries = this.assigneeCostCalendar(filteredSalaryCreateLogs, filteredLogs, versionStartDate, versionEndDate);
        SortedMap barCost = this.generateDailyCostsMap(formattedStartDate, formattedEndDate, Integer.valueOf(0));
        this.calculateBarCost(filteredReqStatusEntities, versionEndDate, groupByCReqLink, allAssigneeSalaries, barCost);
        SortedMap lineCost = this.getLineCost(allAssigneeSalaries);
        Map<String, Map<String, List<SalaryLogJdbcDTO>>> updatesGroupedByDateAndKey = salaryUpdateLogs.stream().collect(Collectors.groupingBy(SalaryLogJdbcDTO::getC_key, Collectors.groupingBy(SalaryLogJdbcDTO::getFormatted_date)));
        Map allAssigneeCandleSticks = this.getAllAssigneeCandleSticks(allAssigneeSalaries, updatesGroupedByDateAndKey);
        SortedMap candleStickCost = this.getCandleStickCost(allAssigneeCandleSticks);
        return new ProductCostResponseVO(lineCost, barCost, candleStickCost);
    }

    private void calculateBarCost(List<ReqStatusEntity> filteredReqStatusEntities, LocalDate versionEndDate, List<CostVO> groupByCReqLink, Map<String, SortedMap<String, Integer>> allAssigneeSalaries, SortedMap<String, Integer> barCost) {
        for (ReqStatusEntity filteredReqStatusEntity : filteredReqStatusEntities) {
            LocalDate \uc694\uad6c\uc0ac\ud56d\uc2dc\uc791\uc77c = filteredReqStatusEntity.getC_req_start_date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate \uc694\uad6c\uc0ac\ud56d\uc885\ub8cc\uc77c = filteredReqStatusEntity.getC_req_end_date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate adjustedEndDate = \uc694\uad6c\uc0ac\ud56d\uc885\ub8cc\uc77c.isAfter(versionEndDate) ? versionEndDate : \uc694\uad6c\uc0ac\ud56d\uc885\ub8cc\uc77c;
            List<CostVO> costVOList = groupByCReqLink.stream().filter(a -> Long.parseLong(a.getReqLinkKey()) == filteredReqStatusEntity.getC_req_link()).collect(Collectors.toList());
            costVOList.forEach(assignee -> Optional.ofNullable((SortedMap)allAssigneeSalaries.get(assignee.getAssigneeKey())).ifPresent(assigneeSalaries -> assigneeSalaries.entrySet().stream().filter(entry -> {
                LocalDate date = LocalDate.parse((CharSequence)entry.getKey());
                return !(!date.isAfter(\uc694\uad6c\uc0ac\ud56d\uc2dc\uc791\uc77c) && !date.isEqual(\uc694\uad6c\uc0ac\ud56d\uc2dc\uc791\uc77c) || !date.isBefore(adjustedEndDate) && !date.isEqual(adjustedEndDate));
            }).forEach(entry -> barCost.merge((String)entry.getKey(), (Integer)entry.getValue(), Integer::sum))));
        }
        barCost.replaceAll((k, v) -> v / 365);
        int barSum = 0;
        for (Map.Entry<String, Integer> entry : barCost.entrySet()) {
            barCost.put(entry.getKey(), barSum += entry.getValue().intValue());
        }
    }

    private SortedMap<String, List<Integer>> getCandleStickCost(Map<String, SortedMap<String, CandleStickVO>> allAssigneeCandleSticks) {
        TreeMap<String, List<Integer>> candleStickCost = new TreeMap<String, List<Integer>>();
        for (SortedMap<String, CandleStickVO> assigneeCandleSticks : allAssigneeCandleSticks.values()) {
            for (Map.Entry<String, CandleStickVO> entry : assigneeCandleSticks.entrySet()) {
                String date = entry.getKey();
                CandleStickVO candleStickVO = entry.getValue();
                List<Integer> sums = candleStickCost.getOrDefault(date, Arrays.asList(0, 0, 0, 0));
                sums.set(0, sums.get(0) + candleStickVO.get\uc2dc\uac00());
                sums.set(1, sums.get(1) + candleStickVO.get\uc885\uac00());
                sums.set(2, sums.get(2) + candleStickVO.get\ucd5c\uc800\uac00());
                sums.set(3, sums.get(3) + candleStickVO.get\ucd5c\uace0\uac00());
                candleStickCost.put(date, sums);
            }
        }
        return candleStickCost;
    }

    private Map<String, SortedMap<String, CandleStickVO>> getAllAssigneeCandleSticks(Map<String, SortedMap<String, Integer>> allAssigneeSalaries, Map<String, Map<String, List<SalaryLogJdbcDTO>>> updatesGroupedByDateAndKey) {
        HashMap<String, SortedMap<String, CandleStickVO>> allAssigneeCandleSticks = new HashMap<String, SortedMap<String, CandleStickVO>>();
        for (Map.Entry<String, SortedMap<String, Integer>> assigneeEntry : allAssigneeSalaries.entrySet()) {
            String assignee = assigneeEntry.getKey();
            SortedMap<String, Integer> salaryMap = assigneeEntry.getValue();
            Map<String, List<SalaryLogJdbcDTO>> updateLogsByAssignee = updatesGroupedByDateAndKey.get(assignee);
            TreeMap<String, CandleStickVO> candleStickMap = new TreeMap<String, CandleStickVO>();
            String previousDate = null;
            for (Map.Entry<String, Integer> salaryEntry : salaryMap.entrySet()) {
                List salaryLogJdbcDTOList;
                String date = salaryEntry.getKey();
                Integer salary = salaryEntry.getValue();
                int min = 0;
                int max = 0;
                int open = 0;
                if (previousDate != null) {
                    CandleStickVO previousCandleStickVO = (CandleStickVO)candleStickMap.get(previousDate);
                    open = previousCandleStickVO.get\uc885\uac00();
                }
                min = open > salary ? salary : open;
                int n = max = open > salary ? open : salary;
                if (updateLogsByAssignee != null && updateLogsByAssignee.get(date) != null && !(salaryLogJdbcDTOList = updateLogsByAssignee.get(date).stream().sorted(Comparator.comparing(SalaryLogJdbcDTO::getC_annual_income)).collect(Collectors.toList())).isEmpty()) {
                    if (salaryLogJdbcDTOList.size() == 1) {
                        Integer updateLogSalary = ((SalaryLogJdbcDTO)salaryLogJdbcDTOList.get(0)).getC_annual_income();
                        min = min > updateLogSalary ? updateLogSalary : min;
                        max = max > updateLogSalary ? max : updateLogSalary;
                    } else {
                        Integer updateLogMinSalary = ((SalaryLogJdbcDTO)salaryLogJdbcDTOList.get(0)).getC_annual_income();
                        Integer updateLogMaxSalary = ((SalaryLogJdbcDTO)salaryLogJdbcDTOList.get(salaryLogJdbcDTOList.size() - 1)).getC_annual_income();
                        min = min > updateLogMinSalary ? updateLogMinSalary : min;
                        max = max > updateLogMaxSalary ? max : updateLogMaxSalary;
                    }
                }
                CandleStickVO candleStickVO = new CandleStickVO(Integer.valueOf(open), salary, Integer.valueOf(min), Integer.valueOf(max));
                candleStickMap.put(date, candleStickVO);
                previousDate = date;
            }
            allAssigneeCandleSticks.put(assignee, candleStickMap);
        }
        return allAssigneeCandleSticks;
    }

    private SortedMap<String, Integer> getLineCost(Map<String, SortedMap<String, Integer>> allAssigneeSalaries) {
        TreeMap<String, Integer> lineCost = new TreeMap<String, Integer>();
        for (SortedMap<String, Integer> assigneeSalaries : allAssigneeSalaries.values()) {
            for (Map.Entry<String, Integer> entry : assigneeSalaries.entrySet()) {
                lineCost.merge(entry.getKey(), entry.getValue(), Integer::sum);
            }
        }
        lineCost.replaceAll((k, v) -> v / 365);
        int lineSum = 0;
        for (Map.Entry entry : lineCost.entrySet()) {
            lineCost.put((String)entry.getKey(), lineSum += ((Integer)entry.getValue()).intValue());
        }
        return lineCost;
    }

    private Map<String, SortedMap<String, Integer>> assigneeCostCalendar(Map<String, SalaryLogJdbcDTO> salaryCreateLogs, List<SalaryLogJdbcDTO> filteredLogs, LocalDate versionStartDate, LocalDate versionEndDate) {
        HashMap<String, SortedMap<String, Integer>> allAssigneeSalaries = new HashMap<String, SortedMap<String, Integer>>();
        for (Map.Entry<String, SalaryLogJdbcDTO> salaryCreateLog : salaryCreateLogs.entrySet()) {
            String assigneeKey = salaryCreateLog.getKey();
            SalaryLogJdbcDTO salaryCreate = salaryCreateLog.getValue();
            LocalDate salaryCreateDate = LocalDate.parse(salaryCreate.getFormatted_date());
            int createdSalary = salaryCreate.getC_annual_income();
            List salaryUpdateLogsByAssignee = filteredLogs.stream().filter(sle -> sle.getC_key().equals(assigneeKey)).collect(Collectors.toList());
            int updateLogSize = salaryUpdateLogsByAssignee.size();
            if (versionStartDate.isBefore(salaryCreateDate)) {
                this.addSalaryForPeriod(versionStartDate, salaryCreateDate.minusDays(1L), 0, assigneeKey, allAssigneeSalaries);
                if (this.hasUpdateLog(salaryUpdateLogsByAssignee)) {
                    this.updateSalaryForSection(salaryCreateDate, versionEndDate, updateLogSize, salaryUpdateLogsByAssignee, assigneeKey, allAssigneeSalaries, createdSalary);
                }
                if (!this.hasUpdateLog(salaryUpdateLogsByAssignee)) {
                    this.addSalaryForPeriod(salaryCreateDate, versionEndDate, createdSalary, assigneeKey, allAssigneeSalaries);
                }
            }
            if (versionStartDate.isEqual(salaryCreateDate)) {
                if (this.hasUpdateLog(salaryUpdateLogsByAssignee)) {
                    this.updateSalaryForSection(versionStartDate, versionEndDate, updateLogSize, salaryUpdateLogsByAssignee, assigneeKey, allAssigneeSalaries, createdSalary);
                }
                if (!this.hasUpdateLog(salaryUpdateLogsByAssignee)) {
                    this.addSalaryForPeriod(versionStartDate, versionEndDate, createdSalary, assigneeKey, allAssigneeSalaries);
                }
            }
            if (!versionStartDate.isAfter(salaryCreateDate)) continue;
            if (this.hasUpdateLog(salaryUpdateLogsByAssignee)) {
                this.updateSalaryForSection(versionStartDate, versionEndDate, updateLogSize, salaryUpdateLogsByAssignee, assigneeKey, allAssigneeSalaries, createdSalary);
            }
            if (this.hasUpdateLog(salaryUpdateLogsByAssignee)) continue;
            this.addSalaryForPeriod(versionStartDate, versionEndDate, createdSalary, assigneeKey, allAssigneeSalaries);
        }
        return allAssigneeSalaries;
    }

    private void updateSalaryForSection(LocalDate startDate, LocalDate endDate, int updateLogSize, List<SalaryLogJdbcDTO> salaryUpdateLogsByAssignee, String assigneeKey, Map<String, SortedMap<String, Integer>> allAssigneeSalaries, int createdSalary) {
        for (int i = 0; i < updateLogSize; ++i) {
            if (i == 0) {
                this.updateSalaryForFirstLog(i, salaryUpdateLogsByAssignee, startDate, assigneeKey, allAssigneeSalaries, createdSalary);
            } else {
                this.updateSalaryForMiddleLog(i, salaryUpdateLogsByAssignee, assigneeKey, allAssigneeSalaries);
            }
            this.updateSalaryForLastLog(i, updateLogSize, salaryUpdateLogsByAssignee, endDate, assigneeKey, allAssigneeSalaries);
        }
    }

    private List<Long> filterResolvedStateIds(Map<Long, ReqStateEntity> \uc644\ub8cc\uc0c1\ud0dc\ub9f5) {
        return \uc644\ub8cc\uc0c1\ud0dc\ub9f5.keySet().stream().collect(Collectors.toList());
    }

    private List<ReqStatusEntity> filterResolvedReqStatusEntities(List<ReqStatusEntity> reqStatusEntities, List<Long> filteredReqStateId) {
        Map<Long, ReqStatusEntity> uniqueMap = reqStatusEntities.stream().filter(reqStatusEntity -> reqStatusEntity.getC_req_start_date() != null).filter(reqStatusEntity -> reqStatusEntity.getC_req_end_date() != null).filter(reqStatusEntity -> filteredReqStateId.contains(reqStatusEntity.getC_req_state_link())).collect(Collectors.toMap(ReqStatusEntity::getC_req_link, reqStatusEntity -> reqStatusEntity, (existing, replacement) -> existing));
        return new ArrayList<ReqStatusEntity>(uniqueMap.values());
    }

    private void addSalaryForPeriod(LocalDate startDate, LocalDate endDate, int salary, String assigneeKey, Map<String, SortedMap<String, Integer>> allAssigneeSalaries) {
        SortedMap assigneeSalaries = allAssigneeSalaries.getOrDefault(assigneeKey, new TreeMap());
        LocalDate date = startDate;
        while (!date.isAfter(endDate)) {
            assigneeSalaries.put(date.format(DateTimeFormatter.ofPattern(DATE_FORMAT)), salary);
            date = date.plusDays(1L);
        }
        allAssigneeSalaries.put(assigneeKey, assigneeSalaries);
    }

    private void updateSalaryDataForPeriod(LocalDate startDate, LocalDate endDate, String assigneeKey, Map<String, SortedMap<String, Integer>> allAssigneeSalaries, int updatedSalary) {
        SortedMap assigneeSalaries = allAssigneeSalaries.getOrDefault(assigneeKey, new TreeMap());
        LocalDate date = startDate;
        while (!date.isAfter(endDate)) {
            String dateString = date.format(DateTimeFormatter.ofPattern(DATE_FORMAT));
            assigneeSalaries.put(dateString, updatedSalary);
            date = date.plusDays(1L);
        }
        allAssigneeSalaries.put(assigneeKey, assigneeSalaries);
    }

    public boolean hasUpdateLog(List<SalaryLogJdbcDTO> salaryUpdateLogsByAssignee) {
        return !salaryUpdateLogsByAssignee.isEmpty();
    }

    private void updateSalaryForFirstLog(int i, List<SalaryLogJdbcDTO> salaryUpdateLogsByAssignee, LocalDate startDate, String assigneeKey, Map<String, SortedMap<String, Integer>> allAssigneeSalaries, int createdSalary) {
        LocalDate endDate = LocalDate.parse(salaryUpdateLogsByAssignee.get(i).getFormatted_date()).minusDays(1L);
        this.updateSalaryDataForPeriod(startDate, endDate, assigneeKey, allAssigneeSalaries, createdSalary);
    }

    private void updateSalaryForMiddleLog(int i, List<SalaryLogJdbcDTO> salaryUpdateLogsByAssignee, String assigneeKey, Map<String, SortedMap<String, Integer>> allAssigneeSalaries) {
        LocalDate startDate = LocalDate.parse(salaryUpdateLogsByAssignee.get(i - 1).getFormatted_date());
        LocalDate endDate = LocalDate.parse(salaryUpdateLogsByAssignee.get(i).getFormatted_date()).minusDays(1L);
        int updatedSalary = salaryUpdateLogsByAssignee.get(i - 1).getC_annual_income();
        this.updateSalaryDataForPeriod(startDate, endDate, assigneeKey, allAssigneeSalaries, updatedSalary);
    }

    private void updateSalaryForLastLog(int i, int updateLogSize, List<SalaryLogJdbcDTO> salaryUpdateLogsByAssignee, LocalDate versionEndDate, String assigneeKey, Map<String, SortedMap<String, Integer>> allAssigneeSalaries) {
        if (this.isLastLog(updateLogSize, i)) {
            int currentSalary = salaryUpdateLogsByAssignee.get(i).getC_annual_income();
            LocalDate currentStart = LocalDate.parse(salaryUpdateLogsByAssignee.get(i).getFormatted_date());
            this.updateSalaryDataForPeriod(currentStart, versionEndDate, assigneeKey, allAssigneeSalaries, currentSalary);
        }
    }

    private boolean isLastLog(int updateLogSize, int i) {
        return updateLogSize == i + 1;
    }

    private List<SalaryLogJdbcDTO> getLatestSalaryUpdates(List<SalaryLogJdbcDTO> salaryUpdateLogs, Set<String> getAssignees) {
        List filteredUpdateLogs = salaryUpdateLogs.stream().filter(salaryLogJdbcDTO -> getAssignees.contains(salaryLogJdbcDTO.getC_key())).collect(Collectors.toList());
        Map<String, Map<String, List<SalaryLogJdbcDTO>>> updatesGroupedByDateAndKey = filteredUpdateLogs.stream().collect(Collectors.groupingBy(SalaryLogJdbcDTO::getFormatted_date, Collectors.groupingBy(SalaryLogJdbcDTO::getC_key)));
        return updatesGroupedByDateAndKey.values().stream().flatMap(dateGroup -> dateGroup.values().stream()).map(arg_0 -> this.getLatestLogFromGroup(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private SalaryLogJdbcDTO getLatestLogFromGroup(List<SalaryLogJdbcDTO> logs) {
        return logs.stream().max(Comparator.comparing(SalaryLogJdbcDTO::getC_date)).orElse(null);
    }

    private String convertDateTimeFormat(String localDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT);
        LocalDateTime parse = LocalDateTime.parse(localDate, inputFormatter);
        return parse.format(outputFormatter);
    }

    private SortedMap<String, Integer> generateDailyCostsMap(String startDateStr, String endDateStr, Integer dailyCost) {
        TreeMap<String, Integer> dailySalaryCosts = new TreeMap<String, Integer>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT);
        LocalDate startDate = LocalDate.parse(startDateStr, formatter);
        LocalDate endDate = LocalDate.parse(endDateStr, formatter);
        LocalDate date = startDate;
        while (!date.isAfter(endDate)) {
            dailySalaryCosts.put(date.format(formatter), dailyCost);
            date = date.plusDays(1L);
        }
        return dailySalaryCosts;
    }

    private SortedMap<String, List<Integer>> generateDailyCostsCandleStick(LocalDate versionStartDate, LocalDate versionEndDate) {
        TreeMap<String, List<Integer>> candleStick = new TreeMap<String, List<Integer>>();
        LocalDate date = versionStartDate;
        while (!date.isAfter(versionEndDate)) {
            candleStick.put(date.toString(), Arrays.asList(0, 0, 0, 0));
            date = date.plusDays(1L);
        }
        return candleStick;
    }

    public Set<String> getAssignees(Long pdServiceLink, List<Long> pdServiceVersionLinks) {
        PdServiceAndIsReqDTO pdServiceAndIsReqDTO = PdServiceAndIsReqDTO.builder().pdServiceLink(pdServiceLink).pdServiceVersionLinks(pdServiceVersionLinks).build();
        CostDTO costDTO = new CostDTO(pdServiceAndIsReqDTO);
        ResponseEntity response = this.aggregationService.aggregationByAssigneeAccountId(costDTO);
        List body = (List)response.getBody();
        if (body == null) {
            return Collections.emptySet();
        }
        return body.stream().map(CostVO::getAssigneeKey).collect(Collectors.toSet());
    }

    private Set<String> getCompleteKeyword() throws Exception {
        HashSet<String> completeStateKeywordSet = new HashSet<String>();
        Map completeStateEntityMap = this.reqStateService.\uc644\ub8cc\uc0c1\ud0dc\uc870\ud68c();
        completeStateEntityMap.forEach((key, value) -> completeStateKeywordSet.add(value.getC_title()));
        return completeStateKeywordSet;
    }

    public List<AssigneeTimeDiffVO> getEstimatedPeriodCostByAccountId(CostDTO costDTO) throws Exception {
        List returnList;
        Map salaryEntityMap = this.salaryService.getAllSalariesMap();
        if (salaryEntityMap.isEmpty()) {
            log.info(" [ CostServiceImpl :: getEstimatedPeriodCostByAccountId ] :: \ub514\ube44\uc5d0\uc11c \uc5f0\ubd09 \uc815\ubcf4\ub97c \uc870\ud68c\ud558\ub294 \ub370 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
            this.chat.sendMessageByEngine("\ub4f1\ub85d \ub41c \uc5f0\ubd09 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        if ((returnList = this.aggregationService.calculateWorkdayByAccountId(costDTO)).isEmpty()) {
            log.info(" [ CostServiceImpl :: getEstimatedPeriodCostByAccountId ] :: calculateWorkdayByAccountId.list is empty");
            return Collections.emptyList();
        }
        for (AssigneeTimeDiffVO vo : returnList) {
            String accountId = vo.getAccountId();
            vo.setSalary(Optional.ofNullable((SalaryEntity)salaryEntityMap.get(accountId)).map(SalaryEntity::getC_annual_income).orElse("0"));
            double salaryDoubleType = 0.0;
            double dailyAverageCost = 0.0;
            double hourAverageCost = 0.0;
            double costForDaysPeriod = 0.0;
            double costForHoursPeriod = 0.0;
            if (!vo.getSalary().equals("0")) {
                salaryDoubleType = Double.parseDouble(this.extractNumbers(vo.getSalary()));
                dailyAverageCost = this.calculateDailyAverageCost(salaryDoubleType);
                hourAverageCost = this.calculateHourAverageCost(salaryDoubleType);
                if (vo.getDaysDiff() != null && vo.getDaysDiff() > 0L) {
                    costForDaysPeriod = (double)vo.getDaysDiff().longValue() * dailyAverageCost;
                }
                if (vo.getHoursDiff() != null && vo.getHoursDiff() > 0L) {
                    costForHoursPeriod = (double)vo.getHoursDiff().longValue() * hourAverageCost;
                }
            } else {
                if (vo.getDaysDiff() != null && vo.getDaysDiff() > 0L) {
                    costForDaysPeriod = (double)vo.getDaysDiff().longValue() * -1.0;
                }
                if (vo.getHoursDiff() != null && vo.getHoursDiff() > 0L) {
                    costForHoursPeriod = (double)vo.getHoursDiff().longValue() * -1.0;
                }
            }
            vo.setEstimatedCostForDaysPeriod(this.formatToTwoDecimalPlacesString(costForDaysPeriod));
            vo.setEstimatedCostForHoursPeriod(this.formatToTwoDecimalPlacesString(costForHoursPeriod));
        }
        return returnList;
    }

    private String formatToTwoDecimalPlacesString(double value) {
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(value);
    }

    private String extractNumbers(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        return input.replaceAll("\\D", "");
    }

    private double calculateDailyAverageCost(double totalCost) {
        if (totalCost < 0.0) {
            return 0.0;
        }
        return totalCost / 365.0;
    }

    private double calculateHourAverageCost(double totalCost) {
        if (totalCost < 0.0) {
            return 0.0;
        }
        double MINUTES_IN_A_YEAR = 8760.0;
        return totalCost / 8760.0;
    }

    private double calculateMinuteAverageCost(double totalCost) {
        if (totalCost < 0.0) {
            return 0.0;
        }
        double MINUTES_IN_A_YEAR = 525600.0;
        return totalCost / 525600.0;
    }

    public CostCalculationVO calculateCostAll(CostDTO costDTO) throws Exception {
        Map versionMap = this.buildVersionMap(costDTO);
        Set completeKeywords = this.getCompleteKeyword();
        Long pdServiceId = costDTO.pdServiceLink();
        Map linkedJiraIssueData = this.getLinkedJiraIssues(costDTO, pdServiceId);
        VersionRequirementAssigneeVO versionRequirementAssigneeVO = this.getVersionRequirementAssignee(costDTO);
        Map versionRequirementAssignee = versionRequirementAssigneeVO.getVersionRequirementAssignee();
        Map allAssignees = versionRequirementAssigneeVO.getAllAssignees();
        RequirementDifficultyAndPriorityVO requirementDifficultyAndPriorityVO = this.getRequirementListAndDifficultyAndPriority(costDTO, pdServiceId);
        List requirements = requirementDifficultyAndPriorityVO.getRequirement();
        requirements.forEach(reqAddCostVO -> this.processCalculateCost(reqAddCostVO, versionMap, linkedJiraIssueData, versionRequirementAssignee, completeKeywords));
        List estimatedPeriodCostByAccountId = this.getEstimatedPeriodCostByAccountId(costDTO);
        this.updateEstimatedPeriodCostByAccountId(estimatedPeriodCostByAccountId, allAssignees);
        return CostCalculationVO.builder().versionCostMap(versionMap).requirement(requirements).difficulty(requirementDifficultyAndPriorityVO.getDifficulty()).priority(requirementDifficultyAndPriorityVO.getPriority()).versionRequirementAssignee(versionRequirementAssignee).assigneeTimeDiffVOs(estimatedPeriodCostByAccountId).build();
    }

    private void processCalculateCost(ReqAddCostVO reqAddCostVO, Map<Long, PdServiceVersionCostVO> versionMap, Map<String, Map<Long, List<LinkedJiraIssueVO.RequirementData>>> linkedJiraIssueData, Map<String, Map<String, Map<String, AssigneeSalaryVO>>> versionRequirementAssignee, Set<String> completeKeywords) {
        this.extractReqVersionList(reqAddCostVO).forEach(versionId -> {
            PdServiceVersionCostVO versionCostVO = (PdServiceVersionCostVO)versionMap.get(versionId);
            if (versionCostVO == null) {
                return;
            }
            Map versionRequirementMap = linkedJiraIssueData.getOrDefault(versionId.toString(), Collections.emptyMap());
            List<LinkedJiraIssueVO.RequirementData> requirementDataList = versionRequirementMap.getOrDefault(reqAddCostVO.getC_id(), Collections.emptyList());
            Map requirementAssigneeMap = versionRequirementAssignee.getOrDefault(versionId.toString(), Collections.emptyMap());
            requirementDataList.forEach(requirementData -> {
                Map<String, AssigneeSalaryVO> assigneeSalaryVOMap = requirementAssigneeMap.getOrDefault(requirementData.getC_issue_key(), Collections.emptyMap());
                assigneeSalaryVOMap.forEach((assigneeKey, salaryVO) -> {
                    try {
                        LocalDate[] dates = this.getValidStartEndDate(reqAddCostVO, completeKeywords);
                        if (dates == null) {
                            return;
                        }
                        LocalDate startDate = dates[0];
                        LocalDate endDate = dates[1];
                        long cost = this.calculateCostByAssignee(startDate, endDate, salaryVO.getSalary().longValue());
                        salaryVO.setCompletePerformance(Long.valueOf(salaryVO.getCompletePerformance() + cost));
                        salaryVO.setConsumedCostByVersionAssignee(Long.valueOf(salaryVO.getConsumedCostByVersionAssignee() + cost));
                        reqAddCostVO.setReqAmount(Long.valueOf(reqAddCostVO.getReqAmount() + cost));
                    }
                    catch (Exception e) {
                        log.warn("\ube44\uc6a9 \uacc4\uc0b0 \uc911 \uc624\ub958 \ubc1c\uc0dd - assigneeKey: {}, error: {}", assigneeKey, (Object)e.getMessage());
                    }
                });
            });
        });
    }

    private void updateEstimatedPeriodCostByAccountId(List<AssigneeTimeDiffVO> estimatedPeriodCostByAccountId, Map<String, AssigneeSalaryVO> allAssignees) {
        estimatedPeriodCostByAccountId.forEach(assigneeTimeDiffVO -> {
            AssigneeSalaryVO salaryVO = (AssigneeSalaryVO)allAssignees.get(assigneeTimeDiffVO.getAccountId());
            assigneeTimeDiffVO.setEstimatedCostForDaysPeriod(String.valueOf(salaryVO.getCompletePerformance()));
        });
    }

    private List<Long> extractReqVersionList(ReqAddCostVO req) {
        return Optional.ofNullable(req.getC_req_pdservice_versionset_link()).map(VersionUtil::stringToLongArray).map(Arrays::asList).orElse(Collections.emptyList());
    }

    private LocalDate[] getValidStartEndDate(ReqAddCostVO reqAddCostVO, Set<String> completeKeywords) {
        LocalDate endDate;
        LocalDate startDate = this.convertToLocalDate(reqAddCostVO.getC_req_start_date());
        LocalDate localDate = endDate = reqAddCostVO.getC_req_end_date() != null ? this.convertToLocalDate(reqAddCostVO.getC_req_end_date()) : LocalDate.now();
        if (startDate == null || endDate == null || startDate.isAfter(endDate)) {
            return null;
        }
        if (reqAddCostVO.getC_req_state_title() != null && !completeKeywords.contains(reqAddCostVO.getC_req_state_title())) {
            endDate = LocalDate.now();
        }
        return new LocalDate[]{startDate, endDate};
    }

    private Map<Long, PdServiceVersionCostVO> buildVersionMap(CostDTO costDTO) throws Exception {
        List pdServiceVersionEntities = this.pdServiceVersion.getVersionListByCids(costDTO.pdServiceVersionLinks());
        return pdServiceVersionEntities.stream().collect(Collectors.toMap(PdServiceVersionEntity::getC_id, entity -> PdServiceVersionCostVO.builder().id(entity.getC_id()).title(entity.getC_title()).build()));
    }

    private Map<String, Map<Long, List<LinkedJiraIssueVO.RequirementData>>> getLinkedJiraIssues(CostDTO costDTO, Long pdServiceId) throws Exception {
        SessionUtil.setAttribute((String)"cost-calculation", (Object)("T_ARMS_REQSTATUS_" + pdServiceId));
        LinkedJiraIssueVO linkedJiraIssueVO = this.getLinkedJiraIssuesByVersionAndRequirement(costDTO);
        SessionUtil.removeAttribute((String)"cost-calculation");
        return linkedJiraIssueVO.getLinkedJiraIssueData();
    }

    private RequirementDifficultyAndPriorityVO getRequirementListAndDifficultyAndPriority(CostDTO costDTO, Long pdServiceId) throws Exception {
        SessionUtil.setAttribute((String)"cost-calculation", (Object)("T_ARMS_REQADD_" + pdServiceId));
        RequirementDifficultyAndPriorityVO requirementListStats = this.getRequirementListStats(costDTO);
        SessionUtil.removeAttribute((String)"cost-calculation");
        return requirementListStats;
    }

    private LocalDate convertToLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private long calculateCostByAssignee(LocalDate startDate, LocalDate endDate, long salary) {
        long days = ChronoUnit.DAYS.between(startDate, endDate) + 1L;
        long dailyPay = Math.round((double)salary / 365.0);
        return days * dailyPay;
    }

    private VersionRequirementAssigneeVO getVersionRequirementAssignee(CostDTO costDTO) throws Exception {
        Map salaryEntityMap = this.salaryService.getAllSalariesMap();
        if (salaryEntityMap.isEmpty()) {
            log.info(" [ " + this.getClass().getName() + " :: \ubc84\uc804\ubcc4_\uc694\uad6c\uc0ac\ud56d\ubcc4_\ub2f4\ub2f9\uc790\uac00\uc838\uc624\uae30 ] :: \ub514\ube44\uc5d0\uc11c \uc5f0\ubd09 \uc815\ubcf4\ub97c \uc870\ud68c\ud558\ub294 \ub370 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
            this.chat.sendMessageByEngine("\ub4f1\ub85d \ub41c \uc5f0\ubd09 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return new VersionRequirementAssigneeVO(new HashMap(), new HashMap());
        }
        PdServiceAndIsReqDTO pdServiceAndIsReq = costDTO.getPdServiceAndIsReq();
        pdServiceAndIsReq.setIsReq(Boolean.valueOf(true));
        ResponseEntity reqReqList = this.aggregationService.getAssigneeListByProductVersionAndRequirement(costDTO);
        pdServiceAndIsReq.setIsReq(Boolean.valueOf(false));
        ResponseEntity subReqList = this.aggregationService.getAssigneeListByProductVersionAndRequirement(costDTO);
        ArrayList allResult = new ArrayList();
        allResult.addAll((Collection)reqReqList.getBody());
        allResult.addAll((Collection)subReqList.getBody());
        HashMap<String, Map> versionRequirementAssignee = new HashMap<String, Map>();
        HashMap<String, AssigneeSalaryVO> allAssigneeMap = new HashMap<String, AssigneeSalaryVO>();
        for (CostVO costVO : allResult) {
            String assigneeAccountId = costVO.getAssigneeKey();
            String requirementId = costVO.getReqKey();
            String subReqId = costVO.getSubReqKey();
            String versionId = costVO.getVersionKey();
            String assigneeDisplayName = costVO.getDisplayNameKey();
            Long salary = Optional.ofNullable(salaryEntityMap).flatMap(map -> Optional.ofNullable((SalaryEntity)map.get(assigneeAccountId))).map(SalaryEntity::getC_annual_income).filter(s -> !s.trim().isEmpty()).map(NumberUtils::toLong).orElse(0L);
            AssigneeSalaryVO assigneeSalaryVO = AssigneeSalaryVO.builder().id(assigneeAccountId).name(assigneeDisplayName).salary(salary).consumedCostByVersionAssignee(Long.valueOf(0L)).completePerformance(Long.valueOf(0L)).build();
            allAssigneeMap.put(assigneeAccountId, assigneeSalaryVO);
            if (requirementId != null && !requirementId.trim().isEmpty()) {
                versionRequirementAssignee.computeIfAbsent(versionId, k -> new HashMap()).computeIfAbsent(requirementId, k -> new HashMap()).put(assigneeAccountId, assigneeSalaryVO);
            }
            if (subReqId == null || subReqId.trim().isEmpty()) continue;
            versionRequirementAssignee.computeIfAbsent(versionId, k -> new HashMap()).computeIfAbsent(subReqId, k -> new HashMap()).put(assigneeAccountId, assigneeSalaryVO);
        }
        return new VersionRequirementAssigneeVO(versionRequirementAssignee, allAssigneeMap);
    }

    public CostCalculationVO calculateVersionCost(CostDTO costDTO) throws Exception {
        CostCalculationVO costCalculationVO = this.calculateCostAll(costDTO);
        return CostCalculationVO.builder().versionCostMap(costCalculationVO.getVersionCostMap()).versionRequirementAssignee(costCalculationVO.getVersionRequirementAssignee()).build();
    }

    public CostCalculationVO calculateRequirementCost(CostDTO costDTO) throws Exception {
        CostCalculationVO costCalculationVO = this.calculateCostAll(costDTO);
        return CostCalculationVO.builder().requirement(costCalculationVO.getRequirement()).difficulty(costCalculationVO.getDifficulty()).priority(costCalculationVO.getPriority()).build();
    }

    public CostCalculationVO calculateAssigneeCost(CostDTO costDTO) throws Exception {
        CostCalculationVO costCalculationVO = this.calculateCostAll(costDTO);
        return CostCalculationVO.builder().assigneeTimeDiffVOs(costCalculationVO.getAssigneeTimeDiffVOs()).build();
    }

    public CostCalculationVO toBeCalculateCost(CalculationCostDTO calculationCostDTO) throws Exception {
        Map allSalariesMap = this.salaryService.getAllSalariesMap();
        if (allSalariesMap.isEmpty()) {
            log.info(" [ " + this.getClass().getName() + " :: toBeCalculateCost ] :: \ub514\ube44\uc5d0\uc11c \uc5f0\ubd09 \uc815\ubcf4\ub97c \uc870\ud68c\ud558\ub294 \ub370 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
            this.chat.sendMessageByEngine("\ub4f1\ub85d \ub41c \uc5f0\ubd09 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        Map salaryDTOMap = allSalariesMap.values().stream().map(salaryEntity -> {
            AssigneeSalaryDTO assigneeSalaryDTO = new AssigneeSalaryDTO();
            assigneeSalaryDTO.setAssigneeId(salaryEntity.getC_key());
            assigneeSalaryDTO.setName(salaryEntity.getC_name());
            assigneeSalaryDTO.setSalary(Long.valueOf(salaryEntity.getC_annual_income() != null ? Long.parseLong(salaryEntity.getC_annual_income()) : 0L));
            return assigneeSalaryDTO;
        }).collect(Collectors.toMap(AssigneeSalaryDTO::getAssigneeId, Function.identity()));
        calculationCostDTO.setSalaryDTO(salaryDTOMap);
        ResponseEntity response = this.engineService.calculationCost(calculationCostDTO);
        return null;
    }

    public CostServiceImpl(AggregationService aggregationService, PdServiceVersion pdServiceVersion, Chat chat, SalaryLog salaryLog, InternalService internalCommunicator, ReqAdd reqAdd, ReqStatus reqStatus, ReqState reqStateService, SalaryService salaryService, ModelMapper modelMapper, EngineService engineService) {
        this.aggregationService = aggregationService;
        this.pdServiceVersion = pdServiceVersion;
        this.chat = chat;
        this.salaryLog = salaryLog;
        this.internalCommunicator = internalCommunicator;
        this.reqAdd = reqAdd;
        this.reqStatus = reqStatus;
        this.reqStateService = reqStateService;
        this.salaryService = salaryService;
        this.modelMapper = modelMapper;
        this.engineService = engineService;
    }
}

