/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.cost.controller;

import com.arms.api.analysis.cost.model.vo.SalaryEntity;
import com.arms.api.analysis.cost.model.vo.SalaryVO;
import com.arms.api.analysis.cost.service.SalaryService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsBase;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsFactory;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/admin/arms/salaries"})
public class SalaryController
extends TreeAbstractController<SalaryService, SalaryVO, SalaryEntity> {
    private static final Logger log = LoggerFactory.getLogger(SalaryController.class);
    private final SalaryService salaryService;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.salaryService);
        this.setTreeEntity(SalaryEntity.class);
    }

    @ApiOperation(value="\uc5f0\ubd09 \uc785\ub825 \uc5d1\uc140 \ud15c\ud50c\ub9bf \ub2e4\uc6b4\ub85c\ub4dc")
    @PostMapping(value={"/excel-download.do"})
    public void \uc5f0\ubd09\uc785\ub825_\uc5d1\uc140\ud15c\ud50c\ub9bf_\ub2e4\uc6b4\ub85c\ub4dc(@RequestBody List<SalaryVO> \uc5f0\ubd09\ub370\uc774\ud130\ub9ac\uc2a4\ud2b8, @RequestParam(value="excelFileName") String excelFileName, HttpServletResponse httpServletResponse) throws Exception {
        log.info(" [ " + this.getClass().getName() + " :: \uc5f0\ubd09\uc785\ub825_\uc5d1\uc140\ud15c\ud50c\ub9bf_\ub2e4\uc6b4\ub85c\ub4dc ]");
        httpServletResponse.addHeader("Content-Disposition", "attachment; filename=" + excelFileName);
        httpServletResponse.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpServletResponse.addHeader("Pragma", "no-cache");
        httpServletResponse.addHeader("Expires", "0");
        httpServletResponse.setContentType("application/octet-stream");
        ExcelUtilsBase excelUtilsBase = ExcelUtilsFactory.getInstance((OutputStream)httpServletResponse.getOutputStream());
        List \uc0d8\ud50c\ub370\uc774\ud130 = this.salaryService.getSampleSalaryInfo();
        List \ube44\uad50\ud55c_\uc5f0\ubd09\ub9ac\uc2a4\ud2b8 = this.salaryService.compareSalaryInfo(\uc5f0\ubd09\ub370\uc774\ud130\ub9ac\uc2a4\ud2b8);
        excelUtilsBase.create(List.of(\uc0d8\ud50c\ub370\uc774\ud130, \ube44\uad50\ud55c_\uc5f0\ubd09\ub9ac\uc2a4\ud2b8));
    }

    @ApiOperation(value="\uc5f0\ubd09 \uc785\ub825 \uc5d1\uc140 \ud15c\ud50c\ub9bf \uc5c5\ub85c\ub4dc")
    @PostMapping(value={"/excel-upload.do"})
    public ModelAndView uploadSalaryTemplate(@RequestPart(value="excelFile") MultipartFile excelFile, HttpServletRequest httpServletRequest) throws Exception {
        ExcelUtilsBase excelUtilsBase = ExcelUtilsFactory.getInstance((InputStream)excelFile.getInputStream());
        List uploadedSalaryList = excelUtilsBase.read(SalaryEntity.class);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.salaryService.saveExcelDataToDB(uploadedSalaryList));
        return modelAndView;
    }

    @PutMapping
    public ResponseEntity<CommonResponse.ApiResult<List<SalaryVO>>> bulkUpdate(@RequestBody Map<String, SalaryVO> salaryMaps) throws Exception {
        List salaryVOList = salaryMaps.values().stream().collect(Collectors.toList());
        List salaryEntityList = salaryVOList.stream().map(dto -> (SalaryEntity)this.modelMapper.map(dto, SalaryEntity.class)).collect(Collectors.toList());
        this.salaryService.updateSalary(salaryEntityList);
        Map fetchSalary = this.salaryService.getAllSalariesMap();
        List response = fetchSalary.values().stream().map(entity -> (SalaryVO)this.modelMapper.map(entity, SalaryVO.class)).collect(Collectors.toList());
        return ResponseEntity.ok((Object)CommonResponse.success(response));
    }

    @GetMapping(value={"/transfer-salary-info"})
    public List<SalaryVO> transferSalaryInfo() throws Exception {
        return this.salaryService.getAllSalaries();
    }

    public SalaryController(SalaryService salaryService) {
        this.salaryService = salaryService;
    }
}

