/**
 * Copyright (c) 2020-2025, JGraph Holdings Ltd
 * Copyright (c) 2020-2025, draw.io AG
 */
(function()
{
	Sidebar.prototype.addAlibabaCloudPalette = function()
	{
		var d = 30;
		var dt = 'alibaba cloud';
		var sb = this;
		var s = 'points=[];aspect=fixed;html=1;align=center;shadow=0;dashed=0;fillColor=#FF6A00;strokeColor=none;shape=mxgraph.alibaba_cloud.';

		// Adds Alibaba Cloud shapes
		this.setCurrentSearchEntryLibrary('alibaba_cloud', 'alibaba_cloud');
		this.addAlibabaCloudGeneralPalette(d, dt, sb, s);
		this.setCurrentSearchEntryLibrary();
	};

	Sidebar.prototype.addAlibabaCloudGeneralPalette = function(d, dt, sb, s)
	{
		var gn = 'buildings';
		
		var fns = [
			this.createVertexTemplateEntry(s + 'abap_business_application_platform;',
				d * 1.82, d * 1.65, '', 'ABAP Business Application Platform', false, null, this.getTagsForStencil(gn, 'abap business application platform', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'acms_application_configuration_manangement;',
				d * 1.7, d * 1.58, '', 'ACMS Application Configuration Manangement', false, null, this.getTagsForStencil(gn, 'acms application configuration manangement', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'acr_cloud_container_registry;',
				d * 1.62, d * 1.88, '', 'ACR Cloud Container Registry', false, null, this.getTagsForStencil(gn, 'acr cloud container registry', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'actiontrail;',
				d * 1.67, d * 1.67, '', 'ActionTrail', false, null, this.getTagsForStencil(gn, 'actiontrail', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'adam_advanced_database_and_application_migration;',
				d * 1.43, d * 1.71, '', 'ADAM Advanced Database and Application Migration', false, null, this.getTagsForStencil(gn, 'adam advanced database and application migration', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'adb_analyticdb_for_mysql;',
				d * 1.63, d * 1.83, '', 'ADB AnalyticDB for MySQL', false, null, this.getTagsForStencil(gn, 'adb analyticdb for mysql my sql', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'address_purification;',
				d * 1.69, d * 1.79, '', 'Address Purification', false, null, this.getTagsForStencil(gn, 'address purification', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'afs_fraud_service;',
				d * 1.47, d * 1.66, '', 'AFS Fraud Service', false, null, this.getTagsForStencil(gn, 'afs fraud service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'agw_aligateway;',
				d * 1.57, d * 1.32, '', 'AGW AliGateWay', false, null, this.getTagsForStencil(gn, 'agw aligateway', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ahas_application_high_availability_service;',
				d * 1.55, d * 1.79, '', 'AHAS Application High Availability Service', false, null, this.getTagsForStencil(gn, 'ahas application high availability service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'airec_artificial_intelligence_recommendation;',
				d * 2.0, d * 2.0, '', 'AIRec Artificial Intelligence Recommendation', false, null, this.getTagsForStencil(gn, 'airec artificial intelligence recommendation', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'alb_application_load_balancer_01;',
				d * 1.58, d * 1.34, '', 'ALB Application Load Balancer', false, null, this.getTagsForStencil(gn, 'alb application load balancer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'alb_application_load_balancer_02;',
				d * 2, d * 2, '', 'ALB Application Load Balancer', false, null, this.getTagsForStencil(gn, 'alb application load balancer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'alibaba_cloud_logo_chinese;',
				d * 5.12, d * 1.14, '', 'Alibaba Cloud Logo Chinese', false, null, this.getTagsForStencil(gn, 'alibaba cloud logo chinese', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'alibaba_cloud_logo_english;',
				d * 5.16, d * 0.65, '', 'Alibaba Cloud Logo English', false, null, this.getTagsForStencil(gn, 'alibaba cloud logo english', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'alibaba_cloud_logo;',
				d * 3.22, d * 2.0, '', 'Alibaba Cloud Logo', false, null, this.getTagsForStencil(gn, 'alibaba cloud logo', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'alimail;',
				d * 1.92, d * 1.3, '', 'AliMail', false, null, this.getTagsForStencil(gn, 'alimail', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'alimt_machine_translation;',
				d * 1.58, d * 1.59, '', 'AliMT Machine Translation', false, null, this.getTagsForStencil(gn, 'alimt machine translation', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'aliyun_linux;',
				d * 1.75, d * 1.75, '', 'Aliyun Linux', false, null, this.getTagsForStencil(gn, 'aliyun linux', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'amqp_advanced_message_queuing_protocol;',
				d * 1.53, d * 1.6, '', 'AMQP Advanced Message Queuing Protocol', false, null, this.getTagsForStencil(gn, 'amqp advanced message queuing protocol', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'amscloudapp;',
				d * 1.89, d * 1.32, '', 'AMSCloudApp', false, null, this.getTagsForStencil(gn, 'amscloudapp ams cloud app', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'analyticdb_for_postgresql;',
				d * 1.67, d * 1.65, '', 'AnalyticDB for PostgreSQL', false, null, this.getTagsForStencil(gn, 'analyticdb for postgresql', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'antibot;',
				d * 1.85, d * 1.65, '', 'AntiBot', false, null, this.getTagsForStencil(gn, 'antibot', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'apigateway;',
				d * 1.44, d * 1.39, '', 'APIGateway', false, null, this.getTagsForStencil(gn, 'apigateway api gateway application programming interface', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'apsara_file_storage_for_hdfs;',
				d * 1.6, d * 1.58, '', 'Apsara File Storage for HDFS', false, null, this.getTagsForStencil(gn, 'apsara file storage for hdfs', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'apsaravideo_vod;',
				d * 1.79, d * 1.3, '', 'ApsaraVideo VOD', false, null, this.getTagsForStencil(gn, 'apsaravideo vod', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'arms_application_real-time_monitoring_service;',
				d * 1.83, d * 0.88, '', 'ARMS Application Real-Time Monitoring Service', false, null, this.getTagsForStencil(gn, 'arms application real-time monitoring service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ask_ack_container_service_for_kubernetes;',
				d * 1.49, d * 1.71, '', 'ASK ACK Container Service for Kubernetes', false, null, this.getTagsForStencil(gn, 'ask ack container service for kubernetes', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'asm_service_mesh;',
				d * 1.44, d * 1.67, '', 'ASM Service Mesh', false, null, this.getTagsForStencil(gn, 'asm service mesh', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'assettech;',
				d * 1.44, d * 1.39, '', 'AssetTech', false, null, this.getTagsForStencil(gn, 'assettech asset tech', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'avds_vulnerability_db_scanning;',
				d * 1.83, d * 1.83, '', 'AVDS Vulnerability DB Scanning', false, null, this.getTagsForStencil(gn, 'avds vulnerability db scanning', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'baas_blockchain_as_a_service;',
				d * 1.44, d * 1.58, '', 'BaaS Blockchain as a Service', false, null, this.getTagsForStencil(gn, 'baas blockchain as a service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'bandwidth_bag;',
				d * 1.83, d * 1.33, '', 'Bandwidth Bag', false, null, this.getTagsForStencil(gn, 'bandwidth bag', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'bastionhost;',
				d * 1.68, d * 1.33, '', 'BastionHost', false, null, this.getTagsForStencil(gn, 'bastionhost bastion host', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'batchcompute;',
				d * 1.56, d * 1.6, '', 'BatchCompute', false, null, this.getTagsForStencil(gn, 'batchcompute batch compute', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'bccluster;',
				d * 1.67, d * 1.24, '', 'BCCluster', false, null, this.getTagsForStencil(gn, 'bccluster bc cluster', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'beebot;',
				d * 1.99, d * 1.83, '', 'BeeBot', false, null, this.getTagsForStencil(gn, 'beebot bee bot', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'beian;',
				d * 1.57, d * 1.61, '', 'Beian', false, null, this.getTagsForStencil(gn, 'beian', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'bizdevops;',
				d * 2.01, d * 1.67, '', 'BizDevOps', false, null, this.getTagsForStencil(gn, 'bizdevops biz dev ops', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'bizworks;',
				d * 1.44, d * 1.39, '', 'BizWorks', false, null, this.getTagsForStencil(gn, 'bizworks biz works', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'bpstudio;',
				d * 1.67, d * 1.21, '', 'BPStudio', false, null, this.getTagsForStencil(gn, 'bp studio', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cas_ssl_central_authentication_service;',
				d * 1.46, d * 1.65, '', 'CAS SSL Central Authentication Service', false, null, this.getTagsForStencil(gn, 'cas ssl central authentication service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cassandra_wide-column_database_01;',
				d * 1.46, d * 1.56, '', 'Cassandra Wide-Column Database', false, null, this.getTagsForStencil(gn, 'cassandra wide column database', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cassandra_wide-column_database_02;',
				d * 1.71, d * 1.83, '', 'Cassandra Wide-Column Database', false, null, this.getTagsForStencil(gn, 'cassandra wide column database', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ccc_cloud_call_center;',
				d * 1.79, d * 1.74, '', 'CCC Cloud Call Center', false, null, this.getTagsForStencil(gn, 'ccc cloud call center', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ccn_cloud_connect_network;',
				d * 1.87, d * 1.53, '', 'CCN Cloud Connect Network', false, null, this.getTagsForStencil(gn, 'ccn cloud connect network', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ccs_customer_service_01;',
				d * 1.8, d * 1.82, '', 'CCS Customer Service', false, null, this.getTagsForStencil(gn, 'ccs customer service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ccs_customer_service_02;',
				d * 1.74, d * 1.84, '', 'CCS Customer Service', false, null, this.getTagsForStencil(gn, 'ccs customer service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cddc_cloud_database_dedicated_cluster;',
				d * 1.68, d * 1.52, '', 'CDDC Cloud Database Dedicated Cluster', false, null, this.getTagsForStencil(gn, 'cddc cloud database dedicated cluster', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cdn_content_distribution_network;',
				d * 1.7, d * 1.41, '', 'CDN Content Distribution Network', false, null, this.getTagsForStencil(gn, 'cdn content distribution network', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cdp_cloudera_cdp;',
				d * 1.83, d * 1.14, '', 'CDP Cloudera CDP', false, null, this.getTagsForStencil(gn, 'cdp cloudera', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cdt_cloud_datatransfer;',
				d * 1.67, d * 1.41, '', 'CDT Cloud DataTransfer', false, null, this.getTagsForStencil(gn, 'cdt cloud datatransfer data transfer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cen_cloud_enterprise_network;',
				d * 1.78, d * 1.83, '', 'CEN Cloud Enterprise Network', false, null, this.getTagsForStencil(gn, 'cen cloud enterprise network', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cfw_cloud_firewall;',
				d * 1.85, d * 1.3, '', 'CFW Cloud Firewall', false, null, this.getTagsForStencil(gn, 'cfw cloud firewall', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cityvisual;',
				d * 1.75, d * 1.23, '', 'CityVisual', false, null, this.getTagsForStencil(gn, 'cityvisual city visual', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'clb_classic_load_balancer_01;',
				d * 1.58, d * 1.34, '', 'CLB Classic Load Balancer', false, null, this.getTagsForStencil(gn, 'clb classic load balancer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'clb_classic_load_balancer_02;',
				d * 2, d * 2, '', 'CLB Classic Load Balancer', false, null, this.getTagsForStencil(gn, 'clb classic load balancer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'clickhouse;',
				d * 1.6, d * 1.83, '', 'ClickHouse', false, null, this.getTagsForStencil(gn, 'clickhouse click house', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloud_auth;',
				d * 2, d * 1.82, '', 'Cloud Auth', false, null, this.getTagsForStencil(gn, 'cloud auth', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloud_config;',
				d * 1.58, d * 1.6, '', 'Cloud Config', false, null, this.getTagsForStencil(gn, 'cloud config', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloud_display;',
				d * 1.83, d * 1.44, '', 'Cloud Display', false, null, this.getTagsForStencil(gn, 'cloud display', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloud_governance_center;',
				d * 1.67, d * 1.45, '', 'Cloud Governance Center', false, null, this.getTagsForStencil(gn, 'cloud governance center', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloud_security_center;',
				d * 1.44, d * 1.63, '', 'Cloud Security Center', false, null, this.getTagsForStencil(gn, 'Cloud Security Center', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloud_shield;',
				d * 1.52, d * 1.63, '', 'Cloud Shield', false, null, this.getTagsForStencil(gn, 'cloud shield', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloudap;',
				d * 1.83, d * 1.84, '', 'CloudAP', false, null, this.getTagsForStencil(gn, 'cloudap cloud ap', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloudbox;',
				d * 1.58, d * 1.83, '', 'CloudBox', false, null, this.getTagsForStencil(gn, 'cloudbox cloud box', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'clouddesktop;',
				d * 1.83, d * 1.84, '', 'CloudDesktop', false, null, this.getTagsForStencil(gn, 'clouddesktop cloud desktop', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'clouddev;',
				d * 1.89, d * 1.35, '', 'CloudDev', false, null, this.getTagsForStencil(gn, 'clouddev', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloudphoto;',
				d * 1.5, d * 1.5, '', 'CloudPhoto', false, null, this.getTagsForStencil(gn, 'cloudphoto cloud photo', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloudproc;',
				d * 1.44, d * 1.39, '', 'CloudProc', false, null, this.getTagsForStencil(gn, 'cloudproc', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cloudshell;',
				d * 1.58, d * 1.26, '', 'CloudShell', false, null, this.getTagsForStencil(gn, 'cloudshell', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cmn_cloud_managed_network;',
				d * 1.73, d * 1.26, '', 'CMN Cloud Managed Network', false, null, this.getTagsForStencil(gn, 'cmn cloud managed network', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cmp_cloud_mobile_push;',
				d * 1.64, d * 1.19, '', 'CMP Cloud Mobile Push', false, null, this.getTagsForStencil(gn, 'cmp cloud mobile push', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cms_cloud_monitor_service;',
				d * 1.74, d * 1.38, '', 'CMS Cloud Monitor Service', false, null, this.getTagsForStencil(gn, 'cms cloud monitor service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'codepipeline;',
				d * 1.37, d * 1.74, '', 'CodePipeline', false, null, this.getTagsForStencil(gn, 'codepipeline', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'codestore;',
				d * 1.44, d * 1.39, '', 'CodeStore', false, null, this.getTagsForStencil(gn, 'codestore', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'companyreg;',
				d * 1.58, d * 1.75, '', 'CompanyReg', false, null, this.getTagsForStencil(gn, 'companyreg', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'computenest;',
				d * 1.67, d * 1.48, '', 'ComputeNest', false, null, this.getTagsForStencil(gn, 'computenest', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'content_security;',
				d * 1.55, d * 1.57, '', 'Content Security', false, null, this.getTagsForStencil(gn, 'content security', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'coo;',
				d * 1.45, d * 1.58, '', 'COO', false, null, this.getTagsForStencil(gn, 'coo', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cpns_cell_phone_number_service;',
				d * 1.33, d * 1.83, '', 'CPNS Cell Phone Number Service', false, null, this.getTagsForStencil(gn, 'cpns cell phone number service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'csas_cloud_security_access_service;',
				d * 1.44, d * 1.67, '', 'CSAS Cloud Security Access Service', false, null, this.getTagsForStencil(gn, 'csas cloud security access service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cvc_cloud_video_conferencing;',
				d * 1.33, d * 1.82, '', 'CVC Cloud Video Conferencing', false, null, this.getTagsForStencil(gn, 'cvc cloud video conferencing', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'cwh_cloud_web_hosting;',
				d * 1.66, d * 1.52, '', 'CWH Cloud Web Hosting', false, null, this.getTagsForStencil(gn, 'cwh cloud web hosting', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'das_database_autonomy_service;',
				d * 1.58, d * 1.58, '', 'DAS Database Autonomy Service', false, null, this.getTagsForStencil(gn, 'das database autonomy service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'databot;',
				d * 1.51, d * 1.74, '', 'DataBot', false, null, this.getTagsForStencil(gn, 'databot data bot', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'datahub;',
				d * 1.59, d * 1.59, '', 'DataHub', false, null, this.getTagsForStencil(gn, 'datahub data hub', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dataphin;',
				d * 1.82, d * 1.82, '', 'Dataphin', false, null, this.getTagsForStencil(gn, 'dataphin', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dataquotient;',
				d * 1.61, d * 1.61, '', 'DataQuotient', false, null, this.getTagsForStencil(gn, 'dataquotient data quotient', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'datav;',
				d * 1.64, d * 1.48, '', 'DataV', false, null, this.getTagsForStencil(gn, 'datav data', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dataworks_dataide;',
				d * 1.52, d * 1.75, '', 'DataWorks DataIDE', false, null, this.getTagsForStencil(gn, 'dataworks dataide data works ide integrated development environment', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dbaudit;',
				d * 1.63, d * 1.63, '', 'DBAudit', false, null, this.getTagsForStencil(gn, 'dbaudit db database audit', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dbes_database_expert_service;',
				d * 1.58, d * 1.58, '', 'DBES Database Expert Service', false, null, this.getTagsForStencil(gn, 'dbes database expert service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dbfs_database_file_system;',
				d * 1.58, d * 1.6, '', 'DBFS Database File System', false, null, this.getTagsForStencil(gn, 'dbfs database file system', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dbs_database_backup;',
				d * 2.28, d * 2.13, '', 'DBS Database Backup', false, null, this.getTagsForStencil(gn, 'dbs database backup', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dcdn_dynamic_route_for_cdn;',
				d * 1.55, d * 1.83, '', 'DCDN Dynamic Route for CDN', false, null, this.getTagsForStencil(gn, 'dcdn dynamic route for cdn', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ddh_dedicated_host;',
				d * 1.58, d * 1.58, '', 'DDH Dedicated Host', false, null, this.getTagsForStencil(gn, 'ddh dedicated host', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ddos_protection;',
				d * 1.38, d * 1.58, '', 'DDoS Protection', false, null, this.getTagsForStencil(gn, 'ddos protection', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ddos-bgp;',
				d * 1.58, d * 1.57, '', 'DDoS-BGP', false, null, this.getTagsForStencil(gn, 'ddos bgp', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ddos-dip;',
				d * 1.61, d * 1.84, '', 'DDoS-DIP', false, null, this.getTagsForStencil(gn, 'ddos dip', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ddos-pro;',
				d * 1.59, d * 1.56, '', 'DDoS-Pro', false, null, this.getTagsForStencil(gn, 'ddos pro', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'devops;',
				d * 2, d * 2, '', 'DevOps', false, null, this.getTagsForStencil(gn, 'devops dev ops', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dg_database_gateway;',
				d * 1.33, d * 1.83, '', 'DG Database Gateway', false, null, this.getTagsForStencil(gn, 'dg database gateway', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'directmail;',
				d * 1.75, d * 1.16, '', 'DirectMail', false, null, this.getTagsForStencil(gn, 'directmail direct mail', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'disk_block_storage;',
				d * 1.72, d * 1.38, '', 'Disk Block Storage', false, null, this.getTagsForStencil(gn, 'disk block storage', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dlf_data_lake_formation;',
				d * 1.78, d * 1.67, '', 'DLF Data Lake Formation', false, null, this.getTagsForStencil(gn, 'dlf data lake formation', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dms_data_management_service;',
				d * 1.53, d * 1.58, '', 'DMS Data Management Service', false, null, this.getTagsForStencil(gn, 'dms data management service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dns_domain_name_system;',
				d * 1.86, d * 1.83, '', 'DNS Domain Name System', false, null, this.getTagsForStencil(gn, 'dns domain name system', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dns_privatezone_01;',
				d * 1.86, d * 1.83, '', 'DNS PrivateZone', false, null, this.getTagsForStencil(gn, 'dns privatezone private zone', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dns_privatezone_02;',
				d * 1.66, d * 1.74, '', 'DNS PrivateZone', false, null, this.getTagsForStencil(gn, 'dns privatezone private zone', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'domain_and_website;',
				d * 1.71, d * 1.38, '', 'Domain and Website', false, null, this.getTagsForStencil(gn, 'domain and website', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'domain;',
				d * 1.83, d * 1.83, '', 'Domain', false, null, this.getTagsForStencil(gn, 'domain', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'drds_distribute_relational_database_service;',
				d * 1.48, d * 1.58, '', 'DRDS Distribute Relational Database Service', false, null, this.getTagsForStencil(gn, 'drds distribute relational database service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dsi_data_security_insurance;',
				d * 1.45, d * 1.71, '', 'DSI Data Security Insurance', false, null, this.getTagsForStencil(gn, 'dsi data security insurance', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'dts_data_transmission_service;',
				d * 1.6, d * 1.58, '', 'DTS Data Transmission Service', false, null, this.getTagsForStencil(gn, 'dts data transmission service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'e-mapreduce;',
				d * 2, d * 2, '', 'E-MapReduce', false, null, this.getTagsForStencil(gn, 'emapreduce map reduce mapreduce', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'eais_elastic_accelerated_computing_instances;',
				d * 1.73, d * 1.2, '', 'EAIS Elastic Accelerated Computing Instances', false, null, this.getTagsForStencil(gn, 'eais elastic accelerated computing instances', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'eci_elastic_container_instance;',
				d * 1.83, d * 1.28, '', 'ECI Elastic Container Instance', false, null, this.getTagsForStencil(gn, 'eci elastic container instance', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ecs_elastic_compute_service;',
				d * 1.62, d * 1.51, '', 'ECS Elastic Compute Service', false, null, this.getTagsForStencil(gn, 'ecs elastic compute service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'edas_enterprise_distributed_application_service;',
				d * 1.55, d * 1.58, '', 'EDAS Enterprise Distributed Application Service', false, null, this.getTagsForStencil(gn, 'edas enterprise distributed application service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ehpc_elastic_high_performance_computing;',
				d * 1.44, d * 1.59, '', 'EHPC Elastic High Performance Computing', false, null, this.getTagsForStencil(gn, 'ehpc elastic high performance computing', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'eip_elastic_ip_address;',
				d * 1.58, d * 1.55, '', 'EIP Elastic IP Address', false, null, this.getTagsForStencil(gn, 'eip elastic ip address internet protocol', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'elastic_web_hosting;',
				d * 1.78, d * 1.71, '', 'Elastic Web Hosting', false, null, this.getTagsForStencil(gn, 'elastic web hosting', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'elasticsearch;',
				d * 1.53, d * 1.67, '', 'Elasticsearch', false, null, this.getTagsForStencil(gn, 'elasticsearch', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'emas_enterprise_mobile_application_studio;',
				d * 1.44, d * 1.39, '', 'EMAS Enterprise Mobile Application Studio', false, null, this.getTagsForStencil(gn, 'emas enterprise mobile application studio', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'energyexpert;',
				d * 1.44, d * 1.39, '', 'EnergyExpert', false, null, this.getTagsForStencil(gn, 'energyexpert energy expert', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ens_edge_node_service;',
				d * 1.83, d * 1.83, '', 'ENS Edge Node Service', false, null, this.getTagsForStencil(gn, 'ens edge node service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'enterprise_website;',
				d * 1.77, d * 1.38, '', 'Enterprise Website', false, null, this.getTagsForStencil(gn, 'enterprise website', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'eprofile;',
				d * 1.67, d * 1.44, '', 'EProfile', false, null, this.getTagsForStencil(gn, 'eprofile profile', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'esign;',
				d * 1.39, d * 1.53, '', 'eSign', false, null, this.getTagsForStencil(gn, 'esign sign', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ess_elastic_scaling_service;',
				d * 1.84, d * 1.01, '', 'ESS Elastic Scaling Service', false, null, this.getTagsForStencil(gn, 'ess elastic scaling service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'eventbridge;',
				d * 1.63, d * 1.63, '', 'EventBridge', false, null, this.getTagsForStencil(gn, 'eventbridge event bridge', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'express_connect;',
				d * 1.72, d * 1.58, '', 'Express Connect', false, null, this.getTagsForStencil(gn, 'express connect', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'face_recognition;',
				d * 1.58, d * 1.56, '', 'Face Recognition', false, null, this.getTagsForStencil(gn, 'face recognition', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'fc_function_compute;',
				d * 1.72, d * 1.71, '', 'FC Function Compute', false, null, this.getTagsForStencil(gn, 'fc function compute', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'flow_service;',
				d * 1.33, d * 1.75, '', 'Flow Service', false, null, this.getTagsForStencil(gn, 'flow service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'flowbag;',
				d * 1.84, d * 1.18, '', 'Flowbag', false, null, this.getTagsForStencil(gn, 'flowbag', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'fnf_serverless_function_flow;',
				d * 1.6, d * 1.85, '', 'FNF Serverless Function Flow', false, null, this.getTagsForStencil(gn, 'fnf serverless function flow', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'fpga_field_programmable_gate_array;',
				d * 1.52, d * 1.51, '', 'FPGA Field Programmable Gate Array', false, null, this.getTagsForStencil(gn, 'fpga field programmable gate array', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'fraud_detection;',
				d * 1.58, d * 1.58, '', 'Fraud Detection', false, null, this.getTagsForStencil(gn, 'fraud detection', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ga_global_accelerator;',
				d * 1.83, d * 1.83, '', 'GA Global Accelerator', false, null, this.getTagsForStencil(gn, 'ga global accelerator', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'gameshield;',
				d * 1.71, d * 1.48, '', 'GameShield', false, null, this.getTagsForStencil(gn, 'gameshield', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'gdb_graph_database;',
				d * 1.83, d * 1.58, '', 'GDB Graph Database', false, null, this.getTagsForStencil(gn, 'gdb graph database', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'graphanalytics;',
				d * 1.33, d * 1.66, '', 'GraphAnalytics', false, null, this.getTagsForStencil(gn, 'graphanalytics graph analytics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'graphcompute;',
				d * 1.66, d * 1.67, '', 'GraphCompute', false, null, this.getTagsForStencil(gn, 'graphcompute graph compute', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'gtm_global_traffic_manager;',
				d * 1.85, d * 1.81, '', 'GTM Global Traffic Manager', false, null, this.getTagsForStencil(gn, 'gtm global traffic manager', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'gts_global_transaction_service;',
				d * 1.58, d * 1.6, '', 'GTS Global Transaction Service', false, null, this.getTagsForStencil(gn, 'gts global transaction service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'gws_graphic_workstation;',
				d * 1.58, d * 1.58, '', 'GWS Graphic Workstation', false, null, this.getTagsForStencil(gn, 'gws graphic workstation', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'havip_high-availability_virtual_ip_address;',
				d * 1.75, d * 1.75, '', 'HaVip High-Availability Virtual IP Address', false, null, this.getTagsForStencil(gn, 'havip high availability virtual ip address internet protocol', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'hbase;',
				d * 1.51, d * 1.52, '', 'HBase', false, null, this.getTagsForStencil(gn, 'hbase base', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'hbr_hybrid_backup_recovery;',
				d * 1.61, d * 1.83, '', 'HBR Hybrid Backup Recovery', false, null, this.getTagsForStencil(gn, 'hbr hybrid backup recovery', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'hcs-hgw_hybrid_cloud_storage_array;',
				d * 1.35, d * 1.57, '', 'HCS-HGW Hybrid Cloud Storage Array', false, null, this.getTagsForStencil(gn, 'hcs hgw hybrid cloud storage array', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'hcs-mgw_hybrid_cloud_storage_datatransport;',
				d * 1.69, d * 1.35, '', 'HCS-MGW Hybrid Cloud Storage Datatransport', false, null, this.getTagsForStencil(gn, 'hcs mgw hybrid cloud storage datatransport data transport', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'hcs-sgw_hybrid_cloud_storage_gateway;',
				d * 1.7, d * 1.33, '', 'HCS-SGW Hybrid Cloud Storage Gateway', false, null, this.getTagsForStencil(gn, 'hcs sgw hybrid cloud storage gateway', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'hdr_hybrid_disaster_recovery;',
				d * 1.58, d * 1.58, '', 'HDR Hybrid Disaster Recovery', false, null, this.getTagsForStencil(gn, 'hdr hybrid disaster recovery', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'hologres;',
				d * 1.83, d * 1.67, '', 'Hologres', false, null, this.getTagsForStencil(gn, 'hologres', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'holowatcher;',
				d * 1.44, d * 1.67, '', 'HoloWatcher', false, null, this.getTagsForStencil(gn, 'holowatcher holo watcher', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'hsm_hardware_security_module;',
				d * 1.55, d * 1.65, '', 'HSM Hardware Security Module', false, null, this.getTagsForStencil(gn, 'hsm hardware security module', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'httpdns;',
				d * 1.67, d * 1.21, '', 'HTTPDNS', false, null, this.getTagsForStencil(gn, 'httpdns http dns domain name server', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'idrsservice;',
				d * 1.87, d * 1.87, '', 'IDRSService', false, null, this.getTagsForStencil(gn, 'idrsservice', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'image_recognition;',
				d * 1.63, d * 1.59, '', 'Image Recognition', false, null, this.getTagsForStencil(gn, 'image recognition', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'imagesearch;',
				d * 1.59, d * 1.59, '', 'ImageSearch', false, null, this.getTagsForStencil(gn, 'imagesearch image search', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'imarketing;',
				d * 1.44, d * 1.39, '', 'iMarketing', false, null, this.getTagsForStencil(gn, 'imarketing marketing', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'imm_intelligent_media_management;',
				d * 1.82, d * 1.82, '', 'IMM Intelligent Media Management', false, null, this.getTagsForStencil(gn, 'imm intelligent media management', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'imp_intelligent_media_production;',
				d * 1.76, d * 1.22, '', 'IMP Intelligent Media Production', false, null, this.getTagsForStencil(gn, 'imp intelligent media production', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'imp_low_code_video_factory;',
				d * 1.6, d * 1.62, '', 'IMP Low Code Video Factory', false, null, this.getTagsForStencil(gn, 'imp low code video factory', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'indvi_industrial_visual_intelligence;',
				d * 1.58, d * 1.58, '', 'IndVI Industrial Visual Intelligence', false, null, this.getTagsForStencil(gn, 'indvi industrial visual intelligence', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'intelligent_advisor;',
				d * 1.57, d * 1.83, '', 'Intelligent Advisor', false, null, this.getTagsForStencil(gn, 'intelligent advisor', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'iot_internet_of_things_platform;',
				d * 1.88, d * 1.85, '', 'IoT Internet of Things Platform', false, null, this.getTagsForStencil(gn, 'iot_internet_of_things_platform', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'iot_wireless_connection_service;',
				d * 1.41, d * 1.66, '', 'IoT Wireless Connection Service', false, null, this.getTagsForStencil(gn, 'iot wireless connection service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'iotid_identity;',
				d * 1.59, d * 1.59, '', 'IoTID Identity', false, null, this.getTagsForStencil(gn, 'iotid identity', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'iov_iot_vehicle_cloud;',
				d * 1.83, d * 1.1, '', 'IoV IoT Vehicle Cloud', false, null, this.getTagsForStencil(gn, 'iov iot vehicle cloud', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ipv6_gateway;',
				d * 1.73, d * 2, '', 'IPv6 Gateway', false, null, this.getTagsForStencil(gn, 'ipv6 gateway', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'isoc_iot_security_operations_center;',
				d * 1.65, d * 1.83, '', 'ISOC IoT Security Operations Center', false, null, this.getTagsForStencil(gn, 'isoc iot security operations center', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'isu_intelligent_semantic_understanding;',
				d * 1.58, d * 1.56, '', 'ISU Intelligent Semantic Understanding', false, null, this.getTagsForStencil(gn, 'isu intelligent semantic understanding', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ivision;',
				d * 1.84, d * 1.83, '', 'iVision', false, null, this.getTagsForStencil(gn, 'ivision vision', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ivpd_intelligent_visual_production;',
				d * 1.55, d * 1.55, '', 'iVPD Intelligent Visual Production', false, null, this.getTagsForStencil(gn, 'ivpd intelligent visual production', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'kafka;',
				d * 1.89, d * 1.4, '', 'Kafka', false, null, this.getTagsForStencil(gn, 'kafka', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'linkedmall;',
				d * 1.44, d * 1.4, '', 'LinkedMall', false, null, this.getTagsForStencil(gn, 'linkedmall linked mall', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'linkwan;',
				d * 1.75, d * 1.83, '', 'LinkWan', false, null, this.getTagsForStencil(gn, 'linkwan link wan', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'live;',
				d * 1.63, d * 1.49, '', 'Live', false, null, this.getTagsForStencil(gn, 'live', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'livinglink;',
				d * 1.46, d * 1.69, '', 'LivingLink', false, null, this.getTagsForStencil(gn, 'livinglink living link', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'log_streaming;',
				d * 1.58, d * 1.51, '', 'Log Streaming', false, null, this.getTagsForStencil(gn, 'log streaming', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'logic_composer;',
				d * 1.79, d * 1.78, '', 'Logic Composer', false, null, this.getTagsForStencil(gn, 'logic composer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'machine_learning;',
				d * 1.66, d * 1.67, '', 'Machine Learning', false, null, this.getTagsForStencil(gn, 'machine learning', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'man_mobile_analytics;',
				d * 1.67, d * 1.38, '', 'MAN Mobile Analytics', false, null, this.getTagsForStencil(gn, 'man mobile analytics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mariadb;',
				d * 1.7, d * 1.28, '', 'MariaDB', false, null, this.getTagsForStencil(gn, 'mariadb maria db database', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mas_mobile_acceleration_service;',
				d * 1.71, d * 1.26, '', 'MAS Mobile Acceleration Service', false, null, this.getTagsForStencil(gn, 'mas mobile acceleration service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'maxcompute;',
				d * 1.67, d * 1.67, '', 'MaxCompute', false, null, this.getTagsForStencil(gn, 'maxcompute max compute', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'memcache;',
				d * 1.67, d * 1.51, '', 'Memcache', false, null, this.getTagsForStencil(gn, 'memcache', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'miniappdev;',
				d * 1.64, d * 1.19, '', 'MiniAppDev', false, null, this.getTagsForStencil(gn, 'miniappdev mini app dev application developer development', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mns_message_service;',
				d * 1.33, d * 1.33, '', 'MNS Message Service', false, null, this.getTagsForStencil(gn, 'mns message service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mobile_hotfix;',
				d * 1.67, d * 1.67, '', 'Mobile Hotfix', false, null, this.getTagsForStencil(gn, 'mobile_hotfix', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mobsec;',
				d * 1.7, d * 1.44, '', 'MobSec', false, null, this.getTagsForStencil(gn, 'mobsec', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mongodb;',
				d * 1.58, d * 1.58, '', 'MongoDB', false, null, this.getTagsForStencil(gn, 'mongodb mongo db database', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mps_apsaravideo_media_processing;',
				d * 1.45, d * 1.73, '', 'MPS ApsaraVideo Media Processing', false, null, this.getTagsForStencil(gn, 'mps apsaravideo media processing apsara video', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mps-ai;',
				d * 1.74, d * 1.75, '', 'MPS-AI', false, null, this.getTagsForStencil(gn, 'mps ai artificial intelligence', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mps-censor;',
				d * 1.87, d * 1.83, '', 'MPS-Censor', false, null, this.getTagsForStencil(gn, 'mps censor', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mps-cover;',
				d * 1.87, d * 1.83, '', 'MPS-Cover', false, null, this.getTagsForStencil(gn, 'mps cover', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mps-dna;',
				d * 1.91, d * 1.86, '', 'MPS-DNA', false, null, this.getTagsForStencil(gn, 'mps dna', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mps-multimod;',
				d * 2.02, d * 1.83, '', 'MPS-Multimod', false, null, this.getTagsForStencil(gn, 'mps multimod', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mps-produce;',
				d * 2.02, d * 1.75, '', 'MPS-Produce', false, null, this.getTagsForStencil(gn, 'mps produce', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mq_message_queue;',
				d * 1.5, d * 1.66, '', 'MQ Message Queue', false, null, this.getTagsForStencil(gn, 'mq message queue', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mqc_mobile_quality_center;',
				d * 1.65, d * 1.65, '', 'MQC Mobile Quality Center', false, null, this.getTagsForStencil(gn, 'mqc mobile quality center', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mse_microservices_engine;',
				d * 1.83, d * 1.83, '', 'MSE Microservices Engine', false, null, this.getTagsForStencil(gn, 'mse Microservices engine', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'multi-cloud_finops;',
				d * 1.75, d * 1.25, '', 'Multi-Cloud FinOps', false, null, this.getTagsForStencil(gn, 'multi cloud finops fin ops operations', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'multi-mode_database_lindorm;',
				d * 1.58, d * 1.67, '', 'Multi-mode Database Lindorm', false, null, this.getTagsForStencil(gn, 'multi mode database lindorm', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'multimediaai;',
				d * 2, d * 1.97, '', 'MultiMediaAI', false, null, this.getTagsForStencil(gn, 'multimediai multi media multimedia ai artificial intelligence', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'mysql;',
				d * 1.61, d * 1.5, '', 'MySQL', false, null, this.getTagsForStencil(gn, 'mysql my sql', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nas_network_attached_storage;',
				d * 1., d * 1.0, '', 'NAS Network Attached Storage', false, null, this.getTagsForStencil(gn, 'nas network attached storage', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nat_gateway;',
				d * 1.72, d * 1.39, '', 'NAT Gateway', false, null, this.getTagsForStencil(gn, 'nat gateway', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'network_acl_access_control_list;',
				d * 1.58, d * 1.42, '', 'Network ACL Access Control List', false, null, this.getTagsForStencil(gn, 'network acl access control list', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlb_network_load_balancer_01;',
				d * 1.58, d * 1.34, '', 'NLB Network Load Balancer', false, null, this.getTagsForStencil(gn, 'nlb network load balancer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlb_network_load_balancer_02;',
				d * 2, d * 2, '', 'NLB Network Load Balancer', false, null, this.getTagsForStencil(gn, 'nlb network load balancer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp_natural_language_processing;',
				d * 1.67, d * 1.84, '', 'NLP Natural Language Processing', false, null, this.getTagsForStencil(gn, 'nlp natural language processing', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-address;',
				d * 1.58, d * 1.58, '', 'NLP-Address', false, null, this.getTagsForStencil(gn, 'nlp-address', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-automl;',
				d * 1.61, d * 1.57, '', 'NLP-AutoML', false, null, this.getTagsForStencil(gn, 'nlp-automl auto ml', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-ie_text_information_extraction;',
				d * 1.58, d * 1.58, '', 'NLP-IE Text Information Extraction', false, null, this.getTagsForStencil(gn, 'nlp ie text information extraction', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-ke_keyword_extraction;',
				d * 1.58, d * 1.58, '', 'NLP-KE Keyword Extraction', false, null, this.getTagsForStencil(gn, 'nlp ke keyword extraction', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-ner_named_entity_recognition;',
				d * 1.58, d * 1.58, '', 'NLP-NER Named Entity Recognition', false, null, this.getTagsForStencil(gn, 'nlp ner named entity recognition', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-pos_part-of-speech_tagging;',
				d * 1.58, d * 1.58, '', 'NLP-POS Part-of-Speech Tagging', false, null, this.getTagsForStencil(gn, 'nlp pos part of speech tagging', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-ra_reflexive_anaphora;',
				d * 1.58, d * 1.58, '', 'NLP-RA Reflexive Anaphora', false, null, this.getTagsForStencil(gn, 'nlp ra reflexive anaphora', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-sa_sentiment_analysis;',
				d * 1.58, d * 1.58, '', 'NLP-SA Sentiment Analysis', false, null, this.getTagsForStencil(gn, 'nlp sa sentiment analysis', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-tc_text_categorization;',
				d * 1.58, d * 1.58, '', 'NLP-TC Text Categorization', false, null, this.getTagsForStencil(gn, 'nlp tc text categorization', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nlp-ws_word_segmentation;',
				d * 1.58, d * 1.58, '', 'NLP-WS Word Segmentation', false, null, this.getTagsForStencil(gn, 'nlp ws word segmentation', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nls-asrbag;',
				d * 1.58, d * 1.58, '', 'NLS-ASRBag', false, null, this.getTagsForStencil(gn, 'nls asrbag asr bag', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nls-asrcustommodel;',
				d * 1.83, d * 1.83, '', 'NLS-ASRCustomModel', false, null, this.getTagsForStencil(gn, 'nls asrcustommodel asr custom model', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nls-filebag;',
				d * 1.58, d * 1.58, '', 'NLS-Filebag', false, null, this.getTagsForStencil(gn, 'nls filebag', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nls-service;',
				d * 1.57, d * 1.58, '', 'NLS-Service', false, null, this.getTagsForStencil(gn, 'nls service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nls-shortasrbag;',
				d * 1.58, d * 1.58, '', 'NLS-ShortASRBag', false, null, this.getTagsForStencil(gn, 'nls shortasrbag short asr bag', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nls-ttsbag;',
				d * 1.58, d * 1.58, '', 'NLS-TTSBag', false, null, this.getTagsForStencil(gn, 'nls ttsbag tts bag', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nls;',
				d * 1.83, d * 1.64, '', 'NLS', false, null, this.getTagsForStencil(gn, 'nls', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'nodejs_performance_platform;',
				d * 1.4, d * 1.58, '', 'Node.js Performance Platform', false, null, this.getTagsForStencil(gn, 'node.js nodejs node js performance platform', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'oceanbase;',
				d * 1.67, d * 1.47, '', 'OceanBase', false, null, this.getTagsForStencil(gn, 'oceanbase ocean base', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ocr_optical_character_recognition;',
				d * 2, d * 2.02, '', 'OCR Optical Character Recognition', false, null, this.getTagsForStencil(gn, 'ocr optical character recognition', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'onsmqtt_micro_message_queuing_telemetry_transport;',
				d * 1.83, d * 1.31, '', 'OnsMQTT Micro Message Queuing Telemetry Transport', false, null, this.getTagsForStencil(gn, 'onsmqtt micro message queuing telemetry transport', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'oos_operation_orchestration_service;',
				d * 1.66, d * 1.67, '', 'OOS Operation Orchestration Service', false, null, this.getTagsForStencil(gn, 'oos operation orchestration service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'openanalytics;',
				d * 1.83, d * 1.83, '', 'OpenAnalytics', false, null, this.getTagsForStencil(gn, 'openanalytics', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'openapi_explorer;',
				d * 1.58, d * 1.58, '', 'OpenAPI Explorer', false, null, this.getTagsForStencil(gn, 'openapi open api application programming interface explorer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'opensearch;',
				d * 2.01, d * 2, '', 'OpenSearch', false, null, this.getTagsForStencil(gn, 'opensearch open search', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'oss_object_storage_service;',
				d * 1.69, d * 1.29, '', 'OSS Object Storage Service', false, null, this.getTagsForStencil(gn, 'oss object storage service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ots_tablestore;',
				d * 1.77, d * 1.42, '', 'OTS Tablestore', false, null, this.getTagsForStencil(gn, 'ots tablestore table store', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'outboundbot;',
				d * 1.95, d * 1.95, '', 'OutboundBot', false, null, this.getTagsForStencil(gn, 'outboundbot outbound bot', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'pcdn_p2p_cdn;',
				d * 1.33, d * 1.55, '', 'PCDN P2P CDN', false, null, this.getTagsForStencil(gn, 'pcdn p2p cdn', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'petadata_hybriddb_for_mysql;',
				d * 1.89, d * 1.87, '', 'PetaData HybridDB for MySQL', false, null, this.getTagsForStencil(gn, 'petadata peta data hybriddb hybrid db database for mysql my sql', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'physical_connection;',
				d * 1.81, d * 1.35, '', 'Physical Connection', false, null, this.getTagsForStencil(gn, 'physical connection', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'pnvs_phone_number_verification_service;',
				d * 1.18, d * 1.67, '', 'PNVS Phone Number Verification Service', false, null, this.getTagsForStencil(gn, 'pnvs phone number verification service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'polardb;',
				d * 1.85, d * 1.91, '', 'PolarDB', false, null, this.getTagsForStencil(gn, 'polardb polar db database', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'porana_portrait_analysis;',
				d * 1.64, d * 1.51, '', 'Porana Portrait Analysis', false, null, this.getTagsForStencil(gn, 'porana portrait analysis', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'postgresql;',
				d * 1.6, d * 1.59, '', 'PostgreSQL', false, null, this.getTagsForStencil(gn, 'postgre sql postgresql', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ppas_pay-as-you-go_database;',
				d * 1.33, d * 1.82, '', 'PPAS Pay-As-You-Go Database', false, null, this.getTagsForStencil(gn, 'ppas pay as you go database db', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'privatelink;',
				d * 1.87, d * 1.89, '', 'PrivateLink', false, null, this.getTagsForStencil(gn, 'privatelink private link', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'prometheus;',
				d * 1.63, d * 1.63, '', 'Prometheus', false, null, this.getTagsForStencil(gn, 'prometheus', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'prophet;',
				d * 1.56, d * 1.59, '', 'Prophet', false, null, this.getTagsForStencil(gn, 'prophet', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'pts_performance_test_service;',
				d * 1.66, d * 1.37, '', 'PTS Performance Test Service', false, null, this.getTagsForStencil(gn, 'pts performance test service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'quickbi;',
				d * 1.59, d * 1.6, '', 'QuickBI', false, null, this.getTagsForStencil(gn, 'quick bi quickbi', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ram_resource_access_management;',
				d * 1.84, d * 1.2, '', 'RAM Resource Access Management', false, null, this.getTagsForStencil(gn, 'ram resource access management', dt).join(' ')),
			this.createVertexTemplateEntry(s + 're_recommendation_engine;',
				d * 1.65, d * 1.61, '', 'RE Recommendation Engine', false, null, this.getTagsForStencil(gn, 're recommendation engine', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'realtime_compute;',
				d * 2, d * 2, '', 'Realtime Compute', false, null, this.getTagsForStencil(gn, 'realtime compute', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'redis_kvstore;',
				d * 1.75, d * 1.38, '', 'Redis KVStore', false, null, this.getTagsForStencil(gn, 'redis kvstore', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'region;',
				d * 1.58, d * 1.81, '', 'Region', false, null, this.getTagsForStencil(gn, 'region', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'retailir;',
				d * 1.58, d * 1.58, '', 'RetailIR', false, null, this.getTagsForStencil(gn, 'retailir retail ir', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'ros_resource_orchestration_service;',
				d * 1.67, d * 1.45, '', 'ROS Resource Orchestration Service', false, null, this.getTagsForStencil(gn, 'ros resource orchestration service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'route_table;',
				d * 1.25, d * 1.58, '', 'Route Table', false, null, this.getTagsForStencil(gn, 'route table', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'router;',
				d * 1.84, d * 1.92, '', 'Router', false, null, this.getTagsForStencil(gn, 'router', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'rsimganalys;',
				d * 1.67, d * 1.48, '', 'RSImgAnalys', false, null, this.getTagsForStencil(gn, 'rsimganalys rs img analysis', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'rtc_real-time_communication;',
				d * 1.75, d * 1.76, '', 'RTC Real-Time Communication', false, null, this.getTagsForStencil(gn, 'rtc real time communication', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sae_serverless_app_engine;',
				d * 1.62, d * 1.83, '', 'SAE Serverless App Engine', false, null, this.getTagsForStencil(gn, 'sae serverless app engine', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sag_smart_access_gateway_01;',
				d * 1.58, d * 1.25, '', 'SAG Smart Access Gateway', false, null, this.getTagsForStencil(gn, 'sag smart access gateway', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sag_smart_access_gateway_02;',
				d * 1.67, d * 1.38, '', 'SAG Smart Access Gateway', false, null, this.getTagsForStencil(gn, 'sag smart access gateway', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sas_situational_awareness;',
				d * 1.55, d * 1.64, '', 'SAS Situational Awareness', false, null, this.getTagsForStencil(gn, 'sas situational awareness', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sca_smart_conversation_analysis_01;',
				d * 1.58, d * 1.58, '', 'SCA Smart Conversation Analysis', false, null, this.getTagsForStencil(gn, 'sca smart conversation analysis', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sca_smart_conversation_analysis_02;',
				d * 1.86, d * 1.87, '', 'SCA Smart Conversation Analysis', false, null, this.getTagsForStencil(gn, 'sca smart conversation analysis', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'scc_super_computing_cluster;',
				d * 1.62, d * 1.78, '', 'SCC Super Computing Cluster', false, null, this.getTagsForStencil(gn, 'scc super computing cluster', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'scdn_secure_cdn;',
				d * 1.92, d * 1.98, '', 'SCDN Secure CDN', false, null, this.getTagsForStencil(gn, 'scdn secure cdn', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'scu_storage_capacity_unit;',
				d * 1.7, d * 1.83, '', 'SCU Storage Capacity Unit', false, null, this.getTagsForStencil(gn, 'scu storage capacity unit', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sddp_sensitive_data_protection;',
				d * 1.63, d * 1.93, '', 'SDDP Sensitive Data Protection', false, null, this.getTagsForStencil(gn, 'sddp sensitive data protection', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'shared_bandwidth;',
				d * 1.67, d * 1.67, '', 'Shared Bandwidth', false, null, this.getTagsForStencil(gn, 'shared bandwidth', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'shared_flow_bag;',
				d * 1.83, d * 1.17, '', 'Shared Flow Bag', false, null, this.getTagsForStencil(gn, 'shared flow bag', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'shc_shield_hybrid_cloud;',
				d * 1.64, d * 1.51, '', 'SHC Shield Hybrid Cloud', false, null, this.getTagsForStencil(gn, 'shc shield hybrid cloud', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'slb_server_load_balancer_01;',
				d * 1.58, d * 1.34, '', 'SLB Server Load Balancer', false, null, this.getTagsForStencil(gn, 'slb server load balancer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'slb_server_load_balancer_02;',
				d * 2, d * 2, '', 'SLB Server Load Balancer', false, null, this.getTagsForStencil(gn, 'slb server load balancer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'slb_server_load_balancer_03;',
				d * 1.67, d * 1.42, '', 'SLB Server Load Balancer', false, null, this.getTagsForStencil(gn, 'slb server load balancer', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sls_simple_log_service;',
				d * 1.6, d * 1.6, '', 'SLS Simple Log Service', false, null, this.getTagsForStencil(gn, 'sls simple log service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'smc_server_migration_center;',
				d * 1.83, d * 1.83, '', 'SMC Server Migration Center', false, null, this.getTagsForStencil(gn, 'smc server migration center', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sms_short_message_service;',
				d * 1.66, d * 1.52, '', 'SMS Short Message Service', false, null, this.getTagsForStencil(gn, 'sms short message service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sos;',
				d * 1.55, d * 1.58, '', 'SOS', false, null, this.getTagsForStencil(gn, 'sos', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'spark_data_insights;',
				d * 1.54, d * 1.67, '', 'Spark Data Insights', false, null, this.getTagsForStencil(gn, 'spark data insights', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sppc;',
				d * 1.68, d * 1.47, '', 'SPPC', false, null, this.getTagsForStencil(gn, 'sppc', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'sqlserver;',
				d * 1.32, d * 1.83, '', 'SQLServer', false, null, this.getTagsForStencil(gn, 'sqlserver sql server', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'swas_simple_application_server;',
				d * 2, d * 2, '', 'SWAS Simple Application Server', false, null, this.getTagsForStencil(gn, 'swas simple application server', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'tr_transit_router;',
				d * 1.75, d * 1.75, '', 'TR Transit Router', false, null, this.getTagsForStencil(gn, 'tr transit router', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'trademark_service;',
				d * 1.58, d * 1.77, '', 'Trademark Service', false, null, this.getTagsForStencil(gn, 'trademark service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'uis_ultimate_internet_service;',
				d * 1.83, d * 1.8, '', 'UIS Ultimate Internet Service', false, null, this.getTagsForStencil(gn, 'uis ultimate internet service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'user_feedback_01;',
				d * 1.58, d * 1.58, '', 'User Feedback', false, null, this.getTagsForStencil(gn, 'user feedback', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'user_feedback_02;',
				d * 1.44, d * 1.67, '', 'User Feedback', false, null, this.getTagsForStencil(gn, 'user feedback', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'user;',
				d * 2, d * 2, '', 'User', false, null, this.getTagsForStencil(gn, 'user', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'vbr_virtual_border_router;',
				d * 1.92, d * 1.92, '', 'VBR Virtual Border Router', false, null, this.getTagsForStencil(gn, 'vbr virtual border router', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'vcs_visual_computing_service;',
				d * 1.71, d * 1.75, '', 'VCS Visual Computing Service', false, null, this.getTagsForStencil(gn, 'vcs visual computing service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'vms_voice_messaging_service;',
				d * 1.58, d * 1.52, '', 'VMS Voice Messaging Service', false, null, this.getTagsForStencil(gn, 'vms voice messaging service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'voicebot_intelligent_voice_navigation;',
				d * 1.96, d * 1.9, '', 'VoiceBot Intelligent Voice Navigation', false, null, this.getTagsForStencil(gn, 'voicebot intelligent voice navigation', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'vpc_virtual_private_cloud;',
				d * 1.9, d * 1.22, '', 'VPC Virtual Private Cloud', false, null, this.getTagsForStencil(gn, 'vpc virtual private cloud', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'vpn_gateway;',
				d * 1.83, d * 1.83, '', 'VPN Gateway', false, null, this.getTagsForStencil(gn, 'vpn gateway virtual private network', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'vs_video_surveillance;',
				d * 1.83, d * 1.83, '', 'VS Video Surveillance', false, null, this.getTagsForStencil(gn, 'vs video surveillance', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'vswitch;',
				d * 1.75, d * 1.25, '', 'vSwitch', false, null, this.getTagsForStencil(gn, 'vswitch switch', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'waf_web_application_firewall;',
				d * 1.64, d * 1.44, '', 'WAF Web Application Firewall', false, null, this.getTagsForStencil(gn, 'waf web application firewall', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'webplus_web_app_service;',
				d * 1.83, d * 1.83, '', 'Web+ Web App Service', false, null, this.getTagsForStencil(gn, 'webplus web app service', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'xdragon_bare_metal_server;',
				d * 1.64, d * 1.59, '', 'XDragon Bare Metal Server', false, null, this.getTagsForStencil(gn, 'xdragon bare metal server', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'xtrace;',
				d * 1.38, d * 1.67, '', 'XTrace', false, null, this.getTagsForStencil(gn, 'xtrace', dt).join(' ')),
			this.createVertexTemplateEntry(s + 'yida;',
				d * 1.58, d * 1.58, '', 'Yida', false, null, this.getTagsForStencil(gn, 'yida', dt).join(' '))
		];
			   	
   		this.addPalette('alibaba_cloud', 'Alibaba Cloud', false, mxUtils.bind(this, function(content)
	    {
			for (var i = 0; i < fns.length; i++)
			{
				content.appendChild(fns[i](content));
			}
		}));
	};
	
})();
