/**
 * Copyright (c) 2020-2025, JGraph Holdings Ltd
 * Copyright (c) 2020-2025, draw.io AG
 */
(function()
{
	// Adds Web Icons shapes
	Sidebar.prototype.addWebIconsPalette = function()
	{
		var sb = this;
		var s = 'dashed=0;outlineConnect=0;html=1;align=center;labelPosition=center;verticalLabelPosition=bottom;verticalAlign=top;' + mxConstants.STYLE_SHAPE + "=mxgraph.webicons.";
		var gn = 'mxgraph.webicons';
		var dt = 'web icons icon';
		var w = 0.2;
		var h = 0.2;
		this.setCurrentSearchEntryLibrary('webicons', 'webicons');
		
		this.addPaletteFunctions('webicons', 'Web Icons', false,
		[
		 this.createVertexTemplateEntry(s + 'adfty;fillColor=#66E8F3;gradientColor=#1C7CBA',
				 w * 512, h * 512, '', 'Adfty', null, null, this.getTagsForStencil(gn, 'adfty', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'adobe_pdf;fillColor=#F40C0C;gradientColor=#610603',
				 w * 512, h * 512, '', 'Adobe PDF', null, null, this.getTagsForStencil(gn, 'adobe pdf', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'aim;fillColor=#27E1E5;gradientColor=#0A4361',
				 w * 512, h * 512, '', 'Aim', null, null, this.getTagsForStencil(gn, 'aim', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'allvoices;fillColor=#807E7E;gradientColor=#1B1C1C',
				 w * 512, h * 512, '', 'Allvoices', null, null, this.getTagsForStencil(gn, 'allvoices', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'amazon;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Amazon', null, null, this.getTagsForStencil(gn, 'amazon', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'amazon_2;gradientColor=#231F20',
				 w * 512, h * 512, '', 'Amazon', null, null, this.getTagsForStencil(gn, 'amazon', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'android;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Android', null, null, this.getTagsForStencil(gn, 'android', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'apache;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Apache', null, null, this.getTagsForStencil(gn, 'apache db database', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'apple;fillColor=#807E7E;gradientColor=#1B1C1C',
				 w * 512, h * 512, '', 'Apple', null, null, this.getTagsForStencil(gn, 'apple', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'apple_classic;fillColor=#66E8F3;gradientColor=#1C7CBA',
				 w * 512, h * 512, '', 'Apple (classic)', null, null, this.getTagsForStencil(gn, 'apple classic', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'arduino;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Arduino', null, null, this.getTagsForStencil(gn, 'arduino', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'ask;fillColor=#F33543;gradientColor=#B50E11',
				 w * 512, h * 512, '', 'Ask', null, null, this.getTagsForStencil(gn, 'ask', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'atlassian;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Atlassian', null, null, this.getTagsForStencil(gn, 'atlassian', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'audioboo;fillColor=#EB35CF;gradientColor=#8C0E35',
				 w * 512, h * 512, '', 'Audioboo', null, null, this.getTagsForStencil(gn, 'audioboo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'aws;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'AWS', null, null, this.getTagsForStencil(gn, 'aws amazon web service', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'aws_s3;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'AWS S3', null, null, this.getTagsForStencil(gn, 'aws s3 amazon web service', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'baidu;fillColor=#738FE8;gradientColor=#1F2470',
				 w * 512, h * 512, '', 'Baidu', null, null, this.getTagsForStencil(gn, 'baidu', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'bebo;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Bebo', null, null, this.getTagsForStencil(gn, 'bebo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'behance;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Behance', null, null, this.getTagsForStencil(gn, 'behance', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'bing;fillColor=#0A776E;gradientColor=#053D39',
				 w * 512, h * 512, '', 'Bing', null, null, this.getTagsForStencil(gn, 'bing', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'bitbucket;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Bitbucket', null, null, this.getTagsForStencil(gn, 'bitbucket', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'blinklist;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Blinklist', null, null, this.getTagsForStencil(gn, 'blinklist', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'blogger;fillColor=#FDE47C;gradientColor=#F55F21',
				 w * 512, h * 512, '', 'Blogger', null, null, this.getTagsForStencil(gn, 'blogger', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'blogmarks;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Blogmarks', null, null, this.getTagsForStencil(gn, 'blogmarks', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'bookmarks.fr;fillColor=#F9FAF4;gradientColor=#DCDFBB',
				 w * 512, h * 512, '', 'Bookmarks.fr', null, null, this.getTagsForStencil(gn, 'bookmarks.fr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'box;fillColor=#4CDFEF;gradientColor=#153EA0',
				 w * 512, h * 512, '', 'Box', null, null, this.getTagsForStencil(gn, 'box', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'buddymarks;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Buddymarks', null, null, this.getTagsForStencil(gn, 'buddymarks', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'buffer;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Buffer', null, null, this.getTagsForStencil(gn, 'buffer', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'buzzfeed;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Buzzfeed', null, null, this.getTagsForStencil(gn, 'buzzfeed', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'chrome;gradientColor=#DFDEDE',
				 w * 516, h * 520, '', 'Chrome', null, null, this.getTagsForStencil(gn, 'chrome', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'citeulike;fillColor=#ACD65E;gradientColor=#2E3618',
				 w * 512, h * 512, '', 'Citeulike', null, null, this.getTagsForStencil(gn, 'citeulike', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'confluence;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Confluence', null, null, this.getTagsForStencil(gn, 'confluence', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'connotea;fillColor=#E9FDFC;gradientColor=#BADBE9',
				 w * 512, h * 512, '', 'Connotea', null, null, this.getTagsForStencil(gn, 'connotea', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dealsplus;fillColor=#B569B5;gradientColor=#7A467A',
				 w * 512, h * 512, '', 'Dealsplus', null, null, this.getTagsForStencil(gn, 'dealsplus', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'delicious',
				 w * 512, h * 512, '', 'Delicious', null, null, this.getTagsForStencil(gn, 'delicious', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'designfloat;fillColor=#247BE0;gradientColor=#0A1F42',
				 w * 512, h * 512, '', 'Designfloat', null, null, this.getTagsForStencil(gn, 'designfloat', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'deviantart;fillColor=#00C659;gradientColor=#00813B',
				 w * 512, h * 512, '', 'Deviantart', null, null, this.getTagsForStencil(gn, 'deviantart', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'digg;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Digg', null, null, this.getTagsForStencil(gn, 'digg', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'diigo;fillColor=#2C7DE0;gradientColor=#1E5599',
				 w * 512, h * 512, '', 'Diigo', null, null, this.getTagsForStencil(gn, 'diiigo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dopplr;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Dopplr', null, null, this.getTagsForStencil(gn, 'dopplr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'drawio2;fillColor=#2174CE;gradientColor=#134277',
				 w * 512, h * 512, '', 'draw.io', null, null, this.getTagsForStencil(gn, 'diagrams.net drawio draw io draw.io', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dribbble;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Dribbble', null, null, this.getTagsForStencil(gn, 'dribbble', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dropbox;fillColor=#0BAAFE;gradientColor=#0080E6',
				 w * 512, h * 512, '', 'Dropbox', null, null, this.getTagsForStencil(gn, 'dropbox', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dropbox2;fillColor=#2FB8FC;gradientColor=#0080E6',
				 w * 512, h * 512, '', 'Dropbox', null, null, this.getTagsForStencil(gn, 'dropbox', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'drupal;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Drupal', null, null, this.getTagsForStencil(gn, 'drupal', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dzone;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Dzone', null, null, this.getTagsForStencil(gn, 'dzone', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'ebay;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Ebay', null, null, this.getTagsForStencil(gn, 'ebay', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'edmodo;fillColor=#2F81CE;gradientColor=#1F5487',
				 w * 512, h * 512, '', 'Edmodo', null, null, this.getTagsForStencil(gn, 'edmodo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'evernote;fillColor=#D4EF75;gradientColor=#399F1F',
				 w * 512, h * 512, '', 'Evernote', null, null, this.getTagsForStencil(gn, 'evernote', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'facebook;fillColor=#6294E4;gradientColor=#1A2665',
				 w * 512, h * 512, '', 'Facebook', null, null, this.getTagsForStencil(gn, 'facebook', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fancy;fillColor=#C3ECF8;gradientColor=#348DD4',
				 w * 512, h * 512, '', 'Fancy', null, null, this.getTagsForStencil(gn, 'fancy', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fark;fillColor=#EBEBF1;gradientColor=#8482A7',
				 w * 512, h * 512, '', 'Fark', null, null, this.getTagsForStencil(gn, 'fark', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fashiolista;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Fashiolista', null, null, this.getTagsForStencil(gn, 'fashiolista', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'feed;fillColor=#FFAC75;gradientColor=#FF6600',
				 w * 512, h * 512, '', 'Feed', null, null, this.getTagsForStencil(gn, 'feed', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'feedburner;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Feedburner', null, null, this.getTagsForStencil(gn, 'feedburner', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'flickr;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Flickr', null, null, this.getTagsForStencil(gn, 'flickr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'folkd;fillColor=#27A2E9;gradientColor=#0A2977',
				 w * 512, h * 512, '', 'Folkd', null, null, this.getTagsForStencil(gn, 'folkd', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'forrst;fillColor=#3E6B32;gradientColor=#111C0D',
				 w * 512, h * 512, '', 'Forrst', null, null, this.getTagsForStencil(gn, 'forrst', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fotolog;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Fotolog', null, null, this.getTagsForStencil(gn, 'fotolog', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'freshbump;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Freshbump', null, null, this.getTagsForStencil(gn, 'freshbump', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fresqui;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Fresqui', null, null, this.getTagsForStencil(gn, 'fresqui', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'friendfeed;fillColor=#7BDCEF;gradientColor=#21379E',
				 w * 512, h * 512, '', 'Friendfeed', null, null, this.getTagsForStencil(gn, 'fiendfeed', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'funp;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Funp', null, null, this.getTagsForStencil(gn, 'funp', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fwisp;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Fwisp', null, null, this.getTagsForStencil(gn, 'fwisp', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'gabbr;fillColor=#FBAC39;gradientColor=#EA2B0E',
				 w * 512, h * 512, '', 'Gabbr', null, null, this.getTagsForStencil(gn, 'gabbr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'gamespot;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Gamespot', null, null, this.getTagsForStencil(gn, 'gamespot', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'github;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Github', null, null, this.getTagsForStencil(gn, 'github', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'gmail;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Gmail', null, null, this.getTagsForStencil(gn, 'gmail', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Google', null, null, this.getTagsForStencil(gn, 'google', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_drive;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Google Drive', null, null, this.getTagsForStencil(gn, 'google drive', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_hangout;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Google Hangout', null, null, this.getTagsForStencil(gn, 'google hangout', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_play;fillColor=#000000',
				 w * 347, h * 103, '', 'Google Play', null, null, this.getTagsForStencil(gn, 'google play', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_play_light;fillColor=#66E8F3;gradientColor=#1C7CBA',
				 w * 300, h * 52, '', 'Google Play Light', null, null, this.getTagsForStencil(gn, 'google play light', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_photos;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Google Photos', null, null, this.getTagsForStencil(gn, 'google photos', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_plus;fillColor=#F24B46;gradientColor=#AD3832',
				 w * 512, h * 512, '', 'Google Plus', null, null, this.getTagsForStencil(gn, 'google plus', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'grooveshark;fillColor=#695D5D;gradientColor=#000000',
				 w * 512, h * 512, '', 'Grooveshark', null, null, this.getTagsForStencil(gn, 'grooveshark', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'hatena;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Hatena', null, null, this.getTagsForStencil(gn, 'hatena', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'html5;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'HTML5', null, null, this.getTagsForStencil(gn, 'html5 html', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'identi.ca;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Identi.ca', null, null, this.getTagsForStencil(gn, 'identi.ca', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'instagram;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Instagram', null, null, this.getTagsForStencil(gn, 'instagram', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'instapaper;fillColor=#807E7E;gradientColor=#1B1C1C',
				 w * 512, h * 512, '', 'Instapaper', null, null, this.getTagsForStencil(gn, 'instapaper', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'ios;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'iOS', null, null, this.getTagsForStencil(gn, 'ios', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'jamespot;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Jamespot', null, null, this.getTagsForStencil(gn, 'jamespot', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'java;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Java', null, null, this.getTagsForStencil(gn, 'java', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'joomla;fillColor=#1F457D;gradientColor=#081220',
				 w * 512, h * 512, '', 'Joomla', null, null, this.getTagsForStencil(gn, 'joomla', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'jquery;fillColor=#0BB9EA;gradientColor=#032F80',
				 w * 512, h * 512, '', 'Jquery', null, null, this.getTagsForStencil(gn, 'jquery', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'json;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'JSON', null, null, this.getTagsForStencil(gn, 'json', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'json_2;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'JSON', null, null, this.getTagsForStencil(gn, 'json', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'last.fm;fillColor=#F33543;gradientColor=#BD0E11',
				 w * 512, h * 512, '', 'Last.fm', null, null, this.getTagsForStencil(gn, 'last.fm last fm', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'linkagogo;fillColor=#F6F5FA;gradientColor=#C8C1E1',
				 w * 512, h * 512, '', 'Linkagogo', null, null, this.getTagsForStencil(gn, 'linkagogo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'linkedin;fillColor=#0095DB;gradientColor=#006391',
				 w * 512, h * 512, '', 'LinkedIn', null, null, this.getTagsForStencil(gn, 'linkedin', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'livejournal;fillColor=#2690E5;gradientColor=#0A2463',
				 w * 512, h * 512, '', 'Livejournal', null, null, this.getTagsForStencil(gn, 'livejournal', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'mail.ru;fillColor=#267BE0;gradientColor=#0A1F42',
				 w * 512, h * 512, '', 'Mail.ru', null, null, this.getTagsForStencil(gn, 'mail.ru', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'meetup;fillColor=#F83263;gradientColor=#D40D19',
				 w * 512, h * 512, '', 'Meetup', null, null, this.getTagsForStencil(gn, 'meetup', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'meneame;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Meneame', null, null, this.getTagsForStencil(gn, 'meneame', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'messenger;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Messenger', null, null, this.getTagsForStencil(gn, 'messenger', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'messenger_2;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Messenger', null, null, this.getTagsForStencil(gn, 'messenger', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'messenger_3;fillColor=#09BEFC;gradientColor=#0060FA',
				 w * 512, h * 512, '', 'Messenger', null, null, this.getTagsForStencil(gn, 'messenger', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'mind_body_green;fillColor=#E0EEF8;gradientColor=#4496D5',
				 w * 512, h * 512, '', 'Mind Body Green', null, null, this.getTagsForStencil(gn, 'mind body green', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'mongodb;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'MongoDb', null, null, this.getTagsForStencil(gn, 'mongodb', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'myspace;fillColor=#3C69E2;gradientColor=#101B54',
				 w * 512, h * 512, '', 'MySpace', null, null, this.getTagsForStencil(gn, 'myspace', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'n4g;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'N4g', null, null, this.getTagsForStencil(gn, 'n4g', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'netlog;fillColor=#FA3743;gradientColor=#E10E11',
				 w * 512, h * 512, '', 'Netlog', null, null, this.getTagsForStencil(gn, 'netlog', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'netvibes;fillColor=#99DB00;gradientColor=#638E00',
				 w * 512, h * 512, '', 'Netvibes', null, null, this.getTagsForStencil(gn, 'netvibes', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'netvouz;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Netvouz', null, null, this.getTagsForStencil(gn, 'netvouz', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'networkedblogs;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Networkedblogs', null, null, this.getTagsForStencil(gn, 'networkedblogs', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'newsvine;fillColor=#008733;gradientColor=#00441B',
				 w * 512, h * 512, '', 'Newsvine', null, null, this.getTagsForStencil(gn, 'newsvine', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'odnoklassniki;fillColor=#FDE15A;gradientColor=#F24317',
				 w * 512, h * 512, '', 'Odnoklassniki', null, null, this.getTagsForStencil(gn, 'odnoklassniki', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'oknotizie;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Oknotizie', null, null, this.getTagsForStencil(gn, 'oknotizie', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'onedrive;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'OneDrive', null, null, this.getTagsForStencil(gn, 'onedrive', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'oracle;fillColor=#FA3743;gradientColor=#E10E11',
				 w * 512, h * 512, '', 'Oracle', null, null, this.getTagsForStencil(gn, 'oracle', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'paypal;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Paypal', null, null, this.getTagsForStencil(gn, 'paypal', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'phone;fillColor=#76F21E;gradientColor=#079704',
				 w * 512, h * 512, '', 'Phone', null, null, this.getTagsForStencil(gn, 'phone', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'phonefavs;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Phonefavs', null, null, this.getTagsForStencil(gn, 'phonefavs', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'pinterest;fillColor=#E50B28;gradientColor=#890616',
				 w * 512, h * 512, '', 'Pinterest', null, null, this.getTagsForStencil(gn, 'pinterest', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'plaxo;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Plaxo', null, null, this.getTagsForStencil(gn, 'plaxo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'playfire;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Playfire', null, null, this.getTagsForStencil(gn, 'playfire', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'plurk;fillColor=#FF5656;gradientColor=#A8312D',
				 w * 512, h * 512, '', 'Plurk', null, null, this.getTagsForStencil(gn, 'plurk', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'pocket;fillColor=#FF4460;gradientColor=#B73143',
				 w * 512, h * 512, '', 'Pocket', null, null, this.getTagsForStencil(gn, 'pocket', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'protopage;fillColor=#4B78C0;gradientColor=#294282',
				 w * 512, h * 512, '', 'Protopage', null, null, this.getTagsForStencil(gn, 'protopage', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'readernaut;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Readernaut', null, null, this.getTagsForStencil(gn, 'readernaut', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'reddit;fillColor=#F3F8FC;gradientColor=#B4D2F0',
				 w * 512, h * 512, '', 'Reddit', null, null, this.getTagsForStencil(gn, 'reddit', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'rss;fillColor=#FDE532;gradientColor=#F4600D',
				 w * 512, h * 512, '', 'RSS', null, null, this.getTagsForStencil(gn, 'rss', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'scoopit;fillColor=#8CD845;gradientColor=#4E7A27',
				 w * 512, h * 512, '', 'Scoopit', null, null, this.getTagsForStencil(gn, 'scoopit', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'scribd;fillColor=#1D637D;gradientColor=#071920',
				 w * 512, h * 512, '', 'Scribd', null, null, this.getTagsForStencil(gn, 'scribd', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'segnalo;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Segnalo', null, null, this.getTagsForStencil(gn, 'segnalo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sina;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Sina', null, null, this.getTagsForStencil(gn, 'sina', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sitejot;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Sitejot', null, null, this.getTagsForStencil(gn, 'sitejot', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'skype;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Skype', null, null, this.getTagsForStencil(gn, 'skype', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'skyrock;fillColor=#47B8FF;gradientColor=#006AAD',
				 w * 512, h * 512, '', 'Skyrock', null, null, this.getTagsForStencil(gn, 'skyrock', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'slashdot;fillColor=#03B2AC;gradientColor=#012C2C',
				 w * 512, h * 512, '', 'Slashdot', null, null, this.getTagsForStencil(gn, 'slashdot', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sms;fillColor=#86D466;gradientColor=#42B418',
				 w * 512, h * 512, '', 'SMS', null, null, this.getTagsForStencil(gn, 'sms', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'socialvibe;fillColor=#FA16E2;gradientColor=#DF064B',
				 w * 512, h * 512, '', 'Socialvibe', null, null, this.getTagsForStencil(gn, 'socialvibe', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'society6;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Society6', null, null, this.getTagsForStencil(gn, 'society6', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sonico;fillColor=#3FEAF6;gradientColor=#117EC9',
				 w * 512, h * 512, '', 'Sonico', null, null, this.getTagsForStencil(gn, 'sonico', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'soundcloud;fillColor=#F78E11;gradientColor=#F93A0E',
				 w * 512, h * 512, '', 'Soundcloud', null, null, this.getTagsForStencil(gn, 'soundcloud', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sourceforge;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Sourceforge', null, null, this.getTagsForStencil(gn, 'sourceforge', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sourceforge_2;fillColor=#0078AF;gradientColor=#00385E',
				 w * 512, h * 512, '', 'Sourceforge', null, null, this.getTagsForStencil(gn, 'sourceforge', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'spring.me;fillColor=#3CBEF2;gradientColor=#2B8AAF',
				 w * 512, h * 512, '', 'Spring.me', null, null, this.getTagsForStencil(gn, 'spring me', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'stackexchange;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Stackexchange', null, null, this.getTagsForStencil(gn, 'stackexchange stack exchange', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'stackoverflow;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'StackOverflow', null, null, this.getTagsForStencil(gn, 'stackoverflow stack overflow', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'startaid;fillColor=#47B0E5;gradientColor=#2F7599',
				 w * 512, h * 512, '', 'Startaid', null, null, this.getTagsForStencil(gn, 'startaid', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'startlap;fillColor=#B9E6F0;gradientColor=#3062A2',
				 w * 512, h * 512, '', 'Startlap', null, null, this.getTagsForStencil(gn, 'startlap', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'steam;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 512, h * 512, '', 'Steam', null, null, this.getTagsForStencil(gn, 'steam', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'stumbleupon;fillColor=#FA823C;gradientColor=#E12110',
				 w * 512, h * 512, '', 'StumbleUpon', null, null, this.getTagsForStencil(gn, 'stumbleupon', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'stumpedia;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Stumpedia', null, null, this.getTagsForStencil(gn, 'stumpedia', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'technorati;fillColor=#99EC92;gradientColor=#288925',
				 w * 512, h * 512, '', 'Technorati', null, null, this.getTagsForStencil(gn, 'technorati', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'translate;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Translate', null, null, this.getTagsForStencil(gn, 'translate', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'tumblr;fillColor=#588BBC;gradientColor=#172330',
				 w * 512, h * 512, '', 'Tumblr', null, null, this.getTagsForStencil(gn, 'tumblr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'tunein;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Tunein', null, null, this.getTagsForStencil(gn, 'tunein', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'twitter;fillColor=#49EAF7;gradientColor=#137BD0',
				 w * 512, h * 512, '', 'Twitter', null, null, this.getTagsForStencil(gn, 'twitter', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'two;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Two', null, null, this.getTagsForStencil(gn, 'two', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'typepad;fillColor=#CBD372;gradientColor=#818748',
				 w * 512, h * 512, '', 'Typepad', null, null, this.getTagsForStencil(gn, 'typepad', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'viadeo;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Viadeo', null, null, this.getTagsForStencil(gn, 'viadeo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'viber;fillColor=#9964C4;gradientColor=#52366B',
				 w * 512, h * 512, '', 'Viber', null, null, this.getTagsForStencil(gn, 'viber', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'viddler;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Viddler', null, null, this.getTagsForStencil(gn, 'viddler', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'vimeo;fillColor=#A4EDF9;gradientColor=#2B8ED9',
				 w * 512, h * 512, '', 'Vimeo', null, null, this.getTagsForStencil(gn, 'vimeo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'virb;fillColor=#536873;gradientColor=#161A1D',
				 w * 512, h * 512, '', 'Virb', null, null, this.getTagsForStencil(gn, 'virb', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'vkontakte;fillColor=#5F94CC;gradientColor=#39587A',
				 w * 512, h * 512, '', 'Vkontakte', null, null, this.getTagsForStencil(gn, 'vkontakte', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'wakoopa;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Wakoopa', null, null, this.getTagsForStencil(gn, 'wakoopa', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'weheartit;fillColor=#FF7AA2;gradientColor=#FF4577',
				 w * 512, h * 512, '', 'Weheartit', null, null, this.getTagsForStencil(gn, 'weheartit', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'whatsapp;fillColor=#4FE238;gradientColor=#138709',
				 w * 512, h * 512, '', 'Whatsapp', null, null, this.getTagsForStencil(gn, 'whatsapp', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'wix;fillColor=#8AE3F2;gradientColor=#2451B0',
				 w * 512, h * 512, '', 'Wix', null, null, this.getTagsForStencil(gn, 'wix', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'wordpress;fillColor=#35E2EE;gradientColor=#0E4D99',
				 w * 512, h * 512, '', 'Wordpress', null, null, this.getTagsForStencil(gn, 'wordpress', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'wordpress_2;fillColor=#35E2EE;gradientColor=#0E4D99',
				 w * 512, h * 512, '', 'Wordpress', null, null, this.getTagsForStencil(gn, 'wordpress', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'xanga;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Xanga', null, null, this.getTagsForStencil(gn, 'xanga', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'xerpi;fillColor=#7F719B;gradientColor=#32264B',
				 w * 512, h * 512, '', 'Xerpi', null, null, this.getTagsForStencil(gn, 'xerpi', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'xing;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Xing', null, null, this.getTagsForStencil(gn, 'xing', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yahoo;fillColor=#AC37AE;gradientColor=#2E0E2D',
				 w * 512, h * 512, '', 'Yahoo', null, null, this.getTagsForStencil(gn, 'yahoo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yahoo_2;fillColor=#AC37AE;gradientColor=#2E0E2D',
				 w * 512, h * 512, '', 'Yahoo', null, null, this.getTagsForStencil(gn, 'yahoo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yammer;fillColor=#00AFE0;gradientColor=#005F7A',
				 w * 512, h * 512, '', 'Yammer', null, null, this.getTagsForStencil(gn, 'yammer', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yandex;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Yandex', null, null, this.getTagsForStencil(gn, 'yandex', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yelp;fillColor=#EF5140;gradientColor=#9C1410',
				 w * 512, h * 512, '', 'Yelp', null, null, this.getTagsForStencil(gn, 'yelp', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yoolink;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Yoolink', null, null, this.getTagsForStencil(gn, 'yoolink', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'youmob;gradientColor=#DFDEDE',
				 w * 512, h * 512, '', 'Youmob', null, null, this.getTagsForStencil(gn, 'youmob', dt).join(' '))
		]);
		this.setCurrentSearchEntryLibrary();
	};
	
	// Adds Web Icons shapes
	Sidebar.prototype.addWebLogosPalette = function()
	{
		var sb = this;
		var s = 'dashed=0;outlineConnect=0;html=1;align=center;labelPosition=center;verticalLabelPosition=bottom;verticalAlign=top;' + mxConstants.STYLE_SHAPE + "=mxgraph.weblogos.";
		var gn = 'mxgraph.weblogos';
		var dt = 'web logos logo';
		var w = 0.2;
		var h = 0.2;
		this.setCurrentSearchEntryLibrary('webicons', 'weblogos');
		
		this.addPaletteFunctions('weblogos', 'Web Logos', false,
		[
		 this.createVertexTemplateEntry(s + 'adfty;fillColor=#66E8F3;gradientColor=#1C7CBA',
				 w * 456, h * 458, '', 'Adfty', null, null, this.getTagsForStencil(gn, 'adfty', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'adobe_pdf;fillColor=#A60908',
				 w * 347, h * 338, '', 'Adobe PDF', null, null, this.getTagsForStencil(gn, 'adobe pdf', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'aim',
				 w * 312, h * 342, '', 'Aim', null, null, this.getTagsForStencil(gn, 'aim', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'allvoices',
				 w * 420, h * 398, '', 'Allvoices', null, null, this.getTagsForStencil(gn, 'allvoices', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'amazon',
				 w * 314, h * 341, '', 'Amazon', null, null, this.getTagsForStencil(gn, 'amazon', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'android;fillColor=#A4CA39;strokeColor=none',
				 w * 338, h * 400, '', 'Android', null, null, this.getTagsForStencil(gn, 'android', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'apache',
				 w * 213, h * 426, '', 'Apache', null, null, this.getTagsForStencil(gn, 'apache db database', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'apple;fillColor=#1B1C1C;strokeColor=none',
				 w * 312, h * 381, '', 'Apple', null, null, this.getTagsForStencil(gn, 'apple', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'apple_classic',
				 w * 312, h * 381, '', 'Apple (classic)', null, null, this.getTagsForStencil(gn, 'apple classic', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'app_store;fillColor=#000000;strokeColor=none',
				 w * 306, h * 100, '', 'App Store', null, null, this.getTagsForStencil(gn, 'app store application', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'app_store_iphone;fillColor=#75797C;strokeColor=none',
				 w * 306, h * 100, '', 'App Store iPhone', null, null, this.getTagsForStencil(gn, 'app store iphone', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'arduino;fillColor=#36868D;strokeColor=none',
				 w * 337, h * 160, '', 'Arduino', null, null, this.getTagsForStencil(gn, 'arduino', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'ask;fillColor=#D22028;strokeColor=none',
				 w * 343, h * 253, '', 'Ask', null, null, this.getTagsForStencil(gn, 'ask', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Atlassian_Logo.svg;html=1;',
				 66, 66, '', 'Atlassian', null, null, this.getTagsForStencil(gn, 'atlassian logo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'audioboo;fillColor=#B9217E',
				 w * 270, h * 397, '', 'Audioboo', null, null, this.getTagsForStencil(gn, 'audioboo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'aws',
				 w * 318, h * 292, '', 'AWS', null, null, this.getTagsForStencil(gn, 'aws amazon web service', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'aws_s3',
				 w * 308, h * 288, '', 'AWS S3', null, null, this.getTagsForStencil(gn, 'aws s3 amazon web service', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'baidu;fillColor=#3F4D9E',
				 w * 355, h * 385, '', 'Baidu', null, null, this.getTagsForStencil(gn, 'baidu', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Bamboo_Logo.svg;html=1;',
				 64, 74, '', 'Bamboo', null, null, this.getTagsForStencil(gn, 'bamboo logo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'bebo;fillColor=#EC1C23;strokeColor=none',
				 w * 279, h * 357, '', 'Bebo', null, null, this.getTagsForStencil(gn, 'bebo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'behance;fillColor=#3A3333',
				 w * 369, h * 228, '', 'Behance', null, null, this.getTagsForStencil(gn, 'behance', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'bing;fillColor=#008373;strokeColor=none',
				 w * 265, h * 331, '', 'Bing', null, null, this.getTagsForStencil(gn, 'bing', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Bitbucket_Logo.svg;html=1;',
				 57, 50, '', 'Bitbucket', null, null, this.getTagsForStencil(gn, 'bitbucket logo atlassian', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'blinklist;fillColor=#3A3333;strokeColor=none',
				 w * 406, h * 360, '', 'Blinklist', null, null, this.getTagsForStencil(gn, 'blinklist', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'blogger;fillColor=#F66C2A;strokeColor=none',
				 w * 290, h * 291, '', 'Blogger', null, null, this.getTagsForStencil(gn, 'blogger', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'blogmarks',
				 w * 188, h * 322, '', 'Blogmarks', null, null, this.getTagsForStencil(gn, 'blogmarks', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'bookmarks.fr',
				 w * 351, h * 314, '', 'Bookmarks.fr', null, null, this.getTagsForStencil(gn, 'bookmarks.fr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'box;fillColor=#2771B9;strokeColor=none',
				 w * 223, h * 321, '', 'Box', null, null, this.getTagsForStencil(gn, 'box', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'buddymarks',
				 w * 397, h * 285, '', 'Buddymarks', null, null, this.getTagsForStencil(gn, 'buddymarks', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'buffer;fillColor=#221F1F;strokeColor=none',
				 w * 352, h * 302, '', 'Buffer', null, null, this.getTagsForStencil(gn, 'buffer', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'buzzfeed;fillColor=#ED3223;strokeColor=none',
				 w * 390, h * 390, '', 'Buzzfeed', null, null, this.getTagsForStencil(gn, 'buzzfeed', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'chrome',
				 w * 374, h * 377, '', 'Chrome', null, null, this.getTagsForStencil(gn, 'chrome', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'citeulike;fillColor=#698139',
				 w * 378, h * 180, '', 'Citeulike', null, null, this.getTagsForStencil(gn, 'citeulike', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Clover_Logo.svg;html=1;',
				 71, 71, '', 'Clover', null, null, this.getTagsForStencil(gn, 'clover logo', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Confluence_Logo.svg;html=1;',
				 63, 57, '', 'Confluence', null, null, this.getTagsForStencil(gn, 'confluence logo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'connotea',
				 w * 405, h * 413, '', 'Connotea', null, null, this.getTagsForStencil(gn, 'connotea', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Crowd_Logo.svg;html=1;',
				 66, 65, '', 'Crowd', null, null, this.getTagsForStencil(gn, 'crowd logo', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Crucible_Logo.svg;html=1;',
				 61, 61, '', 'Crucible', null, null, this.getTagsForStencil(gn, 'crucible logo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dealsplus;fillColor=#935492',
				 w * 380, h * 333, '', 'Dealsplus', null, null, this.getTagsForStencil(gn, 'dealsplus', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'designfloat;strokeColor=none',
				 w * 360, h * 360, '', 'Designfloat', null, null, this.getTagsForStencil(gn, 'designfloat', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'deviantart;fillColor=#009544;strokeColor=none;',
				 w * 310, h * 432, '', 'Deviantart', null, null, this.getTagsForStencil(gn, 'deviantart', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'digg',
				 w * 290, h * 280, '', 'Digg', null, null, this.getTagsForStencil(gn, 'digg', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'diigo;fillColor=#2973D2;strokeColor=none',
				 w * 306, h * 344, '', 'Diigo', null, null, this.getTagsForStencil(gn, 'diiigo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dopplr;fillColor=#F9634D;strokeColor=none',
				 w * 512, h * 512, '', 'Dopplr', null, null, this.getTagsForStencil(gn, 'dopplr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'drawio2;fillColor=#1A5BA3',
				 w * 261, h * 354, '', 'draw.io', null, null, this.getTagsForStencil(gn, 'diagrams.net drawio draw io draw.io', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'drawio3;fillColor=#1A5BA3;fontSize=15;fontColor=#1A5BA3;fontStyle=1',
				 w * 261, h * 261, 'diagrams.<font color="#f08707">net</font>', 'diagrams.net', null, null, this.getTagsForStencil(gn, 'diagrams.net drawio draw io draw.io', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'drawio4;fillColor=#1A5BA3;fontSize=15;fontColor=#1A5BA3;fontStyle=1',
				w * 261, h * 261, 'diagrams.<font color="#f08707">net</font>', 'diagrams.net', null, null, this.getTagsForStencil(gn, 'diagrams.net drawio draw io draw.io', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dribbble;fillColor=#EB548D',
				 w * 337, h * 336, '', 'Dribbble', null, null, this.getTagsForStencil(gn, 'dribbble', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dropbox;fillColor=#0287EA',
				 w * 367, h * 310, '', 'Dropbox2', null, null, this.getTagsForStencil(gn, 'dropbox', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'drupal',
				 w * 303, h * 345, '', 'Drupal', null, null, this.getTagsForStencil(gn, 'drupal', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'dzone',
				 w * 438, h * 306, '', 'Dzone', null, null, this.getTagsForStencil(gn, 'dzone', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'ebay',
				 w * 406, h * 172, '', 'Ebay', null, null, this.getTagsForStencil(gn, 'ebay', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'edmodo;fillColor=#276CB0;strokeColor=none',
				 w * 346, h * 369, '', 'Edmodo', null, null, this.getTagsForStencil(gn, 'edmodo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'evernote;fillColor=#3F3F3F',
				 w * 317, h * 376, '', 'Evernote', null, null, this.getTagsForStencil(gn, 'evernote', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fancy;fillColor=#6DB3E3',
				 w * 196, h * 395, '', 'Fancy', null, null, this.getTagsForStencil(gn, 'fancy', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fark;fillColor=#B1B0C7;gradientColor=#ffffff;strokeColor=#B1B0C7',
				 w * 221, h * 351, '', 'Fark', null, null, this.getTagsForStencil(gn, 'fark', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fashiolista',
				 w * 388, h * 366, '', 'Fashiolista', null, null, this.getTagsForStencil(gn, 'fashiolista', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'feed;fillColor=#000000',
				 w * 302, h * 296, '', 'Feed', null, null, this.getTagsForStencil(gn, 'feed', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'feedburner',
				 w * 342, h * 372, '', 'Feedburner', null, null, this.getTagsForStencil(gn, 'feedburner', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Fisheye_Logo.svg;html=1;',
				 71, 59, '', 'Fisheye', null, null, this.getTagsForStencil(gn, 'fisheye logo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'flickr',
				 w * 356, h * 156, '', 'Flickr', null, null, this.getTagsForStencil(gn, 'flickr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'folkd;fillColor=#165AA6',
				 w * 419, h * 218, '', 'Folkd', null, null, this.getTagsForStencil(gn, 'folkd', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'forrst;fillColor=#27431F',
				 w * 264, h * 366, '', 'Forrst', null, null, this.getTagsForStencil(gn, 'forrst', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fotolog;fillColor=#000000;strokeColor=none',
				 w * 238, h * 238, '', 'Fotolog', null, null, this.getTagsForStencil(gn, 'fotolog', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'freshbump;fillColor=#C2D952;strokeColor=none',
				 w * 356, h * 380, '', 'Freshbump', null, null, this.getTagsForStencil(gn, 'freshbump', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fresqui',
				 w * 512, h * 512, '', 'Fresqui', null, null, this.getTagsForStencil(gn, 'fresqui', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'friendfeed;fillColor=#4172BB',
				 w * 369, h * 355, '', 'Friendfeed', null, null, this.getTagsForStencil(gn, 'fiendfeed', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'funp',
				 w * 375, h * 200, '', 'Funp', null, null, this.getTagsForStencil(gn, 'funp', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'fwisp;fillColor=#66676A;strokeColor=none',
				 w * 327, h * 330, '', 'Fwisp', null, null, this.getTagsForStencil(gn, 'fwisp', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'gabbr;fillColor=#F05B1E',
				 w * 322, h * 330, '', 'Gabbr', null, null, this.getTagsForStencil(gn, 'gabbr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'gamespot',
				 w * 408, h * 408, '', 'Gamespot', null, null, this.getTagsForStencil(gn, 'gamespot', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'github',
				 w * 375, h * 375, '', 'Github', null, null, this.getTagsForStencil(gn, 'github', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'gmail',
				 w * 324, h * 234, '', 'Gmail', null, null, this.getTagsForStencil(gn, 'gmail', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google',
				 w * 326, h * 347, '', 'Google', null, null, this.getTagsForStencil(gn, 'google', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_drive',
				 w * 332, h * 290, '', 'Google Drive', null, null, this.getTagsForStencil(gn, 'google drive', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_hangout;fillColor=#4BA139;strokeColor=none',
				 w * 324, h * 377, '', 'Google Hangout', null, null, this.getTagsForStencil(gn, 'google hangout', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_play;fillColor=#000000',
				 w * 347, h * 103, '', 'Google Play', null, null, this.getTagsForStencil(gn, 'google play', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_play_light;fillColor=#66E8F3;gradientColor=#1C7CBA',
				 w * 300, h * 52, '', 'Google Play Light', null, null, this.getTagsForStencil(gn, 'google play light', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_photos',
				 w * 436, h * 436, '', 'Google Photos', null, null, this.getTagsForStencil(gn, 'google photos', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'google_plus;fillColor=#DD4C40;strokeColor=none',
				 w * 328, h * 220, '', 'Google+', null, null, this.getTagsForStencil(gn, 'google plus', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'grooveshark;fillColor=#000000;strokeColor=none',
				 w * 311, h * 311, '', 'Grooveshark', null, null, this.getTagsForStencil(gn, 'grooveshark', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'hatena',
				 w * 431, h * 221, '', 'Hatena', null, null, this.getTagsForStencil(gn, 'hatena', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Hipchat_Logo.svg;html=1;',
				 66, 62, '', 'Hipchat', null, null, this.getTagsForStencil(gn, 'hipchat logo atlassian', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'html5',
				 w * 262, h * 370, '', 'HTML5', null, null, this.getTagsForStencil(gn, 'html5 html', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'identi.ca',
				 w * 371, h * 238, '', 'Identi.ca', null, null, this.getTagsForStencil(gn, 'identi.ca', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'instagram;fillColor=#6FC0E4;gradientColor=#1E305B',
				 w * 361, h * 361, '', 'Instagram', null, null, this.getTagsForStencil(gn, 'instagram', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'instapaper',
				 w * 138, h * 351, '', 'Instapaper', null, null, this.getTagsForStencil(gn, 'instapaper', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'ios;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 368, h * 197, '', 'iOS', null, null, this.getTagsForStencil(gn, 'ios', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'jamespot;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 390, h * 390, '', 'Jamespot', null, null, this.getTagsForStencil(gn, 'jamespot', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'java',
				 w * 172, h * 325, '', 'Java', null, null, this.getTagsForStencil(gn, 'java', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Jira_Logo.svg;html=1;',
				 72, 72, '', 'Jira', null, null, this.getTagsForStencil(gn, 'jira logo', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Jira_Core_Logo.svg;html=1;',
				 55, 66, '', 'Jira Core', null, null, this.getTagsForStencil(gn, 'jira core logo atlassian', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Jira_Service_Desk_Logo.svg;html=1;',
				 59, 76, '', 'Jira Service Desk', null, null, this.getTagsForStencil(gn, 'jira service desk logo atlassian', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Jira_Software_Logo.svg;html=1;',
				 74, 76, '', 'Jira Software', null, null, this.getTagsForStencil(gn, 'jira software logo atlassian', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'joomla;fillColor=#1F457D;gradientColor=#081220',
				 w * 330, h * 328, '', 'Joomla', null, null, this.getTagsForStencil(gn, 'joomla', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'jquery;fillColor=#0BB9EA;gradientColor=#032F80',
				 w * 369, h * 335, '', 'Jquery', null, null, this.getTagsForStencil(gn, 'jquery', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'json',
				 w * 350, h * 379, '', 'JSON', null, null, this.getTagsForStencil(gn, 'json', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'json_2',
				 w * 402, h * 126, '', 'JSON', null, null, this.getTagsForStencil(gn, 'json', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'last.fm;fillColor=#F33543;gradientColor=#BD0E11',
				 w * 416, h * 250, '', 'Last.fm', null, null, this.getTagsForStencil(gn, 'last.fm last fm', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'linkagogo;fillColor=#F6F5FA;gradientColor=#C8C1E1',
				 w * 511, h * 400, '', 'Linkagogo', null, null, this.getTagsForStencil(gn, 'linkagogo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'linkedin;fillColor=#0095DB;gradientColor=#006391',
				 w * 287, h * 303, '', 'LinkedIn', null, null, this.getTagsForStencil(gn, 'linkedin', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'livejournal;fillColor=#2690E5;gradientColor=#0A2463',
				 w * 320, h * 343, '', 'Livejournal', null, null, this.getTagsForStencil(gn, 'livejournal', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'mail.ru;fillColor=#267BE0;gradientColor=#0A1F42',
				 w * 406, h * 393, '', 'Mail.ru', null, null, this.getTagsForStencil(gn, 'mail.ru', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'mathoverflow;fillColor=#656463;gradientColor=#F28711;gradientDirection=east',
				 w * 295, h * 241, '', 'MathOverflow', null, null, this.getTagsForStencil(gn, 'mathoverflow', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'meetup;fillColor=#413E3E;strokeColor=none',
				 w * 374, h * 150, '', 'Meetup', null, null, this.getTagsForStencil(gn, 'meetup', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'meneame',
				 w * 380, h * 338, '', 'Meneame', null, null, this.getTagsForStencil(gn, 'meneame', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'messenger',
				 w * 413, h * 384, '', 'Messenger', null, null, this.getTagsForStencil(gn, 'messenger', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'messenger_2',
				 w * 322, h * 324, '', 'Messenger', null, null, this.getTagsForStencil(gn, 'messenger', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'messenger_3;fillColor=#437BBD;strokeColor=#dddddd',
				 w * 322, h * 324, '', 'Messenger', null, null, this.getTagsForStencil(gn, 'messenger', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'mind_body_green;strokeColor=#888888',
				 w * 407, h * 464, '', 'Mind Body Green', null, null, this.getTagsForStencil(gn, 'mind body green', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'mongodb',
				 w * 206, h * 431, '', 'MongoDb', null, null, this.getTagsForStencil(gn, 'mongodb', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'myspace;fillColor=#003399;strokeColor=none',
				 w * 315, h * 351, '', 'MySpace', null, null, this.getTagsForStencil(gn, 'myspace', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'n4g;fillColor=#000000;strokeColor=none',
				 w * 441, h * 159, '', 'N4g', null, null, this.getTagsForStencil(gn, 'n4g', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'netlog;fillColor=#F42424;strokeColor=none',
				 w * 383, h * 344, '', 'Netlog', null, null, this.getTagsForStencil(gn, 'netlog', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'netvibes;fillColor=#84BD00;strokeColor=none',
				 w * 309, h * 309, '', 'Netvibes', null, null, this.getTagsForStencil(gn, 'netvibes', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'netvouz',
				 w * 286, h * 287, '', 'Netvouz', null, null, this.getTagsForStencil(gn, 'netvouz', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'networkedblogs',
				 w * 394, h * 394, '', 'Networkedblogs', null, null, this.getTagsForStencil(gn, 'networkedblogs', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'newsvine;fillColor=#005221;strokeColor=none',
				 w * 203, h * 386, '', 'Newsvine', null, null, this.getTagsForStencil(gn, 'newsvine', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'odnoklassniki;fillColor=#F58220;strokeColor=none',
				 w * 247, h * 410, '', 'Odnoklassniki', null, null, this.getTagsForStencil(gn, 'odnoklassniki', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'oknotizie',
				 w * 237, h * 352, '', 'Oknotizie', null, null, this.getTagsForStencil(gn, 'oknotizie', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'onedrive;fillColor=#094AB1;strokeColor=none',
				 w * 356, h * 216, '', 'OneDrive', null, null, this.getTagsForStencil(gn, 'onedrive', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'oracle;fillColor=#FF0000;strokeColor=none',
				 w * 450, h * 115, '', 'Oracle', null, null, this.getTagsForStencil(gn, 'oracle', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'paypal',
				 w * 256, h * 290, '', 'Paypal', null, null, this.getTagsForStencil(gn, 'paypal', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'phone;fillColor=#36BE0F;strokeColor=none',
				 w * 289, h * 271, '', 'Phone', null, null, this.getTagsForStencil(gn, 'phone', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'phonefavs',
				 w * 322, h * 394, '', 'Phonefavs', null, null, this.getTagsForStencil(gn, 'phonefavs', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'pinterest;fillColor=#BD081C;strokeColor=none',
				 w * 384, h * 372, '', 'Pinterest', null, null, this.getTagsForStencil(gn, 'pinterest', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'plaxo;fillColor=#414F5C;strokeColor=none',
				 w * 400, h * 400, '', 'Plaxo', null, null, this.getTagsForStencil(gn, 'plaxo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'playfire;fillColor=#FDA21A;gradientColor=#FEE635;strokeColor=none',
				 w * 310, h * 308, '', 'Playfire', null, null, this.getTagsForStencil(gn, 'playfire', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'plurk;fillColor=#E9443D;strokeColor=none',
				 w * 512, h * 512, '', 'Plurk', null, null, this.getTagsForStencil(gn, 'plurk', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'pocket;fillColor=#EE4056;strokeColor=none',
				 w * 314, h * 289, '', 'Pocket', null, null, this.getTagsForStencil(gn, 'pocket', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'protopage;fillColor=#4B78C0;gradientColor=#294282',
				 w * 394, h * 400, '', 'Protopage', null, null, this.getTagsForStencil(gn, 'protopage', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'readernaut;fillColor=#000000;strokeColor=none',
				 w * 360, h * 360, '', 'Readernaut', null, null, this.getTagsForStencil(gn, 'readernaut', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'reddit;fillColor=#F3F8FC;gradientColor=#B4D2F0',
				 w * 440, h * 368, '', 'Reddit', null, null, this.getTagsForStencil(gn, 'reddit', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'rss;fillColor=#F56800;strokeColor=none',
				 w * 408, h * 408, '', 'RSS', null, null, this.getTagsForStencil(gn, 'rss', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'scoopit;fillColor=#6CAB36;strokeColor=none',
				 w * 290, h * 350, '', 'Scoopit', null, null, this.getTagsForStencil(gn, 'scoopit', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'scribd;fillColor=#3D3533;strokeColor=none',
				 w * 289, h * 346, '', 'Scribd', null, null, this.getTagsForStencil(gn, 'scribd', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'segnalo',
				 w * 403, h * 389, '', 'Segnalo', null, null, this.getTagsForStencil(gn, 'segnalo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sina',
				 w * 429, h * 343, '', 'Sina', null, null, this.getTagsForStencil(gn, 'sina', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sitejot',
				 w * 386, h * 330, '', 'Sitejot', null, null, this.getTagsForStencil(gn, 'sitejot', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'skype;fillColor=#2AACE2;strokeColor=none',
				 w * 388, h * 394, '', 'Skype', null, null, this.getTagsForStencil(gn, 'skype', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'skyrock;fillColor=#009AFF;strokeColor=none',
				 w * 339, h * 352, '', 'Skyrock', null, null, this.getTagsForStencil(gn, 'skyrock', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'slashdot;fillColor=#026664;strokeColor=none',
				 w * 262, h * 310, '', 'Slashdot', null, null, this.getTagsForStencil(gn, 'slashdot', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sms;fillColor=#48B921;strokeColor=none',
				 w * 346, h * 320, '', 'SMS', null, null, this.getTagsForStencil(gn, 'sms', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'socialvibe;fillColor=#EE2F7F;strokeColor=none',
				 w * 250, h * 250, '', 'Socialvibe', null, null, this.getTagsForStencil(gn, 'socialvibe', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'society6;fillColor=#000000;strokeColor=none',
				 w * 374, h * 265, '', 'Society6', null, null, this.getTagsForStencil(gn, 'society6', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sonico;fillColor=#01AEF0;strokeColor=none',
				 w * 346, h * 316, '', 'Sonico', null, null, this.getTagsForStencil(gn, 'sonico', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'soundcloud;fillColor=#FE4600;strokeColor=none',
				 w * 367, h * 163, '', 'Soundcloud', null, null, this.getTagsForStencil(gn, 'soundcloud', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sourceforge',
				 w * 371, h * 372, '', 'Sourceforge', null, null, this.getTagsForStencil(gn, 'sourceforge', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'sourceforge_2;fillColor=#00547E;strokeColor=none',
				 w * 316, h * 234, '', 'Sourceforge', null, null, this.getTagsForStencil(gn, 'sourceforge', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Sourcetree_Logo.svg;html=1;',
				 57, 71, '', 'Sourcetree', null, null, this.getTagsForStencil(gn, 'sourcetree logo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'spring.me;fillColor=#0374B8;strokeColor=none',
				 w * 366, h * 158, '', 'Spring.me', null, null, this.getTagsForStencil(gn, 'spring me', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'stackexchange',
				 w * 319, h * 395, '', 'Stackexchange', null, null, this.getTagsForStencil(gn, 'stackexchange stack exchange', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'stackoverflow',
				 w * 272, h * 320, '', 'StackOverflow', null, null, this.getTagsForStencil(gn, 'stackoverflow stack overflow', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'startaid;fillColor=#409FCF;strokeColor=none',
				 w * 206, h * 213, '', 'Startaid', null, null, this.getTagsForStencil(gn, 'startaid', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'startlap;fillColor=#B9E6F0;gradientColor=#3062A2',
				 w * 410, h * 421, '', 'Startlap', null, null, this.getTagsForStencil(gn, 'startlap', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Statuspage_Logo.svg;html=1;',
				 75, 52, '', 'Statuspage', null, null, this.getTagsForStencil(gn, 'statuspage logo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'steam;fillColor=#695D5D;gradientColor=#100E0E',
				 w * 426, h * 198, '', 'Steam', null, null, this.getTagsForStencil(gn, 'steam', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Stride_Logo.svg;html=1;',
				 69, 57, '', 'Stride', null, null, this.getTagsForStencil(gn, 'stride logo atlassian', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'stumbleupon;fillColor=#EB4924;strokeColor=none',
				 w * 512, h * 512, '', 'StumbleUpon', null, null, this.getTagsForStencil(gn, 'stumbleupon', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'stumpedia',
				 w * 335, h * 338, '', 'Stumpedia', null, null, this.getTagsForStencil(gn, 'stumpedia', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'translate',
				 w * 342, h * 335, '', 'Translate', null, null, this.getTagsForStencil(gn, 'translate', dt).join(' ')),
		 this.createVertexTemplateEntry('image;image=img/lib/atlassian/Trello_Logo.svg;html=1;',
				 70, 70, '', 'Trello', null, null, this.getTagsForStencil(gn, 'trello logo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'tumblr;fillColor=#36465D;strokeColor=none',
				 w * 203, h * 326, '', 'Tumblr', null, null, this.getTagsForStencil(gn, 'tumblr', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'tunein',
				 w * 350, h * 350, '', 'Tunein', null, null, this.getTagsForStencil(gn, 'tunein', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'twitter;fillColor=#1DA1F2;strokeColor=none',
				 w * 400, h * 350, '', 'Twitter', null, null, this.getTagsForStencil(gn, 'twitter', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'two;fillColor=#FF6D00;strokeColor=none',
				 w * 377, h * 100, '', 'Two', null, null, this.getTagsForStencil(gn, 'two', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'typepad;fillColor=#ADB560;strokeColor=none',
				 w * 324, h * 192, '', 'Typepad', null, null, this.getTagsForStencil(gn, 'typepad', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'viadeo',
				 w * 367, h * 420, '', 'Viadeo', null, null, this.getTagsForStencil(gn, 'viadeo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'viber;fillColor=#7D539F;strokeColor=none',
				 w * 387, h * 426, '', 'Viber', null, null, this.getTagsForStencil(gn, 'viber', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'viddler;fillColor=#1896E0;gradientColor=#06253F',
				 w * 410, h * 106, '', 'Viddler', null, null, this.getTagsForStencil(gn, 'viddler', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'vimeo;fillColor=#1AB7EA;strokeColor=none',
				 w * 313, h * 290, '', 'Vimeo', null, null, this.getTagsForStencil(gn, 'vimeo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'virb;fillColor=#000000;strokeColor=none',
				 w * 330, h * 353, '', 'Virb', null, null, this.getTagsForStencil(gn, 'virb', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'vkontakte;fillColor=#4C75A3;strokeColor=none',
				 w * 352, h * 200, '', 'Vkontakte', null, null, this.getTagsForStencil(gn, 'vkontakte', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'wakoopa;fillColor=#FF6D00;strokeColor=none',
				 w * 413, h * 224, '', 'Wakoopa', null, null, this.getTagsForStencil(gn, 'wakoopa', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'weheartit;fillColor=#FF4577;strokeColor=none',
				 w * 411, h * 348, '', 'Weheartit', null, null, this.getTagsForStencil(gn, 'weheartit', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'whatsapp;fillColor=#00E676;strokeColor=#dddddd',
				 w * 372, h * 374, '', 'Whatsapp', null, null, this.getTagsForStencil(gn, 'whatsapp', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'wix;strokeColor=#dddddd',
				 w * 370, h * 308, '', 'Wix', null, null, this.getTagsForStencil(gn, 'wix', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'wordpress;fillColor=#00A7DA;strokeColor=none',
				 w * 333, h * 327, '', 'Wordpress', null, null, this.getTagsForStencil(gn, 'wordpress', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'wordpress_2;fillColor=#00A7DA;strokeColor=none',
				 w * 344, h * 344, '', 'Wordpress', null, null, this.getTagsForStencil(gn, 'wordpress', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'xanga;fillColor=#000000;strokeColor=none',
				 w * 350, h * 190, '', 'Xanga', null, null, this.getTagsForStencil(gn, 'xanga', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'xerpi;fillColor=#7F719B;gradientColor=#32264B;strokeColor=none',
				 w * 351, h * 328, '', 'Xerpi', null, null, this.getTagsForStencil(gn, 'xerpi', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'xing',
				 w * 325, h * 369, '', 'Xing', null, null, this.getTagsForStencil(gn, 'xing', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yahoo;fillColor=#65106E;strokeColor=none',
				 w * 372, h * 218, '', 'Yahoo', null, null, this.getTagsForStencil(gn, 'yahoo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yahoo_2;fillColor=#65106E;strokeColor=none',
				 w * 400, h * 233, '', 'Yahoo', null, null, this.getTagsForStencil(gn, 'yahoo', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yammer;fillColor=#0093BE;strokeColor=none',
				 w * 348, h * 298, '', 'Yammer', null, null, this.getTagsForStencil(gn, 'yammer', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yandex',
				 w * 159, h * 332, '', 'Yandex', null, null, this.getTagsForStencil(gn, 'yandex', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yelp;fillColor=#C41200;strokeColor=none',
				 w * 317, h * 415, '', 'Yelp', null, null, this.getTagsForStencil(gn, 'yelp', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'yoolink',
				 w * 396, h * 396, '', 'Yoolink', null, null, this.getTagsForStencil(gn, 'yoolink', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'youmob',
				 w * 380, h * 381, '', 'Youmob', null, null, this.getTagsForStencil(gn, 'youmob', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'youtube;fillColor=#FF2626;gradientColor=#B5171F',
				 w * 786, h * 329, '', 'Youtube', null, null, this.getTagsForStencil(gn, 'youtube', dt).join(' ')),
		 this.createVertexTemplateEntry(s + 'youtube_2;fillColor=#FF2626;gradientColor=#B5171F',
				 w * 232, h * 163, '', 'Youtube', null, null, this.getTagsForStencil(gn, 'youtube', dt).join(' '))
		]);
		
		this.setCurrentSearchEntryLibrary();
	};
})();
