/**
 * Copyright (c) 2020-2025, JGraph Holdings Ltd
 * Copyright (c) 2020-2025, draw.io AG
 */
(function()
{
	// Adds SAP shapes
	Sidebar.prototype.addSAPPalette = function()
	{
		var gn = 'mxgraph.sap';
		var sb = this;

		var s = 1;
		var w = s * 100;
		var h = s * 100;
		var w2 = s * 78;
		
		this.setCurrentSearchEntryLibrary('sap', 'sapAnnotations');
		this.addSAPAnnotationsPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapColored Connectors');
		this.addSAPColoredConnectorsPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapFoundations');
		this.addSAPFoundationalPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapIntegration Suite');
		this.addSAPIntegrationSuitePalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapApp Dev Automation');
		this.addSAPAppDevAutomationPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapData Analytics');
		this.addSAPDataAnalyticsPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapAI');
		this.addSAPAIPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapBTP SaaS');
		this.addSAPBTPSaaSPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapOther');
		this.addSAPOtherPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapGeneric Icons');
		this.addSAPGenericIconsPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapComponent Groups');
		this.addSAPEssentialsPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapComponents');
		this.addSAPComponentsPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapDefault Connectors');
		this.addSAPDefaultConnectorsPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapArea Shapes');
		this.addSAPAreaShapesPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapDefault Shapes');
		this.addSAPDefaultShapesPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapNumbers');
		this.addSAPNumbersPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapProducts');
		this.addSAPProductsPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapBuild Workzone');
		this.addSAPBuildWorkzonePalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapSemantic Accent');
		this.addSAPSemanticAccentPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary('sap', 'sapTexts');
		this.addSAPTextElementsPalette(s, gn, sb);
		this.setCurrentSearchEntryLibrary();
	};
	
	Sidebar.prototype.addSAPAnnotationsPalette = function(s, gn, sb)
	{
		var dt = 'sap annotation ';
		
		this.addPaletteFunctions('sapAnnotations', 'SAP / Annotations and Interfaces', false,
		[
			this.createVertexTemplateEntry('rounded=1;whiteSpace=wrap;html=1;arcSize=50;strokeColor=#0070f3;fillColor=default;strokeWidth=1.5;',
					 s * 57, s * 16, '<font size="1" color="#0a74f3"><b style="">Interface</b></font>', 'Interface', null, null, this.getTagsForStencil(gn, 'interface', dt).join(' ')),
			this.createVertexTemplateEntry('rounded=1;whiteSpace=wrap;html=1;arcSize=50;strokeColor=#475f75;fillColor=default;strokeWidth=1.5;',
					 s * 57, s * 16, '<font size="1" color="#475f75"><b style="">Interface</b></font>', 'Interface', null, null, this.getTagsForStencil(gn, 'interface', dt).join(' ')),
			this.addDataEntry('authenticate', 125, 16, 'Authenticate', 'zVXLbqMwFP0alo2weRSWbdJ2NVKlRprM0gk3YNXBjHESmK+fCzavklRpNzORUDjnvuzjAzje8lC9KFZkP2QCwvGeHG+ppNTm7lAtQQiHujxxvJVDqYuXQ5+vREkbdQumINe3FFBTcGLiCIZxaCiw9LFAutS1MHT4+9gs6VHwHO4y4GmG6AFTCPEdGmBkyMG71P63nfYS10LdnRRSTZo51CNRFJNoTLkl/zOdSa633l5c5Dx//bRZdzUoxvZjH+TMKmd0MXB0MowqecwTaHQkGD5nXMNbwXZN9IzniVymD8KGmdq9mX0FLsJSK/kOy16RTgcUiwsx4vfBnkFgRRzxNAz3Hus7/eSJzppRi6Bf6gmUhuqqL1rKmuIF5AG0qjHFFvjGNu7ZNm4osohjw3YGaPuEhmOlwWnfa7Ad3ljnXXahd8GFH9SGPHlQSp4R5TKHqbrDUTTi4hZVvRmDXw1opWnhqhoHV7VF80O5j7Zk+6nIkKQwkVgzlYKePFw3qD6SOXDnGnecAsE0P00nXhLeTniVvH30apMRTQtKeVQ7sDnjd0RXZr0Q2um2yx2dtjE7nrVpz7zf4k028L9kg62Qu/d1xvN/7wWouN60yCUdtnPcDg+DGlCPwCsojiqB6leSPHPR7QeRfXP47XSm9AhfcaE52v/MhdZOUTCx0/0i9uPhF8XfMymhX2r7bdMiHL7OJn388f4L'),
			this.addDataEntry('authorize', 125, 16, 'Authorize', 'zVXLbqMwFP0alo2MeTQsm6TtaqRKjTSZJQkXsOpgxjgJzNfPxTavJkhpNzORUDjnvuzjAzje+li/yrjMf4gEuOM9O95aCqHM3bFeA+cOJSxxvI1DKcHLoS8zUVdHSRlLKNQ9BdQUnGN+AsM4NORYuiqRrlTDDR3+PrVLWnFWwEMOLMsRPWGK6/oODTAy5OBdZv91p1TgWig5CC7kpJlDvSDxwjQdU6Rif6Yz3fnW+5uLvM7fPu+2XQ2Ksf/cBzmzyiu6HDg6GUalOBUJtDq6GL7kTMF7GR/a6AXPE7lcHbkNx/LwbvYVEISVkuID1r0inv9I9m2vVco4H/GpCwnqY0Qc8TQMUy/uO/1kicrbUYugX+oZpIJ61heasqZ4BXEEJRtMsQW+sQ252MYt5S6iyLCdAXSf0HBxZXDW9xpshzfWebdd6N1w4Se1oUiepBQXRIUoYKrucBStuLhF2ezG4FcLtDQabupxcNNYNH8o8yJDksFEYhXLDNTk4bpD9ZHMAbnWuOMk8Fix83TiLeHthDfB9KPXmIzltKASJ3kAmzN+R3Rl1guhnW67PNBpG7Pjqzb6zPst3mUD/0s22HNx+NjmrPj3XoCaqZ1GxO2wnUM6PAxqQTMCbyAZqgSyX0nywni3H0T2zeHr6bFUIzzjQnO0/5kLrZ2WwcROj4vIj4bfMvqeSV36pbbfNi3C4ets0scf778='),
			this.addDataEntry('generic protocol', 125, 16, 'Generic Protocol', 'zVXLbqMwFP0alo2MwaRZtknbVaVKjTSZJYELWHUwNU4C8/VzwebVBCntZiYSCufcl318AMdbH6oXFRbZq4xBON6T462VlNrcHao1COFQwmPH2ziUErwc+jwTddsoKUIFub6lgJqCUyiOYBiHBgJLHwukS10LQwefx2ZJj4LncJcBTzNED5jiur5DGUaGHLxL7X/bKZG4FkoiKaSaNHOo5y9ZsmRjipT8z3SmO996f3WRl/nbp922q0Ex9l/7IGdWeUEXA0cnw6iSxzyGRkcXw+eMa3gvwqiJnvE8kcv0QdhwqKJ3sy9GEJZayQ9Y94p0OqBYXIgRn7AkSJZWxBFPgyDxwr7TLx7rrBm1YP1ST6A0VLO+aClriheQB9CqxhRb4BvbkLNt3FDuYrUybGeAtk9guLA0OO17DbbDG+u86y70rrjwi9qQxw9KyTOiXOYwVXc4ikZc3KKqd2PwuwGtNC3cVOPgprZo/lDmRYY4hYnEOlQp6MnDdYPqI5kZudS44xSIUPPTdOI14e2EN8nbR682GffTglIeVQQ2Z/yO6MqsFwI73Xa5o9M2ZscXbdoz77d4kw38b9lgL2T0sc14/u+9ABXXuxYRt8N2DunwMKgB9Qi8geKoEqh+JfEzF91+ENk3h99OD5Ue4RkXmqP9z1xo7XTPJnZaLlaMDD+fsZ+51KXf6/tj2yIcvs8mffz5/gs='),
			this.addDataEntry('trust', 125, 16, 'Trust', 'zVXLbqMwFP0alo2MCUxYtqTtaqRKjTSZpQMXsOpgapwE5uvngs2rSUZpN9NIKJxzX/bxARwv2tfPipX5T5mAcLxHx4uUlNrc7esIhHAo4YnjrR1KCV4OfboSdbsoKZmCQt9SQE3BkYkDGMahgcDShxLpSjfC0MH7oV3Sg+AF3OXAsxzRPaa47tKhPkbGHLzL7H/XKZW4FkpiKaSaNXOoF8eEJPGUIhX/M5/pXm+9u7jI8/zN43bT16AYu499kDOrPKPLkaOzYVTJQ5FAq6OL4VPONbyWLG6jJzxP5HK9FzbMVPxq9uUThJVW8g2iQREvighZR61YXIgJn6YpSZkVccLTIEg9NnT6xROdt6MW/rDUIygN9VVfdJQ1xTPIPWjVYIotWBrbkJNt3FLuIgwN2xug6xMYjlUGZ0Ov0XZ4Y5132YXeBRd+UBuK5F4peUJUyALm6o5H0YqLW1TNdgp+t6CTpoPrehpcNxadHYo1579EhiSDmcSaqQz07OG6QfWJzD4517jnFAim+XE+8ZLwdsKL5N2j15iM1bygkgcVg82ZviP6MuuFwE63Xe7ovI3Z8Vmb7syHLd5kg+WnbLATMn7b5Lz4/16Amutth4jbYzuH9Hgc1IJmAl5AcVQJ1LCS5ImLfj+I7Jtj2U1nSk/wFReao/1mLrR2WvkzO/1YhMtw/K3Cr5nUpZ9q+2XTIhy/ziZ9+vH+Cw=='),
			this.addDataEntry('protocol', 125, 16, 'Protocol', 'zVXLbqMwFP0alo2MeTRZNg+6GqlSI01mScINWHUwY5wE5uvnYptXE6S0m5lIKJxzX/bxARxvdapeZVxkP0QC3PE2jreSQihzd6pWwLlDCUscb+1QSvByaDQRdXWUFLGEXD1SQE3BJeZnMIxDQ46lywLpUtXc0OHvc7OkJWc5PGXA0gzRC6a4ru/QACN9Dt6l9l93OgpcCyUHwYUcNXOoR8gzOdIhRUr2ZzzTnW69v7vI2/ztZrdta1CM/ec+yJlV3tBFz9HRMCrFOU+g0dHF8DVjCt6L+NBEr3ieyGXqxG04lod3s6+AICyVFB+w6hTROkS0EYtxPuA3y2geRVbEAU/D8OjFXaefLFFZM2oWdEu9gFRQTfpCU9YUryBOoGSNKbbAN7YhV9u4odzZYmHY1gC6T2i4uDQ47Xr1tsMb67z7LvTuuPCT2pAnL1KKK6Jc5DBWtz+KRlzcoqx3Q/CrAVoaDdfVMLiuLZo+lGmRIUlhJLGKZQpq9HA9oPpA5oDcatxyEnis2GU88Z7wdsKbYPrRq03GfFxQirM8gM0ZviPaMuuF0E63XZ7ouI3Z8U0bfebdFh+ygf8lG+y5OHxsM5b/ey9AxdROI+K22M4hLe4HNaAegDeQDFUC2a0kiRhv94PIvjl8PT2WaoAnXGiO9j9zobXTPBjZ6Xm2CEj/84Pgey516df6ftu2CPvvs0kffr7/Ag=='),
			this.addDataEntry('protocol', 125, 16, 'Protocol', 'zVXLbqMwFP0alo2MeTRZtknbVaVKjTSZpQMXsOpgapwE5uvngs2rCVLazUwkFM65L/v4AI63PlQvihXZq4xBON6T462VlNrcHao1COFQwmPH2ziUErwc+jwTddsoKZiCXN9SQE3BiYkjGMahocDSxwLpUtfC0OHnsVnSo+A53GXA0wzRA6a4ru/QACNDDt6l9r/tlEhcCyWRFFJNmjnUI/dLb5mMKVLyP9OZ7nzr/dVFXuZvn3bbrgbF2H/tg5xZ5QVdDBydDKNKHvMYGh1dDJ8zruG9YFETPeN5Ipfpg7BhpqJ3s6+AICy1kh+w7hXpdECxuBAjPmZJnARWxBFPwzDxWN/pF4911oxaBP1ST6A0VLO+aClriheQB9CqxhRb4BvbkLNt3FDuYrUybGeAtk9oOFYanPa9BtvhjXXedRd6V1z4RW3I4wel5BlRLnOYqjscRSMublHVuzH43YBWmhZuqnFwU1s0fyjzIkOcwkRizVQKevJw3aD6SOaAXGrccQoE0/w0nXhNeDvhTfL20atNxnJaUMqjisDmjN8RXZn1Qmin2y53dNrG7PiiTXvm/RZvsoH/LRvshYw+thnP/70XoOJ61yLidtjOIR0eBjWgHoE3UBxVAtWvJH7motsPIvvm8NvpTOkRnnGhOdr/zIXWTstgYqf7xSogw88Pgp+51KXf6/tj2yIcvs8mffz5/gs=')
		]);
	};

	Sidebar.prototype.addSAPColoredConnectorsPalette = function(s, gn, sb)
	{
		var dt = 'sap colored connector ';
		
		this.addPaletteFunctions('sapColored Connectors', 'SAP / Connectors', false,
		[
			this.addDataEntry('direct one directional', 120, 0, 'Direct, One-directional', 'jVJNb4MwDP01uU4Uinre6NpTpUmbtHNoLBI1YGRCC/v1MyR8aaq0QyT7vefn2IlIsrI7k6z1BRVYkbyLJCNE56Oyy8BaEUdGieQo4jjiI+LTE3Y3slEtCSr3n4LYF9ylbcEjHmhcbwMAlXolwgdnucXr7UubSiRv2pV82+OOw8YR3iBDizSWJPtDCoeUmZyLZT46DULCtlIwtI44Y+5k7GTC2af5GZT72fLbKKcH/iUdMUluo+F8ulqFFUxYcB16+GlAFfB0QSMUtnMGLMFRz5JH6M1s6ncYaTCFdluMwEpn7lt72fi0mO3mDh9ouPEiabClKwR0/VCTsAvO4SHnQh60APenkPch+5WsHgTNWsHBatAFGn/GlC4/0MvXH/QX'),
			this.addDataEntry('direct bi directional', 120, 0, 'Direct, Bi-directional', 'jVJJbsMwDHyNroVjx8i5ddKcCgRNgZ6VmLDVyKJBy1n6+lKLlxQN0IMAzXA4JCWKrGiuW5Jt/YYlaJFtRFYQog235lqA1iJNVCmytUjThI9IXx9EFz6atJLA2P8kpCHhLHUPgQlEZ286EmDKZyK8MDpoPJ4+amVE9lLbhrtdL/jaWcITFKiRfEq2XOWbVc6RAyfLg3dyQsLelOBKJ4w49qr0YMJor76dculQWcE+9sCjKHt7By2tQrOZIlxYkv2rOR+YmXs8s//qm3awN2hgoILCNccJFdgdkGrAAu1beVSmcnb5OPGnKm3tqCfHhYdzjT/8C0/Fj9gCsjPdWHKJPhzNw3clNaiqtvcc+Rc439vLLsBqtBsr7FBx4UnSYU9HiOx8JwbhNTrHnRkT41v8TuTLbIyJ8is2wGmVg3y+6T8='),
			this.addDataEntry('indirect one directional', 120, 0, 'Indirect, One-directional', 'jVJJbsMwDHyNroVjx8i5dZZTgaAp0LMSEZYaWTJoOUtfX2rxkgIBehAgDmeGpERWVM1th7yV71aAZsWGFRVa6+KtuVWgNcszJVixZnme0WH59kl2EbJZyxGM+48gj4IL1z1EJAKdu+sEgBGviPZK0VHb0/lTKsOKN+ka6na9oGvn0J6hstpikBTLVQmrkjJHEvNjcPJEtL0R4EtnFFFuq/RgQtFB/Xjm0keihkPqgUZR7v4BmjtlzWbKUGGObmjOWDNiyTcb4pnzd9+0g3OSBCgyvIIENbg9oGrAAR5aflKm9m36kQTvZBhhmvxLCSc98uIJ8QH9AE//JEDpQ3ZgqQzeiXJNPpQt47dlElQt3SOG4SUuj/a8i2E92o0V9lZR4YnS2R5PkND5bgzEW3JOuzMK08P8FdJlNsYEhVUbwmmlI32+8b8='),
			this.addDataEntry('indirect bi directional', 120, 0, 'Indirect, Bi-directional', 'jVJNb8IwDP01uU6lBXHeCuM0CY1JOwditRlpXLkpH/v1cz5KyzSkHSLF7z0/24lFUTaXDcm2fkMFRhRrUZSE6OKtuZRgjMgzrUSxEnme8RH56wN2FtislQTW/SchjwknaXqISAQ6dzUJAKueifDM0d7g4fhRayuKl9o13O1qxtfOER6hRIMUUor5cgHLBTN7Tpb74OSFhL1V4EtnHDH3qs1gwtFOf3vl3Eeqgl3qgUfR7voORjqNdj0yXFiS+6u5QEzMQzyx/+qbdrC3aGGAosI3xwkVuC2QbsAB7Vp50Lbydn4uJbs6zDGO/6mVqz3y5AXxFf0UDz8mQOlXNoBchq4sOScfZhfx77IadFW7e4zCc5zu7WUXw+pmd6uwRc2FR0mHPR0godMFGYSX5JwW6JaYHuZ3Il8mY4xQ2LchHPc6yqdr/wM='),
			this.addDataEntry('optional one directional', 120, 0, 'Optional, One-directional', 'jVPLasMwEPwaXYtix+TcOo9TITSFnpVosdTIkpHlPPr1Xb1spxDowaCdnZndldakrNvbzrJOvBsOipQbUtbWGBdP7a0GpUhBJSflmhQFxY8U2yfZRcjSjlnQ7j+CIgouTA0QkQj07q4SAJq/WmuuGB2VOZ0/hdSkfBOuxW7XCzz2zpoz1EYZGyTlclVtVhVmjihmx+DkidYMmoMvTTHC3FaqbILRQf545tJHvIFD6gFHke7+AYo5afRmymBhZl1uThs9YsmX5njm/D20XXZOkgBFhlegoAG3BytbcGAPHTtJ3fg2/Uic9SKMME3+JbkTHnnJhD1zqNSBVVBfNl6rH+vpSwUoPdMODBa3d6Rckztmq/iYVIBshHvEbLify6M962PYjHZjhb2RWHii9GawJ0jofGMy8Zac00aNwnRdf4V4mI0xQWEBczgteqTP/4Nf'),
			this.addDataEntry('optional bi directional', 120, 0, 'Optional, Bi-directional', 'jVNNb8IwDP01uU6lBXHeCuM0CY1JOwditRlpXLkpH/v1cz5KyzSkHSrFz+8924krirK5bEi29RsqMKJYi6IkRBdPzaUEY0SeaSWKlcjzjD+Rvz7IzkI2ayWBdf8R5FFwkqaHiESgc1eTALDqmQjPHO0NHo4ftbaieKldw92uZnzsHOERSjRIQVLMlwtYLjizZ7HcBydPJOytAl8644hzr9oMJhzt9Ldnzn2kKtilHngU7a7vYKTTaNdjhgtLcn81FxIT8xBP7L/6ph3sLVoYoMjwzbGgArcF0g04oF0rD9pW3s7PpWRXhznG8T+1crVHngbCVjpW2sDKM1823q2f7eFzBSi91QaQi9OVKefkztlFfNGsBl3V7h6jcEmne3vZxbC62d0qbFFz4ZHSYU8HSOh0bQbiJTmntboJ03X9FvJhMsYIhS0cwnHbI336M/wA'),
			this.addDataEntry('direct elbow', 120, 20, 'Direct, Elbow', 'jVPNTsMwDH6aXlHWbowrK9s4gDRpSJxDa9qwNK5cd6w8PWmTrB0wiUOl+PuxHTuNkrQ6bUnW5TPmoKNkHSUpIbI7VacUtI5iofIoeYjiWNgvijdX2NnAiloSGP6PIXaGhjsNDoG8gL0PkbjEAo3U6xFdEbYmhz6BsNGoeUKsLTiz4Acwd3v11SeRLaOFSq60Z9/RsCdndzZumPAAKWqkoYdkvlyslwuv3MhK6c4Sj6CPwCqTngiGHN5lq+11VyypAN4BqQoYaF/LTJmiL9MnA5P7qvOhqCSexJa9J8JPG75pzA4vpTIO3igdOnedvqqcyx65WYREwWrQQMC8rx+Sm3I/2qt7GiC/pC2gvQB1VkKgJavjpU82LizOurN1h8pmjMXJG/z+Ref3LS4z+Ik50/SdhDxB2GBLGfwS2nvLbiKre0FzvZ9b8XeZS/pHt15tD65ciCaDGqHhgYdw/JGcfPqffQM='),
			this.addDataEntry('optional elbow', 120, 20, 'Optional, Elbow', 'jVPBTsMwDP2aXlHabowrG9s4gDRpSJxDY9qwNK5Sd6x8PUmTrB0wiUOkvOf3bMdJknxVn7aGN9UzClBJvk7ylUEkv6tPK1AqyZgUSf6QZBmzK8k2V6LpEGUNN6DpP4bMG1rqFXgGRAn7ANFQhSVqrtYjuzTYaQEuAbNo1DwhNpZMLfkBRP1efrkkvCO0VEW1CtF31BSC6Z3FLRk8wAoVmqGHfLaYrxfzoNzwWqreBh5BHYFkwUMgGgS8807Z4y6JmxJoB0bWQGD2DS+kLl0Zlwy0CFVnQ1FuaIJt9N4Y/LTwTWFxeKmk9vRGqti57/RVCqocczOPiaJVo4bIBZ8bkuBtNUwsDWDHyTaoByZjrr6/CDf9q1c5UOEet4D2jKa3EgOKkzxe+njrYXnWna07lDZjxk7BEJ4I68OTYJcZwlC9afqUYp4obLEzBfwS2tHwfiJrnKC93s8t+7vMZfhHt0FtN75cRJNBjdTwByIc/5qXT7/iNw=='),
			this.addDataEntry('indirect elbow', 120, 20, 'Indirect, Elbow', 'jVPLTsMwEPyaXJGTtJQrLW05gFSpSJxNvCSmjjdyNqXh67Fju0mBShwieWZn9mUnyVf1aWt4Uz2jAJXk6yRfGUTyp/q0AqWSjEmR5A9JljH7JdnmSjQdoqzhBjT9x5B5Q0u9As+AKGEfIBqqsETN1XpklwY7LcAlYBaNmifExpKpJT+AqN/LL5eEd4SWqqhWIfqOmkIwvbO4JYMHWKFCM/SQzxbz9WIelBteS9XbwCOoI5AseAhEg4B33ik77pK4KYF2YGQNBGbf8ELq0pVxyUCLUHU2FOWGJljwthqGSr303hj8tPBNYXF4qaT29EaqOIZv+1UKqhxzM49Zo1WjhsgFn9uYX7nb89VLG6hwY1tAO43prcSA4iSPlz7eeliedWfrDqXNmLFTMITHwPpw+ewyQ1ifN00fTcwThS12poBfQjs37yeyxgna6/3csr/LXIZ/dBvU9uDLRTRZ1EgNrz3C8a/y8ulP9w0='),
			this.addDataEntry('plain direct', 120, 0, 'Plain, Direct', 'jVLLboMwEPwaXysCQTm35HGKFJVDz05YgVvjRYvJo1/f9SNAIkXqAckzOzPrNSuyor3uSHbNHivQItuIrCBEG07ttQCtRZqoSmRrkaYJfyLdvqgufDXpJIGx/zGkwXCWeoDABKK3Nx0JMNU7EV4YGTRMfjS25YuuF3zsLeEPFKiRvDpbrnJY5Vw5sk8efYgTEg6mAtc1YcS1rdJ6QqX6dcqlQ1UNZWzPUyh7+wQtrUKzmSrcWJJ9upfnZrkez5K/h7a7J0eLp4LCOdhQgz0AqRYsUNnJkzK1GyEfh/1SlW0c9ea48Fzuzi//gKfi8+8AOZluLLnEHK7m4SclDai6sY8c+eHPj/GyD7Ae48YOB1TceJL0ONAJIjvfhLvwGpPjpozG+BbPRj7Mxpgov1h3OC1wkM/3+w8='),
			this.addDataEntry('plain indirect', 120, 0, 'Plain, Indirect', 'jVLLboMwEPwaXysCQTm35HGKFDWHnp14BW6NFy0mj359148EEilSD0je2ZlZxl5RVO1lQ7JrtqjAiGIliooQXTy1lwqMEXmmlSiWIs8z/kS+ftGdhW7WSQLr/iPIo+AkzQARiUDvriYBYNU7EZ65smgZ/Ghcyz+6nPGxd4Q/UKFBCuxivihhUXLnwDp5CCaeSDhYBX5qxhX31tqYsdrrX8+c+0rVsE/jOYV2108w0mm0q7HDgyW5p/8K2MQ31BPn76Htbs5JEqDI8AoW1OB2QLoFB7Tv5FHb2kfwkZTsmxBhTP6llWs88uYJ8e58gJfPEaD0FhtAHkNXppyTD3fL+GJZA7pu3CNG4SZOj/ayj2V9t7tP2KHmwSOlx4GOkNDpWtyIl+Sc1uYuTBfzLOTDJMYIhS27leM2R/p02f8A'),
			this.addDataEntry('plain optional', 120, 0, 'Plain Optional', 'jVO7bsMwDPwarYVjJ8jcOo8pQNAMnZWIsNXKkkHTefTrSz0cOwECdDBAHu+OokSLomyuW5RtvXMKjCjWoijROYpRcy3BGJFnWoliJfI840/kmxfVWahmrUSw9B9BHgVnaXqISAQ6upkEgFXviO7CmXWWwY+aGj7oasZhR+h+oHTGYWAX8+VivVxw5cg6eQwmnoiutwp814wzrm20MWN20L+eOfeZquCQ2vMUmm6fYCRpZ9djhRtLpKdzBWziG/KJ83fftINzkgQoMryCBRXQHlA3QICHVp60rfwIfiQluzqMME7+pRXVHnkbCHtJrLSBlWe+bbxRP9bLRwpQeqEtOG6ON6ZckjtXF/Edsxp0VdMjhuF+zo/2sotpdbe7d9g7zY1HSud6PEFCp8syEK/JOS3TXZiu61nIwWSMEQq7N6Tjjkf69Bf4Aw=='),
			this.addDataEntry('default firewall', 120, 0, 'Default, Firewall', 'jVJNb4MwDP01uVMy1HNHP06VJu3Qc7pYEC1gZEwL+/UzJAWqqdIOkez3np9jJ0rnVX8i05RntOCVPiidEyKHqOpz8F6libNK71WaJnJUenzBbiY2aQxBzf8pSEPBzfgOAhKAlgcfAajtjgjvktVYC/heciUX3W8kbJnwG3L0SJNav22zwzYT5ip15jqZjELCrrYwdk0kE+7ovF+yT/czKvVseXGWy4iEK4Et4OWUExRHPAFWwDSI5B5dhM3CIpISXFHyM0bgDbvbs71pQ1rMdnOHD3TSeJG02NEXRHS97Yewj87xNeZCNlQA/ymUfZthJWtGQbtWSLAadIGm532kyzcK8vUv+wU='),
			this.addDataEntry('error', 120, 0, 'Error', 'jVLbbsMgDP0aXicK6wds6dqnSZM2ac+kWAGVxBEhbbKvnwnkUk2V9oBkn3N8jA1MFvVw8qo176jBMfnGZOERQ4rqoQDnmOBWM3lgQnA6TBwfsLuJ5a3y0IT/FIhUcFWuh4QkoAujywA0+sV7vFFWOjxfvoxtmHw1oabbHnYUdsHjBQp06KcSqQVXXBFTUrEqJ6co9Ng3GmJrThlxR+tmE8o+7U9UPi+W31YHE/mn/YQpH+40lM9Xa7CBGcuusUeaBnQFDxc0QXk7J8Aagh9Jcsu9id2nHXIDtjLhHvPgVLDXe3vVpbRa7JYOH2ip8SrpsPdnyOj2oWbhkJ3zQy6FNGgF4U8h7UONG1kbBd1WQcFm0BWafsacrj8wybcf9Bc='),		
			this.addDataEntry('error', 120, 0, 'Error', 'jVJJbsMwDHyNroViNw9oneVUIGgK9KzEhK1GFg1aztLXl1q8pGiAHgRohsMhKVHkRXPdkmrrNyzBiHwt8oIQXbw11wKMEZnUpchXIsskH5FtHkQXISpbRWDdfxKymHBWpofIRKJzN5MIsOULEV4YHQweTx+1tiJ/rV3D3a4WfO0c4QkKNEghJS8zqaTiyIGT1SE4eSFhb0vwpSUjjm20GUwY7fW3Vz57VFawTz3wKNrd3sEop9GupwgXVuT+ai4EZuYBz+y/+qYd7C1aGKio8M1xQgVuB6QbcED7Vh21rbzdcpz4U5eu9tST5+LD+cYf/kWg0kdsAdmZbiy5JB+OLuN3yRp0Vbt7jsILnO/tVRdhNdqNFXaoufAk6bCnIyR2vhOD8Jqc086MiektfifyZTbGRIUVG+C0ylE+3/Qf'),
			this.addDataEntry('error', 120, 0, 'Error', 'jVLBbsMgDP0arhMl6wds6drTpEk77EyHlaCROHJIm+zr5wBNyKZKOyD5PT8/Y4MoymY8ke7qVzTgRPEiipIQfYyasQTnhJLWiOIglJJ8hDreye5CVnaaoPX/KVCx4KLdAJGJRO8nlwhozRMRXhm12DL5XPuGL3rYcdh7wi8o0SEFdWGU1FJz5sx1+hxMZiHh0BqYu0pGnDta51b0br9n5eNi+WGNr+fah33gNPmNhvGvWwUuc42DgKng7m4ClRZzAmzA08SSa+rN2X1cn6zBVrXfcgROe3vZ2us+wmqxWzq8oeXGq6THgT4hsfkb3YRjck5vuBTyoBX4P4W8Dz1lsm4W9LmCg2zQlQqf4gbXzxfl+d/8AQ=='),
			this.addDataEntry('error', 120, 20, 'Error', 'jVPNTsMwDH6aXlHWMsSVlW0cQJo0JM6h8dqwNK5cd6w8PWmTbB0wiUOl+PuxHTtNsrw+rkk21QsqMEm2TLKcENmf6mMOxiSp0CrJHpM0Fe5L0tUVdjayopEElv9jSL2h5d6AR0CVsA0hEldYopVmeUYXhJ1VMCQQLjprnhEbB84c+AHM/VZ/DUlkx+igimsT2B1aDuTs3sUtE+4hR4M09pCpVEghg3Ila216RzyBOQDrIhLRoGAnO+Ouu2BJJfAGSNfAQNtGFtqWQ5m5Y8GqUPV2LCqJJ7FjH4jw04XvBov9a6Wth1faxM59p29acTUgN/OYKFotWohY8A1D8lMeRnt1TyMUlrQGdBeg3kkIjGR9uPTJ1oflSXeyblC7jKk4BkPYv+jDvsVlhjAxb5q+k5gnClvsqIBfQndv2U9kzSBor/dzJ/4uc0n/6Dao3cGXi9FkUGdofOAxPP9IXj79z74B'),
			this.addDataEntry('dashed error', 120, 0, 'Error, Dashed', 'jVJJbsMwDHyNroViNw9oneUUIGgK9KxEhKVGFg1ZztLXl1q8pECAHgSIw5khKZGVVXPbOtGqHUowrFyzsnKIPt2aWwXGsIJrycoVKwpOhxWbJ9lFzPJWOLD+P4IiCS7C9JCQBHT+bjIAVr45h1eKjgZP50+lLSvflW+o29WCrp13eIYKDbooKWXBBReUOZJYHKNTIDrsrYRQmlNEuY02gwlFB/0TmK8hkjUccg80ivb3DzDCa7TrKUOFhfNDcxbtiGVfPsQz5+++aQfnLIlQYgQFCWrwe3C6AQ/u0IqTtnVoc0lZKToVR5gm/9LSq4C8BEJ6wDDA0z+JUP6QLSCVcXeiXLMPZZfp27gCXSv/iLn4EpdHe9GlsB7txgp71FR4onTYuxNkdL4bA/GWnfPujML8MH+FdJmNMUFx1YZwWulEn2/8Lw=='),
			this.addDataEntry('dashed error', 120, 0, 'Error, Dashed', 'jVLbbsMgDP0aXiearB+wpZenSdUyac+0WIGVQOSQXvb1M5c06bRKe0DC5xwf22BWVu1li6JTb06CYeWalRU659OtvVRgDCu4lqxcsaLgdFixecAuIss7gWD9fxKKlHASZoCEJKD3V5MBsPIF0Z0p2ht3OH4obVn5qnxL3a4WdO09uiNUzjiMKaUsuOCCmD0li310CkJ0g5UQSnOKiNtoM5pQVOvvoHwOkWygzj3QKNpf38EIr51dTwwVFuj/ai4SM/MYz+y/hrYb7a2zMEJJEZqjhAb8DlC34AHrThy0bYLdklgpehXnmMb/1NKrgDwFQXrFMMXDj4lQ/pUtOCqDV5Kcsw+xy/R3XIFulL/HMD7H6d5e9Clsbna3CjunqfAk6d2AB8jofEFG4SU75wW6JeaH+Z1Il9kYExT3bQynvU7y+dr/AA=='),
			this.addDataEntry('dashed error', 120, 0, 'Error, Dashed', 'jVLJboMwEP0aXysHmg9oyXKqFJVDz048ArfGgwaTpV/f8ZJAIkXqAcnztmHsEWXVnbek+vYDNVhRrkVZEaJPp+5cgbWikEaLciWKQvInis0TdhFZ2SsC5/9jKJLhqOwICUnA4C82A+D0GxGeuHLoGHxvfcc/ulrwcfCEP1ChRYrqUhdSScXMnn1qH0OCkHB0GkJXyRVzG2PtVNXmNyhfQ6UbqHN7nsL4yydY5Q269cRwY0X+4b8iNsuN9Sz5e+z6a3K2RCgpgoMNDfgdkOnAA9W9OhjXhBGWzGo1tHGEafIvo30bkJcgSHcXBnj6HBHKb7EF5DZ0Yckp5zC7TC8mWzBN6+8xijdxvI9XQyqbW9ytww4NN54kA450gIzO1+IqPOfkvDY3Y76YRyMfZmNMUNyyazltc5LPl/0P'),
			this.addDataEntry('dashed error', 120, 20, 'Error, Dashed', 'jVPdT4MwEP9reDUFnPHV4TYfNFkyE5/reoO60iPHMYd/vYW2G1OX+EDS+33cV0uSF/VxRbKpXlCBSfJFkheEyP5UHwswJsmEVkn+mGSZcF+SLa+w6ciKRhJY/o8h84aWewMeAVXCJoRIXGGJVprFGZ0TdlbBkEC46Kx5RmwcmDrwA5j7jf4aksiO0UEV1yawO7QcyPTexS0T7qFAgzT2kKtMSCGDcilrbXpHPIE5AOttJKJBwU52xo07Z0kl8BpI18BAm0ZutS2HMjPHglWh6u1YVBJPYiXbahwq9dIHIvx04bvB7f610tbDS23iGL7tN624GpCbWcwarRYtRCz4ho35lQ97vnppIxRubAXopqHeSQiMZH249MnWh+VJd7KuUbuMmTgGQ3gMog+XLy4zhPV50/TRxDxR2GJHW/gldHPLfiJrBkF7vZ878XeZS/pHt0HtDr5cjCaLOkPja4/h+a/y8ulP9w0='),
			this.addDataEntry('dotted error', 120, 0, 'Error, Dotted', 'jVPLbsMgEPwarhXBzQe0zuMUKWoq9UzCytBgsDDOo1/f5WU7lSL1YImdnZndhTWp6va2dbyTOytAk2pNqtpZ69OpvdWgNWFUCVKtCGMUP8I2T7KLmKUdd2D8fwQsCS5cD5CQBPT+rjMARrw5Z68YHbU9nT+lMqR6l77FblcLPPbe2TPUVlsXJZVglFOOmSOK+TE6BaKzgxEQSlOMMLdRuphgdFA/gfkaItHAIfeAoyh//wDNvbJmPWWwMHe+NGesGbHsS0s8c/4e2q44Z0mEEiMoUNCA34NTLXhwh46flGlCm0vMCt7LOMI0+ZcSXgbkpRD23KPSRBajoWy61jDW05eKUH6mLVgs7u5IuWZ3zC7TY1IJqpH+EXPxfi6P9rxPYTPajRX2VmHhidLbwZ0go/ONKcRbds4bNQrzdf0V4mE2xgTFBSzhtOiJPv8PfgE='),
			this.addDataEntry('dotted error', 120, 0, 'Error, Dotted', 'jVNJbsMwDHyNroViNw9oneVUwGgK9KxEhKVGFg1ZztLXl1ocO0UD9GBAnBkOSYlmZdVetk506g0lGFauWVk5RJ9O7aUCY1jBtWTlihUFp48VmwfsIrK8Ew6s/09CkRJOwgyQkAT0/moyAFa+OIdnivYGD8cPpS0rX5VvqdvVgo69d3iECg26mFLKggsuiNlTsthHpyB0OFgJoTSniLiNNqMJRTv9HZTPIZIN7HIPNIr213cwwmu064mhwsL5v5qLxMw8xjP7r6HtRnuLFkYoKUJzlNCAr8HpFjy4XScO2jbBbkmsFL2Kc0zjf2rpVUCeRkEtPGXaqCp4KJvuNsz28LkilN9qC0jF3ZUk5+xO7DK9KFegG+XvMRcv6XRvL/oUNje7W4UaNRWeJD0O7gAZna/NKLxk57xWt8R8Xb8T6TAbY4LiFo7htO1JPv8ZfgA='),
			this.addDataEntry('dotted error', 120, 0, 'Error, Dotted', 'jVPLboMwEPwaXyvHNB/QksepUtQcenbiFbg1NlpMAv36rh8EEilSD0i7szOzXnthRdkMe5Rt/eEUGFZsWVGicz5FzVCCMUxwrVixYUJw+pjYPamuYpW3EsH6/whEElyk6SEhCej8aDIAVr0huitl1lkC32vf0EE3Kwo7j+4HSmccRnahBJdcUuVEOnmKJoGIrrcKQldOGdV22pg5O+rfwHwNmargmNvTFNqPn2Ck185u5wo1lugfzhWxhW/MF87ffdNOzlkSocQIChJU4A+AugEPeGzlWdsqjLCmqpJdHUeYJ//SytcBeZkIB+lJaSNL8NA23WgY6+kjRSi/0B4cNceRKNfsTtV1ekdeg65qf49hvJ/Lvb3sUlrd7G4dDk5T45nSuR7PkNHlskzEITvnZboJ83U9CilYjDFDcfemdN7xRF/+An8='),
			this.addDataEntry('dotted error', 120, 20, 'Error, Dotted', 'jVNfT4MwEP80vJoCzvjqcJsPmiyZic91vUFd6ZFyzOGn96DtxtQlPpDw+3d3XEuSF/Vx5WRTvaACk+SLJC8cIvm3+liAMUkmtEryxyTLBD9JtryipqMqGunA0n8CmQ+01BvwDKgSNgGiowpLtNIszuzcYWcVDAUEo7PnGbFhMmXyA4j6jf4aisiOkKmKahPUHVoKYnrPuCWHeyjQoBtnyFUmpJDBuZS1Nj0LT2AOQHobhRhQsJOd4c+dk3Ql0BqcroHAbRq51bYc2sxYBatC19uxqXQ0waw+OIefDN8NbvevlbaeXmoTJ/eTvmlF1cDczGKhGLVoIXIhNyxJybYaN5YGsJbEA9qRycTQ3x/EsP2rRzlS4RxXgPyNrmeLAyNJHy5zsvWwPPlO0TVqrpiJYwiEKyL6cCXEZYWwVB+aXqVYJxpb7NwWfhl5NbKf2JrB0F6f50783eZS/jFtcPOLbxfRZFFnavwHIjz/a94+/RW/AQ=='),
			this.addDataEntry('warning', 120, 0, 'Warning', 'jVLbasMwDP0av440Xj5gS9c+DQYb7NmJRWLqWMFx2mRfP/mSSxmFPRikc46OLNmMl910tqJv31GCZvyN8dIiuhh1UwlaszxTkvEjy/OMDstPD9hDYLNeWDDuPwV5LLgKPUJEIjC4WScAjHyxFm+UVRrry1erDOOvrevotscDhYOzeIESNdpQwmteFFlGTEXFogpOXmhxNBJ8a08Sd1J6MaHsU/145fNq+a2kaz3/VARMWHenoXy5mkEDC5ZcfY84DcgGHi4oQGk7Z8AOnJ1Jcku9iS3iDrMWVNO6e8yCFk5d7+3FENNmtVs7fKCixptkwNHWkND9Qy3CKTmnh1wLadAG3J9C2oeYd7LeC4a9goLdoBsUfsaSbj8wyvcf9Bc='),
			this.addDataEntry('warning', 120, 0, 'Warning', 'jVJJbsMwDHyNroVj1w9oneVUIGgK9KzYhK1GFg1aztLXl1q8pGiAHgSIM5whKVFkRXvdkeyaN6xAi2wjsoIQbbi11wK0FmmiKpGtRZomfES6fcCuPJt0ksDY/wjSIDhLPUBAAtDbm44AmOqFCC8cHTWWp49GGZG9NrblbtcrvvaW8AQFaiQvycosz5OEmSOL5dE7uUTCwVTgSjuSua3SowlHB/XtMp9dVNVwiD3wKMre3kFLq9BsZoYLS7J/NeeJhbmPF/ZfQ9uN9gYNjFDIcM2xoAa7B1ItWKBDJ0tlameXTxN/qso2DnpyWHg41/jDv/BQ/IgdIDvTjVMu0YfZPHxX0oCqG3uPkX+B87297ENYT3ZThT0qLjyn9DhQCRFd7sSYeI3OcWcmYXyL30K+LMaYIb9iYzivckhfbvoP'),
			this.addDataEntry('warning', 120, 0, 'Warning', 'jVJNb4MwDP01uU4pGT9go2tPlSbtsHPaWBAtYBRCC/v1cz4KYVOlHSLZ7z0/x06YqNrpaGXfnFCBYeKNicoiuhi1UwXGsIJrxcSeFQWnw4rDA3YXWN5LC537T0ERC67SjBCRCAxuNgmATr1YizfKOuwIfG1cSxfd7ygcnMUvqNCgDWpxEWXJOTFnqpPnYOKFFsdOge/qSeIO2pg1+9DfXvm8WH5q5Rpf+1QGTFq30VD+61YBy1zjIKBqeLibAKXFHAFbcHYmyS31JraM6+MN6LpxW8yCkU5ft/ZyiGm92C0d3lFT41Uy4GgvkND8je7CKTmnN1wKadAa3J9C2oecM1nvBUOuoCAbdIXCp7in6+eL8vxv/gA='),
			this.addDataEntry('warning', 120, 20, 'Warning', 'jVPdT4MwEP9reDUdiPHV4TYfNFkyE58r3KCu9Eg55vCv96DtYOoSH0h6v4/7aomSrD5trGyqFyxAR8kqSjKLSO5UnzLQOoqFKqLkMYpjwV8Ur6+wi5EVjbRg6D+G2Bla6jU4BIoSdj5ESxWWaKReTejSYmcKGBIIjibNM2LD4ILBDyDqd+prSCI7QoYqqrVn92jIk4t7jluyeIAMNdqxhyRP0lQIr1zLWumeiSfQRyCVS08EQwF72Wked0nSlkBbsKoGArtrZK5MOZRJmQVT+Kq3Y1FpaRYz+2AtfnL4rjE/vFbKOHitdOjcdfqmCqoG5CYNiYLVoIGAed8wh9vysNqr9zRC/pI2gDyA7VliQUtSx0ufbF1YnnVn6xYVZ4zFyRv8/Yve37e4zOA35kzzdxLyBGGLnc3hl5Dnlv1M1gyC9no/d+LvMpf0j269mg+uXIhmi5qg8YGHcPqRnHz+n30D'),
			this.addDataEntry('dashed warning', 120, 0, 'Warning, Dashed', 'jVLJbsMgEP0arhUx9Qe0znKKFDWVeiZmZGgwWBhn6dd3WLykUqQekJg3772ZgSGsam87xzu5twI0YRvCKmetT7f2VoHWpKBKELYmRUHxkGL7JLuKWdpxB8b/R1AkwYXrARKSgN7fdQbAiDfn7BWjk7b1+VMqQ9i79C12u17htffOnqGy2rooYTUrS0oxc0IxP0WnQHR2MAJC6ZDE3Fbp0QSjo/oJzNcQiQaOuQccRfn7B2julTWbOYOFufNjc8aaCcu+dIwXzt9D243OWRKhxAgKFDTgD+BUCx7cseO1Mk1os8Ss4L2MI8yTfynhZUBeAiE9YBjg6Z9EKH/IDiyWcXekXLMPZsv0bVSCaqR/xFx8icujPe9T2Ex2U4WDVVh4pvR2cDVkdLkbI/GWnfPuTML8MH+FeFmMMUNx1cZwXulEX278Lw=='),
			this.addDataEntry('dashed warning', 120, 0, 'Warning, Dashed', 'jVLbboMwDP2avE4Uxgds9PI0qRqT9pwSi2QNMQqhl339nAuFTqu0h0jxOcfHdmJWVN1lZ3kv31CAZsWGFZVFdPHWXSrQmuWZEqxYszzP6LB8+4BdBTbruQXj/pOQx4QT1yNEJAKDu+oEgBEv1uKZooPG5vghlWHFq3Qddbte0XVwFo9QoUYbUoqmKMssI+ZAyfwQnLzQ4mgE+NKeJG6r9GRCUa2+vfLZR6KFOvVAoyh3fQfNnUKzmRkqzK37q7lALMxDvLD/Grt+sjdoYIKiwjdHCS24PVjVgQNb97xRpvV2JbGCDzLMMY//qYSTHnnygviKfoqHHxOg9Cs7QCpjryQ5Jx9iy/h3mQTVSneP2fAcp3t7PsSwvdndKuxRUeFZMuBoG0jockEm4SU5pwW6JaaH+Z1Il8UYMxT2bQrnvY7y5dr/AA=='),
			this.addDataEntry('dashed warning', 120, 0, 'Warning, Dashed', 'jVJLb4MwDP41uU4Uxg/Y6OM0qRqHndPGgmwhRia0dL9+zqOFVqq0A1L8vYwTi6Lqph3Jvv1ABUYUG1FUhOjiqZsqMEbkmVaiWIs8z/gT+fYJuwps1ksC6/5jyKPhJM0IEYnA4C4mAWDVGxGeubJoGXxvXcc/ul7xcXCEP1ChQQrq4liUZZYxc2CfPIQQLyQcrQLf1ZPMbbUxc1XrX6989ZVqoE7teQrtLp9gpNNoNzPDjSW5h/8K2CI31Ivk77Hrr8nJEqCo8A42NOD2QLoDB1T38qht40comVVyaMMI8+RfWrnWIy9eEO/OD/D0OQKU3mIHyG3owpJzymG2jC+WtaCb1t1jFG7idB8vh1g2t7hbhz1qbjxLBhzpCAldrsVVOKXktDY3Y7qYRyMfFmPMUNiyazlvc5Qvl/0P'),
			this.addDataEntry('dashed warning', 120, 20, 'Warning, Dashed', 'jVPdT4MwEP9reDUFxPjqcJsPmiyZic8VblBXeuQ45vCvt9B2Y+oSH0h6v4/7aonSvDmuSbb1C5ago3QZpTkhsjs1xxy0jhKhyih9jJJE2C9KVlfYeGJFKwkM/8eQOEPHgwaHQFnB1odIXGOFRurlGV0Q9qaEMYGw0VnzjNhaMLbgBzAPW/U1JpE9o4VqbrRnd2jYk/G9jTsm3EOOGmnqIS3SLBPCK1eyUXqwxBPoA7AqpCeCoYSd7LUdd8GSKuANkGqAgbatLJSpxjKZZcGUvurtVFQSz+JSdvU0VOykD0T4acN3jcX+tVbGwSulwxiu7TdVcj0iN1nIGqwGDQTM+8ah3MrHPV+9tAnyN7YGtNPQYCUEWrI6XPpk58LqpDtZN6hsxkQcvcE/BjH4yxeXGfz6nGn+aEKeIOywpwJ+Ce3ccpjJ2lHQXe/nTvxd5pL+0a1X24MrF6LZos7Q9NpDeP6rnHz+030D'),
			this.addDataEntry('dotted warning', 120, 0, 'Warning, Dotted', 'jVPJbsMgEP0arhUx9Qe0znKKFDWVeiZmZGgwWBhn6dd3WLykUqQeLDFv3nszA2PCqva2c7yTeytAE7YhrHLW+nRqbxVoTQqqBGFrUhQUP1Jsn2RXMUs77sD4/wiKJLhwPUBCEtD7u84AGPHmnL1idNK2Pn9KZQh7l77FbtcrPPbe2TNUVlsXJaxmZUkpZk4o5qfoFIjODkZAKB2SmNsqPZpgdFQ/gfkaItHAMfeAoyh//wDNvbJmM2ewMHd+bM5YM2HZl47xwvl7aLvROUsilBhBgYIG/AGcasGDO3a8VqYJbZaYFbyXcYR58i8lvAzIy0g4cI9KE1kFDWXTtYaxnr5UhPIz7cBicXdHyjW7Y7ZMj0klqEb6R8zF+7k82vM+hc1kN1U4WIWFZ0pvB1dDRpcbMxJv2Tlv1CTM1/VXiIfFGDMUF3AM50VP9OV/8As='),
			this.addDataEntry('dotted warning', 120, 0, 'Warning, Dotted', 'jVPLbsMgEPwarhUx9Qe0zuNUyWoq9UzMytBgsDDOo1/f5eHYqRqpB0vszOzsLqwJq7rLzvFevlkBmrANYZWz1qdTd6lAa1JQJQhbk6Kg+JFi+4BdRZb23IHx/0koUsKJ6xESkoDBX3UGwIgX5+wZo4O2zfFDKkPYq/Qddrte4XHwzh6hstq6mMIaVpaUInPAZH6ITkHo7GgEhNKBRG6r9GSC0V59B+VziEQL+9wDjqL89R0098qazcxgYe78X81FYmEe44X919j1k72xBiYoKUJzmNCCr8GpDjy4fc8bZdpgVyIr+CDjHPP4n0p4GZCnSVBzj5kmqgoayqa7DbM9fK4I5bfagcXi7oqSc3ZHtkwvSiWoVvp7zMVLOt3b8yGF7c3uVqG2CgvPksGOroGMLtdmEl6yc16rW2K+rt+JeFiMMUNxC6dw3vYkX/4MPw=='),
			this.addDataEntry('dotted warning', 120, 0, 'Warning, Dotted', 'jVPJboMwEP0aXysHyge0ZDlVQs2hZwePwK2x0WCS0K/veCGQSJF6QPK8bTy2YXnZXQ8o+vbDStAs37G8RGtdXHXXErRmGVeS5VuWZZw+lu2fsJvA8l4gGPcfQxYNZ6FHiEgEBjfpBICRb4j2QpWxhsD31nW00e2GloND+wOl1RaDOq/zouCcmBP5xCmEeCHa0UjwXT1J3F5pvVRH9euVr76SDRxTe5pCuekTtHDKmt3CUGOB7mFfAVvlhnqV/D12/ZycLAGKCu8gQwOuAlQdOMBjL2plGj9CQawUQxtGWCb/UtK1HnmZBZVw5DRBlXHfNp6oH+vpJQUo3dABLDXHiSSXlE5sEe+Rt6Ca1t1jGM7nfB8vhlg2t7hbh8oqarxIBjtiDQldP5ZZeE3J6THdjOm4Ho20WI2xQOHtzeXyxqN8/Qv8AQ=='),
			this.addDataEntry('dotted warning', 120, 20, 'Warning, Dotted', 'jVNLT4NAEP41XM0CYrxabOtBkyY18bzCFNYuO2QZavHXO7C7LVWbeCDhe83MvqI0b45rK9v6BUvQUbqM0twikvtrjjloHSVClVH6GCWJ4C9KVlfUeFJFKy0Y+k8gcYGOBg2OgbKCrYdoqcYKjdTLM7uw2JsSxgKC0dnzjNgyGTP5AUTDVn2NRWRPyFRNjfbqDg15Mb5n3JHFPeSo0U4zpEWaZUJ450o2Sg8sPIE+AKlCeiEEStjJXvNyFyRtBbQBqxogsNtWFspUY5uMVTCl73o7NZWWZpjVB2vxk+G7xmL/Wivj6JXSYXI36ZsqqR6ZmywUClGDBgLnc+M6StnV047FHmwk8YBmYhIx9ncHMe7+1aOcKH+Oa0Beox3YYkFLUofLnOwcrE6+U3SDiism4ugD/oqIwV8JcVnBb6oLza9SqBOMHfa2gF9G3ho5zGztaOiuz3Mn/m5zKf+Y1rv5x7ULaLZRZ2p6AwGe35qzz5/iNw=='),
			this.addDataEntry('success', 120, 0, 'Success', 'jVJNa8MwDP01vo58rJAdt3TtqTDYYGenEYmpYwXFaZP9+im281FGYQeD9N7TkyVbpHkzHEm29QlL0CJ9F2lOiNZHzZCD1iKJVCnSvUiSiI9IDg/Y2LFRKwmM/U9B4guuUvfgEQ90dtQBAFO+EuGNs0Lj+fJVKyPSt9o2fNt9zGFnCS+Qo0ZyJWmcZS9xxkzBxbJwTpOQsDclTK0jzpg7KD2bcPapfibl82L5rUpbT/zTzmGS7J2G8/lqBg3MWHCdevhpoKzg4YIcFLZzBGzA0siSW+jN7M7vMKpBVbW9xwi0tOp6by87n1aL3dLhAxU3XiUd9nSGgG4fahYOwTk85FLIg1Zg/xTyPuS4kbWToNsqONgMukLuZ8zp+gO9fPtBfwE='),
			this.addDataEntry('success', 120, 0, 'Success', 'jVLbTsMwDP2avKJemDQeoWN7QpoYEs/ZarVhaVy56S58Pc6llyEm8RAp5/j42E4s8qK5bEi29RuWoEX+KvKCEG24NZcCtBZZokqRr0SWJXxEtr4TTX00aSWBsf9JyELCSeoeAhOIzl51JMCUz0R4ZrTXeDh+1MqI/KW2DXe7SvnaWcIjFKiRfEqeLpdP6ZIje06We+/khIS9KcGVThhxbK30YMJop76d8tGhsoJd7IFHUfb6DlpaheZ1inBhSfav5nxgZu7xzP6rb9rB3qCBgQoK1xwnVGC3QKoBC7Rr5UGZytktxok/VWlrRz04Ljyca/zuX3gqfsQGkJ3pypJz9OHoInxXUoOqanvLkX+B06297AKsRruxwhYVF54kHfZ0gMjOd2IQXqJz3JkxMb7F70S+zMaYKL9iA5xWOcjnm/4D'),
			this.addDataEntry('success', 120, 0, 'Success', 'jVJNb4MwDP01uU58rBI7bnTtqdKkHXZOFwuiBYxMaGG/fiZJIWyqtEMkv+fn59iJyMtmPJLs6hMqMCJ/FXlJiNZHzViCMSJLtBL5XmRZwkdkhzvZ1GWTThK09j8FmS+4SDOAZzzR28kEAlr1TIRXRi22TL7UtuGL7lMOe0v4BSUaJKfO06J4SgvOnLlOnp3JLCQcWgVz14QR5w7amBW96+9Z+bhYfmhl67n2Yec4SXajYfzrVo6LXP0goCq4uxtHhcUcARuwNLHkGnpzdufXl9Sgq9puOQIjrb5s7WXvYbXYLR3eUHPjVdLjQJ8Q2PiNbsIxOIc3XAp50Arsn0Leh5wiWTcL+ljBQTToSrlPcYPr5/Py+G/+AA=='),
			this.addDataEntry('success', 120, 20, 'Success', 'jVPNTsMwDH6aXlHaMjSObGzjANKkIXEOrdeGpXGVumPl6XGbZO2ASRwqxd+P7dhplC6r08bKunzBHHSUrqJ0aRHJnarTErSOEqHyKH2MkkTwFyXrK2w8sKKWFgz9x5A4Q0OdBodAXsDOh2ipxAKN1KsRXVhsTQ59AsHRqHlGrBmMGfwAom6nvvoksiVkqKRKe3aPhjwZzzluyOIBlqjRDj2k8Xx+PzC9ci0rpTsmnkAfgVQmPREMOexlq/m6C5K2ANqCVRUQ2F0tM2WKvsyMWTC5r3o7FJWWJjGzD9biJ4fvGrPDa6mMg9dKh85dp28qp7JHbmYhUbAaNBAw7+uH5Kbcj/bqngbIL2kDyBewHUssaEnqeOmTjQuLs+5s3aLijIk4eYPfv+j8vsVlBj8xZ5q+k5AnCBtsbQa/hHxv2U1kdS9orvdzJ/4uc0n/6Nar+eDKhWgyqBEaHngIxx/Jyaf/2Tc='),
			this.addDataEntry('dashed success', 120, 0, 'Success, Dashed', 'jVLJagMxDP0aX8ssDaTHdrKcCqEp9OzEYuzGYw8aT5Z+feVllhQCPRisp/eeJFusrJrrFnkr360Azco1Kyu01sVbc61Aa1ZkSrByxYoio8OKzYNsHrJZyxGM+4+giIIz1z1EJAKdu+kEgBGviPZC0UHb4+lTKsPKN+ka6naV07VzaE9QWW0xSMp8uXzJl5Q5kJgfgpMnou2NAF86o4hyG6UHE4r26sczn30katinHmgU5W4foLlT1qynDBXm6IbmjDUjlnyzIZ45f/dNOzgnSYAiwytIUIPbAaoGHOC+5Udlat/mgrKCdzKMME3+pYSTHnnyhPiAfoCHfxKg9CFbsFQGb0S5JB/KLuK3ZRJULd09huElzvf2vIthPdqNFXZWUeGJ0tkej5DQ+W4MxGtyTrszCtPD/BXSZTbGBIVVG8JppSN9vvG/'),
			this.addDataEntry('dashed success', 120, 0, 'Success, Dashed', 'jVK5bsMwDP0arYWPBkjH1jmmAkEzdFYiwlYjiwYt5+jXlzoSOwECdDAgvoumRFFW7XlNsms+UYER5VKUFSG6eGrPFRgjikwrUS5EUWT8iWL1hM0Dm3WSwLr/GIpoOEozQEQi0LuLSQBY9U6EJ64sWgY/Gtfyjy5yPvaO8AAVGqSgLvP5/C2fM7Njn9yFEC8kHKwC3zXjirmVNmastvrXK199pWrYpvY8hXaXLzDSabTLkeHGktzDfwVskhvqSfLP0HbX5GQJUFR4BxtqcBsg3YID2nZyr23tR5gxq2TfhBHGyb+1co1HXrwg3p0f4OlzBCi9xRqQ29CFJaeUw+wsvljWgK4bd49RuInjfbzsY1nf4m4dNqi58SjpcaA9JHS6FlfhOSWntbkZ08U8GvkwGWOEwpZdy3Gbo3y67H8='),
			this.addDataEntry('dashed success', 120, 0, 'Success, Dashed', 'jVJJbsMwDHyNroWXBkiPrbOcCgRNgZ6ViLCUyJJBy1n6+lKLY6dogB4EiDPDISmRlVVzWSNv5bsVoFm5ZGWF1rp4ay4VaM2KTAlWLlhRZHRYsXrA5oHNWo5g3H8Siphw4rqHiESgc1edADDiFdGeKdppuz9+SmVY+SZdQ90ucrp2Du0RKqsthpQyn89f8jkxO0rmu+DkhWh7I8CXzigibqX0YELRVn175bOPRA3b1AONotz1AzR3yprlyFBhju6v5gIxMQ/xxP7QN+1gb6yBAYoK3xwl1OA2gKoBB7ht+V6Z2tvNiBW8k2GOcfwvJZz0yJMXxFf0Uzz8mAClX1mDpTJ4Jck5+RA7i3+XSVC1dPcYhuc43dvzLob1ze5WYWMVFR4lne1xDwmdLsggvCTntEC3xPQwvxPpMhljhMK+DeG411E+Xfsf'),
			this.addDataEntry('dashed success', 120, 20, 'Success, Dashed', 'jVNfT4MwEP80vJoCzsxHN7f5oMmSmfhc6Q3qSo+UYw4/vS1tB1OX+EDC79/dcS1JvqxPG8Ob6gUFqCRfJfnSIJJ/q09LUCrJmBRJ/phkGbNPkq2vqOmgsoYb0PSfQOYDLfUKPAOihF2AaKjCEjVXq5FdGOy0AFeAWTR6nhEbS6aW/ACifie/XBHeEVqqoloFdY+agpjOLW7J4AGWqNAMM+TpfH4/KM655rVUvRWeQB2BZMGDEAMC9rxT9nMXxE0JtAUjayAwu4YXUpeuzcyqoEXoejs05YYm2KoPxuCnhe8Ki8NrJbWn11LFyf2kb1JQ5ZibWSwUoxo1RC7k3JIEb6thY66IX7nb89VDG6hwYhtA+zWmtxYDipM8XuZ462F59p2jW5S2YsZOIRAuA+vD4bPLCmF9PjS9NLFONLbYmQJ+Ge0SeD+xNc7QXp/njv3d5lL+MW1w2xffLqLJokZquO0Rjn+Vt09/um8='),
			this.addDataEntry('dotted success', 120, 0, 'Success, Dotted', 'jVPLasMwEPwaXYtsN5AeW+dxKoSm0LMSLZYaWTKynEe/vquX7RQCPRi0szOzu9KaVHV73VrWiXfDQZFqTaraGuPiqb3WoBQpqeSkWpGypPiRcvMgW4Qs7ZgF7f4jKKPgzNQAEYlA724qAaD5q7XmgtFBmePpU0hNqjfhWux2VeCxd9acoDbK2CCpiuXypVhi5oBidghOnmjNoDn40hQjzG2kyiYY7eWPZz77iDewTz3gKNLdPkAxJ41eTxkszKzLzWmjRyz50hzPnL+HtsvOSRKgyPAKFDTgdmBlCw7svmNHqRvf5gKznPUijDBN/iW5Ex55yoQdc6jUgVVSXzZeqx/r4UsFKD3TFgwWtzekXJI7ZhfxMakA2Qh3j9lwP+d7e9bHsBntxgo7I7HwROnNYI+Q0PnGZOI1OaeNGoXpuv4K8TAbY4LCAuZwWvRIn/8Hvw=='),
			this.addDataEntry('dotted success', 120, 0, 'Success, Dotted', 'jVNJbsMwDHyNroWXBkiPrbOcCgRNgZ6ViLCUyKIhy1n6+lKLY6dogB4MiDPDISnRrKyay9ryVr6jAM3KJSsri+jiqblUoDUrMiVYuWBFkdHHitUDNg9s1nILxv0noYgJJ657iEgEOnfVCQAjXq3FM0U7jfvjp1SGlW/SNdTtIqdj5yweoUKNNqSU+Xz+ks+J2VEy3wUnL7TYGwG+dEYRcSulBxOKturbK599JGrYph5oFOWuH6C5U2iWI0OFuXV/NReIiXmIJ/aHvmkHe4MGBigqfHOUUIPbgFUNOLDblu+Vqb3djFjBOxnmGMf/UsJJjzwNgg13lGmCqsh82Xi3fraHzxWg9FZrQCpuryQ5J3diZ/FFMwmqlu4es+GSTvf2vIthfbO7VdigosKjpMPe7iGh07UZhJfknNbqlpiu63ciHSZjjFDYwiEctz3Kpz/DDw=='),
			this.addDataEntry('dotted success', 120, 0, 'Success, Dotted', 'jVO7bsMwDPwarYUfDZCOrdNkKhA0Q2clImy1smjQch79+lIPx06AAB0MkMe7oyjRoqza84Zk13ygAiPKd1FWhOhi1J4rMEYUmVaiXImiyPgTxfpBNQ/VrJME1v1HUETBUZoBIhKB3l1MAsCqVyI8cWbRMvjWuJYPuso57B3hD1RokAK7zJfLl3zJlT3r5D6YeCLhYBX4rhlnXFtrY6Zsp38989lnqoZdas9TaHf5BCOdRvs+VbixJHd3roDNfEM+c/4e2m50TpIARYZXsKAGtwXSLTigXScP2tZ+hAVXleybMMI0+ZdWrvHI00jYSsdKG1hF5tvGG/VjPXykAKUX2gByc7ow5ZTcubqI75g1oOvG3WIU7ud4ay/7mNZXu2uHLWpuPFF6HOgACZ0vy0g8J+e0TFdhuq57IQezMSYo7N6YTjse6fNf4A8='),
			this.addDataEntry('dotted success', 120, 20, 'Success, Dotted', 'jVNfT4MwEP80vJoCzsxHN7f5oMmSmfhcxw3qSo+UYw4/vVfabkxd4gMJv393x7Uk+bw+rqxsqhcsQCf5IsnnFpH8W32cg9ZJJlSR5I9Jlgl+kmx5RU0HVTTSgqH/BDIfaKnX4BkoStgEiJYqLNFIvTizM4udKcAVEIzOnmfEhsmUyQ8g6jfqyxWRHSFTFdU6qDs0FMR0yrgli3uYo0Y7zJCn0+n9oDjnUtZK9yw8gT4Aqa0MQgwUsJOd5s+dkbQl0BqsqoHAbhq5VaZ0bSasgilC19uhqbQ0wqw+WIufDN81bvevlTKeXiodJ/eTvqmCKsfcTGKhGDVoIHIh55ZUyLYaNpYGsJbEA5qByYTr7w/Cbf/qUQ5UOMcVIH+j7dliQUtSh8ucbD0sT75TdI2KK2biGALhiog+XAlxWSEs1YfGVynWicYWO7uFX0ZejexHtsYZ2uvz3Im/21zKP6YNbn7x7SIaLepMDf9AhOd/zdvHv+I3'),
			this.addDataEntry('accent', 120, 0, 'Accent 3', 'jVLbasMwDP0avw43WT9gddY+FQYb7NmpRWLqRMFx2mRfP/mSSxmFPRikc46OLNksF814srKrz6jAsPyd5cIiuhg1owBjWMa1YnnBsozTYdnxCbsLLO+khdb9pyCLBTdpBohIBHo3mQRAq96sxTtlpcHL9avWLcsPtWvotsWOwt5ZvIJAgzaU5OLAeSGIKalYlsHJCy0OrQLfmlNG3FGb2YSyT/3jla+L5bdWrvb8yz5g0roHDeXz1VpsYcaSq+8RpwFVwdMFBSht5wTYgLMTSe6pN7H7uENeg65q94hZMNLp26O97GNaLXZLhw/U1HiV9DjYCyR0+1CzcEzO6SGXQhq0AvenkPYhp42s84J+q6BgM+gKhZ8xp+sPjPLtB/0F'),
			this.addDataEntry('accent', 120, 0, 'Accent 3', 'jVJJbsMwDHyNroViNw9onOVUIGgK9KzEhK1WFg1aztLXl1q8pGiAHgRohsMhKVHkRXPdkWrrVyzBiHwj8oIQXbw11wKMEZnUpcjXIsskH5FtH0QXISpbRWDdfxKymHBWpofIRKJzN5MIsOULEV4YHQ2evt5rbUW+ql3D3a4XfO0c4RcUaJBCSl6spFwXHDlysjoGJy8k7G0JvrRkxLGtNoMJo4P+9spnj8oKDqkHHkW72xsY5TTazRThworcX82FwMw84Jn9Z9+0g71FCwMVFb45TqjA7YF0Aw7o0KqTtpW3W44Tf+jS1Z568lx8ON/4w78IVPqIHSA7040ll+TD0WX8LlmDrmp3z1F4gfO9veoirEa7scIeNReeJB32dILEzndiEF6Tc9qZMTG9xe9EvszGmKiwYgOcVjnK55v+Aw=='),
			this.addDataEntry('accent', 120, 0, 'Accent 3', 'jVLBboMwDP2aXKcU1g9YYe2p0qQddk4XC6IFjExoYV8/k6QQNlXaIZLf8/Nz7ETkRTOeSHX1GTVYkb+KvCBEF6JmLMBakUmjRV6KLJN8RHZ8kN35rOwUQev+U5CFgquyAwQmEL2bbCSg1S9EeGPUYsvkoXYNX7Tccdg7wi8o0CJ5dV4cpCwLzly4Tl28ySwkHFoNc1fJiHNHY+2K3s33rHxeLD+MdvVc+7T3nCK30TD+dSvPJa5hENAVPNyNp+JiToANOJpYcou9ObsP65M1mKp2W47AKmeuW3vVB1gtdkuHNzTceJX0ONAnRDZ9o7twjM7xDZdCHrQC96eQ96GmRNbNgj5VcJAMulL+U9zh+vmCPP2bPw=='),
			this.addDataEntry('accent', 120, 20, 'Accent 3', 'jVPNTsMwDH6aXlHWMsSVdWwcQJo0JM5h9dqwNK5cb6w8PW6TbB0wiUOl+PuxHTtNsrw+Lkk31QsWYJPsMclyQmR/qo85WJukyhRJNk/SVMmXpIsr7GRgVaMJHP/HkHpDy50Fj0BRwjqESFxhiU7bxzM6I9y7AvoESqKz5hmxEXAi4Acwd2vz1SfRe0aBKq5tYLfoOJCTe4lbJtxBjhZp6CHLZ0rN86Bc6NrYTognsAdgs9GBiIYCtnpv5boz1lQCr4BMDQy0bvTGuLIvMxUWXBGq3g5FNfEoFvaBCD8lfLe42b1Wxnl4YWzs3Hf6ZgqueuRmGhNFq0MHEQu+fkh+yv1or+5pgMKSloByAepEQmA1m8OlT7c+LE+6k3WFRjKm6hgMYf+qC/tWlxnCxLxp/E5inihscU8b+CWUe+tuJGt6QXu9nzv1d5lL+ke3QS0HXy5Go0GdoeGBx/D8I3n5+D/7Bg=='),
			this.addDataEntry('dashed accent', 120, 0, 'Accent 3, Dashed', 'jVJJbsMwDHyNroViNw9onOVUIGgK9KxEhKVGlgxaztLXl1q8pECAHgSIw5khKZGVVXPboWjVu5NgWLlhZYXO+XRrbhUYwwquJSvXrCg4HVZsn2QXMctbgWD9fwRFElyE6SEhCej83WQArHxDdFeKjsadzp9KW1aulG+o2/WCrp1Hd4bKGYdRUlYrztcVZY4kFsfoFIjoeishlOYUUW6rzWBC0UH/BOZriGQNh9wDjaL9/QOM8NrZzZShwgL90Jx1dsSyLx/imfN337SDc5ZEKDGCggQ1+D2gbsADHlpx0rYObS4pK0Wn4gjT5F9aehWQl0BIDxgGePonEcofsgNHZfBOlGv2oewyfRtXoGvlHzGML3F5tBddCuvRbqywd5oKT5TO9XiCjM53YyDesnPenVGYH+avkC6zMSYortoQTiud6PON/wU='),
			this.addDataEntry('dashed accent', 120, 0, 'Accent 3, Dashed', 'jVLbbsMgDP0aXiearB+wppenStU6ac+0WIGV4IiQXvb1M5c06bRKe0DC5xwf22BWVs1140SrtijBsHLFysoh+nRrrhUYwwquJSuXrCg4HVasn7CzyPJWOLD+PwlFSjgL00NCEtD5m8kAWPnmHF4oOhg8nj6UtqxcKN9Qt8sZXTvv8AQVGnQxpawWnC8rYg6ULA7RKQgd9lZCKM0pIm6tzWBC0V5/B+VriGQN+9wDjaL97R2M8BrtamSosHD+r+YiMTGP8cT+q2/awd6ihQFKitAcJdTgd+B0Ax7cvhVHbetgNydWik7FOcbxP7X0KiAvQZBeMUzx9GMilH9lA0hl3I0kl+xD7Dz9HVega+UfMRef4/xoL7oU1ne7e4Udaio8Sjrs3REyOl2QQXjNznmB7on5YX4n0mUyxgjFfRvCca+TfLr2Pw=='),
			this.addDataEntry('dashed accent', 120, 0, 'Accent 3, Dashed', 'jVLJbsIwEP0aXyuTlA8oYTkhoXLo2eBR4tbxRBOHpV/f8QIJSEg9RPK8bTL2iLJqLxtSXbNFDVaUK1FWhOjTqb1UYK0opNGiXIqikPyJYv2CnUVWdorA+f8YimQ4KTtAQhLQ+6vNADj9QYRnrhw6BheNb/lHlzM+9p7wByq0SFFdVgsplxUzB/apQwwJQsLBaQhdJVfMrY21Y7U3v0H5Hipdwz635ymMv36CVd6gW40MN1bkn/4rYpPcWE+Sv4e2uyVnS4SSIjjYUIPfAZkWPNC+U0fj6jDCnFmt+iaOME7+ZbRvAvIWBOnuwgAvnyNC+S02gNyGriw55xxm5+nFZAOmbvwjRvEmTo/xqk9lfY+7d9ih4cajpMeBjpDR6VrchJecnNfmbswX82zkw2SMEYpbdivHbU7y6bL/AQ=='),
			this.addDataEntry('dashed accent', 120, 20, 'Accent 3, Dashed', 'jVPdT4MwEP9reDUFnPHVMTcfNFkyE58r3KCu9MhxzOFfb6HtYOoSH0h6v4/7aonSrD5tSDbVCxago/QxSjNCZHeqTxloHSVCFVG6ipJE2C9K1lfYeGRFIwkM/8eQOEPLvQaHQFHCzodIXGGJRurHCV0SdqaAIYGw0aR5RmwsGFvwA5j7nfoaksiO0UIV19qzezTsyfjexi0THiBDjTT2kGZLIVaZV65lrXRviSfQR2CVS08EQwF72Wk77pIllcBbIFUDA+0amStTDmUWlgVT+Kq3Y1FJPIsL2VbjULGTPhDhpw3fNeaH10oZB6+VDmO4tt9UwdWA3CxC1mA1aCBg3jdszK182PPVSxshf2MbQDsN9VZCoCWr46VPti4sz7qzdYvKZkzEyRv8YxC9v3xxmcGvz5nmjybkCcIWO8rhl9DOLfuZrBkE7fV+7sTfZS7pH916tT24ciGaLWqCxtcewumvcvL5T/cN'),
			this.addDataEntry('dotted accent', 120, 0, 'Accent 3, Dotted', 'jVNJbsMwDHyNroViNw9onOVUIGgK9KxEhK1GFg1ZztLXl9psp0CAHgyIw5khKdGsrNrbzoqueUcJmpUbVlYW0cVTe6tAa1ZwJVm5ZkXB6WPF9kl2EbK8ExaM+4+giIKL0ANEJAK9u+sEgJFv1uKVoqPG0/mzUYaVq8a11O16QcfeWTxDhRptkJTVivN1RZkjicUxOHmixcFI8KU5RZTbKp1NKDqoH8989ZGs4ZB6oFGUu3+AFk6h2UwZKiysy80ZNCOWfHmOZ87fQ9tl5yQJUGR4BQlqcHuwqgUH9tCJkzK1b3NJWSn6JowwTf6lpGs88pIJe+FIaQKr4L5svFY/1tOXClB6ph0gFbd3olyTO2WX8TF5A6pu3CNmw/1cHu1FH8N6tBsr7FFR4YnS42BPkND5xmTiLTmnjRqF6br+CukwG2OCwgLmcFr0SJ//B78='),
			this.addDataEntry('dotted accent', 120, 0, 'Accent 3, Dotted', 'jVNJbsMwDHyNroViNw9onOUUIGgK9KxEhKVGlgxaztLXl1ocO0UD9GBAnBkOSYlmZdVcNyhatXUSDCtXrKzQOZ9OzbUCY1jBtWTlkhUFp48V6yfsLLK8FQjW/yehSAlnYXpISAI6fzMZACvfEN2FooNxx9OH0paVC+Ub6nY5o2Pn0Z2gcsZhTCmrBefLipgDJYtDdApCdL2VEEpziohbazOYULTX30H5GiJZwz73QKNof3sHI7x2djUyVFig/6u5SEzMYzyx/+qbdrC3zsIAJUVojhJq8DtA3YAH3LfiqG0d7ObEStGpOMc4/qeWXgXkZRDshKdMG1UFD2XT3YbZnj5XhPJbbcBRcbyR5JLdiZ2nF+UKdK38I4bxks6P9qJLYX23u1fYOU2FR0nnejxCRqdrMwiv2Tmv1T0xX9fvRDpMxhihuIVDOG57kk9/hh8='),
			this.addDataEntry('dotted accent', 120, 0, 'Accent 3, Dotted', 'jVPbbsIwDP2avE6hHR8wCuxpEhoPew7EarOlceWmXPb1cy6lBQlpD5Xs43OO48QVZdVe3kl1zQdqsKLciLIiRJ+i9lKBtaKQRotyLYpC8ieK7ZPqIlZlpwic/4+gSIKTsgMkJAG9v9oMgNNvRHjmzKFjcNX4lg+6XnDYe8IfqNAiRXZZraRcV1w5sE4dokkgEg5OQ+gqOePa1lg7ZXvzG5ivIdM17HN7nsL46ydY5Q26zVThxor8w7kiNvON+cz5e2i70TlLIpQYQcGCGvwOyLTggfadOhpXhxGWXNWqb+II0+RfRvsmIC8jYac8K11kFTK0TTcaxnr6SBHKL/QOyM3pypRzdufqMr2jbMDUjb/HKN7P6d5e9Smtb3a3Djs03Hii9DjQETI6X5aReMnOeZluwnxdj0IOZmNMUNy9MZ12PNHnv8Af'),
			this.addDataEntry('dotted accent', 120, 20, 'Accent 3, Dotted', 'jVNfT4MwEP80vJoCzvjqmJsPmiyZic8VblBXeqQcc/jpPWg7mLrEBxJ+/+6Oa4nSrD5trGyqFyxAR+ljlGYWkdxbfcpA6ygRqojSVZQkgp8oWV9R41EVjbRg6D+BxAVa6jU4BooSdh6ipQpLNFI/TuzSYmcKGAoIRpPnGbFhMmbyA4j6nfoaisiOkKmKau3VPRryYnzPuCWLB8hQox1nSLOlEKvMO9eyVrpn4Qn0EUjl0gshUMBedpo/d0nSlkBbsKoGArtrZK5MObRZsAqm8F1vx6bS0gyz+mAtfjJ815gfXitlHL1WOkzuJn1TBVUDc7MIhULUoIHA+dywpEK21bix2IOtJB7QjEwihv7uIIbtXz3KkfLnuAHkb7Q9WyxoSep4mZOtg+XZd45uUXHFRJx8wF8R0fsrIS4r+KW60PwqhTrB2GJnc/hl5NXIfmZrBkN7fZ478XebS/nHtN7NL65dQLNFTdT4DwQ4/WvOPv8VvwE='),
			this.addDataEntry('accent', 120, 0, 'Accent 2', 'jVJNb4MwDP01uU6UjN1XWHuaNGmTdg6NRaKGGIXQwn79DAlfmirtEMl+fn4vdsJ4XvdnJxr1jhIM42+M5w7Rh6juczCGpYmWjBcsTRM6LD09qB6matIIB9b/pyENDTdhOghIAFo/mAiAla/O4Z2y0uDl+qW0ZfyofE23LQ4Utt7hFXI06KYWnhX85USWx5KaRTkpjUSHnZUwWieUUe2kzSxC2af+GZnPi+S3ll6N9adswoTzOw7l89UsWpixqDp6hGlAVvBwQRMUt3MGrMG7gSj36E3VLOwwUaAr5feYAyO8vu3lRRvSapFbHD5Qk/FKabFzF4jo9qFmYh+V40MujTRoBf5PI+1DDBtaMxLaLYOCzaArNP2MOV1/YKBvP+gv'),
			this.addDataEntry('accent', 120, 0, 'Accent 2', 'jVJJbsMwDHyNroVj1703znIqEDQFelZiwlYjiwYtZ+nrSy1eUjRADwLE4cyQlCiyorluSbb1G5agRbYWWUGINtyaawFaizRRpchWIk0TPiLdPMgufDZpJYGx/xGkQXCWuoeABKCzNx0BMOUrEV44Omg8nj5qZUS2rG3D3a4WfO0s4QkK1EhekuWr7GXDJZcHFsuDd3JEwt6U4EonHHFuo/RgwtFefTvms4vKCvaxBx5F2ds7aGkVmvWU4cKS7F/N+cTM3Mcz+6++aQd7gwYGKDBccyyowO6AVAMWaN/KozKVs8vHiT9VaWsHPTksPJxr/OFfeCh+xBaQnenGlEv04WweviupQVW1vcfIv8D53l52IaxGu7HCDhUXnigd9nSEiM53YiBeo3PcmVEY3+K3kC+zMSbIr9gQTqsc6PNN/wE='),
			this.addDataEntry('accent', 120, 0, 'Accent 2', 'jVJNb4MwDP01uU6UjN1XGD1NmrTDzuliQbSAkQkt7NfPJCkfmyrtEMnv+fk5diJk3ownUl39ihqskC9C5oToQtSMOVgr0sRoIQuRpgkfkZZ3sgefTTpF0Lr/FKSh4KLsAIEJRO8mGwlo9TMRXhm12DJ5rF3DFy0OHPaO8AtytEheLbNCPpXc7XjmOnX2JrOQcGg1zF0TRpwrjbUrejffs/Jxsfww2tVz7UPmOUVup2H861ae27iGQUBXcHc3noqLOQE24GhiyTX25mwW1pfUYKra7TkCq5y57O1VH2C12C0d3tBw41XS40CfENntG92EY3SOb7gU8qAVuD+FvA81bWTdLOi3Cg42g66U/xQ3uH6+IN/+zR8='),
			this.addDataEntry('accent', 120, 20, 'Accent 2', 'jVPNboMwDH4arlMKa7XrSkt32KRKnbRzBi5kDTEypit7+gWStHRbpR2Q4u/HduwQJWl92pBsqhcsQEfJOkpSQmR3qk8paB3FQhVRsoriWNgvirMb7GxkRSMJDP/HEDtDy70Gh0BRws6HSFxhiUbq9QVdEnamgCGBsNFF84zYWHBmwQ9g7nfqa0giO0YLVVxrz+7RsCdnDzZumfAAKWqksYdkvkoWWeaVmayV7i3xBPoIrHLpiWAoYC87ba+7ZEkl8BZI1cBAu0bmypRDmbllwRS+6v1YVBJPYss+EuGnDd815ofXShkHZ0qHzl2nb6rgakDu5iFRsBo0EDDvG4bkpjyM9uaeRsgvaQNoL0C9lRBoyep47ZOtC8uz7mzdorIZY3HyBr9/0ft9i+sMfmLONH0nIU8QtthRDr+E9t6yn8iaQdDe7mch/i5zTf/o1qvtwZUL0WRQF2h84CG8/EhOPv3PvgE='),
			this.addDataEntry('dashed accent', 120, 0, 'Accent 2, Dashed', 'jVLLbsMgEPwarpVjmt4bp8mpUtRU6pmElaHBYK1xHv36Lg8/UilSD0js7MzsLizjVXPdomjVu5NgGH9jvELnfLo11wqMYWWhJeNrVpYFHVZuHmQXMVu0AsH6/wjKJDgL00NCEtD5m8kAWPmK6C4UHYw7nj6VtoyvlG+o2/WCrp1Hd4LKGYdRwpdr/rKhkqsDicUhOgUiut5KCKULiii30WYwoWivfwLzOUSyhn3ugUbR/vYBRnjt7NuUocIC/dCcdXbEsm8xxDPn775pB+csiVBiBAUJavA7QN2AB9y34qhtHdpcUlaKTsURpsm/tPQqIE+BkB4wDPDwTyKUP2QLjsrgjSiX7EPZZfq2QoGulb/HML7E+d5edCmsR7uxws5pKjxROtfjETI6342BeM3OeXdGYX6Yv0K6zMaYoLhqQzitdKLPN/4X'),
			this.addDataEntry('dashed accent', 120, 0, 'Accent 2, Dashed', 'jVLLbsMgEPwarpVjmt4b53GqFDWVeiZhZWgwWGucR7++y8OxUzVSD0jszOzsLizjVXPZoGjVm5NgGF8xXqFzPt2aSwXGsLLQkvElK8uCDivXD9hZZItWIFj/n4QyJZyE6SEhCej81WQArHxFdGeK9sYdjh9KW8YXyjfU7XJG186jO0LljMOYwudL/rKmkos9JYt9dApCdL2VEEoXFBG31mYwoWinv4PyOUSyhl3ugUbR/voORnjt7GpkqLBA/1dzkZiYx3hi/9U37WBvnYUBSorQHCXU4LeAugEPuGvFQds62M2JlaJTcY5x/E8tvQrIUxCkVwxTPPyYCOVf2YCjMnglyTn7EDtPf1co0LXy9xjG5zjd24suhfXN7lZh6zQVHiWd6/EAGZ0uyCC8ZOe8QLfE/DC/E+kyGWOE4r4N4bjXST5d+x8='),
			this.addDataEntry('dashed accent', 120, 0, 'Accent 2, Dashed', 'jVJLb4MwDP41uU4U1t1XaHuaVK2HndPGgmwhRib0sV8/51GglSrtgBR//h44sSjK9rIl2TUfqMCIYi2KkhBdPLWXEowReaaVKCqR5xl/It886S5CN+skgXX/EeRRcJJmgIhEoHdXkwCw6p0Iz1xZtAyuGtfyj1YLPvaO8AdKNEiBXSyr4m3DaasD6+QhmHgi4WAV+NSMK+5ttDFTtde/nvnqK1XDPsXzFNpdP8FIp9Gupw4HS3IP/xWwmW+oZ87fQ9vdnJMkQJHhFSyowe2AdAsOaN/Jo7a1H2HJXSX7JowwTf6llWs88uIJ8e78AE+fI0DpLbaAHENXppyTD3eX8cWyBnTduHuMwk2c7u1lH8t6tBsTdqg5eKL0ONAREjpfixvxkpzT2ozCdDGPQj7MxpigsGW3ctrmSJ8v+x8='),
			this.addDataEntry('dashed accent', 120, 20, 'Accent 2, Dashed', 'jVNbT4MwFP41vJoCbvHVsTEfNFkyE58rPYO60kPKYQ5/vYW2g6lLfCDp+S7n1hKlWX3eGt5ULyhARekmSjODSO5UnzNQKkqYFFG6jpKE2S9K8htsPLKs4QY0/ceQOENLvQKHgChh70M0VGGJmqvNhK4MdlrAkIDZaNI8IzYWjC34AUT9Xn4NSXhHaKGKauXZA2ryZPxg45YMHiFDhWbsIV2s02Wee2XOa6l6SzyBOgHJgnsiGAQceKfsuCvipgTagZE1EJh9wwupy6HMwrKgha96Pxblhmax4G01DhU76aMx+GnDd4XF8bWS2sG5VGEM1/abFFQNyN0iZA1WjRoC5n3DxtzKhz3fvLQR8je2BbTTmN5KDChO8nTt460Ly4vuYt2htBkTdvYG/xhY7y+fXWfw63Om+aMJeYKwxc4U8Eto5+b9TNYMgvZ2P0v2d5lr+ke3Xm0PrlyIZouaoPG1h3D6q5x8/tN9Aw=='),
			this.addDataEntry('dotted accent', 120, 0, 'Accent 2, Dotted', 'jVPLbsMgEPwarhUxTe+N0+RUKWoq9UzCytBgsDDOo1/f5WU7lSL1YImdnZndhTVhdXvdOt7JdytAE/ZGWO2s9enUXmvQmlRUCcLWpKoofqTaPMguYpZ23IHx/xFUSXDmeoCEJKD3N50BMOLVOXvB6KDt8fQplSFsJX2L3a4XeOy9syeorbYuSthyzV42WHJ1QDE/RKdAdHYwAkJpihHmNkoXE4z26icwn0MkGtjnHnAU5W8foLlX1rxNGSzMnS/NGWtGLPvSEs+cv4e2K85ZEqHECAoUNOB34FQLHty+40dlmtDmErOC9zKOME3+pYSXAXkqhB33qDSRVdFQNl1rGOvhS0UoP9MWLBZ3N6Rcsjtml+kxqQTVSH+PuXg/53t73qewGe3GCjursPBE6e3gjpDR+cYU4jU7540ahfm6/grxMBtjguIClnBa9ESf/we/'),
			this.addDataEntry('dotted accent', 120, 0, 'Accent 2, Dotted', 'jVNJbsMwDHyNroVjNb03znIqEDQFelYiwlIji4YsZ+nrSy2OnaIBejAgDmeGpEQzXjWXjROtekMJhvEV45VD9OnUXCowhpWFlowvWVkW9LFy/SA7i9miFQ6s/4+gTIKTMD0kJAGdv5oMgJWvzuGZor3Bw/FDacv4QvmGul3O6Nh5h0eo0KCLEj5f8pc1lVzsSSz20SkQHfZWQihdUES5tTaDCUU7/R2YzyGSNexyDzSK9td3MMJrtKsxQ4WF8381FxMT8xhP7L/6ph3sLVoYoMQIzZGgBr8Fpxvw4HatOGhbB7s5ZaXoVJxjHP9TS68C8jQQtsKT0kZWWYSy6W7DbA+fK0L5rTaAVNxdiXLO7pSdpxctFOha+XvMxUs63duLLoX1ze5WYYuaCo+UDnt3gIxO12YgXrJzXqubMF/XbyEdJmOMUNzCIRy3PdGnP8MP'),
			this.addDataEntry('dotted accent', 120, 0, 'Accent 2, Dotted', 'jVPJboMwEP0aXysCpfeGLKdKUXPo2YlH4NZ40GCy9Os7XggkUqQekDxv3uKxjSiq9rIl2TUfqMCIYi2KihBdXLWXCowReaaVKFYizzP+RL550l2EbtZJAuv+I8ij4CTNABGJQO+uJgFg1TsRnrmyaBlcNq7lja4WvOwd4Q9UaJACuyhXxduG05YH1slDMPFEwsEq8KkZV9zbaGOmaq9/PfPVV6qGfYrnKbS7foKRTqNdTx0OluQe9hWwmW+oZ87fQ9uNzkkSoMjwChbU4HZAugUHtO/kUdvaj1ByV8m+CSNMk39p5RqPvIyEnXSstIGVZz42nqgf6+klBSjd0BaQw+nKlHNy524Z7zFrQNeNu8conM/p3l72saxvdreEHWoOnig9DnSEhM4fy0i8JOf0mG7CdFyPQl7Mxpig8PbGcnrjkT7/Bf4A'),
			this.addDataEntry('dotted accent', 120, 20, 'Accent 2, Dotted', 'jVNfT4MwEP80vJoCbvHVsTEfNFkyE5/ruEFd6ZFyzOGn96DtxtQlPpDw+3d3XEuUZvVpbWVTvWABOkpXUZpZRHJv9SkDraNEqCJKl1GSCH6iJL+hxqMqGmnB0H8CiQu01GtwDBQlbD1ESxWWaKReXdiFxc4UMBQQjC6eZ8SGyZjJDyDqt+prKCI7QqYqqrVX92jIi/ED45YsHiBDjXacIZ0t03mee2cua6V7Fp5AH4HUTnohBArYy07z5y5I2hJoA1bVQGC3jdwpUw5tZqyCKXzX+7GptDTBrD5ai58M3zXuDq+VMo7OlQ6Tu0nfVEHVwNzNQqEQNWggcD43LKmQbTVuLPZgI4kHNCOTiKG/O4hh+zePcqT8Oa4B+RttzxYLWpI6Xudk62B59p2jG1RcMREnH/BXRPT+SojrCn6pLjS9SqFOMLbY2R38MvJqZD+xNYOhvT3PXPzd5lr+Ma1384trF9BkURdq/AcCvPxrzj79Fb8B'),
			this.addDataEntry('accent', 120, 0, 'Accent 1', 'jVJNa8MwDP01vo40Xlmva7r2NBhssLPTiMTUsYLitMl+/eTY+SijsINBenp6z5ItZFb3J1JN9Y4FGCHfhMwI0YWo7jMwRqSJLoQ8iDRN+Ij0+KC6GatJowis+09DGhquynQQkAC0bjARAFu8EuGNs9zg+fJVaSvkvnI13/aw4bB1hBfI0CCNLTJ52ckdW+5zblb5qOSJhJ0twFsnnHHtqM0kwtmn/vHM51nyWxeu8vWn7YgpcncczqerWbQwYVHVe4RpoCjh4YJGKG7nBFiDo4Ept+jN1W3YYVKBLit3jxEY5fT1Xl61IS1nudnhAzUbL5QWOzpDRNcPNRH7qBwfcm7kQUtwfxp5H2pY0RpPaNcMDlaDLtD4M6Z0+YGBvv6gvw=='),
			this.addDataEntry('accent', 120, 0, 'Accent 1', 'jVJJbsMwDHyNroVjN2iujbOcCgRNgZ6VmLDVyKJBy1n6+lKLlxQN0IMAcTgzJCWKLK+vW5JN9YYFaJGtRZYTog23+pqD1iJNVCGylUjThI9INw+yM59NGklg7H8EaRCcpe4gIAFo7U1HAEzxSoQXjg4aj6ePShmRLStbc7erGV9bS3iCHDWSl2TJyyJbcMnlgcXy4J0ckbAzBbjSCUec2yjdm3C0V9+O+eyiooR97IFHUfb2DlpahWY9ZriwJPtXcz4xMffxxP6rq5ve3qCBHgoM1xwLSrA7IFWDBdo38qhM6ezmw8SfqrCVg54cFh7ONf7wLzwUP2ILyM50Y8ol+nB2Hr4rqUCVlb3HyL/A+d5etiEsB7uhwg4VFx4pLXZ0hIhOd6InXqNz3JlBGN/it5AvkzFGyK9YH46rHOjTTf8B'),
			this.addDataEntry('accent', 120, 0, 'Accent 1', 'jVLBboMwDP2aXCdKVq3Xla49TZq0w87pYkG0gJEJLezrZ5IUwqZKO0Tye35+jp0IWdTDiVRbvaIGK+SLkAUhuhDVQwHWijwzWsiDyPOMj8iPd7Ibn81aRdC4/xTkoeCibA+BCUTnRhsJaPQzEV4ZNdgwua9czRc9bDjsHOEXFGiRvFpmTzu54277M9epszeZhIR9o2HqmjHi3NFYu6B38z0pH2fLD6NdNdU+bD2nyK00jH/dynOJaxgEdAl3d+OpuJgTYA2ORpZcY2/ObsP6sgpMWbk1R2CVM5e1veoCLGe7ucMbGm68SDrs6RMim77RTThE5/iGcyEPWoL7U8j7UGMiaydBlyo4SAZdKP8pbnD5fEGe/s0f'),
			this.addDataEntry('accent', 120, 20, 'Accent 1', 'jVPNTsMwDH6aXlHWMtiVjXUcQJo0JM6h9dqwNK5Sd6w8PW6TrB0wiUOl+PuxHTuNklV12lhZly+Yg46SdZSsLCK5U3VagdZRLFQeJY9RHAv+oji9ws4GVtTSgqH/GGJnaKjT4BDIC9j5EC2VWKCRej2iS4utyaFPIDgaNc+INYMzBj+AqNuprz6JbAkZKqnSnt2jIU/OFhw3ZPEAK9Rohx4Scb9IFqlXprJSumPiCfQRSGXSE8GQw162mq+7JGkLoC1YVQGB3dUyU6boy8yZBZP7qrdDUWlpEjP7YC1+cviuMTu8lso4OFU6dO46fVM5lT1yMw+JgtWggYB5Xz8kN+V+tFf3NEB+SRtAvoDtWGJBS1LHS59sXFicdWfrFhVnjMXJG/z+Ref3LS4z+Ik50/SdhDxB2GBrM/gl5HvLbiKre0FzvZ878XeZS/pHt17NB1cuRJNBjdDwwEM4/khOPv3PvgE='),
			this.addDataEntry('dashed accent', 120, 0, 'Accent 1, Dashed', 'jVLJbsMgEP0arhUxjZpr4yynSlFTqWcSRoYEg4Vxln59h8VLKkXqAYl5896bGRjCyvq2dbyRH1aAJmxNWOms9elW30rQmhRUCcJWpCgoHlJsnmRnMUsb7sD4/wiKJLhw3UFCEtD6u84AGPHunL1idND2eP6SyhC2lL7GblczvLbe2TOUVlsXJYy+LdgCSy4PKOaH6BSIznZGQChNMcLcRuneBKO9+gnM1xCJCva5BxxF+fsnaO6VNesxg4W5831zxpoBy760jyfOp65ueucsiVBiBAUKKvA7cKoGD27f8KMyVWhzjlnBWxlHGCf/VsLLgLwEQnrAMMDTP4lQ/pAtWCzj7ki5Zh/MztO3UQmqkv4Rc/ElLo/2vE1hNdgNFXZWYeGR0trOHSGj093oibfsnHdnEOaH+SvEy2SMEYqr1ofjSif6dON/AQ=='),
			this.addDataEntry('dashed accent', 120, 0, 'Accent 1, Dashed', 'jVJJbsMwDHyNroVjNWiujbOcCgR1gZ6VmLDUyKIhy1n6+lKLY6dogB4EiDPDISmR8aK5bK1o5RtWoBlfM15YRBdvzaUArVmeqYrxFcvzjA7LNw/YWWCzVlgw7j8JeUw4Cd1DRCLQuatOAJjq1Vo8U7TXeDh+SGUYX0rXULerGV07Z/EIBWq0IYVnLwu+oJLLPSWLfXDyQou9qcCXzigibqP0YEJRqb698tlHVQ1l6oFGUe76Dlo4hWY9MlRYWPdXc4GYmId4Yv/VN+1gb9DAAEWFb44SanA7sKoBB7ZsxUGZ2tvNia1EJ8Mc4/ifqnLSI09eEF/RT/HwYwKUfmULSGXslSTn5EPsPP5dJkHV0t1jNjzH6d5edDGsb3a3CjtUVHiUdNjbAyR0uiCD8JKc0wLdEtPD/E6ky2SMEQr7NoTjXkf5dO1/AA=='),
			this.addDataEntry('dashed accent', 120, 0, 'Accent 1, Dashed', 'jVLJboMwEP0aXysCjZprQ5ZTpagcenbiEbg1HjSYLP36jpcEEilSD0ieN29h7BFF2Z63JLvmAxUYUaxFURKii6f2XIIxIs+0EsVK5HnGn8g3T7qz0M06SWDdfwR5FBylGSAiEejdxSQArHonwhNXFi2Dy8a1/KOrGR97R/gDJRqkwC6yt0Wx4LTlnnVyH0w8kXCwCnxqxhX3NtqYsar0r2e++krVUKV4nkK7yycY6TTa9djhYEnu4b8CNvEN9cT5e2i7q3OSBCgyvIIFNbgdkG7BAVWdPGhb+xHm3FWyb8II4+RfWrnGIy+eEO/OD/D0OQKU3mILyDF0Ycop+XB3Hl8sa0DXjbvHKNzE8d5e9rGsb3a3hB1qDh4pPQ50gIRO1+JKPCfntDY3YbqYRyEfJmOMUNiyazluc6RPl/0P'),
			this.addDataEntry('dashed accent', 120, 20, 'Accent 1, Dashed', 'jVNbT4MwFP41vJoCTvfqcMwHTZbMxOdKz6Cu9JBymMNfb6HtYOoSH0h6vsu5tURpVp82hjfVCwpQUbqO0swgkjvVpwyUihImRZQ+RknC7Bcl+RU2HlnWcAOa/mNInKGlXoFDQJSw8yEaqrBEzdV6QlcGOy1gSMBsNGmeERsLxhb8AKJ+J7+GJLwjtFBFtfLsHjV5Ml7auCWDB8hQoRl7SNn9Ml3mXpnzWqreEk+gjkCy4J4IBgF73ik77oq4KYG2YGQNBGbX8ELqciizsCxo4avejkW5oVkseFuNQ8VO+mAMftrwXWFxeK2kdnAuVRjDtf0mBVUDcrMIWYNVo4aAed+wMbfyYc9XL22E/I1tAO00prcSA4qTPF76eOvC8qw7W7cobcaEnbzBPwbW+8tnlxn8+pxp/mhCniBssTMF/BLauXk/kzWDoL3ezx37u8wl/aNbr7YHVy5Es0VN0PjaQzj9VU4+/+m+AQ=='),
			this.addDataEntry('dotted accent', 120, 0, 'Accent 1, Dotted', 'jVPLasMwEPwaXYtiNTTXxnmcCqEp9KxEi61Elows59Gv7+plO4VADwbt7MzsrrQmrGxuW8vb+sMIUIStCSutMS6emlsJSpGCSkHYihQFxY8UmyfZWcjSllvQ7j+CIgouXPUQkQh07q4SAFq8W2uuGB2UOZ6/aqkJW9auwW5XMzx2zpozlEYZGySMvi3YAksuDyjmh+Dkidb0WoAvTTHC3EaqbILRXv545quPRAX71AOOIt39ExR30uj1mMHC3LrcnDZ6wJIvzfHE+dQ3bXZOkgBFhlegoAK3AysbcGD3LT9KXfk255gVvKvDCOPk31K42iMvmbDjDpU6sArqy8Zr9WM9fakApWfagsHi9o6Ua3LH7Dw+Jq1BVrV7xGy4n8ujPe9iWA12Q4WdkVh4pHSmt0dI6HRjMvGWnNNGDcJ0XX+FeJiMMUJhAXM4LnqkT/+DXw=='),
			this.addDataEntry('dotted accent', 120, 0, 'Accent 1, Dotted', 'jVPLbsMgEPwarhUxjZpr4zxOlaymUs8krAwNBgvjPPr1XR6OnaqRerDEzs7M7sKasLK5bB1v5ZsVoAlbE1Y6a306NZcStCYFVYKwFSkKih8pNg+ys5ilLXdg/H8ERRKcuO4hIQno/FVnAIx4dc6eMdprezh+SGUIW0rfYLerGR477+wRSqutixJGXxZsgSWXexTzfXQKRGd7IyCUphhhbqP0YILRTn0H5nOIRA273AOOovz1HTT3ypr1mMHC3Pm/mouJiXmMJ/ZffdMO9sYaGKDECM2hoAZfgVMNeHC7lh+UqYPdHLOCdzLOMY7/qYSXAXkaCBX3qDSRVdBQNt1tmO3hc0Uov9UWLBZ3V6Scsztm5+lFqQRVS3+PuXhJp3t73qWwvtndKlRWYeGR0tneHSCj07UZiJfsnNfqJszX9VuIh8kYIxS3cAjHbU/06c/wAw=='),
			this.addDataEntry('dotted accent', 120, 0, 'Accent 1, Dotted', 'jVPJboMwEP0aXysHGjXXhiynSqgcenbiEbg1NhpMln59xwuBRIrUA5LnzVs8tmF50V72KLrmw0rQLN+yvEBrXVy1lwK0ZhlXkuUblmWcPpbtnnQXocs7gWDcfwRZFJyEHiAiEejdVScAjHxHtGeqjDUErhvX0kY3C1r2Du0PFFZbDOycv63yFaWtD6QTh2DiiWgHI8Gncqqot1NaT1Wlfj3z1VeyhirF0xTKXT9BC6es2U4dChboHvYVsJlvqGfO30Pbjc5JEqDI8AoS1OBKQNWCA6w6cVSm9iMsqStF34QRpsm/lHSNR15GQikcKU1gZdzHxhP1Yz29pAClG9qDpXC8EuWc3Km7jPfIG1B14+4xDOdzurcXfSzrm90tobSKgidKbwc8QkLnj2UkXpJzekw3YTquRyEtZmNMUHh7Yzm98Uif/wJ/'),
			this.addDataEntry('dotted accent', 120, 20, 'Accent 1, Dotted', 'jVNfT4MwEP80vJoOnO7V4TYfNFkyE5/reoO60iPlNoef3oO2g6lLfCDh9+/uuJYky6vTysm6fEEFJskWSZY7RPJv1SkHY5JUaJVkj0maCn6SdHlFnfSqqKUDS/8JpD7QUGvAM6AK2ASIjkos0EqzGNi5w4NV0BUQjAbPM2LN5ITJDyBqN/qrKyIPhEyVVJmg7tBSECczxg053EOOBl0/QybuZ9lsGZxLWWnTsvAE5giktzIIMaBgJw+GP3dO0hVAa3C6AgK3qeVW26JrM2UVrApdb/um0tEIs/rgHH4yfDe43b+W2np6qU2c3E/6phWVHXMzjYVi1KKFyIVctyQlm7Lf2CSAtSQe0PZMKrr+/iC67V89yp4K57gC5G90LVscGEn6eJmTjYfF2XeOrlFzxVScQiBcEdGGKyEuK4Sl+tD4KsU60djgwW3hl5FXI9uRre4MzfV57sTfbS7lH9MGN7/4dhGNFjVQ/T8Q4fCvefv4V/wG'),
			this.addDataEntry('firewall', 120, 0, 'Firewall 2', 'jVLBbsMgDP0a7hS03bNk7WnSpB12psMKaCSOHNIm+/o5gSappko7INnvPT9jg9BlM57IdO4NLQShX4UuCTGmqBlLCEEo6a3QlVBK8hHq+IA9LKzsDEEb/1OgUsHFhAESkoA+TiED0NqCCK+ctdgy+OJiwxetDhz2kfAbSgxIi1pXShayYObMdea8mMxCwqG1MHeVnDF39CFs2Yf/mZXPq+Wnt9ExohlJVwJbw8MpFyiPeAJsINLEkmt2YfYpLUI68LWL9xhBMNFf7u1Nn9J6tVs7vKPnxpukx4G+IKP7bd+EY3bOr7EWRkM1xD+FvG8z7WTdLOj3Cg52g27Q8ry3dPtGSb7/Zb8='),
			this.addDataEntry('firewall', 120, 0, 'Firewall 3', 'jVJNb4MwDP01uadE/ICNfpwmTdph57SxIFrAyJgW9utrSApUU6UdItnvPT/HTpQp6uFEtq0+0EFQ5qBMQYgco3ooIASVae+U2ass03JUdnzB7mZWt5ag4f8UZLHgakMPEYlAx2NIADTujQhvkjXYCPhecS0X3e8k7JjwBwoMSLPaXEyeay3MWerseTaZhIR942DqOpHCHX0Ia/blfyelWSy/veMqIfFK4Ep4OeUMpRFPgDUwjSK5JRdh87gIXYEvK37GCIJlf322t11My8Vu6fCJXhqvkg57ukBCt9t+CIfknF5jKWRLJfCfQtm3HTeydhJ0W4UEm0FXaH7eR7p+oyjf/rI7')
		]);			
	};

	Sidebar.prototype.addSAPFoundationalPalette = function(s, gn, sb)
	{
		var dt = 'sap foundation ';
		var st = 'shape=mxgraph.sap.icon;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;strokeWidth=1;strokeColor=#D5DADD;fillColor=#EDEFF0;gradientColor=#FCFCFC;gradientDirection=west;aspect=fixed;SAPIcon=';		

		this.addPaletteFunctions('sapFoundations', 'SAP / Foundational', false,
		[
			this.createVertexTemplateEntry(st + 'Cloud_Integration_Automation',
				 s * 50, s * 50, '', 'Cloud Integration Automation', null, null, this.getTagsForStencil(gn, 'cloud integration automation', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Audit_Log_Service',
				 s * 50, s * 50, '', 'SAP Audit Log Service', null, null, this.getTagsForStencil(gn, 'audit log service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_BTP,_Cloud_Foundry_runtime',
				 s * 50, s * 50, '', 'SAP BTP, Cloud Foundry Runtime', null, null, this.getTagsForStencil(gn, 'btp cloud foundry runtime', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Keystore_Service',
				 s * 50, s * 50, '', 'SAP Keystore Service', null, null, this.getTagsForStencil(gn, 'keystore service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Event_Broker_for_SAP_Cloud_Applications',
				 s * 50, s * 50, '', 'SAP Event Broker for SAP Cloud Applications', null, null, this.getTagsForStencil(gn, 'event broker for cloud applications', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Cloud_Identity,_SAP_Malware_Scanning_Service',
				 s * 50, s * 50, '', 'SAP Cloud Identity, SAP Malware Scanning Service', null, null, this.getTagsForStencil(gn, 'cloud identity, malware scanning service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Application_Autoscaler',
				 s * 50, s * 50, '', 'Application Autoscaler', null, null, this.getTagsForStencil(gn, 'application autoscaler', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Service_Manager',
				 s * 50, s * 50, '', 'SAP Service Manager', null, null, this.getTagsForStencil(gn, 'service manager', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Application_Logging_service_for_SAP_BTP',
				 s * 50, s * 50, '', 'SAP Application Logging service for SAP BTP', null, null, this.getTagsForStencil(gn, 'application logging service for btp', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_BTP,_Kyma_runtime',
				 s * 50, s * 50, '', 'SAP BTP, Kyma runtime', null, null, this.getTagsForStencil(gn, 'btp kyma runtime', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Cloud_Connector2',
				 s * 50, s * 50, '', 'Cloud Connector', null, null, this.getTagsForStencil(gn, 'cloud connector', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Custom_Domain_service',
				 s * 50, s * 50, '', 'SAP Custom Domain service', null, null, this.getTagsForStencil(gn, 'custom domain service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Connectivity_Service',
				 s * 50, s * 50, '', 'SAP Connectivity Service', null, null, this.getTagsForStencil(gn, 'connectivity service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Destination_service',
				 s * 50, s * 50, '', 'SAP Destination service', null, null, this.getTagsForStencil(gn, 'destination service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Job_Scheduling_service',
				 s * 50, s * 50, '', 'SAP Job Scheduling service', null, null, this.getTagsForStencil(gn, 'job scheduling service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Authorization_and_Trust_Management_service',
				 s * 50, s * 50, '', 'SAP Authorization and Trust Management service', null, null, this.getTagsForStencil(gn, 'authorization and trust management service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Object_Store_on_SAP_BTP',
				 s * 50, s * 50, '', 'Object Store on SAP BTP', null, null, this.getTagsForStencil(gn, 'object store on btp', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Alert_Notification_service_for_SAP_BTP',
				 s * 50, s * 50, '', 'SAP Alert Notification service for SAP BTP', null, null, this.getTagsForStencil(gn, 'alert notification service for btp', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Credential_Store',
				 s * 50, s * 50, '', 'SAP Credential Store', null, null, this.getTagsForStencil(gn, 'credential store', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Cloud_Logging',
				 s * 50, s * 50, '', 'SAP_Cloud_Logging', null, null, this.getTagsForStencil(gn, 'cloud logging', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Monitoring_service_for_SAP_BTP',
				 s * 50, s * 50, '', 'SAP Monitoring service for SAP BTP', null, null, this.getTagsForStencil(gn, 'monitoring service for btp', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Master_Data_Integration',
				 s * 50, s * 50, '', 'SAP Master Data Integration', null, null, this.getTagsForStencil(gn, 'master data integration', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Secure_Login_Service_for_SAP_GUI',
				 s * 50, s * 50, '', 'SAP Secure Login Service for SAP GUI', null, null, this.getTagsForStencil(gn, 'secure login service gui graphical user interface', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Identity_Authentication2',
				 s * 50, s * 50, '', 'Identity Authentication', null, null, this.getTagsForStencil(gn, 'identity authentication', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Identity_Directory2',
				 s * 50, s * 50, '', 'Identity Directory', null, null, this.getTagsForStencil(gn, 'identity directory', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Cloud_Identity_Service',
				 s * 50, s * 50, '', 'SAP Cloud Identity Service', null, null, this.getTagsForStencil(gn, 'identity cloud service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Authorization_Management_Service',
				 s * 50, s * 50, '', 'SAP Authorization Management Service', null, null, this.getTagsForStencil(gn, 'authorization management service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Automation_Pilot',
				 s * 50, s * 50, '', 'SAP Automation Pilot', null, null, this.getTagsForStencil(gn, 'automation pilot', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Continuous_Integration_and_Delivery',
				 s * 50, s * 50, '', 'SAP Continuous Integration and Delivery', null, null, this.getTagsForStencil(gn, 'continuous integration and delivery', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Cloud_Transport_Management',
				 s * 50, s * 50, '', 'SAP Cloud Transport Management', null, null, this.getTagsForStencil(gn, 'cloud transport management', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Content_Agent_Service',
				 s * 50, s * 50, '', 'SAP Content Agent Service', null, null, this.getTagsForStencil(gn, 'content agent service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Personal_Data_Manager',
				 s * 50, s * 50, '', 'SAP Personal Data Manager', null, null, this.getTagsForStencil(gn, 'personal data manager', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Data_Retention_Manager',
				 s * 50, s * 50, '', 'SAP Data Retention Manager', null, null, this.getTagsForStencil(gn, 'data retention manager', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Data_Privacy_Integration',
				 s * 50, s * 50, '', 'SAP Data Privacy Integration', null, null, this.getTagsForStencil(gn, 'data privacy integration', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Document_Management_Service',
				 s * 50, s * 50, '', 'SAP Document Management Service', null, null, this.getTagsForStencil(gn, 'document management service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Solution_Lifecycle_Management_Service',
				 s * 50, s * 50, '', 'SAP Solution Lifecycle Management Service', null, null, this.getTagsForStencil(gn, 'solution lifecycle management service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Cloud_Management_Service',
				 s * 50, s * 50, '', 'SAP Cloud Management Service', null, null, this.getTagsForStencil(gn, 'cloud management service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Software_as_a_Service_Provisioning_Service',
				 s * 50, s * 50, '', 'SAP Software as a Service Provisioning Service', null, null, this.getTagsForStencil(gn, 'software as service provisioning saas', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Landscape_Portal_for_SAP_S4HANA_Cloud_ABAP_Environment',
				 s * 50, s * 50, '', 'Landscape Portal for SAP S/4HANA Cloud, ABAP Environment', null, null, this.getTagsForStencil(gn, 'landscape portal for s4hana cloud abap environment', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'OAuth_20',
				 s * 50, s * 50, '', 'OAuth 2.0', null, null, this.getTagsForStencil(gn, 'oauth 2.0', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_PKI_Certificate_Service',
				 s * 50, s * 50, '', 'SAP PKI Certificate Service', null, null, this.getTagsForStencil(gn, 'pki certificate service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Application_Vulnerability_Report',
				 s * 50, s * 50, '', 'Application Vulnerability Report', null, null, this.getTagsForStencil(gn, 'application vulnerability report', dt).join(' ')),
				 
			//allegedly this isn't a correct stencil, as there is already an "Identity Provisioning" stencil, which should be correct - it exist in the repo as of May 2025, so it is enabled again
			this.createVertexTemplateEntry(st + 'Identity_Provisioning2',
			 	 s * 50, s * 50, '', 'Identity Provisioning', null, null, this.getTagsForStencil(gn, 'identity provisioning', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Private_Link_service',
				 s * 50, s * 50, '', 'SAP Private Link service', null, null, this.getTagsForStencil(gn, 'private link service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Identity_Directory',
				 s * 50, s * 50, '', 'Identity Directory', null, null, this.getTagsForStencil(gn, 'identity directory', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Identity_Provisioning',
				 s * 50, s * 50, '', 'Identity Provisioning', null, null, this.getTagsForStencil(gn, 'identity provisioning', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Identity_Authentication',
				 s * 50, s * 50, '', 'Identity Authentication', null, null, this.getTagsForStencil(gn, 'identity authentication', dt).join(' '))
		]);
	};

	Sidebar.prototype.addSAPIntegrationSuitePalette = function(s, gn, sb)
	{
		var dt = 'sap btp service icons integration suite ';
		var st = 'shape=mxgraph.sap.icon;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;strokeWidth=1;strokeColor=#D5DADD;fillColor=#EDEFF0;gradientColor=#FCFCFC;gradientDirection=west;aspect=fixed;SAPIcon=';		

		this.addPaletteFunctions('sapIntegration Suite', 'SAP / Integration Suite', false,
		[
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_Advanced_Event_Mesh',
				 s * 50, s * 50, '', 'Advanced Event Mesh', null, null, this.getTagsForStencil(gn, 'advanced event mesh', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_API_Managment',
				 s * 50, s * 50, '', 'API Managment', null, null, this.getTagsForStencil(gn, 'api application programming interface managment', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_Cloud_Integration',
				 s * 50, s * 50, '', 'Cloud Integration', null, null, this.getTagsForStencil(gn, 'cloud integration', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_Data_Space_Integration',
				 s * 50, s * 50, '', 'Data Space Integration', null, null, this.getTagsForStencil(gn, 'data space integration', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_Event_Mesh',
				 s * 50, s * 50, '', 'Event Mesh', null, null, this.getTagsForStencil(gn, 'event mesh', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_Integration_Advisor',
				 s * 50, s * 50, '', 'Integration Advisor', null, null, this.getTagsForStencil(gn, 'integration advisor', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_Integration_Assessment',
				 s * 50, s * 50, '', 'Integration Assessment', null, null, this.getTagsForStencil(gn, 'integration assessment', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_Migration_Assessment',
				 s * 50, s * 50, '', 'Migration Assessment', null, null, this.getTagsForStencil(gn, 'migration assessment', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_Open_Connectors',
				 s * 50, s * 50, '', 'Open Connectors', null, null, this.getTagsForStencil(gn, 'open connectors', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Edge_Integration_Cell',
				 s * 50, s * 50, '', 'Edge Integration Cell', null, null, this.getTagsForStencil(gn, 'edge integration cell', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_SAP_Graph',
				 s * 50, s * 50, '', 'SAP Graph', null, null, this.getTagsForStencil(gn, 'graph', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite_-_Trading_Partner_Management',
				 s * 50, s * 50, '', 'Trading Partner Management', null, null, this.getTagsForStencil(gn, 'trading partner management', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Integration_Suite',
				 s * 50, s * 50, '', 'SAP Integration Suite', null, null, this.getTagsForStencil(gn, 'integration suite', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Business_Accelerator_Hub',
				 s * 50, s * 50, '', 'SAP_Business_Accelerator_Hub', null, null, this.getTagsForStencil(gn, 'business accelerator hub', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'API_Business_Hub_Enterprise',
				 s * 50, s * 50, '', 'API Business Hub Enterprise', null, null, this.getTagsForStencil(gn, 'api application programming interface business hub enterprise', dt).join(' '))
		]);
	};

	Sidebar.prototype.addSAPAppDevAutomationPalette = function(s, gn, sb)
	{
		var dt = 'sap btp service services icons app dev automation application development ';
		var st = 'shape=mxgraph.sap.icon;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;strokeWidth=1;strokeColor=#D5DADD;fillColor=#EDEFF0;gradientColor=#FCFCFC;gradientDirection=west;aspect=fixed;SAPIcon=';		

		this.addPaletteFunctions('sapApp Dev Automation', 'SAP / App Dev Automation', false,
		[
			this.createVertexTemplateEntry(st + 'Business_Application_Studio',
				 s * 50, s * 50, '', 'Business Application Studio', null, null, this.getTagsForStencil(gn, 'business application studio', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Build_Work_Zone_-_Standard_Edition',
				 s * 50, s * 50, '', 'SAP Build Work Zone - Standard Edition', null, null, this.getTagsForStencil(gn, 'build work zone standard edition', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Build_Work_Zone_-_Advanced_Edition',
				 s * 50, s * 50, '', 'SAP Build Work Zone - Advanced Edition', null, null, this.getTagsForStencil(gn, 'build work zone advanced edition', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'UI_Theme_Designer',
				 s * 50, s * 50, '', 'UI Theme Designer', null, null, this.getTagsForStencil(gn, 'ui user interface theme designer', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Build_Apps',
				 s * 50, s * 50, '', 'SAP Build Apps', null, null, this.getTagsForStencil(gn, 'build apps', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Build_Code',
				 s * 50, s * 50, '', 'SAP Build Code', null, null, this.getTagsForStencil(gn, 'build code', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Build_Process_Automation',
				 s * 50, s * 50, '', 'SAP Build Process Automation', null, null, this.getTagsForStencil(gn, 'build process automation', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Task_Center',
				 s * 50, s * 50, '', 'SAP Task Center', null, null, this.getTagsForStencil(gn, 'task center', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_BTP,_ABAP_environment',
				 s * 50, s * 50, '', 'SAP BTP, ABAP environment', null, null, this.getTagsForStencil(gn, 'abap environment', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Extensibility_Service',
				 s * 50, s * 50, '', 'Extensibility Services for SAP BTP', null, null, this.getTagsForStencil(gn, 'extensibility for', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Cloud_Application_Programming_Model',
				 s * 50, s * 50, '', 'SAP Cloud Application Programming Model', null, null, this.getTagsForStencil(gn, 'cloud application programming model', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Build',
				 s * 50, s * 50, '', 'SAP Build', null, null, this.getTagsForStencil(gn, 'build', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Application_Frontend_Service',
				 s * 50, s * 50, '', 'Application Frontend Service', null, null, this.getTagsForStencil(gn, 'application frontend service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'HTML5_App_Repository',
				 s * 50, s * 50, '', 'HTML5_App_Repository', null, null, this.getTagsForStencil(gn, 'html5 app repository', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'UI5_flexibility_for_key_users',
				 s * 50, s * 50, '', 'UI5 flexibility for key users', null, null, this.getTagsForStencil(gn, 'ui5 flexibility for key users', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Mobile_Services',
				 s * 50, s * 50, '', 'SAP Mobile Services', null, null, this.getTagsForStencil(gn, 'mobile services', dt).join(' '))
		]);
	};

	Sidebar.prototype.addSAPDataAnalyticsPalette = function(s, gn, sb)
	{
		var dt = 'sap btp service icons data analytics ';
		var st = 'shape=mxgraph.sap.icon;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;strokeWidth=1;strokeColor=#D5DADD;fillColor=#EDEFF0;gradientColor=#FCFCFC;gradientDirection=west;aspect=fixed;SAPIcon=';		

		this.addPaletteFunctions('sapData Analytics', 'SAP / Data Analytics', false,
		[
			this.createVertexTemplateEntry(st + 'SAP_Master_Data_Governance',
				 s * 50, s * 50, '', 'SAP Master Data Governance', null, null, this.getTagsForStencil(gn, 'master data governance', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Analytics_Cloud_Embedded_Edition',
				 s * 50, s * 50, '', 'SAP Analytics Cloud Embedded Edition', null, null, this.getTagsForStencil(gn, 'analytics cloud embedded edition', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Analytics_Cloud',
				 s * 50, s * 50, '', 'SAP Analytics Cloud', null, null, this.getTagsForStencil(gn, 'analytics cloud', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Datasphere',
				 s * 50, s * 50, '', 'SAP Datasphere', null, null, this.getTagsForStencil(gn, 'datasphere', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_HANA_Spatial_Services',
				 s * 50, s * 50, '', 'SAP HANA Spatial Services', null, null, this.getTagsForStencil(gn, 'hana spatial services', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Persistence_Service_ASE',
				 s * 50, s * 50, '', 'SAP Persistence Service ASE', null, null, this.getTagsForStencil(gn, 'persistence service ase', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_HANA_Cloud',
				 s * 50, s * 50, '', 'SAP HANA Cloud', null, null, this.getTagsForStencil(gn, 'hana cloud', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Business_Data_Cloud',
				 s * 50, s * 50, '', 'SAP Business Data Cloud', null, null, this.getTagsForStencil(gn, 'business data cloud', dt).join(' '))
		]);
	};

	Sidebar.prototype.addSAPAIPalette = function(s, gn, sb)
	{
		var dt = 'sap btp service icons ai artificial intelligence ';
		var st = 'shape=mxgraph.sap.icon;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;strokeWidth=1;strokeColor=#D5DADD;fillColor=#EDEFF0;gradientColor=#FCFCFC;gradientDirection=west;aspect=fixed;SAPIcon=';		

		this.addPaletteFunctions('sapAI', 'SAP / AI', false,
		[
			this.createVertexTemplateEntry(st + 'Data_Attribute_Recommendation',
				 s * 50, s * 50, '', 'Data Attribute Recommendation', null, null, this.getTagsForStencil(gn, 'data attribute recommendation', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Document_Information_Extraction',
				 s * 50, s * 50, '', 'Document Information Extraction', null, null, this.getTagsForStencil(gn, 'document information extraction', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Personalized_Recommendation',
				 s * 50, s * 50, '', 'Personalized Recommendation', null, null, this.getTagsForStencil(gn, 'personalized recommendation', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Translation_Hub',
				 s * 50, s * 50, '', 'SAP Translation Hub', null, null, this.getTagsForStencil(gn, 'translation hub', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Digital_Assistant',
				 s * 50, s * 50, '', 'SAP Digital Assistant', null, null, this.getTagsForStencil(gn, 'sap digital assistant', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_AI_Core',
				 s * 50, s * 50, '', 'SAP_AI_Core', null, null, this.getTagsForStencil(gn, 'ai core artificial intelligence', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Invoice_Object_Recommendation2',
				 s * 50, s * 50, '', 'Invoice Object Recommendation', null, null, this.getTagsForStencil(gn, 'invoice object recommendation', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_AI_Launchpad',
				 s * 50, s * 50, '', 'SAP AI Launchpad', null, null, this.getTagsForStencil(gn, 'ai launchpad artificial intelligence', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Document_Grounding',
				 s * 50, s * 50, '', 'SAP Document Grounding', null, null, this.getTagsForStencil(gn, 'document grounding', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Service_Ticket_Intelligence2',
				 s * 50, s * 50, '', 'Service Ticket Intelligence', null, null, this.getTagsForStencil(gn, 'service ticket intelligence', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_HANA_Cloud',
				 s * 50, s * 50, '', 'SAP HANA Cloud', null, null, this.getTagsForStencil(gn, 'hana cloud', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Business_Entity_Recognition',
				 s * 50, s * 50, '', 'Business Entity Recognition', null, null, this.getTagsForStencil(gn, 'business entity recognition', dt).join(' '))
		]);
	};

	Sidebar.prototype.addSAPBTPSaaSPalette = function(s, gn, sb)
	{
		var dt = 'sap btp service icons saas software as ';
		var st = 'shape=mxgraph.sap.icon;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;strokeWidth=1;strokeColor=#D5DADD;fillColor=#EDEFF0;gradientColor=#FCFCFC;gradientDirection=west;aspect=fixed;SAPIcon=';		

		this.addPaletteFunctions('sapBTP SaaS', 'SAP / BTP SaaS', false,
		[
			this.createVertexTemplateEntry(st + 'Intelligent_Situation_Automation',
				 s * 50, s * 50, '', 'Intelligent Situation Automation', null, null, this.getTagsForStencil(gn, 'intelligent situation automation', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_S4HANA_Cloud_for_Intelligent_Intercompany_Reconciliation',
				 s * 50, s * 50, '', 'SAP S/4HANA Cloud for Intelligent Intercompany Reconciliation', null, null, this.getTagsForStencil(gn, 's4hana hana cloud for intelligent intercompany reconciliation', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Landscape_Management_Cloud',
				 s * 50, s * 50, '', 'SAP Landscape Management Cloud', null, null, this.getTagsForStencil(gn, 'landscape management cloud', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Omnichannel_Promotion_Pricing',
				 s * 50, s * 50, '', 'SAP Omnichannel Promotion Pricing', null, null, this.getTagsForStencil(gn, 'omnichannel promotion pricing', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Variant_Configuration_and_Pricing',
				 s * 50, s * 50, '', 'SAP Variant Configuration and Pricing', null, null, this.getTagsForStencil(gn, 'variant configuration config and pricing', dt).join(' '))
		]);
	};

	Sidebar.prototype.addSAPOtherPalette = function(s, gn, sb)
	{
		var dt = 'sap btp service icons other ';
		var st = 'shape=mxgraph.sap.icon;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;strokeWidth=1;strokeColor=#D5DADD;fillColor=#EDEFF0;gradientColor=#FCFCFC;gradientDirection=west;aspect=fixed;SAPIcon=';		

		this.addPaletteFunctions('sapOther', 'SAP / Other', false,
		[
			this.createVertexTemplateEntry(st + 'SAP_Responsibility_Management_Service',
				 s * 50, s * 50, '', 'SAP Responsibility Management Service', null, null, this.getTagsForStencil(gn, 'responsibility management service', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Green_Token',
				 s * 50, s * 50, '', 'SAP Green Token', null, null, this.getTagsForStencil(gn, 'green token', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Health_Data_Services_for_FHIR',
				 s * 50, s * 50, '', 'SAP Health Data Services for FHIR', null, null, this.getTagsForStencil(gn, 'health data services for fhir', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Digital_Manufacturing',
				 s * 50, s * 50, '', 'SAP Digital Manufacturing', null, null, this.getTagsForStencil(gn, 'digital manufacturing', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Sustainability_Data_Exchange',
				 s * 50, s * 50, '', 'SAP Sustainability Data Exchange', null, null, this.getTagsForStencil(gn, 'sustainability data exchange', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Collaborative_Demand_and_Capacity_Management',
				 s * 50, s * 50, '', 'SAP Collaborative Demand and Capacity Management', null, null, this.getTagsForStencil(gn, 'collaborative demand and capacity management', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Watch_List_Screening',
				 s * 50, s * 50, '', 'SAP Watch List Screening', null, null, this.getTagsForStencil(gn, 'watch list screening', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'Business_Process_Model_Connector_for_SAP_Signavio_Solutions',
				 s * 50, s * 50, '', 'Business Process Model Connector for SAP Signavio Solutions', null, null, this.getTagsForStencil(gn, 'business process model connector for signavio solutions', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Asset_Performance_Management',
				 s * 50, s * 50, '', 'SAP Asset Performance Management', null, null, this.getTagsForStencil(gn, 'asset performance management', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Project_and_Resource_Management',
				 s * 50, s * 50, '', 'SAP Project and Resource Management', null, null, this.getTagsForStencil(gn, 'project and resource management', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_S4HANA_for_MS_Teams',
				 s * 50, s * 50, '', 'SAP S/4HANA for MS Teams', null, null, this.getTagsForStencil(gn, 's4 hana 4hana for ms teams', dt).join(' ')),
			this.createVertexTemplateEntry(st + 'SAP_Cloud_ALM',
				 s * 50, s * 50, '', 'SAP Cloud ALM', null, null, this.getTagsForStencil(gn, 'cloud alm', dt).join(' '))

		]);
	};

	Sidebar.prototype.addSAPGenericIconsPalette = function(s, gn, sb)
	{
		var dt = 'sap btp service icons generic icon ';
		var st = 'image;points=[];editableCssRules=.*;html=1;shadow=0;dashed=0;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;aspect=fixed;image=img/lib/sap/';		

		this.addPaletteFunctions('sapGeneric Icons', 'SAP / Generic Icons', false,
		[
			this.addDataEntry('adapter highlight', 28, 28, 'Adapter Highlight', 'jVfLcuo4EP0aNrOYEn7MvVka2yFOITkEE2J2YPsaCxOoYLCtr5/TkiGZqrk1s6Ckllqtfpw+MiPbP3TTz81px495UY/scGT7n8djY2aHzi/qemSxKh/ZwciyGH4j6/E3u2O9y06bz+Kj+T8HLHPguqkvhVkxC+emr4eF825zoml12JQYJ0VeNZttXfjn8+ulLs7Y+vMPrF+Lz6bKNvVssy3ql+O5aqrjBza3x6Y5HqBQ08Zkk+3Lz+PlI/eP9fET+3nxa3Opm28WvLoq6WRzPGF1cz4VGQXzq+oKuD3Rjni3VXZbIVObZjOyPSNaj+drObIm3QEB+y9Pwlr3E2e76i6ZYtXm6ZVlwfE6s3M7712b9+41O2RXLr2W+w8qP2RV9LQ+rd9zf2uXD1HF2plclrPEu4iF18e+14veceJFVG6mb6e1tWMvi+i+llv1Pp/inIycSDqHyN7t4nZfRkGn8qf6vF5MWPE+qV8Wz2z9vmMzS6isj+DvcyWcNDk/+wtX5cHkR2a/XjN/LLdWd83kUfJgIterRxnb7Gb1efYhGH9vVD59aGcrcd1OH/q44q1QpYqn6Y9fi1QW0/CHv/DKF4qOPEjuXv1cT98OmbrLzy/T7rQ9vO2yfd6nq9fTeuWyaPo1f1u5p/yJP0Qfb2r9/pxk00e5Xj5c3t5FHVUTl0tWcTm/xMmSQXaMvLxwGfZ6P4HcOxbWkOWyQ+bUTHJbZ3M1f4j2YfVSDT7P4c+TYFvbK1Or22U23Yt4/ej6nzqwt7XWh8x6o+p0UfXze4aTFpmqL8hm/2o/79bTut5+zL9pIFf79Wqt7vckXZu+vx6j6fq0nbYUf7/1Szlf7KtoSn6zZiY9i1dAx8JpuRJytnD6OAkR+15hzrgqL0J693mc8G5GqKucLg7SCw/mPXJhxQun40l2EQl3s572kD8V0V7PcVYEOzlDPgXOcZXBfubOZMQgY68k3Q7nFM5feBKOgV5lbOaSbADBbeSjBqqEzyEDcl2uQsznwEyLepQuXzAzrsjHUKFmbhxkJXxlsFlqPyqPdBS6Ajrz/j5WDLFkLAoixJvaiNcSPulmtAedrOWrFmNk4R4ax/GK3/KEnPGLCLhD53hwn5OPJfdhW6UW5E4EKXxOXYG1m04c5OcZcseTiA1jn1INVEo+K/jcRoGn7cRJOTa12FGtULGlXhdyz3ReKq1jD3lpcL4Xyb40Yy1nZDdYulFAY9qRjPo6FDeXsK3l+TiiGBA77kBfRsaPBDpqbuscJZmlbci0u+kWB9bRPfGCMV2zFUesSwc1Hotgb3yBbhwAF7gnTjKqRc8/OO2pGDrIK9iN8runUetufZI919QB40HbZbgHfpQMPqJno8E+YQI2q8GGTTXKmI5bUV6+7Vkt7VGMvVCvnFPsYEvuI79Wq30RPu2Jv7YJ4YI3kB2h1t+wnJINR2NZ4zzTWP73+nnUH9ANO2HBL8XNmpwbTGu88Bum0TvLLvYZjeghb8iBd8sB4cQinMMP+LiHH3PIcxb7juLykThqjB5ADy11X5p7Q41dUzvCjvEN+XAIO4TJ7VBXnTPpjVNlMPMdOwI2ZoQHmY6NvMc+4SC0U7pPZqWgHurv2KWeHCP31FO4g3Cw7+gMjfN/zxe9UOCCfS+mvB3wPuRqwLzhpUb7j2g1nyQkIzaJ2hBfLZxx2psehN2h/6gXM3Ou1/10Nr6UbmR8U6nGoWej30lmFK8I5spgCbnW+twyeUo1pkVANfGAG6pbaukc+GzgEe/GIwarMvzqS+I6WZK/hDvwHfooIFxE5CtieiWeaWPiB7Xs9BxxDZzdEudw3U/EWZywpHVF4o2JjwW9Z8pDX0Z48RGvfDtzzUeaGzr0dgOeHNNbAAxZQvdu5AI/xG0Gk8S/MrzNibd2Q706egOGmhFP394CJ+2JP3B3khL+HPgFbEa6RwirgvBp6mRRv8W6h1PKs6PfjlU42B7wccfr9/eB7BJ/e+YtIr7V7xJ0aJ6ENr0txBGDD8zUnuy3Jt7Frc+ovzPUNbN1vZNQcyN8Mhgivtd5GfgbdSd8mDmwZP3OX/ReT/WidxD4oJxL9CzxF/lRkX+En7lNPEq+AzfIGe/EoTUcpnO320EX7y3FmrpDzju6T/Op5sJn3JEpcEY7+OEaLqM67cEpWofqD4ykpv54yzSXal7VOdDYxBuhc3Gzb2Ih2yYXxn5GeLydwfcSeklz6o175+ZNMuO4qL6+hV7M1yu+YvBlPHze48O66H77F0EvDf8PpsXxUDSfPVTaKm92w9+En+bUrqjKXfPPtc3ZyOX95Nf/DUyGvxw38euvjd77xz+fvwE='),
			this.addDataEntry('adapter non', 28, 28, 'Adapter Non-SAP', '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'),
			this.addDataEntry('adapter', 28, 28, 'Adapter SAP', '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'),
			this.addDataEntry('admin highlight', 24, 28, 'Admin Highlight', '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'),
			this.addDataEntry('admin non', 24, 28, 'Admin Non-SAP', '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'),
			this.addDataEntry('admin', 24, 28, 'Admin SAP', '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'),
			this.addDataEntry('ai artificial intelligence highlight', 28, 28, 'AI Highlight', 'jVXLkqM4EPwaX/awgRHMDEcMbowHyS/cNNx4NQgL4zBgQF8/JaCnPRvTEXtwGFVVZlUmCmqBjLK37uEtx1WSsgVaL5Bxr6pmeip7I2VsIUs0WSBzIcsS/BbyyxfZ5ZiVbuE9vTb/ByBPgEfI2nSKTIG6GdgcqPPwJh5pGWbwv3qk94bGIXPCKGX7qqYNra6Qj6qmqUooYCKxCuNLdq/aa2JUrLpDPknfw5Y1Tww6o5lANtUNomF9S2Mx9DvtUxhvNTbUP6ISRNKENmHEUqOujy1Lawj/+89HpWgRNuEC6dNRfqkf2UJe9SUINvYbIgfDSom8vo35TYks1oZcouHmKMVm9XBQgpJBRXhQH3EZP7B7UXcnbaob7Cy1lnV0xZpd5lKy0b85gwaIuE04biO0vTrc7rCpP2IUXG26kkPvFR1KTdmf7M4p9I7wM+TjbmeuO8zXaOdeOKb6mMOFyOlLwu0Bm4flzrwoxDxkuMDtzs1UqEU70+eE+ypx8Ry/CExPihhqfZnwCxJ9g7ctDz2thb69U6ypbbHL/rTF/htjMfvRQw0KvaMUmhL9gh8wOQu9pEp+1/ylV6GUNsrz3aBn4K2Uej2zN0c1ts6afT2ydHN4+AgUfdR1l61zJRLeNDyxtM7xyCOytGFHcYctwnwPf38/+UVqrb8bh0sbo0OfIiJFSG98WasjZH+zuQ5zYiUoGm1LieK79dY29B8Omvrv6YQXscB6LWP+OaOIiXcZeC/DEW3zwGIsuh6y0Dto9gV82mS9eFfgj4pd0G3AOzdtzS5saYwVwosDeJMMvne8BZ4qvXrqLdnAnbi+cvDdja2XIjhr7esbYc/+QO/MNvtRt22R2n8jHN4JT0ydOvyrOq0MroSN7+BkZ77c5zESvcDDk/140gqY7vEXbXD3Z5fGiv86st+s8sTKsqBkdQRdkrdt/dMgq5/QLYCz69rcKc7IMcUNeCkcdw3/58YpfNlx7XZn2g0+KUs8SFB3UBwXt8TMIL9WHYiTQRI3pxk5AIvdrMaG1JLCrwGnkpMEN/TMHXPmGhRpZ3QT14hX+t0J6t0Y6rvOMYGDdoC5LMcZJlw9zTDjzHEG6HURONF/xgOXARyGIhMqTRzAB7e9wVRRgPdZg8BMOqbZxdyA2Yauuxa9VcBKYgZ/1D7rK9YNgT7APzhF1hCqcPBAdgqMQA8nI4fORx9NLLzrwDuoXYPHujgPoHPmA21GB73W4LXfYh7XM9/EUWB57GlioU0hQhv4Abpr8BG8Ez7BF8A8Qwz8Bo2O+cwj5ukmLnOcp57m6T7mqad5Zn3Ca0Oa5pl4Zn0zh9BHuyd9B+GZ4FI9+nlb94bGkzKGmwlf7Xn1wDJI+y/X1xiad5eVVmXa3Aco6WjS5PMK+zGh8pRmefNnLKync/Yb+bkL4WFehx/Hz7U75v7Yyr8A'),
			this.addDataEntry('ai artificial intelligence non', 28, 28, 'AI Non-SAP', 'jVVNc6M4EP01vuxhCyOYCUcMDpaD5C8cB9+wIFhYGJcBA/r10wIyyWxNqvbgAnX3e93vSUYT5OStd49uZ1LEiZig+QQ596Kohre8dRIhJrrG4wlyJ7quwW+iP3+TnfZZ7Rbdk2v1fwD6AHhEok6GyBAoq06MgfIc3dQrz6MUnrNHcq84i4QfnRKxLkpe8eIK+VNRVUUOBUIlZhG7pPeivsZOIYo75OPkPapF9YXBFjxVyKq4QTQqbwlTQ7/zNoHxZn1D+yOqQSSJeRWdROKU5bYWSQnhf//5qFQtoiqaIHtY6s/lI53oszYHwc56QfVjNzNOh7Zm8macPFFHUuPRYqsxt3j4KEZxZyLSmQ+WswcJLuZqZw11HU4Tb1qersTC+VmLF/YPv7MAwepYkvqElldf4oa49oOh4xXzmR4dXtEmt4z1Djd+ZjdU7iHPmpU7b4ico1VwkYTbfY5kKmdPqcQdcTfTlXsxqLtJSUbqVZCaUItWbiipDE0akDF+UZiWZgxqQ53KC1J9j29LGR2sGvq2fjbn2BOX9W5JwjchmHhqoQZFh60WuRr/hh8wZxEd4iL+XfOXXpmRY3Q+rzo7BW+15NAKvNiazNtb+LoVyWLzCBEoyoyaoU2DF2XK0PbBnGl20tsHy4qU5TF/cS+t79gtCfYldudytbv8xAst9a9UI7sZvFPthOwq1K3yhPAPvFheQ55K6jQpzAoY1r0EZfq+s598NMyx5mGWePOf2LGfjt5rzuTnrCqm9vR4eO62aHk+ekKcrps0OmwsfAG/Fmmr9gx8MkkA+h3YexdbOMNaH8uUJxvwKO7Cw/Z2PJja68G8xQs4G9dXCf4HzHvOjnurfn2j4qtP0DvFbitjz2qwR8vwjUrYGxm7Nvfld3VWfrxS0e/FDqeh3p4ZUr2UP/jxRStgmsdftMF/YMmpEYJLquK/jqwXs3PspekxF+UJusRvy/LFobMX6HaEdRBg6Wd75LvqJDxnfjCH577ys1D3A1yvXFyRnTElnQZ1G8MPSE3dFPJz04c47TR1gqqeA7AkSEviaDXNwhJwJt1pcFL30ndHrs7QVk4zcPV4o13toD5gUN80vgscvAHMZdrPMODKYYYR5/YzQK+Lwqn+Ix64HOBwDJ1ybeAAPjhJFeGGAbxfNSjMoGOYXc0NmGUUBHPV2wSspmYIe+2jvmxeUegD/J2fpRXlhgQPdD8jCPTAyVUctux9dInyrgHvoHYOHttq3YHOkQ+0OQ30moPXYU0kK0e+gSMjet/TJUqbQZU28AN0l+AjeKd8gi+Bu4cY+A0affcrj5qnGbjcfp5ymKf5mKcc5hn1Ka8dbZhn4Bn1jRxKH2++6NsozxSXeeCfp3XtWDLOGZxM+HqPVxBcCkn77TXWh8Y7zEuKPKnuHZQ0PK7O41X2NKDOCU/P1Z+xqBzW6W/k550IL+O1+LH8vH773B+38y8='),
			this.addDataEntry('ai artificial intelligence', 28, 28, 'AI SAP', 'jVVNc6M4EP01vuxhCyOYCUeMHCwHyV84Dr5hIFhYGJcBA/r10wIyyWxNqvbgAnX3e93vSUYT5OStew9vZ1rEiZig+QQ596Kohre8dRIhJrrG4wnCE13X4DfRn7/JTvusdgvvybX6PwB9ADxCUSdDZAiUVSfGQHkOb+qV52EKz9kjuVc8CoUXnhKxLkpe8eIK+VNRVUUOBUIlZmF0Se9FfY2dQhR3yMfJe1iL6guDLXiqkFVxg2hY3pJIDf3O2wTGm/UN7Y+oBpEk5lV4EolTlttaJCWE//3no1K1CKtwguxhqT+Xj3Siz9ocBDvrBdOP3cw4Hdo6kjfj5Io6lBoPF1stwsXDQzGKOxPRznxEefSg/sVc7ayhriNp4k7L05VaJD9r8cL+4XUWIKI6lrQ+oeXVk6Sh2H5E6HglfKaHh1e0yS1jvSONl9kNk3vIR80Kzxsq52jlXyTldp+jmcrZUyZJR/FmusIXg+FNSjNar/zUhFq0woFkMjCZT8f4RWFalkVQG+hMXpDqe3xbyvBg1dC39bI5J664rHdLGrwJEYmnFmpQeNhqIdb4N/yAOYvwEBfx75q/9MqMnKDzedXZKXirJYdWkMXWjNy9Ra5bkSw2jwCBosyoI7RpyKJMI7R9RM40O+ntI8qKNMpj/oLp1HOAG19KgsmU7S4/yUJLvSvT6G4G70w7IbsKdKs8IfKDLJbXgKcNYAzWNeDFvHnxy/R9Zz95aJhjzYMscec/iWM/Hd3XPJKfs6qY2tPj4bnbouX56Apxum7S8LCxyAX8WqSt2jPwyaQ+6Hdg7zGxSEa0PpYpTzbgUdwFh+3teDC114N5ixdwNq6vEvz3I/c5O+6t+vWNia8+Qe+U4FbGrtUQl5XBG5OwNzLGNvfkd3VWfrwy0e/FjqSB3p4jpHopf8jji1bANI+/aIP/wJIzIwCXVMV/HVkvZufYTdNjLsoTdInfluWLw2Yv0O0Ia98n0sv2yMPqJDxnnj+H577yskD3fFKvMKnozpjSToO6jeH5tGY4hfzc9CDOOk2doKrnACz105I6Ws2yoAScyXYanNS99PDI1RnaymkGrh5vtKsd1PsR1DeNh4GDN4C5TPsZBlw5zDDicD8D9LoonOo/4oHLAQ7H0BnXBg7gg1NfUW4YwPtVg8IMOobZ1dyAWYa+P1e9TcBqaoag1z7qy+YVgz7A33lZWjFuSPBA9zKKQI9kPYctex8xVd414B3UzsFjW6070DnygTangV5z8DqoqYzKkW/gyKje98RUaTOY0gZ+gO4SfATvlE/wJcB7iIHfoNHDX3nUPM3Ahft5ymGe5mOecphn1Ke8drRhnoFn1DdyKH28+aJvozxTXOaBf57WtWPJOI/gZMLXe7yC4FJI2m+vsT403mFuUuRJde+gpOFxdR6vsqcBdU54eq7+jIXlsE5/Iz/vRHgZr8WP5ef12+f+uJ1/AQ=='),
			this.addDataEntry('alert highlight', 28, 25, 'Alert Highlight', 'jVVNc6M4EP01vuxhS0F4Jz5isLEySDY2CYEbXyOEhXEZsIFfPy0gyWzVTO1WJYX6tbr79VMnvcBm2dm36JrTKs3kAm8W2LxVVTOdys7MpFxoSKQLbC00DcHvQtv+wfs0etE1umWX5v8EaFPAPZJtNiETUDe9nIE6j67qKMqIw3edpaKJYpmZdX1sZVaD6++/AL9nt0YkkXSiOJOHqhaNqC7gjKumqUq4IJVjHSVnfqvaS2pWsrqBP81+RK1sfslgSMFVZFNdAY3qa5aoZn6ILgPa65GI8YGiD0SlippogY3J1Lb1nS+0dVdCw+Zhx7SwX+ux37XJgES0O6LEqu4OTnHaLzHtl/ekTO60MB7UXA1pmQiyC6/he2rGmK+IQA+neOWOZ7TsZPR70+jZSe/YcBbEzmXkp1VqIUGL15Z6yZKINY78I4pGjIuDCIrM3nwzTwYHLijzO0l2x2Viv67I5SiznXsPMBtIoZcE5/n+cX5xLgzRXTOk9urh+Owe26t+L+iD2kwGPv324zTndM9tgt0uwwzF2GgCbVXHmPxDBgPvLaqHRbN6EUwPvPqFmMazg6f6n5y87hz64fBpu+fn2JZt6G/7I37JQ1vK+OLy8PN8fItLiZSO6TuTiWSPwGfS05ZvifYKup37w4n0zNQxswjYfLSp0ss6K38H9uAUBmYm4Zm1WZGCtNSiSrdrCJq5JwJv98FaMUrw8Z6Y6yK2t4OqDB0/iHj+71sd5LyHZTiE7y7U2Qhn+NL4YK7qyF/K4P1ll5Tbc+S/tan16X92tKMML/SXKofdOk9tzsNS1rGlFHipv5ts/f1EuGLueURziuRpb6KWDnQZeJuWWRsO3SN6Mh7EMjg1UecULkyR/mAabUAJnamzFzSAdVQYT05BNSpQR3u9p/1sl7xR9wHr6BCoPIDDV+iIFW4DE6kR67VlF9pDfo2Zxuj/xEveMo/2sUXbvUV6YiUtK1gO3AYmjE7VmPgpnht4EdKrXlQcLQj6fS9Gu/fOyFGYFdbARXc80u7tjcqnj3kGPuc0uKrBxv7pEINGe48gx6PAI9CDwVW5dKc4P4EGneJFPaL4d7RwOfVUrvPYC/XyfOahtOx+5Q1Tp6vpCnqlCwF9CeQbpxHOidJ9PEN8z6zQdwq+pNpmzjP3OPFV95F6B8gx0Mu1cbyN0hT6IgrToYdB9QJ34N0Djf2+77lWoPLpbMMhx7ZwlJ6e6gf8o24QUxho1M9EoH0+qDhquaMfan7glXrTtEh/r4GaJbhLh7d6jucwXzrF14aOWsO7qhresVBf0F7xe2IezBDM22j3+nKcP4h3PBc02frgw3vvrRh9gwu9uEtiqZma+MH8Tm8kEAINluxSff21DY97gsPLgau9on7W8/KBf/tZ98cFNkLz9rKzqsyaWw9XHiJt8nmJPU9ReSZ4PkdpywmL6snmn5Ff2xAO80L8ML8W7+j7117+CQ=='),
			this.addDataEntry('alert non', 28, 25, 'Alert Non-SAP', 'jVXLcqs4EP0ab2YxpQCemywx+CEHycZW4sCOV4RAGJcBG/j62wLymKrcmqlKiu7T6tbpo056pltFu74Gl5SUcSJn+nKmW9eyrEeraK1EypmGRDzT7ZmmIfidaas/RB+GKLoE1+Rc/58EbUy4BbJJRmQEqrqTE1ClwUWZogg4fBdJLOoglIlVVYdGJhWE/v4L8FtyrUUUSCcIE7kvK1GL8gzBsKzrsoADUgUWQZTza9mcY6uU5RXicfIeNLL+VsGUgqvMurwAGlSXJFLNvIs2AdqLgYj5gaIPRJUK6mCmm6Orraobn2mLtoCGrf2Gan63MMJT20Q9EsHmgCK7vDl6rMfdXCfd/BYV0Y1k5p1YT31cRAJv/Iv/Fluhzp+wQHcne+EOMxt6NLudZXb0aLS0zwVepzI4xWVsI0Gyl4awaI7FQg9OBxQMGBd74WXJevnLOpocuKDk1Eq8Ocyj9csTPh9ksnFvnk57nBlNpLt3vKl4pB9ukfWQhVp7i7KSR0Usnu28dSyzJeylwvay3x3zX3iDuHOmiBwXYFMU6mbtaU9VqON/8GZ79gTvqXXnlBHIibpnVvH3o/no6COPT26szf2T33/6bv4YrmXjn1bdQd+m/lrK8Oxy/9M+vIaFRErP+I3KSNK7d6KSafPXSHsB/fJuf8QdtQyd2hh8PvhE6WbnKt6C3zuZqVML88RePuEMN8QmSr+LD9q5RwxvuBXU8Fi1VYxGVRZZuF716uZBLfH436daqHnzC7/331y4Zymc3iiwnqa7e77dW09VcJpL7227iYpVHpxem9j+jD862kH6Z/Ltlv1mkcZrzv1CVqGtFNhWzxZdPB8xV8wZw5qTRQ87CzWkJ3OPLRtqLzl0Dy9l3rFtcmKh1slcmCbjTjVSgxIGVTbzasBaIswHJyMaEaglndGRbvILXqvzgLWk91QdwOErDEQzt4bJ1LD90tAz6aC+Ri1ziH/iBW9gGrrQJs3Oxh1MRUMzmgK3ngqzVXeM/BTPJbwI7lQvKo9kGP3ci9nsWI4chdl+BVwMh+Fmt16qesZQp+dTTZOrO+jQP+lD0GjHMHIYAR6e4fWuqmU4Wf4AGrSKF2FY8W9J5nLCVK186IWwNJ14KC3b77xh6gw1XV6ndMGgL4Z6wzSCHSndBxvyO2r7Jyfjc6ItpzpTjyNfdR6pd4AaPTlfaoctlabQF1aYAT30qhc4A+/uafTnvqe7PFXPoEsONVaZo/Rkqh+ID7pBTmaiQT8LgfZpr/KI7Q5xuPMDL9Wbxln8swZqluAs6V+rKZ/DfBlEv9Rk0BreVd3BDpn6gvaK3wNlMEMwb4PfGfNh/iDfYS5osjpBTN+x12yI9S704s6xrWZq5AfzO76RQAg0mNNz+fXX1t9vke6f91ztF/WzmJYQ/PtP2j8usgGattg6KYukvnZw5C7iOp2W2eOYlSaCp1OWNh+xoBp9/pn5tRXBmBbjh/u1gIfYv/bzbw=='),
			this.addDataEntry('alert', 28, 25, 'alert SAP', 'jVXbcqM4EP0av+zDlgx4J3nE4IscJBubxIE3biMkhHEZsIGvnxaQy1bN1G5VUnSfVrdOH3XSM90q2s0tvGakTFI501cz3bqVZT1aRWulUs40xJOZbs80DcHvTFv/ITofouga3tJL/X8StDHhHsomHZERqOpOTkCVhVdl8iJk8F2mCa/DSKZWVR0bmVYQ+vsvwO/preZxKJ0wSuWhrHjNywsEo7KuywIOSBVYhnHObmVzSaxSljeIJ+nPsJH1twqm5Exl1uUV0LC6prFq5idvU6C9HIiYHyj6QFSpsA5nujm62rq6s5m2bAto2DpsqRZ0SyM6t03cIx5ujyi2y7ujJ3rSLXTSLe5xEd+JMB/Eeu6TIuZ4G1yD98SKdPaMOXo44pU5ntnQk9ntLbOjJ6Olfc7xJpPhOSkTG3EiXhvixQvMl3p4PqJwwBg/cF+km9UP62Qy4ILScyvx9riIN6/P+HKU6da9+zrtsTCaWHcfeFuxWD/eY2suIq29x6JkcZHwF5vMHctsqZ1X2MZzesp/4C1izoUiclqCTVGkm7WvPVeRjv/B293F5+wBOQbtHoyI1ePFq9jPk/nk6COPT25emwfnoP/03fwp2sgmOK+7o77Lgo2U0cVlwad9fIsKiZSeyTuVsaQP/0ylpy3eYu0V9Mu7wwl31DJ0amPw2eATpZudq3gLfu8IU6cWZqm9esYCN8QmSr9rANq5JwxvuOPU8L1qpxiNqixFtFn36uZBLf7036daqHkPiqAP3l24Z8Wd3iiwnmX7R747WM9VeF5I/323jYt1Hp7fmsT+jD852lEGF/LtlsN2mSUbxoJCVpGtFNhVLxZdvpwwU8w9D2uOiOd7CzWkJwvfWzXUXjHoHl7KfGDbZMRCrSNcmCbjQTVSgxIGVbbn14C1hJtzRxCNcNSSzuhIN/kFq9V5wFrS+6oO4PDlBqLCrWEyNWy/NvRCOqivUcsc4p94wRrqkS6ySbO3cYftuKGCZsCtp9xs1R0jP8VzBS+CO9WLyiMCo9/3YjZ7L0eOwuygAi6G4+Fmv1mpesZQp2dTTZOpO+jQP+kj0GjvYeR4BHj4ht+7qpbhiHwOGrSKF/Gw4t8S4TLiqVr50AvxsmziobRsv/OGqTPUdPmd0gWDvhjqDdMIdqx0H2zI76gdnB3BFkRbTXWmHke+6jxS7wA1enK51o63UppCX1hhBvTQq17gDLy7r9Hf9z3d5at6Bl0xqLEWjtLTU/1AfNANcoSJBv0sBNpnvcojtjvE4c4PvFRvmojk9xqoWYKzpH+rpnwG82UQ/VqTQWt4V3WHdxTqC9orfnPqwQzBvA1+ZyyG+YN8x3NBk/UZYvreexNDrHehF3eBbTVTIz+Y3/GNOEKgwYJeyq+/tv5xj/XgcmBqv6if5bSE4N9/2v5xkQ3QtMU2aVmk9a2DIw+e1Nm0zJ7GrCzlLJuytMWIhdXos8/Mr60IxrQYP9yvBTzE/rWffwE='),
			this.addDataEntry('api application programming interface highlight', 28, 28, 'API Highlight', '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'),
			this.addDataEntry('api application programming interface non', 28, 28, 'API Non-SAP', '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'),
			this.addDataEntry('api application programming interface', 28, 28, 'API SAP', '7VdLk6JIEP41XvawUQLudB8RaC2HKlrFsfGGwBQvH9GgPH79ZhZIT+/YM33YiL3swYCqzMr88ssH1kg1DvXs1T/H7BRG+Ui1RqrxejqV3duhNqI8HykkCUeqOVIUAr+R8vSBdCyl5Oy/RsfyMweU7sDVzy9Rt9NtFGWT9xtF7J/xNTn4Ap7TKExKf59HRlGsLnlUgOjPP2D/Gr2WSeDntr+P8udTkZTJ6QjC/aksTwdQyFEw9YNMvJ4ux9A45adXkIfRd/+Slz9Y0PNE4MnydIZdvzhHAQbzPakjgD2VQPTbLrntoCm/9Eeq3i2Vp+IqRsq0PkDAxvOcK7tmqu239SVoSeLPVyQwT1dbDdWwmaismVyDQ3BlqV4x47END0FC57vz7iU09qp4pAmp7HQjbFe/8LXeOIbe8EbTWOsldBbn/jY8hSZJWBpcHJMpNJmq/nZFfLknkufES6OZ9cVY6wKwkGhb53S+mgSzzSM9rvJovrx6Km9pql0CdVnReSECdXUNjHG6V+prkJ5EcAiTryYb24ZeczMrqEnHfJ19oXMi7CMnbD2Fd072ql56ymOxV+lfdL44eomo4IzGm0qw1Kq+uoX4vtYfbLXDMWBz62y33bXDepk97Gf5Zbd9albqIt7N8nx/XIrd8L76tj/kBPkMX3ge5Lzytjx3lcm3QNkAf1nzvKYNX2sNcAJrIdes0VqWeiivYd3a6XLM1lREpvVIU3phJpsAf+cdcLdcU8jhIuGa5xYLRNSxMk33s6cWPUu2koffa9Vg87o77NrdyxL8WIndageqxrFTZYtn47Hwt5Pce1nMg8NT5m+/XUJzkD/YyirfHdkPXp7n0zicCbE75MXeRAYWxVeDT79CJIjcdWltp1nN1pCtRGuYu0jtNFB4o1fUtC7cDCZ2ahGe6A08W6gmwto4BrYUam4usA96uoDzwBDYMIbn2E6pQFalHKqBGnhWCJZoNWsDlI2dNeptJjcde/2m4yAWzIpLLzzdqPCuOO4SfAHOdFnKp+nhGvZFCXZqODdmLkVZzdzlxXGt1nYtqHZdw3igcxS0w10B71mDMsACcTLNBj/MZSpkunXmDG2Qzi7GTzD+CUuI1PVciB1wQgwqdFnPAQEugzFr8EkrfmA9JjwTjMHvBOyj3Yqb1g1/2eGXnH7ER9nzgdhVyFFhuwHgzlTbZcCNpXjSp9WyBM6kOlQv4l02YA/Wm5YbBPIiJjKnLiMSv5vdcnDD/y5Gmd9PxbhU+RrOuBbi1YBbGaPjythq2Menyl0+/SDGMeDCDqudGaswRg4TCvKnYH66GoScGORWg1gT4NebcANy2Uo/DW8z8Q9/cY8d/AXaUIfIQbuRdYH1IOP8iQv9fb4bianDC/E6WF/pUMuQCwGcLkF3IwAT4W92er7waY3ZtoL6YhPeYD48lb14GMf4U3ErFsThia733mKRNT3U+L2c6e9ztrF6/ru4mdSzcOpiv8h83IuXY6/18Q49kOgS02AD8s9M0fUocvHznOgwyDoVlfOvzAkq7uX5Lb9dvqFHsEabvl4xHzCnhnq94Zb1I3NidHUGe/3c6/pwmBfQzw5yYqAtoUFvoL/alvNKYL8r8JUou3lK+hmDee3yxUzazSbX6vYB494gCtgijpynm4orDOpBYK00XY0vO4xpBr4CImNLlwRjlrMGMZhZVxdmgBhvZ2DG5AXMeA2+ygK+boS7ixjWKsx68BmoP9aU4wYSG/iZ9LVQdrWIefMIzBM5k+HrDk8m+eLquUQuwDbMuTgGrhRH9pF3y1vVxRvgLGpYcpOhjVsd6mUvw+8S/OO5qyM+owMxT3jLoC9oM8g6TNVQI/I8+ZWOlN1w39chn9F55yvKyBjni/P23b3L15ALrE/ok7s6hpSVfbx3dfrzv9Zxf+/rv8pfdCDIE3z7qIC+bB2T/8/Xr/hK6PX2D/m5uynAv0K4hfRXKbjERPWH1zG51d/FZtHpEJWvDahUSVjG/ZXsoTsVR4mIy/d7ftGtxXDy7W4HL/317rZ8u0ZK2btb5t8='),
			this.addDataEntry('app highlight', 28, 25, 'App Highlight', 'jVXLcqM4FP0ab2YxJQPujpcYCFYKCWNwCOx4tQwI4zJgHl/fV2AnmanqmqlKSrqvc889ktFK1qrBvEXXM6nTjK9kYyVrt7pul101aBnnKwnl6UrWV5KE4H8lvf4hup6j6Brdskv7fwqkpeAe8S5bPIujaUf+cDTn6Cq2eRUxWHdZmrdRzDOtaY4dzxoI/f0X+O/Zrc2TiFtRnPFD3eRtXl8gGNdtW1eQwEVgFyUlu9XdJdVqXt8gnma/oo633xBUnjNR2dZX8EbNNUvEML/yIQPau5mI+vSip0dARW20ktXFlF6bO1tJu6GCgbXDnkrhuFNif+iSCeXR/ogSvb5bciqn40Ym4+aeVMmdFGpPtO2UVkmO9+E1/Ei1WGZbnKPeKk7M8tSOuupoa+pINWVNPZJj88wjP61THeWkcDrqnSac7+TIP6Jo9rH8kAdFZho/NVdlwAVl/sDx/rhJzNMWX4482zv3QKYTLpQKy+ez3Zdv1oUism+n1Nz2lk/vsbkd7Zz0xKQ88MnPX+4D0ym7RHaGTKYoltU2kLZNLOMfeFJlWydKWLTbt5wqgde8YU19seSl/ycnbyhDP5w+bad8iU3ehf7reJTfzqHJeXxxWPi5P77HFUdCx/SD8oTTPvAp96TNeyKdQLdyPLh40WdiYLPZJpoiERezzDO2uMCd7bE16KQQDzTKlZ5MJWjJy4P7tvuuA/CbNcAmbYIPOkF8SnU1t6b/yjEAb1uFF8rns3Hx/fuMljRc4+r9nJTpGPjHa+hv0Jcm/T0036vkq8dLYr6iSNtVkT80gL9Oqr7GyLjCDIIzJQXp4Kw3lqusg8mAvTpiXWUw20j0U0d1YUOOripYn+MIboos7hXkrIkeMFIk4n5NVpEMaWFIVmFMRDKQVWAGei54mjpY3lL/xAtG1NmAbxWsJy4a5jWHvALDigBP7enTLtmMT3zSEldww4CJRhGjLhI8AX/BffQZA8/pAG/mAf174P+sbckIZ6effVhlwOyfNVbhiN4P3KU31RYu9isB/6mnwPsxb2+L3h9XKvSyXXUNebLtsxFsRHgwcw4mtbWKEs11ejKJXlTHw79XF3ShkzEIXcjERjgT4JhAbbIGngMZhUbqZLvKBL8R8OO10Jd6DuyJArNJ1hwzGBG10xnurjLRIv0Re1jMBmcBd1h3kAsrKbhEoLftYcGRLbNDn4IBDyI4QL9SoaCZrSeQf4J5gjUdRY/y0aOc8yLd2IA2sm0SwHPk+cxd0KAwgJuzXrR0xuWciUTXAdyhciQf9ddvYurviRxeDkx8xcXf7vGph49sNvzxuZhdj7fCzOoqa28jpPR52p4fT8bLUnXOcnZ+VEmbxRc1i80+K7/eHtg8np+n+fXMzbF/vIK/AQ=='),
			this.addDataEntry('app non', 28, 25, 'App Non-SAP', 'jVVbk6I4FP41vuzDVrg40z4i0JoeElSwaXyDwEQgiCUgl18/J6Dds1s1tVvVXcm5fec7XyJZaGbZb27R9UyqJBULzV5o5q2qmnlX9mYqxEJFWbLQrIWqIvhfqK9/iCpTFF2jW3pp/k+BOhfcI9Gms2d21M0gHo76HF3lNisjDus6TbImikVq1vWhFWkNob//Av89vTUZi4QTxanYVXXWZNUFgnHVNFUJCUIG1hEr+K1qL4lZieoG8ST9GbWi+Q3BEBmXlU11BW9UX1Mmh/mZ9SnQXk9EjKcXPT0SKmqihWbMpvpa3/lCXfclDGzutlQ9DWs9DvqWjSiLtgfErOruaImWDEuNDMs7K9md5EZHzNWYlCzD29P19JGYscZXOEOdkx+54xst9YzBNY2BmrpCfZLhzVlEQVIlFspIvm+pfxxxttai4ICiycezXRbm6cb+bnoGBy4oDXqBt4cl2xxX+HIQ6XZ/DzU64lxvmbbv8LbmTDvcmanksdrfWV5xVibZD6voHdPoiX+ssWWPrld8x1vEnQtFxFvDnqJYM5pQXdWxhr/h7dslzPhIzY4DV6hhww+/5j8948XRZh6f3Py+OAWn8dPeFy/xRrSn4HU4aG/n00aI+LLnp8/94T0uBZJ6Jh9UMEG7MKDCV5fvTD2CfsWw8/Cs08jB5pNNTF0lHuapb69wjlvX5wropRMftMr0jowFaCqKnfe2Bj1KrJ3Pble8Ab8x2aw6vKF1+EFHiI+JZWTO+F85NuCtytOFiumMPHz/fUZH7a9x+X5mRTKEweF6CpboS5Puftq8l+yrxwvbvKLIXJdR0NeAr7CyqzCyrzCD5ExJTlo486Xj6Uo42rA3BmwZHGYbiHVsqSVtyLEMHc5QxhHcGE3eL8hRiBVykjN5z0YnZ32S26qT2yNRbeTkmIOeMx7cA8ef65944YBaF/CdnHfEQ/20ZpCXY1gR4BkdfdoFn/BJQBriSW4YMNEgY9RDkifgz7iPPkPo71vAm3hA/w74P2sbMsDZWecAVg0wu2eNk+9l7wfu3JuaMxf3lYD/2FHg/Zi3c2XvjyuVermeoUCe5gZ8ABsREU6cw9FonLxAU53FRtmLWrj/9+qBLnS0e6kLGfkAZwIcGdQyBXj2ZJAaGfA70kfXIuDHitSX+nvYEx1mU50pZnMia8cz3F19pHnyLfaxnA3OAu6wtUcerCQXKoHero8lRz7PDn1yDjyI5AD9Cp2CZq7FIP8I84QKHWSP4tGjmPIiy16CNpq7IYC316Yz90CD3AZue2XWcj/M50xUqoRwh4qBfFRfv4mxuzPtdNlx+TWXf+vHJx8+tmn/x2djcj3ejE1alWlzGyCly5Lm/Hg6Xuaqc5rx86NKXc6+qJ5t/ln59QbB5vEMPc2v526K/eM1/AU='),
			this.addDataEntry('app', 28, 25, 'App SAP', 'jVVbk6I4FP41vuzDVrg40z4i0JoeElSwaXyDwEQgiCUgl18/J6Dds1s1tVvVXcm5fec7XyJZaGbZb27R9UyqJBULzV5o5q2qmnlX9mYqxEJFWbLQrIWqIvhfqK9/iCpTFF2jW3pp/k+BOhfcI9Gms2d21M0gHo76HF3lNisjDus6TbImikVq1vWhFWkNob//Av89vTUZi4QTxanYVXXWZNUFgnHVNFUJCUIG1hEr+K1qL4lZieoG8ST9GbWi+Q3BEBmXlU11BW9UX1Mmh/mZ9SnQXk9EjKcXPT0SKmqihWbMpvpa3/lCXfclDGzutlQ9DWs9DvqWjSiLtgfErOruaImWDEuNDMs7K9md5EZHzNWYlCzD29P19JGYscZXOEOdkx+54xst9YzBNY2BmrpCfZLhzVlEQVIlFspIvm+pfxxxttai4ICiycezXRbm6cb+bnoGBy4oDXqBt4cl2xxX+HIQ6XZ/DzU64lxvmbbv8LbmTDvcmanksdrfWV5xVibZD4sojmn01CpqbGGFesV3vEXcuVBEvDXsKYo1ownVVR1r+Bvevl3CjHdQo9Oh4yS3ux9+zX96xoujzTw+ufl9cQpO46e9L17ijWhPwetw0N7Op40Q8WXPT5/7w3tcCiT1TD6oYIJ2YUCFry7fmXoE/Yph5+FZp5GDzSebmLpKPMxT317hHLeuzxXQSyc+aJXpHRkL0FQUO+9tDXqUWDuf3a54A35jsll1eEPr8IOOEB8Ty8ic8b9ybMBblacLFdMZefj++4yO2l/j8v3MimQIg8P1FCzRlybd/bR5L9lXjxe2eUWRuS6joK8BX2FlV2FkX2EGyZmSnLRw5kvH05VwtGFvDNgyOMw2EOvYUkvakGMZOramOIIbo8n7BTkKsUI4Jybv2ejkrE9yW3VyeySqjZwcc9BzxoN74Phz/RMvHFDrAr6T8454qJ/WDPJyDCsCPKOjT7vgEz4JSEM8yQ0DJhpkjHpI8gT8GffRZwj9fQt4Ew/o3wH/Z21DBjg76xzAqgFm96xx8r3s/cCde1Nz5uK+EvAfOwq8H/N2ruz9caVSL9czFMjT3IAPYCMiwolzOBqNkxdoqrPYKHtRC/f/Xj3QhY52L3UhIx/gTIAjg1qmAM+eDFIjY3Q9fXQtAn74TYG+1N/Dnugwm+pMMZsTWTue4e7qI82Tb7GP5WxwFnCHrT3yYCW5UAn0dn0sOfJ5duiTc+BBJAfoV+gUNHMtBvlHmCdU6CB7FI8exZQXWfYStNHcDQG8vTaduQca5DZw2yuzlvthPmeiUiWEO1QM5KP6+k2M3Z1pp8uOy6+5/Fs/PvnwsU37Pz4bk+vxZmzSqkyb2wApXZY058fT8TJXndOMnx9V6nL2RfVs88/KrzcINo9n6Gl+PXdT7B+v4S8='),
			this.addDataEntry('building highlight', 29, 28, 'Building Highlight', 'jVVLs6I4FP41bmYxFQN2X5cIilgkPkARdrw6JMLFUpDHr58T4N6+PV1dMwuL8z7fd5J4ZopetOYjvGekTNJ8pqxniv4oy2qUilZP83yGEU9mijHDGMFvhjd/8M4HL7qHj/S9+j8JeEx4hXmdjpbR8Ky6fDI8s/AuRV6EDL6rNOFVGOWp/nye6jx9guvvv8D+Sh8Vj8PcDqM0P5RPXvHyHZxRWVVlAQG5dKzC+MYeZf2e6GVePsCfpD/COq++VNByzmRmVd7BGj7vaSzJ/OBtCrBXAxDtw4o+LLJUWIUzRRtVvHm+2Ayv2gII64ctxUG3UiOvreMe8XB7QrFRvmwlUZJuoZBu8YqL+EWE1hB92SdFzK1tcA+uiR4pbGlx1NjizGxXq6mjdXv50y0Wmpd7gDN0cKxBT3B+S0yIF9bCEmphKVm2b27MMto+2ebPwFmh9LrKD84OBdcM2Zj2cWcBzh2nqu8+d7qz6BNj9T1WTq9Yn4sIt69YlIIYKxF4G7FX0EfVnf1OEblWfWIuG9ujr8hcdntOGtqzfm/63384vkjN9Xfd0dhBspII3E9Ub4F5KeL+U98dzPYeFZcsviWd753ugbdAlvlTvniLe7IlS+v90gfXnRubGxGcl/XlSnOLrxZEIE6EVRPDmoOujvqx3rvAUfpd0DsV0f4I02UtTK23RYwoh0l6x6V1W/MDnzAfAc+WokjRmI/bLFZkX+CrW6//jHEsFuGgiPFFnkxr8bevE3YbmFRewzS7k7LLAjPPo/fjlwiY1S3wgv6zj9s2/vVUWmZwj8xG8u8inYmjc+OWKXGjjupqR90zI+6xJi6b+8AT5sCIDjemX3e2WMMNURekh/n0DNnCmlOudsS9TfoZZkFUOsRsMJE3TUCdXmO2YArtUE0NolrGGuLXc9sdvx+6Y1gw55OwHch3CfRFLdRTQEdQvyKO2kMNaWvp1a+IGwiIgZrahA1NOCUGBLVIO2JENRFnDPgG+4j1pg52kEPjDH5tfhH+yLvXKqiBqaO2VBxBjlvCVQT1JIaGGpsn3AHgBxi42hNj40l+Y96xAVtLHIlF9ifw0iQWhn/D4vyOBeSWdFozziQGbmdlktnAX/Gh5k0huIFZW+pel9xJQzwCMf4cbO3eUefUYDV1fdkHQQzkaPDOfDUtUAW84P7eGODEe+OC5Zdg2XuN6XbghIlyr2zXgvODczCZzJG9oZffD/Pqk2+Rq1VTDY/AWVLvlziVXmUNGRsPduJeysE/l7gYIremHd4S1wD3GlGzmeqdJVe8d/NvkYMkh444MgbO3WPAmy0uYg2cLqXtknpv5BLLv/kMcQlHA2bgPeiWkeGRF5uH+mhLxKhDDNzN1Ve/7Kl88QOWeEF1rZnqqgNnXd6TE576f/vlrb7ZCvxv96pcRcpqWlawJtL2jwtvME3bzkzLIq0eHYQ0PKmyaektx6ws5SybsvDbaAufo84+M39uTxCmBfqh/lzUg++XPf4P'),
			this.addDataEntry('building non', 29, 28, 'Building Non-SAP', 'jVVJs6JIEP41XuYwURb4+nlkUSyDwgUU4cbWZQGKISDLr58s4C09HR0zB4PK/fuyssyZpN1a4xk8rrSIk3wmrWaS9iyKajzdWi3J8xlGPJ5J+gxjBL8ZXv/BOh+s6BE8k3v1fwLwGPAK8joZNaOirLp8UpTX4CGO/BYw+KpJzKsgzBOtLI91npRg+vsv0L+SZ8WjIDeDMMn3RckrXtzBGBZVVdzAIRcGNYgy9izqe6wVefEEe5z8DOq8+pZByTkTkVXxAG1QPpJIkPnJ2wRgqwMQ5UOLPjQiVVAFM0kZRbwuX2yG1fYGhLX9xsJ+p8qh29ZRj3iwOaJIL16mFEtxt5Bot3hFt+hFU6Wh2rKPbxEnG//hX2ItlNiScNSY6YmZjlJbttLtxE8jLDDODx9f0d4mgxzjPIsN8E/JgqTyjUjX667JGNHbPt7kpW+rKLmo+d7eIv9yRSa2+qgjgNO8W4hq6g+ysVAoKZWHl2UokTey2d49zhbUbhh1VnNTU1raZ49dpy6JtuhjfcWSTu1jY9mYrvUKjWW342rnY1LQ/lAS/dRDjER5BrkR2wt2Aonzie7dN863qP+Ut3ujfYS38zXK4s5zjw/fXSBifJ3P7uIRb+iS3M+9f9k6kbFO/dOyPl+snHB1QVPEaUpqqpM5yPIoH+qdA1yF3QG5k5HVH6DLrIXu9WYaIYtDR93DkmQrvudemhirH9oB8Iw9YR5ur5Ek6opekdd/+tiEhdi/Rfgsbqgl/B06veWW7DnlVnMa6FZe++66O0rbq2/keXg/fPOAXmW+6/efdZy28S7Hghj+IzQawb8LNZYe7IwTQ+BGnaXJneWc4K4ONXXY3AOe0AdGNZicftWZ6QomRV7QHvrTM2SmZG5xuaNONslwXymVrcFnjamYuBTy9AozUyZZHaotncpEX4E/zIMzfj9kWyfQ52Nq2hDvUKiLWsgngYwgf0VtuYccQtdaF6+ijp+CD+RUJmxowikwIMhF2xEjqml6woBv0I9YM3nQwznQT2BX5ufUG3n3SgU5sGXLrZUe4By1lMsI8gkMjaWvS5gB4AcYuNxTfe0KfmPcoQFdS22BRdSn8OIEFoZ/w2L/jgXOLe2UZuxJBNxO0nRmA3/Jg5yZRHEDvSbyThPcaUNdCj7eHHTtzpbnls5qy/FEHQQ+EKMgevHk5IYq4AXzmzHAiXf6GYsvxaL2ClubgROm0qMyHQL3B/dgMBEjakMtrx/61cdvoaNUUw4X3ndtub/4ydZF5BC+0aCnzrkY7HOBiyGaNe3wlrgCuFfIMpop30lwxTsnfwttJDh01BY+cO8uA95scU5XwOlcmA6td3ousPybz+AXczRgBt6DTPQrHnmxeaCNujgdZfCB2VS/20VN6ZsdsEQLS1OaKa88cNbEnBzxVP/tl7f6bkrw/93LYiVJ6rS0YF0k7R8X36Catp6RFLekenbg0vC4uk7LbzlGXRPOrlMUfh91QTnK7DPya4vCYVqkH+LXwh5sv+zzfwA='),
			this.addDataEntry('building', 29, 28, 'Building SAP', 'jVXJkqM4EP0aX+YwIQtcXT6y2FgOJC/gBW5sLQtj4zBglq+fFFBLT0fHzIEg93wvJciJYtwa6xk8LjSPk2yiLCaK8czzcpBujZFk2QQjEU8Uc4IxgmeCl3/wTnsvegTP5F7+nwQ8JLyCrEoGy2AoyjYbDcUleEhR3AIObz2JRRmEWWIUxb7KkgJcf/8F9lfyLEUUZHYQJtk2L0Qp8js4w7ws8xsEZNKhB9GVP/PqHht5lj/BHyc/gyorv1XQMsFlZpk/wBoUjySSZH6KJgHYeg9E+7CiD4ssFZTBRNEGFS+LF59gvbkBYWO7YthvdTU8NVXUIRGs9igy85etxErczhTazl7RLXrRVKupMe/iWyTIyn/459gIFT4nAtV2euC2q1XM0dqNfAzCA+v48PEFbR3S6zHOrrEF8SmZkVS9EeVy2dRXTsymi1dZ4Ts6Ss56tnXWyD9fkI1ZF7UEcNp3hqih/yArhkJFKz08L0KFvJHV+u4J3jGn5tTdzWxDa5l7eGxafU6MWRebC560ehdb89o+sVdozduN0Fsfk5waNd+YUUFM0lDjCrUR30p2Eon7ie7dt463qPvU11ureYS34yW6xq132j/80wwR60s+nmaPeEXn5H7s/PPajaxl6h/m1fHMMiL0GU2RoCmpqEmmoKuDvqs2LnCVfhf0VkWs28GUeQPT6+w0QkzARE+7ObkuxFZ4aWItfhg7wDPMhHu4uUSK7CtnRV7/GeMQHmL/FuGjPKGGiHeY9Fow1XOLteHWMK2s8k/Ldq+sL76VZeF99y0CZnX1T3732cdtau+8z4nlP0Krlvzb0ODpzrkKYkncqGWGKs9HnlVFXT71gCfMgVMDbk63aO10ATdFndEO5tNxZKdkyoTaUvc66geYBVVZH7PEVN64FOp0GrdTrrAWVcykKjEXEL+Y2u7w/tAdk8Cc96ntQL5LoS9qoJ4COoL6JXXUDmpIW8POXkldP4UYqKmN2NCIU2JAUIs2A0ZU0fSAAV9vH7Be1d4OcmAewK9Nj6k38O60Empg5qgNS3cgRw0VKoJ6EkPNzGUBdwD4AQahdtRcniS/IW9Xg62hjsQi+1P44iQWjn/D4vyOBeSGtlo9zCQCbgdllHnPX/Gg5lWhuIZZE3VjSO60picKMd4UbM3GUafM5BVzPdkHQQzkaIiePTW5oRJ4wf29csCJN+YRyzfFsvcCs1XPCVPlUdougfODc7C4zJG9oZfX9fPq4rfQ1cqxxonCWbLTL3EqO8saMjbq7dQ95r1/KnFxRK91039LQgPcC8Sseqx3kFzxxs3eQgdJDi11ZAyc+4kDbz47pgvgdMxtl1YbM5NY/s2nj4sF6jED714n5gUPvPg0MAZbnA46xMDd1L/7ZU/lmx+wRDNmaPVYV+05G/Ke7PHY/+2Xb/XdVuD/3alyJSn6uLRgXSTNHxdfbxq3npXkt6R8thBSi7i8jMtvPmRdEsEvYxZ+H2xBMej8M/Nri4IwLtIP9Wth975f9vk/'),
			this.addDataEntry('cloud connector highlight', 28, 28, 'Cloud Connector Highlight', 'jVZNc6M4EP01vuxhiwCeiY8YHFseJIIN48ANAyODcZwK2Hz8+n0tSGamaqd2D5Sklrr1+r2W0MywL936PXk78WuWVzNjNTPs9+u1GXuXzs6raqZrRTYznJmua/hm+tMfZh/UrPaWvOevzf9x0EeHe1Ld8tEyGuqmryZDfUreqFtcEol2mWdFkxyr3K7r3a3Ka0z9/Rfs9/y9KdKkcpNjXj1f66Iprq+YPF6b5nrBgoomlkl6lu/X22tmX6vrO+az/Edyq5pfIlhVIcmzub7BmtRveUrJ/Ci6HLCXCoj1YdU+LBQqaZKZYY1D/am+y5m+7C5I2H7eCD3ul+bx0N3SQSuSzU5LnevdNTIj6+cG7+f39JLeeWm13F4M2SUt2CZ+i18y+2jIBSu01i1D6QbWTeyt3rOtXvTmXDhRwdanKjlk18zRCl6mNy/wdVYsjeSw0xJlk8VzEZX5evXV3lsSWLT80FVss5un63DBXndVvvHvkSEGVpoXZpxOXnveuq9C45tmyNaL1j2I+3G96L2Ct3wtqujAv/7YTzH98y01/C43hHY0rCbSF/XRYF/YYBmew824bBbbQphRUG+ZbT26xrj/J6agO8eHePgc++fH47q6xYenfmdsT/G6qo6vvow/+7vvx0ulEY/Zi6jSSrTRQVSBPv+e6iF4O/fPe9aLvTlwZ4WxVGPemxoPGM13GA9u6euiYDJ3VgtWsht3+By8vcXgzN8zaPeBmhClxu6e2svyuH4aaGdk3LLi8b9XdYh5jy/xEL/42GdVuMNPjp/tRZ0c5lX0st2kl6dzcvh+y5zP+UdX31XxK/9ll+fN8pStpYwvVX10iIFt/c0Wy297Jgl5EDDDLS2dFxYx0HrBrnRLNueF2XsBuwko4pZRi7HGB4lqYfMoWN34EEkOxkRhtcyx0NdoLWKdTVRc55ZcZ860zqY1q2acozin0t2bneeEsKGCC43WmbC1wmGwhYPoYQtWxp/38g2XFLu0DWJ25De229IlH+DEfh1i91CuFbbCNLgBv3kOMxS2MjTTnuYjHbF0PpwbqG7wAC3GXhBzxNTFcJY88G9iiAm35tH+wIa+6QUhre24k1Lbc+BAa4jD6gF5zJkTYu35Fw58cKsBy1n3DnzMn+KVUkN/7o75wpfhlBM2pUtPmIDzQRTmgyjVnr0IFC/IjeLJluuKC/CkwZ+3Xrj6gw4h6dhFg9XQPLQFb6RFNOdKH6m04tq/+kvM4XQA84GTXSNNJl+Kg9iUiz8IvVU4wP3YrqiWmMkcH36h9IhbB9zgZkJc7GUN3t4a1N46x9jvVX6DL4ERp09pJCeN5KhRVsNu4CaTNC+GJ9Rv2CL2A247YFnJEZeUkz7UmhwYRCC7sQ64RjXAHNQ7TjkwdhOOsQ7Llam4V7qH/eijamaOGp7i7b4EQUr+yE+iVvw+Ur4RYrPR10kRM9RHvVfoV4OrtF1hvdWrvjNpWlYl+IYdHJfpMGmAmpaEjeqnE2HbYU1H55YPyDMI6VainNqjTbXDHz7r/0K1NuJQmIifUtUj1RnOxHmuzkCwI0wG4tD6DlhJF91TfpZOOeHeR44W1eDgkZZl+kB16wUKX89f3poPTTj9gUrShGmw9ap+HQ4uItwV0iBduXMCF5EpbOKCj/lDC/AODnGW8Cfj6vxSPWhqP+JD7Ufcl6KeNCZMuMO2VAOaZ5NeVIuyH/NgmtIKeaOdi5LOJeUT0VnuwXWj6r+k3D98cE7Bs+it7tNnyhUYjLxg948/0fP4J8bti7/89FTBIyHv/vjcUabprbPOr5e8ee+xpC2y5jQ9eR5Hr1NeyFPzuy2px7H89Pz5dkJnej59DH8+09Tcb6+4fwA='),
			this.addDataEntry('cloud connector non', 28, 28, 'Cloud Connector Non-SAP', 'jVZNc6M4EP01vuxhCwOeSY4YHFsOEsGGcfANAyODwU4FbD5+/b4WTmamalO7B0pSS916/V5LaGLYVbd8j9+O/JJm5cRYTAz7/XJpxl7V2VlZTnQtTyeGM9F1Dd9Ef/pidqpmtbf4PTs3/8dBHx1ucXnNRstoqJu+vBvqY/xG3byKJdp5luZNfCgzu6431zKrMfX3X7DfsvcmT+LSjQ9Z+XKp8ya/nDF5uDTNpcKCkibmcXKS75frObUv5eUd82n2M76WzW8RrDKX5Nlc3mCN67csoWR+5l0G2HMFxPqwah8WChU38cSwxqH+VN/kRJ93FRK2X1ZC3/dz87Drrsmg5fFqoyXO5eYaqZH2M4P3s1tSJTdeWC23H4e0SnK22r/tX1P7YMhHlmutW4TSDayr2Fq9Z1u96M2ZcKKcLY9lvEsvqaPlvEiuXuDrLJ8b8W6jxcom85c8KrLl4ru9tSSwaNmuK9lqM0uW4SM7b8ps5d8iQwysMK+J4bdsVcvE2NwSe1oc9O6WFBeZVGn+7Jw617Y6HoQ1cxaDtz19ZytNumeh8e0cfaEdDKuJ9Mf6YLBvbLU+R7kchN1KEXD4JP1zUMufW+vBNUYcn9iC7rTf7YfPsX96OCzL63731G+M9XG/LMvD2Zf7z/7mx6EqNeIzfRVlUoo22oky0Gc/Ej0Ef6f+Zct6sTUH7iwwlmrMe1PjAaP5DuPBLXxd5ExmzuKRFezKHT4Df297cOdvGTRc58KMgnpNiEZW5sVh+TTQzoqt/OG/V3WIedtX+2H/6mOfRe4OZsWM49FrT+sX+7GOd7Myel2vkurpFO9+XFPnc/7B1Tfl/sx/2+VlNT+mSyn3VVkfHGJgXT/bYv68ZZKQBwEz3MLSeW4RA60XbAq3YDOem70XsKtwuOkWUYuxxgeJqmGzKFhc+RBJDsZEbrXMsdDXaC1inUxUXucWXIfy4zqb1iyacY7iHAt3a3aeE8KGSs41WmfC1gqHwRYOooctWBhf7+UbLilWtQ1iduQ3tuvCJR/gxH4dYvdQrhW2wjS4Ab96DjMUtiI0k57mIx2xdD6cGqhu8AAtxl6w54ipi+EkeeBfxbAn3JpH+wMb+qYXhLS2405Cbc+BA60hdosp8pgxJ8Ta028c+OBWA5aT7u34mD/FK6SG/swd84Uvw2knbEqXnjAB51Tk5lQUas9eBIoX5EbxZMt1xQV40uDPWy9cfKFDSDp20WA1NA9twRtpEc240kcqrbj2r/4SczgdwLzjZNdIk7svxUFsysUfhN4qHOB+bBdUS8xkjg+/UHrErQNucEMhLvaycFNYg9pb5xj7vcpv8CUw4vQpjeRdIzlqlNawG7jRJM2L4Qn1G7aIPcWtBywLOeKS8q4PtSYHBhHIbqwDrlENMAf1jlMOjN0dx1iHxcJU3Cvdw370UTUzQw3f422+BUFC/shPolb8PlK+EWKz0ddJEDPUR70X6JeDq7RdYL3Vq75z17QoC/ANOzgukuGuAWpaEjaqn06EbYc1HZ1bPiDPIKRbiXJqDzbVDp9+1n9FtTbiUJiIn0LVI9UZzsRpps5AsCFMBuLQ+g5YSRfdU36WTjnh/keOFtXg4JGWRTKluvUCha/nr2/Nhyac/kQFacI02HpVvw4HFxHuCmmQrtw5govIFDZxwcf8oQV4B4c4S/ijcXV+qR40tR/xofYj7gtR3zUmTLjD1lQDmmeTXlSLsh/zYJrSCnmjnYmCziXlE9FZ7sF1o+q/oNw/fHBOwbPo8Tf78LnnCgxGlrPbx5/oZfwj4/bF3/7+ZMFjIeu+fPYo0/3Ns8wuVda891jS5mlzvD99HkavY5bLY/OnLa7Hsfz0/PWGQuf+jPoY/nquqbk/XnP/AA=='),
			this.addDataEntry('cloud connector', 28, 28, 'Cloud Connector SAP', 'jVZNc6M4EP01vuxhC/MxkxwxEFsOEsGGceCGgZGRwbgCNh+/frsF8cxUbWr3QElqqVuv32sJLTSr6tcfyfVE6ywvF5qz0KyPum6nXtVbeVkuVKXIFpq9UFUFvoX68sXsUs4q1+Qjv7T/x0GdHO5Jecsny2Ro2qGcDc0puWK3qBIO7SrPijY5lrnVNLtbmTcw9fdfYL/nH22RJqWbHPPyrW6KtqgvMHms27auYEGJE6skPfOP+nbJrLqsP2A+y38mt7L9LYJZFhw92/oK1qS55ikm87Poc4C9kkDMT6vyacFQSZssNHMaqi/NnS/UVV9BwtbbhqnxsNKPh/6WjkqRbHZKatd3V8u0bDA0Ohj3tErvVJgdtZ7HrEoLsomv8XtmHTX+TAqlc0XI3cC8sb05eJY5sEE3mB0VZH0qk0NWZ7ZSUJHevMBXSbHSksNOSaSNF29FJPK1893amxywKPmhL8lmZ6Tr8JlcdmW+8e+RxkYi9Fuq+R3ZNDzVdvfUWoqj2t9TUfO0yopXmy5dy+yZfW6ITZZsf/5ONgp3L0yh+xX0mXLUzDZSn5ujRr6RzfYSFbwDH50NHafC6V6Dhv/cm0+uNuF4YAv6c3yIx8fYPz8d1+UtPrwMO217itdlebz4PH70dz+OVakgn9k7K9OSddGBlYFq/EjVEPg7D297MrC9PlLbgTGXYzroCg0IzvcwHl3hq6wgPLedZyLIjdrUAP6uMXDn7wlouC2YHgXNFhFNrKzEcf0y4s6SreLpv1f1EPMeV/EYv/uwj1O4o14R7XTyuvP2zXpukoNRRu/bTVq9nJPDj1tmP+afXHVXxhf62y5vm9UpW3MeV2VztJGBbfNqsdXrnnBEHgREc4Wp0sJEBjov2AlXEIMW+uAF5MZsqrsi6mCs0JFD1RAjCpwbHSNOgTFWmB2xTegruBZinXWovN4VVCX2vM7CNU47zWGck3D3eu/ZIdigkgsF1+lg65hNwBaObABb4Ghf7+VrLipWdS3E7NFvarfCRR/ACfv1EHsA5TpmSUyjG9CbZxNNYhOhng44H6kQS6XjuQXVNRpAC2MviCnEVNl45jTwb2yMEbfi4f6ADfq6F4S4tqd2iu1AAQe0Gjs4S8jDIHYIa8+/ceADtwpgOavegU75YzzBFegb7pQv+BI47YhN6jIgJsC5ZIW+ZELuObBA8gK5YTzeUVVyATwp4E87L3S+0CFEHftoNFucB22BN9QiMqjUh0utqPKv/hzm4HQA5gNFu4KazL4YB2JjLv7I1E7iAO6n1sFaIjqxffALuYfc2sAN3FAQF/YyR29vjnJvlcLYH2R+o88BI5w+qRGfNeKTRlkDdg1uNI7zbHyB+g07iL2EWw+wOHzCxfmsD7Y6BQws4P1UB1TBGoCbCnTwVcDYzzimOhSOLrmXuofD5CNrxoAanuPtvgVBiv6QH4da8YdI+kYQm0y+dgoxQ3XS24F+ObpSWwfWm4Ps27OmohTAN9iBY5GOswZQ0xyxYf30LOx6ircsrKcj5BmEeCthTt3Rwtqhy0f9V1hrEw6JCfkRsh6xzuBMnA15BoIdYtIgDq7vASvqonrSz1QxJ7j/IUcTa3D0UEuRLrFuvUDiG+j7tf3UhOKfSKAmRAHbIOvXpsBFBHcF11BXap+Ai0hnFnJBp/xBC+AdOISzBH80Ks8v1oMi90M+5H7IvWDNrDFigjtsizWgeBbqhbXIhykPokitIG9oDSbwXGI+EZ7lAbhuZf0LzP3TB84p8MwGs3/4zLkCBi0vyP3zT/Q2/ZHh9oW//fxkgcdC3n/57JGm+c2zzusqbz8GWNIVWXuanz5Pk9cpL/ip/dOWNNOYPzx/vaGgMz+jPoe/nmty7o/X3D8='),
			this.addDataEntry('cloud highlight', 28, 18, 'Cloud Highlight', 'jVVbk6I4FP41vuzDFk1wpn1EoDUuiY1i0/DGbWIgiCUgkF+/J2jrzFRN7VZpJec7ObfvJJwZsqphdYnPR1JnuZghZ4asS123t101WLkQM13j2QzZM13X4D/T3/6gfZm02jm+5Kf2/xjoN4NrLLr8htyAph3FHWiO8VlteRUzWJd5xts4EbnVNLtO5A2o/v4L8Gt+aXkaCzdOcvFeN7zl9QmUSd22dQUHhFIs47Rkl7o7ZVYt6gvos/xH3In2Jw+m4ExZtvUZ0Lg556kq5gcfckh7OSVifqHaF6JcxW08Q+ZN1N+aK5vpy6GCgq33NdWjcWkkwdClUuPxeqeldn11UYaycY7IOL+mVXolhdkTayGzKuV4HZ2jz8xKEFtgrvVucWCub3Z0b45byxy2lqERH3O8Ooo4yOrM1jjxWUdtZ8R8ieJgp8UKKxh/52GRr5zv1t5kkIuWB4PA6908XR0W+LQT+dq7hohKXBgVRsfjti837olqZN3KbLXo3YBek9Vi3HLSkxUVYUC+/9jffXpllyJvyBHVEmS2ob5oEoS/YWmirU2MqGgXG06N0G822DJfXXSL/8jJH8ooiORD9srXZCW6KHgbd2hzjFZCJCePRY/97iOphKZ4zD6pSAXtw4AKX59/pPoBeCvH9z0eCTd6YjOQmZIHahkGLUqlH5TeLZyBjJjltrPABe6ITebA2zkCzrw9ht59Za0yStHumlrLIlm9SRUZKu4xf/3vUwP4vEZVJKNPD+I43JVPjt+tRRMHcxF+btZp9VbGwUeX2Q/9q6vvRHQiP0V5Xy+P2YqxqBJNYisGNs0/Fl3+s8dMZe77h27rmxLbIVTkIU+GcCOIhm2oUHov2C47Wjhzd2/A3pFu4el01DoaEGCE9WRv9tg+dKTwEOg76pu68kX9FGTSUenNY8sYSLErgNGe2iUjloncgkiwBX/YIPwh39ZP0pLRGLc2ZnQ0JJFOe1/v8lvt+h7ke9BCyAW6BrHMFjoEL0PJ5gj5jtQvATN7uldYaqj9pPcPLw8c4k37AwPMk6S6xaYyhDw1wEpJuAa1hi+UP+TbeiK/4eZv+jMlPnBgh2jiUwff3NCBE+VbA/40sFE3S98+5dtaObCW0AcP+qPOK55NNuXKjZFIxsje0CbO7zqy1wbgb65e+9QnnbVwxgCOQE6l4ghqG4jEky2x8VOe1o284+xX/KGvCXxRiC+OSoa4wJ2jTbFVDtBn4ELxP+VFZKniyO3+Kz9lSwZsLwuoA+6RenFEYdpUlwV1KZ7APrbv/YU+U58w0L2QUflxpliuX4I+HGNLA35SFPoTD6ruO1eOqh3uEGkVn550kOL5due8uTpLoVbqQ23ckM+7rfpBv8ErrOJgaNzPzUuivnrVhx4F82u08p4vUvbXFEWnd6Zmj/ot7wMKRkM+/HHITdB9wq3yusrbywhHep61x/uge71ZHXPOjl9WdyxubjJ7WD4nJmzuQ/NLfA7nSffL7P4X'),
			this.addDataEntry('cloud non', 28, 18, 'Cloud Non-SAP', 'jVVbk6I6EP41vpyHUxFwd+YRgdE4JIriOPDGbWMgiCWgkF+/HXB0d6u2zqnSSvrr9O3rhJ7oVtktLtH5SKo0ExPdmejWpaqacVd2VibEREM8nej2RNMQ/Cfa21+000GLztElOzX/x0AbDa6RaLMRGYG66cUdqI/RWW15GTFY51nKmygWmVXX21ZkNaj+/Qfwa3ZpeBIJN4ozsalq3vDqBMq4apqqhANCKeZRUrBL1Z5SqxLVBfRp9iNqRfOLB1Nwpiyb6gxoVJ+zRBXzg3cZpD0fEjG/UPSFKFdRE010cxS1t/rKJtq8K6Fga7OkWtjPjfjQtYlEPFpuUWJXV1dP9bSf6aSfXZMyuZLcvBHrVaZlwvEyPIefqRXr7BVzdHPzPXN9s6U7s19bZre2DER8zPHiKKJDWqU24sRnLbWdHvO5Hh22KFJYzviGB3m2cL5bO5NBLig7dAIvt7NksX/Fp63Ilt410KnEudEmunfDy5ol+vaaWNM81rprklcsKVP+bhedC7GJv6+x7cj1rviOl4i5J4rIbg57imLdbALttY51/A0vV6eAM0mtG6M+AZukf/dr9mNnvrj6mMcjN78rwkMoH7JXvMQL0YaHt36rr47hQoj45LHwsd9+xKVAis/0k4pE0FtwoMLXZh+Jtgf+in6zwz3hxo3YDGSm5I5ahkHzQuk7pXdzpyM9ZpntvOIct8QmM+DvHAJ33g5DD1ecGoFfr1RGIyvzPF68SRV5YIu//PepDnxewzKU4acHcRzuSqPE+vG4vhWrjfVaR4eZCD5Xy6R8K6LDR5vaD/2Lq21FeCK/RNks58d0wVhYijq2FQOr+t2i8/cdZipz39+3a9+U2A6gIk/3ZAA3gyBsQ4XSm2K7aGnuzNydMVWddHNPoz1q6YEAI+xGduYN2/uW5J4O+pb6pqZ8UT8BmbRUerPIMjqSb3Ng9EbtghHL1N2cSLAFf9gg/CGP6ydpSG/0axsz2huSSKe5r3f5rXJ9D/LdowByga5BLLOBDsELUbLZQ7499QvAzBvdKSwx1H7Q+/vpA4d4w37PAPMkKcfYVAaQJwKskIQjqDWYUv6Qx/VE/sDNP/RnSnzgwA70gU8NfHNDA06UbwT8IbBRN0tbP+VxLR1YC+iDB/1R5xXPJhty5UZPJGNkZ6CB87uO7FAH/M3Uqx/6pLEGzhjAEciJVBxBbR2ReLAlNn7Kw7qSd5z9jj/0FYEvC/HFUckQF7hz0BBb5QB9Bi4U/0NeRBYqDrz+r/yULemwPc+hDrhH6sURhaGhLgvqUjyBfWTf+wt9hi8CA92U9MqPM8Ry/QL0QR9ZCPhJ9MAfeFB137lyVO1wh0ij+PSkoyuexzvnzdRZCrVSH2rjhnzebdUP+g1eYRkdutr9XE1j9fUrP7TwMLuGC+/5IuXtmujhacPUDFK/+X1QwYjIur8OuwG6T7pFVpVZc+nhyI2nzfE+8F5Gq2PG2fHL6o5F9Sizh+VzcsLmPjy/xOeQHnS/zfCf'),
			this.addDataEntry('cloud', 28, 18, 'Cloud SAP', 'jVVbk6I6EP41vpyHUxFwd+YRgdE4JIrgOPDGbWO4iCUgkF+/HXB0d6u2zqnSSvfX6XT31wk9U42yX13Dy4lUSVrMVGumGteqaiap7I20KGYK4slMNWeKguA/U97+Yp2PVnQJr+m5+T8OyuRwC4s2nZAJqJuhuAP1KbxIkZchg3WZJrwJoyI16nrfFmkNpn//AfyWXhseh4UdRmmxq2re8OoMxqhqmqqEDYU0LMM4Z9eqPSdGVVRXsCfpj7Atml9O0AvOpGdTXQAN60say2J+8D6FtJdjIvoXir4QeVTYhDNVn1Tlrb6xmbLsSyjY2K2pEgxLLTr2bSwQD9d7FJvVzVYTNRkWKhkWt7iMbyTTO2K8iqSMOV4Hl+AzMSKVvWKOOjs7MNvTW+rqw9bQ+62hIeJhjlenIjwmVWIiTjzWUtMaMF+q4XGPQolljO+4n6Ur67vh6gxyQemxL/B6v4hXh1d83hfp2rn5KhU409pYdTq8rlms7m+xMc8ipb/FWcXiMuHvJpnbEJuaeY1NPKdu/h2vEbPPFBF3CTJFkao3vvJaRyr+htebs89ZBz4aHTpGMqt792r2w9VfbHXK45Gb1+fBMRAP3clfolXRBse3Ya9uTsGqKKKzw4KHvP+IygJJPpNPWsQF7fwjLTxl8RErB+AvH3YuHgjXOmIy0JnUe2poGs1yae+l3c6sngyYpab1ijPcEpMsgL9LANw5LoYebjjVfK/eyIwmVpZZtHoTMvLIFn/57109nHkLykAEnw7EsbgttBKrp9O2yzc747UOj4vC/9ys4/ItD48fbWI+7C+2si+CM/klym69PCUrxoKyqCNTMrCp3w26fHcxk5l73qHderrApg8VOaojfLgZBEHXWiKcOTbzlmbWwnY1kC1hZ45CB9TSIwFGWEdcvcPmoSWZo4K9pZ6uyLOoF4NOWiqcRWhoPcn2GTDawY1gxNBVOyMCfOE8rBH+0Kf1kzRk0IatiRkdNEGE1dzXu/5W2Z4D+R6QD7lA1yCW3kCH4IVIXR8g34F6OWB6R12JxZqUR7t3mD9wiDfKBwaYI0g5xabChzwRYLkgHEGt/pzyhz6tZ/IHrv9hv1DiAQemr458KnA21xTgRJ6NgD8EPvJmKdunPq2lBWsOfXCgP3K/5FlnY65cG4hgjLgaGjm/24iLeuBvIV/92CeFNbBHA45Aj4XkCGrricCjLzHxUx/Xjbjj7Hf8Ya8IfFmIV5ykDnGBOwuNsWUO0GfgQvI/5kVELuOIrfuVn/QlPTaXGdQB90i+OCIxNNZlQF2SJ/APzXt/oc/UIwxsczLIc6wxlu3lYPeH0EDAT6z63siDrPvOlSVrhztEGsmnIyxV8jzdOWch91KolXpQG9fE827LftBv8ArL8NjX9udmHsmvX/mhBMfFLVg5zxcpulusBucdkzNI/pb3QQUjIu3/OuxG6D7pVmlVps11gC0dT5rTfeC9TF6nlLPTl9cdC+tJZw/P5+QE4T48v9TnkB5tv83wnw=='),
			this.addDataEntry('collision highlight', 28, 26.83, 'Collision Highlight', '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'),
			this.addDataEntry('collision non', 28, 26.83, 'Collision Non-SAP', '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'),
			this.addDataEntry('collision', 28, 26.83, 'Collision SAP', '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'),
			this.addDataEntry('da highlight', 28, 28, 'DA Highlight', 'jVVNc6M4EP01vuxhCyMxEx8x2FguBLFN7MANBMOXMC7zrV+/LeNMJruVqj1Qkrr1ul8/CfUCGdVo3cNbRus44Qu0WSDjXtftPKtGI+F8oSp5vEDmQlUV+Bbq9hvv8uFVbuE9ubb/B6DOgD7kXTJbZkPTTvxpaLLwJqd5FaYwrvvk3uYs5HYYJfy1bvI2r6/gj+q2rSvYwKVjHbIyvdfdNTZqXt/BHye/wo63f0TQeZ5KZFvfwBo2t4RJ0r/yMQF660dC/cOqgCWJ8zaMeGI0zbHjSQPmv//62ClThG24QPq8VLdNny7U9VhBwcbrzlGDaY2jy9gxccORxbtQKHm4OyrMrHsbxSieNEQnrWcV66lXau5pNe+bSJpYyya60hWpMiXe6T/saQUI1sWCdhHaX21BBmrqPUPBleRrNbyc0aFa4dcTGexCB1+KXc+fXG8zOd6b5ni6Ros0pYY+0Qlr4FMd8aaAX1BB5f6UFoec7ALOrs4tUvGKFJuOnkgaXg4rUo5ZcjlP72IDe+JbsDvWkOu7WDmxMh5e4jo2lVzGfc39IrE2P4mhvzB01CLrLY13fAg8uBvWGcfGqmCI/t5nHMqOocOQIEeJkN766qqJEPlBhD746jnzRbva5w72vWZvnDQRm9ufELdnxrKI1LFnRV1Qk2EqsspFSkVQlrlDmRJz6J/54ayeEcA6lsElEH+wlLYmvGjcf9/vWLUtQeEuNta3ACo6gCqJuQGFdFCjHKXqcAqYFnO1YJukOo5B0gDts8DiPLoez1HFFQa3IH53OOPO4F8c7qnamalv+Zfc8MENkpWnvjpmoMyKXB2FGqT/bl+kBhVTzwrkHYFLEVlbIXOBirB++bNaiTJW/63OxLNO08P/b0VemLVVQmNdhZexsd/3S9AQ7udZDS5aH1hQtRXcImsApucpMtLicCrBJu+OMjoGRs5pUOwiRf6kdNRjrV0ckH3CmMLaMeW61GxTh/FNsc1N5xSkpSc8ucYw2QVVbI907knOUw1wimvg0TlJbNq5JmmoMXSuVzaAUWmOl84HDmLRgjVgg/gQwywhvy9zStw8ShzgHe/QzvhhtAuCZE4qDjPWm7GQDzhulsAfP/jnwwAj/L8KYPwJ5pBbeXKWudP2E89DzyPCLhhwYcBjT+Hfhz0Q19sXgJ2kHvAfQQ5fajE9Y0s/cXIsHvoJH/iCTZCnlqXkgzwDT04+IHgDZp3hvXBMAn66BB1g1MVDW/PYUE/vQNvRuaSDP8m8WEDtS1dqK3MaML4DXrzJejHkkOe1jMwNvDFQk3cuQCOpAZyr5Fuq8vwghnCttKPmFmrdgA76CLoDhsH9UaSdgh7IfuhPG6gJz+d6rCUnR8QNcFGBG9REsS31ERT4gn5eEH65zS82gpdWYNk80PrZXuDBT8ZvW9TD9OxPVlJXSXufYMuQx232bFMvMypL8jRrv9rCZl6nv5Gf/Q4mz5b3sfxsrQ/fl877Dw=='),
			this.addDataEntry('da non', 28, 28, 'DA Non-SAP', 'jVVdk6o4EP01vuzDFvKxOz4iOBiXwKiMjrxB4EYQxJLP8Ov3RJy9d3ZrqvaBStKd0336JKRnmlUOzj26nWmVpMVMW800615VzTQrBystipmqZMlMs2eqquCbqa/feOcPr3KL7um1+T8AdQJ0UdGmk2Uy1I0onob6HN3kNCsjjnHZpfcmY1HhRnFavFV11mTVFf64apqqxIZCOpYRu/B71V4TqyqqO/xJ+iNqi+aXCGaRcYlsqhusUX1LmST9IxtS0Fs+EpqfVgWWNMmaKC5Sq653bZHWMP/+2+dOmSJqoplmTkv1te74TF0OJQq23taeGoqlHh+Hlo03PXaKNhqVLFrvFGZXnaslWiIMjQqjYyXraHAx/P1i2icIT515HV/pgpRnJVmbf7hiAQRrk5G2sba5uiPpqW12TAuvJFuq0fGgbcuF/rYnvZub8HHdD07CD1bCC94NLzANmnNOLVNQoRvwqd74rsA/0pHK/Zzm24ysw4JdvVus6guSr1q6Jzw6bhfkMpzT40F8jCvsSW7helch13exMuKci+iYVImtZDLuW3bKU2f1J7HMF6btjNh558m66MMAd8M56Im1yJlGsc8YE9vkqViOibPo3aPXxc5C+NlShCqpkKMm9mrw9j2nATX+Cmr+Y2+2TNsOZF1zxO6YNc9jdehYXnFWJtlfNlVcy5xT0XNvJDdfLBfE7rsnD5zZJvP0EyIRe7iEx3D8ha201dHRKE4fmzUrXy9Quk2s5S1EZVuok9orKGVClcsg1cdp6DSfqoZNSJU8i/BQ25xDpyji6+4Ql4XCcBuSD69ghdefjl4RqMaBqe/Zl9z4cJOUWDP5SR3OUGhBrp5CLdJ9ty9Ww5KpBwV5B3DJY+d1lLkeCmUvv1YrUdbiv9XZekm089kXD/+/FXlhzqsSWcsyOg61+7GZQ0Pc04MaHo0udFC1E95ipwfTg4gtnm/3F9jkHVIGz9I1nJ3i5lw7CaWlAWvcfKu5e12nWHu2XF8M1zYxviuuvWq9nDR0rwvf6oWb4ywD0vp7OecGcIpv6bgPEstb3yY1tfrWDy41MCrN9Ln3iUMsmrMaNsRHDPuC/CeZU+KmUeKA94JtM+H7wc2JJnPScTthgwmLfOC4moO//uCf9T1G/McKMCeBOXIrT84yN29+4osoCMjo5gxcGHhsKN4A7EHcYJMDK6Qe+J+Q4yS1EM/Y0k+8TB8f+o0n8IVtJE8tL5KPFli68LJew1sw6Yx3w7MJ/HQOHTCa40Nbe1fTwGyh7eAdeX8SMq8+ova5L7WVOS2MH8CP77JeHTnkec1je4W3BjUFhxwaSQ1wrpLvRZXnhxij7/CW2q+odQUdzAG6A8NwfxRpp9BDcx/60xo16dO57irJyRuTGlxUcENNVHelPiMFX+gXhNGX2/zianhxR102EW35bDN4+NPh21b1MD37lJNWZdrcBbb0WdKcn+3qZUKd04yfm6+2qJ7W/B/kz76HybP1fS5/ttiH70sH/hs='),
			this.addDataEntry('da', 28, 28, 'DA SAP', 'jVXRkqo4EP0aX/ZhCwnujo8IDsZLcFTUkTcI3AiCWAJC+Pp7Is7Ond2aqn2gknTndJ8+CekRsYrOuYXXEyvjJB+R+YhYt7Ksh1nRWUmej3QtjUfEHum6hm+kv37jHT+82jW8JZf6/wD0AXAP8yYZLIOhqmX+NFSn8KqmaREKjLN7cqtTHuZuGCX5W1mldVpe4I/Kui4LbMiVYxbys7iVzSW2yry8wR8nP8Mmr3+LYOapUMi6vMIaVteEK9I/0y4Bvdkjoflh1WBJ4rQOozyxqmrT5EkF859/fOxUKcI6HBFzWOqv1V2M9FlXoGDrbeHpgZwZ0aFreH81Iidvwl5Lw8VG43Z5d0lMYjkhTE7uvOB35p8nq+102CepSJxxFV3YlBYnLV6Yf7lyCgRv4p41EVle3J62zDbvnAQXms708LAn62JqvG1p62YmfMJY+Ue58ufS83cTzzcnLBOCWaZk0pjAp3v9ToO/Zz1T+wXL1ildBDm/eNdIN6Y0mzdsS0V4WE/puTslh7187+fYE1+DxaZEru9ipdQ55eEhLmNbS1Xct/SYJc78b2qZL5xsJpGzE/EibwMfd8PZG7E1zThh2DfpY9sUiZz1sTNt3YN3j5ypXKUzGei0ZP2uovZcW21b8N2Nf/iV+Lk1G07WHV1UArHv3Bpnkd7deVYKXsTpD9sERhBX1e6b15WcTand3p88cGbL1DOOiETt7hwcgv43tspWhYdJfnxfLnjxeobSTWzNrgEqW0OdxJ5DKROqnDulPk7DYNlQNWxSqeRZVARkeQqcPI8um31U5BrHbYjfvZznXns8eLmvT/Zc36VfcuPDTdIiYoqj3p2g0JRePI1Z9P7dvkgPCq7vNeTtwCWLnNde5XoolL78Xq1CWdP/VmcbBSWn00o+/P9W5IU7r1pozYrw0FXu+3IMDXFP93pwmNwDB1U7wTVyWjDdy8gS2Xp7hk3dIa3zLIN421ZzM0GOUmuYz2s3WxN3axgMa89W6/PEtU2MO821542X0ZptDbmyWulmTHN92uD8MRcT4LSVZXTeVmFFs7Jpxay2WfnnChidpcbY+8AhFst4BRviI4Z9Rv6jyqlww6hwwHv+uh7wbedmlKicrF8PWH/AIh84zsfgbzz4p22LEf+xBsxRYo7c2pOzyi3qT3we+j7t3YyDCwePJcMbgD2I6y8zYKXSA/8TchyVFvIZW/mplxr9Q7/+CL6w9fSp5VnxIb5lSC9tCd6CQWe8G55N4Wdj6IDR7B/a2psK/0QDbTvvINqjVHmNHrWPV0pbldPC+A58v1P1Gsihzmsc2XO8NajJ32fQSGmAc1V8z7o6P8ToV45omP2KWufQweygOzAc90dTdgY9iPvQn1WoyRjOdVMqTl4fV+CigxtqYoar9OkZ+EI/Pwi/3OYXl+DF7Q3VRMjs2Wbw8Cfdt63qYXr2KScpi6S+SWxp07g+PdvVy4A6Jak41V9tYTWsxT/Iz76HybP1fSw/W+zD96UD/wI='),
			this.addDataEntry('deploy highlight', 25, 28, 'Deploy Highlight', 'jVZNl6JKDP01bt7iHQScaZcItlYPVTaKbcOOrykpsPE0IFC/fpIC7ZnFnPcWHitJ5Sa5SbRmhn3pN5/R9UyrNCtnxnpm2J9V1YynS29nZTnTtTydGc5M1zX4zPTnv1jnyqpdo8/so/k/DvrocIvKNhs1o6JuhnJS1Ofoisf8EnH4XmVp3kRxmdl1vW/LrAbTv/+A/pZ9NnkSlW4UZ+VrVedNXn2AMa6aprrAhRINqygp+GfVfqR2VVafYE+zn1FbNr8hWGXO0bOprqCN6muWYDE/8z6DtFcqEeuu1e4ahIqaaGZYo6g/1zc+01f9BQq2X7dMD4eVGZ/6NpFaHm33WuJUN9dIjXRYGHRY3JJLcqPC6qi9lOklyck2vIbvqR0bfElyrXPFkbu+1bKDNbCDOTARcCp4TjbnMjqlVepouZK36TXc7qvXA7nfy1/zQGSb9Xf7YHHIRctOfUm2+0WyOS7Jx77Mtt4tMJgkwrwQ43zedcWL+8E0um1kull27ond4s1y2OW0oxtWBif6/edhwvSKNjG8PjOYFhtWE+jLOjbINyItY+dQMxTN8iVnZuDXL8S2nlxjjP/Iye+L8BTKh+wVT/GmbMPT87A3Xs7hpizjD4+Hj/P+Lb6UGvKYvrMyKVkXnFjp64u3RD9C/cWAtdPB7KlPQOZfsgzQ3oMsXeEZzCY8c9ZLItYtk0VP8tU1BB69A4He3bPGjBJjf0vslYg3zxIjQ8UdyZ/++xZi3sJLKMN3D+Pkrvzi+NVe1tFpUQbvL9vk8lxEp7c2dR72J1ffl+EH/S3K63Z1Tjech5eyjh1k4KX+YbPVjwPhmLnvE80Va53Zlu6KQGcb2jLH6l1B5jANOnVIy3wO1Qcdzc3FzvE4ta2W+tbCPZgd9XkLU9jjmflHOCcyFWvwX89Zgd90QZx1S2WBfh2cYQoBQwCGpHpsaz09ANMO4QzwmfMmXJxCxPI9Hc5zKgrAXWM8E3IYqF80gDvsAA/tTBxBtmArNOjKGnOBOyWFGgDbGqhtSirDM8QxYBsgp2ROHAvz6ZW/kzSqvhOF73W3O2gQ7zgHW8+E14ydB50faKDTmR+e2GAuqHhBTLlTmFjniEls06D+uqGqjnPNMIbkDUzUPBjMYeeTKc49d+QfaxtjJIOpwZ2WOpCDSBQ/TOxrwAT7USdOKsAHueiYpMAjMaFWCTlpVHLoXzGAXWMjVyN3wut3h1FmwhpS4bU7JzACaXFXFNoO6mMOYsNkO2RwMZYMjId8AGzsHd6TnoHcwK8H1thBb7EfJvI/8Yb9e+gwnos8OXS6X+qu70F9nuE7AdqBu2O7848S5kFTs5ODjwjMVGC+ZB478C2pRuA+bCn0b5Rdf5TfBNQtqPQdnDno14D+lhFgfIdivhPvAWBjTsnUy6BR/Dpc1QbzPDxmCfjAGcJ52MEeKJ5HHu4c4H7wsc+8mXYE46gdYT5ZjFhqHlQfsgLm3Yb7knLqJ4DJZTD1TXGn8gNc7KMY+wF7YOJsQS4LNSNOAvt41JmaU+wtH6b6xt09jPEU7yru0VS5XZCb49hTP7nvYzPO2Dh7wD/Un5hQM9wNFkzthAezhbGK4c7ZF4/AEcZwCuiN1Yw5mt3OR9wj9F/VCmcOuwd7KJAnr8NdBLyJM/V70z1mRWFAbva0+6petQe419/++B3F/wc9lCb+/Rur6YEAf81Z/9dHhlJNL4xNVl2y5nOAK12eNufpobEYvc5Zzs+Tl/406qJ6lPnD8+vFAofp0XIXvx5HyvbH2+kX'),
			this.addDataEntry('deploy non', 25, 28, 'Deploy Non-SAP', 'jVZLd6pIEP41bmYxBwHvJEsEo23oNgjGwI7XbWlQPAIC/eunCtDcu7hnZpFDV1XX66uvTM8089ytb+H1RMskLWbaaqaZt7Ksx9O5M9OimKlKlsw0a6aqCvzN1Lc/WOeDVbmGt/RS/x8HdXS4h0WTjppRUdV9MSmqU3jFY3YOOXyXaZLVYVSkZlXtmyKtwPT3X6C/p7c6i8PCDqO0+CirrM7KCxijsq7LM1wo0LAM45zfyuaSmGVR3sCepD/Dpqh/iWAUGUfPuryCNqyuaYzN/My6FMpeDoUYD63y0GCosA5nmjGK6lt15zN12Z2hYfNjw9SgX+rRsWtiqWThZq/EVnm3tURL+oVG+8U9Psd3KoyWmq8yOccZ2QTX4CsxI42/kkxpbXHgtmc0zDV65uo9Ez6ngmdkfSrCY1ImlpIN8ia5Bpt9+eGSx73sI/NFul79Y7oGh1qU9NgVZLNfxOvDK7nsi3Tj3H2NSSL0JtaclmwqHmv7e2zORaR291iUPD4n2buVd7ZpdNQ7VMRayZ2b/0M2CrcvTKHuEs5MiTSj9tXXKtLID7LZXvyMS2a2nHkUfOL+3av4T9d4sbWxjmdtXpcHx0A+ZSd/idZFExzf+r22PQXrooguDg+e5/1ndC4UxDP5YkVcsNY/ssJTF5+xegAc8h4xoL0O9RKQ+bcsfbR3IEtbOBozCU+t1SsRq4bJvCPZ8hoAno5LYIbbjOm+V22xohGVpYjWbxIzD2hlL/99C2Peg3Mggy8H82S21M9EO512bb79MF+r8Lgo/K/tJj6/5eHxs0msp/3FVvdFcKG/ZPnYLE/JmvPgXFSRhQhsq3eTLd9dwrFyzyOKLVYqMw3VFr7K1rRhltHZgsyBFSq1SMM8Dt37Lc30xc5yODWNhnrGwnb1lnq8ATZ2eGbeAc6xTMQK/FdzluOXLoABDZU5+rVwBjZCDAExJFUjU+moC0hbhDOIz6xPYSMbMZbnqHCeU5FD3BXm06GGnnp5DXH7HcRDOxMHkA3YDgWmssJa4E5BoQeIbfTU1CWVwQnyaLAVUFM8J5aB9XSDvxXXQ39HCt9Vu3MVyHeYg61jwqnHyYPO8xXQqcwLjqzXF1RsMSaw25j6HGMSU9eot6rp0MepYphD8hoYNfd7vd95ZMrzqB3xx97GHHGvK3CnoRbUIOIBHyb2FcQE+0ElViLAB7FomaSAI9GhVwk1KVRymF/eg11hI1YjdsLpdu4oM2H0iXCaneVrvjS4LXJlB/0xC2MDsy3S25hL+tpTdiE2zg7vSUdDbOBXBHtsYbY4Dx3xn3DD+T11mM9GnCw63S9U23OgP0fzLB/tgN2h2XkHCXxQBu5k4CN8PRFYL5lHFnwlVQjchy2F+Y2y7Y3yp4C+BZWehZyDefXob2g+5rco1jvh7kNsrCmeZunXA74WH3oDPvdPLgEeyCHkww72YMB5xOGBAe4HH+fM62lHMM+wI8wjizHWwIdhDmkOfDfhvqScejHE5NKf5jZgN9QHcXGOYpwH7IGO3IJaFgNHrBj28aCygac4W95P/Y276475BtyHvAd9qO2M2BzGmXrxYx/rkWMj9wB/6D/WoWe46y/YsBMOcAtz5f0Ds28cASPMYeUwG6Mea9TbnYdxDzD/oVc4c9g92EOBODkt7iLEmzAbfm/aJ1eGGFCbOe3+0O+wB7jXP377HcX/D2ogdXwGaMvpoQD/otPuj4+NQTW9NNZpeU7rWw9X2iypT9ODYzF6ndKMnyYv9WXUhdUo86fn98sFDtPj5SF+P5IG229vqH8B'),
			this.addDataEntry('deploy', 25, 28, 'Deploy SAP', 'jVZLl6pIDP41bmYxBwHvdC8RbC2bKhvBtmHH65YUKB4Befz6SQq0713cM7PoQyWpfEm+JHbNNPPcrW/h9UTLJC1m2mqmmbeyrMfTuTPTopipSpbMNGumqgr8zdS3P1jn0qpcw1t6qf+Pgzo63MOiSUfNqKjqvpgU1Sm84jE7hxy+yzTJ6jAqUrOq9k2RVmD6+y/Q39NbncVhYYdRWnyUVVZn5QWMUVnX5RkuFGhYhnHOb2VzScyyKG9gT9KfYVPUvyAYRcbRsy6voA2raxpjMT+zLoW0lzIR46FVHhqECutwphmjqL5Vdz5Tl90ZCjY/NkwN+qUeHbsmHpQs3OyV2CrvtpZoSb/QaL+4x+f4ToXRUvN1SM5xRjbBNfhKzEjjryRTWlscuO0ZDXONnrl6z4TPqeAZWZ+K8JiUiaVkUt4k12CzLz9c8riXfWS+SNerf0zX4JCLkh67gmz2i3h9eCWXfZFunLuvsYEIvYk1pyWbisfa/h6bcxGp3T0WJY/PSfZu0bltGh2z8opYZM7c/B+yUbh9YQp1l3BmSqQZta++VpFGfpDN9uJnvAUfnfUt5Ltq372K/3SNF1sb83jm5nV5cAyGp+zkL9G6aILjW7/XtqdgXRTRxeHB87z/jM6FgnwmX6yIC9b6R1Z46uIzVg/AQ94jB7TXO+oRkPm3PPho70AebOFozCQ8tVavRKwaNuQdyZbXAPh0XAI93GZM971qixmNrCxFtH4bMLJkK3v571uIeQ/OwRB8ORgnswf9TLTTadfm2w/ztQqPi8L/2m7i81seHj+bxHraX2x1XwQX+kuUj83ylKw5D85FFVnIwLZ6N9ny3SUcM/c8othipTLTUG3hq2xNG2YZnS2wa7pKLdIwj0P1fkszfbGzHE5No6GesbBdvaUeb2AaOzwz7wDneEjECvxXc5bjly6ItWrokKNfC2foLmAIwBioGplKR11g2iKcAT6zPoWN04hYnqPCeU5FDrgrjKdDDj318hpw+x3goZ2JA8gGbIcCXVlhLnCnoFADYBs9NfWBDsEJ4miwFZBTPCeWgfl00t+Ka1nfkcJ31e5cBeId5mDrmHDqsfOg83wFdCrzgiPr9QUVW8QcdhIT6xwxialr1FvVVNZxqhjGGHgNEzX3e73feWSK88gd+cfaxhhxrytwp6EW5CBiyQ8T+wowwX5QiZUI8EEuWjZQ4JHoUOsAOSl04NC/vAe7wkauRu6E0+3cUWbC6BPhNDvL1/zB4LbIlR3UxyzEhsm2SG9jrMHXnrIL2Ng7vDc4GnIDvyJYYwu9xX7oyP/EG/bvqcN4NvJk0el+odqeA/U5mmf5aAfuDs3OOwwwD4qcnQx8hK8nAvMl88iC70AVAvdhS6F/o2x7o/wpoG5BB8/CmYN+9ehvaD7GtyjmO/HuAzbmFE+99GvJr8VlbTDP/XOWgA+cIZyHHeyB5Hnk4cEB7gcf+8zraUcwjtwR5pHFiCXnQfYhzWHeTbg/UE69GDD54E99k9zJ/AAX+yjGfsAe6DhbkMtCzogVwz4eVCbnFHvL+6m+cXfdMZ7kXcY96DK3M3JzGHvqxY99rMcZG2cP+If6Yx1qhrv+gsmdcGC2MFbePzj75hE4whhWDr0x6jFHvd15iHuA/sta4cxh92APBfLktLiLgDdxJn9v2uesSAzIzZx2X9Yr9wD3+sdvv6P4/0ENBh2fAdpyeijAv+i0++NjQ6qml8Y6Lc9pfevhSpsl9Wl6cCxGr1Oa8dPkpb6MurAaZf70/H65wGF6vDzE70eStP32hvoX'),
			this.addDataEntry('desktop highlight', 28, 19, 'Desktop Hightlight', 'jVVLl6I6EP41bu7ingg40y4RFOOQ2Cg2DTteHYJBPALy+PVTAdueXsy5d8Eh9X2Vqi9VecxUo+isW3jNSJmkYqauZ6pxK8t6GhWdkQoxUxBPZqo5UxQE30zZ/IWdjyy6hrf0Uv+fCco04R6KJp2QCajqXjyAKguvcsiLkMF/lSa8DiORGlV1aERaAfXvP4Df01vN41DYYZSK17LiNS8vQEZlXZcFOAhJrML4zG5lc0mMUpQ34JP0I2xE/UcEXXAmZ9blFdCwuqaxXMwH71KQvRqF6J8o+kRkqLAOZ6o+mcqmurOZsuoKWLDxuqVK0K+0yOuaeEA83B5QbJZ3W03UpF+opF/c4yK+k1xvibEckiLmeBtcg/fEiFS2xBy1dn5itqs39Kj3e0Pv9oamUJNxbGUi9JIyMREnLmto7miYr9TQO6BQYjnjr9zPU2v90zjqDLSg1OsE3h4WsXVa4stBpFvn7qt0wLlWYDXL9u15Z18oItt6SKxla3v0HlnLfs9JSywqfI/8/Dg+YjrnJladLlUpilS99pVlFan4Bx50dW8SLcjr5Y5TzXerHTb0F1ud8j81ud058ILhaTvnl8gSTeBt+oO6ywJLiOjisOA5PrxFhUCyjsk7FbGgre9R4SqLt1g5Qd3O/esR94RrHTWlzaTd0aPWERNLvpO8na8R7TFLzfUS57ghJllA3a4B1Mw5Yujdp2qpKFYP99hY5ZG1GWRmWHGL+ct/e3UQ8x4UwRC8O5Bnze3hq8avxrIKvYXw33fbuNicQ++tScwn/2IrBxFcyB9ZXrerLLEYCwpRRaaswK76ZdDVryNmUrnrYsXOyZwcdblijbqb3M5jhXK9xea6Ia6zAF4jvd7JCuyPj/87qb/hBvrOr6ed5feoIQPWsKmDv98SDrZ57mzINY7zeHBGn3MH+VTwmVPAqdTTawPEqOVOJm4yQNx2fwQO8kJu2NWo2Zs70Is7iZN8DVqdxRgXcto56yHPQPIMQ3dbqpAW7JYOUrs8EeDngp/E3BNga4VufcnNqSd9pnxjLNgNk5ZJH3F9BNhibx48MsWFsTP5umvQpc/t/KxRA8HOcRRyIsNTm3tCePQlsg5zbJ5gfJJa56G5hn7gBWiFOuo99GXsw948yT4g6AvEO3Xwl/ywP8Kpdn2oyUmZ8kncUaF2Ug+DdSOabxQCmsZ+DDoDviVyXWYMmtjUE6jd2G+ImZ4RmnoKPRhvjawcb4pBH95yqD7UjQ6+AnoRMdc1kbUxmfz3cCoedoZhPw3Uhf7IXpuYkXGP4JZAX/eTn/RnD/8f386HPPdKMGjyWldXj4sfrty0++vjMUKPl8NKyyKtbz24tDyps8cD8jLNylLOss9ZywkLq8lmz5lfLxEMHo/Rp/n16I3ctzfxNw=='),
			this.addDataEntry('desktop non', 28, 19, 'Desktop Non-SAP', 'jVXLlqM4DP2abGYxxwHSXVkSyMMp7BQBKgU7XmVMTMgJEB5f3zKk0l2LPjMLDtKVLF1LtjVTjaLb3sJrRsokFTN1PVONW1nWk1R0RirETEE8manmTFEQfDNl8xfrfLSia3hLL/X/WaBMC+6haNIJmYCq7sUDqLLwKkVehAz+qzThdRiJ1KiqYyPSCkz//gP4Pb3VPA6FFUapeCsrXvPyAsaorOuyAAchDaswPrNb2VwSoxTlDexJ+hk2ov4jgi44kyvr8gpoWF3TWG7mk3cp0F6NRPQvFH0hMlRYhzNVn1RlU93ZTFl1BWzYeNtRJehXWnTqmnhAPNwdUWyWd0tN1KRfqKRf3OMivpNcb4mxHJIi5ngXXIOPxIhUtsQctVbuMcvVG+ro/cHQu4OhKdRkHG8zEZ6SMjERJy5raG5rmK/U8HREocRyxt+4n6fb9U/D0RlwQempE3h3XMRbb4kvR5Hu7Luv0gHnWhOrdot3FYvV4z025nmkdPc4L1lcJPzVPHcW5CauV2FzPRyc80+8Q8y6UEScFcgURape+8qyilT8A+/2F5+zgRotoy6BNXH/6lbs09FfLHXi8eTmdufgFAxP3T6/RFvRBKdNf1T3WbAVIrrYLHjKx/eoEEjWM/mgIha09U9UuMriPVY8qN+5f3NwT7jWUVPqTOoddbSOmFjaO2m38jWiPWapuV7iHDfEJAuo3zWA2tkOhh7uOdV8t9pLRlNVVnm03Qwy81gt/vLfXh3EvAdFMAQfNuRZc2vQCqxm2aE979+MZRWeFsL/2O/iYnMOT+9NYj7tL5ZyFMGF/JHlbbfKki1jQSGqyJQV2FevBl29OphJ5q6LFSsnc+LocscadTe5lccK5XoLnWuIay/ArpFe72QFDs7j/0Hqb7iBvtvX0wnze9SQAWvY1MHfbwkHXZ4OyDXKeTzYo8+5g3wq+Mwp4FTy6bUBYtTyRBM3GSBue3DABnkhN5xu1BzMPfDFncRJvgau9mKMCzmtnPWQZyB5hqG7LVVIC3pLB8ld3gzwc8FPYq4H2FqhO1/a5vQkfaZ8Yyw4DROXiR9xfQTY4mAeT2SKC7I9+bpr4KXPrfysUQPBybEV4pHhyc31EB59iazDHJseyJ7kOg/NNfQDL4Ar1FHvoS9jHw6mJ/uAoC8Qz+vgL+1ws+B2uz7UxFOmfBK3Vaid5MNg34jmG4UAp7Efg87A3hK5LzMGTmzqCdRu7DfETM8ITT2FHoyvR1aOL8agD+85VB/qRgdfAb6ImOuayNqYTP57uBUPPcNwngbqQn9kr03MyHhGcEugr4fJT/qzh/+Pb/dD3nslGDT5vKurxwCApzft/jpERugxQbZpWaT1rQeXlid19hgkL9OqLOUs+1q1nLCwmnT2XPl7IoHwGEpf6u/hN9q+zcZf'),
			this.addDataEntry('desktop', 28, 19, 'Desktop SAP', 'jVVLl6I6EP41bu7ingg40y4RUGOT2Ai2DTteHYJBPALy+PVTAduZXsy5d8Gh6qtK1ZeqJDVTjaLb3MJrRsokFTPVmqnGrSzrSSo6IxVipiCezFRzpigIvpmy/ot1PlrRNbyll/r/LFCmBfdQNOmETEBV9+IBVFl4lSIvQgb/VZrwOoxEalTVoRFpBaZ//wH8nt5qHofCDqNUvJUVr3l5AWNU1nVZgIOQhlUYn9mtbC6JUYryBvYk/QwbUf8RQRecyZV1eQU0rK5pLDfzybsUaK9GIvoXir4QGSqsw5mqT6qyru5spqy6AjZsvG2pEvQrLTp1TTwgHm4PKDbLu60matIvVNIv7nER30mut8RYDkkRc7wNrsFHYkQqW2KOWjs/MtvTG+rq/d7Qu72hKdRkHG8yEZ6SMjERJx5raO5omK/U8HRAocRyxt+4n6cb66fh6gy4oPTUCbw9LOLNcYkvB5Funbuv0gHnWhOrTou3FYvVwz025nmkdPc4L1lcJPzVJHMbclPzXGETz6l7/om3iNkXioi7ApmiSNVrX1lWkYp/4O3u4nPWwhqN9i0judW+ehX7dPUXW514PLl53Tk4BcNTd84v0UY0wWndH9RdFmyEiC4OC57y4T0qBJL1TD6oiAVt/RMVnrJ4j5Uj1O/cv7m4J1wDvlJnUu+oq3XExNLeSbudW4j2mKWmtcQ5bohJFlC/awC1c1wMPdxxqvletZOMpqqs8mizHmTmsVr85b+9Ooh5D4pgCD4cyGNxe9AKrGbZvj3v3oxlFZ4Wwv/YbeNifQ5P701iPu0vtnIQwYX8keVtu8qSDWNBIarIlBXYVa8GXb26mEnmnocVOydz4upyxxr11rmdxwrleotNqyGeswC7Rnq9kxXYu4//B6m/4Qb6bremE+b3qCED1rCpg7/fEg66ee5syDXKeTw4o8+5g3wq+Mwp4FTy6bUBYtTyRBMvGSBuu3fBBnkhN5xu1OzNHfDFncTh1ABXZzHGhZx2znrIM5A8w9DdliqkBb2lg+Qubwb4eeAnMe8ImKXQrS9tc3qSPlO+MRachonLxI94PgJssTcPJzLFBdmZfD0LeOlzOz9r1EBwchyFHMnw5OYdER59iazDHJtHkI+S6zw0LegHXgBXqKPeQ1/GPuzNo+wDgr5AvGMHf2kf9i7cbs+HmhyVKZ/EHRVqJ/kw2Dei+VohwGnsx6AzsLdE7suMgRObegK1G/sNMdMzQlNPoQfj65GV44sx6MN7DtWHutHBV4AvIqZVE1kbk8l/D7fioWcYztNAPeiP7LWJGRnPCG4J9HU/+Ul/9vD/8e1+yHuvBIMmn3d19RgA8PSm3V+HyAg9JsgmLYu0vvXg0vKkzh6D5GValaWcZV+rlhMWVpPOnit/TyQQHkPpS/09/Ebbt9n4Cw=='),
			this.addDataEntry('detail view highlight', 21.91, 28, 'Detail View Highlight', 'jVZLk6JIEP41XvYwgRTONEcEG3EobFpsGm8INPISowGF+vWbmeDauzEdsQeiqvL15eMrrRnTq978DC8nXsdJOWOrGdM/67odd1WvJ2U5k6UsnjFjJssSfDP5+RvtnLTSJfxMzu3/cZBHh2tYdskoGQVNO5SToDmFF9xmVZjCurwmn20WhaUdHpPypW6yNqvPoD/WbVtXYFCiYhlGRfpZd+dYr8v6E/Rx8hF2ZfslglZmKXq29QWkYXNJIkz6I+sTSG9JgNpdKoEkibM2PJaJ3jSvXZk0IP7x190SIcI2nDFtPMrPzTWdycu+goL1l7UjH4alcvT7LhIX5WiWXSikLFy/SpFRX20Ws3hYMD4srlEVXblXLLY7dbQbrDQx583xzFWrOknxWvtpDyp4RF0seHdkm7MtrBs3tGvEDmcrW8qh/8bcSlVedtbNMrSUe2nKc96BzWLrFQoXVu94XPBcE2h/eN+I0Fc7sO/tfJVZZlm87DY8eC/LqHzqwYaF/qsUGlIGsUB/KkM/rmM8fxc3VyqLnU7bQUuhfinx+9Javy4ic69a59cyWbvXgDkPu1uxsc+OxNetiE31ZvvO9WiqwzbjN246ZeDzXx+7IE/M1S/dLbqIuX3CHOnItDaQ1ebIrJ+W0NjW4Mohb9VN5iiB12wsXXuy2Yj/ko3+KDuYb1UkHjmiDPt98J+HV7Y5HcyyPJ7dNPRd1SqgJ+u0p35mywX3oG4d5mJYqpWvFJLl1AvoTTwE/uvl4C+kN39xidcwt/ObgB57kfmcH/Zq9/bulF/7A9ipZfRUt2U6TfDuCOi/iA0ts8V3dmp1ODslzWBnpYHcnyKGWNDDnXX9Uiv43K5/qA34OXWJLP7bkZf18hSbaXqoyuYIKPH7pvmtO8vfgHaAs+etZDvfS7axWth5uggGZXB0+oSzU+Z8R6vC33kLrBrAltl3mY8yS6IPbO2cy7CyLerPqNvjueeZ1DmiaFF/1CUB69z2eOcYcY56Zyd13NtjrAHOgzPAObfaKZ681RVpq0vAapfZeTTYntVxkUJMtAkG29BayHPgFMfCPXMAk4sAcxAUE/0hR4iNcXAPtxPyMlZg4yIuA5tu62HMgtneCnRFe6+NchJ7jN1/2SvRQPX1lDvVBX7ikD/84CO9xh5xS+hBqhDm7vbIx4eeeMGIaaymnkAPDIwZ0D4SKC+wzgbr5Bn0uiI/6JmLshvMDnApLsy2WFB8rDGPYFbFQHkYVB/6gK+L9aBvzwecLfpGgKs1YEv94xnJsCbZyW4Qw4UatMkGeaHBeaXAuiD5eB7GulG+EkeDjziDIjnzi7MFHCcDTKw7h3p0xFjNCY/y3y/u88fZOMYe7ALs+41THtjXgEUTX+6zmWxkXiEHXcxZQo5tvQj5otAMvIL2EfEBMHNLTHLwP+Xko49+EA98yX6cRb4RNG+cUW6hvqF8ZOS0S3kCFshTlM+3WMPzxeEkg56P/OjHj0+8xjViMfQJuDEEAvvKsfc9cRzuFPKNeJ0jLvEW/Yb7neN055AnK+STgj3jYpPb97uRuy3h4L0mDmOMVH6DGriUwqyseUyzcvvQiDrio3Dvc8E7RxwZuekI+h2gOa2I13w37neop98G4Mt4NxFTwH1D/TineYB74Y51AiZnyKUx/rIG7gN2mVN9xDHgAvEpWuA98AsJZhY0wB9l+ycs/YHFGfIumvhxe+QgpzLGg988uPu3G9VFeZIN5eIwjM3ZWDNvv9Rf23DnIMfQyp4ev8L4PyUfhIJPH7acHkfwXEn6bx9YJJpeV2ZSV0n7OYDJLYvb0/TImv9QJ8dTkqWnyVF+GmVhM57Tf5wfDzbYTG+2+/HxNiTdv56OfwM='),
			this.addDataEntry('detail view non', 21.91, 28, 'Detail View Non-SAP', 'jVZLk6JIEP41XvYwgRTOtEcEW8umsFFsG29YMAiCGAIK9es3M9G1d2M6Yg8EVfn68vEV1IBZRTu7hOeDKKM4H7DpgFmXsqz7VdFacZ4PdC2NBswe6LoGz0B//UY7JK12Di/xqf4/DnrvcA3zJu4lvaCqu/wuqA7hGZdpESbwnlzjS53KMHfCfZy/l1Vap+UJ9PuyrssCDHJUTEJ5TC5lc4qsMi8voI/i32GT118imHmaoGddnkEaVudYYtK/0zaG9CYEaD6kGkjiKK3DfR5bVbVq8rgC8Y+/HpYIEdbhgJn9Vn+trslAn7QFFGy9z119102M/bZtpDob+1nehEpLw/lKk3Z5dVjEom7ERDe6ykJehX8cLdfj3q7jSTwbVvuTGPPioEVz86fTjcFDNpESzZ4tTo7iN2GbV8l2J55O9HD7wbxibLyv+Y3bZiL8JBGZaMBmtPSPhlC8dX2hRGYqtN99LlS4HTdg3zrZNOWz/Pi+XojgM89l/tKCDQu3Ky20tRRigf6Qh9uojHD/XdzMKDg7HJadmUD9Wrxtcz5fjeRsM+anVR7PvWvAXLRrJPNufF4lkq2u0hpme729yqxMZBGlb/axdSyzFf6m4vZULdfHX3yuJc7J1cR6AmtX2zOzDvRxtWf8J58vTkGaKNe6JZAL+Mjuza+S32vzxWF9Hu9pkMWz6S9umS+72Uch1TNXlGHfd9vXbsUWh90sz/cnLwm33pgfoTfzpKW+ppOR8KF+C+Zj8zHPpgbJMuoJ9Cjqgu3qvNuOtI/t6BzNYX6nDwW99uXsNdttxs3Hp5t/7RNgJ9xuVTQb3/jMrYJPV8EcVGSbqaO+sxsXu5Ob0yzWPAn09iAZYmF/+PVLreBzu/6hNuDpInWNALqEFv/tyPt8cohmSbIr8moPKNHnonqz3MkboO1g7/tT3ck2mmNPR06WjILO6FyLHuWujaFY09sQn6IGdnVgy5yHbIsyrtEDtk4mdHizJepPqNvgvhWp1rjqWKN+b2kK3kPHF41rRxnq3bXWAEMwVgf7zu1gn/H6Hk9fWoa2tDRgt8ecTHaOzxuhEoiJNkHn2GYNeXaC4nBcMxcwhQowB0Ux0R9yhNgYB9dwSiEvewo2HuIysGmWPsY8Msefgu5YP2qjnNQGY7df1obsqL6Wcqe6wE/tsqcfPKQ32TNuDj1IDMJc3575bKEnftBj2tN7T6AHNsYMaC0Vyo9YZ4V1ihR6XZAf9MxD2Q1mB7gUF2Z7HFF8rDGTMKtjR3nYVB/6gK+H9aBvKzqcLfpKwDUrsKX+iZRkWJPupjeI4UEN5t0GeWHCfmrAe0Tyft/1daN8qva26HE6Q3OHZ3cJOG4KmFh3BvVYiDEdEh7lvxk95o+zce0N2AXY95ugPLCvAZN3vjxmc7fRRYEc9DBnDTm29CXyxaAZ+EdaS+IDYGZc3eXgf8jIx+r9IB74kn0/i2yhaN44o4yjvqJ8dOS0R3kCFsgTlA+XWMPr2RUkg573/Gj7R9x5jW/JIugTcKMLFPZVYO9b4jicKeQb8TpDXOIt+nWPMyfozCFPpsgnA3sm1CJzHmcj82rCwXNNHMYYif4BNQgtgVnxYUSz8trQlg3xUXmPueCZI4703HQVfQdoTlPitVj36zXq6dsAfOnPJmLC15963c9pGOBaeX2dgCkYcqmPPymB+4CdZ1QfcQy4QHySIzwH26MGMwsq4I+x/BOW9cQSDHkn7/y4PXPQEx3jwTcPzv7tRnVRnmRDubgMYwvW1yzqL/WXDpw5yDHk6cvzK4z/KX2nDLwCscn9kgTXlrj99qJFovstaxaXRVxfOjC5pVF9uF+2hj/Gd8dDnCaHu6P+0svCqt8n/zg/L26wuN/dHtvnHZF0/7pC/g0='),
			this.addDataEntry('detail view', 21.91, 28, 'Detail View SAP', 'jVZbk6I4FP41vuzDFBKcaR8RaI1NsFFsG98wMMhNLAGB/Po9J+DauzVdtQ9UknP7zuWLZkKMolveguuZlWGUT4g1IcatLOthV3RGlOcTVUnCCTEnqqrAN1Ffv9FOpVa5BrfoUv8fB3VwuAd5Ew2SQVDVfT4KqnNwxW1SBDGsi3t0qxMe5HZwivL3skrqpLyA/lTWdVmAQY6KRcCz+FY2l9Ao8/IG+jD6HTR5/SWCnicxetblFaRBdY04Jv076SJIbyEB9YdUAUkUJnVwyiOjqrZNHlUg/vHXwxIhgjqYEH04qq/VPZ6oi66Ago33laMe+4V2OnQNF1fttMybQChJsNoq3CzvNglJ2M8I62d3XvA787LZZjcf7HoaR8tpdbqwOS3OSrjSf9r9HDx4EwrWnMj6YgvaMlO/c3K80GShBocP4hZz7X1HW2rqMfPimKWsAZvZxss0JmjneEywVBdof/xci+Awb8C+s1Mrocs8e9+tmf+Z5zx/6cCGBIetEphKArFAf86DQ1iGeP4ubqoVlJzPm16PoX4lOnQ5XW1nfLmf08s2j1bu3ScO2jWcuC1dVTEn2zs3pulJ7e48LWNehMmbyaa2oXeOmVXUpFNnl/2iKyW2L47CdgvYO8qJ6LWvzqsToT/pan3xk7gFH83pW6jbat+8Kv69019sMuTxnvhptLR+UUN/OS4/Ci6euaIM+348vPZbsj4fl3l+urhxcHDnNIPerOJO9jVZzJgH9RswH5POaWppUpbKnkCPwt4/bK/Hw0z5OMyu4Qrmd/kQ0GuPL1/T437efHw6+dc+AXZMzU6Ey3lLl07lfzoC5iBCU09s8Z3dvDhenFzOYkdjX+3OnCAW9ofev9QKPu39D7UBT9eJo/nQJbT4b0feV4tzuIzjY5FXJ0AJP9fVm+Es3gDtCGfPs1Q73Su2ac3sNJ75vdY7hvyEs9OmbCdXjX2yGtjVgy2xH7IDyqgiP7C1U6bCSjaov6Buj+eOJUrjiKxG/clQBKxT22ONY4Yp6p2d0jBvj7F6OPdOD+eU1mM8dWNoysZQgN0usVPe2x5tmIghJtr4vW3qNeTZMxmH4p44gMmEjzkIGRP9IUeIjXFwD7cU8jItsHERl4BNs/EwZkZszwJdVj9qkzmJPcbuvuw13sv6Opm7rAv8xDF9+sEn9Tp5xs2hB7EmMXftM58D9MTzB0zTGnsCPTAxpi/3XKA8wzorrJMl0OtC+kHPXJS1MDvAlXFhttlMxscaUw6zynqZhynrQx/wdbEe9O1Yj7NFXw64egW2sn8skTKsSXWSFmK4UIM+2iAvdDhbGqwzKR/O/VA3yi1xMtmA02uKM706G8BxEsDEulOox0AMayrxZP772WP+OBvH3IOdj31vmcwD++oTPvLlMZvRRmUFctDFnBXk2MbjyBdNzsDL5J5LPgBmSsUoB/9zKn2MwQ/iga+0H2aRroWcN84opaivZD4qctqVeQIWyGOUTzdYw+vVYVIGPR/40Q0fG3mNKych9Am40fsC+8qw953kONwp5JvkdYq4krfo1z/uHJN3DnliIZ807BkT69R+3I3UrSUO3mvJYYwRqx9QA1NimBWdhnJWbheYvJF8FO5jLnjnJEcGbjpC/g7IOVmS12w37Heol78NwJfhbiKmgPuG+mFOUx/3wh3qBExGkEtD/EUJ3AfsPJX1SY4BFySf+AzvwSFTYGZ+BfzRNn/CMp5YjCDv+MiP9pmDGqsYD37z4O63raxL5iltZC4OwdiMDDWz+kv9pQ13DnIMaPLy/BXG/yn1KDR8ApHF+EiCZ0vUffvQkqLxlbWMyiKqbz2YtElYn8fH1vTHfHQ8R0l8Hh3Vl0EWVMM5/sf5+XCDzfh2exyfb0Sp+9cT8m8='),
			this.addDataEntry('devices highlight', 28, 23, 'Devices Highlight', 'xVZNk7I4EP41XvawFQH3HY8RGI1FwqgogzcEBvkSS1Egv347CaPu1r67W3vZg0WnO+mPp5+OGelm1c0v4flI6zgpR7o90s1LXTdKqjozKcuRhrJ4pFsjTUPwG2nvP7GOpRWdw0tyav7NAU0duIflLVEapbg2fTkorsfwLMSsClP4zpI4a8JDmZjX6/pWJlcw/foL6O/JpcmisHTCQ1J+1NesyeoTGA9109QVbCiFYRZGRXqpb6fYrMv6AvY4+QpvZfPiAZdZKk429Rm04fWcRKKYr6xLIO2ZTAR/a9G3RrgKm3CkY7XU3q/3dKTNugoKNj8WTNv3M+Pgd7eIoyxcrFFk1XdHj/W4n+i0n9yjKrrTHLfUnPK4ijKy2J/3n7F50NMpyVDr5NvU8fCNbXDvmrinvcGZRTMyP5ahH9exhTKa0xvlK06ymR76axRKXZp9ZEGezO0f5gankAtK/K4ki/Ukmm+n5LQuk8XqHuiMk9yoiH48um2xdE4M0UXD4/m0dXx2P8ynvZvRls5ZGfj0x9dm8LkqbpG+6hKdoYOOm0CbXg86+Y1wrLsWNfZ5M11mzAi865KY+M3RVfxHTl5X7P09f6xXxdthXt72/nu/1pfH/bwsD6dVun/I692hKpHAMf5kZVSyNvBZ6WmTXaRtAbei/9iQnplGTz2BYyrWnbsxxswkaeLZU5KTm2vZAieDeoBRZrSUF4BlWXxslrNXHCA/iQGZs2vwyTjYeWzhzOH/tMcGf9Nqf2Kl7M2G3F9rdLTufKh2x6iI+8Bfn/f+BD0xae/7+a6KnjHeovk7Cs1ZFfrdFfyPo6qtCbLPUIPImVGP3phHdGLZhpPbBjsFvZOzmm6Mjvlg44FBLJzK9cZA1KKDjDsnJy0TGFirG/W2vbMBGTCiHCMhM17cmLUaRz0C+0rs10HfM6uAPZEeSH0K8UjHQGbWVnNyCjxFgDPppWynupMHGpvTBvIbUxUPZOCUOG8RDj4RkzpsyFh5MHFEjhYR+3SWCd1WnJ/IMzkdyzw2SOShiVxdeZ5MqNhrpSCvEMRswcZZHkCeNuiCMYP5ET5cK4K87JbJGjBgR7j05xX8GXPHX3wi6dMU8rGGORxTK9YcD/BCKezDLdNs+G45sURPAGcTt9CXBmoe01zELwzW47/cI20bBJhtO3cXSH+uL/OfQK5QJ22gbwYF7F0PMIW4zAp0gbGsgVPAPgK+Qx9y3IPP757CPC7BXzoRNsDWkDbghcSwSjvXNDTXYjOoCTAV+ZGx5IyJO2IRJPoGPBkza5kDhhOYMY15qeBRyyxbfBHcTcAPjCjcU4CTxj4FD+mYVXA3WRip3st+C32rcIwmEtNPyQ04a6ha8tVE9kCT+g5id9QTXCAwy0YH9Yv+tmLWmbcT/OHQX9GjXnKJE+F7rPgJGIjeiHgDr4E/ih8b2UvufMf1Vr3kC49kLMFB1xN7gRsPDkJe/cAHOKfs2FAc3vmAIfC7zCnEYwpjDrPQyJnzhu8GdRKP4ps3wkekAYat48m+Qa7gX8lqXj+DDr4a40vwjYVvMWsGzbD0NfRb7fVTtVf7L/Mv/kswf5l/9DL/muLQ0J9K9gdyEHduITAVPBnmS/aZJxXqwG7AvdK4AluVk/a3OZ2CR/5/4g5/cid9vZv6x90k+xfnsncW8CC3ddkbD+4ATkQ/DHXHESM0EcwP7qj2P9xNi6ARnGV5LLlCZT/tzhF1e2reYWaBa8B9S/DRbl3x38aDIdaTp1H/5CHMBOS7lTJg3zB1Z6RQG2feHjgGucP/g5phcX+lgF+Akuz5P/Wh3iLwjoF3zvBYg2dS0v30wSdVw2tvntRV0lx62NJmcXMcHn1v6tQxydLjcErTlS68qnX6OPl8PYIwPCC/l8+HqrT94R37Ow=='),
			this.addDataEntry('devices non', 28, 23, 'Devices Non-SAP', 'xVZNl6pGEP01brLIaQHzZpYIjvY8uhkFdXCHwEO+xDOiQP/63G4cneTkJTnZZMGhqOquj1u3mh7pVtXNP8LTgdVxUo702Ui3Puq6GaSqs5KyHGkki0e6PdI0gmekvfzEOlZWcgo/kmPzbzZow4ZrWF6SQTMozk1f3hTnQ3iSYlaFKd7TJM6acF8m1vm8upTJGaZff4H+mnw0WRSWTrhPyrf6nDVZfYRxXzdNXWFBKQ3TMCrSj/pyjK26rD9gj5Mf4aVsvngwyyyVO5v6BG14PiWRLOZH1iVIe6oSMT+15FMjXYVNONLN4VN7OV/TkTbtKhRsvS24tuunxn7bXSJBsnCxIpFdXx091uN+orN+co2q6Mpys2XWs4irKKOL3Wn3Hlt7PX2mGWmdfJ06vnnhntm7ltmz3hDcZhmdH8pwG9exTTKWswsTS0GzqR5uVyRUujR7y4I8mc++WZ6ZIheSbLuSLlaTaL5+psdVmSyW10DngubGJdKXLV2c00hfXSNrnO+17hrldRpVcfbdLjrHMjvmr8/UngnXK77RBUmdIyfMm0LmZK+bTaA9n/c6/Y0uXo9BlgputSn3GfZE/Xf/nP7wzCdHH/K45+Z3xW67E/fvZfG0n5eX3falX+mvh928LPfHZbq7y6vNviqJxDN+52VU8jbY8tLXJptIWwO/on/zaM8to2e+xDOV353rGWNu0TTxZ880pxcXdQAvg/nAKjNaJgpgWhZv3usUeFRUPxzctnhFfiKeP7d0zs/BOxewi9g2M0f805oZ/D1XuyMvVY88ev1ao6N1p321OURF3Afb1Wm3nZAHJu11N99U0SPGUzR/IaE1rcJtd4b/cVS1NSWzE2qQOXPmswv3qY7+GE4+M/gx6J2c18wzOr6FTQQGtc1UfXsGYTa7yWbn5LTlEgN7eUGPe8eDDIyYMImUuSgu3F6Oo57AvpTrdeh7bhdYE+mB0qeIRzsOmdtrzckZ+EqAM+2VPEt1Jw80PmcN8huzIR5k1jK536YCPglXOtNQsfJg4sgcbSrX6TyTurXcP1F7cjZWeXhE5qHJXF21n06YXGunkJcEMVvYBM8D5DmDLhhzzJH04doR8pq1XNVgAjsqlD+/EI+YG/HFJ1E+LSkfaszjmNmx5vjAi6RYZ7Zcm+G9FtSWPQHOltmiLw1qHrNcxi8M3pt/uUbZPALM1p27CZQ/d6vynyBX1Mka9M1gwN71gSnicjvQJcaqBsGAfQS+ow+52cPnZ091136Fv3QibcDWUDbwQmFYpZ1rGZpr8ylqAqYyPzpWnMHsU5sS2TfwZMzt1xwYTjBjGvdTyaOW2zP5JjijwA8T54KJGpYaf5c8ZGNe4YyyTTL0XvVb6tsBx2iiMH1X3MBeY6glX05UDzSl7xAbZ5DkAsUsGx3ql/1t5axzfyP5I9Bf2aNecUlQ6Xs88BMYyN7IeDdegz8DPzzVS+F8xvWXveKLiFQsyUHXl2vBjTsHkVd/4wP2DXbTGDi82QJD8LvMGeLxAWOBWWjUzPm3t0c6hUfxyRvpI9KAYev4qm/IFf4HeZjX96DDW+PiFb5N6VvOmsEyU/m69XtYu02Htdp/mX/5TzHFl/knX+ZfGzh060+l+oMc5JlbSEwlT27zpfoskop0sBs4VxpXYjvkpP1tTsfgnv+fuCMe3Em/nk39/WxS/Ytz1TsbPMhnuuqNjzNAUNkPYzjjqBFaBPOD/5v2P5xNi6CRnOV5rLjCVD9nnSPr9od5x8yCa+C+Lfk4a135bxPBLdaDp1H/4CFmAvmulQzsGz6cGSlqE9zfgWPIHf+HYYbl+ZUCv4Ak2eM/9TbcSXCfwX3ndmnDdSnpfnrxU6rbrW+e1FXSfPRY0mZxc7hd/p6GXYckSw+3XZo+6MLz8J3edz5ukRBuF8nPz8eFVdn+cJ/9HQ=='),
			this.addDataEntry('devices', 28, 23, 'Devices SAP', 'xVZNl6o4EP01bmYxJwLO614i0Jp+JLaCbeMOgRdBEE+LAvn1cxPstmfOvJk5s5mFh0pVUh+3bsWMTKfqZu/xac/qNCtHpjcynfe6bgap6pysLEcGydOR6Y4Mg+A3Mp5+Yh1rKznF79mx+TcHjOHANS4v2aAZFOemL2+K8z4+KTGvYoHvNEvzJt6VmXM+ry5ldobp11+gv2bvTZ7EpR/vsvKlPudNXh9h3NVNU1fYUCrDNE4O4r2+HFOnLut32NPsR3wpmy8e7DIX6mRTn6CNz6csUcX8yLsMaU91IvaHlnxolKu4iUemPSyNp/NVjIxpV6Fg52XOjW0/tXab7pJIksfzFUnc+uqbqZn2E5P1k2tSJVdW2C1zHmVaJTmdb0/bt9TZmeKR5qT1i7XwQ/vCA7tfOHbPektyl+V0ti/jTVqnLslZwS5MLiXNp2a8WZFY60T+kkdFNvO+OYEtkAvJNl1J56tJMls/0uOqzObLa2RySQvrkpjLls7PIjFX18QZFzujuyZFLZIqzb+7bOw7dsfdw5m6dMyDwzc6J8I/csKCKWROdqbdRMbjeWfS3+j8+RjlosUZi/etYIXXfg/P4kdgP/jmkMdnbmF32G628nO9PDzsZuVlu3nqV+bzfjsry91xKbaf8up1V5VE4Zm+8TIpeRtteBkak9fEWAO/Q/8S0J47Vs9ChadQ624RWGPuUJGF3iMt6GXhegovi4XAKrdaJg/AtDy8BM9T4FFRc79ftIdn5CfT2WNLZ/wcvXEJu0xdO/flP+3x4O+x2h55qXsU0OvXGn2jO+2q131ySPtoszptNxNyx6S9bmevVXKP8ZDMnkjsTKt4053hf5xUbU2Jd0INKmfOQnbhITWp61l+4Vn8GPV+wWsWWB3fwCYji7q20OvAIsxlN9nu/IK2XGHgLi8sXPd+ABkYMWkTJXN5uHB3OU56AvtS7Teh78EH7EnMSOsF4tGOQ+bu2vALBr4S4Ex7LXvC9IvI4DPWIL8xG+JBZi1T510q4ZNwrbMtHauIJr7K0aVqn8lzpVur8xN9pgAvVR4BUXkYKteFPk8nTO11BeQlQcwWNsmLCHl60EVjjjlSPhZugry8lusabGBHpfYXHuQ95qv84pNon46S9zXmcczc1PBD4EUE9tktNzx815K6qifA2bFb9KVBzWPMAuIfMBf2X+7RtoAAs3W3eI20v8VG5z9BrqiTNeibxYD9IgSmiMvdyFQY6xokA/YJ+I4+FHYPnx89NRfuM/yJibIBW0vbwAuNYSW6hWMZC5dPURMwVfnRseYMZh9zT1TfwJMxd58LYDjBjBk8FIpHLXc99SW4o8APG/eCjRqWBn9TPGRjXuGOcm0y9F73W+nbAcdkojF909zAWWuopVhOdA8Mre8Qu2Oh4gLuIMfqUL/qb6tmnYevij8S/VU96jWXJFW+xwM/gYHqjYp34zX4M/Aj0L2U/kfccNlrvshEx1IcXIRqL7jxyUHk1d/4gHOD3bYGDr9ugCH4XRYM8fiAscQsNHrmwts3IJ3G4/DBG+UjMYBh64e6b8gV/gd5mNe3qMPX4PIZvm3lW82axXJb+7r1e9i7EcNe47/Mv/pPseWX+Sdf5t8YOHTrT6X7gxzUnXtQmCqe3OZL91lmFelgt3CvNAuF7ZCT8bc5HaPP/P/EHXnnjvh6N/Wfd5PuX1ro3rngQeGZujch7gBJVT+s4Y6jVuwQzI/dMeN/uJvmUaM4y4tUc4Xpfnqdr+oOh3nHzIJr4L6r+Oi1C/XfJqNbrDtPk/7OQ8wE8l1rGdg3fLgzBGqTPNyCY8gd/w/DDKv7SwC/iGT5/X/qZXiT4D2D987t0YbnUtb99OGnVbdX3yyrq6x577GlzdNmf3v8PQyn9lku9rdThjno4vOwFp8n769ICLeH5Mfy/mDVtj+8Z38H'),
			this.addDataEntry('document highlight', 20, 28, 'Document Highlight', 'jVZbl6I4EP41vuzDHgScaR8RaE0PCY1C2/CGwERiEE8Dcvn1WwVq9+w5M7sPHlKVunz1VSVmpplFt/6IL0dappmcafZMMz/Ksp5WRWdmUs5UJU9nmjVTVQV+M/X5N7vzcVe5xB/Zuf4/DurkcI1lk02aSVHVvbwpqmN8wWVexBy+qyzN6/ggM7Oqto3MKtj6+y/QX7OPOk9i6cSHTL6WVV7n5Rk2D2VdlwUYSNxYxcmJf5TNOTVLWX7Afpr9jBtZf4lgyJyjZ11eQBtXlyzBYn7mXQawVyMQ465V7hoMFdfxTDMmUX2urnymrroCCjZfN0yN+pV+2HdNMih5vNkqiVVeHS3V0n6h0X5xTYrkSoXRUnM5pEWSk010id5T86DxJcmV1hEBd3yjYTujp6beUj/gVPCcrI8y3qdlain5KG/SS7TZlq87crfLX/NQZGv7u7kzOGBRsn0nyWa7SNbBkpy3Mtt411BjAxF6QbTj0W1PL86ZKXRTD+l62Tp7dj2sl72b05aumQz39PvP3S2md2oSzesyjSkHzahDdVkdNPKNDIbmWlSPRL18yZke+tULMY0nR5vyPzD53SnaR8ND9k5Ph7Vsov1zv9VejtFaysPZ49FjvX07FFJBHtN3JhPJ2nDPpK8u3hI1gPpPPdTeuaY+0CEEmfcjFztdoxbKpw7kwRGexkzCM8teEmE3dLDnJF9dIuDR2xHo3R01Ikq07TUxV+Kwfh4wM1Tckvzpv606iHmNimiI3j3MkzvDJ8ev5rKK9wsZvr9skuL5FO/fmtR67D856lZGZ/oly+tmdUzXnEeFrA4WMvBS/TDZ6seOcETu+/bCEbbm7PSO+tERqh5YbnSOoCqxDE5NoyOm3jNBG2YFStjrLfNPDfWThlpcA7s5+LTA3pwOTKUiaGAqh3AwOMZguQK2pHdEAgzDevAUR5x0ptqQw1aIBUz6HuZpYV2Dz4L12AmbY1w6YjH6OxbAqbhWCD6GtjOhQ2LE/Ds7iGe3rDf+kAsx0S7EryDoB7WecE9hgJcJwI6cWF494p6HwBeZs4K2o14gFnsOa5UNyVTfTl8AFxTrYBbGsjuwh/jeFN9KGuYHKvq7lte4Flem9baEuoDXQA19xEqRg472iBfq2hloC1xSnW0uteMTsAl0YhHojd3tLN4Ahu6AuH2qww2guO8hTG7Ysb0NfnyOtq4VfOEgGVzkS5zgVjHAxuuneOSLDW9ZrqvjDZLrnbtDO3vxhesF8zn2XduNvrIa+QdOqPUMflhj0MUW8CSM7k0AbnEaspMCsxC0kLdjpq67/lFQwO76AcQwdAc4ABzzsW+CPOR44m+AWdSpzycM0CfAqLBh5KynIsSvAvOI+xDTxj4qMLN8nHHB68nOu8lHwvDECynA7hZXucVVcPZVzA84pu8Q6lmhAMeJDn2BOmyVYo+HsENegPM5xOuw12N/hQc8Yz6sHWcI5wv4Qfl+JjSKs9LTHnD4/DaD+sK1Upxx5L37F+9QTzhyOc6vH0BfjOnMDTbENBYT9gTOqaG7AZ9jvydbnAujneaf4Py2wEU93nKos+SfcoIdWbA14sWbUplqGs8J6sL+cw11vdPpDkB+/RDrHXBmXOtN4Pl00d/3ADsZzxz0TP3lbCLfOI/TOX+cBWZxdby3rPTbL3cr/meo0aDjk0Bb3R4N8Heddb99eIyq26tjnZVFVn/0YNLmaX28PT6mt4lyzHJ+vHmpT5MuriaZPzw/XzGwuD1k7uLng2nc++U99Q8='),
			this.addDataEntry('document non', 20, 28, 'Document Non-SAP', 'jVZLc6M4EP41vuxhSwY8kxwxEFsJEsFAHLhhYGRkMK4A5vHrtxscT2arZnYPLtRPff11S9ZCNcp+8xFfjqxKs2KhWgvV+KiqZl6VvZEVxUIhebpQzYWiEPgtlKffWJeTlVzij+zc/J8AZQ64xkWbzZpZUTdDcVPUx/iCy7yMBXzXWZo38aHIjLretUVWg+nvv0B/zT6aPIkLOz5kxWtV501encF4qJqmKsGhQMM6Tk7io2rPqVEV1QfY0+xH3BbNlwx6kQuMbKoLaOP6kiVYzI+8zwD2egKif2rJpwZTxU28UPVZVJ7qq1go676Ego3XLVeiYa0d9n2bjCSPtzuSmNXVVlM1HVYqG1bXpEyuTOodMx7HtExyuo0u0XtqHFTxSHPS2TIQtq+33NMHZmgd8wPBpMjp5ljE+7RKTZJP8ja9RNtd9erRT7/8NQ9ltrG+G54uAAvJ9n1Bt7tVsgke6XlXZFv3Gqp8pFJrE9Xt6LYWibq7JsZSHpT+mshKJGWav5in3jb0HnLW1LRGxzt9p1si7DMnzFvDmpODqjeh8lgfVPqNbp/PYS5GbnSC+wxikuHFr8UPT3+w1RnHHZvfn6J9NN5l9/Rw2BRttH8adurzMdoUxeHsiui+3r0dyoIgn+k7L5KCd+GeF76yekuUAHg4DcBB7xjayMYQZDFMnHiaykyUTz3Ioy1dlRtUZKb1SKXVstFa0nx9iYBP16PQw+eca6FfPyOimZW1PGyeRtx5Yit/+G+vHnJeozIao3cX98ntUSupejw63en51Xis4/2qCN+ft0n5dIr3b21q3u0PtrIrojP7ssvrdn1MN0JEZVEfTGTguX4x+PrFowKR+761sqWl2p4G3YqOUPXIc723JVOoqQsGXaSGNnDJWm4GJBy0jvunlvlJy0yhgt8SYjpgb8lGrjAZtDCdYzjqAnPwnIAvHWyZAMOwHl1iy5PGFQv2sAhMB9hd3KeDdQMxKz5gJyyBedmERR8+sQBO4pghxOiqZ0CH5IT5d36Qz+r4oP9hL8TE+hC/kmIc1HpCG+GAl0vAjpyYbjPhXobAF13yknWTXiIWawlrhY/JXJ+nrYALhnVwE3NZPfhDfnfObyYt9wMF4x3TbR1TkHm9q6Au4DVQQh+xMuSgZwPihbo8HX2BS6bx7aWxfQo+gUZNCr2xes8ULWDoD4jbZxrcBMR5D2Fyw57vLYgTS/R1zOALB8noIF/yBLeLDj7uMOejX3xEx3NNmW6SXOsdD/2s1ReuV9wX2HfVm2KLeuIfOGHmE8RhjUEfm8CT1Ps3CbjlacxOBGYh6GDfnhua5vhHyQC74weQQ9ds4ABwLKe+SXqX45m/EWZRY76YMUCfACPh48TZwGSIXwLziHbIaWEfCcysmGZcimb2c2/ykXI88bKQ4HfLS255Cc6+gvsDjvk7hlpWEuA40aAvUIelMOzxGPbIC3C+hHw99nrqr3SBZ9wPa8cZwvkCflD+PBMqw1kZ2AA4fHGbQW3lmCnOOPLe/4t3qCecuJzm1w+gL/p85kYLcuqrGXsC51TXnEAssd+zL86F3s3zT3F+O+CimW451JnFn/YEP7riG8SLNyWZa5rOCerC4eca6npn8x2A/Poh1jvizDjmm8Tz6WC87wJ2Op056Jnyy9lEvnEe53N+PwvcFMp0b5npt1/uVvzPUKJRw6eBur49HuBvO+t/+wCZVLfXxyaryqz5GMCly9PmeHuEzG8UcsxycbxFKQ+zLq5nWdwjf75mYHF70HyKPx9Ok+2Xd9U/'),
			this.addDataEntry('document', 20, 28, 'Document SAP', 'jVZdd6M4DP01edmHPQ6QmfaRAE3cYqcEaApvBBgHAyGnQPj49StBmunsOTO7DzlYsiRfXUmOF6pR9puP6HJiVZIWC9VaqMZHVTXzquyNtCgWCsmShWouFIXAb6E8/WZ3Oe2SS/SRnpv/46DMDteoaNNZMyvqZihuivoUXXCZlZGA7zpNsiY6FqlR1/u2SGvY+vsv0F/TjyaLo8KOjmnxWtVZk1Vn2DxWTVOVYFDgxjqKc/FRtefEqIrqA/aT9EfUFs2XCHqRCfRsqgtoo/qSxpjMj6xPAfZ6AqJ/asmnBkNFTbRQ9VlUnuqrWCjrvoSEjdctV8JhrR0PfRuPJIu2exKb1dVWEzUZViobVte4jK9M6h0zHsekjDO6DS/he2IcVfFIM9LZ0he2p7fc1QdmaB3zfMGkyOjmVESHpEpMkk3yNrmE23316tJPu+w1C2S6sb4bri4AC0kPfUG3+1W88R/peV+kW+caqHykUmtj1enothaxur/GxlIelf4ay0rEZZK9mGxpG3rPzbymJl1yN/9Ot0TYZ06Yu4Y1J0dVbwLlsT6q9BvdPp+DTHTgo/GhA7xW9+LV4oerP9jqjOOOzevz8BCOd9nJH46bog0PT8NefT6Fm6I4nh0R3tf7t2NZEOQzeedFXPAuOPDCU1ZvseIDD/kAHPQ7QxvZGIAshokTV1OZiXLegzza0lG5QUVqWo9UWi0brSXN1pcQ+HRcCjV8zrgWePUzIppZWcvj5mnEkye2sof/tuoh5jUswzF8d/CczB61kqqn067Ln1+Nxzo6rIrg/Xkbl095dHhrE/O+/2Ar+yI8sy+nvG7Xp2QjRFgW9dFEBp7rF4OvX1wqELnnWStbWqrtaj3zwhNkPfJM723JFGrqgkEVqaENXLKWmz4JBq3jXt4yL26ZKVSwW4JPB+wt2cgVJv0WunMMRl1gDJ4RsKWDLWNgGNajQ2yZa1yx4AyLUBOY9Bw8p4N1Az4rPmAlLIFx2YRFHz6xAE6yMwPw0VXXgArJCfPv7CCe1fFB/8NZiIn1AX4lRT/INcc9wgEvl4AdOTGdZsK9DIAv6OiSdZNeIhZrCWuFj/Gcn6utgAuGecAEIIYe7CG+M8c345Z7voL+O9Npd6Yg83pfQV7Aq68EHmJlyEHPBsQLebk62gKXTOPbS2N7FGx8DSYMamP1rilawNAfEbfHNLgJyO49gM4Nen6wwE8s0XZn+l84iMcd8iVzuF10sHGGOR79YiM6nmnKdJNkWr9z0c5afeF6xT2BdVfdybeoJ/6BE2Y+gR/m6PeRCTxJvX+TgFvmY5oT6AW/g3N7bmjazjtJBth3ng8xdM0GDgDHcqqbpHc5mvkboRc15okZA9QJMBI+TpwNTAb4JdCPuA8xLawjgZ4VU49L0cx2zk0+UY4TLwsJdre45BaXYO8reD7gmL9joKUlAY5jDeoCeVgKwxqPQY+8AOdw62k91nqqr3SAZzwPc8cewv4CflD+nAmVYa8MbAAcnrj1oLbamQn2OPLe/4t3yCeYuJz61/OhLvo8c6MFMfXVjD2GOdW1nS+WWO/ZFvtC7+b+p9i/HXDRTLcc6sziT2eCHV3xDeLFm5LMOU1zgrpg+LmGvN7ZfAcgv16A+Y7YMzvzTeJ87tDfcwA7nWYOaqb8MpvIN/bjPOf3WeCmUKZ7y0y+/XK34n+GEo4aPg3U9e3xAH/baf/bB8ikur0+NmlVps3HACZdljSn2yNkfqOQU5qJ081LeZh1UT3L4u758zUDi9uD5lP8+XCa9n55V/0D'),
			this.addDataEntry('documents highlight', 28, 28, 'Documents Highlight', 'nVbLlqJIEP0aN7OYQ/HoLpcIlGY1mZSKZcGOV6dAKh5FeXx9RyRo2XO6p+fMwkM+I27cuBHmRLP27fwUHXe0SjMx0ZyJZp2qqh5G+9bKhJioSp5ONHuiqgr8JurLb3af5K5yjE7Zof4vF9ThwjUSl2xYGRbOdSfGhfMuOuIw30ccvrMszesoFpl1Pq8uIjvD1t9/wfo1O9V5Egk3ijPxVp3zOq8OsBlXdV3t4YDAjVmUlPxUXQ6pVYnqBPtp9j26iPrBgilyjjfr6gir0fmYJRjM97zNAPZMAjFvq8ptBU1FdTTRzGGqvpyvfKLO2j0EbL0tmBp2Mz3etpekV/JosVISu7q6WqqlnaHRzrgm++RKC7Oh1rRP90lOFuEx/EitWONTkiuNW2y465sXtjY71umG55ecFjwn852ItmmV2kou54v0GC5W1dua3M7lb3lQZHPnq7U2OWBRsm0ryGJlJPPNlBxWIlssr4HGelLoe6Ltdl5TvroHptBF3afzaeNu2TWeTzsvpw2dMxFs6dfv69Hmsrwk2rLNNKbEmlkH6vQca+QL6U3Ns6keFvX0NWd64J9fiWU+u9rg/47Jb8twG/b3+bJ8jufiEm5fupX2ugvnQsSHJQ/v49V7vBcK8ph+MJEI1gRbJnzVeE/UDcRfdjL2td5TG/ngck47XWH+EvdbmPdusdSYRXhmO1NSkAu1qUHy2TEEHpdrArm7oUZEiba6JtasiOcvPXqGiBuSP//5VAs2r+E+7MOPJfhxcrf/5PjNmp6jrSGCj9dFsn8po+37JbXv+8+uuhLhgT54eVvMdumc83AvzrGNDLyev1ls9m1NOCL3faK5hanStQIRBW3Q6Z3n0wstSoy49yxdhUgvDDLjwhr9CJCpjtqrHV0DQ7nZwjmV2CanFoyBRc9eXjyfa0EHNouN6hbEQPusMEebCtwxFbxP+x1huf5EfVa4cs7BDpzt+RPMW2YnNZxrGK4BhsB34Bvw0Xcj/SL2nqtw3vDsdOvJTIoC7dA+AP+Owjr0Xyqjf4kvtjneU1xffnu0DXjRNsR4s23KswO2XUXxjJ+owJMCvGDMgJW20keO/hOJM9srNc31nvkJH75h5fol2jdijMVfGlChCtMC4CTQ6Nbp4GsQmyBOtAv+ndoteAcYwH4JVW/+8gzgNQDDxbNJt4aYwH/7Dx8ts3Sd2QLwB3iuzUqlpZBb1gM+H/Jll4DEBH/LBvC20BlgnHTekE8YlzrmnflBLfPZSV3UA5/mkM98yFFkj3z+gaNBF9LmON/ogBM1gJw/Jagffwn6THqpn0GDOlPRrwO8OR3mErBCXokcM3uDY4Mt8Ax9Qu14fgLjTQ+YG2/La9A0xCT1ZmCeXakpgnpTMD6py2KD3571L19iyJtnmzoBXdPCMX4ZV/cYl4N101JZR5gD8iS7S7GBfUeTOsNuDPr2HnQG2oKYNu1QUxRqykH9PmhB1iP4uWu0RdsPtXfHEFkK4KA6Ve85amAfOizmD/CubzX4x7pSBrujT4mN3OudWHd99HRLh3pfDz1E1vutprGGbzEsjsxDPXb/0nMK5zPfHeCxkD9ejxpSweadD1oICpoFGxvuoX5Q76BP9v96VPvYo+R47ow8j/3hno+NQqVGzcGOn6DthvXIMe2wHqjPDakryREFjpwRy8j33RbV2diX3osE9Ab181CP2AfHelSG2IGXTQO4uXHn0R/1grrNf9m/CtSV7G3AseTcX6pjbeP+l5/+o/C/Vw17HZ9W2mx8fMGzJ2t/+4CTS+PrbZ5V+6w+dXCkydN6Nz7inodbuyznu/rnteg8zPn95udrEAbjg/A2/Xx4yr2f3qU/AA=='),
			this.addDataEntry('documents non', 28, 28, 'Documents Non-SAP', 'nVbLlqJIEP0aN7OYQ/HorloiUJpVZFIqlgU7Xp0CiXgKVODrOyJB257TPT1nFh7yGXHjxo0wZ5pVdYvP6LindZqJmebMNOuzrttxVHVWJsRMVfJ0ptkzVVXgN1Off7P7IHeVY/SZHdr/ckEdL5wjccrGlXGhaXsxLTT76IjDvIo4fOdZmrdRLDKradYnkTWw9fdfsH7OPts8iYQbxZl4q5u8zesDbMZ129YVHBC4MY+Skn/Wp0Nq1aL+hP00+xadRHtnwRQ5x5ttfYTVqDlmCQbzLe8ygD2XQMzrqnJdQVNRG800c5yqz82Zz9R5V0HA1tuSqWE/1+Ndd0oGJY+WayWx67OrpVraGxrtjXNSJWdamBdqPQ1pleRkGR7Dj9SKNf5EcuXiFlvu+uaJbcye9brh+SWnBc/JYi+iXVqntpLL+TI9hst1/bYh13P5Wx4U2cL5am1MDliUbNcJslwbyWL7RA5rkS1X50BjAyn0U6KtLmTZ8ERbnxProYjV7pwUNU+qNH+1y861zI7624bYzuBtyq9kqXD3wBS6mcOYKbFmtoH61MQa+UKWL4cg5wOzLpz5FO4k/avf8G8b89HVRhw3bH5XhrtwuM1X5WO8EKdw99yvtZd9uBAiPqx4eBuv3+NKKMhn+sFEItgl2DHhq8Z7om6Bh7KXHGz0gdrIC5dz2usK81e438F8cIuVxizCM9t5IgU5UZsaJJ8fQ+BztSGQw5ec6YHfvCCikZV5ES+eB/Qs2cof/3yqA5vnsAqH8GMFfpzcHfSKaPu9dylf3qynJtoZIvh4WSbVcxnt3k+pfdt/dNW1CA/0zsvbcr5PF5yHlWhiGxl4aV4tNn/dEI7IfZ9obmGqdKNAREEX9Hrv+fREixIjHjxLVyHSE7Op7sIa/QiQqZ7a6z3dAEO52cE5ldgmp5BxF1j07NXJ87kW9GCz2KpuQQy0zwpzsqnAHVPB+3TYE5brD9RnhSvnHOzA2YE/wLxjdtLCuQvDNcAQ+A58Az75vki/iH3gKpw3PDvdeTKTokA7dAjAv6OwHv2XyuRf4ottjvcU15ffAW0DXrQNMV5tm/LsiG1fUzzjJyrwpAAvGDNgpZ30kaP/ROLMKqWluT4wP+HjN6xdv0T7Royx+CsDKlVhWgCcBBrdOT18DWITxIl2wb/TugXvAQPYL6H6zV+eAbwGYDh5Nuk3EBP47/7ho2OWrjNbAP4Az3VZqXQUcssGwOdDvuwSkJjgb3UBvB10CBgnvTfmE8aljnlnftDKfPZSF+3IpznmMx9zFNkTn3/gaNSFtDnNtzrgRA0g5w8J6sdfgT6TQepn1KDOVPTrAG9Oj7kErJBXIsfM3uLYYEs8Qx9QO56fwHg7AOaLt+MtaBpiknozMM+u1BRBvSkYn9RlscXvwIbnLzHkzbNNnYCuaeEYv4yrv4/LwbqB7od1hDkgD7K7FFvYdzSpM+zKoG/vTmegLYhp2401RaGmHNTvnRZkPYKfm0Y7tH1XezcMkaUADqpT9ZajC+xrno35A7ybaw3+sa6U0e7kU2Ijt3on1k0fA93Rsd43Yw+R9X6taazhawzLI/NQj/2/9JzC+ZHvHvBYyB9vJw2pYPPGBy0EBc2CjS33UD+od9An+389qrvvUXK8cCaep/5wy8dWoVKj5mjHT9D2hQ3IMe2xHqjPDakryREFjpwJy8T3zRbV2dSX3osE9Ab1c1eP2AenelTG2IGX7QVwc+PGoz/pBXWb/7J/Fagr2duAY8m5v1Kn2sb9Lz/9R+F/rxoOOj6xtPn0CIPnT9b99iEnl6ZX3CKrq6z97OHIJU/b/fSYexxv7bOc79uf16JmnPPbzR+vQhhMD8Pr9McDVO799D79Dg=='),
			this.addDataEntry('documents', 28, 28, 'Documents SAP', 'nVbZlqJIEP0aX+ZhDrJ0Vz0iUJoWmZSKZcEbW6ds4ilQlq/viARte0739Jx58JBrxI0bN8KcKUbZLT+D85FWcVLMFGumGJ9V1YyjsjOSopjJUhrPFHMmyxL8ZvLLb3bnYlc6B5/JqfkvF+TxwjUoLsm4Mi7UTV9MC/UxOOMwLQMO30USp00QFolR19tLkdSw9fdfsH5NPps0Cgo7CJPirarTJq1OsBlWTVOVcKDAjUUQ5fyzupxioyqqT9iPk2/BpWgeLOhFyvFmU51hNajPSYTBfEu7BGAvBBD9tirdVtBU0AQzRR+n8kt95TN50ZUQsPG2YrLfL9Tw0F2iQUqD1VaKzOpqK7ES95pCe+0aldGVZnpLjechLqOUrPyz/xEbocKfSSq1drbntqtf2E7vWa9qjptzmvGULI9FcIir2JRSMV/FZ3+1rd525HYufUu9LFlaX42dzgGLlBy6gqy2WrTcP5PTtkhWm6unsIFk6iVSNi1Z1TxSttfImGeh3F2jrOJRGaevJp3bht4xM6+JSeZsl38lK4nbJybR3QLGTAoVvfHk5zpUyBeyWp+8lLdwR2V9C3it9tWt+bed/mQrI447NrfL/YM/3Oeb/ClcFhf/8NJvlfXRXxZFeNpw/z7evodlISGf8QcrooK13oEVrqy9R/IeeMh7wcFOHaiJvHAxp70qMXeD+x3MBzvbKMwgPDGtZ5KRCzWpRtLF2Qc+NzsCOVynTPXceo2IRlYWWbh8GdCzYCt9+vOpDmxe/dIf/I8N+LFSe1BLohyPTpuv34znOjhohfexXkXlSx4c3i+xed9/suVt4Z/og5e31eIYLzn3y6IOTWRgXb8abPG6IxyRuy5R7EyX6U6CiLzO69XecemFZjlGPDiGKkOkF2ZS1YY1+uEhUz01t0e6A4ZSvYNzMjF1TiHjNrDomJuL43LF68FmtpftjGhon2X6ZFOCO7qE9+lwJCxV59RlmS3mHOzA2YHPYQ4Kiho41zJcAwyea8HX45PvVvhF7AOX4bzmmPHBEZksMrRDBw/8WxLr0X8uTf4FvtDkeE+yXfEd0DbgRdsQ4822Ls6O2I4VxTNuJANPEvCCMQNW2gkfKfqPBM6klBqaqgNzIz5+/cp2c7SvhRiLu9GgUiWmeMCJp9CD1cNXg2pBnGgX/FuNnfEeMID9HKpf/+UZwKsBhotjkn4HMYH/7h8+OmaoKjMLwO/huS7JpY5CbtkA+FzIl5kDEh38bVrA20GHgHHUO2M+YZyrmHfmeo3IZy900Yx86mM+0zFHgTnx+QeORl0Im9N8rwJO1AByPo9QP+4G9BkNQj+jBlUmo18LeLN6zCVghbwSMWbmHscaW+EZOkftOG4E4/0AmFvnwBvQNMQk9KZhnm2hKYJ6kzA+octsj9+BDS9fQsibY+oqAV1DZ9J+GVf/GJeFddNRUUeYA+yAoMlsD/uWInSGXRn07TzoDLQFMe27saYo1JSF+n3QgqhH8HPXaIe2H2rvjiEwJMBBVSrfc9TCvuKYmD/Au7vV4B/rShrtTj4FNnKvd2Lc9THQAx3rfTf2EFHvt5rGGr7FsDozB/XY/0vPyawf+e4Bj4H88WbSkAw273zQrKCgWbCx5w7qB/UO+mT/r0d1jz1KjJfWxPPUH+752EtUaFQf7bgR2m7ZgBzTHuuBulwTuhIcUeDImrBMfN9tUZVNfek9i0BvUD8P9Yh9cKpHaYwdeNm3gJtrdx7dSS+o2/SX/StDXYneBhwLzt2NPNU27n/56T8K/3tlf1DxiaUspkcYPH+S7rcPObE0veKWSVUmzWcPR9o0bo7TY+5pvHVMUn5sfl4L6nHO7zd/vAphMD0Mb9MfD1Cx99P79Ds='),
			this.addDataEntry('event highlight', 28, 28, 'Event Highlight', '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'),
			this.addDataEntry('event non', 28, 28, 'Event Non-SAP', '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'),
			this.addDataEntry('event', 28, 28, 'Event SAP', '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'),
			this.addDataEntry('factory highlight', 28, 28, 'Factory Highlight', 'rVbLsqJIEP0aN7OYKHl0t0sEL5ZBgQqKsOPVBSUIIaDA13cW4L23O7pnZjEREla+T55MKReiWnT6PahSUsZJvhA3C1G9l2UznYpOTfJ8IaAsXojaQhAQPAvh7Q/W5WhFVXBPbs1/CRCmgEeQt8mkmRR10+ezok6Dih+zIqDwvU7irAnCPFHr+tjmSQ2mv/8C/SO5N1kU5EYQJvm+rLMmK29gDMumKQtwyLlhHURXei/bW6yWeXkHe5x8D9q8+ZRByTPKI5uyAm1QV0nEm/medQnAXo9AlJcWvTQ8VdAEC1GZROGtftCFsO4KaFjdb03B79dS6HZtNKAs2B5RpJUPQ4zFuJdF0suPqIgehClPoq6GuIgyvPUr/xKroUhXOENPg52o4SitaSu9pfIH00A/V76Qor2NRzkW8musgz/DEmZSgcU0tZ5XirVuiLd57dtrlFzW+d7eIf+SIkMwh6jHgHOXmZLn1DvVlodYW3+NxOMjUpcsFLpHxEpGtDXz3TdmieiVdWfcTEQuzRDrq6fhmo9QX/VWRp7mQAdL975+tz2W6Juvqq3QPe+KI3DeUX3z9XMRDe/ybq93VVic0+ga9557rHxXRlj/OJ9duYq3ZIVv58G/7JxIf2P+adWeL2aOs7VMGMoIO7VkUGSQpUkmramd0Gh3QO4lZA4HYJd2nDWDKYNlA5PuYYWvm2yfzZgPgGdrolBUqCd0aSTyutCvih//6gP5QsEvIuHMJ9Ph7Ntnhp0nMJW3wGZ/FHepr+d5eDt88gCurr7rD+91nO7pXY4l1v0q1J+8/z5UKTvY1wzrHDfqzUySLcejxMHQLwY7EgzmLQ3n1JrORvCcTWuqSmewAyWq8sSa0hBbQpZ2aAy2kc2CwPdBNhjuTRW15nCVDBbBVk1nrG1awiIUM8jvEORomwHsHda81nKU/y3/mW1gJm/YUqWlpfmuwXJGRp8I4r3BGOsgXmfMb6uSfOiljvTgY/PndZZkwLo02A7iFR7fmoxQHsNrTViP5bgvBeF2jnvMy+tMPrzO0SUO2N0NnIk84hyu7z3Cr/I5+Smita1MqCuaDqWEHVoTUejFFIwxngJfhyX4NGScjYlJJg1xhkB/Lse9dNIvoaM0MMvB1nBLlh5wRHtT/zVWEc3rmNvlOQJt3HEp4XugSoKlea/6EH+COK+B/MsAsMM8JK8HjD3HP/b4zsvI7Zb8nmeNwtxP0owX8z2z9H/kDfqediXUDsAZ/AY5Tpjvb3aFzrvSEucqAD5kwSwJwwh2RJ52BEvzGeKwaPKeMmlJhmMNvUnwVhz4npFb1RjOFep5I+/EOaeEz8Tm9aLlVGveT+BkxDuc6OzDOZkxAdZLxWchwz6NsSPuX31tzsdp5iD6yAfyaB9rrL/A+6cI3K42LrtlqJ9WuDgL8E57+PohM17vwOH5iET/tqf87uOf9XxBwtWUdH+8ZEfVfMPqSVkkzb0Hl2cWN+l80X6botIko2nzsy6oJ5m+R37c2HCYL+2X+PHnYLT99N/hBw=='),
			this.addDataEntry('factory non', 28, 28, 'Factory Non-SAP', 'rVZJs6JIEP41XuYwUbL0tEcWH5ZBgSiKcGProliEEFDg108W+N7r7uiemcNESFi5f/llSrkStWow7mGTkTpJy5W4XYnava675VQNWlqWKwGxZCXqK0FA8KyEt99Y17MVNeE9vXX/JUBYAh5h2aeLZlG03Vi+FG0WNvzIqpDCt5omrAujMtXa9tiXaQumP/8A/SO9dywOSzOM0vJQt6xj9Q2MUd11dQUOJTeoYVzQe93fEq0u6zvYk/Rb2JfddxmUklEe2dUNaMO2SWPezDc2pABbnYEo71r0ruGpwi5cicoiCm/tg64EdaigYe2ws4RgVKXIG/p4QizcHVGs1w9TTMRklEUyyo+4ih8kV55E20xJFTO8C5rgmmiRSDeYoaeZn6npKr11UkZb4w+moXFpAiFDhxOe5UQoi8QA/xxLOJcqLGaZ/Swo1ocp2ZVtcFJRelXLw2mPgmuGTMGa4hEDTvNmIaKpf+GdhSJR6Xxh00Yi/oJ3+5vPqExOT0rc7drUlIFMRWOP6gZr8pToW5qO6pQYm6fpWY/I2Iw2U8dAwDWZnBbr5wliRMIKyI3ogXfHkbgf6L4GxqWKpw95fzCGJqouWVwko+8dm8CTETY+zxdPbpId2eDbZQquezc23vLgvOkvV6vETJVJjhjJzz2ZFBlkaZFJb+lnNNtdkEcJWZMDLNOBs2fmymSfgFHP2eBiyw7Mz1Nj+5fmAJ6FE+oLQxaLvC7nCj/+1QfyRUJQxcKFT2jA7CswvWeW5LvtXnOfwFbZB97beBT3WWCUZXRzvvMArorAC6aPOu7w9K/HGhtBExlP3v8YaTR3TgXDBseNRotJsu36MCsM/WKwI8HM/bXpnnvL3Qq+u+0tmKGZO5RoyhPrSkdOErJ1pzPzrWxVBL4d2czxaGmot6ZCMvMYtms5Y33bkzxGSQ75XYJcfTuBfcC639uu8r/lv+RbmMkbtjVpbeuBZ+ZlTmafGOL9yZzrIF5nzn/SJNkZpYGM4HPiz/tZkgHr2sz3EK/w+N7KCeUxvNaC9VjP+1IRbue457y8zuLD6xw94oLd28KZyDPOqfjoEX6dz8VPEe1dY0Fd0XIpJbnTW4hCL5ZgzvEU+HLW4NOReTYWJkyaEoZAf6nnvXSzL5GrdDDL6aTjnqx94IiOlvFzrCJaxZzb4zlCfd5xKeV7oEmCrfvv9SH+DHF+B/nXIWCHeUj+CBhHjn/u8YOXmdsd+TXPOoW5n6UXXsz3zDb+kTfoe9mVSHeAM/gNcpww31/sCn3tSk/cQgB8yIZZkhwj2BF52REsvc4Qh0WL98SkNZmOLfQmwdtx4ntGbk1nugXU82feiXvJCJ/JideL10ut134CJzPe6UxfPpyTFybAem34LGTYpzl2xv2z74nzcX5xEH/mA3m2zzXUL/D+qUJvaM3rfh0Z5w2uLgK80x6B4TDz/R04PR+xGNwOlN+B/KO+Lkq4otLht5ftrHrdtEZaV2l3H8HlyZIue124X5eoLGU0637Uhe0i04/Iz5sbDq/L+138/JMw2374D/E3'),
			this.addDataEntry('factory', 28, 28, 'Factory SAP', 'rVZJs6JIEP41XuYwUbL0tEcWH5ZBFS4owo2ti0IQQkCBXz9Z4Huvu6N7Zg4TIWHl/uWXKeVCNsreuod1RqokLRbyeiEb96pq51PZG2lRLCTEk4VsLiQJwbOQ3n5jXU5WVIf39Nb+lwBpDniERZfOmlnRtEPxUjRZWIsjL0MG33qa8DaMitRomkNXpA2Y/vwD9I/03vI4LOwwSotd1fCWVzcwRlXbViU4FMKgh/GV3avulhhVUd3BnqTfwq5ov8ugFZyJyLaqQRs2dRqLZr7xPgXY+gREe9eid41IFbbhQtZmUXprHmwh6X0JDRu7DZWCQVcir+/iEfFwc0CxWT1sOZGTQZXJoD7iMn6QXHsSYzUmZczxJqiDS2JEMlthjp52fmK2q3X0qA2OIR7MQutcB1KGdkc8yYlUXBML/HOs4FwpsZxlzvPKsNmPyaZogqOO0ote7I5bFFwyZEt0jAcMOO0bRcTQ/8IbiiJZa31p1UQy/oI325vP2UiPT0bcvWpDZeqeamfQV9hQx8Rcs3TQx8RaPW2PPiJrNThcHwIJV8R4MseMG2zinhhXyI3YTnQnkLgf6L4G1rmMxw95u7P6OirPWXxNBt871IGnImx9ns+eWicbssK38xhctm5sveXBadWdL7TAXFdJjjjJTx0ZNRVkZZZJR80TmuwuyIOC6LgHllkv2LNzbXSOwKi3X+Hrmu+4n6fW+i9jD3hmTpgv9Vksi7qCK/z4Vx/IF0lBGUtnMaEe86/A9JZTxXebreE+ga2iC7y34SBvs8Aqiui2/84DuLoGXjB+1HH7p385VNgK6sh6iv6HyGD5/njl2BK40UC5ojquD7PC0C8GO5Ls3F/a7qmj7lry3XVHDa238z0jhvbEptaSo4Icc9/a+VqlJYFvmHOOB2qgjo5Xxc5j2K75jM11R/IYJTnkdwlyzfUI9h6bfue42v+W/5yvYSZv2DGUpWMGnp0XOZl8Yoj3R3uqg0SdKf/RUNT9oPRkAJ+jeN7PigpYl3a+hXhNxHc0J0zEiFoz1kM17UtJhF3gnvKKOrOPqHPwiAt2bw1nok44x+tHj/DrfM5+muxsagp1ZeoyRvJ9RxGDXqhkT/EM+Novwacl02woJlwZE45Af66mvXSzL5GrtTDL8Wjijix94IgN1Po5VpPpdcrtiRyhOe24koo9MBTJMf33+hB/gji/hfzLELDDPBR/AIyDwD/1+MHLxO2G/Jpnk8HcT8oLLxZ75lj/yBv0Pe9KZO6BM/gNCpww31/sCnvtSkfcqwT4kAOzJDlGsCPqvCNYeZ0hDstU9MSVJRkPDfSmwNtxFHtGbnVru1eo50+8E/ecETGTo6gXL+dar/0ETia844m9fAQnL0yA9VKLWaiwT1PshPtn36Pg4/TiIP7MB/Jkn2roX+D9U4Ze39iX7TKyTitcniV4pz0Ca8/t93fg+HzEcnDbMXEHio/+uijhikr73162k+p101ppVabtfQCXJ0/a7HXhfp2jspSzrP1RFzazzD4iP29uOLwu73fx80/CZPvhP8Tf'),
			this.addDataEntry('feature highlight', 25, 28, 'Feature Highlight', 'jVZLl6o4EP41bmYxB0m8t10ioJ0+JLQK2rhD4CIv8QgI5NdPVbBv9yzumVlwyFeVqvrqEciMmNWwuYe3C6/jpJwRe0bMe12306oazKQsZ7qWxTNizXRdg2emr/+gnSutdgvvybX9Pwb6ZPAIyy6ZJJOgacfyKWgu4Q2XWRWm8F4lcdaG5zIxm2bXlUkDqr//AvkjubdZFJZOeE7K97rJ2qy+gvJct21dwYYSFaswKtJ73V1jsy7rO+jj5FfYle03D0aZpWjZ1jeQhs0tiTCZX9mQAO2VImJ8SrVPCboK23BGjAnq6+aRzvTVUEHC5vur0E/jip6PQxdJLQtfd1pk1Q+HxCQeF4SPi0dURQ+eGz03lzKuooy9nm6nj9g8k3TJMq13cj91PKMTe2MUezoyi1GWrerTsbyGr9slyxUm4XGnhZaW8dzveMaAw1smaOA1b8w0XiKyW5w3fhq/lv3Jg05sDjQ2l3lEePaeBXmysX+a26KLyLZPiNDOxGgDfdmcCfvBpNEH+uESyHb56dPcL2RsrX+C30dkzvOzPjyivM65FVEuL5VLtIqRy8Xti5RZ/eMZ/xur982uPF35N4npDU14XJTBx9trVK2L8HjoYnN1/b1eH7rwYyff92/zSD+MPlldgNf7uTzI056licewGtLJjbkYAVuf2B5FhnobMO+EFWlQMcqhDnxPiWv5GduUBfhdsZx+8kY+Mt4se7YRTfAhMC7kbGSO/K89NvhbVqerKGPsyJ49vtX4xdGH27k6XKIiHoPj7nY6LrTfeq9/nDaHKvqK8RJt1lporqrwODQq96qvmWbfIAfkLLhnd0L6xNlTzbWEpbC1nSPmlt1xL9WYtYU99gC1GXHtWpwEyq5IVQ32Rs8sI+Wm1nHp606+JfzYt1A7XZhU8lzoYqTUtd6OPAe7TQ9+OXFyprsb3kHfYW1rrklHnm/BB8TPuXSRg0xxL8S2B5xieMPUGchFhzfsK+aukkcQy4DYNuWjwpTvERsE5IilGBH7RCi9D/ZUul6BPFE3QC7w1sCnQSEW4rnr+S2eHJ5HHc95++SpiUyDOgWd8LgOtSI8B55WOsJ6FHKLOQ2OZ4OvQBd7qIsFsRUusLa9azHwxajSSa6BTIfagcyfu1BHIQNd7fMwJtoykHH0ATwCzfF86EMwyXOMBSfXC1rMCfTIGThtEc9B34qM9hxyRexa21bVSfGCvmLeMsU4PfKBKaCwHvjHrRVTT1J468ITDYc+Qp6q70KKHDmKPAA/yCWCeuC84DnZUoXhKzFhXws8rrlotzeksAqcO5gZnB27hfkgyBv8a8LbKb9QF+Q0Qm8I9o2PGpzH7QL6DjhYTNjvwaaH/jz542xEFPgCP5aCbgE5Kr6c3FrHg7gWk8zC+m31M8wzzhdwwHoOscrFmJ9xlqEOzEK8nvh4Ac44+C96AXqwl46H9qnqC9gTsNOmGcF9KeHX4Fn7Q6O+LXucr2LhHnHuGfniXOD+Ocwq2lOhZjwlAjhz7K3cLpjiysaJ47qZYtvzibs/VxhmecIRDUbMocBv2sgztabP+cRaUeCIXKiL59GyIQf0a2OvB+hjCzWjQkapmgGLP3GcT/6gbyb2CGYhg9oit696/WDZy9fX+cUh8C+TFH/PZPX8gcOvMxn+eAlQoucNYJPUVdLeR9jSZ3F7eV4EFpPVJcnSy9NKf5lkYTPh9Lfl140CFs9LxSf8urwo3b/uNv8A'),
			this.addDataEntry('feature non', 25, 28, 'Feature Non-SAP', 'jVZNd6s4DP012cxiDsHOTLMkQFP3YdMESEp2BHjEfIScAuHj149k0vbN4p2ZRQ6+kiVfXQniBTGrYfsR3S68TtJyQewFMT/qup1X1WCmZbnQNZksiLXQdQ1+C/35N96l8mq36CO9tv8nQJ8D7lHZpbNlNjTtWD4MzSW64VJWUQbPTZrINjqXqdk0+65MG3D9+QfY7+lHK+OodKJzWr7VjWxlfQXnuW7buoINJTo2UVxkH3V3Tcy6rD/An6Q/o65sf8lglDLDyLa+gTVqbmmMxfyUQwq0N4qI8WnVPi2YKmqjBTFmqD8392yhb4YKCjbfXoR+Gjf0fBy6eNJk9LLXYqu+OyQhybgifFzd4yq+89zoubmekiqW7OV0O70n5plkaya13smDzPGNTnjGKDw6MotRJjf16Vheo5fdmuUKk+i41yJLkzwPOi4ZcHiVgoZ+88pM4ykm+9V5G2TJS9mffOjE9kATc53HhMs3uZoSy8jScTMl23XvHMX9vF2PrtyMJ53Vrm83zLIH4fUZ9/nqh99kPz2ji8luYC9NBrnvsbnMz/pwj/M6i6tE/rC45pjGko99JiZ2c8fNmln9/cHjF3Zv2315uvJfLKY/NNFxVYbvry9x9VxEx0OXmJvr1/r50EXv++nNe13G+mEMyOYS6oe3c3mYTh7LUp+hKpOTG0sxArY+sT0KiX4bMO+EFWugHOWgB/coca1Asm1ZQN4Ny2nFyOXi9gXyUbqwrWjCd4Hnol7Smf5rjw351tXpKsoEO+Ox+5sM83Rr/23uiidHH27n6nCJi2QMj/vb6bjSvvx+fz9tD1X8fcZTvH3WInNTRcehUbVXfc00+wY1IGfBfbsTU0Acj2quJSyFrd0SMbfsjvuZxqwd7LEH0GbEtWtxEqq4IlMaeEbPYBa4qXV8CnQn3xF+7FvQThcmnXgudDFS6lqvR55D3LaHvJw4OdPdLe+4FcPa1lyTjjzfQQ44P+eTixymDPfC2ThLxghPmD4DuejwhH3F0lX2GM4y4Gyb8lFhyj3EBgE74kmMiAMilD+AeDq5foE80TdALfDUIKdB4SzES9cPWnyDeB53POftg6cmpAY6hZ3wuQ5aEZ4DTysbYT2KaYc1DY5vQ65QFx7oYsHZCheobe9aDHIxqnwTzL1HddAObMHSBR3FFOpqn49nYiwDG8ccwCPUHD+APoSzPcez4A32wxZrAj9yBk47xEvwt0LSnkOtiF1r1yqdFC/oK9Y9ZXhOj3xgCiisB/5+a8XckwyeuvBFw6GPUKfqu5hEjhxFHkIe5BKDHjgv+J7sqMLwtZhxoIU+11yM84xJWAXOHcwMzo7dwnwQ5A35NeHvVV7QBTmN0BuCfeOjBu/jbgV9BxyuZhz0ENNDfx78cTZiCnyBH8vAt4IaFV9Obq3jw7kWm5iF+u30M8wzzhdwQD2HRNViLM84y6ADsxA/z3z8EGcc8he9AD/ET46P8ZnqC8QTiNPmGcF9GeHX8KH9oVHfFg/nq1i5R5x7Rr45F7h/CbOK8VSoGc+IAM4cezvtVkxxZePM8bmZz7aXM/dgqTDM8oxjGo5YQ4HftJFLtaaP+UStKHBELtTF99GyoQbMa2OvB+hjC5pRMcWZmgGLP3CSz/mgbyb2CGZBgrbI7Vuvv5h8+v46PzkE/tMmin/TZPP4I4e/0HT47WVAmR43gW1aV2n7McKWXibt5XEhWM1Rl1Rml0eU/jTbombG2Vfk980CFo/LxSf8vsQo37/uOP8A'),
			this.addDataEntry('feature', 25, 28, 'Feature SAP', 'jVZLl6o4EP41bmYxB0mcaZcItJ2+JPgAbdwhcDE8xCMgj18/VcHuvrO4Z2bhIV9VqvLVVwVmRsyyX9/D24VXcVLMiD0j5r2qmmlV9mZSFDNdk/GMWDNd1+A3019/450rr3YL78m1+T8B+hTwCIs2mSyToW6G4mmoL+ENl7IMU3iuklg24blIzLretUVSg+vPP8D+SO6NjMLCCc9Jsalq2cjqCs5z1TRVCRsKdKzCKE/vVXuNzaqo7uCPk59hWzS/ZDAKmWJkU93AGta3JMJifso+AdorRcT4tGqfFkwVNuGMGBPUX+tHOtNXfQkFm5s3oZ+GFT0f+zYaNRm+7bTIqh4OiUk8LAgfFo+ojB48MzpuLse4jCR7O91OH7F5JumSSa1zMj91PKMVe2MQezowi1EmV9XpWFzDt+2SZQqT8LjTQkuTPPNbLhlweJeCBl79zkzjJSK7xXntp/Fb0Z086MT6QGNzmUWEy41cjLFlpMmwGuP1snOO4nFeLwdXroaTzio++jWzbM3ddylkn//w6vTn3mgjsu3ZW51C7kdkzrOz3j+irEqjMpY/LANiUuKYxsA94+YOqyWzuseTxy/sNutdcbryXyym19fhcVEEH+9vUfmah8dDG5ur69f69dCGH7txs3+fR/ph8MnqEuiHzbk4jKc9SxOPoSqjkxlzMQC2PrE9CIl+GzBvhRVpoBzloAffU+JavmTrIoe8K5bRkpHLxe1y5KN0YWtRBx8Cz0W9pDP+1x4b8i3L01UUMXZmzx4bGWTJ2v7b3OYvjt7fzuXhEuXxEBx3t9NxoX35ve5xWh/K6PuMl2j9qoXmqgyPfa1qL7uKafYNakDOgnt2K0afOHuquZawFLa2c8TcslvupRqztrDH7kGbAdeuxUmg4vJUabA3OgazwE2thb7rTrYl/Ng1oJ0uTDryTOhioNS13o88g7h1B3k5cTKmu2veciuCNcyKSQeebSEHnJ/x0UUOY4p74Wy7x2mGJ0yfgVx0eMK+fO4qewRnGXC2TfmgMOV7xAYBO+JRDIh9IpTfh3g6ul6OPNHXQy3w1CCnQeEsxHPX8xt8g3gWtTzjzZOnJqQGOgWt8LgOWhGeAU8rHWA9iHGLNfWOZ0OuQBd70MWCsxXOUdvOtRjkYlT5Rq6BTQftwObPXdBRjIGu9nl4JsYysHHMATwCzfF86EMw2TM8C95gL2iwJvAjZ+C0RTwHfyMk7TjUiti1to3SSfGCvmLdY4rndMgHpoDCuucft0ZMPUnhqQtP1Bz6CHWqvotRZMhRZAHkQS4R6IHzgu/JlioMX4sJ+1rgcfgeQNzeGIWV49zBzODs2A3MB0HekF8T3k7lBV2Q0wC9Idg3PmjwPm4X0HfAwWLCfgcxHfTnyR9nI6LAF/ixFHwLqFHx5eTWOB6ca7GRWajfVj/DPON8AQfUs49VLcb8jLMMOjAL8evExwtwxiF/3gnwQ/zoeBifqr5APIE4bZoR3JcSfg2e2h9q9W3Z43zlC/eIc8/IN+cc989hVjGeCjXjKRHAmWNvx+2CKa5smDi+1tPZ9nzi7s8VhlmecESDAWvI8Zs2cKnW9DmfqBUFjsiFuvg+WjbUgHlt7HUPfWxAMyrGKFUzYPEnjrMpH/TNxB7BLEjQFrl96/UXky/fX+cXh8B/2kjxb5qsnn/k8Bea9L+9DCjT8yawTqoyae4DbOlk3FyeF4LFFHVJZHp5Rukvky2sJ5x+RX7fLGDxvFx8wu9LjPL9647zDw=='),
			this.addDataEntry('indent highlight', 28, 28, 'Indent Highlight', 'zVbLcqM4FP0ab2YxJQPujpdY+EEK4QfEjtkJQQOyMC4D5vH1c2WRxElXaqZqNr2gkO7znHNViJGO83Z5pZeUFFEsRvp8pONrUVRqlbc4FmKkoSwa6dZI0xA8I23xjXd896ILvcbn6r8kaCrhRkUdK4sylFUnBkOZ0otcZjlN4D27xdcqY1Q4NIzFpiizKivO4A+LqipyCBDSMaPslFyL+hzhQhRX8EfxL1qL6qGCKbJEZlbFBay0vMRMgv6VtTHAm90bmm9WBJY4yioaihiX5a4WcQnmv/96i5QtaEVHuqm22qK8JSNt1uZAGG9WrhZ0MyM8tDXrUUZXO8Ss4ubokR51E510kxvL2Y1wsyF42kc5y+xVcAleIxzqydTmZkKw2bnYaIgFMdZ8QizWu1aikZ4khG9lvGBn9xJqBsTPa+LZCT1sp/apTePDvnvt5xATXYLVrth49ne1MnuZCnqIishCmay7yY48Xs5/2th8YvpuEi5fkmglmsCHOS73RoSnnOnkPQ5vTzXTt02suyjUzeqoTctQt3/YvdkctX167Kvpc+YaR798xt6kj6zFT6h7Y3jMQ629MV5wwGOQPs3XOsptPU3XzSmxreY29AddhwpgbU/BIegfUEpbSQ8TcXx9XrF8caKHfR3h2SUARltQJbbmUlFQ49SCEo2dzQzCFVuwdUodOwn05zRYChGed/swF0hOLnp1BRNuczy4wtcme6a9ZJ96wwPTlsyTo9amoMzUPruIYPv2XVyoBTnT9gj6toCFh8tFL3uBirB/emQrs/D0d3aWoXTq7v6vijyx5QJRPMvpoS033vOY5U1ho/kFup1g7xJO6rV/Kgm3a5e7nOCmdvuXyuHHzrHgLPWsIp7Ru13TOpzo3t0WccczdNdrGsdXMRDfvq3v8TqBevZjrqH8UUHkGeU77nA2diyzVDGGRjLVQ/WNqO/bHdTtYa85fN5RjCYOt7VjhyTGkmCk4iVW1bt86F0+4h5qFmvP6NycDPmDz3vorTD2yoYebAOv8cVVWpGS+CZoFxWOfwI+wVdNvvLX2W8cB7xaMvAa8q13TT/PQCfVA9ehtsJ4OKGOZFC/a8ag1fiP0UrVhTkyRC27/b881flLLZVjlvfzKvHjf9FYYsngDXFw1pCbNwh0gjO7rYm/4BKXI/lCzNoDzYb32k8lv9bFUkcbcJEJ7CfrueREkGMxmL2Qsx8TqbVPJF5EvPf1BHo2TPlK5VPc1/6uJJ2s3fSABfnYgHpzmN9+qPde80seYOay74s8h8AxAVsidSkhrwGeDdGk/aj0gRrEt2XMHf8h+/gibdSdA18auM+GSxmuybj99mK/m4ZbfRkXeVxdOwhpsqhKh8v9SWWlcZak1WcbLdU+ec/8+EuAxfCj8Lb9+CG5+z79r/wD'),
			this.addDataEntry('indent non', 28, 28, 'Indent Non-SAP', 'zVZLb7M4FP012cxi5PDQNEsCJHE/TNqEhoYd2BRMIKAA4fHr5zqmbdpP1Yw0m1kg7Ps851wLM1PNol9fwiolJYvzmWrPVPNSlo1cFb0Z5/lMQZzNVGumKAiembL6wTu/eVEVXuJz828SFJlwDfM2lhZpqJshnwx1GlZiyYswgffyGl8aTsPcCaM4fypr3vDyDP6obJqygIBcOJYhPSWXsj0zs8zLC/hZ/Ba2eXNXwch5IjKbsgJrWFcxFaDfeB8DvOWtofFuRWCJGW/CKI/Nut61eVyD+c8/3iNFi7AJZ6oht8qqviYzZdkXQNh82rhKMCy1yO9bOiIebnaIWuXVUZnKBl0lg36lBb2SzOiIuRhZQTneBFXwysxITRY4MxJiGoNrah2xIMaydWLR0bUShYwkIdmziM/p2a0iRYN4uyV7nIT+8wKf+jT2D8PraEMMq4LNrnza459qcbxO89BnJbMQF3Wf+DGL1/Zf2DQeqLrTo/VLwjZ5F3gwx/VBY+YioyqBOH1klpHEw3Jk60Xn+O41Wi+GLV8OgYLLrWfX2LJ7d98lxCP6L69O3vZGS9XnHm/qBGpfqTnPIqW/0qxMaMH4L4sgxzTmZOgSd8TVdlgusNVdJxyg7yN3tSNUwlZ/CvxgvEMrbHXo6/nx9XFDi9Up9A8tM5dVAMyeQZ3YsoWyoMqpB0U6zJcaySRrsA1SJZwE6mMarPM8Ou8OUZEjMUH26uY0d7uj7+aeoh+o8sK/9IYHpo4i1UiOSp+CQgt8dhEx8fWnuEgJCqocEPTtAUsWrVej6HVTiD/csxVZ5uJ3dpZWYDVNt8PN/12RB7peodBcFqHf10/7xzktuhIju4JuJ9i7JCPt1jvVJMOtm7kZMbvWHV8aJzsOjgVnaqQN2WujO3S9kxF1f7OxzNlrKsy1czwZA/H9+/oWrxKoh+9zNelnJRFnNdtlTkbnjmXUMkZTCJc9ZF8Weh4eoO4Ie8XJ7CE0ke5kWDkOSGCsiYlkvMAqe9d3vet73FPNcrvXBrcgU/7k29/1lhhHaUN3tonXvHKlVqQmngHasdLxTsAn+K7Jd/4q/Y3jhFdJJl5TvvWh6dcZqKS54zrVlhj9ExoIh/pDNwet5v8brWRdmCNFoYX7/8pTnr/UkjlGfTuvAr/5DxoLLBzeEAdnDblFh0AnOLPPLfFWmcDlCL4Qs92DZtN766WCX++aQkcMuIgOe31rC07wrbIozD4Xs4dvFsR4ROBFZP+x1qFnR6Wvlj7JfevtajKI2t0IWJBnalDPhvkdpnofNb/lAeZM9H0R5xA4JmBLhC415HXAsyOKsB+lPlCDeFjE3PD7/POL9CTvHvjSwL02Xc5wXcb9jxf8zTTd7uu4LOLmMkBIx1mTTpf8g8xKY56kzVdbWMt98pH5+bcAi+mH4X37+WNy8335b/kb'),
			this.addDataEntry('indent', 28, 28, 'Indent SAP', 'zVZLb7M4FP012cxi5ADRNEsCebgfJmkgoWFnDAUTCChAePz6uY5pm/ZTNSPNZhYI+z7POdfCTFQj79ZXWiakCKNsoi4nqnEtilqu8s6IsmyiIB5OVHOiKAieibL6wTu9e1FJr9Gl/jcJiky40ayJpEUaqrrPRkOV0FIseU5jeC9u0bXmjGYWDaJsV1S85sUF/EFR10UOAZlwLCg7x9eiuYRGkRVX8IfRG22y+qGCnvFYZNZFCVZalREToN94FwG8xb2h/m5FYIlCXtMgi4yq2jdZVIH5zz/eI0ULWtOJqsutsqpu8URZdDkQNnYbW/H7hRZ4XcMGxOlmj5hZ3Cw1VMN+ppJ+dmM5u5FUb4kxH8KccbzxS/81NAI1nuNUj4mh97ahtcSEGHM5IyYbbDNWyEBikr6I+Ixd7DJQNIhfNsTBMfVe5vjcJZF37F+HJcSEpb/ZFzsH/1SL43WSUS8sQhNxUXfHT2m0Xv6FDf2JqftZsD7E4SZrfRfmuD5qoTFPmUogbjaEph5H/WII1/PW8uxbsJ73W77ofQUXZDhU2FyirdMC3sP0l1vFb47eMPWlw5sqhto3ZkzTQOluLC1ilof8l6lDTqxawJ24erntF3NstrcRB+j7zG3tBJWw2Z19zx8e0ApbRb1Zdnp93rB8dabesQmNRekDsxdQJzKXQllQ5dyBIi3mC42kkjXYeqkSjn31OfHXWRZc9scgz5CYYPhqZyyz25NnZ64yOzLlwL/0hgemjgJVj09Kl4BCc3yxETHw7ae4QPFzphwR9O0ASxqsV4PodVeIPz2yFVnG/Hd2ppZjNUm2/d3/XZEntl4haixy6nXVznmesrwtMFqW0O0Me5ukpNm654qkuLFTOyVG29jDobbSU2+ZcKYGVhNHG+y+7ayUqM7dFqaWo6m207aWK2Mgvntf3+NVAvXwY64m/WFBxFlN96mVsqkF85YxmkK47CH7htR1cQ91B9grVrrsqYFmVoqVU48ExooYSMYLrLJ39dC7esQ91iy2jtbbORnzR5/z0FtiHKQNPdhGXtPSllqRCs4naBcWlnsGPv53Tb7zV9lvHEe8SjzyGvPND02/zkAl9QPXsbbE6J1RTzjU79spaDX932gl68IcGaIm7v4rT3n+ElPm6NX9vAr8xj9oLLBweEMcnDVk5y0CneDMvjTEXaUClyX4QszWAc3G99ZNBL/ONoSOGHCRGexn26XgRJBlMph9JmY/JUJrlwi8iDgf6xn0bJn0VdInuW/dfUV6UbsdAAtyDQ3qLWF+x7HeR81veYA5FX0P4hwCxxhssdClgrwWeLZEEfaT1AdqEBeLmDt+j39+kXby7oEvDdxr4+UM12XU/XjB303j7b6Oijyqrz2EtDysk/GSf5JZScTjpP5qo5Xcxx+Zn38LsBh/GN63nz8md9+X/5a/AQ=='),
			this.addDataEntry('info highlight', 28, 28, 'Info Highlight', 'jVZdc6s4DP01edmHHQfI3ttHApS6g01SyAe8EcMlEBIyDQTwr7+SIW3vzHZ2Z5KxLUtHR7JkPNOtc+++J9cjq9OsmunOTLfe67oZZ+feyqpqppEinen2TNMI/Gfa8ze7c7VLrsl7dmn+j4E2GtyTqs1GySi4NUM1CW7H5IrT4pzkMC6ztGiSQ5VZt9tbW2U32Pr7L5Dfs/emEEnlJYesWtW3oinqC2we6qapz6BQ4cYyEaf8vW4vqVVX9Tvsp9mvpK2aLwhmVeRo2dRXkCa3ayYwmF9FnwHtpSJiPqTkIUGopElmujkutefbPZ9py/4MAVurF67Fw9I47PpWSFIkL29E2PXd01M9HRY6GxZ3cRZ3Vpods55kehYFfYmv8T61Dnr+RAvSeeUm90Kz5YE5+Bb+aZ6422usHckqoGqdatUpdUG/pAYtjTPVj0e/O+XU7mX6Ut3iYEmy/bJaBa8k3h+Jp3EpBgo8XwtuROHt1QoWMrWXP4T+dhfWvDxo/V2UdcnsZRnvnktfJw/UV+/CCds3MnWfOm/H7wf3afAL1nGZS9+NfvwKojJznR9WYOYrjAoZhB+sfsbu9izkx/p15fbXw3l7FKd0iHZv13i3INT9nG93i2v6wp7oZSvj/Wso3Ocy3jy12z2vaLFcsJIUrNy0TJoLWBvjmrXc3hC1H8J6MAiXa8hu3mPWvNKUfgCZ3K2f6MkpVsXEeQ18Xjg56GYeaf1R6OgX4rXo/T91AO+gxWehbfFkelr8/JrhsINMVS1kc3jTX4+xW1WHy/qLBuTqFO9i+eEn7Lto/1ZTN74e3A7jHw5WXq6DU0Fd5E16HhgDVEYP8fVc8iMLDJ3aTssHs6O2mTOLtCx0NC8wNN9lDcRt8ABkpZINLETZGuxBJgXK5lweJYySlxT26IKBPg+FoWQyQn3iK1xKFO7kI0KMkg0g65ido57GLZhLB+aR4ZVOzy8Pfw/fG923Hrjo6+GX6bxQXL6PCTDTMi2ZBd1hCzhTR4N8GH5IYX0a0AbqwpjkPYeaYDIaJj+AfcKY5wJrw84xHvnBc+f0Xiny0Tf6RN8TXmAQf4dYVB/zFCl/MNd9ez3OQ9SNNS9M/wlDB3A3ENO2BLwF2CEeyISEGNE+B36EhWv01/njqEN+Wi5ZrnJl56MMbCGnxLeVvJvkg1qrETgDJrM3OBosQD9mBzcHgbzD2QPGYEJsEeQXR3PBFZe1wT7Xc3VGmoPnpOTTOOY/IF/1NMgFxCb6CXfOLdyH2BSuM4f6+MpBjvbUGP1TwCVwJnnnww0H595BLSqugKfseKHwRswCsTbz0ZcDmERxBV8TJ9TNsaY6qJEGeEPOTlhPGvgd+T74u3DOFuQWsKbxEZ+OPPkwjeTbPLRT780jaTbT2WKNEW88O03VjH2C9QbqwlFnjrXBpTNXNS2hX0AXvgALasNom4YXYg3l842MsD4NhSFNqEOoUZsB982CO99xGvlgH2dnArIT+phH0BPMdrAmOtCZ+ghzttYhzpaXJvTLv+qoPcXZFjrGCf4NdV+UYI91bgt1DzCbYg7gnsVadwxuqXtm7PdA3S/YLxrUO8oWbK/6X8L5Q+8JmOejXhhNd4lYjHfJGvXm0CsdD+mkh/0cS9WLyBtkEzb2X4/23FbxdeqcCnUv4D2Ujxy3cBZU9RvcPe1Yi5gL1GNTPsaYwaZjl7rwHt8s2d2FHl9WOb5V8LecHjTwlMj6bx9FSjS9iNysPmfN+wAqXZE2x+lh9HO0OmZFfmz+lCW3cZ1/WH6+sGAyPbIey8/HnNr74633Gw=='),
			this.addDataEntry('info non', 28, 28, 'Info Non-SAP', 'jVZbk6o4EP41vuzDVgQ85/iIwDCZIlEHvMAbAieCKJaCQH79dgecmVO1U7tVWkk63V/fm0x069y5t/h6ZFWalRPdmejWrarqYXfurKwsJxrJ04luTzSNwH+ivXxzO1W35Brfskv9fwS0QeARl002UAbCve7LkXA/xlfc5udYwLrI0ryOD2Vm3e/vTZnd4ervv4D+yG51nsSlFx+yclXd8zqvLnB5qOq6OgNDiReLODmJW9VcUqsqqxvcp9nvuCnrLwhmmQuUrKsrUOP7NUvQmd95l4HZC2WI+aSSJwWh4jqe6OZw1F7uDzHRFt0ZHLZWr1yL+oVx2HVNIkkev76TxK4enp7qaT/TWT97JOfkwQqzZdZcpuckp6/RNdqn1kEXc5qT1is2wgvMhvtmv7TwT0Xsbq+RdiQrn6pzqpWn1AX+ghq0MM5UPx6X7UlQu5Ppa3mP/AXJ9oty5b+RaH8knsZl0lOw07twwqzFT/rKyUE361Cb3w86/UFf3y5hLmbMbwULnKlnmR2Tp+uyX8ypNZOp7YisX8jUnbfejj8O7rxf5os+0mjF5PpO7Y0EGZ3lJ8AmYoXeoSXBh3W/Ind7TuTH+W3ldtfDeXtMTmkf7t6v0W5GqPu53+5m1/SVzellK6P9W5C4L0W0mTfbPS9pvpixguSs2DRMmjM4G8OZNdzeEHUfwLk3CJdriLLoMHpeYcqlDxHdref05OSrPCwy1/lprcGeISYi1LpjoqNejBV9/CcP4B206JxoW8xQR/NfEOm3nBthcH+zghaiVTbR7qV/19+OkVuWh8v6CwfE6hTtIvmhJ+jacP9eUTe6HtwW/e8PlijW/imnLtpNOu4bPVRIB/51XPIj8w2d2k7De7OltimYRRrIo+b5hrZ0WQ1+G9wHWqFoPQuQtgZ5oMkEaVMujxJWyQsKdxRqgTQ8SAxFkyHyk6XCpUThjjpCxChYD7SW2QL5NG7BXjqwDw2vcDp+eep76t7oS+uJi7qeepnOc2XL9z4BZlqkBbOgS+wEcupoEA9jGVA4n3qUgbowRnrHoSaYDPtRD2Cf0OdpgrVhC/RHfti5czqvSMSgG3Wi7hHPN8hyh1hUH+IUKn2w15f2etgHyBtpXpD+CAIHcDfg07YAvBnIIR7QEgk+orwA+wgL1qivXQ6rDvFpuGRCxcoWAw1kIaZkaSt6O9J7dVYr2AyYzN7gajAf9ZgtTBACcYfcA0Zvgm8hxBdXc8aVLWuDfZ6nKkeag3lS9HEd4u+Tr3waxAJ8S7oRd8otvAffFK4zhfr4aoMc5Kkx6KeASyAnol3CpIO8t1CLylbAU3I8V3gDZo5Ym+mgywFMomwFXaNNyCuwplqokRrshpidsJ400DvY+7TfhTxbEFvAGtenfzrayftxJd/GoRl7bxpKsx5zizVGvCF3mqoZ+wTnDdSFo3KOtcGlM1U1LaFfgBe+BDNqw2qbhhdgDYnpRoZYn4bCkCbUIdSozcD2zYw739k02IN9nJ0J0E6oYxpCTzCY3VATLfCMfYQxW+vgZ8MLE/rlX3nUnbLZTnT0E/Qbal4UII91bidqDjCbYgxgzmKtOwa31JwZ+t1X8wX7RYN6R9qM7VX/S8g/9F4CezHwBeE4S5LZMEvWyDeFXml5QEc+7OdIql5Eu4E2YmP/dSjPbeVfq/KUq7mAc0gMNm4hF1T1G8yeZqhFjAXysTEeg88g07JLlXvPb5ZsH4keXVYC3yz4W4wPG3hSZN23jyNFGl9Gblads/rWA0ubp/VxfCD9GqSOWS6O9Z+0+D6cxYfk50sLNuNj63n8fNSpuz/efP8A'),
			this.addDataEntry('info', 28, 28, 'Info SAP', 'jVZbk6o4EP41vuzDVuRyzvERgWEyRYKOqANvCJwIolgjCOTXb3fAmTlVO7VbpZWk0/31vclMt8+9955cj6zO8mqmuzPdfq/rZtydezuvqplGimymOzNNI/CfaU/f3M7VLbkm7/ml+T8C2ihwT6o2Hykj4dYM1US4HZMrbotzImBd5lnRJIcqt2+317bKb3D1919Av+fvTZEmlZ8c8mpV34qmqC9weaibpj4DQ4UXyyQ9ife6vWR2XdXvcJ/lv5O2ar4gWFUhULKpr0BNbtc8RWd+F30OZi+VIdaDSh4UhEqaZKZb41F7ut3FTFv2Z3DYXj1zLR6WxmHft6kkRfL8SlKnvvt6pmeDqbPBvKfn9M5Kq2P2QmbntKDP8TV+y+yDLha0IJ1fboUfWi3fWENg45+KxNtdY+1IVhuqzplWnTIP+Etq0NI4U/14DLqToE4vs+fqFm+WJH9bVqvNC4nfjsTXuEwHCnb6F06YvfxJnzk56FYTaYvbQac/6PPLJSqE5JtOsHBt+qCZh9trMCwX1DZl5rgiH5Yy8xadv+f3g7cYgmI5xBqtmd2JwElv1KE9s0+ATcQKvUNLwg/rfsXe7pzKj/PLyuuvh/PumJ6yIdq/XuO9Saj3ud/tzWv2zBb0spPx20uYek9lvF20uzde0WJpspIUrNy2TFomnI3xzFrubIm6D+E8GITLNURZ9Bg9v7RksIGI7tcLenKLVRGVuef+tNdgzxgTEWn9MdVRL8aK3v+TB/AOWnxOtR1mqKfFL4j0S8GNKLy92GEH0araeP80vOovx9irqsNl/YUDYnWK97H80BP2XfT2WlMvvh68Dv0fDrYo15tTQT20m/R8YwxQIT3413PJj2xj6NRxWz5YHXUswWzSstDV/I2hBR5rwG+Db4BWKtrAQqStQR5oMkXanMujhFXyksIdNRnw8zA1FE1GyE8ChUuJwp10RIhRsgFoHXME8mnchr10YR8Zfun2/PLQ99C91QP7gYu6HnqZzgtly/c+AWZWZiWzoUucFHLqahAPIwgpnE8DykBdGBO951ATTEbDpAewT+jzPMXacAT6Iz/s3Lu9X6Zi1I06UfeEtzFIsEcsqo9xipQ+2OuBsx73IfLGmh9mP8LQBdwt+LQrAc8EOcQDWirBR5QXYB+BfkN9XTCuOsSn5ZIJFStHjDSQhZiSwFH0bqIP6qxWsBkwmbPF1WAb1GN1MEEIxB1yDxiDBb5FEF9cLZMrW9YG+zzPVY40F/Ok6NM6xn9DvvJpEAvwLe0n3Dm38R58U7juHOrjqw1ylKfGqJ8CLoGciC6ASQd576AWla2Ap+R4ofBGzAKxtvNRlwuYRNkKuiabkFdgTXVQIw3YDTE7YT1poHe092G/B3m2IbaANa0P/3S0kw/TSr6NQzv13jySVjPlFmuM+GPuNFUzzgnOW6gLV+Uca4NLd65qWkK/AC98CUzqwOpYhh9iDYn5VkZYn4bCkBbUIdSow8D2rcnd72wa7cE+zs8EaCfUMY+gJxjMbqiJDnimPsKYrXXws+WlBf3yrzzqTtnspDr6CfoNNS9KkMc6d1I1B5hDMQYwZ7HWXYPbas6M/b5R8wX7RYN6R5rJ3lT/S8g/9F4KezHyhdE0S1JznCVr5JtDr3Q8pBMf9nMsVS+i3UCbsLH/epTnjvKvU3kq1FzAOSRGG3eQC6r6DWZPO9YixgL52BSP0WeQ6dilLvzHN0t291SPLyuBbxb8LaeHDTwp8v7bx5EiTS8jL6/PefM+AEtXZM1xeiD9GqWOeSGOzZ+05DaexYfk50sLNtNj63H8fNSpuz/efP8A'),
			this.addDataEntry('inspect highlight', 28, 28, 'Inspect Highlight', 'jVZbk6I4FP41vuzDFgLOjI8KinFI0Bak8Y1bRzCIJSCQX78nAbt7Zre3psoU5Ny/75wYJppRdNY9vJ1xmaRsoq0mmnEvy3p4KzojZWyiKlky0cyJqiqwJur6C+1UapVbeE+v9Z84qIPDI2RNOkgGQVX3bBRU5/AmXrMipPBcPtJ7ncUhs8MoZbuyyuqsvII+Kuu6LMCACcUyjC/0XjbXxChZeQd9kr6FDas/RViwjArPuryBNKxuaSyKfsu6FMpbyoSLp1QBSZpkdRix1Kiql4alFYj//utpKVKEdTjRFsNWXVcPOlGXXQGAjd2GqKd+qUd+18T8pkcWa0KuZOHmRYnN8mFriZb0Mw33s0dcxA/sXmbOYT7Y9Yim1rSKrniOirOSbBbf7H4OHnGTcNxE2vZqc9Ric/GItdMVZUs19I/avpjruwPq7fyiYxNxnCPumLHquB7H7pbZLqW2ixrHpS3OcQ9LJzyYERd3uPBqx1j0RC5Ek+LYxyp7RLmS4YPeQY7byVQy11rPTq/bN3wAG5VdEovOUY4U0Jcnn13DzX7Y53qBtPPZ6RcUuFBSv2No8zKLLW+Ori8s3ewfgUb4u1172dpXouBNzRNr3to+eUTWvHcy3GKLsMDH398OQZ5aq+/G/tLE2r5LNaJE2qIO1HkVaegb4gvNMbF+yuv5NiN64FZbZCx+2NqQf5cN/kJ2so5FzD9qFDLB/clf9y/a9nyyGIuuexr6gOeyytCGdsBtCzhn2AVOgKPURE/sMyx4yvcZspI+8F9uJ3+mHP3ZLdlAD69HDpy5sbXOT968Ob4S9pkfyE2R2UncyCJV8Er47rDlibnIbP6V3bw4XQlLTNEfRAO1O8eayAUcHtDjE1bwaR//gQ1mdWRJWvzOyG6zPEN36algVQRZktdt9dMgy5+QTU6Cu28Ip5WYDqLi1j7onBh6hw9KQ3LcYI5rO6eKnaMp6Hqc6VMCOpA3jnkBHeahuVLtPNaDXvi2rW3oKu5FDF2HWBzeezL4csfQp+Cji5hJLvwoD/iiApkC8TuwUXEm4lOIv4f44iTAOkg/bj9jKlQNemG3r7AhahW2q07onaG+evTrh3hi79XvMdZBB/aaf1E08bRHDIAFsOLZMUfgwxABHEQLOpHTOd4IdnFDXK8iGcSwRMy9yKlIvmCNNeu2uwJ/WK7gyAOfAJ7xFPKADMn30IRY+TqHfJ1tCg48XWLIqeQXgx+WdVCILbnTySbgdh50A2eeKvCBbkYEB9yTfRR4iRkLX8hzETj7sR5ZWwS2jivqvCi26L/AA30hvuRsOvZ6Cn2DnBIT+J4Fb1PJrayfin5JPdQnMPLnXtpLG28mey34tlrg1ZuO+Ybcou41cCrm4tD2ULuKfdpjwbWPx962wxxC/UMdX/EiageceTDWBXPg4/+bn07I/3SGyPveE9zATAuczMdivorfzw3617mBOsdzQ5/nRo/78ZxkQ02OhQdcg7/EBnrR84GTY/nxT8JbeWvsqLhvxW85XspwTabdlxe7FI23upWWRVrfezBps6Q+j5f7j8HrnGb0XP8qC6thT989P74S4GX8UHhuPz5IpO6X75V/AA=='),
			this.addDataEntry('inspect non', 28, 28, 'Inspect Non-SAP', 'jVZbl6I4EP41vuzDHgScGR8VFGOTqC1K4xu3jmAQj4BAfv1WAXbPzG7vmXM6x6Sqvrp8Vekw0oysse7+7UzzKBYjbTHSjHuel/0ua4xYiJGqJNFIM0eqqsAaqcsvtONOq9z8e3wt/wSg9oCHL6q4l/SComzFICjO/g23SeZz+J0/4nuZhL6w/SAW27xIyiS/gj7IyzLPwECgYu6HF37Pq2tk5CK/gz6K3/1KlD95mImEI7LMbyD1i1scYtLvSRNDevMu4OwpVUASR0npByI2iuK1EnEB4r//elpiCL/0R9qsP6rL4sFH6rzJoGBju2LqqZ3rgdtUobzpgSUqXyqJv3pVQjN/2FqkRe1Eo+3kEWbhgzqXyWY/7e1awmNrXARXOiXZWYlWs292OwVEWEWSVoG2vtqS1NScPULtdCXJXPXdo7bLpvp2T1o7vejUJJKmRG7MUN04B0mdtbAdzm2HVBuH1zSlLSydSW/CHNrQ7FBujFnLukV4lB3bUBWPIFUSutcbiHE7mUriWMvJ6W39Tvdgo4pLZPEpSYkC+vzkiqu/2vXnVM+Idj5v2hkHLpTYbQRZvU5C6zAl11cRr3YPT2MS7KpQ29VkVfBQe32ExjgN1OYRpjkPsyh5MS+Nbcwa6hwKYi7kZn/5TlYKt69Mofs57JkSaLPSU6dFoJFvZLW+egmXzKg51AWYsH1xCv6+n/2wtT6PbeKlsbX4TozZj5N1zEL5mSvKsAcnd9m+auvzyRIiuO6470Jdl0VCVrwBjmuod0Id4Aa4ik3y5GBCka90lxAraj339XZyJ8rRndyiFfTyepTAnRNay/R0mFbHNyZ+5glic2I2MrKmNbFY4b0xud2vZWTOElt+ZTfNTlcmIhP7RLinNudQw1jID3n8VCtg6sd/1AYzu06Y7gFLaPE7I9vV/Axd5qdMFAFEid7WxYvB5i8QrZsIZ1cxyQucEqbS2t7rwL7e0L1SsZRWVNLSTrlip2QMupYm+piBDuTVxryAjkrfXKh2Gupei9i6tg1dpS360HXwJWHfsh4rN4Y+BoyOPqMUcVx6claATAH/DdioNEH/HPzvwD/eCFj7Diftp0+Fq16LdruCGpgr2i4a1G/6/MoB1/b+8HwoP3wsvQbsNfeiaPhrDzVALVArnRxTAhhBGNTBNK/BmJvjjVGHVgymmSXgw0KfO4ypdHzBGnLWbWcBeFgOcnQAjAe/4RjigIx0e98EX+kyhXiNbSIHB72rIeUdvxRwtMuDg++OO52tPGmnXtNzdlCxPtBNGHIgD10fsV5mhoiFOBessx3y6XILwHbjYJ4Xxcb+Yz3QF+Z2nI2HXo+hbxCzqwmwZ+Rt3HHb5c+xX50e8sMa5fPc2Xc2h0nXa+TbqoHXw3iI18fGvJfAKc7Fvm4hd5W6vKXItUuH3tb9HEL+fR5f8YK5Q52pN+QFc+DS/5ufBuV/OkPs43xAbmCmsU7hUpyv7Pd7Q/51byDP4d7w573Rw3a4J0mf08aifV09vqsN9NjznpNj/vmfRNbd67Hl+O7i33x4nOG5jJsvH/hONLzuVpxncXlvwaROovI8PPI/etQ5Tvi5/FXmF/2ZfyA/vxZgM3wwPI+fHyad7pfvln8A'),
			this.addDataEntry('inspect', 28, 28, 'Inspect SAP', 'jVZbl6I4EP41vuzDHgScGR8VFGOTqC1K4xu3jmAQj4BAfv1WAXbPzG7vmXM6x6Sqvrp8Vekw0oysse7+7UzzKBYjbTHSjHuel/0ua4xYiJGqJNFIM0eqqsAaqcsvtONOq9z8e3wt/wSg9oCHL6q4l/SComzFICjO/g23SeZz+J0/4nuZhL6w/SAW27xIyiS/gj7IyzLPwECgYu6HF37Pq2tk5CK/gz6K3/1KlD95mImEI7LMbyD1i1scYtLvSRNDevMu4OwpVUASR0npByI2iuK1EnEB4r//elpiCL/0R9qsP6rL4sFH6rzJoGBju2LqqZ3rgdtUobzpgSUqXyqJv3pVQjN/2FqkRe1Eo+3kEWbhgzqXyWY/7e1awmNrXARXOiXZWYlWs292OwVEWEWSVoG2vtqS1NScPULtdCXJXPXdo7bLpvp2T1o7vejUJJKmRG7MUN04B0mdtbAdzm2HVBuH1zSlLSydSW/CHNrQ7FBujFnLukV4lB3bUBWPIFUSutcbiHE7mUriWMvJ6W39Tvdgo4pLZPEpSYkC+vzkiqu/2vXnVM+Idj5v2hkHLpTYbQRZvU5C6zAl11cRr3YPT2MS7KpQ29VkVfBQe32ExjgN1OYRpjkPsyh5MenYNmYNMy8FMcmY7S/fyUrh9pUpdD+HPVMCbVZ66rQINPKNrNZXL+E1YHTW1pymi/rFKfj7fvbD1vo8tomXxtbiOzFmP07WMQvlZ64owx6c3GX7qq3PJ0uI4Lrjvgt1XRYJWfEGOK6h3gl1gBvgKjbJk4MJRb7SXUKsqPXc19vJnShHd3KLVtDL61ECd05oLdPTYVod35j4mSeIzYnZyMia1sRihffG5Ha/lpE5S2z5ld00O12ZiEzsE+Ge2pxDDWMhP+TxU62AqR//URvM7DphugcsocXvjGxX8zN0mZ8yUQQQJXpbFy8Gm79AtG4inF3FJC9wSphKa3uvS2boDd0rFUtpRSUt7ZQrdkrGoGtpokMXFZRXG/MCOip9c6Haaah7LWJr6J6u0hZ96Dr4krBvWY+VG0MfA0ZHn1GKOC49OStApoD/BmxUmqB/Dv534B9vBKx9h5P206fCVa9Fu11BDcwVbRcN6jd9fuWAa3t/eD6UHz6WXgP2mntRNPy1hxqgFqiVTo4pAYwgDOpgmtdgzM3xxqhDK+YcCpaADwt97jCm0vEFa8hZt50F4GE5yNEBMB78hmOIAzLS7X0TfKXLFOI1tokcHPSuhpR3/FLA0S4PDr477nS28qSdek3P2UHF+kA3YciBPHR9xHqZGSIW4lywznbIp8stANuNg3leFBv7j/VAX5jbcTYeej2GvkHMribAnpG3ccdtlz/HfnV6yA9rlM9zZ9/ZHCZdr5FvqwZeD+MhXh8b814CpzgX+7qF3FXq8pYi1y4delv3cwj593l8xQvmDnWm3pAXzIFL/29+GpT/6Qyxj/MBuYGZxjqFS3G+st/vDfnXvYE8h3vDn/dGD9vhniR9ThuL9nX1+K420GPPe06O+ed/Ell3r8eW47uLf/PhcYbnMm6+fOA70fC6W3GexeW9BZM6icrz8Mj/6FHnOOHn8leZX/Rn/oH8/FqAzfDB8Dx+fph0ul++W/4B'),
			this.addDataEntry('key highlight', 28, 28, 'Key Highlight', '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'),
			this.addDataEntry('key non', 28, 28, 'Key Non-SAP', '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'),
			this.addDataEntry('key', 28, 28, 'Key SAP', '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'),
			this.addDataEntry('link highlight', 28, 28, 'Link Highlight', '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'),
			this.addDataEntry('link non', 28, 28, 'Link Non-SAP', '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'),
			this.addDataEntry('link', 28, 28, 'Link SAP', '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'),
			this.addDataEntry('locked highlight', 22, 28, 'Locked Highlight', 'jVZdk6o4EP01vuzDVgyw984jAoOxTNCBUeENgRtBFGsE+fj12x1wZm7Vbu0+WCFJp/v06dMxM826dO5HfDvxKs3KmebMNOujqurx69JZWVnOKMnTmWbPKCXwm9HXf9mdq11yiz+ya/1/DtDxwCMum2xcGRfudV9OC/dTfMPP/BJLGBdZmtfxscys+/2tKbM7bP35B6w/so86T+JyHR+zclPd8zqvrrB5rOq6uoBBiRuLODnLj6q5plZVVh+wn2a/4qasv3kwy1ziybq6wWp8v2UJJvMr7zKAvVBAzOcqea6gq7iOZ5o5Tunr/SFndNFdIGFrsxQ06hf6cd81yUDyePlGErt6rLVUS3tD473xSC7Jgxdmy62XIb0kOVtGt+iQWkdNvrCctOviXa4DsxG+2fNcJxxGz2Iydne3iJ7IxmdqntLynLpwpmD9uth2rNAvTDudvPYsmd0N6bK8R/6CZIdFufFXJDqcyJqKIekZ4F3lQg+D+8ryjSG1Fz8S7e2RWPPiSLtHUlQFtxdFtH8tPI08va7WV0H4oR5S96Vd78Xj6L70Xs5bMcjBc8Mfv/ywyFznh+WbcoPZIYLgE9XPyN1dkuFzvtq43e142Z2Sc9qH+7dbtDcIc7++d3vjli75C7vuhuiwChL3tYjeX5rdQZQsXxi8IDkw2YjgrMNcH+cM5g5V+wHMe52IYQssyw6Y64DdgefA5n77ws5OvsknzFvAsxTkqJkypN0p0TAu5Guxx3/a+EweaXRJ6A6r07H853eGgxaYKhtgs3/TVqfILcvjdfvNArg6R/to+IwTdG14eKuYG92Obov590dLFlv/nDMXcZNO9Dr1AkdyVEqR6OHgNMAFZbYpQTU9t8+NsAGLzRtuO4TZuB9C/rIFTnRuc8l9tHvHUfNs+TXPdUNcQ31dcJ3veTueNenaBzXazug/cOpP+15veRAFPJCNZ0MtbKahinmQALZzN853DOw0HpTFOlD+5oC1nrDWoGDARYZ1YXY8J4CTtaLktfJTbCEXqUN8OMPAhun8ENaepQ+eLQpuob1DPYWPo89OBMmUT1irfHKVM/iThOem4kGMcSh02Pe4lO9CCnE74fIWYhqe/d5Abj3ihvwM2COeT6DrkgFiDqJ4R78a1EQHLSIvlBeKV9CeVDkKOwpgv/WQE1WPpPECDryY4MsEn6HBfYJd33FLp3gOOBvAh+4FZxUfcm9Ay52Kv+eAJYHznOIZON8LX8WXY7ytiu8tOXLTjTacehaOWx04APyMQI4NH8L5yIs+F7biTRMBhz7aas+Y2YXUHOsWJFDfRTVxvwde5zx4m2oANcMcbPAdMKyx8az1OlA67JOeKO69yR5Gxb14zl2O/HWgGwk+AaMzB96edYU6mk9tjDWywHcBd5BvPudq5Ncb4AXshTkwewsYVifUw8gDm6s+scxWaVpxfdYFRX04A6x1vMA1pgMuOMtQewT4wDVDLNGOz7FeoF0NdckHXDMNH/pNDI4R9gTquzWUxjGG0vA7RT6gL8d+HJIuLSSMsgsHUwIGyGUL/xKqRhNWGK1p3MsOesgQoLixX8yWWdBTg4O44V8BtZrUqm9BA3A/IN65yJ85htj76hswtcJ+/evoE+jzLeh4jMEvqCvkzBz1W2D9EoUXtAu1kv2okzPes2DLepVLgPcF7qGfs8ap06OmlX5ULU28R+rfbVR/d5PunnVXPlWvfcYDTQ2h/sUl9hvTQGujH+QaOA2DKVYOd6OP8TAH8t0f8lyr3kctDO/1mCP7LeY/+zG/x+qz/Ot/YTP+k8ONDq+E6akDj4ys+9fnklqa3kpuVl2y+qMHkzZP69P0ZJqeSKcsl6fpFP05rsX3cS4/T369veBjen49p1/PPLX32yvwbw=='),
			this.addDataEntry('locked non', 22, 28, 'Locked Non-SAP', 'jVZdk6o4EP01vuzDVgxw9/qIwGAsAzqiDrwhsDGAYo0wfPz67Q44M7dqb+0+WCEf3X369OmYmWZdO/c9vl94lWblTHNmmvVeVfX4de2srCxnlMh0ptkzSgn8ZvTlN7tztUvu8Xt2q/+PAR0NPuKyycaVceFR9+W08LjEd/yU11jAuMxSWcfnMrMej9emzB6w9ecfsP6RvdcyictNfM7KbfWQtaxusHmu6rq6woESN5ZxUoj3qrmlVlVW77CfZn/HTVl/82CWUqBlXd1hNX7cswST+Vt2GcBeKiDmc5U8V9BVXMczzRyn9OXxIWZ02V0hYWu78mjUL/XzqWuSgch49UoSu/rYaKmW9obGe+MjuSYfPDdbbi2G9JpItoru0VtqnTWxYJK0m/wgNoHZeHuz51InHEbfYiJ2j/eIXsh2z9Q8pWWRumCTs36T7zqW61emXS5+Wwhmd0O6Kh/Rfkmyt2W53a9J9HYhG+oNSc8A7+bmEW4t/2Irj5w1sw7p4nHW2A+2Wt9CKQy+bwUPnPnGMjs+FHe/Xy6YZQyp7YisXw6pu2g3J+/j7C56Xy77iLKKD7sHsw8D2GhcFuCbiC1miUiCT3Q/I/d4TYbP+Xrrdvfz9XhJirQPT6/36GQQ5n59H0/GPV3xBbsdh+htHSTuSx4dFs3xzSuZXBo8JxIYbbyg0GGuj3MGc4eq/QDmvU68YQdsiw4Y7IDlgUtg9bRbsMKRWxnmmev8Ze0Az8iJCGl3STSMi1yxj/88s2fiTKNrQo9YpY7Jn8D0Wnp6GDzWVtACW2UTnV76V219idyyPN92304AV0V0iobPOEHXhm+vFXOj+9ltMf/+bIl8ty8kcxE36bxep37gQK0g/zzRw8FpgAvKbFOAenpuF41nAxabN9x2CLNxP4T8RQuc6Nzmgu/x3AFHzbfF11zqhncL9U3OdX7i7Whr0s0eVAk6UP4Dp/483+stD6KAB6LxbaiFzTRUMw8SwFZ04/zI4JzGgzLfBMrfHLDWE9YalAy4yLDJQXeSAE7WeiWvlZ98B7kIHeKDDYMzTOdvYe1b+uDbXs4tPO9QX+Hj6LPzgmTKJ6xVPlLlDP4E4dJUPHhjHAqd9j0u5ceQQtzOc3kLMQ3fPjSQW4+4IT8D9oi/J9B9yQAxBy8/oF8NaqKDFpEXynPFK2hPqBw9Owpgv/WRE1WPpPEDDryY4MsEnyH0HsHu77ilU7QDzgbwoftBoeJD7g1ouVPxTxywJGDPKdqAfe/tVXwxxtup+P6KIzfdeIZT38JxpwMHgJ8RyLHhQzgfedHnnq1407yAQx/ttGfM7EpqjnULEqjvspq4PwGvcx68TjWAmmEONvgOGNbYeNZ6Eygd9klPFPf+dB5Gxb33nLsc+etANwJ8AkZnDrw96wp1NJ/aGGtkge+cQ1zzOVcjv90BL2DPzYHZO8CwvqAeRh7YXPWJZbZK04rrQvco6sMZYK3jOa4xHXCBLUPtEeAD1wxvhef4HOsF2tVQl3zANdPYQ795g2OEPYH67gylcYyhNHygyAf05diPQ9KluYBRdOFgCsAAuezg30LVaMIKozWNJ9FBDxkeKG7sF7NlFvTU4CBu+HdArSa16lvQANwPiHfuyWeOIfa++gZMrWe//DjvCfT5DnQ8xuBX1BVyZo76zbF+icIL2oVaiX7USYH3LJxlvcolwPsC99BPoXHq9KhppR9VSxPvkfrXM6q/u0l3z7orn6rXPuOBpoZQ/+IS+41poLXRD3INnIbBFEvC3bjHeJgD+e4Pea5V76MWhkM95sh+ifnvfszvsfpMfv0vbMd/dLjR4bUwPXngsZF1v302qaXpzeRm1TWr33s40sq0vkxPp+mpdMmkuExW9Oe4Fj/Gufi0/HqDwcf0DHtOv557au+X1+A/'),
			this.addDataEntry('locked', 22, 28, 'Locked SAP', 'jVZdk6o4EP01vuzDVgxw9/qI4GAsE3REHXhDYGMQxRph+Pj12x1wZm7V3tp9sEKSTvfp06djJoZzbb33+H7mZZoVE2MxMZz3sqyGr2vrZEUxoUSlE8OdUErgN6Evv9md6l1yj9+zW/V/DtDhwEdc1NmwMiw8qq4YFx7n+I6f6hpLGOdZqqr4VGTO4/FaF9kDtv78A9Y/svdKJXGxjk9ZsSkfqlLlDTZPZVWVVzAocGMeJxf5Xta31CmL8h320+zvuC6qbx7sQkk8WZV3WI0f9yzBZP5WbQaw5xqI/VwlzxV0FVfxxLCHKX15fMgJnbdXSNjZLAWNurl5OrZ10hMVL19J4pYfayM10s4yeGd9JNfkg+d2w51Zn14TxZbRPXpLnZMhZ0yRZp3v5Tqwa7GzO65MwmH0HSZj73CP6JlsdkzPU1pcUg/O5Kxb59uW5eaVGeez31wkc9s+XRaPaDcn2du82OxWJHo7kzUVfdIxwLu+CcKd+V9sKcjJsKuQzh4ng/1gy9UtVLIXu0byYGutHbsTwf7ud/MZc6w+dRcy6+Z96s2a9VF8nLxZ56t5F1FWcqeRvps8mMta7lzAN5EbzBKRBJ/ofkbe4Zr0n/PVxmvvp+vhnFzSLjy+3qOjRZj39X04Wvd0yWfsduijt1WQeC95tJ/VhzdRMDW3eE4UMFqL4GLC3BzmDOYLqvcDmHcmEf0W2JYtMNgCyz1XwOpxO2OXhdqoMM+8xV/OFvAMnMiQtufEwLjIFfv4T5sdkycaXRN6wCq1TP0EpldKmGHwWDlBA2wVdXR86V6N1TnyiuJ0236zAK4u0THqP+MEbRO+vZbMi+4nr8H8u5Mj8+3uopiHuEkrOpP6wQJqBfnniRn2ixq4oMy1Jain4+6lFlAP5vKauwvCXNwPIX/ZACcmd7nkO7Tb42j4rvyaK9MSt9Bc59zkR94MZ2263oEqQQfaf7CoPu07s+FBFPBA1r4LtXCZgWrmQQLYLu0wPzCwM3hQ5OtA+5sC1mrEWoGSARfp17ndckUAJ2tEwSvtJ99CLtKE+HCGgQ0z+VtY+Y7Z+67IuYP2C+prfBx9tiJIxnzCSuejdM7gTxKubM2DGOJQ6LTvcSk/hBTitsLjDcS0fHdfQ24d4ob8LNgj/o5A9yU9xOxFvke/BtTEBC0iL5TnmlfQntQ5CjcKYL/xkRNdj6T2Aw682ODLBp+hxXcEux96yKR4DjjrwYfpBxcdH3KvQcutjn/kgCWB85ziGTjfiZ2OL4d4Wx3fX3Lkph1sOPUdHLcmcAD4GYEca96H04EXcypczZshAg59tDWeMbMrqTjWLUigvvNy5P4IvE558DrWAGqGObjgO2BYY+tZ63WgddglHdHc+6M9jJp78Zx7HPlrQTcSfALGxRR4e9YV6mg/tTHUyAHfOYe49nOuR367A17Ants9c7eAYXVGPQw8sKnuE8dutKY11xdTUNTHooe1lue4xkzABWcZao8AH7hmiSXa8SnWC7RroC55j2u2tYN+E/3CCjsC9d1aWuMYQ2t4T5EP6MuhH/ukTXMJo2zD3paAAXLZwr+FrtGIFUZnHI+yhR6yBChu6Be7YQ70VL9A3PDvgFpNKt23oAG4HxDvVKhnjiH2vv4GTI1wX36cdgT6fAs6HmLwK+oKObMH/eZYv0TjBe1CrWQ36OSC9yzYsk7nEuB9gXvo52JwuuhQ01o/upY23iPVrza6v9tRd8+6a5+61z7jgab60PziEvuNGaC1wQ9yDZyGwRhLwd24w3iYA/nuD3mudO+jFvp9NeTIfon5737s77G6TH39L2yGf3S40eG1MD554LGRtb99Numl8c3kZeU1q947MGlUWp3Hp9P4VDpnSp7HU/TnsBY/hrn8PPn1BoOP8Rn2nH499/TeL6/BfwA='),
			this.addDataEntry('machine highlight', 28, 27, 'Machine SAP', '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'),
			this.addDataEntry('machine non', 28, 27, 'Machine Non-SAP', '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'),
			this.addDataEntry('machine', 28, 27, 'Machine SAP', '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'),
			this.addDataEntry('message highlight', 28, 21, 'Message Highlight', 'jVXJkqM4EP0aX+YwIbNMlY8YKEoOJGwjL3Bja4EMhcMGs3x9p8BV1T0RHTMHQsr95UsJLVSz6p1bdM1JnWblQrUXqnmr62beVb2ZleVCQUW6UK2FoiD4FsrbH6zLyYqu0S37aP5PgDIHPKKyzWbNrLg3Q/lU3PPoKrdFFXFY11laNFFcZub9vm/L7A6mv/8C/SO7NUUSlW4UZ+W2vhdNUX+AMa6bpq7AoZSGdZRc+K1uP1KzLusb2NPsR9SWzS8ZjLLgMrKpr6CN7tcskc38KPoMYK8nIManFn1qZKqoiRaqMYvK2/3BF8q6r6Bhc/tOlXBYa/Gpb5MRFdH7HiVW/XDVVE0HXSWD/kiq5EGE0RFzNaZVUuD38BqeUzNW+QoXqHPFgbvMaKlvDJ5pDMTHPHKO11DJ0dbHk5wq5SV1wF9gDQutwmqee92FY6sf0/fyHvprlJ3X5dbfoPCcI1ehYzJgwLkpqBaw+8b09TG11i+Jun8k5lLESv9IRC2ItRbh6U14KvrMunE/KCLnZkydVeee6CN2VoNXkI6OfPSc4OWHH4jMsV9M3+Bb2ZVEwL5QvYbOsUrGL3mzdfprXB3z5JIOwWl/DU86ws73/njSr+k7WeGP4xieNyxx3kR4WLXHMy1xsdaJQAURpCUj1kHWJpklICfLyc5ALjTkWTawy3vJmiuM0ZNMnnYrfLGLbfHEvAM87xTFqsEDpc8TVdaFfk38+E8fyBcrYZUoRzmZHhevvzLMOmCqbIHNYa9u8tApy/hj94sHcHUJT+H4VYf1XXDe19gJr7HTyf6H2ORi518K7EjcaCCDNnjWpXHFURBfG4hFOIFT4grcUeiZsAsHn45YnEs7Zbz1LGnnHSmMXvqRQa6JRr9lsF+WRA164G1Jx1xAzqcNtdQyemzhFk6t4jJbriO2gH/L0A4jRq7Y6ZB7IKa2BL8R4jTPn2Uf/Oho98GAPmt1Lnvm8gGvZTdPvM3cD2Wghzy2OudF8ib00Bv0XZ7AVyXszZp9cEvZDsG+82TfoAM/lUw1DxrkALuxnOyWzWVvso68YXMeW/L4D2MEOMLSPlJrL8B/pNLHhNqMj/LsUIlDHBRX2J136nRXBAPgAhmwVcCFOCzBhqisIS4g2+DD5Vx67wx4GNYlDjrOfLiyV1YSInayLqKMiqcdMBmq5J0wiPe1nkzzJvA3kDpDj+QKdy+rUO8Bh1RA7+wAukANBk2ncvbT/HbDxJ+VoIkLC+4Bm9ejOMi5KrGJNJi9AvMC/AfVc2yYpz1gawe1sMzTYTkj4J9KvoGDQJ6JMVCwZciZLQmTmKFPH8l+EXlyxaYzw3VszbVS4A440YhCOmxOOH/D9u81K77v4Hb+W8LtgT/x8zmBH3nW//FJmlTP98jJ6iprbgO4dEXa5M9n6XWOyrOC58+oz0zRfZb5V+T3+wab5xP3KX4/pZPtt5f2Jw=='),
			this.addDataEntry('message non', 28, 21, 'Message Non-SAP', 'jVXJkqM4EP0aX+YwIbN0t48YKCwHAruQF7ixtViNw4ABff2kwFXVPREdMwdC5P7ypZaVrNej9QjvGWmStFrJ5krWH03TLX/1qKdVtZJQnqxkYyVJCL6V9PYH63q2onv4SG/d/wmQloBnWPXpolkUbTdVL0WbhXfxm9chg3WbJnkXRlWqt+17X6UtmP7+C/TP9NHlcVjZYZRWh6bNu7y5gTFquq6pwaEShm0Yl+zR9LdEb6rmAfYk/Rn2VfdLBq3KmYjsmjtow/aexqKZn/mYAuztDET70KIPjUgVduFK1hZRemufbCVtxxoa1g87RwqmrRJdxj7mKA937yg2mqctJ3IyqTKZ1Gdcx09SaAPRNzyp4xzvgntwTfRIZhuco8EuTsymWu942uTq2kQ8zELrfA+kDB08PMuJVJWJBf4FVnCh1FjOMncoGTZGnuyqNvC2KL1uq4O3R8E1Q7bk8HjCgNO+OYjo2+9456BI1jpf2rSRjL/h3f7m50wl3sAINde2ro2El3d32m6wrvLEMFk6bXlibQb74jwjazO5+XYKJNwQfmyxceIQI5O8hNyIHUR3Agn9RPcjsM51zD/l/cEa71F9zuIymfzL+z24qAhbX//ni3pPdmSDb2ceXPc0tt6K4LTpz1enwvlWJQXKSUF6wrEKsjLLNAY5Xs92CnKuINcwgWU2CvbsQuOuYPRy3ODSzA+5X6SW+V0/Ap6FE+ZLYxbLoq7gCj//0wfyRVJQx9JZTGjE+Q9gep87ik/bvU4HYKvqg8vb9C7vs8Cqquh2/MUDuCqDS8A/69Bx8K/vDbaCe2QNov8p0llx9MocWwI3msikTK5RdnZxLoinTMQgjMBusQs8ONAzoSUDn4EYjAm7Q1nvGsLOBpJro/Ajk1hjxfmSwV6uieyPwNva4VkBOV821DuGNmID97B7JZuaYuXYAP4NTTlxjOziqELuiejKGvw4xCmut8ge+DncHP0JfdQabPrK5QFew+xeeLulH4eCHvKY8pIXiRMxQm/Qd3UBX5nQN2Pxwb1Djwj+B1f0DTrwk8lc86RADrBr69kO+1j0JuqIk7bkMQWP3yglwBEWdu4Y7wX4c0f46FCbMi72jiNwFCfJLszBvQyqXfgT4AIZsNXARXFagw05okZRgmyCDxNzGd0r4KFYFTgcvvBhi15pRUhxFHWRQ53iZQdMcJ6Ad0Ih3lNGMs+bwK0gdJoaipUzntZodIFDp4De6Ql0vuxPiuqI2c/zO04zf0aMZi4MOAd0Wc/FScxVinSkwOwlmBfgP8muZcI8zQkbR6iFRZ4BixkB/47gGzjwxZ7gvoQNTcxsTajADH16SPSLyIsrOu8ZpsIdMddKgDvgRCESGbA+4/wN27/XNP86g4fl1oTTAzfy61mBCz0d//g0zarXu2SlTZ12jwlchjzpstfz9GOJytKcZa+oj0xhu8jsM/LrnYOf11P3IX49qbPttxf3Hw=='),
			this.addDataEntry('message', 28, 21, 'Message SAP', 'jVXJkqM4EP0aX+YwIbN0t48YKCwHEnZZXuDG1gIMxmHAIL5+UuCq6p6IjpkDIeX+8qWEFqpZDc4jvGekTtJyodoL1XzUdTvvqsFMy3KhoDxZqNZCURB8C+XtD9blZEX38JHe2v8ToMwBz7Ds0lkzK5pWlC9Fk4V3uc2rkMO6TpO8DaMyNZvmvSvTBkx//wX6Z/po8zgs3TBKy13d5G1e38AY1W1bV+BQSsM6jK/8UXe3xKzL+gH2JP0ZdmX7SwajzLmMbOs7aMPmnsaymZ/5kALs9QTE+NCiD41MFbbhQjVmUXlrnnyhrIcKGjZ3G6oEYq1F56GLR5SHm3cUW/XTVRM1EbpKhP6Mq/hJCqMn5mpMqjjHm+AeXBIzUvkK56h3iyN3mdHRgyE80xDkgHnonO6BkqHdAU9yopTXxAH/Amu40CqsZpnXXzm2hjHZlE1wWKP0si53hy0KLhlyFTrGAgNO90YRMdff8YaiSDVaX1k1kYq/4c325ud8pIeeE7bXXahM2fHuifUKm/qYWDZPxXpMnFXvnukzclbCy9ciUHBNzJ57VtxgCw/EvEJuxHeyO4mEfaL7ETinKh4/5e3OGe5RdcriayL88/s9OOsIO1/701m/JxuywrfTGFy2LHbeiuC46k4XWuJ8rZMC5aQgHRmxDrI2ySwGOV5OdgZyriHPsoFlPkj23MIYPcnoeb/CVzvf5X6ROvZ3cw94Zk64rwxZrMq6kiv8/E8fyBcpQRUrJzmhAec/gOltTjWfNVuT9cBW2QXnN/GubrPAKcvotv/FA7i6Budg/KzDht6/vNfYCe6R08v+RWTyYn+45tiRuJEgQhOedW3d4lSQgyaIRTiBmbkF7in0TNiVg09PLM6lnTLeeZa0857kxiD9iJBrrNEvGezXJVH9AXhb0jErIOfLhjpqGQPMuIPTq7jMluuILeDfMrTjiJFb7HXILYipLcFvhDjNO8zyAfzoaA++QB+1epe9ch0Ar2W3L7zt3A9loIc8tjrnRfJGDNAb9F2ewVcl7M2afXBH2R7Bvvdk36ADP5VMNY8a5AC7sZzscI5lb7KOvGlzHlvy+I0xAhxhaR+p9V6A/0iljwm1GR/l2aESR3FU3MLuvXOvu4UvABfIgK0CLorjEmyIyhrFFWQbfLicy+BdAA/DusRBx5kPV/bKSkKKvayLKKPFyw6YDFXyThjEH7SBTPMm8FeQOkMP5TryMa3Q4AGHtIDe2RF0vuoLTady9tP89mLiz4rRxIUF94DN66k4yrkqkYk0mL0C8wL8R9VzbJinLbC1h1pY5umxnBHwTyXfwIEvz8ToK9gy5MyWhEnM0OcByX4ReXHFpjPDdWzNtRLgDjjRiEJ6bE44f8P27zXNv+7gbv5rwu2BP/LrWYEfejr88WmaVK93yUnrKm0fAlz6PGmz1/P0Y47K0pxnr6iPTGEzy/wz8uudg83rqfsQv57Uyfbbi/sP'),
			this.addDataEntry('mobile highlight', 21, 28, 'Mobile highlight', 'jVXJkqM4EP0aX+YwoWLpKh9ZbCwa4QXKCzeBKCEsDGEWA18/AuxydXRXTEfYYeV7Lx+ZKUcyk42sta64SFBOYj6TFzPZuOZ5NZ2y1og5n0mAkZlsziQJiO9MWn7DvowsKPA1vlR/kyBNCQ3mdTwhE1BWHb8DZYKL4cgyTMWvHhNW4ZDHRlnuah6Xgvr3H4E38bViEeYODmO+yUtWsfwiyDCvqjwTAj4QOo7O9JrXF2LkPL8KnsQfuObVFweNMzpkVnkhUFwWcTQ088HaWJStj4VoDxQ8kMEKV3gma1MoLcuGziS9zUTDxmblSkGnK+GhraMeMLzagcjMG0cmMulUGXVqE2VRg1Lthox5T7KIwVVQBEdihDKdQwZuTvpOHV+rXU/rkKEorqF1awNSbO2LQErAxoNjTCR+JpbISaHIoQCmSgblJFnfzhSabU9WvAw8HcRHnW88GwTHBDiS20cdFPXazFVOfmkbntoTU3+N5F0TGS9pKLVNlOYpMvU0OCzTtQwerrZzcQE6Vj2x5jfn4DahNe/WDN3cnvZr6/T64Z3S2Fq8Gp5GN0N3QwX+Z1VvgbXPov4ztjdWW4TZPonOpDsddkVwUAG0nuf9QS3ICs3hZd8HR9uPrGUavM/r/dHlkOkqSgFD/rlGPlRFrIxxCmtkLtSR90XcKcDtt2LKtBWTa50UDVwRmIBtvV8msT2/TVPQ09Ba9sP9RfL2Btnb/6ta4dkEWSDq3IobWTDna5/GvMQHlZ+O9irKlmd82NfEfM7FkXY8uKAvT9ms9ETcLQ0yXoaiUnK0y5+Gq//0IB0q931Uux2o3fcFcFJIXUPpoKlRZGg3x1NeoCl4+dSuPUU6+dsaMW3UDfygm/QCz2iLmJiQ9bvPyDMgcPsgpij/waca9M6AXwpX+PTjc6WFmPKWIk8Bd68WmovaNYDAd7nQSchMJMG/oDRJJt3AT7UN+kc+FjW4JgQnf+Qn/KETvDPgy1PnpO7D93c/7+lH0oXqpMEfNOBT433Tw/isqYcf4rYzfGhL52i/hNb7HGZ7Sfxjm8DaPm++vzWRHFw2dNhww0e/r0GxgOL221U6Qvc9asV5FlfXTkhujFTJfZ3es5KY0eSeJb1NGC6nmH5mPveyONxX8yN8vgJG7pc3xH8='),
			this.addDataEntry('mobile non', 21, 28, 'Mobile Non-SAP', 'jVXbkqJIEP0aX/Zho+Qy0z5CoVgMRavgjTduUxSCEHIR+PpJQNvemOnYidCw8pyTh8wsI5mJOGv1m1fENA+jdCYuZyK+5Xk1nbIWR2k6ExAPZ6I2EwQE35mw+oKdjywqvFt0rf4mQZgSGi+towmZgLLq0gdQxl4xHHnmMfhVo5BXnp9GuCx3dRqVQP37D+BNdKt44KWm50fpJi95xfMrkH5eVXkGgnQgVC+4sFteX0Ocp/kN+DD66dVp9clBSTkbMqu8ANQriygYmvnJ2wjKVsdClCeKnshg5VXeTFSmUFiVDZsJaptBw3iztgS3UyX/2NZBj7i33qFAyxtTDMWwk0XayU2QBQ1NlDvFiz7MAk7WbuGeQuyLbEE4upvJnpmOUlu20lEsSRZWundMmKcfCleI0cYmYxwK6SXUISchkMMQSaSMiHH8fr8worV9uE5L11ZRdFLTjW0g9xQjU7D6oCNQr3m1EMXqd7K2kC8q1VlYlL5IvpG1cT1zJlP7zqiznJtYaWl/Kd47dUGw3IfakkWd2of64m4ercbXF907VztXIDnttyXR9j3kiJRfwBuxzdDlUInzUd2bqx+yoP+IjY3eFn52iINL2J2Pu8I9yojor/PhKBfhmi7I9dC7J8MJ9FXi7hf14WSlhKsyTRCnzqWmDpEhlsY4ITXVlvLIOxB3ErL6LUybtTDB1kzowBWuhvjWHiZicEs6O6WBt5e3QNw1AVYTX1/1wz0G4vZO+Nv/q1rwbNzMhTq3cDNLbn7uEy9K7yin55OxDrLVxTse6lB7zcUUdql7pZ+eslmrMdwxc7O09KHS8GSUP7Cl/rAJGyp3HFpbHaqt/RKZCWEWljqiKYxi5W7a0pxowIvn9t2WhLOzrSlXRt3AD7pJD3jGWsphQvrvPiPPEeDGEaYo/sGnGvTmgF8LC3z68bnCEqa8ZdSW0MOrJdqytjACfJeDTqBaLAA/p0kcT7qBn2ob9M98D2qwNILOzshP+FMHvDngq3NnJtbT93c/++UXJkvZTNw/aNCHxv6ih/FZUw/f4LYz79iW5smY+/p+QbKDAP/YxtW3r5vv700gutcNGzbd8FEf6xAWUdR+uVJH6LFP9SjPourWgeTOwyp+rNVHVhxxFj+yhLcJ88opZh+Zr/0Mh8eKfoavV8HI/edN8Qs='),
			this.addDataEntry('mobil', 21, 28, 'Mobile SAP', 'jVXJkptIEP0aXeYwUc1it45QSKgwhRbQxo3NRSEQhFgEfL0TkFo9YXeMI1BQ+d7LrFwUyUzEWavfvCKmeRilM3ExE/Etz6vplLU4StOZgHg4E7WZICD4zYTlF+zbyKLCu0XX6m8chMmh8dI6mpAJKKsufQBl7BXDkWceg7cahbzy/DTCZbmr06gE6t9/AG+iW8UDLzU9P0o3eckrnl+B9POqyjMQpAOhesGF3fL6GuI8zW/Ah9FPr06rTxGUlLPBs8oLQL2yiIKhmJ+8jSBtdUxEeaLoiQyhvMqbicpkCsuyYTNBbTMoGG9WluB2quQf2zroEfdWOxRoeWOKoRh2skg7uQmyoKGJcqd43odZwMnKLdxTiH2RzQlHdzPZM9NRastWOoolycJKt8aEefqhcIUYbWwy2qGQXkIdfBICPgyRRMqIGMfr+4URre3DVVq6toqik5pubAO5pxiZgtUHHYF8zauFKFa/k5WFfFGpzsK89EXyjayM65mz3rLvjDpb2YTbLWdfrDt1TrDch9qCRZ3ah/r8bh6txtfn3ZqrnSuQnOI7W2tBSTTSUnyB2IhthiqHTJyP7N5d/ZAF/YdtbPS28LNDHFzC7nzcFe5RRkR/nQ9HuQhXdE6uh949GU6gLxN3P68PJyslXJVpgjh1LjV1iAy2NNoJqam2kEfeAbuTkNVvodushQ62ZkIHrnA1xLf20BGDW9LZKQ28vbwH4q4JsJr4+rIf5hiI2zvh7/+vaiFm42Yu5LmFySy4+blOPC+9o5yeT8YqyJYX73ioQ+3VF1PYpe6Vfrpls1JjmDFzs7T0IdPwZJQ/sKX+sAkbMnccWlsdqq39ApkJYRaWOqIpjGLlbtrSG9GAF8/t2paEs7OtKVdG3cAPukkPeMZayqFD+u9xRp4jwI0jdFH8Q5xq0JsDfi0siNOP9woL6PKWUVtCj1gt0Ra1hRHguxx0AtViAfg3msTxpBv4KbdB//T3IAdLI+jsjPyEP3XAmwO+PHdmYj3j/h7PfsULk4VsJu4fNOhDY39Rw3jXVMM3mHbmHdvSPBlvvr6fk+wgwD+2cfXta/L9vQlE97phw6YbHvWxDmERRe2XK3WEHvtUj/Isqm4dSO48rOLHWn14xRFn8cNLeJ8wr5xs9uH52s9weKzop/n6FIzcf74UvwA='),
			this.addDataEntry('on premise highlight', 26, 28, 'On-Premise Highlight', 'jVZLl6o4EP41bmYxBwn2bZcIiPGSKBrbhh2vG3mJR0Agv34qoN13FvfMLDxJpV5ffVUhzpBR9vY9uF1IFSfFDFkzZNyrqpl2ZW8kRTFTlTSeIXOmqgr8Zur6D9r5qFVuwT25Nv/HQZ0cHkHRJtPJdFA3Q/E8qC/BTW7TMuCwrpI4bYKwSIy6PrRFUoPq77/g/JHcmzQKCicIk2Jf1WmTVldQhlXTVCUYFFKxCqKc36v2GhtVUd1BHye/grZofougFymXnk11g9OgviWRLOZX2icAezUC0V+nyutEhgqaYIb0SVTX9YPP1FVfQsHGfkNVf1hp4blvI6GkweagRGb1cFCM4mGByLB4RGX0IJneEWMp4jJK8ca/+Z+xESK+xKnSOdmJO0xv6VEfaKp1O9PlJOMpti9FcI6r2FTSUd7EN39zqPZH/LJL96mXJbb1wzjqHLAoybkv8OawiOzTEl8PRbJxHx6iAmdaidHlsuvyrXOlCtk0IraXnXOmj9BeDruUdMSmhXcmP34dnzHdvI2Q2yeIKiHSG09d1iHCb1joaGcSzc+a5TalmsfqLTb0dwdN+b8wsT73z774kt38PbSL1j+vhwPaXny7KMKry/2v/eEjLAtF8hh/0iIqaOedacHUxUeknqD+fJC1k0FDO4ZB5i95oMyT+h5k4WQuogbmiWktcWa1O9Ob43R184FH94ihdy/UElGEDo/IWGWhvRYyM1Tc4fT9v616iPnwS1/4n67Mkzrim+O9sayD86LwPrebqFznwfmjjc0v/bujHgr/Sn7Lst+sLrHNuV8WdWhKBrb1T4Oufh4xl8gZw4qTWR01dE2upLRAzhE23XbHIk4MvcOmxclR66iJ5Ton4pA5GV7IPTXzlkLXwKYl7DQAS2Jn6L2T8T7OLFijgZ5JN+ozt3eOmkIyiJcCu9mpgRiwQtwB4me8AT/w1zTIJXXaFAur5KhAB6yBHJ/yiYPMB6pKvJYm8RLGX3ibV7wp/tqEvDDZkDc7SbwqyHNsytrdnqTKeEvAp6difSbMAhtX8YQu/cXOjEDOe4fhljJ9kLVQM9IcRloi3IFJDjIC/J0WNJd4TpwaMr4u8fRgP4w6Y8wDen0x4jXzb37Zacw52l1vjcNyiB1xOmgaET4mcJOJ+FCBG0QYrSA+4Dq8hQywCT44zJUYR8xyUsmgAB8ugjo1yvJm6osC3Fnz0FAAqzcHGUG+jpYE9B5wq8i6hMNkr7yxV1QQycFi5NbuGsivUnaSuObE9DOwGXaShywXY28FBy4i9NzLeekp26ojpwLPAR+fsGg9fH3gFunQR6LRsc/6gpZyZk5i5JiRJz/6NH9TzRX0CeLFqsMgl7DEVDPvxhsrXIlXkTMEc9bAnHUkA44YH3sOt1bGGqB2yB3BnGPoAxcjTyJ+8XoBP5WmOvTNU7/7KG0xcMYRVQnEdBeAVRl7lI13Y4AZh7h4eNnG2YQxMME+s5A3PHkxdNk3BfJKHp71Qc/kWWYp4565wA2eU9lLIeeKCNlXmEERwawCp1A3WYz3V84wy0WS4sfry7ifXgb4GsCr83w64dFK+j8+v+PR8+21k6pMmvsAJl0aN5fnE/w2eV2SlF+eXur7dBbUk8y/PL/fctg8n/OX+P23YdT961/FPw=='),
			this.addDataEntry('on premise non', 26, 28, 'On-Premise Non-SAP', 'jVZLl6o4EP41bmYxBwHv7V4ioMYmsdHYNux43ZgA4hEQyK+fCmj3ncU9MwtPUqnXV19ViDPDLvv1LbqecZVmxcxwZ4Z9q6pm2pW9nRXFTNd4OjOcma5r8Jvpqz9o56NWu0a37NL8Hwd9crhHRZtNJ9NB3QzF46A+R1e15WXEYF1mKW+iuMjsut63RVaD6u+/4Pye3RqeRIUXxVnxXtW84dUFlHHVNFUJBoVSLKMkZ7eqvaR2VVQ30KfZr6gtmt8iWAVnyrOprnAa1dcsUcX84n0GsJcjEOt5qj1PVKioiWaGNYn6qr6zmb7sSyjYft8QPRyWZnzq20RqPNrstcSp7p6RGumwMPCwuCdlcsfC6rD9KtMy4WgTXsPP1I4N9oq41nniyDxqteRgDYSb3c7xGRaMo/W5iE5plToaH+VNeg03++r9gJ52/J0HIlu7P+2DxQCLlp36Am32i2R9fEWXfZFt/HtgEImE2SaG36FNzRJjf0/suYj1/p6IiiVlyt+cvPdsq8f0WCPHlbtD/hNtNOZdiIYPS9gTLTasJtBf69hAP9Bmewk4k8TuGKEYfJLhjdbs18F68YwJxxc22ufhKZRfsp+/xOuiDU+rYW9sz+G6KOKLz8Kv/f4jLgtN8Zl+kiIpSBecSEH1xUeiH4GHfFAc4ME0dhSBzJ7yQGig9D3I0hO+QWzEMsd9RcJtd04wR3x5DYFP/4Cgh1tOzIDWW4VoYmUp4vVKqswjW/zlv616iHkPy1CGn77Kwz1plsg4n3ddvn23X+votCiCz+0mKVd5dPpoU+dL/+Lp+yK84N+yvG+W53TNWFgWdewoBrb1m02WbwfEFHJKkeYJtyO2ZaoVly7IuYEcv93RhGHb6qCDDB/MjjhIrXMs98ITaKH2xMlb4mATbFro9gAsyR103hOsT4ULazKQE+5GvfB772BqWEA8DuyKYwMxYIW4A8QXrAE/8DdNyKV05hQL6figQQfcAR8e8pGBzAaiK7yuqfBiyp54m2e8Kf7Kgbww4ZBXHBVeHeQ5clTtfo+5Nt4W8OmJXJ0wdcHG1wJpKX+5cxKQYaIpagm1BlULcRLTo7jF0h+o4kBg4O+4ILnCc2TEVvEthacH+2HU2WMe0FuLEa+Tf/NLj2PO0e5ybTyaQ+yEkcE0sQwRhhuN5YcO3BiYkgriA679j5gCNskGj/oK44hZTSoeNODDN6BOk9C8mfqiAXfuPLY1wBrMQTYgX0dKDPoAuNVUXdKjqlfB2CsiseJgMXK77hrIrxN6VLjm2AkF2Aw7xYPI5dhbyYCLxHjs1bz0hG71kVOJ5oCPTVjMHr5CcIss6CM2ydhna0FKNTNHOXJM8YMfa5q/qeYK+gTxUt2jkEu6cqqZdeONlb7Cq6kZgjlrYM46LIAjysaew61VsQaoHXInMOcI+sDkyJNMn7yewU8n3IK+Bfp3H5UtAs6YQXQMMf0FYNXGHonxbgww4xAXDU/bVEwYIwfshWsEw4MX21J90yCv4uFRH/RMnQlXG/fUB27QnKheSjVXWKq+wgzKBGYVOIW68WK8v2qGaS4zju7PL+P79ELA1wBen8cTCo9X1v/xGR6PHm/wOqvKrLkNYNLxtDk/nuIfk9c54+z88NJfprOonmT25fn9psPm8aw/xe+/D6PuX/8u/gE='),
			this.addDataEntry('on premise', 26, 28, 'On-Premise SAP', 'jVZLl6I4FP41bmYxBwG7q5YIqLFILDSWBTteHcNDPAIC+fVzE7SqZ9FnZuFJ7vvLd2+IM8OuhvUtup5xnWblzHBnhn2r63baVYOdleVM13g6M5yZrmvwm+mrP1jnyqpdo1t2af9PgD4F3KOyyybNpGjasXwomnN0lVteRQzWZZbyNorLzG6afVdmDZj+/gv09+zW8iQqvSjOyve64S2vL2CM67atK3AopWEZJQW71d0lteuyvoE9zX5FXdn+lsEqOZORbX0FbdRcs0Qe5hcfMoC9VECsp1Z7amSqqI1mhjWJ+qq5s5m+HCo4sP2+IXo4Ls34NHSJ0Hi02WuJU989IzXScWHgcXFPquSOc6vH9qtIq4SjTXgNP1M7Ntgr4lrv5UfmUasjB2sk3Ox3js9wzjhan8volNapo3Elb9JruNnX7wf09OPvPMiztfvTPlgMsGjZaSjRZr9I1sdXdNmX2ca/BwYRKDe7xPB7tGlYYuzviT3PY324J3nNkirlbw6ee7Y1EKdokIPm5FD8RBuNeRei4cMS9kSLDasN9NcmNtAPtNleAs56iDHJ2ANet3+jDft1sF48Y8LxhY0ORXgKxZfsFy/xuuzC02rcG9tzuC7L+OKz8Gu//4irUpN8pp+kTErSBydSUn3xkehH4KEYJQd4NI0dRSCzpzwSGkj7ALLwct8gNmKZ476i3O12TjBHfHkNgU//gKCHW07MgDZbiWhiZZnH65WQlRVb/OW/vQbIeQ+rUISfvqzDPWFWyDifd32xfbdfm+i0KIPP7SapVkV0+uhS58v+4un7Mrzg36q8b5bndM1YWJVN7EgGts2bTZZvB8QkckqR5gHbBJiXK65ckAsDOX63ownDttUjx2X4YPbEQXKdY7HPvRwt5B463BEHm+DTYXocgSWxg857ORvS3IU1GckJ98qe+4N3MDXoLsMc2M2PLeSAFfKOkD9nLcRBvGlCLWkzp1xIxwcNOuCO+PCQjwxkNhJd4nVNiRdT9sTbPvNN+VcO1IUJh7r5UeLVQZ7DZEKsP2CuqdsCMQMRqxOmLvj4WiAsGS92TgJyMXgUdYRaozwLcRLTo7jDwh+p5CDHwN9xQQqJ58iILfNbEs8A/qOy2aoO2K2FwusU3/zSo6qp/C7X1qMF5E4YGU0TixBhuNFYfOjAjYEpqSE/4Nr/iClgE2z0qC8xKsxyUvGoAR++Aec0CS3aqS8acOfOY1sDrMEcZAPq9aTCYA+AW02eS3hU9ipQvSICSw4Witt130J9ndCjxDXHTpiDz7iTPOSFUL0VDLhIjMdezstA6FZXnAo0B3xswmIO8BWCW2RBH7FJVJ+tBankzByF4pjiBz/WNH/TmWvoE+RLdY9CLeGK6cysVzdW+BKvJmcI5qyFOetxDhxRpnoOt1bmGuHsUDuBOUfQByYUTyJ98nqGOJ1wC/oW6N99lL4IOGMG0THk9BeAVVM9ytXdGGHGIS8an75pPmGMHPDPXSMYH7zYluybBnUlD4/zQc+kLnc1tac+cANfT9lLIecKC9lXmEGRwKwCp3BuvFD3V84wLUTG0f35ZXyfXgj4GsDr83hC4fHKhj8+w0r1eIPXWV1l7W0El56n7fnxFP+Yos4ZZ+dHlP4y6aJmktlX5PebDpvHs/4Uv/8+KNu//l38Aw=='),
			this.addDataEntry('palette highlight', 28, 28, 'Palette Highlight', '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'),
			this.addDataEntry('palette non', 28, 28, 'Palette Non-SAP', 'nVfbkqJaEv0aX+ZhAgHPaR8RLMVmY1FiWfqGQCMXL1GAAl9/VubG0p7pipiYB8NN7rysXHlRBpp5bGafweUgzlFcDLTpQDM/z+dKno6NGRfFQFXSaKBZA1VV8BmoL9/cDvlWuQSf8an6XwxUaXANijqWEikoq7boBeUhuNAxPQYJvifX+LNKw6Bwgn1cvJ7LtErPJ9zvz1V1PkKhoItJEObJ57k+Rea5OH/iPop/BXVRPXkwijQhy+p8gTQoL3FIoH+lTQx4Ew5o3KUKJHGUVsG+iM2yfKuLuIT43/+6a1KIoAoGmiEf1ZfymgzUSXNEwubr3FV37UTfb5o67C76flbUQaekwfxNCa3z1dEiLWpHmmhH1/AYXoWfj5arsdRr7SSeDcv9SYzt40GJ5sZfTjuGRVhHnaj32uLkdPZNWMY11HYnO52oweZd845j/XVl35zMGOKO7m+u5WnCEsrSEqptGYnIRL30c7pr3CzUXWurul2u2ZbdOVmu427kdokqulBd+uuOfO8+Fl2wGdfw3TjZNLVnRf66WojtR1GExY8GOlqweVMCS0m/9Z9OzrtNcQrm3tjOvomV6UdbOxyWrZGAPyXeNIU9fxuFs/XYPr0V8dy7bjWX9OpQ8272vExC7e0amsNsrzbXMDsn4TFKf1p545hGI/x1aVvTbrnK/7bnSuKcXEWsJji7yl4zqq06Lvea/Zc9X5y2adK55i1xfQGbsP3pl8mvlfHD0SSO13SbxbPp37Zp/NjN3o9h98BKMqrbbvPSvmmLw25WFPuTlwQb5JqDr3nSUF3AwUj44MhEfS2beFBYlhFvHniN2u3m7bLbjJT3zegSzVH/03sH/v1w9pLt1uP6/cMtnnlC7MS2mi6ajW/2zC23H26H2nSRZaRO953e+Lg7uUVE9VrZyVZtDqFGsYgf+/qUK2xu1z/khj5fpK6+BUuk8Z+MvM4nh2iWJLtjUe4RJfpYlD9Nd/IT0XZ49v1piy5tHWuSiZWuuunt5liiFtm0Ft20dE3IVvoIFUHHeZqTbTvHsmu325bQV5arGzooGbLMT0jWOBZsV6SfqyQXHeSpPlyavS77mNaYCHSoR3eYOI6h4A6+jBLfqgNfoiU/to5zt2QMCZ1bYBq6qYKYOcW84Yw7Q/r9EBViI06oOz6e0X2kI1SSr1X4G5Jc+CFhq3Cnixb+Z0mFfHV3RnqwtQy6a9xWRzXI/1Tj3LIF8hAjPvthKXVufL9tGefNMXUNvnr8hg59fLyGY2fbRuKg7xw5G6q8Nwhz61A+zB/ywRnctEtTqWmikQuweahZgm+hcE0kfl1y4Kk9Lsp1BJ2Gc+3W4DuswDVxp7gt6VIdkGML/OAS9ab8iXfUgn0pOKuiVRAvZD+ulZM+eOV6Vw/up3QegSfoClXee6zrgRP0VYO4LeeITcB1lmfuvxA6sIXclpz4Xu1m7xlj5Lhh32+MRe37jf1Lrjh+I/tty1gQk/qt6nuv6blCPiQ3Wue55+j8cnGx/cEzepviW4uM+xD9CH+tSLkGdFaBo6a+AI+ErZZ8ol5ZWMl79ADzbley3+y+diHOqCO4Rn1kf0n+RqQjfMZ7g7+O+UFtqfZLK7nzS72jkQ/JtaHJXt5Kf6lONdNc5hI1ozPmgThweW56OXBsGfNU7e0ayRHhgG9rXfY4KPY9/lD2eSKxUk1a6lVwIGugytg34PJkrhbl+tIxB1wz9GG3JjtNbMTDjns2L3scMi+LcdzjE+/6kvXX97se4+2eR8n5f8WdUizZO+YNPmiuMYsUy6L5sWm+VO59WYtWUC59DeUM2NQzCsv9vOKZJb55/ujc80A14n3iyX2S9vMr5wA+yRazTfvJFzw3Ms+1wv6sw5l3D/dggmevXNLOOjJHtE9GxI3MFZiydSvnnz50DqWM95PMl+LwzspyymEoMQnqe/zC0gc5dehd3+bc0c9DceLdSTqN7Glb2h6F3Der3s635Y5kv4r0i10CDP3uyVvGw1xJXiTW8AlL77ugnGFnibLfv/9HzlEnMZMN4+OZddUet8SucY6p8uUvpP7mXKZaj5VyaDEbD8wyR+KqeuSEeGSzYoxfPmn/Ez+wfehbD7+bXBnJ31v89llv2C/rTv7eoUb335eOesZmH+yHekjWSeakfdW1feayx9zjRm3uWKW/iufD/HO+97pKW37WeLfde0MTf6zrNzmq/JtmYZfyDl3L+eP9FpZfvZbe+5DPfW36WjMn66+a9ljItuM9/MhT+w2PzLOTvch93/exaO91/O+6JtUTV8yRK+0Y89N8PNU2eeTNOx55p49/bK/muIuOIf6d4S2lf9XCy0/cfPu6xqL+XW0Wn49x9dlC5ZZG1aF/ZfshrQ5xmhyq32VBKZ+TL8vHux8O/evf/fHxmsl3v72F/gM='),
			this.addDataEntry('palette', 28, 28, 'Palette SAP', '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'),
			this.addDataEntry('paper plane highlight', 28, 28, 'Paper Plane Highlight', 'jVVdk6I4FP01vuzDVgTcaR8FlI5FggqtwhtfjcEgloCQ/Pq5EXu6Z6d6a6ugSM49534lJBPdqgbnFl9PpM5yPtGXE9261XU7jqrByjmfaIhlE92eaBqCd6KtvrFOH1Z0jW/5pf0/Am0U3GPe5SMyAk0r+BNoTvFVDVkVF/A17/mtZWnM3TjJ+aZuWMvqC9iTum3rCghcGcw4PRe3urtkVs3rG9iz/D3uePvFw4KzQinb+gpo3FzzVCX9zoYc0jMfARcfKAIkz1gbJzy3mmbX8bwB+O+/PpgqRNzGE30xTrVVcy8mmjlUULC1eaVaJEwjOQxdKq9G4vAulojFrzuU2vXd1TM9EzOdiNk9rdI7Cc4zz5+PPIGL3Jk2yYXMcXVC2eviH1fMQZF2mSRdoq8vrsQ9sRf3VI8umJlafNjr22pubHzcY3vRgU1SWQyeveypvRCenfYkSA3CFoIIY+YFoYCYGpFv4Oes0zIsSEk6T2HlckZLMgUfMypDTfmPjmsZH+Yd+B/ccsmww88bf03CI+cpfxmAo8eHHYptxP7DTx0d+CV+3c5xiaVbnsGOB8hF0mDRe0GqUYahh2tGjTBoCmwPMnvlTeSbKD+aHCKi6HhCrkZlKr4w15Y/k5lt/kj13T21pmWiDfe0rEtim2V0WJWejiqsn05ef167F4rIsZWZM+/dA70nzlx4jPTQL+k54Y93PyxzZ/nD8hfFxpqPGQTGqBeAOTseXcjXPC2FDtek2p/ScybCw+4aHWbo2SUTKjdIAJ2xYGWDJVS/YPi1ENBNQR8YVh1BwLuk1eoMq9llq30XH3cS9NNU24s33TyF2n6T8L2MfPyv6PC+jLWbZeKsZAp7LdW3PWYv3zPvURXJ6KhWQ60obcIjVfGgk0vmys+KlcbV/qxvw8ZOjfY/umIPfXjc1diJronTz/FlLxKrKLf+GaJB1DMaqGUIz+8Hzzd6WvXILYuWBLgj8KXMmBG/12CfTF0bsGDZUN+QhF8p7GXg4Ab0M3LoPzRqbrj2W0ckbggzhl/6IIQ9uYqDQO27t5lbbodQGAg46p0S3wAMz1x72VF717hBAT62Dexh8MtL1zeE4nkW6mi57Tw7bEEjIB+DMsCCoiFg84KiBT+6G4AOcM9egy/SUR8ZbpkaAeRHWD+QR94EuG9o9K24GOahgDlwEPxn+OGTPnI4q3g95KDiKds0sLGAfxHqWwqoZUqBq3oy8mAcEDVGjx7v688Vlf3j3NgU6sRVj/k8luGgzIdvj/YH9DzXnbyu8vYmgNKzrD09j/eXUXXKWXFqf8fiZpwXv5Sf9wQMnlfFx/TzSnrYfruxfgI='),
			this.addDataEntry('paper plane non', 28, 28, 'Paper Plane Non-SAP', 'jVXJkqM4EP0aX+YwIQPuLh9ZvKgCCdvgBW5sjYWFcRgwSF8/KePq6p6OmpgICKSX72WmUok00e1qWN3j25nUWc4n+mKi2/e6bsdRNdg55xMNsWyiOxNNQ/BOtOUX1unTim7xPb+2/0egjYJHzLt8REagaQV/Ac05vqkhq+ICvtYjv7csjbkbJznf1A1rWX0Fe1K3bV0BgSuDFaeX4l5318yueX0He5b/iDve/uLB5KxQyra+ARo3tzxVSf9gQw7pWc+A5geKAMkz1sYJz+2m2XU8bwD++68PpgoRt/FEN8eptmwexUSzhgoWbG/WVIuEZSTHoUvlzUhWvIslYvF6h1Knfrh6pmdiphMxe6RV+iDBZeb585EncJGvpk1yJXNcnVG2Nr+5Yg6KtMsk6RL9/epK3BPHfKR6dMXM0uLjQd9Wc2Pj4x47Zgc2SWUxeM6ip44pPCftSZAahJmCCGPmBaGAmBqRe/Bz0WkZFqQknaewcjGjJZmCjxmVoab8R6d3GR/nHfgf3HLB8IpfNv47CU+cp/xtAI4eH3codhD7Dz91dOTXeL2d4xJLt7yAHQ+Qi6SB2XtBqlGGoYbvjBph0BTYGWS25k3kWyg/WRwiouh0Rq5GZSoU071SRGzrO15TlOhmG2rzJtHxN7x+v4asmBG/L0iwmLq2ORB5uXnCmmN7JjNnUeTCktlq3rtH+khWc+ExS0QaroncNtjZS9DohF3ANyo29nzMJDAqrJ/PnjCLzWrHoyv5NV9bocMtqQ7n9JKJ8Li7RccZelXLggoYJIAK2bDDwQKqYDK8LgRUVdAnhlVlEPCuabW8wK522fLQxaedBP001Q5ir1vnUDtsEn6QkY//FR3et1TfPVLbKpPVUqbQc6m+7TF7+5r5iKpIRie1K2pnaROeqIqnqsRc+blipXG1P9e3YWGZrxbfR/sfVXGGPjztaryKbsmqn+PrQSR2UW79C0SDqBc0UNsQnt8Pnm/0tOqRWxYtCXBH4EuZofZRg36Zug5gwaKhviEJv1HoaeDgBvQzcuw/NGpuuM6+IxI3hBnDT30QQm8u4yBQ/befueV2CIWBgKPeKfENwPDMdRYddXaNGxSd6gfoZfDLS9c3hOJ5Nupoue08J2xBIyAfgzLAgqIhYPOCogU/uhuADnDPeQdfpKM+MtwyNQLIj7B+IM+8CXD3aPStuBjmoYA5cBD8b/jpkz5zuKh4PeSg4inbNHCwgH8S1rcQsJYpBa6qyciDcUDUGD1rfKg/d1T2z/NjU6iTVz3W63iGAzMfvjzin9DrfF/ldZW3dwGUnmXt+XXMv42qc86Kc/s7FjfjvPip/LwvYPC6Mj6mn1fT0/bbzfUP'),
			this.addDataEntry('paper plane', 28, 28, 'Paper Plane SAP', 'jVXJkqM4EP0aX+YwIbN0F0cWL6pAwjZ4gRtbY2EBDgMG8fWTsl1d3dNRExMBgfLly0WpJDVT7Wpc3eLrmTRZzmfqYqbat6bpnqtqtHPOZwpi2Ux1ZoqC4J0pyy+084cWXeNbXnf/x0B5Gtxj3udP5Am0neAvoD3HV7lkVVzA17rnt46lMXfjJOebpmUda2rQJ03XNRUQuFRYcXopbk1fZ3bDmxvos/xH3PPuFw8mZ4W07JoroHF7zVOZ9A825pCe9QhofqAIkDxjXZzw3G7bXc/zFuC///pgyhBxF89U8ykqy/ZezBRrrGDD9mZNlUhYWnIc+3S6asmK9/GEWLzeodRp7q6aqZnQVSL0e1qldxJcdM83njyBi3w1b5OaGLg6o2xtfnOFARZpn02kT9T32p3wQBzznqpRjZmlxMeDuq0MbePjATtmD7qJTsXoOYuBOqbwnHQgQaoRZgoiNN0LQgExFTLtwc9FpWVYkJL0nsTKhU5LMgcfOp1CRfqPTu9TfDR68D+65YLhFb9s/HcSnjhP+dsIHDU+7lDsIPYffproyOt4vTVwiSe3vIAej5DLRANz8IJUoQxDDd8Z1cKgLbAzTtmat5FvofxkcYiIotMZuQqdUiGZbk0Rsa3veE1RoppdqBhtouJveP1eh6yYqD8UJNjqrm0KGuyvnrAMbOtT5iyKXFhTtjIG90jvycoQHrNEpOCG2EMB9Wqxg0diX8A3Kja28cwk0Cqsns+eMIvNasejmvyary3R8ZpUh3N6yUR43F2jo45e1bKgAhoJoEI2nHCwgCqYDK8LAVUV9IFhWRkEvDqtlhc41T5bHvr4tJvAfp4qB7FXrXOoHDYJP0yRj/8VHd63VN3dU9sqk9VySqHnUnU7YPb2NfMeVdEUneSpyJOlbXiiMp6sEnOnzx1LG1f5c38bFpb5avH9qf+jKs44hKddg1fRNVkNBq4PIrGLcutfIBpEvaCR2prw/GH0fG2g1YDcsuhIgHsCX8o0nfiDAv0ydx3AgkVLfW0i/Eqhp4GDW7DXyXH4sJGy5jr7nky4JUwbf9oHIfTmMg4C2X973S23Yyg0BBz5zomvAYZ111n01Nm1blCAj20LvQx+een6mpA8z0Y9Lbe954Qd2AjIR6MMsKBoCei8oOjAj+oGYAe457yDL9JTH2lumWoB5EfYAP0l8ybA3aOnb8nFIIcCZOAg+N/wwyd95HCR8QbIQcaTunngYAH/JOxvIWAvcwpcWZMnD9YBkWv0qPGh+TzRaXjMj00hJ698rNd4hoGZj1+O+Af0mu+rvKny7iaAMrCsO7/G/NvT6pyz4tz9jsXtUy5+Wn7eF7B4XRkf4ufV9ND9dnP9Aw=='),
			this.addDataEntry('permissions highlight', 21.91, 28, 'Permissions Highlight', 'jVZbk6I6EP41vpyHrRjw7PiowDhYBEZhRuGN2yIRxRpASH79dgfcmT1bW3UeKJK+fv11BzLTjMuw+YhvJ1ZneTXTrJlmfNR1O64ug5FX1YySMptp5oxSAs+MPv9FO1dacos/8mv7fxzo6HCPqy4fJaOgaUU1CZpTfMNleYkLeK/v+UdbpnHlxElevdZN2Zb1FfRJ3bb1BQwqVKzj9Fx81N01M+qq/gB9lv+Iu6r9EmFVlQV6tvUNpHFzy1ME/aMccoC3VglXDykBSZ6VbZxUudE0+67KGxB/++dhiSniNp5pq3FLn5t7MaPr4QIFG68vLo3EWk8OQ5fKm55sqi6WpIxf9iQ167ujZVomFhoTi3t6Se8sOC88fznaCbvIN/MmubKlfTmR7GX1ryOW4JF2mWRdom2vjrR7Zq7uqRZd7XJN48O7trss9Vffbpmh9yxYob534e3ydMFMi7LAKpixGrxPvWC80D3T0pkMC8ZZx0x79DPfNFeGEnwFxo+OWxkflh3EHxxulfamOr/6WxYeqyqtngaw0eLDnsQmKVlQQBxLxWHchvjF4JmMgk0dHapr/LJb2tyWDof8aGPu5q5MKWDQWGkDh9vS1cOgKWxzkNlL1UT+muTHdQUZSXQ8EYeCvfhiuTX8hczM9fdU299TY84TOtxTXnNmrnl0eOaeRi62djp5/XnrXF3Cjq3MNsveObj3ZLMUXsl6VxbS24Tff/ghzzfWd8NfFa/GckQQ6KO/ANlmX0VX9hWngdLhllzeT+k5E+Fhf4sOCzKxtIbKdRYAMwZ0NrCg+lVpvxQC2fSUzFaMgN01vTyfoZtd9vzexce9BP95St/Fm7Y+hfT9NaneZeTb/8kOz9NY+5onm2eZwqyl2q63y6e/W96jSySjI3YDO+o24dHFfMCkVTrys2L0ceif9b2WI1Oj/g9WzKEPj/va3kS3ZNMv7eu7SIyC7/wzZIOsZzK4pb5woEcOT6Vjrhrm6zBfTHdMq2N+j7MmMx52nllxZvQd9KgFvab0Qdoqe7XOpBPge4f6xWONenceCoe7tROknWvuG8fXiWvAc0T5WQvlqnF4KEEuWKlyarCmrlqDzcPeJ52HMXiBcedwjqi3gTXUkBgEYu86iDnAXsQmnCW5h7qYwLoc/raAuBAvXSiZmn88S2zu8J0+voshFQRw251bwlu+Qd3PXOGCx1U5UpCH7RSH+qr2PdpIwN4jbngAA2A1FRd09Id43ML9gPV4BsbHfTFkJRmY0HV2YegvXDH6uwHW8Ia5tADzmmfYb7nCPWIiLuKVgFeeMTbUDTbmNg4CiwK3DQveIG808sAtfeRhNx/xF8PEAVW4eDpX77GfFDARlwIm4JlhHm6r+cCcLg9xTRVO5N1EnGcN+qVj7134Brn8BD1HXYX8UMXPrxmx5WTXKh/VYzLFCZEz+B6rPK3Kc4X3Aw/YQo+RA50h7z4ZZ2bkRcJMkxEjm3gZOYa6FzBriJMqPjC/THGmcIYIxKdfalM98gLgEHXYz6CCXDr8MyCn6IU6J/y8CJXfY15Xij+YE4zRwxkCux2cIZRV2BcxnR8CvvC9toHXio68ZHDGsJ8MMFpimiWp5t7EWXn0Xc2h6jfsNeQJ5kIqezVjBUFdqHpmfc4dzrniC3iDc4KcHfAbADEQO9QgXDhPeNa8I5xHvtNi1VvEB1zCD/e379mTo8FfVup4cdDW09UCfvb58NfriRJNd5NNXl/y9kOASV9m7Wm6osy/LSfHU14Wp8mRPo2yuBn3xS/nz+sOLKYbz2P7ebNSut8uXj8B'),
			this.addDataEntry('permissions non', 21.91, 28, 'Permissions Non-SAP', 'jVbJkqM4EP0aX+YwIUu4p3w0S9lUILxRZcONrTEyNo4CbKSvn0yBu7qnoyPmQCDl+vJlCjRh1qVffsa3E6+zvJowZ8Ksz7puh9Wlt/KqmlBSZhNmTygl8Ezo6x+0U60lt/gzv7b/x4EODve46vJBMgiaVlajoDnFN1yWl7iAt3nPP9syjSsvTvJqUzdlW9ZX0Cd129YXMKhQYcbpufisu2tm1VX9Cfos/x53VftThEVVFujZ1jeQxs0tTxH097LPAZ6pEy6eUgKSPCvbOKlyq2l2XZU3IP77r6clpojbeMIWw5a+NvdiQs3+AgVbm5VPI2kayaHvUnUzkmXVxYqU8WpHUru+eyxjmZwxLmf39JLeeXCerffzwU66Rb6cNsmVz93LiWSrxTdPzsEj7TLFu4S9XT3lPri9uKcsurqlSePDB9te5sZm77bcMh48WKD+4cPbF+mM2w7lgVNwa9Gvv/SSi8JY247BVVhwwTtuu4Of/c58FSrwlRg/Or6p+DDvIH7vCad0l9V5s3/j4bGq0uqlBxsWH3YktknJgwLiODoOFy7EL/q1zSnY1NGhusar7dwVrvIE5Ecbezv1VUoBA+OlCxy+lb4RBk3h2r3KVlUT7U2SH80KMpLoeCIeBXuJlt7VJ9wy/3FXPknYog3pvEmY+81dvV3Dspjx/aOAuqce1M3V+baW5ty1ZiqznSKXpsqW84d38O/Jci7XpSkj6tZcbRvXflfgA3jOEJsUG2s+IAmMi8tOp7VcFJvlroqu/Ge8Fkr7W3L5OKXnTIaH3S06zMjIlgkMGDwAhizocOAAC4vSXRUSWV1rmauZAbtrenk9Q1e77PWji487Bf7TlH7Id2aeQvqxSaoPFe3d/2SH5yVlu3tqmSJZvqoUZi5l24dbvvzZ8h5dIhUdsSvYWb8Jjz7mQ5ZKT31VjD4e/b2+TRmKfOn8M+h/Y8XuH+FxV7vL6JYsH3P3+iETqxDb/RmyQdYz6f3SmHm2KTyRKs9eNHxvwJxxw7OdDnqIM6cyEXZruxLcenS+KlrQM60P0lbb63WmvADfW9TPnmvU+9NQesKvvSDtfHvXeHuD+BY8R5SfWagWjSdCBXLJS52TwZr6eg02T/s96dYYQxQYdwrnia6XsIYaEotA7G0HMXvYy9iGM6V2UBeXWJcn3mcQF+KlMy3T5wDPFJ96YmsM76JPJQHcbueX8FbvUPer0Ljg8XWOFORhO8ahe137Dm0UYH8gbngAA2C1NRd08Id4wsF9j/WsLYyP+6LPStJzaRj8wtFf+nLw9wOs4R1zsQDz2mfYvwmNe8BEfMSrAK86Y2yoG2zstzgIHArcNjx4h7zRwINwjIGH7XTAX/QjB1TjEulUv4d+UsBEfAqYgGeOeYSr5wNz+iLENdU4kXcbcZ4Z9MvA3vvwLfLFCXqOugr5oZqfHzPiqtGu1T66x2SMEyJn8F3WeVqd5wrvJx6whR4jBwZH3vdkmJmBFwUzTQaMfORl4BjqnsGsIU6q+cD8KsWZwhkiEJ/+VJvu0ToADlGH/QwqyGXAvwNyyofU50ScZ6H2e87rQvMHc4IxHnCGwG4LZwhlFfZFjueHgC98t13gtaIDLxmcMewnB4yOHGdJ6bm3cVaefddzqPsNe4Y8wVwoba9nrCCoC3XPnK+5wznXfAFvcE6QswN+AyAGYocapA/nCc/a+gjnUWxZrHuL+IBL+PH+8j178Rj8bZWBFwhmjlcM+Onn/R+vKVo03lGWeX3J208JJo8ya0/jVWX693x0POVlcRod6csgi5thX/xw/rr2wGK8+Ty3XzcsrfvlAvYv'),
			this.addDataEntry('permissions', 21.91, 28, 'Permissions SAP', 'jVbJkqM4EP0aX+YwIQvcUz6apWxVIHmjyoYbW2MwNo4CbKSvn0yBu7qnoyPmQCDl+vJlCjQx7Eu//IxuJ16nWTUx3Ilhf9Z1O6wuvZ1V1YSSIp0YzoRSAs+Evv5BO9Vacos+s2v7fxzo4HCPqi4bJIOgaWU1CppTdMNlcYlyeFv37LMtkqjyojirNnVTtEV9BX1ct219AYMKFVaUnPPPurumdl3Vn6BPs+9RV7U/RVhURY6ebX0DadTcsgRBfy/6DOBZOuHiKSUgydKijeIqs5tm11VZA+K//3paYoqojSbGYtjS1+aeT6jVX6Bge7MSNJSWGR/6LlE3M15WXaRIEa12JHHqu2ekRipnBpeze3JJ7tw/z9b7+WAnWZ4tp0185XN2OZF0tfjmyTl4JF2qeBcbb1dPsQd3FvfECK+ssGh0+DC2l7m52bOW2+aD+wvUPwS8RZnMuONS7rs5txf9+ksveZmba8c1uQpyXvKOO2zwc94NoQIFvhLjh8c3FR3mHcTvvdIt2LI6b/ZvPDhWVVK99GBjRIcdiRxScD+HOK6Ow0sG8fN+7XAKNnV4qK7RajtnJVNeCfnRxtlOhUooYDB4wYDDt0KYgd/kzOlVuqqacG+R7GhVkJGExxPxKNhLtPSugnDb+oetBImNRRvQeRMb7BtbvV2DIldi/8i5v5159kIK//22ltac2TOVOm6eSUuly/nDO4h7vJzLdWHJkLKa24987SQNc1jP7TPEJvnGng9IfPPCjNNpLRf5Zrmrwiv/Ga+N0v4WXz5OyTmVwWF3Cw8zMrJlAQMm94EhGzrsu8DComCrXCKray1jmhmwuyaX1zN0tUtfP7rouFPgP03oh3w3rFNAPzZx9aHCPftPdnheEmN3T2yrjJevKoGZS4ztgxUvf7a8h5dQhUfsCnZWNMFRYD5kqfDUV8Xo49Hf69sUQZkt3X8G/W+sOP0jOO5qtgxv8fIxZ9cPGdt5ud2fIRtkPZNeFObMc6zSKxPlOYuG702YM256jtvx/QNnTqVl0K2dqoT+dELlLegNrfeTVtvrdao8H99b1M+ea9SLaSC9UtSen3TC2TXe3iTChueI8rMRqEXjlYECueSFzmnAmgq9Bpun/Z50a4xR5hh3CueJrpewhhpim0DsbQcxe9jLyIEzpXZQF5dYl1e+zyAuxEtmWqbPAZ4pPvXKrTm88z6RBHCzThTwVu9Q92upccEjdI4E5EE7xqF7XfsObRRgfyBueAADYHU0F3Twh3ili/se61nbGB/3eZ8WpOfSNPmFo78UcvAXPtbwjrkMH/M6Z9i/lRr3gIkIxKsArzpjbKgbbJy3yPddCtw23H+HvOHAQ+maAw/b6YA/70cOqMZVJlP9HvpJARMRFDABzxzzlEzPB+YUZYBrqnEi7w7iPBvQLxN7L+BbJMoT9Bx1FfJDNT8/ZoSp0a7VPrrHZIwTIGfwXdZ5Wp3nCu8nHrCFHiMHJkfe92SYmYEXBTNNBox85GXgGOqewawhTqr5wPwqwZnCGSIQn/5Um+7R2gcOUYf99CvIZcK/A3LKh9TnpDzPAu33nNeF5g/mBGM84AyB3RbOEMoq7Isczw8BX/huM+C1ogMvKZwx7CcHjK4cZ0npuXdwVp5913Oo+w17A3mCuVDaXs9YTlAX6J65X3OHc675At7gnCBnB/wGQAzEDjVIAecJz9r6COex3BqR7i3iAy7hx/vL9+zFM+Bvq0y8QBjWeMWAn37W//GaokXjHWWZ1Zes/ZRg8ijS9jReVaZ/z0fHU1bkp9GRvgyyqBn2+Q/nr2sPLMabz3P7dcPSul8uYP8C'),
			this.addDataEntry('restart highlight', 25.67, 28, 'Restart Highlight', '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'),
			this.addDataEntry('restart non', 25.67, 28, 'Restart Non-SAP', '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'),
			this.addDataEntry('restart', 25.67, 28, 'Restart SAP', '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'),
			this.addDataEntry('synchronize highlight', 28, 28, 'Synchronize Highlight', 'jVZLd6pIEP41bmYxpwWcG5cKSsih2yjEiDsEgrzEE0Do/vVT1Y15zJ3MmQVHqHd99VXbE92sBvs9vJ5pHSflRF9NdPO9rlv1Vg1mUpYTjWTxRLcmmkbgmWjrH7RTqSXX8D25tP/HQVMOt7DsEiVRgqbl5ShozuEVX7MqTOF3eUve2ywKSzc8JeVz3WRtVl9Af6rbtq7AoETFMoyK9L3uLrFZl/U76OPkLezK9kuERZml6NnWV5CGzTWJsOi3bEigvKVMuLhLCUiSOGvDU5mYTbPryqQB8Z9/3C0xRdiGE32hPrV1c0sn2nKooGHz+ZFpR740Tq9DF4mrcbLLLhQkCx93JLLqm6vHesxnOuWzW1RFN+oXs403V3bcSRN72pwudO5UZxI/Lv5y+Rw8oi4WtDvpTxdXOD21FrdIP16cbKmFr3t9W82NZ8/p3XwxBV1P/cWU+fCbOwPNXzgzF6gjUodPngrqO5xagXAsR7g51IB1WIsZzYMp9anG+AL8jF7W56cYj1D/pWemk8bVnkdaeTvlJKOeMUAd16NFMt9ez46HpzfqgY1WFrGdzp38p/hOGtr761E7E6j9p1yA61PGjMBvUscaRPxYNkdvSZLDsnz2nsjxcCauxkTEv1g+md5MxNbyV6TvbpE5zU/acIvyOqfWMj++rvONTipHP583ffHkXhihh1bE9rx3X9ntZM/5JqM9E6nY2MGvNy/IE3v1y/QW6bM5VxX4hvLnILN35fFCv9ZponS4nqr9OSpiHrzursfXGXHssoCal4CWQX1ADpBM/BUgtMicx5QrFFDmIGoE7C5RtS5gwl283nfhYSfAfxppe/6iL8+Btn8+lXtx9Jx/ZIfnQfW+zE/2WkTAv0jf9k728LPl7VgdxfGwhdyrzLFZExwY5gMkV5krPjtGH1f7vb/nTCGl9L+hYg19cNjVjn28nux+7lz2/GSm+dYrIBtkLQinmcFZ1g/MMzT6SjvgbketomOWI9+Z78B71AF34Snkw6yV+s2Dhpo9vNMWuA6ccwzXM/qNZxDGyeBiDN9pIQd896BPW+AcoV4/BXvu+qtu468a4DPUQQjukguxNxZtGfhQqAt8hLSzUshFIEaguRjfJBCDEtRRsWohhsYyAnbblnKowSRc1uRvoY8IZVN2CUC20gKxaKQv7JH0MwnEoOBbQB8Ol49nYHwBvwbULKiOPQajDxltqQg4+OYO+k1BJyh8M/+lvftuDgH2rDGb9qiHd+nPcgdzgl1KRl+cxZR5X2uhIrS2EK/MZb0W1i17GJQfFdJX1kwNF2cnUvDdCVlndu8NZRBD5UCsOzbWCniBntUKxzXkKQZXzbcB2x5moPJZFOtCmQ6zHGQ9OAuYMcN6/bTB3hg3ZhtTzs3AehF3mAVwBvQKO9Bt5ZyZH8DcMH4Ec0I8ttJ+5ILAWWHNG8B/48kYHUN8czVz0INvMIxzNIB3PdtfGcwDOYS8mm6Q0xgXeCox952x51RxXc4hlXhAHoM9BtgX+cYRwBGxUjhuf+aIJvmNOdtxXv/KGTWHO2/k9wd35OwQb9xH/iHL7xyBOkeOpPd4RmiNs/OMGcwb8F3NJJ5WgLuHuYXkB+6yiHBXhOKg1GuILcyvldzM1DvYzGA2vetTsKOIfYvzY3InYX4+zg/nHo0xcI4U92zc9eJ+FnBZL54lErutDjzFuQ4bqcde8FxBXYC1E9Vnj/tCJE4W4vnC3bt9jvu1mI3nAHxLvfZpP+4x1iu5h7FlXDgjZFzoA7jN1a4pe4hvrRReHHvBHqE/s8c901wfz8UniyE/MQ7vZ1Cvjv/x4MflLzyBuJ9ViAFyaQt68FU7I3eL5YWy4Yg35lrAriAnVyjT6EHNjVX/eWbwOx/cO3flrp/Db/85D64OtyNh4IVPX45XQrikJcOP10opGu+UdlJXSfvOwaTP4vY8Xi0flNc5ydJz+10WNuo7/fD8vKPCy3hNvX9+Xoel7ttt+W8='),
			this.addDataEntry('synchronize non', 28, 28, 'Synchronize Non-SAP', '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'),
			this.addDataEntry('synchronize', 28, 28, 'Synchronize SAP', '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'),
			this.addDataEntry('settings highlight', 26, 28, 'Settings Highlight', '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'),
			this.addDataEntry('settings non', 26, 28, 'Settings Non-SAP', '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'),
			this.addDataEntry('settings', 26, 28, 'Settings SAP', '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'),
			this.addDataEntry('success highlight', 28, 28, 'Success Highlight', 'jVZLs6I6EP41bu7iVgSsGZcIHE4sElTwATsEBokolqJAfv3tDuo5s5iaW6XVSb/y9ddJyEi3Tp17TS4HVmd5NdKdkW5d67oZRqfOyqtqpJEyG+n2SNMI/Efaxx+sY2Ull+San5v/E6ANAY+kuueDZlDcmr56Km6H5ILD8pQUIGd5VjbJvsqt2211r/IbmP79B/SP/NqUaVJ5yT6vFvWtbMr6DMZ93TT1CRwqNMyS9Fhc6/s5s+qqvoI9y38l96r5lsGsygIjm/oC2uR2yVMs5lfZ5QB7poCYLy15aTBV0iQj3Rym2sftUYy0WXeCgq3FJ9fifmbst909laRMPlckteuHp2d61k901k8e6Sl9MGG2zJrK7JSW9DO+xLvM2uvFlJak9cS68ELzzgOz9y380yJxN5dYO5BFQNU806pj5oK/oAYVxonqh4PfHgtqdzL7rG5xMCP5blYtgjmJdwfiaVymPQWc85IbUXibW8FEZvbsR6qvHqk1Fnute6SiFsyeiXj7IXydvLLOvTMnbNfIzJ223pY/9u6090vWcllI341+/AoikbvODyswiwVWhQjCN6qfsbs5pfI9ny/c7rI/bQ7pMeuj7eoSbyeEul/jzXZyyT7ZlJ43Mt7Nw9T9EPF6et/seEXL2YQJUjKxvjNpTmBuDHN25/aaKHsI894gXC6B3aJD1jxhSj8AJrfLKT065aJ8Yl4Cnk9O9rpZRFp3SHVcF+q16OOvPpBvr8WnVNtgZzpa/vzOcNgCU9Ud2OxX+vwQu1W1Py+/eQBXx3gby/c6YddGu1VN3fiyd1usv99bhVgGx5K6iJt0UNfYC4xxJJ27H7Ke2mYBOp3JCPiICLXXwIMD0rkz+6gkl470RCqpze6w84xBh7FL8C0GvT3omcC5khq1KXI8RunbwPXbb4gbckIukRpf62Efiv5rPuCJQsSg9E8JuC2z88LvftEk6onCO+RdE7QDVpWXhWvdC79joBMVr7AO2L3whXXA7oW/17hUOJZywIFywDHM1wUT6Z1vHeTZYKX5kq3yC8gYYjQ/IB3spwl3WQN2yWTRsMAgKHlgTPzw2HDLaJXsUZ8+ZTZjgN+3afGWFuZ2GrU26PiWtVgT9tYTTOMWUTxzwKLWtBSGDvLDbYI4UsCItlSyEn1pC7cGSBMkIeBrsDHTIJfuI98Czm1vGngeAPPYD1d/wjTgCaAfu0vjhSnMVweI0VVv+icnFthFAb1xNOwdEw6sZRoqTnFKAR+Mw9RADPzMoFY6gTySC9ooXWmM4S6BsdNDXQT6heMO9JrvspZailtYI4J6ijFy6YeAMzB6Hh5ueCbUvtvi3jORt55j3wTgtI/DXhRrWH85YSXeCwxrhFqPEs5Sx8XymQvXBZ9T2zELzlnowG28EUM+rAd5xRwEeeqeY5B07EO/ma1q62F/wF5b4jklPFxjLQTGGhcc1+uZXGLdEzbkNPA8c/tDKCxD7Tr0GfYvQ3/JQuRpjTkIszOppMrhEMTCRdRjLJOVGGyp6otvY82OxoM3RuBtzlgIfQsjPC9wTmC/y7Ux7P+jOn+QuxvWRSypqpcjV+GTR1jD39Wl97rTZftI9fi8KPBbjr/Z84MPn9q8++OjQameLwY3r095c+3BpS2z5vB8OPwcog55WRya33XJbZgX78ivFwgMno+Q1/TrsaNsv72F/gM='),
			this.addDataEntry('success non', 28, 28, 'Success Non-SAP', 'jVZbs6I4EP41vuzDVgTcGR8ROBiLBBW8wBsCgyCKpSiQX7/dicdz5mFqt0qrk77l66+TkJFunXv3llyPrMnyeqQ7I926NU2rRufeyut6pJEyG+n2SNMI/Efaxx+sY2kl1+SWX9r/E6CpgGdSP3KlUYp7O9Qvxf2YXHFYnpMC5CzPyjY51Ll1v68fdX4H099/gf6Z39oyTWovOeT1srmXbdlcwHho2rY5g0ONhlmSnopb87hkVlM3N7Bn+a/kUbffMph1WWBk21xBm9yveYrF/Cr7HGDPJBDzU0s+NZgqaZORbqqp9nF/FiNt1p+hYGs551o8zIzDrn+kgpTJfE1Su3l6eqZnw0Rnw+SZntMnq8yOWVORndOSzuNrvM+sg15MaUk6r9oUXmg+eGAOvoV/WiTu9hprR7IMqJxnWn3KXPCvqEEr40z149HvTgW1e5HN63sczEi+n9XLYEHi/ZF4GhfpQAGnd+GEWbMfdM7JQTfbSJveDzr9h84Xl6gsJizoChY6Y88yeyZOV3+YTak1EZntFPkwE5k77bwdfx7c6eCXsyHWaMPE6k7tjYAYnZUnyE2KJVaHSMI3up+xuz2n4j1fLN3+ejhvj+kpG6Ld+hrvJoS6X+PtbnLN5mxKL1sR7xdh6n5U8Wb62O55TcvZhFWkZNXmwYQ5gbmh5uzB7Q2R9hDmg0G4WAHLRY/seZUp/AAY3a2m9OSUyzKqctf5Ya0Aj+KkiLT+mOq4LnJFn//pA/kOWnxOtS12qKflT2B6UXIjCu8LK+yArfoR7z6Gtb44xm5dHy6rbx7A1SnexeK9Tth30X7dUDe+HtwO6x8OVlGtglNJXcRNeqhr7AXGOBLOww/ZQG2zAJ3ORAR8RAT6ATw4IJ0Hs09ScuEIr0oFtdkDdqChdBi7At9C6W2lZxXOpdSoTZHjMUrfBq7ffipO5YRcVWp8rYd9KIavucIThYhB6l8ScMNe88LvftEkGojEq/JuCNoBq8zLwo3uhd8x0ImMl1gVdi/8xKqwe+HvNa4kjpVQOFAqHGq+KViVPvjOQZ4NVpqfspN+ARlDjOYHpIf9NOEua8EumChaFhgEJQ+MiR+eWm4ZnZQD6tOXzGYM8Ps2Ld7SwtxOK9cGHd+xDmvC3noV07hFJM8csMg1LYmhh/xwqyCOFDCiLRWsRF/awe0B0gRJCPgabMw0yKX7yHfFOj6YBp4HwDz2w/WfMCk8AfRjf229MIX5+ggxuuzN8OLEAntVQG8cDXvHKgfWMg0ZJzmlgA/GYWogBn5hUCuF+8YQvKKt1JXGmAN3XuUMUBeBfuG4B73mu6yjluQW1oignmKMXPoh4AyMgYfHO54Jue92uPdM5G3g2LcKcNontRerDay/mrAS7wWGNUKtJwFnqefV6pUL1wWfc9czC85Z6MCtvK1UPqwHecUcBHnqX2OQdOxDv5ktaxtgf8BeW+E5JTzcYC0ExhqvOK43wL2JdU+Yymngeeb2RyWxqNp16DPsX4b+goXI0wZzEGZnQkqZwyGIhVfRgLFM1JWypbIvvo01OxoP3hiBtwVjIfQtjPC8wDmB/S42htr/J3n+IHev1kUsqayXI1fhi0dYw983pfd5p4vumerxZVngNx1/s9eHHz65ef/Hx4NUvV4Obt6c8/Y2gEtXZu3x9YD4qaKOeVkc2991yV3Ni3fk10sEBq/HyOf069Ejbb+9if4F'),
			this.addDataEntry('success', 28, 28, 'Success SAP', 'jVZbs6I4EP41vuzDVuSyMz4icDixSFDBC7whMAiiWIoC+fXbnXgu8zC1W6XVSXen++uvk5CJbp8H75Zej6zNi2aiuxPdvrVtp0bnwS6aZqKRKp/ozkTTCPwn2tsfrFNpJdf0Vly6/7NAUwueafMolEYp7t3YvBT3Y3rFYXVOS5DzIq+69NAU9v2+fjTFHUx//wX6Z3Hrqixt/PRQNMv2XnVVewHjoe269gwODRrmaXYqb+3jkttt097Anhe/0kfTfYtgNVWJK7v2Ctr0fi0yLOZXNRQAey6BWB9a8qHBUGmXTnRLTbW3+7OcaPPhDAXby3euJePcOOyGRyZIlb6vSea0T1/P9Xw0dTaaz+ycPVlt9cyeifycVfQ9uSb73D7o5YxWpPfrTelH1oOH1hjY+Kdl6m2viXYky5DKea41p9wD/5oatDbOVD8eg/5UUmcQ+XtzT8I5KfbzZhkuSLI/El/jIhsp4PQvnDB7/oO+c3LQrS7WZveDTv+h74tLXJWCh33JopXpQ2Yeba7BOJ9R2xS545bFOBe5N+v9HX8evNkYVPMx0WjL7L4MnOxOHTow+wSxSbnE6hBJ9InuZ+Jtz5n4nC+W3nA9nLfH7JSP8W59TXYmod7XeLszr/k7m9HLViT7RZR5b3WymT22e97Qam6ymlSs3jyYsEyYG2rOHtzZEGmPYD4ahIsVsFwOyJ5fWyIIgdHdakZPbrWs4rrw3B/2CvAoTspYG46ZjnmRK/r8Tx+Id9CSc6ZtsUMDrX4C04uKG3F0X9hRD2w1j2T3Nq71xTHxmuZwWX3zAK5OyS4Rn3mioY/365Z6yfXg9Vj/eLDLehWeKuohbjJAXVM/NKaxcB9BxEbqWCXodCZi4CMm1NkADy5I98Gck5RcuMKvM0Ed9oAdaCgdrl2Bb6n0jtKzGudSatBX5HiKMnCA608/tU7FhFh1Znzlwz6U49dc4YkjxCD1Lwm4bWvwo+9+sRmPROJVcTcE7YBVxmXRRvej7xioKddLrAq7H31gVdj96PcaVxLHSigcKBUONd+UrM4efOcizwarrA/ZS7+QTGGNFoRkgP1kco91YBdMlB0LDYKSh4YZRKeO20Yv5Yj67CXzOQP8gUPLT2ljbLeTuUHHd6zHmrC3fs00bhPJMwcsMqctMQwQH24VxJEBRrRlglXoS3u4PUBaIAkBX4NNmQax9AD5rlnPR8vA8wCYp0G0/hMmhSeEfuyvnR9lMF8fYY0uezO+OLHBXpfQG1fD3rHahVyWIddJTuFuwJ5GmYEY+IVBrdSEOILXtJO6yphy4M6v3RHqItAvHA+g1wKP9dSW3EKOGOopp8hlEAHO0IC76njHMyH33Q73noW8jRz7VgNO56T2Yr2B/CuTVXgvMKwRaj0JOEsDr1evWJgXfM493GdwziIXbuVtreJhPcgrxiDI0/Aag6TTAPrNHFnbCPsD9toKzymBuxRrITDWeM0x38jECus2mYpp4Hnmzlstsajadegz7F+G/oJFyNMGYxDm5EJKGcMliIXX8YhrmWhqZctkXwIHa3Y1Hn5iBN4WjEXQtyjG8wLnBPa72Bhq/5/k+YPYg8qLWDJZL0euohePkCPYt5X/caeL/pnpyWVZ4jcdf/PXhx8+ucXwx8eDVL1eDl7RnovuNoJLX+Xd8fWA+KlWHYuqPHa/69K7mpefK79eIjB4PUY+pl+PHmn77U30Lw=='),
			this.addDataEntry('third party highlight', 28, 28, 'Third Party Highlight', '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'),
			this.addDataEntry('third party non', 28, 28, 'Third Party Non-SAP', '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'),
			this.addDataEntry('third party', 28, 28, 'Third Party SAP', 'jVdNl6pGEP01brLIafl4eS4RGOw5dDOMqIM7BNKCOHpGHKF/faq6QWeSvJMsPNpf1bdu3brIxHSPXfCRnffsVJTNxPQnpvtxOrX617Fzy6aZGKQqJqY3MQwCn4nx9IvVqVol5+yjfG//zwFDH/jMmmupZ/TEpe2bYeKyz874szpmAr7nZVG12a4p3cvl9dqUF1j6/TeY/yw/2irPmjDblc3L6VK11ekdFnentj0dYUODC/MsP4iP0/W9cE/N6QPWi/LP7Nq0XyI4TSXwZHs6w2x2OZc5JvNn1ZUAe66AOOMsGWcwVNZmE9PRQ+Pp8ikmxrw7QsLuy4Ib235u7TbdNZekyhavJPdOn6FZmEVvm6y3P/Nj/slq58bcmSyOeUUX2/P2rXB3ppjRitzCeiXCxLnypdNHLn6oyIL1eWvsycuSqnFhNIcigP01tWhtHam530e3g6BeJ4tFc9ku56R8mzcvy2eyfduT0OAy7yngDN85Ye78D7rgZGc6bWrMLjuT/qCL5/e0EpIvb4IlsR3CzTxZnaN+PqOuLQvPF2U/l0Uwu4Ub/rkLZn1UzfutQU/MvYnIyy/Uox1zDxCbiBfMDpEkd3Q/t8H6mMv7+Pkl6M6743qfH4o+3byetxub0ODxe72xz8WCzej7Wm7fnpM8eKq3q9l1/cYbWs1tVpOK1asrk44NY0uP2ZV7K6LWExj3FuEyBpZFh+yFtSOjJTC6iWf04FcvVVqXgf+HGwMezYlIjW6fm3gvckU//3MPxNsZ22NurLFCHa1+AtPPFbfS5PLsJjdgq7luN0/9q/m83wZNs3uPv+wArg7bzVbe70m6W/r2eqLB9rwLbph/v3NFHS8PFQ0QN+nZ0jK5l0Ot2JUd/Q7GUDtn/L5RzxFs6ZCw9g3uOjKsD4RvWAf5TyPYF9apRT3/yhNhUw84S3L7MV5deX2wC+CSJVSmEmNZN1bTFtQp9T5GwmTcr8dLL7+yWvRpT6AG+RQwwH4B9xGIExu4nyWrPlxahEkBa9RmuFavjMdc2uMc95il9nsHo6gI4F1Z0UogfskD1g54BHPVmuQunEn8XmMasTGyrn07rPM+TRBbLnhv9by/8wNnqQH3aZ6O7Bp5wBXeWzsqryihXZhQwI35AB81kzjm8iARM69j5AS6ksBZX2NOYh3DixUeiGmnSQrfQvDKsqCrh/shdwm5VNYt8p5qpmLkpsKyJKpGYR3bkBvoNu7YxjdgzaReinggd4zjY20k8Iqc2FzyGvAYkeIjV7UCzKbGw0ydU67xyVThYl6KuG68uvOi71N1OMgUOUtSvE+NoQZd5FomQ168lUyRD3AtyMP4oj3gCOpR+10M3HPACdxDrzy4h/3Qw3C/zM1UIm9Qt6U1jTwVS0YJcisswAV3piasWeBjSouRxoPx4UNvTO1xIG/LYB6Xqj8k5oo6B3xeOlU6BV1DPgbExt9E8xMPmvaHPfF0PAM83MBDbKZydKTmD+pcpzCv7uy4C1r0GOLqeII9QsFjEJvWN/KgtCNjrX3ULerX85WOQQ+dylPV/NBFKq+Vyd/PnEF9eII48X7oxR73sA55Vjr0KGpkyisCWBgBHnDdxHu1loTJH2cwPjyF7mM4Q61owVS/6Zyp8gUm/emIOR3yx3i4h3nU/PuecQyKw1p3Qz8L4K4H3bdao+s9cDUFP4J+A49GHWgNKy2GyXCfdNpR00Nuox4RN2pb4x77ZYn44kH/6lsC562++zCMn34kiUCddsrfZGyjT0UeYlf3TVEvDM9VVhdhvgnrtB5j9DnyRX8DNuRWadAGD0YtKC8FzxrycsS3PVqj/9hzvw9yyVB/Ensqh/sF9oz9xS8gf3+q/Qh7GfqqZrjHYP3DU7R3Qh2SZ/RV6IOnvdKoeh443cB7R13Qa80gjxy8D72X9dECNAd9DJ4hWK346LLB90AHErSD2uy1d0ItlHeOveD3sA4eRQknwsQaMYONtUSvxjrKr3rl7j3OL/XK3b/p9e3cIjbgiYzPHuQLYsH5eOS11biI7tEA82QWw5qjp6NWPNoqn0iUPg3434C1B08HnaLnVRiPGqNOdb+BJySjj2CsXGvdS5WPa12kqNXBj4jyjfFZprQG9WagRXjG9ErzXjr4CcZDP0PPwZxzCb5s81oMuFaoPfCuBvEZoCsTffGB77t3KX38GyfLwbcWqX52BgK4Bf3XTz++/Xf5GZrwf1Za+BfdnA9/4uHvc9n98kVATQ1vAUF5OpbtRw9bblXR7oeXgZ/61L6sxL79Ppdd9FjcTz7eKuDH8GIxDh8vMGrt2/vNXw=='),
			this.addDataEntry('tree highlight', 28, 24.5, 'Tree Highlight', '5VZdk6I4FP01vuzDFAacaR8VbMUioW1RG98gMHwFsQQE8uv3JkFnZre6amvmcatMSe7HueeeXKhMdLPs17fgmuIqitlEX01081ZVjXoqezNmbIK0LJro1gQhDdYEvX7inUqvdg1u8aX5LwlIJdwD1sbKogx1M7DRUKfBVTxmZZDA//Ie35qMBswJwpi9VXXWZNUF/GHVNFUJAUw4lgEtklvVXiKzYtUN/FH8PWhZ8xPCgmWJyGyqK1iD+hpTQfp71sdAbykLLh5WDSxxlDVByGKzrt9bFtdg/vLXI1KUCJpgoi/UFr3W92SCln0JDZtvG4LOw9IIT31L+dUI16wNuJYFm3eNWtXd0SM9GmY6HmZ3WtI79oqZu5+ruMFO4vW0Di94bpepFm0WX51hDhm0jThuQ317cbjdYWtxp/r5YmdLFJyO+q6cG297e3DywsCWzXFuc9eiyPUOHHtb5nhJ4nh263pJh3M8wDII92fEwz0uD41rLgYCC5vGzBV8IM71bES8FSc5zezNmdELuYbImNv5qsV7OwlOu7ld9Gl8Og4ffAUx0fW8ea8ED2KCf328nlGqif1nuG+Zn8fr1TfbXLxQ/X0Wrg9JtGHd2YO5WR+NyJznVMfPOHNXtFTfdbFOtFBfND6a16Fuf7X5ovPRMfV5M99mxPC9emvuZzyyXr8B7p2a0zxE/Z3mVY4tamCelq6ulbaepm5XJLbV3cf6cI4jAlj74nw6859YClsdnGbM/9huaPlagPptZC6vZ0vLdqBKbK1AoQWoUfTQeQcnZOBcy3C+E7ZBqgFxZ32bnteMhZf3Y1gyjcKERB+EUUY6/0SYh2ZHig7ZL7VhwXSJzhMf9SkoM7cvRMOmff8sLkTnkqKjOIUeuOTh+pWLWqAi7F9+7lZkmfN/d2cZSqdB+v+pyAtdv2qBuSyDU1+/7bdTWnaVra2uUK2APYFZbAlPauwdcyfHmmMtaif3YVZXsBINbIaT21NYg3o+tJgnrWu9IzwYU1LizjENTkytxTDDJN81Ki6ZOXtjwJlYWkv2BseDBnk7yCeV4+GWeOccYiC36+AfKYxVM+bKeODXyPrjnngHgc9hb7gffvPkIHGMHu8hBnrCHDeKv8wdoP6UgE9xLyTHwBwx9oburiWG5Ko4yBqKg+TrC74I+unxKVHc/396TckFMJQGDckkViN7tRaqTr7qVW1Yut87OVU6nzBg7Wpsdqqe+N7J3hLgfBC85bPo24V4svEB64B8LvQFnfdQMxt7fnISGsMCro8eoSeOtaQXdl+enaipjTpLboYr+xp5y14f+8NTN9di6KE5ljV3o9birJ+1VC7wH3V+nCN316KvFDBW8H6lEoNw0ScV88ZdyBc+V8yAJ2tzx4Jvt0fFOdQQMxNzADhI6BBlGg9MTWnyZ32dsJiz350Bq/it2Qes7g9nH2GktPAHQyd7eAeEXrwQmo56GYbUUS6pYU8GsFlC5y1S77k8l8DzEpFbk72cZV1wBo2BNx1AZ7WX38YtxEL9fAXfSAo5rBLnhnOJBzqqWYNc+X8qNDmneN+J2tyF90TGXXzpDyyVO2IAtg128FkrqIlnUFvh5dJfjbkKg1WZw8fvPe/kHeMtEbcz8VuOVzi4VMX9p9dAaRrvgOu4KuPmNkBIl0VNOl4FX1RWGmdJOmYh48tMWYNaWZJn7o9bJTyMF8vH9scFVvp+ud/+DQ=='),
			this.addDataEntry('tree non', 28, 24.5, 'Tree Non-SAP', '5VZNc6M4EP01vuxhCgvYjY82EIwHiTjGduAGguHDYFwBDOjXb0vCmZndStXWzHGrojLqj9evnxqihWrUo/0e3XLcJGm1UK2Farw3TSef6tFIq2qBlCJZqOYCIQXWAj1/4l0Kr3KL3tNr918SkEy4R1WfSos0tN1UzYY2j278saijDH439/S9K2hUuVGcVi9NW3RFcwV/3HRdU0NAxR2biF6y96a/JkZTNe/gT9JvUV91PyCsqyLjmV1zA2vU3lLKSX8rxhTobUTB9cOqgCVNii6Kq9Ro29e+Slswf/njEclLRF20UNdyi57be7ZAm7GGho2XLUHhtNHi89hTdtNiu+ojphTR9lWhZnN31URNJl3Fk36nNb1j/6J7h5WMm5wstZdtfMUrp86VZLv+051WkEH7hOE+VndXlzkDNtd3qoZXp9ig6HxS9/VKezk4k1teNGw6DJcO80yKPP/IsL+rXD/LXN/pPT8bcIknWBphgU58POL62HnGeiKwsKHpHucDcZ7vIOJbjJS0cLZhRa/kFiNt5ZRWjw9OFp33K+cy5un5NL0xC2KSW7h9bTgPYoDfPt1ClCt8/xnuSxGUqW395RjrJ6q+6rF9zJJtNYQ+zI190hJjVVIVQ5zOEnOdpdOGJfZqcM/kHturySs2U4icxvOt1jGtkRyGDPtY/+q32bfDuqfqfnS2bQbYd2osyxiNd1o2Ga2T4quJFddYL/E0ZIQ5N2/arBxzuM884Dx3BdECQHLM8RKeQ/YDW25ro7NeBW+7La2fL3AKfWJsbqGpFHtQJzUtUGoNqlxGUGCAk9JwqRS43HPbJFSBuFDd5aFdVfH19RTXlUJhUpI3UtGKDMGZVD7STxQdi59qw4IpU2J1nQVozEGhlXMlCjac+2dxMQprik78NEbgUsb2M+O1hELF04/d8ixj9e/uTK121Dz3JuH/pyJP1H5WImNTR+exfTnslrQeGkexblDtAnsCM9kTlrXYP5VuCdqb69YtA5hZC1amgE1zS2cJa5LPxx6zrPfMV4QnbUlqPLiGxoih9BhmmZT7TsZlunvQJlzwpfTkoDE8KZC3h3zSuD7uiR+WEAO5wwC/SGJY3Zwr4oFfJ+rPe+IfOT6Dvea9Bd0HB4GjjfgAMdATZriT/EXuBPWXBHyS+0VwjIwZ46Cpni0wBFfJQdSQHATfgPNF0M+Iz5nk/v/Ta0mugCE16EghsDrRq7mWdUprlLVhqcHollTqfMaAtW+xMch6/LsnesuA85HzFs+8bw/iyTYArCMKGNcXdD5AzWLu+YMT1xgWcH30CD0xrGQjtwfi7HhNZdZZcNM80dfMW/T62B8/dPPMCj00x6Lmftaan/VHLZkL/GedH+fIPJv3lQOGBe9XLjAI431SPm/Mg3zu8/gM+KI2c034hvuUn0MLMTqfA8BBXIekUFhkKFKT3+vrjPmc/eoMmJdfmn3AGn5z9hFGUotg0lT4nzIIvdiFazrrpWlCR7GEhiOZwGZynXdIvufiXCLfz3huSw5illXOGTQG3nQCneVefBt3EAv1Swu+kRRyqoafGy4FHugoZw1yxe/5oog5xYeB12YevCci7hoIf2TK3BkDsB2wg8+0oCbWobbEK4W/mXMlRtUULpu/92wQd42XjN/S+N9mvsrB5SodP70OCtN8F7TTpk679wlChiLp8vlK+CSz8rTI8jkLaV90aY1aack+cr/fLuFhvmA+tt8vssL30z33bw=='),
			this.addDataEntry('tree', 28, 24.5, 'Tree SAP', '5VZNj6M4EP01uexhRAzZ7RwToAkZbDoNSRpuYBg+AiFqIIB//ZZt0jOzq5ZWM8eVYgXXx6tXzwXyQtXr0XqPbjlukrRaqOZC1d+bppNP9ainVbVASpEsVGOBkAJrgZ4/8S6FV7lF7+m1+y8JSCbco6pPpUUa2m6qZkObRzf+WNRRBv/be/reFTSqnChOq5emLbqiuYI/brquqSGg4o5tRC/Ze9NfE72pmnfwJ+m3qK+6HxA2VZHxzK65gTVqbynlpL8VYwr0tqLg5mFVwJImRRfFVaq37WtfpS2Yv/zxiOQloi5aqBu5Rc/tPVug7VhDw/rLjqBw2mrxeewpu2mxVfURU4po96pQo7k7aqIm00rF0+pOa3rH/mXlemsZN9lZai3b+IrXdp0ryW7zpzOtIYP2CcN9rO6vDrMHbGzuVA2vdrFF0fmkHuq19uLZk1NeNGzYDJc2cw2KXP/IsL+vHD/LHN/uXT8bcIknWBphwYr4eMT1sXP1zURgYV1buZwPxLm+jYhvMlLSwt6FFb2SW4y0tV2aPfbsLDof1vZlzNPzaXpjJsQkt3D32nAeRAe/dbqFKFf4/jPclyIoU8v8y9Y3T1R9XcXWMUt21RD6MDfWSUv0dUlVDHErlhibLJ22LLHWg3Mm99haT26xnUJkN5gdW9swFdcbMlwel1/9NvvmbXqqHkZ712aAfaf6sozReKdlk9E6Kb4aG8jJVIf37W9u7rRd28Zwn3nAee4LogWAZBvjJTyH7Ae23NZG51UVvO13tH6+wCn0ib69hYZSHECd1DBBqQ2ochlBgQFOSsOlUuDywG2TUAXiQnWfh1ZVxdfXU1xXCoVJSd5IRSsyBGdS+Wh1ouhY/FQbFkyZEqubLEBjDgqt7StRsG7fP4uLUVhTdOKnMQKXMraeGa8lFCqefuyWZ+nrf3dnaLWt5rk7Cf8/FXmi1rMS6ds6Oo/ti7df0npobMW8QbUL7AnMZE9Y1mL/VDolVhzQ3ykDmFkTVqaATXNKewlrks/HHrOsd41XhCdtSWo8OLrGiK70GGaZlIdOxmUrx9MmXPCl9MTTGJ4UyDtAPmkcH/fED0uIgdxhgH8kMcxuzhXxwK8T9ec98Y8cn8Fec9+C7oODwNFG7EEM9IQZ7iR/kTtB/SUBn+R+ERwjfcbwNNW1BIbgKjmIGpKD4Btwvgj6GfE5k9z/f3otyRUwpAYdKQRWJ3o1NrJOaY6yNiw1GJ2SSp3PGLAOLdYHWY9/90RvGXA+ct7imfftQjzZBYB1RAHj+oLOHtQs5p4/OHGNYQHXR4/QE8NKNnJ7IM6O11RmnQU3zRV9zbxFr4/98UM316jQQ3Msah5mrflZf9SSucB/1vlxjsy1eF85YJjwfuUCgzDeJ+XzxlzI5z6Xz4AvajPHgG+4T/k5tBCz4nMAOIjrkBQKi3RFavJ7fZ0xn7NfnQHj8kuzD1jDb84+wkhqEUyaSjx4B7he7MI1nfXSNKGjWELDkUxgM7jOeyTfc3Euke9nPLclnphllXMGjYE3nUBnuRffxj3EQv3ShG8khZyq4eeGS4EHOspZg1zxf74oYk6xN/DazIX3RMRdA+GPDJk7YwC2DXbwGSbUxCuoLfFK4W/mXIlRNYXD5u89G8Rd4yXjtzT+285XObhcpeOn10Fhmu+CVtrUafc+QchQJF0+XwmfZFaeFlk+ZyHty0pao1Zaso/c77dLeJgvmI/t94us8P10z/0b'),
			this.addDataEntry('user highlight', 28, 28, 'User Highlight', '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'),
			this.addDataEntry('user non', 28, 28, 'User Non-SAP', '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'),
			this.addDataEntry('user', 28, 28, 'User SAP', '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'),
			this.addDataEntry('web highlight', 28, 27, 'Web Highlight', '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'),
			this.addDataEntry('web non', 28, 27, 'Web Non-SAP', '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'),
			this.addDataEntry('web', 28, 27, 'Web SAP', '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'),
			this.addDataEntry('', 48, 48, '', '7VfLcqtGEP0abbJIIR431hIBlnGYwRIgGe0QEDQIhMqAeHx9ugeQfKvkGy9SlU0WrmGme7rP6Zc8M0nL29VHcDmSIoqzmWTMJO2jKKrhK2+1OMtmosCimaTPRFGAv5n4/IV0zqXCJfiIz9V3LojDhWuQ1fFwMhyUVZeNB+UxuOAny4ME1mUcsSo4ZLFWlps6i0sQ/f4bnF/jj4qFQWYFhzh7K0pWseIMwkNRVUUOChkKlkF4Sj6K+hxpRVZ8gDyK/wrqrPpkQc1Ygjer4gKnQXmJQyTzF2tjgL3kQNTpVJhO0FRQBTNJHbbic3lNZuKyzYGw9vZCxX23lA+7tg57gQUvGyHUi6slRVLUKRLplGuYh1eSqg3RFn2Uh8x82V/275F2kJKFyYTGSr3EctWaOmpna2pHO1kmvc/M1TELdlER6QIjaVjbOhFNtpSC3UYI+FnC3pifxivjD81RE8AixLs2M182SrjyFuZ5k8Uv66sv0d5M5TqU1o35UiahtLmG2jw9iO01TIskzCP2p27MqdMkxDVkCzG43sXulgtTU/pIN5K4W/bRatFYO3o9rBadzZbdXjQL2hulqRsd3iF9ONzRmyv4UA4rD+L0yqjsu+Xr22qT7c/k04nmtmWwUzL//fUlzJ9PwW5bR9ryfPt+3tbB+6Z/c17nobjtPGl59MXt2yHb9nvHTGLXXJipObdSUyYd7HW+762UdJSh3IA9qanutRA3mbgQMyY3pD9BbLMT2F1CXHJTOh7t5oR4OEdzRUv/naJf4K4yq/8nHQPsLfL9mWY8V455veVlfXqyxPZyyLfH8BR1/m5z2e8U4SZ3m+t+tc3Du4+ncPUsBNoyD3ZtybnnTWEKxgU4IGZKUqO2XaOFuIvAvSU5cOx9ydTVhDiyQPtTTdy1aOomrESy0nVvrwyIk59QRxa5nqbCfVIT3RDuq1cTpmI8Ud6A/YTfhdxaqdHTDmWegnrUPU061ScdBbDA3lQgziJ1Q/j2FQq+4KyjmoBrQxnufcXWBLADtZN6LWEoM1qqyQpgroCHTPQE+XRE99HO3NbkznZNlAEWWSB9UoGfFuoOckzksEMba24X+Vsu8j91loO6xyNwlwAncAjlKQaWa0DsvB5X6FHR70ZMPI4e+D21hNtVBeJM+IUBP4/pV/EQhnicEXsIOWoqwNzbEBPSySJx9yn36ULl6rDqULeAl+qmgnvqEsFyCfT8CWMwJ/0G8c9tZ8rBhP8zxyT5Nkc9nFto10W8CcSWc1QGbsZ84BrOifAVRw9mBfaWIfu9ihxF4NdSyNVUg5iTAR/WINYE+E1PAsROGvyYEvD52Z9ojNjBH/CZ6hBsSnSoC6yH5FEshnq/5TsdMPH7yFcBP929liEXOsRUA6yOCpjW87udIV48L67XHvSwhpkhYT4o5DLiPLxv8fZd4MF7yv/Mhdf0VOOPcjZhGHM2X7tD/EfezdDrMHMd7BfMx/YRXwF8T3ynHhB5bNnNBsQ9aeyhRxvqqA/mxFA3uNq6Kv8rc4Kpj/J8y++Qb5oONWoO9cr7xRDu9Trh5vXDczLWGZyNc2/ow9u8gH6WkTvasvWktbg/A+eIaOvY735DsD9gno49xfM65qshKa9BiDk/R4yl5fpga63gHKWuKvlQDzZ+w2zGGh/mnyHa4Iv2a+QmUn2NnHHWIIYG5jmeN5RjnO7AjNk1MOMTAXLeY42SHGd+CLPeB4zh55pSaM+xibabjbUg8Frk9ZCuBcvhMzlBrpxj6klxLmAsepxzMM869Il9BH062lar0TZwNLubDOM11SHM20GGv0th/1hH/Y4OcD7B/0zQF1hbg2zEpE5c+X3L+YWOxmUT7oc64/1f67iffb3+cKEHYb4o99/dh/G65QLy1hGmPtQZZMLI96FO9R2db/j6j/L3+uPg8lqF33YV+pLIMNv/j9cv4mWyp/t/x0+WBC+LXsbHkrQcn1PwkInbL59k/Gh8j63iIo+rjw5UGhZVx0FDfhpuHWOWHKufz4Jy2Ce3m/f3HXyMT7xpe39KctlPL82/AQ=='),
			this.addDataEntry('', 48, 36, '', 'jVVLc6M4EP41vuxhSxY4kxx5OLYcJEwMseHGa2RAGJcB8/j12wInmdmqqd2DS+r++vm1cC8Uo+w3t/B6plWSioWyXijGraqa+Vb2RirEAqMsWSjmAmMEvwV+/QO6nFB0DW/ppfk/Dnh2uIeiTWfNrKibQTwU9Tm8ymtWhhxOPU2yJoxEatT1eyvSGqC//wL9Pb01WRwKK4xSsa/qrMmqC4BR1TRVCQZCAnoYF/xWtZfEqER1AzxJf4ataH6JoImMS8+muoI2rK9pLJv5mfUplK1PhWifWvSpkaHCJlwo2izi1/rOF1jvS2jY2G8ZDgZdjY59G48oC7fvKDaru6UkSjKsFDqs7nEZ32muddR4GZMyzsg2uAanxIgU/kIy1Fm5xy1Xa9lBG2xDG+iB8HDzcQ3wGe0PZJITLIpkA/Y5UUmulkQ5n+2u4MTsx2Qr6uCgo/Ski/1hh4LTGVmYjfFAoE7rwhA19B9ky1CkaI2PX+pIIU9ku7v4Ge+Z69XEXPe20XGae8s3t+Y/D1obK05PtjWPlfd7bCzzCPf3OK94XCbZmxn3lqH1NJM+VHn4PFsKQ+mxF/vMz9PN+ofh9kVwDMYv2Smeo41og+Pr8K7szsFGiOji8ODr/v4RlQJJJpMTE7FgnX9kwsWrjxh7wFwxTIwM6kjzAmQu5Z6BzMYJ7yVu5Y4qWUvNtWSspSZdkUy/BibKnINkZZcx1Xfrnaxo7lDPo83rKDND5x3Jnv/bqoeY96AMxuDkQJ51Zo1fk9ntjZc6PK6Ef9pt4/K1CI8fbWJ+4c8WfhfBhf6SZb/VzzBjHpSijkzJwK5+M5j+Bp3Iyl2XjBbM3z6glh1pD/eODlpHTOgw1zB03dsHDWy0Dt6RxJe2oaoUcNvUBpiytBvlyUaOv2XAXW9M8jUw5yn2hnafmHVQETXXnGbqQE2/oQd5Ug4T6Kh5dmnutMwsIDaZ3jG8BvDjq1n+IGCnUPc1t9zPXFrzGQvq7egBPepFcz9L2kxx3HiKC/mXUAue+v7wwTbuqfewydQlMx24ayvoG/w9sIs7mZO5nEOtS2p6EofXoMneZB75nc1xJI+nKwN7lWYSp4htZGyKwaaTuW2TyteD4Y6Z67fU1VaRWbQMuCUmyFCbP6gDfEWAOZDfG2zJkVsA53Iu61U8QB15IetQZj7WcCe97XUDM2ReZ0kxfeAIYsaS9x78Qbfu5LzpSFSpo6ao4Bxtkz1F7noFvlj2zkDH8iS38gLB7Kf5MZNI/hAbHckFojlp5nN3ZNNcg9pyOczeh3l5LXNjeIcO9EE4MyBXJuNo4IugRoKAb+AgyCGmwnKf02lmXj/VDH1aruzXGWauAirnbJsFf+TCwB1wwkd/1Phc52+1/evcPf32Dcr/FhyMqlweiv5YL/DHnvZ/XFGT6rGfNmlVps1tAJMuS5rzbKE+z17nNOPnh5fyNOvCepb5l+f3voPLY+V9it+rdcJ+27z/AA=='),
			this.addDataEntry('', 48, 48, '', 'nVZbk6pGEP41vuQhNQImx0cE1Nkww6qjLr4hkJGbWAvK5dene1DXkzrJSaVqt5hLz9fdX389zki3inbxGVxOrIzifKQ7I936LMt6GBWtFef5SCNJNNLtkaYR+B9p83/YHatdcgk+43P9Xw5ow4FbkF/jYWVYqOouvy9Up+CCw6QIJHxncZTUwTGPrapaX/O4gq1ff4H1W/xZJ2GQu8Exzt/LKqmT8gybx7KuywIMctyYBWEmP8vrObLKvPyE/Sj+M7jm9QuCmScST9blBVaD6hKHmMyfSRtD2DMViPlYJY8VhArqYKSbw1SbVzc50mZtAQlb70uuHbqZcdy317AnSbBck9Aub64e6VE30Vk3uYVFeGOp2TBr2kdFmNDl4XL4iKyjLqc0IY2bbqUrzCvfmB3vjIknMslSmdDFKQ/2URnZJFHzZXQ5LNfl+4Y+7JL3xE/jhfO7tTElxELifZvT5XoSLrZTel7n8XJ183Xe09S4hvqqoctKhvr6Flrj9Ki1tzAtZVhEyR+2M+abRjLhGK4FcYjtxetmU2pN+sh2ZNzN+mgxbdw9vx0X085LZt1BoyXvnYraTodnWB8OZ+zmBj4mx8UWeHpLuOGL6u19sc4PZ/ayYom2CvaT3P94W4bFPAv2u2tkzc7P8Xx3DT7W/fvmbRxqu26rz06+tns/5rv+sKEyFnRKUzp2U9Z4FsxtNe/ddDXmOBcOzNmV2yGhycxgAnhMjIb1GXCbZ4A7A14Kqp9OXpNhPCpHuuCV/8HRL+RuJm7/MxsH8KbF4cxzVasNvT3rssq+uVp7ORa7U5hFnb9fXw77CXnui+Z2WOyK8MvHt3AxJ4E1K4J9W6nci6akxLlADhgzZ2l4Zbbfuhuj4ek8dVM6YZ3ReQJzZYab+g3MCevlFdbaSHFEG75wWuBGg3qBnS+ZZTYwroE/g1ugJztKARNq719ZmiG+xuw7pnDA5wrP954jNdBsyzRWqznggK3u2VuYO4R3BOxMAmsQw+nE4MsT8+7bRL+I3Xu2D/aZwcf+RNVwzxCn5yn4Fysd/XtiNfjfqPgqz8Jzq3r4csTuoG8Am44f2FTlEg6xLWQLNi3vD8DTCniBnC1DZ72DPjTlX3F1+u24IR3EMeadOXwLWXuKj7wC/2NuZ1cOcUWoqTRsfUHhC72aQJwb5BL8b8jVs2mLHHsi7Kn9QxuIN4O7wTBY+kYhF/A//5sPh7ipJN5etjxBu/lvQjhwV0A3d2YL9TI8AZFYBPjBeJ3Ow3FPJ0M9IQ4hse5jnhCsZz/ogig+MT6oZ3evUXnn8yccyUEXCnOYcyHJoAHkfNe7yLUdQhysHbBRg1L3wS8DfTJBsZYd1BCw1JhAvohLQrTpt6idCcc4BetxHFjEwJwGvWVY5xo1xVLU2wrzQ22BDvDLdPZxwboZzJYSeOqYyH+Ul/5dXgL7xmmxj7AGgI33CmDCvohQZ62ndOZMXnTWYk5cOKqnWA89hfpNvrQw9CP4eWrUQeyX3nvqr3QFxNHL3n/WyIT90FD1E6vxswd/2ler+sXnEFv67Hf5pQ/W+p3q9/p+h2C/P3pa9fAjhzjDGkj9X+6cjr3UG+NB/lCTg4b8Xulz4KPztk2HGBCjgf5A71APn/y/O8p5vaPU2Bd3nof74aseYqU0ygYcuBcQ29QVxz3Ffmg9O0MOCHLEQMeIpWIZ+H5iQa7kfi/toYYG9s9LPxKlYdWPK5U79qOwfbgfsgePp7teULfaj+8vhroaD3z6yDn0l3/vbdhfll+/Tz3+7h7O7xJfWPg3uz/D4AEUt//4lFNL93fcIi6LuP7swKRJovo0WBjfhlOnOJGn+vu1oBrm8nny610Ig/vT8DH9eoKqve9eqH8B'),
			this.addDataEntry('', 32.14, 45, '', 'jVZbk6o4EP41vuzDFnI5e3xEQM0sCaNGHXxD4EQQxBpACL9+u4POzG7V7G7VTJF0+vL1190xE8Mp++V7dDvTKkmLieFNDOe9qppxVfZOWhQTXcuSieFOdF2D/4m++OZ0qk61W/SeXpv/Y6CPBveoaNNRMgrqRhYPQX2ObrjMykjAd54mWROditSp601bpDUc/f4byO/pe5PFUeFHp7R4reqsyaorHJ6qpqlKUCjwYB7FF/FetdfEqYrqHc6T9FfUFs0XD3aRCbRsqhtIo/qWxpjMr6xPAfZcAbGfUu0pQVdRE00Me9zqi/ouJvq8LyFh53XF9KOcm6dD38aDlkWrjRa71d03EiORlkGldY/L+E5zu6PObEjKOCOr4+34ljgnQ8xIpnV+vhM+t1u2tSV1zI7ynaC5yMjyXESHpEpcLVP7VXI7rjbV65Y89bLXLMzTpfeHs7UFYNHSQ1+Q1caKl7sZuW6KdLW+hwYbSG62sbHuyKoWsbG5x840P+n9Pc4rEZdJ9qfrTdm2E5R7pu/YkvHdLZDzGXGsIXE9kcr5kCxnnX9g99NyJoNsLo86qdjg1cT1JNrQIR5t3O4OMazTcgc8vWTMDHn98rrcFMcr/SJxeF9HB6sI315Wcbm4RId9mzjz68d6sW+jt83wun2Zxvpe7oz5OdT3r6diPxy3RKSczEgOeHM6sAz2Lu5J7+dxp/bcgz1tmRtrJJublAOPW3NA3siyuIDfOfBSEuN8DroL4lE5kiWrwzeGcSF3O/OH/9LxwN+sPF5ZoWq1JfePuqwvP329v53K/Tm+JDI8bG7Hg6V9nPPuflzuy/gzxs94udAiZ15Gh75WuZddRTTvBjkgZkb5paU8bvzc61npQb5Uhxq0dAgFdewO1sLPiU6lqTG+yf3cngZbs2fS7AI3Br0d2NjA226gRijZ1pTUZTnYog/dB12akxZqa8J6YO66DbgwQg4x+FpQ9KXi2LDWwOZiYA3o1ka/UmFxyRML4FybLAOfbkKgNnLE/J0e+OO2oc6+i4U1HBa5j7hztCN6oM7WGsh0wA4yqjFHU7j3OfCV7/RwsFGuKyx8B2uYDKnyg/VloFqHeWjKF/f0UJqSKVxEA70p4yHam8wxzUDZwHopepxFxo9nxEolcuANCq9j90TpEsAmtLTUGgqxGRcCvhrlCxI4JkznogbcU9BpGV9bCfZs7k1DTtrA3aGuCXfDBwdsoCbyE/AY4kCdkEP0l33qBK6tQ3493imAx0I96JsvXF+mEFtiTdA2OHTIvwU2HX0DO8DN+KICnqBGiwPoyICzH5yvAaMNcT3Nz4UVLGkH2C3oIY26oqH4hfuMqto89/tq5I9BL4o+GDFATQhgXBsjZ0SyDL9rqXJ1TItyrOO6A33V44GjjXrPvSem2E/BgTZPvz5/+N1i74fNiEN9B5aff5w4cDyInkBPUx7KEOufe8gLcL4Dfx7WGusLvFIT42HuDHsI+ysPcf8xE7HEXiED4ID4jx7MLybTsceRd+8fvK/hblJcYv9CL0BdXDVzcC8BJvcyYh9gTl1hbd0d4H3oQl9Q1x77P8f+hXsaYsL9hrIuOPxbTMCWX7QQ8eIduVU5qTmhIGOPmcE15DWNpboDGsyLqXyRY8jrQHE+LYUHeypXMwe/F+HX2cRZ6Gj2vA8+ZkELXJwhr2NG9XmvDvh7cby+CnwZ4N/88XyAH+60//YJokSP98cyrcq0eZeg0mVJcx41DP33qTkantNMnB+GpjXKonrciw/jzycNLB6vmuf28/Wkzv72uPoL'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 38, 48, '', 'rVZLl6o4EP41bmYxBwFn2iUCanoI+EBt3GHgxiCIR1Aev/5WJdjdM+fcM7OYhYfUM1VffYkZGXbRLu7x7UzLJM1Hhjsy7HtZ1mpVtHaa5yNdE8nIcEa6rsFvpM9/YR1Lq3aL7+m1/i8Bugp4xvkjVRqlqOouHxTVOb7hUhQxh+8sTUQdn/LUrqrNI08rMP3+G+if6b0WLM69+JTmq7IStSivYDyVdV0W4JCjYRazC7+Xj2til3l5B3uS/ogfef0tg5ULjpF1eQNtXN1Shs38EG0KZc9kIdZLq700mCqu45FhKVGfV08+0mdtAQ3bq6WvH7uZeTq0D9ZrIl5uNOaUT89IjKSbGLSbPFnBnjSzGmpP+6RggiyPt+NHYp8MPiVCa7xsx73Qevhbqw9sU6M9477DBVmc8/iQlImjCSkvk9txuSlXW/LyEysRZenC/dPeWhxq0dJDm5PlZsIWuym5bvJ0uX5Ght+TzHwwY92QZcWZsXkye5yd9PbJspKzIhF/Oe7Y3zachq7p2Vbnh7tb0M2mxJ70iePytJv1yWLaeAf/eVpMu0DMuqNOSr93K+K4HcZAPSrGaZ6wx+S02AFO78I3o7B6Xy02+fFKv2nssK3iwySPPt6XrJhf4sP+kdiz6+d6vn/EH5t+tX0fM33f7YzZOdL3q1O+749bwtOQTElGx14WmX4HsiNl08suOhVod0GOHrR3eyJmJg01QYU5CZwIsM0vkHcGuBTEOJ+D5oL1yB7Jwq+iDx/3hd4t4fX/5uNCvmlxvPo5zopuyfNzLuvLm6e3t1OxP7NL0kWHze14mGif9rB5Hhf7gn3t8cYWcy22Z0V8aCvZe9GURHNv0APW7NM+evgONYhzedBsn9GtNcgucqj1MhfwwO+OQ7+d/xF1wBcjcOZnkDXaWZ2XrXviWJza4Lc1DRXHTHqgNdr8DvnFa5k72+leCLkzbgDWY/9KQW92geOCL2mDraZit5r0jTpN1gN5x/DT/TBC/yYIMTfEi8F/H7W0Q/2GUswfXjTirOEbQW3s4fc77mO9/bmiIfTq0FbqwS/qIDf0CX2Z4Pfqu/O35gTqBlx2MHcGPhR6M2H2RMqIEfIhyYg59NsQlQNqo5pvS9x02mGNVg/9A1YWyjIO+h0rvMweY6CvnoZU7QWYQB0N9u1npH7FQd+IRRs458oLGdTmTjyoJwgtxArxf+UaI87UuWgS760Ge8O5FDIn9taovFgf5uOwvuBdMKwBByeagK/EJHDWMg/0Po5gP7+/IB+MAGqUs5eYrRuYh6w/UjmREyqPrB9ywUxoyM2TQ7EXU/IMZrDPXAPPWrBrNMDFxHzURl7MdYr3Wc/bqLc4ns/A1mTfEv+MtwMvoAbkpfuNc+x/5tz6n5zT4dsGMHfIz9XM0YY+1jBzlKGvQzNR+GqakqnigJwlUzWqmrCPBmy1wkFyQuEIXFY5JWewHphvpDglzFbyFOetuIxn4Y8wHHAF7gH/x6DL5Gw/z6mcy7AGbJd4rojidsiNr/MMtkVTB4qPPJC4HDOwI84KL4nBCx+8R6VPL3mT7b5hjTaFdWhLnvc+3Cm+vC92w48N/I16VYP2qk/moi/cFNf1wEkyNXc5O+RV/TUHxRncj/WuOs8Df4ATpvQrGsR2Amf29QXcOO6rvjCvgRPyP/XFlc8cCg+cDZ6tDu4Yruri0i8VX/f4Sv13w78XvAuGxw08K9L2lw8kqRpeR4u0LNL63oFLI5L6rDyMNxV1TgU/D1HmoIsrJfPPyK/XFiyGB9dL/HrYSdvf3n0/AQ=='),
			this.addDataEntry('', 42.86, 48, '', 'jVZdk6o4EP01vuzDVgS8Oz4iMJpZEvxAHXxD4EYiiDWAfPz67Q7o3H24tVs1U6a7k+7T53Q0E93K2+VXeL+wIk6yie5MdOurKKphlbdWkmUTjaTxRLcnmkbgf6K9/yY6VVFyD7+SW/V/DmjDgUeY1cngGRxl1WWjo7yEd1ymeSjgc5HEaRWes8Qqy22dJSWE/vwD/I/kq0qjMHPDc5KtizKt0uIGwXNRVUUOGzIMLMLoKr6K+hZbRVZ8QTxOfoZ1Vv2SwcxSgSer4g7esLwnETbzM20TgL1QQMynlzw9mCqswoluDqb2Xj7ERFu0OTRsrVdcO3UL43xs66gnabjaksguHq4e63E301k3e0R59GDSbJg17+M8SunqdD99xtZZF3OaksaVe+H6Zs13Zsd3RsdlIJgUKV1esvAYF7FNUmWv4vtptS3WO/rcl67TQCZL5y9rZwrAQpJjm9HVdhYt93N622bJavMIdN5TadSRvmnoqhSRvn1E1lSetfYRyUJEeZz+bTtTvmsE8x3DtQCHv7973WJOrVkf245IukUfL+eNe+SP83LeeemiO2m04L1TUtvp8Azro+GM3Tygxuy83ANPHyk3Ar/8WC+32enGfvFYfluGx1kWfH6sovz9Gh4PdWwtbq/1+6EOP7f9evcxjbRDt9cXl0A7rM/ZoT/tqEh8OqeS9q50WpaCbb/snqPtO2CzmtsRoenCYD7wuDN0z3eA2+wKeRfAS071y8VrrohH9UiXvAw+OdaF3s3U7f9rD+ab56cbz5RWO/p46bK5vrlaez/nh0t0jbvguL2fjjPyivvN47Q85NF3jbdo+U5Ca5GHx7ZUvedNQYlzhx4QM2dyUzM/INQOapgBEnQGYbZTM7mfujJoWGpMPRv6lmbnyqvBLbOhltEy+1q50mw9y+hgP66nao56roHukHOvbfCzvwrgqfd2cM42YQ3zgPpaRs/6U+n6TgscQx1Tg/yEHxnkopir5XYA633nQV7mYz0BGGjr7QjkpQbkw7jG0baj3gU9oHal9uwb6MFpqU3hTrCe51gnmsJ81bzfC4Z9KNx7wjuC/bUBfDLfnLnYh7+HmKNxiyjNXcQjN+ALpjwLdMDaMZWTzTCn6nPIKaBOy3akxT68ZQM87nXPIjBLBwm+GUvHOk/swL/qTdXYwr4N7DEawABYFT8aXzaQE+J+IIBhOINcmPCdADxKAb0ywLTpQQ/i+RTiG23gSnEHPTiz0daY/QF9GQaXsQTMtedvDKhNMDfUIEzSCjXjMnrZkLsB7RrkGPhAbjroCbCZ/aCH6L95Q/1ePqiH55nBunH/Z1BB/YbbMeMpxq8C9J5xn8M8bNTsgG6gyUVTeOWh9FDbfiNgfwuzKUa7GuzDEfrWQGWGswf4dDzP7FhiX/BdUj1558A5YuL9qGWKmBziWaq31lPn1CwhHzhDOA8G6IE8jzw8OcD7YQ46W2S8I1hH3ZEpk9chl5oH1CH74fsOzCMF3cyWg3aezeWoW6f0RnwyQFsb9YB7IHC2AMsVZ6ThPdxHP5i6o7ae4hfrqrtbjfUU70xpIhS2ALnxlaZT3j3vIxlmbJg94B9478XMxb3yOsU7wW2YLcgDc/Xk7JtHP8AaDcwQYCQDRmnOVF4f9Fe9EsAYwT1gneLJRs6iDucGcan7A3MxzorKgdjGuz/0q+4BzO9n8f0d2uNvw+m2FvgKwL/F+FSAH+mk/e1zQ7nGt8YyKfKk+upgS5PG1WXYYWh/vv0YDl6SVFzGg8bb4AvLwRavw9/PF1iML5in+f1SUrF/PaT+AQ=='),
			this.addDataEntry('', 48, 32.57, '', 'jVVZk6JIEP41vuzDBALutI9cYvVShQdK41sJTFkIYshdv36zQLt7HiZ2IzSo/PL6MrOOmWYVvfug9wsukzSfac5Msx5lWU+rorfSPJ+pCk9mmj1TVQX+M3X1B+181Cp3+khv9f9xUCeHluZNOiETUNVD/gSqC73LJS8og6+ZJrym5zy1qmrX5GkFqh9/Ad6mj5rHNPfoOc03ZcVrXt5AeS7ruizAIJcKk8ZX9iibW2KVefkAfZL+ok1ef4tg5JxJz7q8A0qrexrLYn7xPgXa5kjEeKHKC5GhaE1nmjGJ6qpq2Uw1+wIKtjZrop4GUz+HfRMLhdP1TontsvW0REuGhYaHRRsXcYszo8PWUiRFzNH6dD99JNZZY0vElc7LDswLjIbsjcG3jN63dJXYjCP3ktMwKRNb4ThgDcm2OuKmRsOdQiWWMb7hUZa6zk9rbzDgoqRhn6P1bhG7hyW67fJ0vW0jjQiU6U2sbTu0rlis7drYmmdntW/jrGRxkfB/bGdO9h3DgaN7ljGQ4HD3B3OJrIVIbIelgykSd9l5IWnP7nLwuTmcVFQS4VTIdgbpg0U8+dhdCzkWZ/cAfXrnRI+C6n3j7vLTDX9DrKCvaLjIo4/3dVysrjQ8Noll3j7Xq2NDP3Zis3+fx+pxOGjmJVKPm3N+FKc9YmmAlihDg5c5CpGyLWVnDnKHudQ7Ut/gYKtB33QcQM+43mFxhd7mV4hrQl8KpF0ufneVfMYakUuq6IPIvFC7wT3xXzYOxFsWpxvJx1ntUfs5l+31zVP7+7k4XuJrMkTh7n4KF8qnPujak3ss4q8cb7G7UqhlFjTsq7H2oiuR4tyhBsmZ4CxqsDj00Heolc1xiBsiIhXZBsN7vSf2FfRMgF7Wvnh940H5jute8Jte34/77pJ5e13A3mLYUmDPGQPInR84NeSS64EIYksbwGC/xGBzUEGeQxzNy7BKpN/e6ImGIa6xAJ0KeSE30mGt4wLwzJH4gINrA3yHZ87GtxHkwYPvQK7M0CJh1PKLJXfbkf492EkM9itgQaQkXOoO80jaTPnEZONMXCZ+PZwfwK46WUViigtra7LFkpd9aPyAKV6AgFPUbwV+cetJsGWjrZB9ODACOUgguR5L4AD1XIEr9NFG/XMOOgnkHLYwF4gXOOrYZxsvvCyaEw69Bj+ZT+LEjrWJD/Q726r4I+ohxjgPbMHdYBu9nAMBTr49zkT2TuYZsE3+DoLtOEOIpUB8xXeZvEc00IVYxR3YaySLgO+2w3ull2fGt+QXddDbSXYY7Cc8h/nIWcMZMrpxj2SGAFyf7KS9Mdmvy6+zIeSZP902TN7u8mc+nwC4fNP+j8/ICD3fEDcti7R+DGDS8aS+TBb62+R1STm7PL009cfi5wTTaoLYp/PXswSL58v0Er9ewFH32wP5Lw=='),
			this.addDataEntry('', 34, 45, '', 'jVVLs6I4FP41bmYxxbNblzy8GItEvaJe2CHQMTzEEhDIr+8TwOud6e6aWVDJeZ/vywmZqVbROffwdsFlnOQzdTlTrXtZ1uOu6Kwkz2eKxOKZas8URYJvprz9wSoPVukW3pNr/X8ClDHgEeZNMmpGRVX3+aSoLuFNbFkRUljNJGZ1eM4Tq6remzypwPT3X6B/JPeaRWHuhuck35YVq1l5BeO5rOuyAIdcGMwwyui9bK6xVeblHexx8iNs8vpLBiNnVETW5Q20YXVLIgHmB+sSaNscGjGeWumpEanCOpypxigqb9WDzhSzKwCwtV0RJehN7XzqmohLLFy9S5FdPlw1VuNeV3GvP6IieuDUaLG14HERMbQKbsFHbJ1VukBMat30QF3PaMje4LjXdMKXlNiHBnuRgphZBqf8Gq52C5TuZDddqoQhGit5FjsQn2LuppmK9wh6WjOi+V61RpYxj9R3/ewcaLzK28CDk3GOWmwt0kjFbMt0HtsGTXqTx86idU/kcXYW/YaZfaCgEnsH2bWMDnu0QjaSyT77jlYSda9EwnsT9kQ6q0btK4vqrKJvaLW++oxCFy3FHhIxnPRjzFagXuVV4GkFUi+XTZvNA+dYRPxTXm+d7nYujpcoi3v/9H4LTrqEnNf+eNJv8Qov0PXIg4+1FzlvaXBYNMcPkgNDOk4lhvkSGEQ0sZFgBZjK5EH2liAfmo237MFXw8AFZpq8sZcMOXm23a9NlL56sbxu4AQ5pPI/CAe74Iq5/L98RL5FEVxJHttQY48eW+anibP8bu2yuav8ivHT7rWPf3EyB4xSaJlFeOoqyC9HRVsiaXkDDKJnglO/2dgH7u412QfsG2/XIThTmCAZp1lDUpgee9cQ7stwHg22kY7sZYOBm3HNJLGKHMI+8PMp74Y1TnHnprsOF7gdbFAD6imER0Md4mU1cNlCLkosTSMervFe68GPwsoHmWk6zASd/OrJb5JzRJjGN/b6AitMpqG4adQPOGD+XG831vTG/ne91hE7gtsB/fMRO7KxDjGc7KXhBpFeUzfe+2nKm2JLAgwZzC30bUf11LfoT4c8Uz/E/F19ZPtQh/aiTlJIvZsinVjCh2qCE3fKCXpRvxtvJ/TBwceDefSoBj4S4AefHdwP6cmhim1fcAVzSMEWtSSjkNeXiIJHmRmtyAHnLL/y++rQJ8QO58Keuf1uY414xj1wlx60zcrneKi/vghfyAkYdsqEr0WWpsAdpwM3PEi/5IQ+o+6Va6gLvpcS/mTQk6H4/YB9PKcJt9CLOZlwC39Rt9/sjYG7L3Wf+EXdb4jNX3+vuavCP5Vr4plQzekhgV940v3xMRpU00vkJGWR1PceXFoW15fRQ9XGqEvC6GWK0vRRF1ajTD8jXy8bbKbH7Sm+HtHB9o839ic='),
			this.addDataEntry('', 35, 45, '', 'xVZbk6o4EP41vuzDVgQ8Z3xEUMwUiTqgDrwhcCI3sQTl8uu3Ey7OzNbUzttWaZGkL+nv604nE1nLauPmXc8kD8J0Ii8nsnbL87IbZbUWpulEQlEwkfWJJCH4T6TVN9KpkKKrdwsv5U8MpM7g4aX3sFvpFoqySfuF4uxd+TDKPAbfRRhEpXdKQ60o3u5pWIDo779g/RHeysj3UtM7hek2L6Iyyi8gPOVlmWegkHLBwvMTdsvvl0DL0/wG8iD8493T8oMHNY0YtyzzK6x6xTX0OZg/UR1C2AsRiDqsomGFu/JKbyKr3VRaFQ82kRZ1BoC17ZpKbrNQTsf67rco8tZvyNfzhykHctDMZNLMHn7mP0isVkSbt0HmR3jtXt33QDvJbI4jVJnxnpm2eqeW2lJLqUicMKrv70RnCo4WuXtML956N8fxbmrGqrLRMAukNAkMsI8JX2s2FoaYXiOqOHbxijX1xZffZidjz4J1Wrk2ZMY4KIE2j32ZRNto1ga6ysJm0QbGvDKP9HEy5s0mWjSuhHNi76emptbEZgXW8ZRayW+8Rsy8UESsBYwpOslq6Ujz4iTjX3j9enEiJhOrYsTG3KalTWez5ajXaeHaSobl83lTJS+uccj8dpy/bo36esoOZz8JGuf4dnWPM4SN5/hwnF2DNZnjy6F1319t31jF7n5+P7zTFBiakRhFpMV3qicSzJVu7txJvG+EHPADszMhgzGJFIm2kAkjTbbW6wLHz1g0uxacYIMWzjttQc65isz2v3SW4G+euReaBjrsYeHHNnLi0Fj+1nbJiyn9G+Mot6vHF05eACPytEXmHesC/E/9rMoxWl4BA4+Zknh3p/Z+hnUii6owSG3GDqKNWgH/wIVfm5YCXOwY4EW0XZb9lxEN3WnrTEHekHZfEktpNzouzdivaITAD5uSBnT0ZQM6na3FbVTJtJeDrUx0F2+EfBXzOYVKBt9gTxTYa/CtUJt0tqAL9THEJkF9MZBXG53B3k69gZrr9uYYYJ94B9hYQzW1MWFMrC/f92sJ+4HOIQY/EviF/QcddAdMaOSi3xfrKscpUZATfnoAD2lZ0+FxhnhBZ1eTCPW2yw/cdLYcj6UnQu40HZ/cd8/l6Huj79vetuOzj43GS4Vj5Kf8Axd8b46hz+Wn/H35rn6dbLUEnanTDNxzOyJyx/cXHI65cgbeuY8xl2L/T3lXK5Fjzr2oH1J+qZ/+u3rmvtcX+Dsdwf2T85F71vEHtaE7bOBq4KLjivPT4+xqQ8T6lEOsF5H3mmhKRe30f8m933xf5/sWN1jEnfAYYJyIs+o3QveJ+wMuyGGXF6iRsS4+nQleI+dfto3lruNDHEcCeJdcB84LAT+AJfbhFlHhVsCz7tzgiiakBXt5Y0MtNUotaq3l/QND/9gJO7BHcBOBX1UOYlL1PUX0EmIvFcERjx1qkvcKgRtyyHMJfjl+fraZyF2DIE9LmUb9/hH6Eg+T4cyMsZvA28ZeNv0eJe37UbeHq3c+VAT5nvH64zcmaRPIoegp07EHrhzZaUUNcox9jZMeX4/Dhps1TtCuJT3HmPMF2Jkicg74uc8wQcAF9w1siJ7Gz6Ooq3aop69fC3R/2geHXPe1x4b+OpzZTznQhM/xTIuaFTU51sZPaicHvkCGZ047ntfxbvjcZ1HfX/PnvddWD192L1vG32/8t+gfefC8CutvH4piqX8lGmGeheWtAZUqCspzpyHPOqtzGLFzb6X0a17Rzdlo+Xx1wqB/eA7T5wNXyD69f/8B'),
			this.addDataEntry('', 45, 39, '', 'jVVLk6o6EP41bu7iViQwZ1wiOBiLxAdRBna8TgyCWALy+PWnEXVmFqfuXVh0f/1I99dJO8FG3lrX4HKkRZxkE7yYYONaFNUo5a2RZNlEQTKeYHOiKAh+E+XjL9bp3YouwTU5V/8nQBkDbkFWJyMyAmXVZQ+gPAaXQZR5IOA7T2JZBWGWGGW5q7OkBNO//wB+S66VjILMDsIk2xSlrGRxBmNYVFWRg0M2GOZBdBLXoj7HRpEVV7DHye+gzqpvGfRMiiGyKi6ABuUliYZmfss2gbLn90L0J4qeyJAqqIIJ1kdV+ShvYqLM2xwaNjZLpvjdXA3dto56JIPlDkVmcbNxjONOw7TTblEe3WiqN9SY9XEeSbL0L/5nbIRYzIhEjZ3uhc31mjk6Yo7asj4StD/VzNy2RM4L383OwXI7IynV7HSLqENErGSn2IL4dDu10wVmHYGaVpKpHi9XxNDfI7zTQmsv4mXW+BwmYx3U2JilEaZyI7U+NnWRdPM+tmaN7bJbaM26tZx3vkIKyvdT29BbykVJTDJlzukXWSJhnxmcPgeZoRDrlafMyhCTN7JcnT0pMHUaQTkZYnrWjTGboetlVvpczQk+HtfN6d23DnnUv/TVxmovYX44Rqe489zdxXc1RKwv+eBql3hJZ+R86P3PFY+sj9Tfz+rDJ8uAIY2mSA6MrfkCga6OOgUGdfVuh/6B2WbNBbAv2o1DemBdA9ZE4AKzpwVw4qWJtfhlbKGesT/hKe0R+IJzoW+D3P7TByYTKn4eKQcEZ8D03r9NxeANsJzVvvvR7fDq6FtZFp633zyAq5Pv+v3rHN423ueuIJZ/Ca1m6L8LDZFunZMk1lA3qobbw6TaUdNPqYFaOxUqlarCzKiinYpYvxDUUTVmLipmqJilBw7fnnH6il3zLciHgvaLmnGhevAFrCVwRyDHlHG4jekWE3Nbr819T8zRHr38COCie+KDH+u9aZwSuJ0nRF3aPG22c6/tmbd61CagJpVx1tucDHN85bL5zzMd06sp5PS6oVfI7eiNzWHWfK89cldjLvrI/cEBnxKTIjvV1bWBhpfWA0ctM+M3zqkKr6qlUkeOuYc+IyVOaXN/aa4Y/DDtD28/ZvluY3j3vTqsMjx/LDtYM0n714V5hx7b0kqKPKmuHbg0Mq6Oo4eqjVHHRIrjIwrPRiwoR128Ir+2LwiPBfxUvxb93fbjf+AP'),
			this.addDataEntry('', 48, 39.43, '', 'xVZLl6o4EP41bmYxBwjcuS4RaE0PiY2iNu4QmEhE6dOCQH79VAW723vmeWYzCw+VqtQjX30VMyHeuZ+/p29HVudFNSHBhHjvdd2M0rn3iqqaWEaZT4g/sSwDfhPr6S+sprYab+l7cWn+jYM1OtzSqi1Gzai4NkN1V1yP6RuK5TkV8J0Vedmkh6rwrtdVWxVXMP38E+hvxXtTZmkVpoeieqmvZVPWFzAe6qapz7ChQsMszU7ivW4vuVdX9TvY8+K3tK2ahwhuVQr0bOo30KbXtyLDw/xW9gWUPdOFuB9a40ODodImnRB3XFpP15uYWLP+DAf2Xhbc2g8z+7Dr20wZZbpYGZlf30KSk3xwCBucW3bObky6HfOmKj9nJV3s3/avuXcgYkpLowvlRoSx2/K1Oyw9d2CDrbjPSjo/Vukur3PfKJlkLVORouWMpLuVkWqdKF/KRBbz4Bdv7QqoxSh2fUUXKyebb6b0sqqKRXRLCFdU2m1Goo4uriIjq1vmmfJg9bdM1iI75+WvfmDydSdYHNgh1MDjzdtymE2p56jcD0QxzFQ+n3bhjt8O8+mwLGfD3qI1V8GV+sGAPkxlo4/f3SCHc5hvAKfnkttJfH1+ma+q/YU9aLy4v6Y7p0penxfZ+emU7rZt7s0un/LTtk1fV+pl/Wxm1nbYkNkxsbYvh2qr9msqiphOqaRGKGnPB1j7uA4cwNMAnBwWA0albbMYsFyI/mVNh1C6agm+6S6a0lPwhV90ekb8DsQVidUfM8IAP24wj97+cQ/EO1j7M9RoQI6elt9/OGUHiFXtfvc0rMjzcT+vqsMlekTGm572u736zBP3XfK6qul8/3aYd5BjOxw8IaP1CTiBdRs9cMRkMoN+iRZ+Vi5pyyzRhzIwk8EmXArBPFevQxl1bBhl6FULXLQAh457ds9j2oA8AE6K+RHKZLm2De5vVbgGu96fgZ4aoFdc5RL1Sx/yyYCEuDdOgJvUBtlmWAfIaz9ruUyMZDCgvs0w5gNZuRi3Az5DzMjQOv+IuoHLE+gCg5W4L7O0bo3+J21naoN1mKGuI8Fabe0vTwPGXILM/chIlAs2ZvHS7hn4c7khsMYYNlcZxHOx7p75gJ1kpj5PzL5yvrKvmH6kY2p5LhRwq+MkaRCvtQ/7fJck4MtjJnRPBrejvisgL5x5M2D+ZSwI9f90D9rMMKZgC5yt1PGcsf6TzeEeYIMBfRMdYO8s/QzzGlxmiDGeQTGVtDCDDsgW8ynE/OhpZrMLa5f+yRmxFWhT8EUMrdSHOZeJzYxAIaZYH4N7CDgDtQWCyQj7ZuEssTPULk8wZ4m51JxygfP4jWzNJz/qKfCB+4mpeag2FnCwA/3Ye91v1LsaR65OiKmZaW5EEEefZeD+CXtARs4EkDvoNRegBpCdsb8uzrsJPcIeQ3+xR3jeiAA2EHur+QkYIJaGxmjkNdyrmh+m7uUC/XVe4Dj6M8IHnQs56DAtsy8OQl13PqDfaPfFyOFtopDfyx3rYA8ZMWY21K5n7uMbxoHG45M3WI9KAEO30X2DWjH+KI/zmgMGgDuBHnTUw9g4a2LQuMcb8bgXeqr3/qf5R6757GH+Vw/znzgP/bHG/ogB790lzpePPBnna+wz/3aI4T9BCrhXDAexHWtK/ramj7P+kTvskztL7/Fuoh93k6n7Z2H9AeAOd0WM+sjkeK/pfojxjpPHOoxhfvxA/R93Uw5cgJ5ZUGun92I/46DB2brPO8wscE0GneZj7MKcUsXLe65Pnm7VAw8NXe9a1/vtsDbM8c5w4WzM5JcEYgQW/D/oGcb7a4m9l6tvP/xXfQ8Bw72y8YFGZvcnHDyeiv4vn4FadX8Dzov6XDTvA2zpyrw5jjvs76PXsSjF8e5Fpj/bZFSn11ElPp2/npUg3F+WH8uvF6y2/fDA/R0='),
			this.addDataEntry('', 41, 45, '', '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'),
			this.addDataEntry('', 48, 48, '', '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'),
			
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 48, 36, '', 'jVVJr6M4EP41ucxh5IDT/XJkC/ETNsmDLHAjQINZQhRIwPz6KcPbeqTWjJTIrr2+qjK1UI16sO/RLadNklYL1Vqoxr1puvlWD0ZaVQsF8WShmgtFQfBfKJs/SJeTFN2ie3rt/o+BMhs8o+qRzpyZ0Xaieme0eXSTV15HGZx6mvAuulSp0bZvjyptQfT3X8B/pveOx1HlRJe02jUt73hzBeGl6bqmBoVKCvQoLrN787gmRlM1d5An6a/oUXXfPGgVz6Rl19yAG7W3NJZgfvEhhbT1KRHtg4s+ONJV1EULVZtJZdM+s4WiDzUANnZbpoRCx5fT8IhHxKPtG4rN5umoiZqIlUrF6hnX8ZMWWk+N9ZjUMSfb8BaeE+OiZmvCUe8Uh8zxtQfzNOEamqAeySL7eAuVHO08MtGJUpWJDfoFwaTANVHz3O3LjJjDmGyrNvR0lJ71aue9ovCcI0dhYywI5OlcGaKG/pNsGbqoWhco6/aikh9k+3oNeCaYGbTELHsHIjOT3Fyhr4mxGhPTylKhj4m97p0Te17stXC5LkKFNNQPBtCXNoPr72cbs3/G6tvqYh8g6itnOPDb1539VoVX+o1j+EMbnVZVcH7dxvWmjE7HR2Lo18/75viIzm8jIFnGylEcVD0PlOPuUh3HECqR+kRWYXQKKlxJm5K2VKBVNsktKX8wMxsI1zH1Eacc93QsObGrEvzq3yoo85kwEpu1wZnJuIBd4874XzoW+FvX4ZVViQkxPPLc8aBIbeunsS9fHGW4XepjHpeJCE5vt/C0Qp9yv3+G9rGOv2K8xPYGRYZeR6ehnbDXfUOQdQMMMmdGC/qgRbZyPLwMRgvu2khMLQNsgpoB4LVWxAQdU8PElPIDdoqsBzmmJsmoJ/WoPFXXDL5ojlfMZwr1oWZ+jINR+5B1TrHvKUylU5CecTTIkwoNaq/17oYKZmDk+uC7mKeXCixcs5zpQwZ68UBPtPuMZaAPX5CvNjj+nK/jz3gOAkk/AxOT306+DJi1CfcR8LPRGvazDvg5IGYgsC9XEi8DPTbK3OIlvCLI9dAzT8phDkyJDeJA7WSNpB95T0sE+pmQcjruUQC+6RiAjiZjY8ADcxPAPVgyjgdqVq3rYQVqmzE5U35YAJ4l8/DAZA98sgJ6AB089cWvwP8B5lTmEc/1kPfCWvkmQVNe5mGc4kq5h3s2yrpbYA88X5P9HgG/5PXuSZ4UU/XWUb8E20BiXwJPgQ4+4C3iaSY8jGgh67dX2VSLvaBT/+CsgqXsK6v7zjWg90WZQf5LNuY59HOgXEMQS0x+pC3MBQW7qQa1zC1WGIe378uaWzJnwFl2Ei98P+Zalb3sM3Y9bY51DQZqYOyarACfU56/5/av89p8vb9RflfC6y6Te0P+9PflAp/1dPjjgppY79vJTps67e4CVHqedPmsgV9mqzzlWf5upf6YeVE709mn5de2g8v7wvsgvxbrJPtt7/4D'),
			this.addDataEntry('', 48, 48, '', 'nVbJkqNGEP0aXXxwlFjs6SMNNKo2VTQSkhpuCHABQo2iBWL5emcWSOpxzMQ4fFBQay4v30vVQjVPvfMZn3NWp1m1UO2Fan7WdTONTr2ZVdVCIUW6UK2FohD4LZSXn+wu5S45x5/ZR/NfLijThWtctdm0Mi1cmqGaFy55fMZhcYoFfJ+ztGjiQ5WZl8u6rbILbP3+G6xfs8+mSOLKjQ9Z9VZfiqaoP2DzUDdNfYIDFW48x8lRfNbtR2rWVf0J+2n2d9xWzRcLRlUIvNnUZ1iNL+cswWT+LvoMwn6WgRi3VXJbQVNxEy9UY5oqL5erWCjP/QkSNt9WXImGZ+2w79tkJEW8WpPEqq+umqrpoKts0K/JKbmy0uiY+TSmp6Sgq+gcvafmQRVPtCCdW26FGxgt3xgDHzTdC46ClaKgTl7F+7ROLVLI+So9R6t1/baht3PFWxGWmWP/aW4MAbGQbN9XdLXWE2f7RD/WVbbyr6HKR1pqbaL6HV1dRKKur4m5LA9Kf03KWiSntPjLooQXnfAC40JhzIrjn3RFhPvBCds8w5iTg2o0ofJ0Oaj0D7p6/QgL0fPShvN4x9a5Od15wzxX1SUKtBNV89zrjt8iZ3dKxvv89c3pz4fTLk+O6RDu1+dorxPqPMa7vX5OVwxy2I3R+2uQOC9ltH1qd++8osWzzkrEZNuy0dBgrk1z1nJrS+R+APNBI3z0ATfRI2ZuaYzehop47z/Ro/3Azod4pvxEqPR5oqJfyNuk11+eAXsHJTolyo6Aj54W34AbrwXXwuDyagbd9eBUbbR/Gdbqax45VXX48L+cAKyO0T4a736Cvgvf1zV1ovPB6TD/4WCK0t8cgQ8YN8Had4B7A/kobM9aVh5Ht6Q65stG0XLI0y390TM1nY0visSpNEgY2IBPKNgGcCmMDuoGYwIYCuKWR40rDGzSJS+0wQvQftjNNhu403EL7zNtY4UtD+wxHIicgx04m2gcbQW+6oIfZvmNjMGxe/gq1Jp9m+gXbTONF6T1AqHuyiPWUQ9HtMMU8N9zK0H/wKnJ/xRfp8l7JpFfpqBtukTbkOPNtpBn59hiC8/YKj8hN4wRc4ZYR8gHfITSv4xzdW7cgEIcWxX4j18lNomO9r19B/63xNtoS26lCmCi8PElZ4WmeKBZjFNiaRq9u9GAizZirPORiR+eAXy8IIEaiYEdhYb+2b99BH7rWb4O8Svy3PuZM+wRZQLx2VAvoUO9OvBHGMYbUA3GKpNYQj3Bv2dh3bcKjKGebOLFRuIppnrSuUZixvMXGJmSF5PNab6EGCXOEvN35I9NgJ8qG+3mxkHPSkvw2wNuPfQx5BjUUBumsb/k0u4aYxu55M5RhfGSjcBtq6rdQGBOkm9egHUmyKkB+QZ6V1zJa7qUvBuTPjth3UTnmQbgRHtv/6O8kq959agbBpyG81iDgQfYW8Bm6fdc8szWJc+wN995ZmNOSxZITY2gqR75+4ULUo/g58FRtL15aO8egyMaiGP0LF7ea2RCfqPA+kG825sGf60rk3zxGU4+73o37vyA3lBOeidzD0G93zQtNTznkP8RQA08qcmf9RzaP+qdYDyIn+bOHOIQ1wMPqgfI2fIIMcJdC5gcJHDG/389avOlR8l+keczznN/uNcDtCU52k12bFXathLEeGQl6sHWPMkrn8g11PkUy4z33RbUyp/60jKEGgrUzxc9+upNj1IfUo87BnFroP0ZR3vmC/I2/GH/Cgfg1dTbAB/EHPRVTNrG/ax4/Ee9Te8L+HeBt8v8AIOnT9b/9BEnl+YXnJPVp6z5HOBIV6RNPp3Qvk238qwQefP9WnyZ5uJ+8/EihMH8KLxNH49Puffd2/Qf'),
			this.addDataEntry('', 32.14, 45, '', 'jVbLdqM4EP0ab2YxRxaiu7MkQGxlLBFsbAd2vFoWxsEnBvP4+qkCx0kvumcWPkilety6VSVrZtinbvEenw+iyvJyZrgzw36vqnpanTo7L8sZJTqbGc6MUgK/GX36zel8PCXn+D1/q/+PAZ0MrnHZ5JNkElzqvrwJLof4jEt9ihV8H/NM13FS5vblsm7K/AJHf/8F8mv+Xus0Lldxkpcv1UXXunqDw6Sq6+oECiUePMbpUb1XzVtmV2X1DudZ/jNuyvqLB6vUCi3r6gzS+HLOU0zmp+5ygP04ArE+pORDgq7iOp4Z1rSlT5ermtHH7gQJ2y9LSaP+kSX7rkkHouPlmqROdV0ZmZH1piF685qe0qsorFbYD0N2SjVfRufoNbMTQz1wTdpVsVWrwGrkxuqFzVoRbJUolOaLQxnvsypziB73y+wcLdfVy4Z/6OkXHRb5wv1ubywFWEi+70q+XJvpYvvA39ZlvvSvoSEHXrAmNfyWLy8qNdbX1J4XCe2uaVGp9JTpfxxOpG6VF1gXDmuhj9/5kqjVmyRi8whrSRLDqkP6cEkM/o0vn99CrTpZuKCPNq4p7cnmBfNclpcoYCduHA5ee/wRLXandLjvn18W3Tk57Q7pMevD/foc7U3CF5/r3d48Z0sBOeyG6PU5SBdPRbR9aHavsuT60RQFcBKoRgyCwp6N+8Jt5GDR8TyAfc+IHHzgTXXAWbcqRCc3XMV7/4Ef3U/ufMAz5adC2h1SA+NC3ja//qcO+EtodErpjmAMrn9AbzxrycLg8mwH7TVZlE20f+rXxvMhWpRl8uZ/0QCujtE+Gu5xgq4NX9cVX0TnZNFi/n1iq8LfHKEfEDfpvA3rZE8aEbg0DFzgIFRiwwaprRZqAWurEUU4rAp/LheiEc7WXBWusSosJnvQQxtHNTIQQ1bw+argraCi5TacFWENur3QzAB+YS2ItJnpOdlBYFzbAh5dMsbBNcT1ghTr0EEPgF+OWFpxx0Ia6SgKNq0kEHPgE+bf6UEM4aTqD7EQ0yD2Ar4wB2AHuZp4Jh0fZCFgB9ngE5Ah7j3w1csgKoSN8hCxQB9AvCI1pvxI4wEXgYN5+OaIAfTBP5n8+6C3ncvRryKrQjFpT+vYcWF+rbk8uYh1GDkIBOKFvFyFusDl4Dnrb8mG9KAz92wLvn4ntoqtAIPYt4B7O3g2m0unpNC3VAS7A9gxvBPAx/wLBwbERX5MOUAczWBWR3/9Fx0mnBDyc8GOA54j6kHffHLtBVuGdYeaoK2Z2Mj/EWysLgPOMabYw3xjjXYh6HBTGGcJvTAXDsQN/MZzjiwcLMB+hB7yW88mHeIAzB3W5r7fq5E/6DGwcdmEgfVQN4iZTpwVnOJXOnzMFXx2WEfpWGw8H0K2CkY98rHfOFvsJzOEWbj5rW9+67H3NRlxTF9BveW5Bo4N0FWQB9xdzwXKBfJiMyqDLXCFtcb6Aq+DwniYO/Wm/gJ+cH+fiWHslUIADpfdehC4VcbY48j75lfeIR86ckmxf9051KWdZg7uJrjTvWDEbsCctp5Tcon1nnSxL1qYDdTtsX9hhrDH4Y5DmWX+MSbw4gXrYjXy49ZTTuOcYA70NjPDNDO7YboDCOZFMV+BHAdqHvY4n0fEA30HczXOHAeuv84mzoLV3++D+yz4bJyhwDJy/Xm3vkz/i3Arwn/u7eEAf9l599vHxyi6vTwWeXXK6/ceVFqd1YdJw6B/z9lkeMi1OtwMmTnJ4su0V3fjz8cMLG7vmY/t57tpPPvlWfUv'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 38, 48, '', 'rVbJkuI4EP0aLnOYEF66u47GpoxrkCjAQNk3by1kbEyUDV6+fjIlu6p6IjpmDnMgtOSifC+fjGa6XXbue3Q70yrNipm+nOn2e1U1alZ2dlYUM42IdKY7M00j8Jtpz7+xzqWV3KL37Nr8lwBNBTyi4p6pHbVRN30xbtTn6IZTUUYcxkWWiiaKi8yu6929yGow/fkH7D+y90YkUbGO4qx4rWrRiOoKxrhqmqoEhwINiyi58Pfqfk3tqqjewZ5mP6N70XzJYBWCY2RT3WA3qm9ZgmB+ii6DsheyEGvaJdMOpoqaaKZbaqk91w8+0xZdCYDt1xXTwn5hxKfungxERKsdSZzqsdZTPe1NnfbmIymTB82tltpPQ1omwluFt/AttWOdP3mCtOv8wNe+dWd7a9jYBqFDwpnDheeei+iUVqlDhFyv0lu42lWve2/yE68iyDN3+d3eWxxqIdmpK7zVzkzcw5N33RXZavsIdDZ4uXFP9G3rrWqe6LtHYs/zWOseSV7xpEzFX45HmGj5xrdqD+ZUXL57K8LXV0bofgFzRmLdagLtqY5175u3erkGgncsX4I/xixNZquYV8S5KurQN0pPP5837eVH6B7LZPhYv7y63S0uj+fkkvbBaXcLTybx3M/58WTe0hUFDMchfHvxE/c5Dw9P9+MbKzyxMGlOBB0Od5ZzHdaGWvP7xg96afeBM2EM1KfAG++As36dXwwmPB6dtk/eZfnJ3RbqUfh4oHXnRMdzAbftPf7VZ+/xWAvLRDsSOKPzxA/QxotgRuDXL7bfPmK3uIen536nv5xDtyji6/aLB3B1CU/h8HGO37XB267y3PAWuy3i72Ob59v9BfSAdZMBcEmNbPZGz06080bN0L0xhz7cqQ+cwAh6AszePM09Y50nBj0tYb0doL935lBObasFvwZsMo4NvAt6gjYd/TY2wdwa84MGcmsbJwG+D1rSkw7yGnRP7jRfmmtfxa736BvmMGI9kPcAv2DOBPpbJsXcED/5H/PlgPts2XZY+8bfcmYbc5ZTznpDh/o1WYfbdoC1pcMS98Fvl0NuxAm4OPhNuL059BjvRg97AwN9QB2wxzsq5Bo5Ak0wjeZc4R0srnIAlmFLJA9+MGCN1AFugSvqwFrGUcB7kHytc4oxgIt2tJe5G+Qa7gLi1qggU5ypuFgagKOB+nvqXxqox6QOcOUj/1OuA/LcAg84ztc+nO0fNJUTsVkyr6wP89kE9E6NaQ6YCcsvzciJwRyZp6P58Qzn6Ruph8SEfNj7TmJ1gGPJ1TFXeUATtsyj6s85gZ50G+dcA07Awrnq1e5E/QTvm+k7W+CFY75W6uIt6KgN5znPOZyDd9SAMxA3xvYbqTnUhdVJXe4/Ncf6/1dzzP6n5gIYlyb0HfJbsufSliPPque4Rlyxc1H8+lu5DnqpAdlL6KOsUdWEOKxB1cZHTUgeUcsqp9QM1mO0LJeagl4sUafY71HLYF/d2MQraA/0fzCZS7G38+meqr6Mdxa4BW5Ql8gt9Clpvtpim5hKj5YpeSmxfuRZ8YUcfPADupE+V4rc9+wr12hTXFOlc0rwHPm92I+/QekXMKs74k/1yVzdyNuo9cCAW6j6LnuHuiIffRg1g+cNqpYP/YAmuPSLHeT2And2GoE3B89VY9BPmkC81qiVYMrRjFg7dbc8+MZYsq6N1F/47Zdv+Y+1Dv/0g4GPF30xPm/gYZF1v30iya3xfeRmVZk17z24tCJtzspD/6Gizpng5zHKGPeiWq35R+Tnewsm45NrWn4+7aTtl5ff3w=='),
			this.addDataEntry('', 42.86, 48, '', 'jVbLtqI4FP0aJz2oFXlU1R0icDW2iRdFvTDjVRhEcSnI4+t7B/BaPajVPWCRk5znPvtAJqp5bua34HpkRZzkE9WeqOatKMphdW7MJM8nChHxRLUmikLwTJT3P5xO+1NyDW7Jpfw/Bspg8AjyKhl2ho172ebjxv0YXOVSnIMU71kSizII88S83zdVntxx9O0v7D+SWymiIF8FYZJ/FHdRiuKCw7Aoy+IMhVwezILolN6K6hKbRV7ccB4nv4IqL3/zYOQilZZlccVucL8mkSzml2gSpD3rEzGeu+S5I10FZTBRjUFU3u+PdKLMmjMKNj8WXPHbmRYemirqiAgWGxJZxWOlxmrc6ipr9Ud0jh4sM2pmvnXxORJ04V/9z9gM1fSNClKvsl26co2Kb42Wb7WWZ17KslTQ+TEPDnERW0T08iK++otN8bGlTz3xIbwsmds/zK2RIheSHJqcLjZ6NN+90csmTxbOw1N5RzOtilSnpot7GqmbR2ROs1BpHlFWpNE5Fn9blHBRp2vXuFOsmTj9oAuSri6csO0Ma05C1Sg95e0eqvQ7XSwvnkgbntnQlza2zs3B5kPWucjvvqudqXo8ruvTT3++P0fdl7z8mDfX8Lw/Rqe49Q6bq3/QCZ2/1vuDfo0XDDXsO/9z6Ubz98zfvVX7T55TMdNZJjFhFXPtFrL2kpnSn7uQW43wzgFuaQPMmlUW6WxL0+DgvNGT/cLOQT5DfamnNMdIlXFRt0kf/6kDf6HinyNlT2QMKn6CG0vBNc+9L023foTzvPIP7+1GXR79eZ6HF+c3DWB18g9+9xXHbWrvc1PQuX8N57Wsvw3NNHO2J/BB5k1abmrA3Um50BSebbJV5tRM8sHdVTwzWvBJQ+0Ks2i1dlOC/qSrzK7XW1Ixy9ZWGYW+XO+mWKtM9RrYN9z1Z3h3660BrJgu7ZhpNJIPeMBT1vFzXQJz4Gy01PLg35l6LXxl0pcNDpGKu1SH30bGWyMHltn6Cn7BYfiT594Ucs07VqInTZ8LdFxTa+Eb3Dcq1jHFQxze7VLkpGI26j6frbR3VNijvvcM74ZZJ/ihUy79uB7Bnuw79myFy3jZTtlnEXKlrfTJulM61jn6xOx1drOSZ8AutICjG2krl1X8AE5lp3aM88xd4i9rG2IsoGdBJzOQg6YO+HgktOAzs6dcGKrXak2PhRV1wLFdy1q7CHYM/XB0JuATePZY9dhphLmnUfZqdkFdWapwhdXU1HRupYjtSN+I4bRMENkzhbdfMnzL3hkSY8Jlj1yq9TVarO/H2mIv3GT/vvYQD/asS7unfiwI4huEk1qR58AO/T5NmVKXPR9dfLPAx/XCk/m2/FDjHXXcNKBv43tljDIZ5L2Hur2OkVpyD/2KpH2N+mRdXZ/vgLsC3zIn9dnLPifX0YbabK2367kk8ZAcknxI2wHnAYcnBnI+8K3q+zxwiPZxhhnZteuBlwMfZB8+rxxch07UwU6FT40pbOybxK7PD36l7I39sMnaNGSfWnAOuRj4D2hT5F6OvdV6fGV9/eySMV6Pu4w7BT+Q2/IIbKZDT3fqcx5XA8cG7s0xj0JT15gB6Cprdy9ngoBbMpbe80Bi9sIROcoYBr7XRo19mSN6fJJ+p+h/XyvWGmYPHKBa78+Ss0j1ETM5Py374krvQ+Y2zn5f7zAH4G8iXt/Rj+EfiC8g/q/jJQG/56T540Wj3xpvGfOkOCflrYVKLeLyOGhoyref3wfDYyLS42io/Rz2gvsgp1/Gr4sLFuPd5Sm+7kj92b+uUP8A'),
			this.addDataEntry('', 48, 32.57, '', 'jVVLl6o4EP41bmZxTwScvi4RaIxjgg/Uhh0EbkwE8QjI49dPBbT79uKemQWHqq+qkq9SVclEt/LWvUe3MymSNJvozkS37kVRjVLeWmmWTTQkkoluTzQNwTfR3v9gnQ5WdIvu6bX6PwHaGPCIsjodkREoqy57AuU5uilR5BGH/yJNRBXFWWqV5a7O0hJMP/4C/JHeK8GibB3FabYpSlGJ4grGuKiqIgeHTBkWEbvwe1FfE6vIijvYk/RXVGfVbyuYmeAqsipugEblLWUqmV+iTYH2YiBivlD0QtRSURVNdHNUtffywSfaos0hYWuzpFrYLYz41NasRyJa7hCzi8daT/Skm+mkmz1Yzh5Emg2x5n2SM4GX4S38SKxY53MsULOWB772zZruzc6zzNazDI3aXGD3nEWnpEhsJIjPayq3BhYLPTrtUKQwycVGBDJ1nTdrb3LggtJTm+Hlbsbcwxxfd1m63D4CnfZYGjXTtw1elpzpuwezpjLW2geTBWd5Iv6xMaKi4Z5vlhhkIi5veIn4+koR2S9ApijWzSrQ5mWs47/xcnUNBG+pdMBfxTgzao0xG5XnMitD38ixfj57zeVn6B5z1n/qq43b3uL8eGaXpAtOu1t4miHsfsnH0+yWLAnkcOzDj5XP3HcZHub18YNmcAYzIlX+uCb+dgq6Mej+AXSzG+w+6MJoqa3Om7ebPe7W0uy9PebRaTvHF+fr7LbAZ8yPB1p7ZrraF/K28OM/fWC9WAtzph0R7NFi8RN6YyWoEfjlyvKbR+xmdXh673b66hy6WRZft795wFldwlPYf+7jt03wsSuwG95it1H5d7HF5XZ/gX5QvFFHhdFT3+EqX88+tEFn6FQGnEDvrKWDvL3RezbhZK/yvzz/Wb/+hvPqu/2M1zJAnkuqtSSqDxvw14iNQTdnZI9gLyVjnaDBBzCzpR30qh9UqoeJz2rSBwjiptAPOuuMltgXsAU99HQP/Qoy74BvR3yF4xa4Is/Hzz0NgwgEa2Bjb0Nt7UQSC3SbKe4NzAD4OeCnsMN0rXjLnaZs1D9KpY/7kdHHH7g8+TkaBczzOTpKOqyr5KcvnBtv6N6Yefa2gr5BVL7bpHtxc6bUMpVvr84B5nQK8lRxpSeYAWF0ng9cFUfpPOvAp6oO1Ia6CGMKXPhg7y8wxwcNzmQKcWo/hSPas4EPzF4NMW0infZZjwZbBiK2o+oA9wmc0VgHODu1D26IfqPUGmoKNdgO90RkO8ZasoZMgz7oTfBnGlV8bYjxHTU3xvCHmXjpexvmpz9AfVStYY5sU/VIR2wCOO9f/lDbwT8VX/OxGe826Gy4N5+XP1y7afvHB2SAnq+HmxZ5Wt07cGlEUp1HD+PnGHVOBT8/o3Ttx+xthKNyhPhn8NeDBMLzTXqpX2/fYPv2NP4L'),
			this.addDataEntry('', 34, 45, '', 'jVVbk6o4EP41vuzDFhLYHR8RHMwcEm+oA2/cJgaCWAJy+fWnA4wzp+qc2q3SSrr76/66v0QzQ2be2vfgdiFFnIgZWs2QeS+KatzlrZkIMVMVHs+QNVNVBb4z9fUP0fkQVW7BPblW/ydBHRMegaiT0TM6yqoTk6O8BDe55XnAYF0mMa+CUCRmWe5rkZQQ+vsv8D+Se8WjQDhBmIhtUfKKF1cIhkVVFTkAhAwsgyhj96K+xmYhijvE4+QjqEX1rYIhOJOZVXEDb1DekkgO88HbBNpeDo0Yn17l0yNLBVUwQ8Zoqq/lg83UZZvDwOZ2TVW/W2rhua2jXuHBeq9EVvFwUIziTkek0x9RHj1IajTEXPRxHnG89m/+e2yGiC0wVxonPTLHNWp6MHrSaTrtV4xax5q4kYr5svDP4hqsdwuc7uZOukKUYxarIottyE9J76QZIgcMPb1xqnlu+YZN4yVCez20jyxei8Z34WTskxabizRChG+53seWwZJu2cf2onHO9BHai27Dl52v4oKkO9UxDZ2YDYN998Mt2cfBqCO0a/G6ZFD7EZnzNFTbR5QWLMpj/sNaqeQAeJnjZsqU8+IgqiTnVmy5lyb26l/TbTP/7PdPe5e9hLao/fNrt0dvF98WIrzumP/c709hLhSpbvxORSRo452pcFX9FKlHUDPrtgfck4M2B7U0kiqc9Md64x6lrROYnR40WDFgWQvYDhTXQDEWnEHVbMW/9fIGJ6qEyGCe2l5AqwW+UoWY+PGfGKgXqn4eqScFOFrMX76diOk2j99M+Q2xNRe/6uK2jfe+L7Dt30K7AY5TF5os3R0yjm3Zt9JRrmnUJZWTnlKYX6fWCvQ34EYcu81BU2nvMWpqiMINI1xrSJoxwHWgz7Bu3J1cZQ0Zlxo9bciDlaqkX9VQt/N6g00cwOch2g08881BAT0N4DMUJ2Vz0imtk2KdmgasRNoQz1rCjQmnTLjJPjIVcBrJV7BGHba8mvZYztFg4II+Bs6xf2HBL0ABbtBb68fZYZY+gxwyd+QdsAiCOjp99aa6pHHcFdyHHfTjQa4y9S37y6DO1I/yW34GGvcbC0uN/wldXIOGisRsLCY1qaaa4Ad+4JG/WugDEcur5J0EHGB2ML8COkat89QwaiiXWh21jQmx3lAPkjvdIa8bbWwZskYH5/esT9NInXKHc3nWTlfaNM+wh95r6jItTkk7YPIBCzUx5HnTfAaD/tvNcFZwpjn5VnP4J/qqNfAC1mYdMeEOWX46zj7o9Dk3+D32NbfEy3pYl7zD/Xvyfs4PvNeCO72WY3S5bPrmESH/umXynZCf5fSYwN940v7xQRpc02tkJ0WeVPcOIA2Pq8uIQNqYdUk4u0xZmj76gnK02TPz63WDzfTAfZpfD+kQ++Wd/Qk='),
			this.addDataEntry('', 35, 45, '', 'xVZLl6o4EP41bmYxBwFn2iWCjelL4gPUlh2vGxOw8SjI49dPBSJqn7ln7m4WnDyqKqn6vqoiI8081fYlOB9xHifZSJuPNPOS50U/O9VmkmUjVWHxSLNGqqrAN1LffyEdd1LlHFySr+J3DNTe4BZkZdLv9BvXosnkxvUYnMWUnQIK4yyJWRGEWWJer5syS64g+vMP2L8ll4JFQeYEYZKt8isrWP4FwjAvivwECpkQzIIopZe8/IrNPMsvII+Tn0GZFU8nGBmjwrLIz7AbXM9JJIL5yeoE3J51jhj3XeW+I44KimCkGf1Sfb/e6Eid1ScI2FwtiOo3Mz3c12XUKixYbJTIym+OFmtxM9FwM7lFp+iGuVFhc9rGp4ihhX/2P2Mz1OgUMaVy+JY6nlES12iJq1eYp5RY2xJbVEdslvv77CtYrKeIr8cON/SliWisZmlsgz3HYq9Zugh8+mBEP3jXD2Qab5G2mYT2lsaLrPI9YMbe6bE55ZGG2YpN2tgyaNLM2tieVs6e3EJ72izZrPFVlGO+Vh3TmGCzojBvfnhX+tM1ykhb12hxpXD2LTLHPFTrW8RzGp1i9sOaq9gFfWHjpYq0eXM0oiT7OluxA0/s+d+mV6f+3m+H9Tp9C+2s9PfvzUb7OPp2loVfa+oP880uPGWKQDf+JFmUkeqwJ5mnTnaRugU002blohYzXVl6B1jTbk2Y3hAPCXkNa0ApFTIxbxx+0EiDaLAHVNM5e/LlAxhVQs2gB7U+AlZT9EUUbKLbf+q4iIaqf4rUnQJ31Ii9PTFietXtX6J80liZ01dcvLo6fG5yZPvn0K7gjl0TmpSvXYjDFn4rDTH1MfFSituoy5ZDOy8JX2sIuBV4kHZeOJyCngExrzXsKnI0KsfVNcK3IAesXKV2ONYxU0rSGqrjzcultW1BR8EeKqRtLWywdSjwYBtVJKWTTr7HYq0ScTbY45Y2j7PpGDe9LejWD98O9dI06j6r4W4+15HV393F4OoqsSJYIwVZqIR5/X1MTlBBXlSSPYZzDgppjOouA391yN8BCzlCjoo4D2OQN7jdinhauKOPh939BR1r3ggMOlv3gY20hXh8tOzk71ziKc6WWA5n68TDvW2P5903FXtUxFgtLfqEhbhbxNBz+crft/HzXMB9oLPjd+yFHdzbytjoC1cD7uKMgUtx/wvvgH0hse/yB7D4lj9y3D64l/oifqnTYf/AfMDe6PHjCPwx7ljdseixEvj0ccrc6Hylz1j2vM+hexrj5f/DffvrPPc9zBEVfi898EHMXVGrWdvrDnE/xUW4xE3kCB14eaqJLkcWZ4K5qHc0AT/GhxaV2BM6UC+Nri9F/C0eI/EH4WlXN/D3UdctBvtoArkE41zkWiv6R/e3MTs76CPrEnrmBFmxiltD9pSul9TAj8BI+A72VPSKRnIouIRzRfyito2OOwd4wl6k3u93vFd/XCvmjjf4XoDvk77XiDuUsexH/R0p7myQtQa+U63jA/xYCg67nrIdeuCOx7zPQRGjzPFGxifjgL9ss/Q2Fux3GGMu8FoDxlRwDnOR97u/PMBCnE1U3PW0rh67vMLFt7yS4zsC3d/tg3euZe4Z9/4qa3b3wkF/5lDTbc+zwOSeG7+ROzbUsileGBl/1Ovwb3jps47sUwl7/PtW/QsG/lrwOpJPPHhcJfUvn4ndlnwj2kl+SopLAyoVi4tjr6FNeqtjwuhRWulyL7j2azpYPt6cMJHPzvvy8bztZC+v338A'),
			this.addDataEntry('', 45, 39, '', 'jVVbk6o4EP41vpyHU5FA7fjIRRGHRBFGR964TQwEseTOr99G1JndqlO7VVrp7q+707c0M6znnXkLrmdSxImY4eUM67eiqCYq7/REiJmEeDzDxkySEPxn0uoP6PyOomtwSy7V/zGQJoMmEHUySSZBWfXiISjPwXUkeR4wOLUk5lUQikQvy30tkhKg379A3iS3ikeBsIMwEbui5BUvLgCGRVUVOSiIEdCCKGO3or7EeiGKG+Bx8hXUovrhQRWcjZZVcQVpUF6TaEzmi3cJhK3dA1GfUvSUjK6CKphhdWKlVdmwmaR1OSSs79ZU8ntNDo9dHQ2IB+s9ioyisXGM417BpFeaKI8akqot0RdDnEfcWvtX/zPWQ8wWFketnX4w21Nr6qqIunJHh4iRIaup4XQW1wr/KC7B2llYKVHs1EHEtVgsiSw2wT515na6xLS3IKYNp/LJKzeWrr5FeK+E5geL16L1PeiMeZBjfZFGmPAdV4bYUFnSa0NsLlr7SJvQXPRbrvW+ZBUkdSRbVxWitwzo/t0r2Zer1hGGiNYlA99NpM/TUOqaKC1YlMf83VhKxAX90cbL0MPmzcYUJcdO7PgpTczlX7rXZf7RH168k72Fpqj946rf483ZN4UILw7zX/T+EOYCjdWNP6mIBG1PRyo8STlE0gdUM+t3rjVsXVkhngM8u/OklxEx2Ih3wEOVVGWrWywxlmMla+plGKp79Q3EHfdn9caIpgy1NDRXw3gzZN5a/O2/tcaONX7uD/7n2LEltwc5t/D5vG2zzU5flMFREafPzTrKV1lwPNSx8cLfbGkv/Av5ccturZ2hz8zPRRkaYwU25btOtXeYgTFyz0Xj3Eh2arU0J63tLeutwXo7PSHaowHmBRNX7ew0g7lByE4jiR4InGRO+petQnWgj2wgrjzfGucUToUaS+imCj4+5lBdiRoRo7osU4+wCV8NLz0uy1vDYk8e9DBNDxJJP+qt53SnQX1i1RTb0y96xKZCTGxOMKnAF3Ty5av6150W5XK/9fbpPVfwbRlqBd2eQ0cfvtHkq3/4PpBqfGNkcGqYCNmGHC2DQI2WiOIrJQODt7bsLWNv0THPwZfIoN7fX3DXiwb6WXx3cmibCPuXHRs32fjTHusOFk3S/XFl3kWPfWkmRZ5Utx5UWh5X50lDViarc8LZ+WGFF5MsKCeevSy/9y8QjxX8ZL9X/R37x5fgbw=='),
			this.addDataEntry('', 48, 39.43, '', 'xVZfk6JGEP80vuThChnMnY8IrI7nDKKoC28I3AiiWAsIw6dP9+Cue6lckspLqnaLnu7p/79uZ0SsSzd/i24nViZpMSLOiFhvZVkP1KWz0qIY6VqWjIg90nUN/kf6yy+kYyXVbtFbeq3/jYI+KNyjokkHzsCoalk8GNUpuiGZXSIB31maZHV0LFKrqjZNkVYg+vIb8O/pW53FUbGKjmmxLquszsorCI9lXZcXuFCgYBbFZ/FWNtfEKovyDeRJ+iNqivqTBbPIBGrW5Q24UXVLY0zmR9alEPZMBWK+c7V3DpqK6mhEzOGov1R3MdJn3QUSttYLrodyZhwPXRP3WhYtNlpsl/cVSUgiJ4TJyT2+xHeWmy2zpn1yiTO6CG/ha2IdiZjSTGtX+U6sfLPhW1O6limZNHpus4zOT0V0SMrE1jKWs4b1Xk+zGYkOGy1SPJGtsyBP585Xa2sKiEVLD11BF5tJPN9N6XVTpAvvHhDe09xoYuK1dFGJmGzusTXOj3p3j/NSxJck+25TjWetcH2zokCz7PyVLjSxunKNbWdAc+1IzDrQp9WR0N/pYnkNMtHx3IH7qONMuDXorDHPRVGFvnGh5HRy2/O3cL6/xP3Hebmed7fjZX+Kz4kMDptbeJhodP6k94fJLVkwyGHfh69LP56/5OFu2uxfeQE1mLAc8/caljsEzoY6++eG+x7U99ytt1SuctExSUVqO1Oa04bZbAJ3byHUzttS6OEy40bgV0vLO38bqjLLj/OXHjupqpV9++dbHdi8h5cQ4vTAj5OtPudpTavoMCmC1+Uivryco8O+SexnXVb6pgiv7JOX9WJ2SuZChJeiOkKkyeuy+m7x2fctFRi57zs9IEZyaXauZXSuHeosM/rIdhrm7/NVHuuAopaq867httk/aMG2hmR2AJUwtVXujFmmAY2VYi23kI4nq9zT+CurQa7hfS6Bn3vAZ4Trim+AP8n8GGhvzME3IBFoIZmiT5RLQ+f5Jl9tjY77dPC3BZmN+ohwDeLykNe6C+RR3d2CH9+TeI/3AfLGqO/6St5zlOe7WsWh4haoL12fok0DaI3bm5xhHn2gQ5wd8HTux3BGG4JAXB3kiDm0UDvJerTnTNTEPXzG8mmTW2jTU3RkM0CXSZJMg3pxCjots5MTfMdMmtgTqLMpmGV2K8gZ8kb/E9eOxV/eUbJdDTUbM784DPYKFb/rCwJ59ivfaVzbhNqfDegD+PV0yAFqjDmwHmpPAPVABy3LwOajp7wXEvIwXCWjiAeQMfhiDcOS+aLhueg9n2FNMT4J26dVscEWgryhbwFOkwygl67vwf2doXBkA+Lhy22BeGq57QjIQeP5XuGQ+yFg0GwHG3ToN+JiqCNxVZ/2vcIG2lO5UM1VfU8UZhj4Zr6DWJAQA9Bn1V+wgfFCj7DH0F/oi8rXjiXa5geFT6gB1hL9veOa9gM+dqqXSl/5BYwjlvqYKF8Kg2e8C9j4wCDEFT/wgHpK3mItARvjPW5m6FHQm/Uwe2hPSOwdzNz7t2ZqFpbvuME8CfQAsKCpvkGsaF/Rw7xCPUGX57EE2wJt46y5NhXK1tb8fLcc7ib/Zf57rBPO5Mf8Lz7Nf37+1J9Q9QdiwM07UTXFXg3zNfSZ3GoG+Hdxr8BGZv0QE8/+LqZQf8b/J+zID+wYP+2m7H037VT/AqR9qHtOO672yw52AJPYD3fYcdKdi5pj/X3+f+wmHbAAPQvIgBWG/ewY6MJsDfO+NQzAGvgyiZoDW4Bdpj98PXH6yp44hJlAHA7x3uoV1Bd3BsUe9Ts9ycGGH8Dvg5ph3F9QR0fni/L5S9W395iE17XAtxn+zR4POHg6pd0vH4GK9XgBztPyktZvEq60WVKfhhvGt0HrlGbi9NAi0y8GGdhRNbDEh/LzUQnE4135fny+X5Xsp+ftHw=='),
			this.addDataEntry('', 41, 45, '', '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'),
			this.addDataEntry('', 48, 48, '', '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'),
			
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 48, 36, '', 'jVXJkqM4EP0aX+YwIQOubh8xUFgOhBfkBW5sLSSDcRgwy9dPClxV3RNRMXMgpNxfvpTQTDWKzn6E94yUSZrPVGumGo+yrKdd0Rlpns8UxJOZas4UBcE3U96/sc5HK7qHj/RW/58AZQp4hnmTTppJUdV9/lJUWXiXW16EDNZVmvA6jPLUqKpDk6cVmP7+C/TP9FHzOMydMErzXVnxmpc3MEZlXZcFOOTSsArjK3uUzS0xyrx8gD1Jf4VNXv+WQc85k5F1eQdtWN3TWDbzi3cpwF6NQPQPLfrQyFRhHc5UfRKV9+rJZsqqK6BhY7d2laBfadG5a+IB8XB9QLFZPh01UZN+oZJ+8YyL+EmE3hJjOSRFzPE6uAeXxIhUtsQctY44Mofqjevp/dbQe+JhFtqne6BkaOfhUU6U/JrY4C+whoVWYDXLtu2VYbMbknVeBd4KpZdVvvM2KLhkyFHcIe4x4HRuLiLG6gdeuyhS9dpXllWk4je83tx8zlpHVjT9CpuWSvgV/BAbY7xvY1SI6chgyRhE+ilmJ7uTSOgnup+BfSri4VPe7OzuHhWnLL4mvX8+3IPzAmH7a386L+7Jmizx7TQElw2N7XcRHJfN6eLmmK8WRCBOBGnIgBcga6NMY5Dj+WinIHMNbU0LWGadZM8R+rCVjJ73S3y1+I77IrWtH8Ye8Ez9MV/psliVdSVX+PmfPpAvUoIiVk5yQh3mP4HpDXc1n1Ybg7bPyM6b4PzeH9RNFth5Ht32v3kAV9fgHAyfdWjX+pdDie3gHtmt7L+PDCb23pVjW+JGPem1fmtea0ecBPE0mBlhBGbnCNy60DOhVwY+LTEZk3aXsmZrSjtrCdc76Ud6ucaa+yWD/Tonqt8Bb3N3yATkfNlQ45p6h03cwOlVHGrJdcAm8G/q2nHAyBH7BeTuiaHNwW+AOG3rTbIHfu5gdX6PPmq1Dn3l8gCvadUvvPXUj0tBP5fncMqL5I3ooDfoOz+Dr0rouzn54MalewT7div7Bh34qWSsedQgB9j1+Wg3LSZ7k3XkTZvyWJLHN0oJcISlfXDNgwD/wZU+BtSmbJBnx5U4xFFxhNVuz+3CEX4PuEAGbAVwIY5zsCFX1hBXkC3wYXIu3fYCeCheSBzuMPHhyF5pTojYy7rIpa542QGTrkreCYV4T+vIOG8CfwWp0xehXAc2pAXqtsChK6B3egSdr/q9tnDl7Mf57fuRPzNGIxcm3AM6rSdxlHNVIgNpMHsF5gX4j+rWtmCeVo/NPdTCMk+L5YyAf1fyDRz48kwMvoJNXc5sTqjEDH16SPaLyIsrOp4ZtsDmVCsB7oATjSikxcaI8w9s/15T/nUHd9NfE24P/JFfzwr80NPu26dpVL3eJTsti7R+9ODS8qTOJg/t5xSVpZxlryj1bdKF1SSzz8ivdw42r6fuQ/x6UkfbHy/uPw=='),
			this.addDataEntry('', 48, 48, '', 'nVbLdqM4EP0ab2Yxh/DoSZYYiE0aidjGcWCHBS0Li+ATsHl8/VQJ7HbP6Z6eMwsf9ChV3bp1S9bMcMpu8ZmeDqTKcjkzvJnhfFZVM47KzsmlnOmayGaGO9N1DX4z/fkXuw9qVzuln/lH818O6OOBSyrP+bgyLtRNL6eF+pCecCjKlMN3nmeiSfcyd+p6fZZ5DVt//gHrl/yzESyVQbrP5WtVi0ZUH7C5r5qmKsFA4sY8ZUf+WZ0/MqeS1SfsZ/m39CybOw+2FBxPNtUJVtP6lDNM5pvocoA9V0Ds66p2XUFXaZPODHuc6s/1hc/0eVdCws7rkupJPzf3u+7MBk2ky7XG3OoSGJmR9ZZBeuvCSnYhhd0S52nISib8ZXJK3jNnb/AnX2htUGx5ENlnurF72ptWGB05KbjwFweZ7rIqczWh5svslCzX1evGv9qJVxEX+cL7y9nYHLBo+a6T/nJtscX2yf9Yy3y5usQGHfzCPDNj1frLmjNjfWHOQ7HXuwsrKs7KTHx17dp3/ZaKlpOI9V+jmn/b2Him+/UZBme8gWzwzGqYzjwGxojjhi3qjskuGW7z1fFxv5DnZPfcr42XQ7KQcv+x4sltvH7bl1JDPrN3KpmkbbyjMtKtN6ZvgYdjrzjYmANxkReu5qQ3NRqtcL+D+RAUK4M6Ps9d78kv/DNxieWL+SkBPlcbH2r4IqgZR/ULIhoznBf7xfOAkRVb4vH3Vh34vCRlMiTvK4jjiWAwS984HML2+PLqPNXpzpLx+8uSlc/HdPd2ztzb/mOgr2XyQe6ivC7nh2zBeVLKeu8iAy/1V4fOv258jsijyDeCwtbJRoOM4i7uzT6MyJkUR8x4CB1Th0zP1CVmAGvkPUameuKuD2QDDAm7Azvdd21OHBgDi6G7OocRN+IefBZbPSh8C/3Twp58anDG1vA8GQ4+FeYDiWgRqDkHP2A78AeYd9RlDdi1FNcAQxx58I35FLtVcRH7wHWwt0I324WqkrJAP2SIIb6n0R7jH7UpvsK3dzme04JIfQf0DXjRN+R49W0r2xHboSJoEzEdeNKAF8wZsJJOxRAYnymceak1RJgDjRgfv0kVREf0b+0xl2hlQadq1IiBk9ggO6+HrwVdgzjRL8T3mqDgPWAA/0fofvunNoDXAgzn0PX7DeQE8bt/xOioY5rUlYA/RrsuP2odgdrSgWG3wdoRkNgQb9UC3g5uCBizPhzrCeOjiXWnUdyoevZKF83Ipz3WU4w1St2Jz99wNOpC+ZzmWxNwogaQ8weG+olWoE82KP2MGjSpjnE94M3rsZaAFerqqzF1tzi26BJtyANqJ4wYjLcDYG7DHW9A05CT0puFdQ6UpnzUm4b5KV0WW/wOdHj+soe6ha5t+qBrUnjWT/Pq7/PysG86ovoIa+A/qNul2MK+Zyid4a0M+g7vdAbagpy23dhTBHrKQ/3eaUH1I8S5abRD33e9d8OQOhrgICbRbzVqYd8IXawf4N1ce/C3faWNfqeYCpt/63ffueljIDsy9vtmvENUv197Gnv4msPyREPUY/8vd07hfa93D3gc5I83k4Z08HnjgxSSgGbBx5aHqB/UO+iT/r87qru/o9R44U08T/fDrR5bjSiN2qOfiKHvlg7IMemxH0jELaUrxREBjrwJy8T3zRcx6XQvvRUM9Ab9c9ePeA9O/aiNuQMv2xZwc+vGYzTpBXUrfnp/FagrdbcBx4rzaKVPvY37X374j8L/Xj0ZTHxiGfPpEQbPn7z75UNOLU2vuEVelXnz2YNJK7LmMFqYj+OpQy74oflxLa3HOb+d/P4qhMH0MLxOvz9A1d4P79O/AQ=='),
			this.addDataEntry('', 32.14, 45, '', 'jVZBc6s4DP41uexhhwDZbY8EaEKLTQnQFG4EeA6OKZkAwfDrV4I0r29n+nYPGSxZkj99khwvNLOSm0t6PpI6L8RCsxeaeanrdl5V0iyEWKhKmS80a6GqCvwW6tM3u8tpVzmnl+Kj/T8O6uxwTUVXzJpZ0bSDuCmaY3rGZVmlDL7rIi/b9CAKs2l2nSga2PrzD9Bfi0tbZqlw00MhXuumbMv6AzYPddvWFRgI3Fin2Yld6u4jN2tRX2A/L36knWi/RDBEydCzrc+gTZtzkWEyP0pZAOz1BMT41CqfGgyVtulCM2ZRfWqubKGuZQUJm69bqibDWj/sZZeNSplud0pm1VdXy7V8WGlkWF2zKrsSbvTEfBzzKiudbXJO3nPzoLFHp1R6l0fMDY2OBsZATL0nYcQIZ6WzOYp0n9e5pZSTvM3PyXZXvwbOp135Wsa82Nh/m4HBAItS7KVwtrtVtokenY+dKLb+Ndbo6HC9yzS/d7YNy7TdNTOX/KDKa8ZrllV5+WIZjWM5PS17RsJseAkb9iMw0Ed+75OBjz2SAH388ebz4Gozjju2UJ6SfTLeZf/0cNiILtk/DTvt+ZhshDh8+Cy5r3dvh0ooyGf+TkUmaB/vqQjV1VumRsDDaQAOpGfqIxljkNkwcRLoGrFQPkmQR5f7GjUdVlj2o8Ptjoz20inX5wT49AMHavhcUj0Om2dENGe45ofN04gnT2yVD/9tJSHmNamSMXn38ZzSHfXK0Y5Hrz89v5qPTbpfifj9eZtVT6d0/9bl1n3/wVV3IvkgX0553a6P+YaxpBLNwUIGnpsXk65fAoch8jC0Vy63NTfQJQmTI2Q90tKQLieqYxmMmIZ0TH2gnHTUipR40HsanjqoakcspoHdEnx6YG9JRqoSHnXQnWM8Ggxj0FIBW2dweQYMw3r0FZefdKracIatQMVh38dzeli34LOiA1bCZhiXTFiM4RML4FQ8KwYfQwtMqBCfMH9nB/Hsng7Gb85CTETG+OUO+kGuJ9xTKOClHLAjJ5bfTriXMfDlLGlF+knPEYu9hLVKx2zOL9BXwAXBPKiFsWwJ9hDfn+NbWUfDSEV/z/I7z2LKvN7VkBfwGqlxiFgJciDJgHghL5ggsAUuiU6359YNHbCJdJg0qI0tA4t1gEEeEHdIdLgJFO89hs6NJd3b4MeWaOtZ0RcOstFDvvgJbhcDbPxhjud8sWEwybo63SSlLr0A7ezVF65XNGRYdy2YfEUz8Q+cEOsJ/DDHSKYW8MQN+cYBNz+NxUmBXoh6OFdSU9e98MgJYPfCCGIYugscAI7lVDfu3OV05m+EXtRJyGYMUCfAqNBx4mwgPMavAv2I+xDTxjoq0LNs6nHO2tnOv8lHh+LEc8HB7hZXucVVsPdVPB9wzN8x1otKAY4zHeoCedgqwRqPsURegPMlxJNY66m+3Aee8TzMHXsI+wv4QflzJjSCvTKQAXCE7NaD+sqzcuxx5F3+i3fIJ564nPo3jKAuxjxzow0xjdWMPYM5NXQvYkus92yLfWH0c/872L89cNFOtxzqLPG7M8HOWdEN4sWbUplzmuYEdfHwcw15vZP5DkB+wxjzHbFnPOuN43x66B/6gN2ZZg5qpv4ym8g39uM85/dZoBZTp3vLyv/65W7F/ww1GXV8Gmjr2+MB/rYL+e0DZFLdXh+boq6K9jKASV/m7XG20NQ/l/rseCxKdrw56qtZlzazzO7OPx80sLi9aT7Fn2+nae+Xp9U/'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 38, 48, '', 'rVZbk6o4F/01vszDFALWdD8ioKbbYKvYNrwhcGIgiCUgl18/eydo9/dVnZp5mCqtXPYla6+9QmVi2EW3vEXXMy2TVEwMd2LYt7Ks1azo7FSIia7xZGI4E13X4D/RF7+xTqVVu0a39FL/mwBdBdwj0aRqR21UdS/GjeocXXHKi4jBOE8TXkcnkdpVtWtEWoHpzz9g/57eah5HYh2dUvFRVrzm5QWMp7KuywIcBBrmUZyzW9lcErsU5Q3sSforakT9I4MlOMPIurzCblRd0xiL+cW7FGDPJRDrsas9djBVVEcTw1JLfVHd2USfdwUUbH+sPD3s5+bp2DXxoPFotdNip7yvjcRI+plB+9k9LuI7zayW2q9DUsScrMJr+JXYJ4O9Eq616+zA1r7VeHtr2NimRoeYeQ7jZHkW0TEpE0fjcr1KruFqV37sycOPf/AgS5fuX/beYoBFS4+dIKvdLF4eXsllJ9LV9h4Y3kAys4mNbUtWFYuN3T22p9lJ7+5xVrK4SPi7Y1XEIa3HW0b9uH/3K/Zrb2FM9/uYGGLcge4xZjuMMS9rQ+F4YvO7PDyGw3O9zV9OS9GEx0W/M97O4VKI02XLwud893kqhIZ8Jl+eiIXXBkdP+PrsM9YPwEPeIwfe3tQ3DvLJ+pGTmZcRtHew1tcZ7WhPWOq4ryQjzcZnOuHzawh8bvcEevjGPTPwqzdEpCqcZ6flYsCTJVv85Z+9Osh5D4twCL+2cI7L14NZEON83rT524f9WkXHmQi+3lZxscij42eTOE/7y1rfifBCf5zysZqfkyVjYSGqk4MMvFXvtjd/3xOGyH2fQmXbweut2Toj02Bw2bjuUEl0b3bACo5T6GhDs0+dZqzxBtYFPmk8hzLKQT291RLHAj8NbDLO2DiLbL2XykI/c+1j7mDqcQ1yB6bXm7rnhwPsQ17WgW9P/bxWsW4tfQtaKzyQF3NnB136O/kA/hAfjP6LI/Up7mu+4yL2mWdbGow6YDPWWQz4A4nj5LhQqwVKw33wW1LIjXWyBmqdPuqm2QG6DLiBF+i+AT4D1AY+bq/WyBGowgh6UIusl9qWyoG+zlby5mUUMbYUuAWuWlwrNZm9p/hqgKOprGtwB5VbA04Ahw12P+gh3xiXSy6oz8yTrQF+0m32GuDJW+QK+X/kghyAzwIecDzUcHYHuWROrI06Mi/ik/lgPqMDe8yh5q0OuUdOmKbyuL13xPrjGerBG3LIh713sVYNctYS/1HlRE2oPBI/5NpCT1xzs2wHrGVjW6pXi6ADPcCNE9SzzX6D+eArhrpIMhe+arFJj7QlNt5SVqu6MZaYdNQFYJC6/KE54z/WnPb/mvO4aVBfQN+1DrBhz9GmS55Vz3GNdVUbxW/tyS+LyJQGZC+NEaPEhHVQh0psG0dpQvGIWpY5lWYQT2bpSlNwN33UKfZbaRntaa6NvEKfMtC/n2tBj709PO6p7Ms4B27PeK96pW3XlBx826q1n0s9EieXvARoR54VX8jBgx/8mkqfuEfuyfQH12hTXOet0vmwhXM+M6k79TdG/epUYaif+DAX9kPyNmo9Y3ALZd9l76SuvvswagbOu1CF5amfwNxIzGGF3G58uLPjCLyZeK4aAdtDE1AveWiFP3IoncSDq+5W5s6kHjO4S/Lc8vtLPrT32AgvHwzfLvibjw8ceFqk3W8fSXJrfCEt07JI61sPLi1P6rPyMF5U1Dnl7DxGmeNeVKk1e0Z+v7hgMj66Hsvvx520/c/b728='),
			this.addDataEntry('', 42.86, 48, '', 'jVZBd6M4DP41uexhHwEy2x4JpIlT7JSENIUbAcbBQMkrEMC/fiVD0pnDvN1DXyzJ+iR9kqhnhl3266/oeqFVkhYzYzUz7K+qasZT2dtpUcx0LUtmhjPTdQ3+ZvrLH6xzZdWu0Vf62fwfB310uEVFm46aUVE3QzEp6kt0xWNWRhx+l2mSNdG5SO263rdFWoPp779Af0u/miyOCjc6p8VbVWdNVn2C8Vw1TVXChQINyyjO+VfVfiZ2VVRfYE/Sn1FbNL8gWEXG0bOprqCN6msaYzE/sz6FtJcqEeuu1e4ahIqaaGZYo6i/1Dc+05d9CQXbbxumh8PSPJ/6NpZaFm32WuxUN9dIjGRYGHRY3OIyvlFhddR+lkkZZ2QTXsOPxD4b/JlkWueKI3d9q2UHa2AHc2Ai4FTwjKwvRXRKqsTRMiVvkmu42VdvB3K/l71lgUjXq3/sg8UhFy099QXZ7Bfx+vhMPvdFuvFugcEkEWYbG15HNjWPjf0ttufirPe3WFQ8LpPs1bFq4pCOZR2nfjy8+jX/ebDQp/+zTww+K0kP6OPJyefJNcY8Hrn5fR6eQvmQvfzpvC7a8PQy7I3tJVwXxfnT4+HjvH8/l4WGfCYfrIgL1gUnVvj64j3Wj8BDPiAHdDB76hOQ+bcsA7T3IEtXeAazCU+d1TMRq5bJvCfZ8hoCn96BQA+3GTMDv95iRmOFS3Fev0iMrNjKnv77FmLewjKU4YeHcTJXmiUxLpddl2/f7Oc6Oi2K4GO7icuXPDq9t4nzsD+5+r4IP+kvUd42y0uy5jwsi/rsIAPb+tVmy9cD4Zi57xPNFSud2ZbuikBna9oyx+pdQeYwFTp1SMt8DtUHHc3Mxc7xOLWtlvrWwj2YHfV5C9PY45n5RzjHMhEr8F/NWY6/dAFdbanM0a+DM0wjYAjAkFQ/21pPD8C0QzgDfOa8CxenEbF8T4fznIoccFcYz4QcBurnDeAOO8BDOxNHkC3YDg26ssJc4E5BoQbAtgZqm5LK8AJxDNgKyCmeE8fCfHrl78SNqu9E4XfV7Q4axDvOwdYz4TVj50HnBxrodOaHJzaYCyq2iCl3ChPrHDGJbRrUXzVU1XGpGcaQvIGJmgeDOex8MsW55478Y21jjHgwNbjTUgdyELHih4l9DZhgP+rESQT4IBcdkxR4JCbUKiEnjUoO/csHsGts5GrkTnj97jDKTFhDIrx25wRGIC3uilzbQX3MQWyYbIcMLsaSgfGQD4CNvcN70jOQG/iKYI0d9Bb7YSL/E2/Yv4cO47nIk0On+4Xu+h7U5xm+E6AduDu2O/8oYR40NTsZ+IjATATmS+ZnB34l1Qjchy2F/o2y64/yu4C6BZW+gzMH/RrQ3zICjO9QzHfiPQBszCmeehk0il+Hq9pgnofHLAEfOEM4DzvYA8XzyMOdA9wPPvaZN9OOYBy1I8wnixFLzYPqQ5rDvNtwX1L8MgIml8HUN8Wdyg9wsY9i7AfsgYmzBbks1Iw4MezjUWdqTrG3fJjqG3f3MMZTvKu4R1PlViI3x7Gnfnzfx2acsXH2gH+oPzahZrgbLJjaCQ9mC2Plw52zbx6BI4zh5NAbqxlzNLudj7hH6L+qFc4cdg/2UCBPXoe7CHgTZ+p70z1mRWFAbva0+6petQe41z9++47i/wc9lCY+A4zl9FCAf9Fp/8fHhlJNL411WpVp8zXAlS5Lmst4w9T/fvoxOl7SjF8mR/Np1EX1KPOH8/fjBQ7T++Uufr+TlO23Z9S/'),
			this.addDataEntry('', 48, 32.57, '', 'jVXLlqI6FP0aJ3fQCwFvVw2RoMYiUQTLkhkCHYJBXAIC+fo+AcvuGtS6d8Ai2ee1c3YeE8MuuuUtumakTFIxMZyJYd/Ksh5HRWenQkx0jScTA010XYNvoi++sU4Hq3aNbuml/j8B+hhwj0STjsgIVHUvHkCVRVc15EXE4D9PE15HJ5HaVbVrRFqB6cc/gN/TW83jSLjRKRXbsuI1Ly9gPJV1XRbgIJRhHsVndiubS2KXoryBPUl/RY2o/8pgCc5UZF1eAY2qaxqrxfziXQq05wMR6xPVPhGVKqqjiWGNU31R3dlEn3cFLNjerqge9nPzdOiaWGo8Wu20GJV310iMpJ8ZpJ/d4yK+k9xqif0qkyLmeBVew4/EPhnsFXOtdfM9cwOrob7Vb2yr29imThHjeJmJ6JCUCdI4CVhDc8/EfG5Eh50WKSxnfMuPebp0ftq+xYCLlh46gVe7Wbzcv+LLTqQr7340qMS52cSG1+JVxWJjd4/taX7Su3uclywuEv6GrAoj3FLeMhLE/VtQsV++pWK672NiiHEk8VWMJx8xL64x8nhyC7pzeAjlc+6dX05L0YSHRb8z1lm4FOJ08Vj4HO/eT4XQVD+TDypiQdvjgYpAn73H+h76d+63Pu4JNzuK1JypeUd9syMIK3un7G7uaLTHLEXOK85xQxCZQf+uIfTO8zFouObUPAbVWjEaVzjPT8uFVJWHbvGX//bqIOc9LEIZfnhQx+GuNAtsZNmmPa+39msVHWbi+LFexcXiHB3emwQ97S+uvhPhhfxVZbuaZ8mSsbAQ1QmpDqyrN5vO33zMFPMgwLqbkynxLbVikwaL3M1jnXKrBTUaUGIGdpP0Vqc6sPEf/w9Sf8Ft7avdGXfYsdcaIrGJkQX+x5ZwmKNz50KtYZzH0ht8zh3UM8BnSgGnik9vSshRqx1NgkRC3nbjgw3qQm3Y3VqzQWvgizuFk9wBrt5syAs13Zz1UEeSPMOgbkt10sK8pVJxVycD/ALwU1iwB8zR6eqobFN6UD5jvSEX7IaRy8iPBEcNsNkG7Q5kzAtjb/QNHOBlTd38bFJbg53j6WRP5JNbsNfw4EtUH6YY7WG8V1ynEXJADzwDrtBHqwddBh02aK900EAXyLfv4K/scuPD6Q6O0JO9PtZTuGdA7xQfBuvWaL7QCXAa9JAWA3tL1LpQDJzYqAn0btAbcqZnTRs1BQ2G2yMrhxtDWvI9h+5D36g86sBXI8ipieoNYurfw6l4zDMM+0nSAPRRWiPMyLBHcEtA183op/zZw//fL+dDnXs9lKa63o354wGAqzftvn1EBujxgizTskjrWw8uLU/qbPQwX8aoLOUse0QZ+o/ZzxGOqhFiz+A/jxIMHu/S5/TP+zfYvjyPvwE='),
			this.addDataEntry('', 34, 45, '', 'jVXJkqM4EP0aX+YwQbHEtI9sZcuNABd4gRsGWhYG4zC7vr5TyHZXz0zFzIEQmflye0pJC8WsxtU9uZ1xneXlQrEXinmv61b8VaOZl+VClmi2UKyFLEvwLeT3L6xvs1W6Jff82v4fB1k49EnZ5UIjFE07lQ9Fc05u/JdWCYHVyDPaJqcyN5vmoyvzBkx//gH6Pr+3NE1KJznlpV83tKX1FYynum3rCgAlNxhJeiH3urtmZl3Wd7Bn+Y+kK9tPEfSSEu7Z1jfQJs0tT3kzP+iYQ9nGXIj+1EpPDQ+VtMlC0YUovzc9WcjGWEHDpr925Xgy1NNh7FIm0WT9IaVW3TtKpmSTpuBJ69Mq7XGhD9hcsqxKKVrHt/iYmSeFLBGVBqfYESfUOzfQGZ5UzWU2ca1dh8NURtSo40N5TdbbJSq2b05hKy5FJJPLS7YC/wIzp7goOEBQ04a6ahQ2G2Tq31LlQzutdiRbl0Mcws6s9mpmLotUwdSnGsssneSTwbLVcnAObn9aLSePGlMsoxqbA4GKZcfUR5ehmzcZS2RyH/tLH3cCnxCPs4+FhY819I86PlXnrz7K+Io/acxwbJKDVkbHzTqt3i/JYd9lpnF9/b/vu+T4wfxg85bK+2mnGOdI3vuncs/iAJE8RJyJEZgEdsnkB4i5ATAZcvkyggzMXUYMzOWWDVjUuSEZgd1bbEl0+xt75vbC2etT0yhOq3fG9zVVtgOi3/4bxWP2cRWz+Mh3zKYOUyuknM/ecNn45vKffVov+zdH/jsz/to4wz6TuCqbE1SaHTfNd9M1vkPXvPIwRLJTkDc8SZ174AxcJBzoA7IwdIg0p4hgXnTJKVIZ5mtyCn3yAh1wnKF51VyTrzwGt3OWXrI0r0rEcKBKONwUeMbyHJAPZknk2WlOiDpsIQ1Z286zdswJ7Q4DDlmwMi6jzgvtCVkC54QC95QDKwIcmaIw6mDiiEtVmFPeh04gl/TIKerfYTgbW8i9hVqw6B3OjheAD9u1/DxhlkKci7QvHnGZ3mI+EVCPW2wVJxR18/q8EOI86tn+a344CQVWMYU8x1uLqTqBD8eonsU5kUTMQJ14fsgDpyaCOtLBpRKfStXjGMueACPB+W5fHDKIDVzBNKoOr9+KEcSVXSsrhBwRiM/3CfbvFV+G+MJ33hf0jC3jkIh+xD/Urr551lnGzJ4x0YyFmBTqePZnwt1T2CqauUnlaPoUc75bXrFEXsAmFoJ7Cw1uhefeBU/PvkE/z9Cjb8DzvDAPZOYu+JT32T/kzSnqfRoV+cr+yxd3JZwEuIcfjwlc4/n45YM0qx6v0Sqvq7y9TwAZaNaeBUJRhdc5p+T88FI1oUsaIZOX56/XDX4eD9xT/PWQzrbf3tmf'),
			this.addDataEntry('', 35, 45, '', 'xVZLl6o4EP41bmYxBwHntEsetqYvAW3xxQ6BG0EQj4I8fv2tChG15/SZ3s2CE5J6pL6vKpUMFCOrpxf/fKB5GKUDZTJQjEueF91fVhtRmg5kKQ4HijmQZQm+gfz+jXTIpdLZv0Sn4icGcmdw89My6la6hWvRpGLhevDP+BtnPoNRj8K48PdpZFyvn2UaXUH091+wfosuRRz4qeXvo3SeX+Mizk8g3OdFkWegkKJA94Mju+TlKTTyNL+APIx++2VaPHnQ0pihZZGfYdW/nqMAwfyO6wjC1nkg2n1Vuq+gK7/wB4rWTeX3640NZL3OALAxn9my1+jqflOXQSvF/uxTCsz8ZimhEjYjhTajW5AFN5poFTXGbZgFMZl5Z28bGnuFjUksVVayYparlfZSa+2lWtHkyGxzVVKTqSTWc2+TnvzZYkySxdBKNNUxCAvl9BhOwT6huNY4SwIxfcS2unOvH8TQ3gLlc7Sfrlg4SyvPhcxM12pojJNAofE8HrWhqbGo0dtwOq6sjX3bT8eNE+uNJ5OcGhWDiGXL0Gq7JWen0cfEQJvJtzZ2AzYurbmNSTsbs7qJOJ6im08/U+9En1YMt776m1G6237Mguz96G/WZWjop/7/fV362892vvwYBvK6WSn6YSev5/t03XpLwiKXIBONlSxGdgxzk89lKyFDinN3AvNV6aCuif+ktIEJYPfsmVK8eGHPWByRvVtg6Ml++t5iXgNlUZH47b+1avB58zKv9baYsUlstWpGlMPBqY4fc2P8b5xmL3+z5K/MzGf6AfLMvCy97iHScPtx/WXY+i9AgpG7LpGgfoYO1k6jVo55SOhSlW0zYNTQkBGFLqXSMYlETEBtBrXldiMxtcJKAtkGOcU6ciclbVljLVWFmrsC/Ki2S0FnUdNYErYTtKnsWKrvtnaryUvzyOW7Bue7IfoG+xb27X075qoVtqA76WOzk4lKzAmvd9hbpi5jYm/EAPvsJMCm0mTBaKxKdjv5Mr7/s3e1AnSGu3YC/hYK7H/XgXhZYz+4EKNWIU47WYGcwLlDPFTlOAFPH+9SlahLCmFbP3EjbAHPkY24fEMFn+D7zmXvmw1p09l2fN5j29UOx4jn+sEF7s0xdLl8yd/XMcqgh7hBaW/onXu0a7vc4f7aS6563jGffS5x/5e8A/eS4J7XT3uvm6/jU+6FPuIXOpz7nvOee2Jw/krsMjz3nKs7F5wr5EfgFLXBY9WeuPR43in0TmquRv9L7k/0+zpPaUNjDeMeYQzwP+JndUu57gP3Ey6ZCt6wRu518XImeI1ER6nB8w53BcSxTgBvzXUMDfZmgAVibVcM7pPGcfm5aYAvk7ZYI0eoJYjBxVqj2D/g/tCkzg76iKEO+R2k7FpqiJ7COZzUvEZbjJ0CTojdJSKHmMujhPjxbCM2wFFAnuAG2Yn9d8WXeIgtA3997BLEfux6TYtcrjp+xB6LhvuAu1ErHTfAfGAcwCnpesqjB27AL69BxChqXPDS44B7k4zsCW0Fxw3ny1BVyGWBdzLWvb0924ALfQMbvKfheeR1RRvpS12JccWUn/fBe6672gPeikc9wJndvuSA+3ycadrlGTjpa+MHteObpOJvhg3tz2t/Nyxf+mxx768vd9+bpcCrp1XxIafo4qkHj6yo/va5yJfEW3Ea5VlUXBpQqeKwOHQayqizOkQxOwgrVaz5127OesvH2xN+xPPzPn08c7ns5RX8Bw=='),
			this.addDataEntry('', 45, 39, '', 'jVVLk6o6EP41bs7iVgSsMy4hIGaKBFFQYReBg+EhloA8fv1tRMc5i6l7Fxb9+jpfdyftTMZFZ9749UzLKM5nsjGT8a0s60kqOhzn+UxCIprJ+kySEPxm0uoH7/zhRVd+iy/1/wFIE+DO8yaeLJOhqvv8aajO/DqKouAJfLU4EjU/5TGuqm2TxxW4/vkF9nt8q0XIc4uf4nxTVqIW5QWcp7KuywIC8tGh8TBLbmVziXCZlzfwR/Ef3uT1twxqLpIRWZdXsPLqGodjMX9EFwNt7UFEfVnRyzKm4jWfyeqkSqvqnswkrSugYLxZMynoNeV06JpwQIKvtyjUy7slR3LUL2TaL+5hEd5pqrYUL4eoCAVZB9fgGOGTnCyJQK2Veonlqg3bqYjtlI4NYUKHrGG60xGhlcEhv/C1syQpXVipg+iOJJGUZ5EJ+NSZW6khs54Ap0/BFN+tPglWP0J5uziZXhKt8zZwYTLmXonwMg1lKjZiMUS6msS9NkTmsrUO7H4yl70ttD6QSElxmwBjycIqsCFXu9eWBI8Y40cM6wHj0u6B0emE0dv7k8c3dhtzmwcX+s2C3a7ih0XuHz/XYbHK+GHfRFi7fMmrfcOP22Gz+5yH0r73ZO3sS/vNKd8PAXQjdsmzO1nHMOj6Qx+gW6096q4ButdQPVOgowqFftBemdsuTMPMM8irkVQpiHw+22028nnUSExW+Uc2njv2S1jDf8UYkG9ZBBeWRzqcsSP3jfDT2DR+Yyf7sKTueir25zCLev+wvQaHBfryu+09MPdF+D7jIzRXiGOt4IeuetRetCVBxhVqGDkza6fMie4346z8Qa3pTlFsnTQsdWTLpXCDwo7oRmO7Tme5TsMGf+4NTkMHb3hjMzTKXIfZpZ5im+M3g1umtkSHHK4HffUR61Vkpcmc9urkP37F9WBXqFBfOsSFEjv6PdzmBdNXKcUvH3pw+8rrTtyI7jS27g1hj/pxhu9c6O8zvUSyUrJgJh1rhdxGQjGCOXtz+5l7rHPM9crt9Wh8WQPDSmvrST2+NjqQhrqOHGdosLGCqEsSZiTwknyZXfyBgg14l2McG+g8Fu85bqZXDLcXNsRzzcGCibsfV+XD9NyTZlwWcX3rIaQVUX2eIpTFhDrHIjk/UfJysvFq0pMv5HvvgvBcvS/1veIfvr/+Af4F'),
			this.addDataEntry('', 48, 39.43, '', 'xVZNk6o4FP01bmbxKgLWdC8RaDv9SGgVtXGHwEMQxGpRIL/+nSR22zM1b2ZqNrOwuLk39yPnnhszMp26n73Hpz1r0qwamd7IdN6bptVS3TtZVY0MUqQj0x0ZBsFvZDz9wjpWVnKK37Nj+28cDO1wjatLpjVacW6H6qY47+OTFIs6zvGdZmnRxrsqc87nxaXKzjB9+w36a/beFklc+fEuq16bc9EWzRHGXdO2TY0NlTRM4+SQvzeXY+o0VfMOe5r9iC9V+yWCXRW59GybE7Tx+ZQl8jA/ij5D2VNViP2hJR8aGSpu45Fp66XxdL7mI2Pa1ziw8/rMje0wtXab/pIIUsTPC5K4zdU3UzMdJiYbJtekTq6stDvmPIq0Tgr6vD1t31JnZ+aPtCCdX65yP7QvfGkPgWMPbLAEd1lBZ/sq3qRN6pKClezCxFzQYmrGmwWJlS4vXouozGbe787SzlELyTZ9RZ8Xk2S2eqTHRZU9z6+RyQUtrUtizjv6fM4Tc3FNnHG5M/prUjZ5UqfFd9c+U5d2vOhyFibD9/Cc/1ja0qf/tU8CH0+wpfSZi5vPg2/qOj5rC/vDdrMVn+v54WE3qy7bzdOwMF/221lV7Y7zfPspL9a7uiISz/SNV0nFu2jDq9CYrBNjBfwOw+uSDtyxBtSKdS7XfbC0xtyheRZ6j7SklwC1AS+LhcCqsDomDsC0OrwuX6bAo6bmfh90hxfUJ9LZY0dn/By9cQG7SF278MU/7fEQ77HeHnmlerSk169n9I3+tKvX++SQDtFmcdpuJuSOSXfdztZ1cs/xkMyeSOxM63jTnxF/nNRdQ4l3whlkzZyF7MJDagJzyy89ix+jwS95w5ZWzzewiciirp2r9dIizGU32e79UvYWGLjzCwtXg7+EDIyYsImUuThcuDsfJwOBfS73m9AP3D1gT2JGSp8jH+05ZO6uDL9k4CsBznRQspebfhkZfMZa1DdmOh9k1jHp71KBmIQrnW2pXGU08WWNLpX7TF5I3Ur6T5RPycaqjiWRdRiy1kD50wmTe90c8pwgZweb4GWEOj3oojHHHMkYgZugLq/j6gw2sKNCxQsP4p5zLb7EJCqmI+V9g3kcMzc1/BB4kRz77I4bHr4rQV3ZE+Ds2B360uLMY1bK/AeLD/Zf7lG2JQFmqz5YRypesFH1T1Arzsla9M1iwD4IgSnycjcyJcbqDIIB+wR8Rx9Ke0DMj56agfuCePlE2oCtpWzghcKwzvvAsYzA5VOcCZjK+uhYccaxe8w/kX0DT8bcfSmB4QQzZvAwlzzquOvJL8EdBX7YhOG+Ak4Gf5M8ZGNe445ybaJ7r/ot9Z3GMZkoTN8UN+Br6bOU84nqgaH0PXL3LJRcoJhlq8f5ZX87Oes8XEv+CPRX9mhQXBJUxh5rfgID2RuZ78Zr8EfzY6l6KfyPvOF8UHwRicolORiEci+48clB1DXc+AA/bbctzeH1BhiC31XJkI9rjAVmoVUzF96+S9IrPA4fvJExEgMYdn6o+oZaEV/Lel7foh5fg4sXxLZlbDlrFitsFevWb713k+u9xn+Zf/mfYosv80++zL+hOXTrT636gxrknXuQmEqe3OZL9VlkNelht3CvtIHEVtdk/G1Nx+iz/j9xR9y5k3+9m4bPu0n1Ly1V71zwoPRM1ZsQd4Cgsh+WvuOoFTsE82P3zPgf7qbnqJWc5WWquMJUP73el+cO9bxjZsE1cN+VfPS6QP63ieiW687TZLjzEDOBeldKBvYt13dGjrMJHm7BMdSO/wc9w/L+yoFfRLLi/j/1qt8keM/gvXN7tOG5lPW/fPgp1e3VN8uaOmvfB2zpirTd6x3Wg/baZ0W+v3mZj98sU6vjs1bln873hySE21vyY3l/syrbH560PwE='),
			this.addDataEntry('', 41, 45, '', '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'),
			this.addDataEntry('', 48, 48, '', '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'),
			
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 48, 36, '', 'jVVbk6o4EP41vuzDVgw4Z3zk4mgcEmTEUXjjNhEIYgnI5ddvB5yZM1t1avfBSrq/vn4d7JliFN36FlzPtIwTMVNWM8W4lWU93YrOSISYYZTGM8WcYYzgN8Mvf0DnI4quwS251P/HAU8O90A0yaSZFFXdi4eiOgdXeU2LgMOpJ3FaB6FIjKp6a0RSAfT3X6C/J7c6jQJhBWEidmWV1ml5ATAs67oswEBIQA+inN/K5hIbpShvgMfJR9CI+rcImki59KzLK2iD6ppEspmPtEugbH0sRPvUok+NDBXUwUzRJhG/VHc+w3pXQMPGbsOw3+tqeOyaaEBpsHlDkVneLSVW4n6h0H5xj4roTjOtpcZyiIsoJRv/6p9iI1T4kqSotbIDt1ytYXuttw2tp3vCg/X71cdntNuTUY6xyOM12GdEJZlaEOV8ttucE7Mb4o2o/L2OkpMudvst8k9nZGE2RD2BOq0LQ9TQf5ENQ6Gi1R5eVqFCnshme/FS3jP3UBEz7y1D66ibX+1eXxJjMcTmiie9PsTrZWsd2T1cL3s71Xsfk5K6UQv2qvy9uhX/2GvPlsJQcuzELvWyZL36Zbhd7h/94Ut28udwLRr/+NK/KduzvxYivDjc/7q/vYeFQJLF+MREJFjrHZlw8eI9wgdgLe9HNnp1oFkOMpdyx0Bmw4h3ErcyR5WMJeZKstVQky5Iql99E6XOXjKyTZnqudVWVhQpb/fI0LNw/TLIzJHitCR9/m+rDmLe/cIf/JMDeVapNXxNZbszllVwXAjvtN1ExUseHN+b2PzCny38JvwL/S3LbqOfYb7cL0QVmpKBbfVqMP0VOpGVuy4ZLJi9vUcNO9IO7i3ttZaY0GGmYei6s/ca2GgtvCGJz21DVSngtqn1xFxJu0GebOD4WwbcPQxxtgLmDoq9pu0nZu1VROEV0FTtqenVdC9PymECLTXPLs2chsHLgRjjG6YZBT++mOR3AnYKdV8yy/3MpdWfsaDelu7Ro1409TOn9RjHjca4kH8OteCx73cPbKOOHh42qTpnpgN3bQF9g/8B7KJW5mQu51DrnJoHicNr0GRvMo/8xqY4ksfTlYG9SlOJU8TWMjbFYNPK3LZJ5evBcMfM9RrqaovQzBsG3BITZKjN61X5BQHmQP5Db0uO3Bw4l3NZLaIe6shyWYcy8bGCO+nsQ9szQ+Z15hTTB44gZiR578AfdKtWzpsORJU6aooSzsE22VPorhbgi2XvDHQsizMryxHMfpwfM4nkD7HBkVwgmpF6OrdHNs7VryyXw+w9mNehYW4E79CBPghnBuRKZRwNfBHUSBDwDRz4GcRUWOZxOs7s0I01Q5+WK/t1+okrn8o522bOH7kwcAec8MEbND7V+aO2f53bpx/foPxvwf6gysWh6I/VAn/qSffH9TSqHrtpnZRFUt96MGnTuD5PFurz5HVOUn5+eClPky6oJpl/eX7vOrg81t2n+L1WR+zH1v0H'),
			this.addDataEntry('', 48, 48, '', 'nVbbkqJIEP0aX/ZhowScGR8RUKvXKryU2viGwJTcxGhQLl+/mYXazsbMzsZGdAd1yTqZefJkWQPdypvZh385sSKMsoHuDHTroyiqfpQ3VpRlA43E4UC3B5pG4H+gTX+xO1S75OJ/ROfqvxzQ+gM3P7tG/Uq/UFZtdl8oT/4Fh3HuS/hOojCu/GMWWWW5vmZRCVt//gHrt+ijigM/W/jHKFsWZVzFxRk2j0VVFTkYZLgx8YNUfhTXc2gVWfEB+2H03b9m1QuCmcUST1bFBVb98hIFmMz3uIkg7IkKxHyskscKQvmVP9DNfqpNy5scaJMmh4St5Zxrh3ZiHPfNNehI7M/XJLCL20IP9bAd6awd3YI8uLHErJk17sI8iOn8cDm8h9ZRl2Mak3qRbOVCmFe+MVveGiNXpJIlMqazU+bvwyK0Sazm8/BymK+L5YY+7OJl7CXRzPlqbUwJsZBo32R0vh4Fs+2YntdZNF/dPJ13NDGugb6q6byUgb6+BdYwOWrNLUgKGeRh/JdNh3xTS1fQktpO427Sr3RO5OLMCdtMYMzJUTcrTxuXR51+ofO3sxfLhncm2Ev8v7jtZEzt+gb4o+NsCxy9xdzwRPm2nK2zw5m9rFiiKf39KPPe3+ZBPk39/e4aWpPzczzdXf33dbfcvA0Dbddu9cnJ03bLY7brDhsqI0HHNKHDRcJq14K5rebdIlkNOc6FA3N25XZAaDwxmAAOY6NmXQq8ZingToCTnOqnk1unGE8XzsY1nfHSe+fotwttM150v7NxAG+cH848U3Xa0NuzJqv020JrLsd8dwrSsPX268thPyLPfVHfDrNdHnz6+BbMpsS3Jrm/b0qVe14XlDgXyAFj5iwJrsz2msXGqHkyTRYJHbHWaF2BuTJjkXg1zAnr5BXWmlBxRGs+cxrgRoPagp0nmWXWMK6AP4NboCU7TACz5cK7siRFfI3Zd0zhgM8Vnu9cR2qg14ZprFJzwAFb3bW3MHcIbwnYmQTWIIbTicGXx+bdt4l+EbtzbQ/sU4MPvZGq4Z4hTscT8C9WOvp3xar3v1Hxla6F51ZV/+WI3ULPADYdPrCpyiXoY5vJBmxAowfgaQW8QM6WobPOQR+a8q+4On05bkgLcQx5a/bfXFau4iMrwf+Q2+mVQ1whaioJGk9Q+EKfxhDnBrkE/xtydW3aIMeuCDpq/9QG4k3hXjAMlrxRyAX8T//hwyGLRBJ3D/0Vo930ixAO3BPQya3ZQL0MV0AkFgF+MF6ndXHc0VFfT4hDSKz7kMcE69n1uiCKT4wP6tnea1Tc+fwNR7LXhcLs51xI0msAOd91C+TaDiAO1vTYqEGpe+CXgT6ZoFjLFmoIWGpMIF/EJQHadFvUzohjnIJ1OPYtYmBOvd5SrHOFmmIJ6m2F+aG2QAf4ZTp7v2DdDGZLCTy1TGQ/y0v/IS+BfeM02EdYA8DGewUwYV+EqDO4D1FnzuhFZw3mxIWjeop10FOo3/hTC30/gp+nRh3Efum9p/6KhYA4Otl5zxqZsB8Yqn5iNXz24G/7alW9+OxjS579Lj/1wRqvVf1e3e8Q7PdHT6sefuQQpVgDqf/LndOyl3pjPMgfarLXkNcpffZ8tO62bhEDYjTQH+gd6uGR/3dHOa93lBp74s5zfz981kOslEZZjwP3AmKbuuK4o9gPjWunyAFBjhjoGLFULD3fTyzIldzvpT3U0MD+eelHojSs+nGlcsd+FLYH90P64PF01wvqVvv5/cVQV8OeTw85h/7y7r0N+/Pi8/epw9/dw3kp8XWFf5P7EwweP1Hzy2ecWrq/4WZRkUfVRwsmdRxWp97C+NafOkWxPFU/rvllP5fPk59vQhjcn4WP6efzU+398Dr9Gw=='),
			this.addDataEntry('', 32.14, 45, '', 'jVZbk6o4EP41vuzDqQh4zvERATWzJIwSdfANgRNBEGsAufz67Q46M7tVZ3erZoqk05evv+6OmehW0a3ew9uZlXGST3RnolvvZVmPq6KzkjyfaCSNJ7o90TQC/xNt+ZvTqTolt/A9udb/x0AbDe5h3iSjZBRUdZ8/BNU5vOEyLUIJ30USp3V4yhOrqrZNnlRw9O0PkN+T9zqNwtwNT0n+WlZpnZZXODyVdV0WoJDjwSKMLvK9bK6xVeblO5zHya+wyesvHsw8lWhZlzeQhtUtiTCZX2mXAOyFAmI+peQpQVdhHU50c9xqy+ouJ9qiKyBh63XNtWO/ME6HrokGkobrLYns8u7qsR73M531s3tURHeWmS2z5kNcRCldH2/Ht9g66XJOU9K62U66wmy4b/bMMlomdpJlMqWrcx4e4jK2Sar26/h2XG/LV58+9dLXNMiSlfPD8k0JWEhy6HK63s6i1W5Or9s8WW/ugc4HmhlNpG9auq5kpG/vkTXNTlp3j7JSRkWc/mnTKfdb6QlaUdvpPP/yg66JdK+cMH8Ba05OulkH2rw66fQ7Xb9cg1R2fDBBX+L/zesXc2q3d/A/O612wNFLyo1AVC+vq21+vLIvEkt0VXiY5cHbyzoqlpfwsG9ia3H9WC/3Tfi2HV79l2mk7fudvjgH2v71lO+Ho09lIuicZo7hZmzgKext3NPOzaJW7YUDe9ZwOyI0XRhMAIe+MSBndJVfwO8COCmofj577QXxDPFq3tIVr4I3jnGH2DZTd/gvHQf8zYvjleeqTj69f9Rkc/npat3tVOzP0SXug8P2djzMyMe5aO/H1b6IPmP8jFZLElqLIjx0lcq9aEtKnBvkgJg5E5eGiah2M6fjhQP5Mg3q1bAhkMwyW1hLN6Ma6w3CxTZzM3Pq+UbHe6P17Aj0dmBjAm+7gelBz32jZzbPwBZ9aC7osow2fABugS9ubxpPSD0QEENsJENfKo4JawI2Fx1rwHwT/fYKi02fWADnxuAp+LRjCrXpR8y/0wN/wtTV2e9iYQ2HZeYi7gztqOapsw0BmQbYQcYIt4jCvc+Ar2ynBYOJck1hETtYw1T0Kj9YXwZGWsyDKF/C0YLe6LnCRQnoTbkI0N7glmF4ygbWK9nhHHJxPCNW1iMHzqDwWmZHlS4FbJIkBakZxOZCSvgSJpbUswyYzGUFuKeg03CxmcXYs5kzDQRtPHuHugbcCx8c8IEZyI8nIogDdUIO0V/6qePZpgb5dXifAJ4Z6kHffOH6MoXYPdYEbb1Di/zPwKZlb2AHuLlYlsAT1Gh5AJ3eE/y7EBvAaEJch7iZnHkr1gL2GfQQYbasGX7hLmOqNs/9vhz549CLsvNGDFATChg3+sgZ7XmK302vcrWMGRNYx00L+qrHPYuMes+9I6fYT96B1U+/rnj49bH3g3rEob4Dz87fTwI4HmRHoaeZCPoA6585yAtwvgN/DtYa6wu8MgPjYe4cewj7Kwtw/zETUY+9QgfAAfEfPZhdDK5hjyPvzj9438DdpLjE/oVegLrYaubgXgJM9mXEPsCc2nLm2zvA+9CFvmC2OfZ/hv1r9tjjcL+hrPUO/xYTsGUXEiBevCN9lZOaEwYy/pgZXENe06hXd0CNeXGVL3IMeR0YzudM4cGeytTM9cD119nEWWhZ+rwPPmaBeDbOkNNyvfy8Vwf8vTheXyW+CvBv8Xg6wI920v32+aFEj7fHKimLpH7vQaVN4/o8aujat6kxGp6TVJ4fhsZslIXVuJcfxp/PGVg8XjTP7efLSZ397WH1Fw=='),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 38, 48, '', 'rVZLt6I4EP41bmYxJwJ2t0sE1NwxoIJ6cYdAxyCIR1Aev76rErz3zpzTZ2YxC05Sj1SqvvoSMtKtol3co9uZlUmaj3RnpFv3sqzVrGitNM9HGhHJSLdHmkbgG2nz31jH0kpu0T291v9lgaYWPKP8kSqNUlR1lw+K6hzdcCqKiMM4SxNRR6c8tapq+8jTCkx//gH6Z3qvRRzlq+iU5uuyErUor2A8lXVdFuCQo2EWxRd+Lx/XxCrz8g72JP0ZPfL6SwQzFxxX1uUNtFF1S2Ms5qdoU0h7JhMxX1ry0mCoqI5GuqlEbV49+UibtQUUbK2XrnbsZsbp0D7inohouSWxXT5XeqIn3URn3eQZF/GTZWbDrGmfFLGgy+Pt+J5YJ51PqSDNKtvxVWA+XN/sPcsgrI+5a3NBF+c8OiRlYhMh5WVyOy635dqnLz+xFmGWLpzvlm9yyIWkhzany+0kXuym9LrN0+XmGepuTzPjEeubhi4rHuvbZ2yNs5PWPuOs5HGRiL9sOnb9hnsBrajttJ5/+U6XhK+uLmH+DOYuOelmHWrT6qTTb3T5dg0Fb93eBH+O383rZlNqN0+IPzktdoDRm3CNMKje1ottfryyLxoraKvoMMnD97dlXMwv0WH/SKzZ9WM+3z+i922/9t/GsbbvdvrsHGr79Snf90ef8jSgU5qx8SoLDbcD2ZayscouGhNod0AOH6x3eipmBguIYMKYeHYIuOYXiDsDTAqqn89ec8F8+mQxbejCrcJ3F/ftE9sUq/7ffByINy2OVzfHPjGfPj96srn8WGnt7VTsz/El6cLD9nY8TMiHPWiex8W+iD/3+BEv5iSyZkV0aCtZe9GUlDg3qAFzdlkfPlyb6dS+PFi2z5hvDrKD/GlXmQN44LjjUG/nvocdcEX37PkZZMI6s1tlm57aJmcW+PmGrtbFBjuwGm1uh9zitYyd7bRVALEzrgPWY/fKQG90nu2ALwWeELXWJ9I37IjMB+KO4dPcIET/xgswNqwXg/8+bFmH+i1jGD+4EGpvYAwht/jh9jvuYr79uWIB1GqzVurBL+wgNtQJdRng96q7c31jAnkDLjvoeww+DGozoPdUyogR8iHJqDHU21AVA3JjxLUkbhrrMEezh/oBKxNluQ7qHSu8jB7XQF09C5jaCzCBPBqs281o/VoHdSMWrWefq1UQQ27OZAX5eIGJWCH+r1hjxJnZFyLx9gns7QBeMibW1qi4mB/G4zC/4D0wzAEHO5yAr8TEszcyDtQ+DmE/t78gH3QPcpS9l5htGuiHzD9UMZETKo7MH2JBT1jAjZPNsBZD8gx6sM8cHc+at2sI4GJgPGYhL+Yaw7us523YmxzPp2cRWbfEP+PtwAvIAXnpfOFc/D9zbvNPzmkwth70HeJz1XO0oY859BxlqOvQTBS+hCiZKQ7IXsYqR5UT1tGArVY4SE4oHIHLKqbkDOYD/Q0Vp4TRSp5ivxWX8Sx8C4IBV+Ae8H8Mukz29uOcyr4Mc8B2ieeKKm4HXP88z2BbNLWn+Mg9icsxAzvirPCSGLzwwXtU+vSSN9nuC9ZoU1gHluR578Kd4sr7Yjd88cDfsFc5kFd+MhZ74aa4rnl2kqm+y94hr+rPPijO4H5x76jzPPAHOGFIv6JBbCdwZl8j4MZxXzVCvwZOyP/piysfMRQe2Bs8Wx3cMVzlxaVfKj7v8bX6b8PfC94Ew8MGnhRp+9vHkVQNL6NFWhZpfe/ApRFJfVYe+g+16pwKfh5WGYMuqpTMP1Z+vrRgMjy2XuLno07a/vbm+wU='),
			this.addDataEntry('', 42.86, 48, '', 'jVZdk6o4EP01vuzDrQg4d3xEcDSzJPiBOviGwI1EEEtAPn79dgd07j7c2q2aKdNJp/v0Od2akW5lzeIe3M4sj+J0pM9HunXP87JfZY0Vp+lII0k00u2RphH4H2kffzgdq1NyC+7xtfw/F7T+wiNIq7jf6TeKsk2HjeIc3HCZZIGAz1kcJWVwSmOrKDZVGhdw9OMv2H/E9zIJg9QJTnG6youkTPIrHJ7ysswzcEjxYBaEF3HPq2tk5Wl+h/Mo/hVUaflbBDNNBN4s8xvsBsUtDrGYX0kTA+yZAmI+d8lzB0MFZTDSzd7UPoqHGGmzJoOCrdWSa8d2ZpwOTRV2JAmWGxLa+cPRIz1qJzprJ48wCx9MmjWzpl2UhQldHm/Hr8g66WJKE1I7ciccz6z41mz51mi59AWTIqGLcxocojyySaLsZXQ7Ljf5akuffskq8WW8mP+0tqYALCQ+NCldbibhYjel100aL9cPX+cdlUYV6uuaLgsR6ptHaI3lSWseocxFmEXJ3zYd820tXI8W1J437vbyky6JcK6csO0M1pycdLP0tWlx0ukbXX5e/UQ0vDPBX+D/zW1nU2rXD4g/OS12wNFnwg3fKz5Xi016vLLfdiyvKYLDJPW/Ppdh9nEJDvsqsmbX1/pjXwVfm261/RyH2r7d6bOzr+1Xp3TfHbdUxB6dUkk7R84bloBtv+yOo+3NwWYVt0NCk5nBPOBwa+iuNwde0wvEnQEnGdXPZ7e+IJ4uWkxruuCF/8UxbxfZZuJ0/+WD8abZ8cpTpdOWPl6arC/vjtbcTtn+HF6i1j9sbsfDhLzOvfpxXOyz8DvHe7j4IIE1y4JDU6jaszqnZH6DGhAzZ3JdMc8n1PYr0J/4rUGYPa+Y3I0d6dcsMcauDXVLs3XkxeCWWVPLaJh9KR1pNq5ltOCP67HqoY5rzIP73k5b42d3EcBT527hnm3CGnrSMltmGR3rjoXjzRvgGPKYGsQn/MAgFvaO0XDbh/WudSEu8zCfAAwUeolAXGpAPDzXONp22DmgB+Qulc+uhhrmDbUpzAPreIZ5wjH0YsW7nWBYh8K9I7wlWF/jwyfzzImDdXg7OJtr3CJKcwfxyDXs+WOe+jpgbZmKySYYU9XZxxSQp2Fb0mAd7qIGHne6axHopb2EvQlLhjxP7MC/qk3l2IDfGnyMGjAAVsWPxhc1xIRzzxfAMNxBLkz4PgAepYBaGWBad6AHgZmD87XWc6W4gxrmk8HWmP0JdRkGl5EEzJXrrQ3ITTA25CBM0hI14zJ82RC7Bu1q5Bj4QG5aqAmwmV2vh+i+eUP9XnuQD+8zg7WD/5dfQv6a2xHjCZ5fBOg94R6Hflir3gHdQJOzpvDKfeGitt1agH8DvSkGu+zt/QHq1kBlhr0H+HS8z+xIYl2sQ7w97xw4R0y8G7RMENOcuJaqrXHVPdVLyAf2EPaDAXogzwMPTw5wPsxeZ4sMM4J51IyMmbz0sVQ/oA7pm+fNoR8p6GY2HLRzbS4H3VqlN+KTPtraoAfMgcDeAiwX7JGadzCPnj92Bm1dxS/mVbNbDvkU70xpIhQ2H7nxlKZj3j7nkfQ91vce8A+8d2LioK+8jHEmuA29BXGgr56cffPo+Zijhh4CjKTHKM2JiuuB/qpWAhhDmAPWKp5s5CxssW8Ql5of6IuhV1QMxDbMfl+vmgPo36/8+zu0w9+G43Ul8AWAf7PhmQA/0HHzx6eG2hreGYs4z+Ly3oJLnUTlufcwtB/vb/3Fc5yI83DReO/3gqK3xevy99MFFsPr5Wl+v5LU2b8eUf8A'),
			this.addDataEntry('', 48, 32.57, '', 'jVVJk6JKEP41Xt5hAimcbo9sYvWjChXUxhsCUxaLGAJS8OsnC+xlDhPvRWiQ+eX2VWYtM2SWwrlHtwupkrSYIXuGzHtVNZNUCjMtipmq8GSGrJmqKvCfqau/WOejVblF9/Ta/J8AdQp4REWbTsgE1E1fPIH6Et2kyMuIwddIE95E5yI163rXFmkNph//AP5I7w2Po8KNzmmxqWre8OoKxnPVNFUJDoU0GFGcs3vVXhOzKqo72JP0V9QWzbcMesGZjGyqG6BRfUtjuZhfXKRA2xiJ6B+o8oHIVFETzZA+qeqqfrCZaogSFmxu1lQ99YZ2Poo2HhQerXdKbFUPFyUo6ReI9ItHXMYPkukdMZdDUsYcr0+303tinhFbYq50brZnbqC31Nd7z9SFZ2oqtRjHzqWIjkmVWAonAWtpttUwN1B03CmRxDLGNzzMUsd+MX2dARclPYoCr3eL2Nkv8XVXpOvtI0R0wJnWxmjb4XXNYrR7xOY8O6viEWcVi8uE/2vhOfU75gW4xpYtPD9/wWuFuVeqEN8AmSpnpDehuqzPCP/E67dryJmggw7+TP5vXm8ssdU9IP/i7OyhR2+camFQv22cXXG6km+IGYg6Oi6K8P1tHZerPDoe2sQ0rp/y6tBG77th47/NY/XQ75FxCdXD5lwchpOPWRrgJc5w72a2QqVuSd2eg94RLu22tLck2CLomUYC6BfXOjLk0Ncih7wG9KTE6HLxulzyGRJn2WGH1uE7lXWHxNK5O/yXjw35luXpSotxTj5+fM5km7+6qridy8MlzpM+PO5up+NC+bQH3ePkHMr4q8Zr7KyUyDTK6Cjqce1lV2HFvsEaJGdKsrAlw17AjGCtbE6OpKVDqGJLZ8TXBLVysLMB7HLti49v3Cvfcc0N/rBr/rjnLpnrawPsK0ZMBfab3oPeeYHdQC0p93SglvQBjJEgBp+9Cvoc8iA3IyqVcb4uKCKQV1+ATYW6UBtrIGukBDyzJd6TIG+Bb/+s2XoWhjqk92yolekoHPRGfonkbtkyXoCfxGCvAhaESsKlbT8Ppc9Ub5h87InLxE/A2QEs1+gqHKa8IJuTL5G8rH3rBUxxAwycQrEdyAc3QYMtG30H2Yc9o1CDBpLroQIOsJ4cuEIfLSyec9BoIOewhblAvsBWxz5bZOFm4Zxy6DXEyXoSp1aMJj7Q72yrkvdQQI5xHsSEe8HShZwDBU6eNc5E9k7W6YlFfwbBdpwh5FIgv+I5TN4hCGxHopIO/BHNQuC77YivCHlmPFN+cQe9nXSbwX4ic5iPnDWcIb0b90imD4Brk5/01yf/dfV1NgZ55k/XDZM3u/wZz+sfLt5U/PUJGaHn++GkVZk29x5cOp40l8lDe52iLilnl2cUUn8sXiY4qieIfQZ/PUkgPF+lD/Xr9RttfzyOvwE='),
			this.addDataEntry('', 34, 45, '', 'jVVZl6o4EP41vszDHGSZq48INMZLgraoDW8Y6BgW8QjI8uunAtj2LPfMPHCS2r6qr5JQM8XIW/se3i64iOJsplgzxbgXRTXu8taIs2wmSzyaKeZMliX4ZvLbL6zzwSrdwnt8rf5PgDwGPMKsjkfNqCirLpsU5SW8iS3PQwbrKo54FZ6z2CjL9zqLSzD9/hvoH/G94jTMnPAcZ9ui5BUvrmA8F1VV5OCQCcMqpCm7F/U1MoqsuIM9ij/DOqu+IegZZyKyKm6gDctbTAWZT97GUPZqKER/aqWnRkCFVThT9FGU38oHm8mrNgfCxnZN5KBbqedTW9Ne4uH6XaJm8XCUSIk6TcGd9qA5feBEb7Cx7KOccrQObsFHZJwVtkRcapzkwBxPr8le73GnaqS3GDEPNfaojPiqCE7ZNVzvlijZzZ3EUghHLJKzNLIhPsG9k6QK3iOoacOJ6nvlBhn6girv2tk+sGidNYEHJ2Mf1chYJlTBfMu1PjJ1FnerPrKXjXMij7O97Fy+6gIZFTg5zB1D1zBvGPYs7adXss+9XlNl16J1yQD7QY15cpbbB00KRvOI/zQtBRsNc4cv/YHWEtsKxuusDDw1R8rl4jbpIrCPOe2/5M3Wbm/n/HihadT5p/dbcNIkZL/2x5N2i9Z4ia7HPvjYeNR+S4LDsj5+kAy6o+FE4ri3oHuIxSYSHYEupfNB9iyQD7XrWR34qhj6gLk6d02LIztLt/vNCiWvWgyvHfqBbFL6H6QHu+gTd/r/8hF4yzy4kiwyIccePbbcT2Lb+mHs0oUj/5Pjl91rHn/ryQI4SqGxysNTWwL+nOZNgSTrBhxEzQQnfu2ah97Zq3MfuLsenAucJ9yeOU7SmiRwc8xdTXp/jkxUYxNpyLRqDL0Z11QSq8AQ9qE/X/JuWKMEt06ya3GOm8EGOSCfTHo65CFeWkEvG8BixFBV4uEK79UO/Bis/SBzVcMeYpNfNflNcoYIV3vX3FxghVupy05Cu4GHobeOtxtzemP9u05tiUnhZUD9/cgdmViDmJ7speH1kE5VXO/9NOEm2JCAQyphUbdJq6luUZ8GOFM9ZPVv+ZHpQx7WiTxxLnVOgjRiCB+mip44EyboRf52fJlQRw8+HtxHj6ngIwF/8NnBC5WePVSw6YtewT1kYKMNSRng+hKR8ShzvREYcM7zF76vDHVC7HAu/Intt64x8hn30LvkoLprv8dD/s1F+AImcNjJE78GGaqMPcaG3vRB8g0T6qTtC2vIC74X+C/oUJMu+93AfTynibfQi3sy8Rb+Im/n7vWhd9/yPvmLvH8gvnj9uRaOAv/TXhUjQllNQwR+33H7y0E0qKYpZMdFHlf3DlwaHlWX0UNRx6hLzNllilK1UReWo8y+Il9TDTbTYHuKrwE62P4yX/8E'),
			this.addDataEntry('', 35, 45, '', 'xVZbk6o4EP41vuzDFnI5Z3xEQMwcgjqiDrwhcGK4iCUgl1+/nXBxZram9rxtlRZJ+pL+vu50MpO0rDHv/u2C8zBKZ5Ixk7R7npf9KGu0KE1nokDDmaTPRFGA/0xcfSOdc6lw8+/RtfwTA7E3ePhpFfUr/UJRtumwUFz8GxvSzCfwXUYhLf1zGmlF8ValUQGiv/+C9Ud0L2ngp5Z/jtJtXtCS5lcQnvOyzDNQSJlg6QcJuefVNdTyNL+DPIx++1VafvCgppQwyzK/wapf3KKAgflNmwjCXvJA1HFVGFeYK7/0Z5LaT8VV8SAzcdlkAFjbrm3Ra5fy+dRUQSdQf/0mBHr+sKRQCltFwq3yCLLggWO1xtqiC7OAorV3895D7SyRBaJCbcUHYjlqZe/Vzt7LNY4TYuuHCutERnSZe6f06q93CxTv5lasyhsNkVBMk9AE+xiztXazRxDTK7Vl1ylekaa+BNKbcjYPJFyntedAZsyjHGqLOJAw3VKlC3WVRO2yC81FbZ3sx9lctBu6bD0R5Tg+zC1NVTCtCXYM5ZdTkN97tQqkXYPWBQHfj0Cbx2exeQRxToIspL90Q8JaTTb8n/xEa4FsGeJ1WniOnCHpctnUyYtnHrOgm+avW7O5nbPjJUjC1j293byTIiDzOT6elFu4xgt0PXbe+6sTmKvYOyyq47udAjsKjgWKO1TZeiLCXO7nbgUYWi4H7MCqwmUwxlQW7Q6yYKbJdv+6RPEzFs1pOB/ItAv33e5AzniiVvdfOgb4W2Te1U5DHfbYo8eWunFkGj+1XfJiif/GOMmd+vGFkxfAKPjaMvNPTQH+50FW50gwboCBxWzjeFfZzkFBOpZ4RZi4sWJXsFu1RjrjImisvQxc7AjgFezOKIcvwZpQ2Z07B3mLu0OJ93K30VFpxUFtUwH8kDluQUc3WtDpbffMRhUtxxhtJax7aMPlq5jNbahi8A32WIa9Rt+y7eDeFnSxM8UmYocQkNcbncDebrPR1GFvhgH2iXeAjbS2prYWjPH+y/f9VsJ+oHOMwY8IfmH/UUeoAJMwcTHsi3SV4RRtkGN2cgAP7kjb43HHeEFn12AqDLbGB256W4Znrydc7rY9n8z3wOXke6MfusG253OIzY4NmWFkJ/wDF2xvhmHI5af8ffmufpwdtQSduduO3DM7zHPH9uccTrlyR96ZjymXfP9PeVdrnmPGPa8fXH6pn+G7euZ+0Of4ex3O/ZPziXvS8we1obtk5GrkoueK8TPg7GuDx/qUQ6xXnvcGa3JtO+n/kvug/b7ODx1qEY87YTHAOOFnNWi57hP3B1yQwz4vUCNTXXw6E6xGLj8cB0l9t4c4ThjwGkwHzgsGP4AlDuAGUeFGQEp/blBtJ7gDe2njQC21csNrrWP9A0H/2HE7sBfgFgK/qhTGuB56Cu8l0P9lzhGLHWqS9QqOG3LIcgl+GX52tgnPXStAngzJpsP+VPgSD5HgzEyxW8DbxjHaYY/SHvpRv4en9z5UAfKtsPpjtyXuEsgh7ynzqQeuXMnteA0yjEON4wHfgMOBWzVOhF2HB44R4wuwE5nnHPAzn1EiABfMN7DBexo7j7yuurGevn73oPunfXDM9VB7ZOyv45n9lAON+5zONK9ZXpNTbfxJ7cCdroIMKW43ndfpbvjcZ4Whv+bPe6+rH4HkXbeEvd3Ybzk88OBpFTXfPhL50vBCNKM8i8p7Cyo1DctLryEpvdUlouQyWMnDml/0czJZPl+cMBgeneP0+bjlsk9v338A'),
			this.addDataEntry('', 45, 39, '', 'jVVLl6I6EP41bmYxJxKYaZcINqaHxAdRW3ZA6BgE8QjI49dPIWp3L+bcu+Ak9dUjVV8lxQhbWeNcgvOB5iJOR3g2wtYlz8thlzVWnKYjDSkxwvZI0xB8I+31H9rxTYvOwSU+lf/HQRscrkFaxQMyAEXZpnegOATnfquyQMI6jYUqgzCNraJYV2lcgOrnD8Cv8aVUUZC6QRiny7xQpcpPoAzzsswzMEh7xTSIjvKSVydh5Wl+Ab2IP4IqLb9EMFMle88yPwMaFOc46ov5UE0MaU9viZgPFD2QPlRQBiNsDqL2WlzlSJs2GRRsLedM89upHu6aKuqQCuZrFNn51cUCi9bAtDWuURZdaWLW1Jp0IosUmftn/11YIZYTolDtJhvpcrNinomYpzesiyTtjhWzVw1R09zfpadgvpqQhBpuskLUI1Jo6VE44J+sxm4yw6wlkNObYvqeF2/EMl8ivDZCZyPFPK19Dp1xtrqwJkmEqVoqoxO2KeN22glnUrs7dg2dSbtQ09bXSE6Tzdi1TIOqWlI+M/7wQn54ZhVhyGheSIh9jaxxEmrNNUpyGWVC/bFnmFq1XNy+428yR3LZVzxPC5/rGcGHw6I+vvjONou6p/y2dJpzmG0P0VG0+9367O8MRJzP/XZnnMWcTshp2/nvbzxyXhN/M6m27ywFdgyaINWzteAzBLI+yBTYM/WbHmoHVusFl8C8bJYe6YBxAxiTwQ5YPc6Aj30SO7Pf1grymTMUYlPuteYAXMG5DFGLXP/TBroSan4WaVsEZ0DnXr50xOI1MJxW/u61XeO3g++kaXhafbEAro7+zu+e5/Cm3r+vc+L459Cp+/rb0JLJyjsq4vR5o7K/OUzpLbX9hFqocROpU6VrzI5K2uqIdTNJPd1g9qxklo5ZsuWwdozTp++Cr2C/zWk3qxiX+h5WwBoC9wNijBmHm5isMLFX1cLedMQe9NHTjgAu2wfe27FuPxYJgZt5RHRH64fO9W65PeKW99wk5KQzzjqXk76Pz1gu/36mZ+8rCjH3bV8rxPbM2uXQa74x7rHLIRa9x37lgI+JTZGbmPrCQv0r64CjhtniF+dUhxfVUGUiz95AnZEmElrfXtlO9naYdttf33r54mJ4853ejzE8vQ86GDFx889heYPuk9KJ8ywuLy2Y1EqUh8FCNwavQ6zk4e6FJwMWFIMsn56fkxc29+H7ED+H/E337R/wFw=='),
			this.addDataEntry('', 48, 39.43, '', 'xVZbl6I4EP41vuzDHCA4Mz4i0JpeEhtBbXzjNhFE8bQgkF+/VcHuds7u7O7Zl33wUKlbKl99FTMh9qlfvMWXA6uzvJoQd0Lst7puRunU23lVTQytyCbEmRiGBr+J8fQLq66s2iV+y8/NvwkwxoBbXLX5qBkV12ao7orrIb6gWJxiAd95nhVNnFS5fb2u2yq/gunLb6C/5W9NkcaVFyd59VJfi6aoz2BM6qapT+BQoWEep0fxVrfnzK6r+g3sWf4jbqvmIYNVFQIjm/oC2vh6yVM8zI+iz6HsuSrEetdq7xpMFTfxhFjj0ni63sTEmPcnOLD9suTGfpibya5vU6kV8XKtpU5980hGsmFK2DC9paf0xkqrY/ZMZqe0oMv9Zf+a2QkRM1ponVduhBdaLQ+sYWVbAxtMyR1W0MWhindZnTlawUrWMulLWsxJvFtrsdKJ4qWIynzhfrMDS0AtWr7rK7pcT9PFZkbP6ypf+reIcElLs02J39HlVaRkfUttvUyM/paWtUhPWfG7Q3UedGIV0it13H4VHL/RpSa8M9dYMAeZawmxmsiYXRNCv9Ll8zkqRM+lBf4Cf5fVMJ9Rp7tB/mmy2ABGzwU3o/D6/LJYV/sze9DYYX+Nd9Mqen1epqenY7zbtpk9P3/IT9s2fl3Ll+BZT43tsCHzQ2RsX5JqK/cBFXlIZ7SkmlfSng+wdnDtTgFLDTCashDwKUyThYDjUvQvAR280pIriI13/owe3U/s/OPzy3g+ERn9ISUMsINz2/T2jz6QLzH2J6hRgz16Wnz/6ZTdLVlU7X73NKzJ82G/qKrk7D8iY8+O+91efuwT9l30uq7pYn9JFh3ssR0SW5R+cAQ+YN1aD/zQWZkKFooWfkZW0pYZovdKV48Gk/BSCGZbau2VfseGUYa+tsBDA3DouG32PKQNyAPgJJnjo0xWgalxZyu9AOzKPwU91UAvucxK1K8c2K90iYe+YQS8pCbIJsM6QA6ctOVlpEWDBvVthnE/kKWFeTvgMuT0NaVzDqgbeHkEnauxAv1SQ+kCjD8qO5MbrEP3VB0R1mqq+PI4YM4VyNzxtUhaYGMGL8yeQTwvNwTWmMPkMoV8FtbdMwewK5muzhOyzz1f2WdOx1c5lbwQErjVcRI1iFfggJ9jkQhieciE6slgddSxBOwLZ94MuP8qFIQ6f+mDNt0LKdjc6bZU+aZj/UeTwx3ABg36JjrAfrpyUtxX42WKGOMZJJNRyyVwPjAN5lDI+d7T1GRn1q6c43TEVqBNwhcxNGLHNb0yMpnmSsQU62NwBwFnoDZXsNLHvhk4S+wEtZdHmLNIXylOWcB5/Pqm4pPj9xT4wJ1IVzyUGwM42IF+7L3qN+othSOXR8RUTxU3fMijzjJw54g9ICNnXNjb7RUXoAaQp2N/LZx3HXqEPYb+Yo/wvD4BbCD3VvETMEAsNYXRyGu4UxU/dNXLJcarfYHjGM8IH9ReyMEpUzL75CDUdecDxo12R4wc3kYS+b3asQ58yIgxM6F2NXPvXy90FR4fvMF6ZAQYWo3qG9SK+Ud5nNcMMADcCfSgozbmxlkTg8I93IhHX+ip8v1P849cc9jD/K8f5j+aPvTHGPsjBrx3VzhfDvJknK+xz/xrErpgF3CvaFPEdqwp+tua3s/6Z+6wD+6s7Me7ib7fTbrqn4H1u4A73BUh6n2d472m+iHGO6481F4I8+O48v+4mzLgAvTMgFo75Yv9DN0GZ+s+7zCzwLXS7RQfQwvmlEpe3Pf64OlWPvBQU/UGqt6vSaDp451hwdmYzs8R5HAN+H9QM4z31wp7X66//vRf9d0DDPfSxMcZmd+fb/BwyvtfPgGV6v7+W+T1KW/eBnDpiqw5jB7m9zHqkBficI8isy8mGdXxdVSJj+DPJyUI91fl+/Lz9apsPz1u/wA='),
			this.addDataEntry('', 41, 45, '', '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'),
			this.addDataEntry('', 48, 48, '', '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'),

			this.addDataEntry('', 48, 48, '', '7VfNc6JIFP9rvOxhqwWsTY4IRDF0ExTH4A2BaUCIVkAF/vp9rxtxsmNmctiqvezBgn6fv/eJPVKNspm9h8eUHuKkGKnWSDXeD4davpWNkRTFSCFZPFLNkaIQ+I2Up0+4Y8Elx/A9eau/oqBIhXNYnBJJkYSqboueUKXhEV+zMuTwnCZxVoe7IjGqankqkgpYf/4B9HPyXmdRWDjhLileDlVWZ4c3YO4OdX0oQaBAxjSM9vz9cHqLjUNxeAd+nHwPT0X9gwW9yDhq1ocjUMPqmEQYzPesSQD2VADRr1RypaCpsA5Hqi6PylN15iNl2pQQsPEyZ8q2nWq7TXOKOpKF8yWJzMPZUWM1bicqbSfnqIzONNcv1Hjs4jLK7Pn2uH2NjZ3KH+2MXJx8zR1fP7GV3rqG3rJW02gXZPYsLcJNfIhNktE8OrkmVexsqoabJQkFjWcvWZAnM+svY6VzwEKSTVPY8+Ukmq0f7bdlkcy9c6Cyzs61U6R6F3te8UhdniNjnO+U5hzlBx6VcfZs7jvH0BvXp5VtUvLsV/z7Sked5nMdqqIO9S3QWWu9zoOjShwDNr/Zbzfbbjh7+4fdrDhtN0/tUl2k21lR7N48vh3el992ZUEwn/ErK6KCXYINK3xl8i1S1pC/ffuyslu20lrICZy5ONNW62geIL+Bc+fk3piubJ6Y1qOd2ydq0gnk77iF3HkrG2q4yJgW+NUCEckIp/lu9tShZ5Gt7OH3Ug3YPG/Lbbd99cCPlTmdVtpqmrqX/eLFeKzCzaQIXhfzqHzah5tvp9gc+A+Osiy2b/QHLy/zaRrPON+WRbUzMQOL6tlg02eIBJH7vt04+b6hK71hmdZSf5E7eaSwVr/YpnViZjRxcouwTG/h2UE3EdqlKWRLgSqdgA5yOgd9yBDYMIbn2MltjlkVfKisbaAu5zTTGtpFyBu7K5RbT64yzuom4yIWrIpvn1i+VuFdcX0PfAHO3KvF0wzwDHReg50G9MbUt5EHneSdXN/qHN+Cbtc1jAcmR0E7zOfwvm+RB1ggTqo54If60IW517lzijaItIvxE4x/QjMiZAMfYgecEIMKU9bngEAuozFt8WlfWEl7TKgTjcHvBOyj3QszrSv+WuIXOf0sH3WfD8SuQo0qx48A9151fAq5sZRA+LQ6moFOrkP3Il6vBXtwXnfMIFAXPhE19SkR+P39tQZX/B9iFPX9Uoyeylag41uIV4PcihhdX8TWAB2fKvPZ9JMYx4ALJ6xxZ/SCMTLYUFA/BesjexBqYpBrD2JPgN9gwgyoZSf8tKzb83/4S3vs4C/Shj7EHHRr0RfYDyLOn3Khf6x3KzBJvBCvi/2VD70MteCQUw9k1xwwEXaz0+cLn9aYbi7QX3TCWqxHoNLXAOMYfyluxYI4Ai5n7xaL6Omhx+/VTP9Ys7XV51/GTYWcxWlu4byIetyLl+Gs9fEOM5DpAtNgA+pPTS5nFHPx856QGESf8ov7r+wJm9+r862+st4wI9ijbd+vWA/YU0O/XnGL/hE1MWSfAa3fe3IOh30B8+xiTgy0xTWYDfTXOGJfcZx3Bb4StdynpN8xWFdZL2racjf5lqQDxp1BFLBFXLFP1xemUOgHjr3Syh73JMZ8D74iImLLPYIxi12DGMy97AszQoxXHdgxRQU7XmMm1BziYf4ihbMKux58RuqPPeX6kcAGfiZ9L9SyF7FuAYF9InaybWKsVOSLqccacwG2Yc+lKeRKccUcBde6XWS8Ee6ilmZXHtq49qFe9zz8LsE/nrsy/CsyEPOEdRTmwm4HnsR0GXpE6JNfyQjeFfd9GfIVmQ++kj0Z435xb9/du/kaaoH9CXNyV8YQvLqP965Mr/9rGf/3vv6r+iUlwTzBt8/mMJeda7L/8/WrfGX2+foP+UXeFOBfIdxC+qsUXGKS5tPrmCD1d7FZciiT+r0FkUsW16mU0B6kVppkPK0/0sJKnvmgebvbwUt/vbseb9dIwftwy/wb'),
			this.addDataEntry('', 48, 36, '', 'jVXJkqM4EP0aX+YwIbNUdx0xUFgOJOxCXuDG1gIZjMMGs3z9pMBV1T0RFTMHQsr95UsJLVSz6p1bdM1JnWblQrUXqnmr62beVb2ZleVCQUW6UK2FoiD4FsrbN9blZEXX6JZdmv8ToMwBj6hss1kzK+7NUD4V9zy6ym1RRRzWVZYWTRSXmXm/v7dldgfT33+B/pHdmiKJSjeKs3Jb34umqC9gjOumqStwKKVhFSVnfqvbS2rWZX0De5r9itqy+S2DURZcRjb1FbTR/ZolsplfRZ8B7NUExPjQog+NTBU10UI1ZlF5uz/4Qln1FTRsbtdUCYeVFh/7NhlREa3fUWLVD1dN1XTQVTLoj6RKHkQYHTFfx7RKCrwOr+EpNWOVv+ICda7Yc5cZLfWNwTONgfiYR87hGio52vp4klOlPKcO+AusYaFVWM1zrztzbPVjui7vob9C2WlVbv0NCk85chU6JgMGnO6FImKufuA1RbFqNIHyeo9V/ILXm0tQcJ0MHSfsPLqmMVLzDH6ITzH+tzEjnWLsHmKW3jNmK7uTSNgnup+hc6iS8VPebJ3+GleHPDmnQ3B8v4ZHHWHna3846td0TV7x5TCGpw1LnDcR7l/bw4mWuFjpRKCCCNKSEesga5PMEpCT5WRnIBca8iwbWOa9ZM8VxuhJRo+7V3y2i20RiMyxf5g7wDP3xwOlzxNV1pVc4cd/+kC+WAmrRDnICfW4+AlMbwqqBey+MVn3iJ2yDY9vw7u6yUOnLOPL7jcP4OocHsPxsw7ru+D0XmMnvMZOJ/sfYpOLnX8usCNxo4EM2uBZ58YVB0F8bSAW4QROiytwR6FnmCEHn45YnEs7Zbz1LGnnHSmMXvqRQa6JRr9ksJ+XRA164G1Jx1xAzqcNtdQyemzhFk6v4jJbriO2gH/L0PYjRq7Y6ZB7IKa2BL8R4jTPn2Uf/Oho98GAPmp1Lnvm8gGvZTdPvM3cD2Wghzy2OudF8kb00Bv0XR7BVyXszZp9cEvZDsG+82TfoAM/lUw19xrkALuxnOyWzWVvso68aXMeW/L4whgBjrC0j9R6F+A/UuljQm3GR3l2qMQh9oor7M47drorggFwgQzYKuBC7JdgQ1TWEGeQbfDhci69dwI8DOsSBx1nPlzZKysJETtZF1FGxdMOmAxV8k4YxPtaT6Z5E/grSJ2hR3Id+ZhVqPeAQyqgd7YHXaAGg6ZTOftpfrth4s9K0MSFBfeAzetB7OVcldhEGsxegXkB/r3qOTbM0x6wtYNaWObpsJwR8E8l38BBIM/EGCjYMuTMloRJzNCnj2S/iDy5YtOZ4Tq25lopcAecaEQhHTYnnH9g+/eaFV93cDv/NeH2wB/5+azADz3rv32aJtXzXXKyusqa2wAuXZE2+eyh/Zyj8qzg+TNKfZl10X2W+Wfk1zsHm+dT9yF+PamT7Y8X9x8='),
			this.addDataEntry('', 48, 48, '', 'nVZNc6M4EP01vuxhC/MxmxwxEFsJErENceCGgZEBEVwB28Cv326BHc/WzM7WHlzoo9X9+vVrWTPNqrrlZ3w80DrNxExzZpr1WdftOKo6KxNipip5OtPsmaoq8JupT7/Ynctd5Rh/Zh/tfzmgjgfOsThl48q40LS9mBaaQ3zEYV7FHL6LLM3beC8yq2k2J5E1sPXnH7B+zj7bPImFG+8z8Vo3eZvXH7C5r9u2rsBA4MYiTkr+WZ8+UqsW9Sfsp9n3+CTaOw+myDmebOsjrMbNMUswme95lwHshQRiXleV6wq6itt4ppnjVH1qznymLroKErZeV0yN+oW+33WnZFDyeLVRErs+u1qqpb2h0d44J1VypoV5odbjkFZJTlbRMXpPrb3GH0muXNwi4K5vntjW7FmvG55fclrwnCwPIt6ldWoruZyv0mO02tSvW3K1y1/zsMiWzl/W1uSARcl2nSCrjZEsg0fysRHZan0ONTaQQj8l2vpCVg1PtM05sebFXu3OSVHzpErzF7scXMvsPJ82xKbKi9/w71sTz3S/PkM1PEN9B84E+nTmwdVGHDdsfldGu2i4zdflw34pTtHuqd9oz4doKcT+Y82j23jztq+Egnym70wkgl3CHRO+arwlagA8lL3kYKsP1EZeuJzTXleYv8b9DuaDW6w1ZhGe2c4jKciJ2tQg+eIYAZ/rLYEaPudMD/3mGRGNGS6K/fJpwMiSrfzh91Yd+DxHVTRE72uI4+TuoFdEOxy8S/n8aj028c4Q4fvzKqmeynj3dkrt2/6Dq25E9EHvoryuFod0yXlUiWZvIwPPzYvFFi9bwhG57xPNLUyVbhXIKOzCXu+haidalJjx4Fm6CpmemE11F9boe4hM9dTeHOgWGMrNDuxUYpucQvVcYNGz1yfP51rYg88iUN2CGOifFebkU4EzpoLn6XAgLNfn1GeFK+cc/IDtwOcw75idtGB3YbgGGELfgW/Ip9gXGRexD1wFe8Oz050nKykK9EOHEOI7CusxfqlM8SW+vc3xnOL68jugb8CLviHHq29T2o7YDjVFGz9RgScFeMGcASvtZIwc4ycSZ1YpLc31gfkJH79R7fol+jf2mIu/NqBTFaaFwEmo0Z3Tw9cgNkGc6BfiO61b8B4wgP8Sut/8qQ3gNQDDybNJv4WcIH73jxgds3Sd2QLwh2jXZaXSUagtGwCfD/WyS0BiQrz1BfB2cEPAOOm9sZ4wLnWsO/PDVtazl7poRz7NsZ75WKPYnvj8DUejLqTPaR7ogBM1gJzPE9SPvwZ9JoPUz6hBnakY1wHenB5rCVihrkSOmR3g2GArtKFz1I7nJzAOBsB88Xa8BU1DTlJvBtbZlZoiqDcF85O6LAL8Dmx4+raHunm2qRPQNS0c46d59fd5Odg3cJNhH2ENyFzeLkUA+44mdYa3Mujbu9MZaAtyCrqxpyj0lIP6vdOC7EeIc9Noh77veu+GIbYUwEF1qt5qdIF9zbOxfoB3e+3B3/aVMvqdYkps5NbvxLrpY6A7Ovb7drxDZL9fexp7+JrD6sg81GP/L3dO4XzVuwc8FvLH20lDKvi88UELQUGz4CPgHuoH9Q76ZP/vjuru7yg5XjoTz9P9cKtHoFCpUXP04yfo+8IG5Jj22A/U54bUleSIAkfOhGXi++aL6my6l96KBPQG/XPXj3gPTv2ojLkDL8EFcHPjxqM/6QV1m//0/ipQV/JuA44l5/5anXob97/98B+F/71qNOj4xNIW0yMMnj9Z98uHnFyaXnHLrK6y9rMHk0uetofRQn8YTx2ynB/aH9fiZpzz28mvVyEMpofhdfr1AJV7P7xP/wY='),
			this.addDataEntry('', 32.14, 45, '', 'jVZNd6s4DP012cxiDgFnpl0STBO32JQEmsKOAM/BgZJTIHz8+pEg7eubc/pmFjlYsiRfXUmOF4ZV9pv3+HLiVZoVC8NeGNZ7VTXzquytrCgWupanC4MudF2D30J/+GZ3Oe1ql/g9e2v+j4M+O1zjos1mzayom6G4KepTfMFlXsYSvusszZv4WGRWXe/aIqth688/QH/N3ps8iQsnPmbFc1XnTV69weaxapqqBIMCN9ZxcpbvVfuWWlVRvcN+mv2I26L5EsEscomeTXUBbVxfsgST+ZH3GcBeT0DMD632ocFQcRMvDHMW9Yf6Khf6ui8hYet5K/RoWJPjoW+TUcvj7U5LaHV1jNRIh5XBh9U1KZMrV2bHrfsxLZOcbaNL9JpaR0Pes1zrHBVIxzdbsTcHbpGO+4HkSuZscyriQ1qlVMsneZteou2uet6zD7v8OQ9VtrH/tvamBCxadugLtt2tkk1wz952Rbb1rqEhRqZImxhex7a1TIzdNbGW6qj310RVMinT/ImeR8cye9fnNaNce/Jr+WNvok//vQ830If7NvgE5OZz5xgzjk9sfn+ODtH4KXvnu+OmaKPDw7AzHk/RpiiOb56MPte7l2NZaMhn+iqKpBBdeBCFr69eEj0AHs4DcNC7Fhn5GIIsh4mTPTE4Rfncgzw6yjOExWRG7Xum7JaP9pLl60sEfHp7BjV8zAUJ/foREc0ZrtVx8zDiyRNb+d1/W/UQ8xqV0Ri9enhO7oykZMbp5Hbnx2frvo4PqyJ8fdwm5cM5Pry0Kf3cv3P0XRG98S+nPG/Xp3QjZVQW9ZEiA4/1kyXWT3smEbnv2ytH2YazJ8B8dIKsR5GbvaO4zqgpOVSEWWQQireCBlo4kE7455b7ScupNMBuCT4dsLfko9C5ClrozjEcTYkxRK6BLRsclQDDsB49zVFnInQbzrA1RoFJ38NzOlg34LMSA1bClhiXT1jM4QML4NRcGoKPaewtqJCaMH9nB/HsTgzmb85CTLwP8asY+kGuZ9zTBOAVCrAjJ9RrJtzLEPhiS1HybtIrxGIvYa2LMZnz25MVcMExD0Exlt2DPcT35vg0aYUf6OjvUq91qdTm9a6CvIDXQA99xMqRg54PiBfyggkCW+CSE7G9NI7PwCYgjDKojd3vqWwBQ39E3D4ncBNo7msInRv24mCDn1yirUuDLxwko4t8qTPcLibYeMMcj32xkZ3IiT7dJDnp3T3a2asvXK+EL7Huxn7yLeqJf+CE0wfwwxyDPqbAkzL7FwW41XnMzhr0QtDBub2wCHH9k+KA3fUDiGESBzgAHMupbop9yvHM3wi9SLgvZwxQJ8CoiXHibOAqxK8G/Yj7ENPGOmrQs3LqcSWb2c67yScmcOJVocDuFle7xdWw93U8H3DM3zEkWakBxwmBukAets6xxmPYIy/A+RLi9Vjrqb7KA57xPMwdewj7C/hB+WMmDI69MvABcPjy1oNk5dIUexx57//FO+QTTlxO/esHUBdznrnRhpjmasaewJyaxA3kEus922JfmN3c/wz7twMumumWQx0tfncm2LGV2CBevCm1OadpTlAXDj/XkNcrn+8A5NcPMd8Re8alLwrn00V/3wPsbJo5qJn+y2wi39iP85x/zoKgUp/uLZr+9cvdiv8ZejQSfBoY69vjAf62s/7bB8ikur0+NllVZs37ACZdnjan2cLQ/1yS2fGU5fJ0cySrWRfXsyw/nX8+aGBxe9N8iD/fTtPeL0+rfwA='),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 38, 48, '', 'rVZLk6pIE/01bmYxgYAx3UsE1OqmoFVsG3YI3BIoxBCQx6+fzCq0+/sibswsJkKjHvmokydPETXTzLJf36LrmVZJymeaPdPMW1U1clb2Zsr5TFWyZKZZM1VV4D9TV7+xzoVVuUa39NL8mwBVBtwj3qZyR27UzcCnjfocXXGalRGDcZkmWROdeGrW9a7laQ2mP/+A/Xt6a7I44k50SvlHVWdNVl3AeKqapirBgaNhGcUFu1XtJTErXt3AnqS/opY3PzIYPGMY2VRX2I3qaxpjMb+yPgXYSwHEeOwqjx1MFTXRTDPkUl3VdzZTl30JBZsfG1cNh6V+OvZtPCpZtNkpsVXdHS3RkmGh0WFxj8v4TnOjo+brmJRxRjbhNfxKzJPGXkmmdE5+YI5vtO7eGD1TV+gYM9diGVmfeXRMqsRSMrHeJNdws6s+9uThl31kQZ6u7b/MvcEAi5Iee042u0W8PrySy46nm+090NyR5Hoba9uObGoWa7t7bM7zk9rf47xicZlk71YxOqbRez6tiUWVd79mv/YGxvS/j6EaxlDfhpiDPsW8OJrE8cTm90V4DMfnelu8nNa8DY+rYae9ncM156fLloXP+e7zVHIF+Uy+XB5ztwuOLvfVxWesHoCHYkAO3L2uehbyyYaJk4WbE7T3sFadnPZ0ICy17FeSk9bzmUqy5TUEPrd7Aj18y1w98Os3RCQrXOan9WrEkwVb2cs/e/WQ8x6W4Rh+beEcO3NGvSTa+ex1xduH+VpHxwUPvt42cbkqouNnm1hP+4uj7nh4oT9O+dgsz8masbDk9clCBt7qd9Ndvu8JQ+S+T6Gy7egOxsLJyTwYbTate1QS3es9sILjnFikpfmnSnPWuiPrA5+0rkUZzUA9g9ERywA/BWwiTvOsVe7shbLQT3d8zB3M3UyB3IHuDrrq+uEI+5CX9eA7UL9oZKzdCN+SNhIP5MXc+UEV/qiwPcYHk//qSH2K+4pv2Yh94ZqGAqMK2DQnjwF/IHCcLBtqNUa6x33wW1PIjXWyFmqdP+qm+QG6DLiBF+i+Bj4j1AY+9iDXyBGoQgsGUIuol5qGzIG+1lbw5uYUMXYUuAWuOlxLNemDK/lqgaO5qGu0R5lbAU4Ahwl2Pxgg3xRXCC6oz/STqQB+0nt7BfAUHXKF/D9yQQ7AZwAPOB4aOLuHXCIn1kYtkRfxiXwwX9CRPeZQ81aF3BMnTJF57ME9Yv3xAvXgjgXkw97bWKsCORuB/yhzoiZkHoEfcm2hJ7burbsRa/FMQ/ZqFfSgB7hxnLqmPniYD75iqIskt+GrFuv0SDti4i1ljawbY4lOJ10ABqHLH5rT/mPNKf+vOTfTNepz6LvSAzbsOdpUwbPsOa6xrtqT/Dau+LLwXGpA9FKbMApMWAe1qMDmWVITkkfUssgpNYN4ckOVmoK76aNOsd9Sy2hPC2XiFfqUg/79QgkG7O3hcU9FX6Y5cHvGezVIbdu64ODbVjt+IfRIrELwEqAdeZZ8IQcPfvBrKnziAbkn8x9co01yXXRS5+MWzvnMhe7kX5v0q1KJoXniw1zYD8HbpPWcwS0UfRe9E7r67sOkGTjvQiWWp34C3ROYwxq59Xy4s9MIvOl4rhwB20MTUC95aCV75JA6iUdb3q3cXgg95nCXxLnV95d87O6xFl4+GL5d8LecHjjwtEj73z6SxNb0QlqnVZk2twFcuixpztJDe5FR5zRj5ylKn/aiWq7ZM/L7xQWT6dH1WH4/7oTtf95+fwM='),
			this.addDataEntry('', 42.86, 48, '', 'jVZBd6M4DP41uexhHwEy2x4JpIlT7JSENIUbAcbBQMkrEMC/fiVD0pnDvN1DXyzJ+iR9kqhnhl3266/oeqFVkhYzYzUz7K+qasZT2dtpUcx0LUtmhjPTdQ3+ZvrLH6xzZdWu0Vf62fwfB310uEVFm46aUVE3QzEp6kt0xWNWRhx+l2mSNdG5SO263rdFWoPp779Af0u/miyOCjc6p8VbVWdNVn2C8Vw1TVXChQINyyjO+VfVfiZ2VVRfYE/Sn1FbNL8gWEXG0bOprqCN6msaYzE/sz6FtJcqEeuu1e4ahIqaaGZYo6i/1Dc+05d9CQXbbxumh8PSPJ/6NpZaFm32WuxUN9dIjGRYGHRY3OIyvlFhddR+lkkZZ2QTXsOPxD4b/JlkWueKI3d9q2UHa2AHc2Ai4FTwjKwvRXRKqsTRMiVvkmu42VdvB3K/l71lgUjXq3/sg8UhFy099QXZ7Bfx+vhMPvdFuvFugcEkEWYbG15HNjWPjf0ttufirPe3WFQ8LpPs1cmla1v9zqc1caj26tf858FCn/7PPtRAH+qvwOdoTj5PrjHm8cjN7/PwFMqH7OVP53XRhqeXYW9sL+G6KM6fHg8f5/37uSw05DP5YEVcsC44scLXF++xfgQe8gE5oIMJsQnI/FuWAdp7kKUrPIPZhKfO6pmIVctk3pNseQ2BT+9AoIfbjJmBX28xo7HCpTivXyRGVmxlT/99CzFvYRnK8MPDOJkrzZIYl8uuy7dv9nMdnRZF8LHdxOVLHp3e28R52J9cfV+En/SXKG+b5SVZcx6WRX12kIFt/Wqz5euBcMzc94nmipXObEt3RaCzNW2ZY/WuIHOYCp06pGU+h+qDjmbmYud4nNpWS31r4R7Mjvq8hWns8cz8I5xjmYgV+K/mLMdfuiDOqqUyR78OzjCNgCEAQ1L9bGs9PQDTDuEM8JnzLlycRsTyPR3OcypywF1hPBNyGKifN4A77AAP7UwcQbZgOzToygpzgTsFhRoA2xqobUoqwwvEMWArIKd4ThwL8+mVvxM3qr4Thd9VtztoEO84B1vPhNeMnQedH2ig05kfnthgLqjYIqbcKUysc8QktmnAFDdU1XGpGcaQvIGJmgeDOex8MsW55478Y21jjHgwNbjTUgdyELHih4l9DZhgP+rESQT4IBcdkxR4JCbUKiEnjUoO/csHsGts5GrkTnj97jDKTFhDIrx25wRGIC3uilzbQX3MQWyYbIcMLsaSgfGQD4CNvcN70jOQG/iKYI0d9Bb7YSL/E2/Yv4cO47nIk0On+4Xu+h7U5xm+E6AduDu2O/8oYR40NTsZ+IjATATmS+ZnB34l1Qjchy2F/o2y64/yu4C6BZW+gzMH/RrQ3zICjI9flsOd9wCwMad46mXQKH4drmqDeR4eswR84AzhPOxgDxTPIw93DnA/+Nhn3kw7gnHUjjCfLEYsNQ+qD2kO827DfUk59WPA5DKY+qa4U/kBLvZRjP2APTBxtiCXhZoRJ4Z9POpMzSn2lg9TfePuHsZ4incV92iq3Erk5jj21I/v+9iMMzbOHvAP9ccm1Ax3gwVTO+HBbGGsfLhz9s0jcIQxnBx6YzVjjma38xH3CP1XtcKZw+7BHgrkyetwFwFv4kx9b7rHrCgMyM2edl/Vq/YA9/rHb99R/P+gh9LEZ4CxnB4K8C867f/42FCq6aWxTqsybb4GuNJlSXMZb5j6308/RsdLmvHL5Gg+jbqoHmX+cP5+vMBher/cxe93krL99oz6Fw=='),
			this.addDataEntry('', 48, 32.57, '', 'jVVLl6I6EP41bu5iTgS8071EghqbRBFsW3YITAgG8QjI49dPBWxnetHn3gWH1FevL1WVZKJbebu8hdeUFnEiJ7o90a1bUVTjKm+tRMqJhkQ80fFE0xB8E23xjXY6aNE1vCWX6v84aKPDPZR1MiIjUFadfABlGl7VUuQhh/88iUUVnmRileWulkkJqh//AH5PbpWIQumEp0Rui1JUoriA8lRUVZGDgVSKeRid+a2oL7FVyOIG+jj5Fday+iuCKQVXnlVxBTQsr0mkNvNLtAnQng9EzE8UfSIqVFiFE90cRW1R3vlEm7c5bNjarpgWdHPjdGjrqEciXO1QhIu7o8d63M102s3uUR7daWY21Hrt4zwSZBVcg4/YOun8lQjUONmeO75ZM8/sNpbZbixDY5gLskxleIiLGCNBfV6zzDWImOvhYYdChWVcbMUxS5b2T8szOXBByaGVZLWbRcv9K7nsZLJy70ed9SQz6kh3G7IqeaTv7pE1zU5ae4+ygkd5LN7wuXdUbp+WBFP05pf8l2cqn/Z7H6orH+rb4LM3Hj4vjj7yeHLz23NwCPqn7J5fTktZB4dFt9PXabCU8nRxefBc795PuUSqnvEHk5FkzfHApK/N3iNtD/U7d1uPdFQYLcNK5kpumWe0FBOlb5XeyWzEOsITbL+SjNQU0xnU7xpA7VyPQA/XghlHv1wrRuMO59lpuehV5qFa4uW/rVqIeQ/yoA8+XMhjC6c3cqKn6aY5r7fWaxkeZvL4sV5F+eIcHt7rGD/1L462k8GF/pVlu5qn8ZLzIJflCasKrMs3i83fPMIVc98nmpPRKfVMtWOD+YvMySKNCbMh2K6p785Ab9DObFUFNt7j/0GrL7iFvurtccKOHappTwyCTbA/NlSAjM+tA7mGdRb17mBzbiGfDjZTBjhTfDqjhxiVmmjqxz3EbTYe6CAv5IbpRvUGr4EvaRVOMxu4urMhLuR0Mt5Bnp5mKYHuNkyjDcgN6xV3dTLAzgc7hfl7wGyNrY5KN2UHZTPmG2LBNIxcRn7UPyLAZhu8O9AxLqzd0da3gZc5dbKzwSwEk+NqdE/7Jzd/j8hgS1UdpjDtsN4rrtMQ29APMgOuUEezg74MfdjgveoDgr5AvH0Lf6XvNx6cbv8INdlrYz6FuzrUTvHhsG/EsoUGp2rsR29y0DdU7QtHwImPPYHaDf2GmMkZobGn0IPh9kiL4cbozf49g+pD3Vh/1IAvotiuqKoN5urfwal4yCmBeeqZD/1RvcaE02FGSEOhr5vRTtnzh/2/X86HOvda0BvqetfnjwcArt6k/fYRGaDHC7JMijypbh2YNCKu0tHCeBm90kTw9OGlaz9mP0c4LEeIP53/PEqweLxLn+Kf92/QfXkefwM='),
			this.addDataEntry('', 34, 45, '', 'jVXJkqM4EP0aX+YwQbHEtI9sZcuNABd4gRsGWhYG4zC7vr5TyHZXz0zFzIFAub98SkkLxazG1T25nXGd5eVCsReKea/rVqyq0czLciFLNFso1kKWJfgW8vsX1rfZKt2Se35t/0+ALAL6pOxyoRGKpp3Kh6I5Jze+pFVC4G/kGW2TU5mbTfPRlXkDpj//AH2f31uaJqWTnPLSrxva0voKxlPdtnUFDiU3GEl6Ife6u2ZmXdZ3sGf5j6Qr208Z9JISHtnWN9AmzS1PeTM/6JgDbGMGoj+10lPDUyVtslB0IcrvTU8WsjFW0LDpr105ngz1dBi7lEk0WX9IqVX3jpIp2aQpeNL6tEp7XOgDNpcsq1KK1vEtPmbmSSFLRKXBKXbECfXODXSGJ1VzmU1ca9fhMJURNer4UF6T9XaJiu2bU9iKSxHJ5PKSrSC+wMwpLgoOEGDaUFeNwmaDTP1bqnxop9WOZOtyiEPYmdVezcxlkSqY+lRjmaWTfDJYtloOzsHtT6vl5FFjimVUeyFukGVreBoIZtubNxlLZPIY+8sYzFIeM+JgIG5IRIw19A8cn9D5q48yvuJPGjMcm+SgldFxs06r90ty2HeZaVxf6/d9lxw/mB9s3lJ5P+0U4xzJe/9U7lkcIJKHiDMxApPALpn8ADE3ACZDLl9GkIG5y4iBudyywRd1gHEEdm+xJdHtb+yZ2wtnr09Nozit3hnf11TZDoh++28vnrOPq5jFR75jNnWYWiHlfPaGy8Y3l//s03rZvzny35nx18YZ9pnEVdmcAGl23DTfTdf4Dl1z5GGIZKcgb3iSOvfAGbhIONAHZGHoEGlOEcG86JJTpDLM1+QU+uQFOvhxhua/5pr8z3NwO2fpJUvzX4kYDlQJh5sCz768BtSDWRJ1dpoTog5bSEPWtvOsHXNCu8PgBxPRYcZl1HmhPSFL+Dmh8HvKgRWBH5miMOpchohLVZhT3odOoJb0qCnw7zCcjS3U3gIWLHqHs+MFEMN2LT9PMI2Q5yLti0depreYTwTgcYut4oQCN8fnhZDngWf7r/V14BirmEKd463FVJ0ghvuonsU5kUTOQJ14fagzuiwCHOngUolPpepxH8uewEeC892+OGSQG7iCaVQdjt+KEeSVXSsrhBwRyM/3CfbvlV+G/CJ23hf0zC3jkIh+xBqwq2+edZYxs2efaPaFnBRwPPsz4e4pbBXN3KRyNH3KOd8tr1yiLvgmFoJ7Cw1uhefeBU/PvkE/z9Cjb/DndWEeyMxd8Knus3+om1PU+zQq8pX9ly/uSjgJcA8/HhO4xvPxywdpVj1eo1VeV3l7n8BloFl7Fh6KKqLOOSXnR5SqCV3SCJm8In+9brB4PHBP8ddDOtt+e2d/Ag=='),
			this.addDataEntry('', 35, 45, '', 'xVbLkqpIEP0aN7OYQMCJdsnD1upLgbb4YofALUEUQ0AeX38zixK1Jzqmd7MgiqrKzMpz8tRjoBinenr1LweahVE6UCYDxbhmWdH9nWojStOBLMXhQDEHsizBN5Dfv5kd8lnp4l+jc/ETB7lzuPlpGXUj3UBeNKkYyA/+BX/jk8+g1aMwLvx9Ghl5/lmmUQ5Tf/8F47foWsSBn1r+PkrnWR4XcXaGyX1WFNkJDFKc0P3gyK5ZeQ6NLM2uMB9Gv/0yLZ4iaGnM0LPILjDq55coQDC/4zqCtHWeiHYfle4jGMov/IGidV35Pb+xgazXJwBszGe27DW6ut/UZdBKsT/7lAIzu1lKqITNSKHN6BacghtNtIoa4zY8BTGZeRdvGxp7hY1JLFVWsmKWq5X2UmvtpVrR5Mhsc1VSk6kk1jNvk5792WJMksXQSjTVMQgL5fQYTsE/oTjWOEsCOX3Etrpz8w9iaG+B8jnaT1csnKWV50Jlpms1NMZJoNB4Ho/a0NRY1OhtOB1X1sa+7afjxon1xpNJ5rg0J+ZkRJuK0XZxcRp9TAz0mXzrQ9sAfWq6rJjtss7HrG4ij6fs5tPP1DvTpxHDrXN/M0p3249ZcHo/+pt1GRr6uf9/X5f+9rOdLz+GgbxuVop+2Mnr+T5dt96SsMglyERjJYuRHUPf5H3ZSsiQYt+dQH9VOmhr4j8pbWAC2L14phQvXtgzFkdk7xYYerKfvrdY10BZVCR++2+rGmLevJPXelus2CS2WvVElMPBqY4fc2P8b5xmP/9myV+Zmc/0A9SZeac030Om4fYj/2XY+i9Agpm7LpFAP0MHtdOolWMeErpUZdsMGDU0ZEShS6l0TCIRE1CbQW25XUtMrbCSQLZhnqKO3ElJW9ZYS1Wh5q6AOKrtUrBZ1DSWhO8EfSo7luq7r91q8tI88vldg/3dEGODfwvr9rEdc9UKX7Cd9LnZyUQF5XC9w9oydRkTayMGWGcnATaVJgtGY1Wy28mX9v2fvasVYDPctROIt1Bg/bsN5Msa+8GFaLUKcdrJCuYJ7DvEQ1WOE/D0+S5VibqkEL71EzfCF/Ac2YjPb6jgE2LfuexjsyFtOt+Oz3tuu9rhGHFfP7jAtTmGrpYv9fvaRic4Q9ygtDf0zj36tV3tcH3tpVY971jPvpa4/kvdgXtJcM/1095187V9qr2wR/zChnPfc95zTwzOH2hDk3ntOVd3LjhXyI/AKbTBc9WeuPR43SmcndRcjf6X2p/p9zpPaUNjDfMeYQ7wP+J7dUu57QP3Ey6ZCt5QI3ddvOwJrpHoKDW43+GugDzWCeCtuY2hwdoMsECu7YrBfdI4Lt83DfBl0hY1cgQtQQ4uao3i+QH3hyZ1fnCOGOqQ30HKrqWGOFM4h5Oaa7TF3CnghNxdImqItTxKiB/3NmIDHAXUqQZNivV3xZd8iC0Df33uEuR+7M6aFrlcdfyINRYNjwF3o1Y6boD1wDyAU9KdKY8zcANxuQYRo9C44KXHAfcmGdkT2gqOG86XoapQywLvZNS9vb3YgAtjAxv8TMP9yHVFG+mLrkS7YsrPz8F7rTvtAW/FQw+wZ7cvNeAxH3uadnUGTnpt/EA7vkkq/mbY0H6/9nfD8uWcLe7n68vd92Yp8OppVXzIKbp46sEjK6q/fS7yIfFWnEbZKSquDZhUcVgcOgtl1HkdopgdhJcqxvy867Pe8/H2hB/x/Lx3H89cPvfyCv4D'),
			this.addDataEntry('', 45, 39, '', 'jVVLk6o6EP41bs7iVuRRZ1zyUMwUCaKgwi4CB8NDLAGB/PrbiI5zFlP3LizSX/fX6VfamWyUvXVj1zOp4qSYycuZbNyqqplOZW8kRTGTEI9nsjmTJAS/mbT6QTt/aNGV3ZJL838I0kS4s6JNJmQC6mYonkB9ZtfxyEuWwldPYt6wU5EYdb1ti6QG1T+/AL8nt4ZHrLDZKSk2Vc0bXl1AeaqapirBoBgVOovy9Fa1l9ioiuoG+jj5w9qi+eZBK3g6MpvqCiirr0k0JvOH9wmErT8C0V4oeiGjK9awmaxNorSq7+lM0vsSEjY2ayqFg66cDn0bCcTZeosis7rbcizHgyqTQb1HZXQnmdYRYyHiMuJ4HV7DY2yc5HSBOerszE9tT2vpTkN0p/RURCkReUtNt8dcr8JDcWFrd4EzotqZi8gOp7FU5LEF/Myd29lSpgOGmD45VQKv/sSG9hHJW/Vk+Wm8LrrQg85YeyU2FlkkE77hqohNLU0GXcTWorMP9H6yFoPD9SGUcOV4pMbmUiVDB5G4V2fQF9gYOcsfOUREI6cnuy6lXjpxzO7+jONbdBtrW4QX8g0xvL5mB7UIjp/rqFzl7LBvY0O/fJ1X+5Ydt2Kz+5xH0n7wZf0cSPvNqdiLEKqRePhZnbynBsjmQxZQrc4ZZW8Jst8SM1egogqBepBBmTsedMMqcvCr40wpsXw+O10+xvPIEVu0Do50vHesF7fFf9kswd+iDC+0iE24Y4fvGx5kibX8bbj5hy3111O5P0d5PASH7TU8qOhL73X30NqX0fuOj8haIWboJTv09SP3sqswWl4hhzFmau+UOTaDFqZLCoTWkJ2iOCZuaebKtkdggqIeetI6ntvbnttSEcx94bZE+OLNzdF4ZibpYRIVxxq/OUyZ1mETfHg+1DVAdNCQnaVzMmiT/vhlNwCuEK69ZLCLJHoMBphmlZqrjBgvHXrE9uXXm2LDpts6pi+iAQ1jD9++0N93+qlkZ1ilFhlzBd/LlBgI+uzPnafvMc/R18u3P6DxZQlqKJ1jps342ojALfFcOcmRcAwFEQ+ndJnCSwpkegkEAQzirkY7Ksg84e8+bqZXDNMLG+K55mDBJP2Pq/IBPfeklVRl0twGMOl43JwnC0WdWOeEp+cnS15MGKsnOf1ivvcuHJ6r9yW+V/xD99c/wL8='),
			this.addDataEntry('', 48, 39.43, '', 'xVZNk6o4FP01bmYxFQFrXi8RaDv9SGgVtXGHwEMQxGpRIL9+ThJbe6bmzUzNZhYU4d7cj5x77iUj06n72Ud82rMmzaqR6Y1M56NpWr2qeyerqpFBinRkuiPDIHhGxvNPtGOlJaf4Izu2/8bA0AbXuLpkWqIF53aoboLzPj7JZVHHOd7TLC3aeFdlzvm8uFTZGapff4H8mn20RRJXfrzLqrfmXLRFc4Ry17RtU2NDJRXTODnkH83lmDpN1XxAn2Y/4kvVfvFgV0UuLdvmBGl8PmWJPMyPos+Q9lQlYn9KyadEuorbeGTa+tN4Pl/zkTHtaxzYeXvhxnaYWrtNf0kEKeKXBUnc5uqbqZkOE5MNk2tSJ1dW2h1znkRaJwV92Z6276mzM/MnWpDOL1e5H9oXvrSHwLEHNliCu6ygs30Vb9ImdUnBSnZhYi5oMTXjzYLESpYXb0VUZjPvN2dp58iFZJu+oi+LSTJbPdHjospe5tfI5IKW1iUx5x19OeeJubgmzrjcGf01KZs8qdPiu3sQvmP3QcjO1GXke3jOfyxtadP/3IaZ0oaFHmxW1s3mm2/qPO65hf1hu9mK+/f88G03qy7bzfOwMF/321lV7Y7zfHtfL9a7uiISz/SdV0nFu2jDq9CYrBNjBfwOw9uSDtyxBhZKPHP53QdLa8wdmmeh90RLeglcT+JlsRBYFVbHxAGYVoe35esUeNTU3O+D7vCK/EQ6e+rojJ+jdy6gF6lrF774pz0e/D3V2yOvVI2W9Pr1jL7Rn3b1ep8c0iHaLE7bzYQ8MOmu29m6Th4xviWzZxI70zre9Gf4Hyd111DinXAGmTNnIbvwkJrU9Sy/9Cx+jAa/5A1bWj3fQCcii7p2rr6XFmEuu63t3i9pxyUG7vzCwtXgL7EGRkzYRK65OFy4Ox8nA4F+LvebkA/cPWBPYkZKniMe7TnW3F0ZfsnAVwKc6aDWXm76ZWTwGWuR35jpeFizjkl7lwr4JFzJbEvFKqOJL3N0qdxn8kLKVtJ+omxKNlZ5LInMw5C5BsqeTpjc6+ZYzwlidtAJXkbI04MsGnP0kfQRuAny8jquzmADOyqUvxCcv8dciy8+ifLpyPW+QT+OmZsafgi8SI59dscND++VQK+gJsDZsTvUpcWZx6yU8Q8WH+y/3KN0SwLMVn2wjpS/YKPynyBXnJO1qJvFgH0QAlPE5W5kSozVGQQD9gn4jjqU9gCfnzU1A/cV/vKJ1AFbS+nAC4VhnfeBYxmBy6c4EzCV+dGx4gz6mLqUyLqBJ2PuvpbAcIIeM3iYSx513PXkm2BGgR82YZhXwMng75KHbMxrzCjXJrr2qt5S3mkck4nC9F1xA7aWPks5n6gaGEreIzbmieQCRS9bmEeqvp3sdR6uJX8E6itrNCguCSp9jzU/gYGsjYx34zX4o/mxVLUU/mfccD4ovohExZIcxOxrFTfuHERew40PsNN629IcXm+AIfhdlQzxuMZYoBda1XPh7b0kvcLj8Mkb6SMxgGHnh6puyBX+9Vr363vU421w8QrftvQte81iha183eqt925yvdf4L/0v/ym2+NL/5Ev/G5pDt/rUqj7IQc7cg8RU8uTWX6rOIqtJD72FudIGEludk/G3OR2je/5/4o54cCf/OpuG+2xS9UtLVTsXPCg9U9UmxAwQVNbD0jOOWrFD0D/4Vxn/w2x6iVrJWV6miitM1dPrfXnuUPc7ehZcA/ddyUevC+S/TUS3WA+eJsODh+gJ5LtSa2Dfcj0zcpxN8HALjiF3/B90D8v5lQO/iGTF4z/1pu8kuM/gvnO7tOG6lPU/vfgp0e3WN8uaOms/BmzpirTd6x3WN221z4p8f7Myn361TC2Oz1qU340fF0ksbnfJz8/HnVXp/nCl/R0='),
			this.addDataEntry('', 41, 45, '', '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'),
			this.addDataEntry('', 48, 48, '', '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'),
			
			this.addDataEntry('', 48, 48, '', '7VfLcqs4EP0ab2YxhXncSZYYiEMuErGN7eAdFlwMBuMKYB5fP90S2EmVcyeLqZrNLFJC6lb3Of1yNFGMvJ2/B+cDKcIomyjWRDHei6ISX3lrRFk2kaUknCjmRJYl+JvIT19Ip1wqnYP36FR954IsLlyCrI7EiTgoqy4bDspDcMbPJA9iWGdRmFTBPouMslzWWVSC6M8/4PwSvVcJCzIn2EfZa1EmVVKcQLgvqqrIQSFDwSxgx/i9qE+hUWTFO8jD6FdQZ9UHC3qWxHizKs5wGpTniCGZX0kbAewZB6KPp9J4gqaCKpgoutjKT+UlnsizNgfCxuszlXfdTN1v25r1UhI8LyVmFhdHCZWw0xTSaReWswtJ9YYYj32Ys8R+3p13b6GxV+JHO5EaJ13HjqfXdKV3rqF3tFNV0vuJPT9kwTYsQlNKSMpq1ySyncyUYLuUAn4WJ6+Jn0Zz6y9jpceARYq2bWY/LzU2Xz/ap2UWPS8uvkJ7O1Vrpiwa+7mMmbK8MGOa7uX2wtIiZnmY/DTtKemamHhMdgy9+emV8a+Vjnfar+9Ymms0sevppW3qZ7ebPdpmcwFdbT9fQ4xeEqr6XvnyOl9muxP5cGJ4bRlstcx/e3lm+dMx2G7q0Jidrt9Pmzp4W/avq5cpkzfdWpkdfHnzus82/W5lx5FnP9qpPXVSWyUd7E2+752UdDRBuQV7UlNz3ULMVOJBvBK1If0R4podwe4MYpLbyuHgNkfE04fzx8ae09J/o+i3D009cfp/0rHA3mO+O9GM52llX645WRwfHLk97/PNgR3Dzt8uz7utJl3lXnPZzTc5u/l4YPMnKTBmebBtS849bwpbss7AATFTklq161mtbVoycG9JDhx7X4H4x2SlSrQ/1sRbyLZpw0oUJ1307tyCOPkxXaky1zN0uE9qYlrSbV3XJNExnihvwH7M70I9OqnV0w5law31qHccdaoPOhpggb2tQZxl6jH49jUKvuCso4aEa0MT3PtQNxLYseDeuiUJyqyWGqoGmCvgoRIzRj4dMX20M3UNtXM9G2WARZVIH1fgpyU9gxwTlXVoY8HtIn/HQ/7Hzlmh7uEA3BXACRyYOsbA8SyI3brHFfpT9rsBE4/jGvweW8Lt6hJZjfglgZ/H9Kt4SCIeJ8TOIEdNBZh7F2JCOlUm3i7lPj2oXBNWE+oW8FLT1nBPPSI5HoF+P2IMpqRfIv6puxpzMOL/yDGOv83RZFMH7XqIN4bYco6a4GZNBVc2JdJXHNcwJ7C3LNXvdeQoA7+WQq7GGsScCHxYg1gT4Dc9ShA7RfixFeDz2Z9sDdjBH/AZ6xBsKlTUBdZDfC8Wot6v+U4FJn4f+Wrgp7vVMuTChJgagHWlA6bF9GZHxIvnxVu3e5PVMDMUzAeFXIacx/pbvH0PePCe8j9y4TU91vi9nI0YhpxNF56I/8C7Eb2ud2BDEznc3OMrge+R79gDMo9tcrUBcY8bV/RoQ1f6nTkh6gZX19TVf2VOJPq9PF/zK/JNU1GjtqhX3i+WdKvXETevH56Toc7gbJh7og+v8wL6WUXuaMs149bh/iycI7JrYr/7DcH+gHk69BTP65CvhqS8BiHm/Bwxlo7ng62FhnOUerriQz24+A2zGWtczD9LdsEX7RfITabmAjnjrEEMDcxzPG8oxzjegRmzbWDGxxLkvMcaJTnOfAaz3geM7GNNabTn2GTXy4ZakHgt8npIF5Kz4jM5Rq6cY7pWolzCWPQ452CedegT+wj6dLCtV4Nt4Gh3VxnGa6xDmLdChr9LrL+vo39HBzgf4f8l6AusLSEbMOkjV37fWf1Gx+CyEfddneH+73W8j75efnjQgzBftNvv7t14XXMBeetIot/VETJp4HtXp/qOzjd8/Uf5e/mx93itwm+7Dn1JVJjt/8frN/Gyk4fbf8cPjgKvil7Fh5IyG55S8IiJ2i+fY/xoeIvNoyKPqvcOVJokrA5CQ30Qtw5REh+qz2dBKfbx9ebtbQcfw/Nu3N6ekVz26ZX5Nw=='),
			this.addDataEntry('', 48, 36, '', 'jVVLc6M4EP41vuxhSxY4kxx5OLY8SJiAY8ONV2RAGJcB8/j12wInM7NVqd2DS+r++vm1cC8Uo+w3t/B6plWSioWyXijGraqa+Vb2RirEAqMsWSjmAmMEvwV+/QZdTii6hrf00vwfBzw73EPRprNmVtTNIB6K+hxe5TUrQw6nniZZE0YiNer6rRVpDdDff4H+nt6aLA6FFUap2Fd11mTVBcCoapqqBAMhAT2MC36r2ktiVKK6AZ6kH2Ermt8iaCLj0rOprqAN62say2Y+sj6FsvWpEO1Tiz41MlTYhAtFm0X8Wt/5Aut9CQ0b+y3DwaCr0bFv4xFl4fYNxWZ1t5RESYaVQofVPS7jO821jhovY1LGGdkG1+CUGJHCX0iGOis/cMvTWuZqg21oA3UJDzfv1wCf0d4lk5xgUSQbsM+JSnK1JMr5bHcFJ2Y/JltRB66O0pMu9u4OBaczsjAb44FAndaFIWroP8iWoUjRGh+/1JFCnsh2d/EzPjCP1sRcKyzrODUKsEN88nG/9eltj4NP0VmG1v30av7has+WwlB67MU+8/N0s/5heH0RHIPxS3aK52gj2uD4Orwpu3OwESK6ODz4ur+9R6VAksXkxEQsWOcfmfDw6j3GB2CtGCY2BnWkeQEyl3LPQGbjhPcSt3JHlYyl5lqy1VKTrkimXwMTZY4rGdllTPW9eicripW3e2zoebR5HWXmWHE6kj3/t1UPMe9BGYzByYE868wav6ay2xsvdXhcCf+028blaxEe39vE/MKfLfwmggv9Lct+q59hvjwoRR2ZkoFd/dNg+k/oRFbueWS0YPa2i1p2pD3cOzpoHTGhw1zD0HVvuxrYaB28IYkvbUNVKeC2qQ0wYWk3ypONHP+SAfcOY5KvgbmDYm9o94lZroqoueY0Uwdq+g115Uk5TKCj5tmjudMys4DYZHrDNKfgx1ez/E7ATqHea255n7m05jMW1NtRFz3qRXM/S9pMcbx4igv5l1ALnvp+98E27unhYZOpS2Y6cNdW0Df4H8Au7mRO5nEOtS6peZA4vAZN9ibzyG9sjiN5PF0Z2Ks0kzhFbCNjUww2ncxtm1S+Hgx3zDy/pZ62isyiZcAtMUGG2vxBhS/oAJgD+Q+DLTnyCuBczmW9igeoIy9kHcrMxxrupLcP3cAMmddZUkwfOIKYseS9B3/QrTs5bzoSVeqoKSo4R9tkT5G3XoEvlr0z0LE8ya28QDD7aX7MJJI/xEZHcoFoTpr53B3ZNNegtjwOs/dhXoeWeTG8Qwf6IJwZkCuTcTTwRVAjQcA3cBDkEFNhuQ//FHJmh36qGfq0PNmvM8xcBVTO2TYL/siFgTvghI/+qPG5zj9q+9e5e/rjG5T/LTgYVbk4FP2xWuBPPe2/XU+T6rGbNmlVps1tAJMuS5rzbKE+z17nNOPnh5fyNOvCepb5l+evXQeXx7r7FH+t1Qn7Y+v+Aw=='),
			this.addDataEntry('', 48, 48, '', 'nVbbkqJIEP0aX/ZhowScHR8RUKuHAi/V2viGwJTcxBCQy9dvZqG2szGzs7ER3UFdsk5mnjxZ1kg18nZx9S8nVoRRNlKtkWpci6IaRnlrRFk2UkgcjlRzpCgE/kfK/Be7Y7lLLv41Olf/5YAyHLj5WR0NK8NCWXXZfaE8+Rccxrkv4DuLwrjyj1lklOWmzqIStv78A9Zv0bWKAz+z/WOUrYoyruLiDJvHoqqKHAwy3Jj5QSquRX0OjSIrrrAfRt/9OqteEPQsFniyKi6w6peXKMBkvsdtBGHPZCD6Y5U8VhDKr/yRqg9TZV7exEiZtTkkbKyWjnLoZtpx39ZBT2J/uSGBWdxsNVTDbqKybnIL8uDGEr1hxrQP8yCmy8Pl8BEaR1VMaUwaO3kXNtdrZ6t3TqdNXJ4KloiYLk6Zvw+L0CSxnC/Dy2G5KVZb+rCLV7GXRAvrL2OrC4iFRPs2o8vNJFi8T+l5k0XL9c1TnZ4mWh2o64YuSxGom1tgjJOj0t6CpBBBHsbfTDpmXSMYDxTb0JtvvBTftzqeaX99xpq4RiNcrpfU1C9uN5tSs7mB7eS4eAeO3mJH83j5tlpsssOZvawYvC39/STzPt6WQT5P/f2uDo3Z+Tme72r/Y9Ovtm/jQNl17+rs5Cm71THb9YctFRGnU5rQsZ2wxjVgbsp5byfrsYNzbsGc1Y4ZEBrPNMaBw1hrWJ8Cr1kKuDPgJKfq6eQ2KcbTh4tpQxdO6X046LcPTT22+9/ZWIA3zQ9nJ5N12tLbsybr9KuttJdjvjsFadh5+83lsJ+Q5z5vbofFLg8+fXwNFnPiG7Pc37elzD1vCkqsC+SAMTssCWpmeq291RonmSd2Qies0zqXY65MsxOvgTlhvahhrQ0lR7RxFlYL3CjUtMDOEwxqDOMK+NMcA7Rkhglgdg73apakiK8w847JLfC5xvO9awkF9NoyhVVyDjhgq7rmO8wt4nQE7HQCaxDD6cTg68T63beOfhG7d00P7FPNGXsTWcM9Q5zeScA/X6vo3+Xrwf9Wxle6Bp5bV8PXQewOegaw6fiBTWUuwRDbQrRg0zr9AXhaAy+Qs6GprLfQhyL9S65OX45b0kEcY6fTh28uKlfykZXgf+yYae1AXCFqKglaj1P4Qp/GEOcWuQT/W1K7Jm2RY5cHPTV/agPxpnAvaBpL3ijkAv7n//BhETsRxN2L1onRbv6FcwvuCejkTm+hXprLIRKDAD8Yr9W5OO7pZKgnxMEF1n3sxATr2Q+6IJJPjA/q2d1rVNz5/A1HYtCFxBzmDhdk0AByvutt5NoMIA7WDtioQaF64JeBPhmnWMsOaghYckwgX8QlAdr076idiYNxctbj2DeIhjkNekuxzhVqiiWotzXmh9oCHeCXqezjgnXTmCkE8NQxnv0sL/WHvDj2jdViH2ENABvvFcCEfR6izlpX6syavOisxZwcbsmeYj30FOo3/tTC0I/g56lRC7Ffeu+pv8LmEEcveu9ZIx32A03Wj6/Hzx78bV+tqxefQ2zJs9/Fpz5Y63Wy36v7HYL9/uhp2cOPHKIUayDUf7lzOvZSb4wH+UNNDhryeqnPgY/OfW86xIAYNfQHeod6eOT/3VHW6x0lxx6/8zzcD5/14GupUTbgwL2A2LoqOe4p9kPrmilyQJAjBjpGLBnLwPcTC3Il93tpDzXUsH9e+pFIDct+XMvcsR+56cH9kD54PN31grpVfn5/MdTVeODTQ86hv7x7b8P+svj8ferxd/dwXgl8XeHf7P4Eg8dP1P7yGSeX7m+4RVTkUXXtwKSJw+o0WGhfh1OnKBan6sc1vxzm4nny800Ig/uz8DH9fH7KvR9ep38D'),
			this.addDataEntry('', 32.14, 45, '', 'jVZbk6o4EP41vuzDKeRy9swjAmrOIcFL1ME3BE4EQawBhPDrtzvozOxWze5WzRRJpy9ff90dMzGcsl+8RbczrZK0mBjexHDeqqoZV2XvpEUx0bUsmRjuRNc1+J/o8y9Op+pUu0Vv6bX5Pwb6aHCPijYdJaOgbmTxENTn6IbLrIwEfGdpkjXRqUidut60RVrD0bc/QH5P35osjgo/OqXFqqqzJquucHiqmqYqQaHAg1kUX8Rb1V4TpyqqNzhP0t9RWzSfPNhFJtCyqW4gjepbGmMyv7M+BdgzBcR+SrWnBF1FTTQx7HGrz+u7mOizvoSEndWS6Uc5M0+Hvo0HLYuWGy12q7tvJEYiLYNK6x6X8Z3mdkedlyEp44wsj7fja+KcDPFCMq3z853wud2yrS2pY3aU7wTNRUYW5yI6JFXiapnaL5PbcbmpVlvy1MtWWZinC+9PZ2sLwKKlh74gy40VL3Yv5Lop0uX6HhpsILnZxsa6I8taxMbmHjvT/KT39zivRFwm2S+XTKnsBOWx7jt294vX4vfWRpv+axvPCpxOBNyuiWvfAjl7IW53B13rtNgBRz8zZoa8/rlabIrjlX6SOLyvo4NVhK8/l3E5v0SHfZs4s+v7er5vo9fNsNr+nMb6Xu6M2TnU96tTsR+OWyJSTl5I7pl+TgeWwd7FPen9PO7Unnuwpy1zY41kM5Ny4HBrDsgZWRQX8DsDTkpinM9Bd0E8Q7J46ciC1eErw7hD4tqZP/yXjgf+XsrjlRWqTltyf6/J+vLD1/vbqdyf40siw8PmdjxY2vs57+7Hxb6MP2L8iBdzLXJmZXToa5V72VVE826QA2JmlF9aqFHj517PSg/ypTpxvZYOoaBQN1gLPyc6labG+Cb3c3sabM2eSbML3Bj0dmBjA2+7gRqhZFtTUpflYIs+dB90aU5aNgC3wBdz123AhRFyiMHXgqIvFceGtQY2FwNrQLc2+pUKi0ueWADn2mQZ+HQTArWRI+av9MAftw119lUsrOEwz33EnaMd0QN1ttZApgN2kFGNOZrCvc+Br3ynh4ONcl1h4TtYw1RIlR+sLwPVOsxDU764p4fSlEzhIhroTRkP0d5kjmkGygbWC9HjHDJ+PCNWKpEDb1B4HbsnSpcANqGlpdZQiM24EPDVKJ+TwDFhMuc14J6CTsv42kqwZ3NvGnLSBu4OdU24F945YAM1kZ+AxxAH6oQcor/sQydwbR3y6/E+ATwW6kHffOL6MoXYEmuCtsGhQ/4tsOnoK9gBbsbnFfAENZofQEcGnH3nfA0YbYjraX4urGBBO8BuQQ9p1BUNxS/cZVTV5rnfVyN/DHpR9MGIAWpCAOPaGDkjkmX4XUuVq2NalGMd1x3oqx4PHG3Ue+49McV+Cg60efr1+cPvFns/bEYc6juw/Pz9xIHjQfQEepryUIZY/9xDXoDzHfjzsNZYX+CVmhgPc2fYQ9hfeYj795mIJfYKGQAHxH/0YH4xmY49jrx7/+B9DXeT4hL7F3oB6uKqmYN7CTC5lxH7AHPqCmvr7gDvQxf6grr22P859q8tscfhfkNZFxz+LSZgyy9aiHjxjtyqnNScUJCxx8zgGvKaxlLdAQ3mxVS+yDHkdaA4n5bCgz2Vq5mTwPXn2cRZ6Gj2vA/eZ0ELXJwhr2NG9XGvDvh7cbyuBL4K8G/2eDrAj3baf/n8UKLH22ORVmXavElQ6bKkOY8ahv5tao6G5zQT54ehaY2yqB734t344zkDi8eL5rn9eDmps789rP4C'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 38, 48, '', 'rVZLl6o4EP41bmYxJwLOXJcIqOlLwAdq4w4DN4IgHkF5/PqpSrC7Z87pM7OYhYfUM1VffYkZ6VbRLu7R7czKOMlHujPSrXtZ1mpVtFaS5yONpPFIt0eaRuA30ubfWMfSSm7RPbnW/yVAUwHPKH8kSqMUVd3lg6I6RzdcpkUk4DtL4rSOTnliVdXmkScVmH7/DfTP5F6nPMrd6JTkq7JK67S8gvFU1nVZgEOOhlnEL+JePq6xVeblHexx8it65PWXDGaeCoysyxtoo+qWcGzmV9omUPZMFmK+tOSlwVRRHY10U4navHqKkTZrC2jYWi097djNjNOhffCepNFyQ7hdPl091uNuorNu8uQFf7LMbJg17eOCp3R5vB3fY+ukiylNSeNmO+EG5sPbmr1vGYT1XHi2SOninEeHuIxtkkp5Gd+Oy0252tKXX7pKwyxZOH9aW1NALSQ5tDldbiZ8sZvS6yZPlutnqHs9zYwH19cNXVaC65snt8bZSWufPCsFL+L0p03HrGsEC7jmWmbzM6jEr62JMe33Mc7EtxrhB2ZFbfPmd7MptZsn+E5Oix1g9JZ6RhhUb6vFJj9e2ReNFbRVdJjk4fvbkhfzS3TYP2Jrdv1Yz/eP6H3Tr7ZvY67tu50+O4fafnXK9/1xS0US0CnN2NjNQsPrQLalbLjZRWMp2h2QwwfrnZ6mM4MFJGWpMfHtEHDNL5B3BpgUVD+f/eaC9fTxYtrQhVeF7x7u28e2mbr9v/k4kG9aHK9ejnNiW/r8mMn68sPV2tup2J/5Je7Cw+Z2PEzIhz1onsfFvuCfe/zgizmJrFkRHdpK9l40JSXODXrAmj3Whw/PZjq1Lw+W7TMGM1Kyg/xp3cwBPPC7E9Bv572HHXBF9+35GWTCOrNzs3UP8xLMAr+toas4brADq9HmdcgtUcvc2U5zA8idCR2wHntXBnqj820HfGnrb4mK3RLpG3ZE1gN5x/DTvCBE/8YPMDfEp4P/PmxZh/oNY5g/uBBqr+EbQm384fU74WG9/bliAfRqs1bqwS/sIDf0CX0Z4Pfqu/O2xgTqBlx2MHcOPgx6M2D2VMqIEfIhzqgx9NtQlQNqY8SzJG4a67BGs4f+ASsTZRkH/Y4VXkaPMdBXzwKm9gJMoI4G+/YyWr/ioG/EovXtc+UGHGpzJi7UA2cGsUL8X7nGiDOzL0TivSWwtwN4yZzYW6PyYn2YT8D6gvfAsAYc7HACvhIT317LPND7OIT9vP6CfNB9qFHOXmK2bmAesv5Q5UROqDyyfsgFM2GBME42w14MyTOYwT5zdDxr/q4hgIuB+ZiFvJhrDO+yXrRhbwo8n75FZN8S/0y0Ay+gBuSl84Vz/H/m3PqfnNPg2/owd8gv1MzRhj7mMHOUoa9DM1H4EqJkpjggZ8lVjaom7KMBW61wkJxQOAKXVU7JGawH5hsqTqVGK3mK81ZcxrPwRxAMuAL3gP9j0GVyth/nVM5lWAO2SzxXVHE7EPrneQbboql9xUfhS1yOGdgRZ4WXxOCFD96j0qeXvMl2X7BGm8I6sCTPew/uFE/eF7vhxwf+hr2qgbzqk7nYCzfFdc2340zNXc4OeVV/zkFxBvfjvaPO88Af4IQh/YoGsZ3AmX19ATeB+6ovzGvghPw/fXHlI4fCA2eDZ6uDO0aouoT0S9LPe3yl/rfh3wveBMPDBp4USfvt40iqhpfRIimLpL534NKkcX1WHvoPFXVOUnEeooxBF1VKFh+Rny8tWAyPrZf4+aiTtr+9+f4C'),
			this.addDataEntry('', 42.86, 48, '', 'jVZbk6o4EP41vuzDqcjl7PiI4GjmkOAFdfANgROJIJagXH79dgd0zj5M7VbNlOmkL19/X0cz0u28md/C64kVcZKN9NlIt29FUfWrvLGTLBtpJI1HujPSNAL/I+39m9OxOiXX8JZcqv8ToPUBjzC7J/1Ov1FWbTZslKfwiss0DwV8TpM4rcJjlthlub5nSQlHP/6C/Udyq9IozNzwmGTLokyrtLjA4bGoqiIHhwwPpmF0FrfifontIitucB4nv8N7Vv2RwcpSgZFVcYXdsLwmETbzO20SgD1VQKznLnnuYKqwCke61Zvae/kQI23a5NCwvVxw7dBOjeO+uUcdScPFmkRO8XD1WI9bU2et+Yjy6MGkVTN70sV5lNLF4Xr4jO2jLiY0JbUrt8L1rTvfWC3fGC2XgWBSpHR+ysJ9XMQOSZW9iK+HxbpYbujTL12mgUzms7/tjSUAC0n2TUYXazOabyf0ss6SxeoR6Lyj0rhH+qqmi1JE+voR2WN51JpHJAsR5XH6y6Fj1taC+ZHm2lb9yy/F742FMc33MTPTs2vh+VZJHevqtdMJdeoH+JrH+RY4+ki5Efjlx3K+zg4X9seO7TdluDez4PNjEeXv53C/u8f29PJav+/u4ee6W24+xpG2a7f69BRou+Ux23WHDRWJTydU0s6Vs4alYDsvu+No+zOw2Z07EaHp1GA+cLgxdM+fAa/ZGfJOgZOc6qeTV58RTxfPJzWd8zL45Fi3ix0rdbv/8sF8k/xw4ZnSaUMfL01W5zdXa67HfHeKznEb7NfXw94kr3O/fhzmuzz6qvEWzd9JaE/zcN+Uqve8LiiZXaEHxMyZXN2ZHxDqBHfQnwStQZgzuzO5HbsyqFlqjD0H+pZW68qzwUFLahsNc86VK63Gs40W/HE9VjPUcY35EO9vtRV+dmcBPHXeBuIcC9Ywk7bVMtvoWHcoXX/WAMdQx9IgP+F7Brko5mq4E8B623qQl/lYTwAG2ngbAnmpAfnwXONoO1Hngh5Qu1I+2xp6mDXUoXAfWMdzrBONKfTGu61g2IfCvSW8JdhfE8An8y3TxT78LZzNNG4TpbmLeOQK9oIxzwIdsLZM5WQm5lR99jkF1GnYhjTYhzevgcet7tkEZmknYc9k6VDniR34V72pGmvwW4GPUQMGwKr40fi8hpxw7gcCGIYY5MKC7wPgUQrolQGmVQd6EM+ncL7Seq4Ud9DDzBxsjTkf0JdhcBlLwHz3/JUBtQnmhhqESVqhZlxGLxty16BdjRwDH8hNCz0BNqvr9RDdF2+o32sP6mE8M1g7+H8GFdSvuRMznuL5WYDeJvc5zMNKzQ7oBpqcNIVX7koPte1WAvwbmE0x2FVv7/bQtwYqM5w9wKdjPHNiiX2xDvH2vHPgHDHxbtAyRUwz4tmqt8ZTcWqWkA+cIZwHA/RAngcenhzg/bB6nW0y3BGso+7ImMlzn0vNA+qQ/fT9GcwjBd2shoN2nsPloFur9EZ8MkBbG/SAeyBwtgDLGWek5h3cRz8Yu4O2nuIX66q7Ww31FO9MaSIUtgC58ZWmY94+7yPpZ6yfPeAfeO+E6aKvPI/xTnAHZgvywFw9Ofvi0Q+wRg0zBBhJj1Fapsrrg/6qVwIYI7gHrFU8OchZ1OLcIC51f2AuhllRORDbcPf7ftU9gPn9LL6+Qzv8bThclgJfAPg3HZ4J8AOdNN8+NdTW8M6YJ0WeVLcWXOo0rk69h6H9ePvZB56SVJyGQOOt3wvL3hav4K+nCyyG18vT/HolqbN/PaL+AQ=='),
			this.addDataEntry('', 48, 32.57, '', 'jVXbsqI6EP0aX87DFBI8Mz5yE7OHBBXUjW8I7BgEseQW+PrpgPsyD7vOqdIiWb26e6U7lxkyC+E8ovuFlEmaz5A9Q+ajLOtpVAgzzfOZqvBkhqyZqirwn6mrb6zz0arco0d6q/+Pgzo5tFHepBMyAVXd50+gukR3OeRFxOBrpAmvo3OemlW1a/K0AtOPfwBv00fN4yh3o3Oab8qK17y8gfFc1nVZACGXBiOKr+xRNrfELPPyAfYkfYuavP4SQc85k551eQc0qu5pLBfzxkUKso1RiP6OKu+IDBXV0Qzp01RdVS2bqYYoYMHmZk3VU29o56No4kHh0XqnxFbZuihBSb9ApF+0cRG3JNM7Yi6HpIg5Xp/up9fEPCO2xFzp3GzP3EBvqK/3nqkLz9RUajGOnUseHZMysRROAtbQbKthbqDouFMiiWWMb3iYpY790/R1BlqU9ChyvN4tYme/xLddnq63bYjogDOtidG2w+uKxWjXxuY8O6uijbOSxUXCf1t4TvqOkSBWXVPvfgcVe/N16SO+97EXntkxL9ArbOl3rzeW2Opa4C7Ozh5q9MKpFgbVy8bZ5acb+YKYgaii4yIPX1/WcbG6RsdDk5jG7WO8OjTR627Y+C/zWD30e2RcQvWwOeeH4eRjlgZ4iTPcu5mtUDm35Nyew7wjXNptaW9IsEVQM40EUC+udWS4Ql3zK8Q1oCYFRpeL112lniFxlh12aBW+Upl3SCydu8N/cWyItyxON5qPffJx+9GT7fWXq4r7uThc4mvSh8fd/XRcKB/2oGtPzqGIP3P8ip2VEplGER1FNa696Eqs2HdYg9RMSRY2ZNgLbMm1sjk5koYOoQr1Z8TXBLWuYGcD2OXaF+/fuFe+4pob/GXX/HHPXTLX1wbYV4yYCuw3vYd55wV2DbnkuKcDtSQHMLlXgLNXYT6HOMjNiEqln68LigjE1RdgUyEv5MYajDVSAJ7ZEu9JcG1Ab//M2XgWhjyk92zIlekoHPRafonUbtnSXwBPYnPqAxaESsKlbT8PJWfKN0wce9Iy6RNwdgC7anQVDlNcGJsTl0hd1r7xAqa4AQZNodgO5F2boMGWjdxB1mHPKOSggdR6KEEDrOcKWqGOFhbPPmg0kH3YQl8gXmCrY50tsnCzcE451Br8ZD6JUytGkx6od7ZVyWsoIMbYD2LCvWDpQvaBgibPGnsiayfz9MSi/wbBduwhxFIgvuI5TN4hCGxHopIO+IhmIejddsRXhDwznim/uIPaTnObwX4ic+iP7DWcIb0b90imD4BrE0/y9Ym/Lj/PxiDP/Om2YfJmlz/jef3DxZuKb5+QEXq+H05aFmn96IHS8aS+TAzt1+R1STm7PL2Q+mPxc4KjaoLYh/PnkwSD56v0Pv18/UbbX4/jHw=='),
			this.addDataEntry('', 34, 45, '', 'jVVJl6o4FP41bnrRBxne0yWDhfGQoCVqwQ6BF8MgHgGB/Pq+ASyrhzr9Fpzkzvf7knBnill09j28XXAZJ/lMWc0U816W9bgrOjPJ85kssXimWDNZluCbyW/fWOeDVbqF9+Ra/06APAY8wrxJRs2oqOo+nxTVJbyJLStCCquRxKwOz3liVtV7kycVmP78A/SP5F6zKMyd8Jzk27JiNSuvYDyXdV0W4JALgxFGGb2XzTU2y7y8gz1OfoVNXn/JoOeMisi6vIE2rG5JJMD8Yl0CbRtDI/pTKz01IlVYhzNFH0X5rXrQmWx0BQA2t2siB72hnk9dE3GJhet3KbLKh6PEStxrCu61R1RED5zqLTaXPC4ihtbBLfiIzbNCl4hJrZMeqOPpDdnrHPeqRviKEuvQYC+SETPK4JRfw/VuidLd3ElXCmGIxnKexTbEp5g7aabgPYKeNoyovldtkKkvIuVdO9sHGq/zNvDgZOyjGpvLNFIw2zKNx5ZOk97gsb1snRN5nO1l7zKjD2RU4vTAHVPvCPcrZOk3tzeWyBQxq+9jvEyFGA2bLcVm9hOtJboViNd5FXhqgZTLxW2zRWAfi4h/yput3d3OxfESZXHvn95vwUmTkP3aH0/aLV7jJboeefCx8SL7LQ0Oy+b4QXJgR8OpxDBfAXuIJhYSjABL2XyQvRXIh8b1Vj34qhh4wEydu9aKITvPtvuNgdJXL6bXDdiQTSr/g3CwC56Yw//PR+RbFsGV5LEFNfbosWV+mtirn+YuWzjyvzF+2r328Q9OFoBRCk2jCE9dBfnnUdGWSFrdAIPomeDUb1wLzmivzn3A7nq7Ds6Jwu2Z4zRrSAo3x9o1cH5zZKEGW0hD1qrBwM24ZpJYRQ5hH/j5lHfDGqe4c9JdhwvcDjaoAfVkwqOhDvGyGrhsIRclpqoSD9d4r/bgR2Hlg8xUDXuITn715DfJOSJM5a61ucAKt1KXnTTqBxxw9xxvN9b0xv53vdoRK4KXAf3zETuysAYxnOyl4fWQXlVc7/005U2xKQGGTMKibyuqp75Ffxrkmfohxn/VR5YPdWgv6iSF1Dsp0ogpfKgqOHGmnKAX9bvxZUIfHHw8uI8eVcFHAvzgs4MXKj05VLDlC67gHlKwRS3JKOT1JSLjUWZ6K3LAOc9f+X1l6BNih3Nhz9x+55ojnnEP3KUH1V37HA/1NxfhCzkBw06e8LXIVGXsUTpww4P0S07oM+peuYa64HuB/4IOPemy3w/Yx3OacAu9uCcTbuEv6vbuXh+4+1L3iV/U/YHY4vXnWjgK/E+5KkaEYkxDBH7fSfftIBpU0xSyk7JI6nsPLi2L68vooahj1CVh9DJFqdqoC6tRpp+Rr6kGm2mwPcXXAB1sf5uvfwE='),
			this.addDataEntry('', 35, 45, '', 'xVZbk6o4EP41vuzDFnI5Z3xEQMwUQR1RB94QOJGbWAJC+PXbCRdnZmtq522rtEjSl/T3daeTmaTlrXn3bxdchFE2k4yZpN2LoupHeatFWTYThTicSfpMFAX4z8TVN9I5lwo3/x5dq58YiL3Bw8/qqF/pF8qKZsNCefFvbBjnPoHvMgrjyj9nkVaWb3UWlSD6+y9Yf0T3Kg78zPLPUbYtyriKiysIz0VVFTkoZEyw9IOU3Iv6GmpFVtxBHkZ//DqrPnhQs5gwy6q4wapf3qKAgfkTtxGEveSBqOOqMK4wV37lzyS1n4qr8kFm4rLNAbC2XduiR5fy+dTWQSfE/vpNCPTiYUmhFFJFwlR5BHnwwInaYG3RhXkQo7V3895D7SyRBYqFxkoOxHLU2t6rnb2XG5ykxNYPNdaJjOJl4Z2yq7/eLVCym1uJKm80REIxS0MT7BPM1uhmjyCm19iWXad8RZr6Ekhvytk8kHCdNZ4DmTGPcqgtkkDC8TZWulBXSUSXXWguGutkP87mgm7iJfVEVODk0Fma2tqdWyJdvW3ocoE0ZmN8b+OkMtgoWGsI1tLfaC2QLUO8zkrPkXMkXS6bJn3xzGMedNP8dWu2t3N+vARpSN3T2807KQIyn+PjSbmFa7xA12Pnvb86gblKvMOiPr7bGbCj4ESIcYdqW09FmMv93K0BA+VywA6sKlwGYxzLot1BFsws3e5flyh5xqI5LceGTLt03+0O5Iyn2Or+S8cAf4vcu9pZqMMee/TYxm4SmcZvbZe+WOK/MU5yp3l84eQFMAq+tsz9U1uC/3mQNwUSjBtgYDHbONnVtnNQkI4lXhEmbq3EFWyqNkhnXASttZeBix0BvILdGdXwhdwINeR1DnKKu0OF93K30VFlJUFjxwL4IXNMQUc3KOj0tntmo4qWY4y2EtY9tOHyVcLmNlQx+AZ7LMNeo2/ZdnBvC7rYmWITsUMIyJuNTmBvt91AvfV7MwywT7IDbITamkotGOP9l+/7rYL9QOeYgB8R/ML+o45QAyZh4mLYF2qZ4RRtkGN2cgAP7gjt8bhjvKCza3EsDLbGB256W4Znr6dc7tKeT+Z74HLyvdHhHPW2PZ9DbHZiyAwjO+EfuGB7MwxDLj/l78t39evsqBXozF06cs/sMM8d259zOOXKHXlnPqZc8v0/5V1teI4Z97x+cPWlfobv6pn7QZ/j73U490/OJ+5Jzx/Uhu6SkauRi54rxs+As68NHutTDrFeed5brMmN7WT/S+4D+n2dHzpEEY87ZTHAOOVnNaBc94n7Ay7IYZ8XqJGpLj6dCVYjl1+Og6S+20McJwx4DaYD5wWDH8CSBHCDqHAjIKU/N6ixU9yBvbRxoJao3PJa61j/QNA/dtwO7AW4hcCvKoUJboaewnsJdgyZc8Rih5pkvYLjhhyyXIJfhp+dbcJzRwXIkyHZ8bB/LHyJh0hwZqbYLeBt4xh02KOyh37U7+HpvQ9VgHwrrP7YbYm7FHLIe8p86oErV3I7XoMM41DjeMA34HDgVk1SYdfhgWPE+ALsROY5B/zMZ5QKwAXzDWzwnsbOI6+rbqynr9896P60D465HmqPjP11PLOfcqBxn9OZ5jXLa3KqjZ/UDtzpKsiQ4nbTeZ3uhs99Vhj6a/G897rmEUjedUvY2439lsMDD55WUfvtI5EvDS9EMyryqLpTUGnisLr0GpLSW12imFwGK3lY88t+TibL54sTBsOjc5w+H7dc9unt+w8='),
			this.addDataEntry('', 45, 39, '', 'jVVJl6o6EP41bt7inchwb7vEoJg+JE5RWnZMN4ZBOAIy/PpbiNrdiz7vLThJfTWk6qukmKg4a62rV5xpHkbpRF1MVHzN82rcZS2O0nSiIBlOVHOiKAi+ibL8QTu9a1HhXaNL9X8clNHh5qV1NCIjUFZd+gDKs1cMW5l5AtZ5FMrK89MIl+WuTqMSVP/+A/gtulYy8FLb86N0k5eykvkFlH5eVXkGBumgmHtBIq55fQlxnuZX0IfRH69Oqy8RjFSKwbPKC0C9soiCoZg/so0g7fk9EeOJoicyhPIqb6Iao6gsy5uYKPM2g4LxZsUUt5trvtPWQY+kt9qhwMxvthqqYaertNNvQRbcaGw0FM/6MAskWbmF+xFiXxUzIlFjxwdhc6NmewOxvdayPhC0T2pmblsi57nrpBdvtZ2RmOp2vEV0T0SopElogX+8ndrxQmUdgZzeJdNOvHwn2HgL1J3uWwcRrtLG5dAZ66iFeBYHKpUbqfehaYiom/ehNWtsh918a9at5bxzFZLT+NDb2IBMTiUxjWLdzWcEDz6Ln314ooGPTnEjKE5+kxUSm6HiVVq6XMuIej6vm+TNtY5Z0L/k943VFn52PAdJ2J2cXeE6OiLW5/7o6EW4ojNyOfbuxzsPrGXsHmb18YOlwI5OYyQHttZ8gUDWRpkCe4Z210PtwGqz5gKYF+1mT3pgXAfGhOcAq8kC+DjFkbX4jbeQz4ohXzXESWnPwBWcyxDF5PafNtAVX3GzQDkiOAM69/alI5g3wFZau86y26nvZ9dKU/+y/WIBXCWu4/avc3jbnD52ObHcwreaof7OxyLe7hNJrCFvVA03h0mto6YbU4xaOxYalZrCzKCinYZYvxB0r+nMXFQMayqLjxzWnnH68l3zLeyPOe0XNeNCO8EKWAt9FxBjyjjcxHirEnNbr81DT8xRH7zsCOCie+KDHdybaRgTuJkJog5tnjp7f8/tGbd65CYgJ41x1tucDH18xbL59zP35qmmEPPUDbVC7L3R2Bx6zQ/6I3Y1xqKP2EsO+JSYFNmxoa0xGl5ZDxy1zAx/cU41eFEtlQbamweoM1DCmDb3V+aIwU6l/fHXt16+2Sq8+V4bxpg6fww6GDFR++OwvEOPSWlFeRZV1w5MGhlW59FC00evcyTF+eGlzkbMK0dZvDw/Jy9sHsP3KX4O+bvu2z/gLw=='),
			this.addDataEntry('', 48, 39.43, '', 'xVZNk6M4DP01uexhCjDMTo4E6MQ9GJpAkiY3vsaBkJDqQAD/+pVMujtTu7O7tZc9pJAlS5afnhTPiHUalm/J5cCavKhnxJkR661p2kk6DVZR1zNNKfMZsWeapsBvpj39wqpKq3JJ3opz+28ctMnhltRdMWkmxbUd67viekguKJanhMN3UeRlm6R1YV2v664urmD68hvob8VbW2ZJ7SZpUb8017ItmzMY06ZtmxNsqNGwSLIjf2u6c241dfMG9rz4kXR1+xDBrEuOnm1zAW1yvRQZXuZHORSQ9kImYr5rlXcNhkraZEbMaak9XW98pi2GE1zYell52n5c6Olu6DKhlMlqrWR2c3NJTvLRIGw0btkpu7HK7Jk1F/kpK+lqf9m/5lZK+JyWSu9WG+5GZueF5uhb5shGXXg2K+nyUCe7vMltpWQV65gIBC0XJNmtlUTqePlSxlWxdH63QpNDLkqxG2q6WhvZcjOn53VdrIJbTDxBK73LSNDT1ZVnZH3LLLVKteGWVQ3PTnn53aYqG3vOokxzLbP/Hl35j9BEn+HXPo7hWz33I/NKbfPij4s5tfsb7DXS5QYwei49PY6uzy/Ldb0/sweNFQ3XZGfU8evzKjs9HZPdtsutxflDftp2yetavITPaqZtxw1ZHGJt+5LWW7EPKS8iOqcVVdyKDt4IaxvXjgFYKoCRwSLAp9R1FgGOKz68hHR0K1P44Jvsgjk9Op/YBcdnxC4lJo+14ZARBth5CrPo7R/3QLxU258gRwXOGGj57adb9rd0WXf73dO4Js+H/bKu03PwiIw1P+53e/FxTjT08eu6ocv9JV32cMZ2TC1eBeER+IB5KwPwQ2VVBrXiHfy0vKId0/jgVo4ajzrxKs6ZZcq1WwU9GyeZ2k4HPNQAh96z9MGLaAvyCDgJZgcoEz/UFc/eCjcEu9yfgZ4qoBeeyCvU+zacVznExb1RDLykOsg6wzxADu2s86pYiUcF8tuM03kgCxPj9sBliBkoUmcfUDd61RF0jsJK3AccRF2I/kdpZ2KDeaiuzCPGXHXpXx1HjOmD7NmBEgsTbEzzSn1g4O9VGwJrjKF7IoN4JuY9MBuwq5gq7xOxzzNf2WdMO5AxpbzkArjVeyRuEa/Qhn22SWLw9SLGZU1Gs4c+4HAu3Hkz4vl+xAm1/3IP2lQ3omBzjG0l4xlT/kfdgxnARgXqxnvA3vDtDM9VvCpDjPEOgom48wRwPtQ1ZlOI+V7TTGdn1vn20Ziw5WgT8EUMtcR2dLeKdaY4AjHF/BjMIOAM5OZwVgVYNw17iZ0g9+oIfRarvuSUCZzHb6BLPtkwH4APnh2rkodiowEHe9BPtZf1Rr0pcfTEETFVM8mNAOLIu4yefcQakIkzDpztDJILkAPIxlRfE/tdhRphjaG+WCO8b0AAG4i9lfwEDBBLRWI08RpmquSHKmu5Qn95LnAc/RnxRnkWctBgUmafHIS87nxAv8lu84nD21ggv/0d62EPmTBmOuQue+7960aOxOODN5iPiAFDs5V1g1wx/iRP/ZoDBoA7gRr01MLY2Gt8lLhHG/64F2oq9/6n/keu2eyh/9cP/R8bD/XRpvrwEeeuj/1lI0+m/prq7H1NIwfsHOaKYiC2U07x3+b0ftc/c4d9cMe3HmcTfZ9Nqqyfhvk7gDvMigj1gerhXJP14NOMqw6NG0H/2I74P2ZTDlyAmmmQay/3Yj0jp8Xeuvc79CxwrXJ6ycfIhD6lwivvZ33wdCseeKjIfEOZ79c0VNRpZphwN6Z65xhiOBr8P8gexvnlY+2r9def/qu+uYDhXuj4OCOL+/MNHk7F8MsnoFTd33/LojkV7dsIW/oybw/TDv3b5HUoSn64e5H5F51M6uQ6qfiH8+eTEoT7q/J9+fl6lbafHrd/AA=='),
			this.addDataEntry('', 41, 45, '', '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'),
			this.addDataEntry('', 48, 48, '', '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'),
			
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 37.33, 48, '', 'xVZLl6o4EP41bmZxDwLOtEsetqabgDb4YofAjUEQj4A8fv2thIjac+6Zu5sFJySpqtT31ZfHSDGyZn4NLkecR3E6UmYjxbjmedn/ZY0Rp+lIlmg0UsyRLEvwjeT338yO+ax0Ca7xufwTB7l3uAVpFfcj/UBRtqkYKI7Bhf3SLCDQ6nFEy+CQxkZRfFVpXMDUj79g/BZfSxoGqRUc4nSZF7Sk+RkmD3lZ5hkYpGxCD8ITuebVOTLyNL/CfBT/DKq0fIqgpZQwzzK/wGhQXOKQgflJmxjS1nki2n1Uuo+wUEEZjBSt78rvxY2MZL3JALCxXNiy3+rqYdtUYSfRYPElhWZ+s5RIidqJgtvJLczCG060GhvTLspCihb+xd9FxkEhU0Sl2krWxPK0yna1znbVGicnYpvrCptERVTP/W16DharKUpWYyvRVMdAJJLTUzQH/wSzsdZxEeT0QW117xUfyNDeQuVrcpivSbRIa9+Dysw3amRMk1DBdEknXWRqJG71LppPa2tr3w7zaetQvfVllDverEDmrLHdmmAPTz69gvx0tSpUVg1aFARi30JjnBzk5hYmOQmziH6aWLIMbYzbmtgdujitPkVmfRN5PGW3nH+l/hk/jRheUwTbSbrffSzC7P0UbDdVZOjn4f99UwW7r27pfoxDedOuFf24lzfLQ7rpfBeR2EOMidZKVhObQt/kfdlK0BizvjeD/rpymK3J/lFlAxPA7sU3Jbp6Yc9Ynd56hHpymL93rK6AvEb07b+tGoh58zO/83esYjNqdWqGlOPRqU8fS2P6b5zmMP9myd+ZWS70I9SZ+FlaHCDTaPdRfBq2/glIWOaehyTQz9hh2mnV2jGPCXZV2TZDgg2NMaJgV6ocE0nIBNRm2Fhe3yJTK60klG2Yx0xH3qzCHWktV1WwuS8hjmp7GGxWDaaS8J0xn9qmUnP3tTtNds0Tn9+3rL8fs9jg38G6Q2zHXHfCF2xnQ252MlNBbVzvsLaMPULE2gwDrLOXAJuKkxXBVJXsbvatff/74Gkl2Iz33QzirRRY/24D+ZLWfnAhWq1mOO1kDfMI9h3Dg1WOE/AM+bqqhD1UCt/miRvhC3hOZMLnt1jwCbHvXA6xCeyM3rfn857bvnE4RravH1ywtTmGvpYv9fvexhmcIV5Y2Vt85575dX3t2PraS60G3lk9h1qy9V/qDtxLgnuun+6um+/tU+2FPcMvbDj3A+cD98jg/IE2NJnXnnN154JzxfgROIU2eK7aE5c+rzuGsxOb68n/Uvsz/r3OU9xiqrG8JywH+J/wvbrD3PaB+wmXjAVvTCN3XbzsCa6R+CS1bL/DXQF5bBLA23AbQ4O1CWCBXLs1gfukdTy+b1rgy8Qd08gJtAQ5eExrmJ0fcH9oUu8H54ihjvkdpOw7bIgzhXM4a7hGO5Y7BpyQu4dEDVktTxLDz/Y2wwY4SqhTA5oU6+/Lb/kgWwb+htwlyP3UnzUd43Ld8yPWWLU8BtyNWuV4IasHywM4Rf2Z8jgDtxCXa5BhFBoXvAw44N5EE3uGO8Fxy/kyVBVqWbI7mene3l1swMViAxv8TGP7kesKt9I3XYl2TZQ/Pwfvte61B7yVDz3Ant291IDHfOxp3NcZOBm08QfaCUxU8zfDFg/7dbgb3Jdztryfry9335ulwKunU9lDTtHFUw8eWXHz2+ciHxJvxXmcZ3F5bcGkplF57C2Uf34oSu94jCk5Ckf1rR8Lir5PBufH8xN+xAv03n28dPncy0P4Fw=='),
			this.addDataEntry('', 43.73, 48, '', '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'),
			this.addDataEntry('', 48, 46.29, '', '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'),
			this.addDataEntry('', 35, 45, '', 'xVZLl6o4EP41bmYxBwHntEterekmoC2+2CFwYxDEIyCPX38rIaL2nD5zd7PghCRVlfq++vIYKUbWzK7B5YjzKE5HijVSjGuel/1f1hhxmo5kiUYjxRzJsgTfSH7/YXbMZ6VLcI3P5Z84yL3DLUiruB/pB4qyTcVAcQwu7JdmAYFWjyNaBoc0Noriq0rjAqb+/gvGb/G1pGGQ2sEhThd5QUuan2HykJdlnoFByib0IDyRa16dIyNP8yvMR/GvoErLpwhaSgnzLPMLjAbFJQ4ZmF+0iSFtnSei3Uel+wgLFZTBSNH6rvxe3MhI1psMABuLuSP7ra4etk0VdhIN5l9SaOY3W4mUqJ0ouJ3cwiy84USrsTHtoiykaO5f/F1kHBQyRVSq7WRNbE+rnJXWOSu1xsmJOOa6wiZREdVzf5ueg/lyipLl2E401TUQieT0FM3AP8FsrHVXCHL6oI6694oPZGhvofI1OczWJJqnte9BZWYbNTKmSahguqCTLjI1Erd6F82mtb11bofZtHWp3voyyl3PKpBpNc6qJtjDk0+vIL9WWhUqywbNCwKxb6ExTg5ycwuTnIRZRD9NLNmGNsZtTZwOXdxWnyKzvok8nrJbzL5S/4yfRgyvKYLtJN3vPuZh9n4KtpsqMvTz8P++qYLdV7dYfYxDedOuFf24lzeLQ7rp/BUisYcYE62dLCcOhb7J+7KdoDFmfc+C/rpyma3J/lHlABPA7sU3Jbp8Yc9Ynt56hHpymL13rK6AvEb07b+tGoh58zO/83esYha1OzVDyvHo1qePhTH9N05zmH+z5e/MLOb6EepM/CwtDpBptPsoPg1H/wQkLHPPQxLoZ+wy7bRq7ZrHBK9U2TFDgg2NMaLglVS5JpKQCajNsLG9vkWmVtpJKDswj5mOPKvCHWntlapgc19CHNXxMNgsG0wl4Wsxn9qhUnP3dTpNXpknPr9vWX8/ZrHBv4N1h9iuue6EL9haQ25OYqmgNq53WFvGHiFibYYB1tlLgE3FyZJgqkpOZ31r3/85eFoJNuN9Z0G8pQLr320gX9I6Dy5Eq9UMp5OsYR7BvmN4sMpxAp4h35UqYQ+Vwrd54kb4Ap4TmfD5LRZ8Quw7l0NsAjuj9+35vOe2b1yOke3rBxdsbY6hr+VL/b63cQZniBdWzhbfuWd+XV87tr72UquBd1bPoZZs/Ze6A/eS4J7rp7vr5nv7VHthz/ALG879wPnAPTI4f6ANTea151zdueBcMX4ETqENnqv2xKXP647h7MTmevK/1P6Mf9Z5iltMNZb3hOUA/xO+V3eY2z5wP+GSseCNaeSui5c9wTUSn6SW7Xe4KyCPTQJ4G25jaLA2ASyQa7cmcJ+0rsf3TQt8mbhjGjmBliAHj2kNs/MD7g9N6v3gHDHUMb+DlH2HDXGmcA6thmu0Y7ljwAm5e0jUkNXyJDH8bG8zbICjhDo1oEmx/r78lg9yZOBvyF2C3E/9WdMxLtc9P2KNZctjwN2oVa4XsnqwPIBT1J8pjzNwC3G5BhlGoXHBy4AD7k00cSzcCY5bzpehqlDLkt3JTPfO7uIALhYb2OBnGtuPXFe4lb7pSrRrovz5OXivda894K186AH27O6lBjzmY0/jvs7AyaCNP9BOYKKavxm2eNivw92wejlny/v5+nL3vdkKvHo6lT3kFF089eCRFTc/Phf5kHgrzuI8i8trCyY1jcpjb6FMeq9jTMlReKliLCj6Phk8H29P+BHPz3v38czlcy+v4N8='),
			this.addDataEntry('', 48, 32.57, '', 'jVXLlqM4DP2abGbRxwHSXVkSyMMp7BQBKgU7XmVMTMgJEB5fPzKk0l2LPjMLDtKVLF1Lsj1TjaLb3sJrRsokFTN1PVONW1nWk1R0RirETEE8manmTFEQfDNl8xfrfLSia3hLL/X/WaBMC+6haNIJmYCq7sUDqLLwKkVehAz+qzThdRiJ1KiqYyPSCkw//gH8nt5qHofCCqNUvJUVr3l5AWNU1nVZgIOQhlUYn9mtbC6JUYryBvYk/QwbUf8RQRecyZV1eQU0rK5pLDfzybsUaK9GIvoXir4QGSqsw5mqT6qyqe5spqy6AjZsvO2oEvQrLTp1TTwgHu6OKDbLu6UmatIvVNIv7nER30mut8RYDkkRc7wLrsFHYkQqW2KOWiv3mOXqDXX0/mDo3cHQFGoyjreZCE9JmZiIE5c1NLc1zFdqeDqiUGI542/cz9Pt+pfh6Ay4oPTUCbw7LuKtt8SXo0h39t1X6YBzrYlVu8W7isXq8R4b8zxSunuclywuEv5qnjsLchPXq7C5Hg7O+RfeIWZdKCLOCmSKIlWvfWVZRSr+iXf7i8/ZQI2WUZfAmrh/dSv26egvljrxeHJzu3NwCoanbp9foq1ogtOmP6r7LNgKEV1sFjzl43tUCCTrmXxQEQva+icqXGXxHise1O/cvzm4J1zrqCl1JvWOOlpHTCztnbRb+RrRHrPUXC9xjhtikgXU7xpA7WwHQw/3nGq+W+0lo6kqqzzabgaZeawWf/lvrw5i3oMiGIIPG/KsuTVoBVaz7NCe92/GsgpPC+F/7HdxsTmHp/cmMZ/2F0s5iuBC/sjytltlyZaxoBBVZMoK7KtXg65eHcwkc9fFipWTOXF0uWONupvcymOFcr2FzjXEtRdg10ivd7ICB+fx/yD1N9xA3+3racL8HjVkwBo2dfD3W8JBl9MBuUY5jwd79Dl3kE8FnzkFnEo+vTZAjFpONHGTAeK2BwdskBdyw3Sj5mDugS/uJE7yNXC1F2NcyGnlrIc8A8kzDN1tqUJa0Fs6SO7yZICfC34Scz3A1grd+dI2pyfpM+UbY8E0TFwmfsT1EWCLg3k8kSkuyPbk666Blz638rNGDQSTYyvEI8OTm+shPPoSWYc5Nj2QPcl1Hppr6AdeAFeoo95DX8Y+HExP9gFBXyCe18Ff2uFkwel2faiJp0z5JG6rUDvJh8G+Ec03CgFOYz8GnYG9JXJfZgyc2NQTqN3Yb4iZnhGaego9GG+PrBxvjEEf3nOoPtSNDr4CfBEx1zWRtTGZ/PdwKh56hmGeBupCf2SvTczIOCO4JdDXw+Qn/dnD/+e38yHPvRIMmrze1dXjAYCrN+3++oiM0OMF2aZlkda3HlxantTZ5KG9TKuylLPssUpVfix+TXBYTRB7Lv79KIHweJe+1N/v32j79jz+Cw=='),
			this.addDataEntry('', 48, 43.73, '', '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'),
			this.addDataEntry('', 48, 38, '', 'jVZds6I4EP01vuzDFhCYGR8R0BuLBBHUC298DYIo1hUE8uu3G3Dm3tqa2q3SStKdPt19upOwIMa133xE9zOr06xaEGtBjI+6bqbZtTeyqlooUpEuiLlQFAn+C2X9B608aqV79JHdmv9joEwGz6hqs0kyCR7NUM2Cxzm647S4RjmMqywtmiiuMuPx2LdV9gDV33+B/Jl9NEUSVXYUZ9WufhRNUd9AGddNU19hQ4WKVZRc8o+6vaVGXdUfoE+zn1FbNZ8Q9KrI0bKp7yCNHvcswWR+Fn0GYa/GQPSXVHpJECpqogXRp6WyfjzzhbLqr5CwsXvjSjis1PjUt4mQiuhtLyVm/bRJStJBI2zQnsk1ebJS75ixFOk1KehbeA/fUyMm+ZIWUmeXh9z29ZZ7usQHVWPmJWcib5lwZVqs6vBU3aI3d0lLptolk7hH81SpLukG7EuX2OWlczwKMW0Lrgb+Y0sN/UdC9lq8OeTpW9WFPlRmc1RTY1kmhBW7IiizjfXdcC9tQtwuI1yKid4EyvIRE/qNimPBBVODslm+MA1PE6m5/g64z8SQy1jpn0lZl6ykgvuu6hDpSsn57HSXnJrdc/b/KardZl+FN/ZJYvj9IzppVfC+fUuu60t0Orapsbr9mq+PbfS+FztvKyfKcTiQ1TlQjru4OooQWMh8iqwAA/nISmbimgq7dGVuoN5ChttJZ33RRSdg9GJ95mIL1UQe8kDpz8DTkt64xAz6/M89gB8r4RVilHYe7Wnx40uW3TPeVG14Wg97sj2Hm6qKb+5nZozlJTyF4pcfv++C931NN+E93nTg4zjERl663qWgG4xbgrjUwTFZA/lozon10AWaY+gdNVnLyxw4CTRqHlpmBj01KY5SIqYR94xdVqgdL92ce2rP/b3CStY6vk4CP2lZoQMGzdmIaTVf96al7VvQoQlgTaPtI2YwY1oN7MNxXq8pL1TC/Kq0PVXj415LRgzHk1rmHzTbpy0XuQx6mfn8DCdhoOYYB/jXc+ZJA3Q/dK8EuR4kyHWMb9qnY5w9YmC+tn9ATHIsA8C0tEDoc/wWcHNp2KASsAc8XeGGJNulJXPL+hceNSd7iEly/Opb7EmCF7oG/hW+yYVjqIKb/PTKjRkYWzCwQcJc0KfERIAj7GPzOvzMhcL9A9RQ76e8qMY8dYAz1cBIHKgbLw8E/TNxaAFDnmxc4EPtGOQC/qCfIXc42c77vZlvDjFyV1qqZ7ow5iItLQlvD6awjhqq4qAf/4I40EfIy2GsJcQ9YE+xySfqe1YmoMd+eunBp5IL4FHm5b6EtcqHsU/Al6vav7EVxwwwRgUwBXANOVwQSx37x6fyiDVIr/g5Azn3kXsKt52lcoVNOWK+PmvGeH0LZHSAnkA7leEZh/hnv5MOZEzg3FU56n1dgJ5wkeLYw37E7djUf2irMX+LNZzPD+2dEZ9CrwHnY30gz0Id6wt5IqYy1mZQVcgF8A6y847nb6xT7/gunKeATPN1zWCNtQmg/+C2n/gSrjT68PQ5F9SNeYAPCjKmjTngucCzLRI5GTB+6M0CzyL6sHroceQb6oF85T0bsL+h3gOeG1cA/rQmdWELdbqrBd7T4W2X45uMv9X8cMOTmfV/fPxH0fzyb7L6mjUfA2zpirQ5TzvUH5PVOSvy82xFZln0mNb5L8vfXxIwmT8mXsvfHy2j7ss3zT8='),
			this.addDataEntry('', 37.71, 48, '', 'jVbbkqo4FP0aX+ZhKnI5fXxEoDGWAW1RG94QOJGLYrUgl6+flaDdfarm1MyDFXayr2uvHTNRzXPnfETXE6uStJyo9kQ1P6qqHr/OnZmW5UQhWTJRrYmiEPwmyusfTqfylFyjj/RS/x8DZTS4R2WTjjvjxq3uy8fG7RRdxWd2jjjWeZpkdXQsU/N2e2vK9Iajv//C/j39qLM4KlfRMS3X1S2rs+qCw2NV19UZCqU4mEdxwT+q5pKYVVl94DxJf0VNWX/zYJQZF5Z1dcVudLumsSjmV9alSHsuEzGeu+S5I1xFdTRRjVFUXm93PlHm3RkFm+uFq4T9XDseuiYeSBYt3khsVfeVmqhJr6us1+/xOb6z3GiZORuSc5zRRXgN3xPzqPIZzUi7ynd85RuNuzV6lmmEYfVMyiNnfw2VE1lvqZQTpSwSBzY57Vf5pqO5dqbq6eS1BadWNySL8hZu5yR9n5fr7ZKE7yeyUtwh7inyXV1cwsz5C1245KgadaDMbkeV/qCL5SXIuM62LWe+PV2ZRseG4ur18xk19SGxbJ728yFxZu3q4N6Pzqz3snkfKrRiw+ZGrd0AG5VlBXwTvhZVikz8z+x+hs7+HA+f8nLtdNfjeX+Ki6QPDm/X8KAT6nx97w/6NVmwGb3sh/B96cfOax7uZs3+3S1pNtdZTjIg2rh+oUHWRplCthV57kPuNeIOG6DNOyDYAeWBZUD1sJnRws7WWZCnjv1ibpDPiAkPlO4UqyKuwIre/1NnS/lRCc+xshdd6mj2E0gvM1cL/NvS9FugVTbh4bV/U5en0CnL42XzTQNYFeEhHD7j+F0bvL9V1AmvR6cV9fdHk+ebbZFRR+RNOrfXFM+30SvUn8daMNgNsFCoZXCwp2dW0bgWcrFYwyybUEucB6ift8BEYxbjbCv0dmJVPYt/yZmmu5dAW+VMYwfWjraGstqCleCB9O/b9ad+r7XMD33m88az0AuLqoLNzI+RW9GN8p5CT2V+ma986W+KXOtHrjWYjLzIsMrBu4wgT9q6Jauln3yDWriG+LCh0KEaew9qz9QGz3JzZgp9W/Fkfkz47Fw/ftQT1LKeTNYMf5ywzJA4uGMcBZP2Pa7C9oGCuJ3rsBYxdc/aNaitF3mjPh1nxNsSTF88IObg5jvhV0VPNHBR4KKwXOIK7nFZo2uFPs5bT2Ai+xE3ns+AiwFfBnwGmD0ipr9jpqYIO2A2wIfm+YWMj9obcLmT8Q8MucSwZ4qwgX3vbmV8PsbbyPjegglsulGHKZ4p1o0GDJA/JaixYUMwHXHRpq4lcVNdn2GONuozZnomNRN982P0d149sD8A1ynz3x49QM9EDRZ8+1T0WH/2euVLHvZxTyT23kMfq8TefcoOE/h14A2HT+RoT4Hbs6/oo/HkxtgjE75zhrjGU5Yru1yRL3LPjYFaG+SwPAk+jDjQqZwT02glpyXWheYqgh/2gL2O5WKPasgLtlRwjwAPsae7C6HHpqJf4K4qeMkGsWfoW8ybO9h60BP0d6NLjosYksM7ReCBuRzncYi7JOdYeRcMBkcOqGWDfwvZo0euWM3HeuAdZkh3wbhxXoyWmpipwRZ5499BcDWu5dyCA7gfRL5TN3vWGIjZl9/IqXWt1x/HLcGcb8DjMQY7C14JzIyRv7noXyzzBXfRK96PPCnEPQtd2stafHFfiDPhp1CZYveC05I/speGuEfq33XkfHcP3j37Ln3KWfuMB04NgfaFpZg3qoJrox+BNTAN/EesDHfjVsQTNZDv/gTOtZx9wYVhV4810t9i/rsf43usPs2+/hfW4z86bnS8Fh5PHjw20u6Pzya59XgzOWl1TuuPHiptltSnUUN9+fvlYXhKM356GGo/x73oNsr80/jrGYaPx0vsKX69+OTZbw/CfwA='),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 48, 48, '', 'jVZbk6o4EP41vuzDVgQ85/iIwDCZIlEHvMAbAieCKJaCQH79dgecmVO1U7tVWkk63V/fm0x069y5t/h6ZFWalRPdmejWrarqYXfurKwsJxrJ04luTzSNwH+ivXxzO1W35Brfskv9fwS0QeARl002UAbCve7LkXA/xlfc5udYwLrI0ryOD2Vm3e/vTZnd4ervv4D+yG51nsSlFx+yclXd8zqvLnB5qOq6OgNDiReLODmJW9VcUqsqqxvcp9nvuCnrLwhmmQuUrKsrUOP7NUvQmd95l4HZC2WI+aSSJwWh4jqe6OZw1F7uDzHRFt0ZHLZWr1yL+oVx2HVNIkkev76TxK4enp7qaT/TWT97JOfkwQqzZdZcpuckp6/RNdqn1kEXc5qT1is2wgvMhvtmv7TwT0Xsbq+RdiQrn6pzqpWn1AX+ghq0MM5UPx6X7UlQu5Ppa3mP/AXJ9oty5b+RaH8knsZl0lOw07twwqzFT/rKyUE361Cb3w86/UFf3y5hLmbMbwULnKlnmR2Tp+uyX8ypNZOp7YisX8jUnbfejj8O7rxf5os+0mjF5PpO7Y0EGZ3lJ8AmYoXeoSXBh3W/Ind7TuTH+W3ldtfDeXtMTmkf7t6v0W5GqPu53+5m1/SVzellK6P9W5C4L0W0mTfbPS9pvpixguSs2DRMmjM4G8OZNdzeEHUfwLk3CJdriLLoMHpeYcqlDxHdref05OSrPCwy1/lprcGeISYi1LpjoqNejBV9/CcP4B206JxoW8xQR/NfEOm3nBthcH+zghaiVTbR7qV/19+OkVuWh8v6CwfE6hTtIvmhJ+jacP9eUTe6HtwW/e8PlijW/imnLtpNOu4bPVRIB/51XPIj8w2d2k7De7OltimYRRrIo+b5hrZ0WQ1+G9wHWqFoPQuQtgZ5oMkEaVMujxJWyQsKdxRqgTQ8SAxFkyHyk6XCpUThjjpCxChYD7SW2QL5NG7BXjqwDw2vcDp+eep76t7oS+uJi7qeepnOc2XL9z4BZlqkBbOgS+wEcupoEA9jGVA4n3qUgbowRnrHoSaYDPtRD2Cf0OdpgrVhC/RHfti5czqvSMSgG3Wi7hHPN8hyh1hUH+IUKn2w15f2etgHyBtpXpD+CAIHcDfg07YAvBnIIR7QEgk+orwA+wgL1qivXQ6rDvFpuGRCxcoWAw1kIaZkaSt6O9J7dVYr2AyYzN7gajAf9ZgtTBACcYfcA0Zvgm8hxBdXc8aVLWuDfZ6nKkeag3lS9HEd4u+Tr3waxAJ8S7oRd8otvAffFK4zhfr4aoMc5Kkx6KeASyAnol3CpIO8t1CLylbAU3I8V3gDZo5Ym+mgywFMomwFXaNNyCuwplqokRrshpidsJ400DvY+7TfhTxbEFvAGtenfzrayftxJd/GoRl7bxpKsx5zizVGvCF3mqoZ+wTnDdSFo3KOtcGlM1U1LaFfgBe+BDNqw2qbhhdgDYnpRoZYn4bCkCbUIdSozcD2zYw739k02IN9nJ0J0E6oYxpCTzCY3VATLfCMfYQxW+vgZ8MLE/rlX3nUnbLZTnT0E/Qbal4UII91bidqDjCbYgxgzmKtOwa31JwZ+t1X8wX7RYN6R9qM7VX/S8g/9F4CezHwBeE4S5LZMEvWyDeFXml5QEc+7OdIql5Eu4E2YmP/dSjPbeVfq/KUq7mAc0gMNm4hF1T1G8yeZqhFjAXysTEeg88g07JLlXvPb5ZsH4keXVYC3yz4W4wPG3hSZN23jyNFGl9Gblads/rWA0ubp/Vx4DB+DVLHLBfH+k9afB/O4kPy86UFm/Gx9Tx+PurU3R9vvn8A'),
			this.addDataEntry('', 48, 48, '', 'jVZbs6I4EP41vuzDVgTcGR8ROBiLBBW8wBsCgyCKpSiQX7/dicdz5mFqt0qrk77l66+TkJFunXv3llyPrMnyeqQ7I926NU2rRufeyut6pJEyG+n2SNMI/Efaxx+sY2kl1+SWX9r/E6CpgGdSP3KlUYp7O9Qvxf2YXHFYnpMC5CzPyjY51Ll1v68fdX4H099/gf6Z39oyTWovOeT1srmXbdlcwHho2rY5g0ONhlmSnopb87hkVlM3N7Bn+a/kUbffMph1WWBk21xBm9yveYrF/Cr7HGDPJBDzU0s+NZgqaZORbqqp9nF/FiNt1p+hYGs551o8zIzDrn+kgpTJfE1Su3l6eqZnw0Rnw+SZntMnq8yOWVORndOSzuNrvM+sg15MaUk6r9oUXmg+eGAOvoV/WiTu9hprR7IMqJxnWn3KXPCvqEEr40z149HvTgW1e5HN63sczEi+n9XLYEHi/ZF4GhfpQAGnd+GEWbMfdM7JQTfbSJveDzr9h84Xl6gsJizoChY6Y88yeyZOV3+YTak1EZntFPkwE5k77bwdfx7c6eCXsyHWaMPE6k7tjYAYnZUnyE2KJVaHSMI3up+xuz2n4j1fLN3+ejhvj+kpG6Ld+hrvJoS6X+PtbnLN5mxKL1sR7xdh6n5U8Wb62O55TcvZhFWkZNXmwYQ5gbmh5uzB7Q2R9hDmg0G4WAHLRY/seZUp/AAY3a2m9OSUyzKqctf5Ya0Aj+KkiLT+mOq4LnJFn//pA/kOWnxOtS12qKflT2B6UXIjCu8LK+yArfoR7z6Gtb44xm5dHy6rbx7A1SnexeK9Tth30X7dUDe+HtwO6x8OVlGtglNJXcRNeqhr7AXGOBLOww/ZQG2zAJ3ORAR8RAT6ATw4IJ0Hs09ScuEIr0oFtdkDdqChdBi7At9C6W2lZxXOpdSoTZHjMUrfBq7ffipO5YRcVWp8rYd9KIavucIThYhB6l8ScMNe88LvftEkGojEq/JuCNoBq8zLwo3uhd8x0ImMl1gVdi/8xKqwe+HvNa4kjpVQOFAqHGq+KViVPvjOQZ4NVpqfspN+ARlDjOYHpIf9NOEua8EumChaFhgEJQ+MiR+eWm4ZnZQD6tOXzGYM8Ps2Ld7SwtxOK9cGHd+xDmvC3noV07hFJM8csMg1LYmhh/xwqyCOFDCiLRWsRF/awe0B0gRJCPgabMw0yKX7yHfFOj6YBp4HwDz2w/WfMCk8AfRjf229MIX5+ggxuuzN8OLEAntVQG8cDXvHKgfWMg0ZJzmlgA/GYWogBn5hUCuF+8YQvKKt1JXGmAN3XuUMUBeBfuG4B73mu6yjluQW1oignmKMXPoh4AyMgYfHO54Jue92uPdM5G3g2LcKcNontRerDay/mrAS7wWGNUKtJwFnqefV6pUL1wWfc9czC85Z6MCtvK1UPqwHecUcBHnqX2OQdOxDv5ktaxtgf8BeW+E5JTzcYC0ExhqvOK43wL2JdU+Yymngeeb2RyWxqNp16DPsX4b+goXI0wZzEGZnQkqZwyGIhVfRgLFM1JWypbIvvo01OxoP3hiBtwVjIfQtjPC8wDmB/S42htr/J3n+IHev1kUsqayXI1fhi0dYw983pfd5p4vumerxZVngNx1/s9eHHz65ef/Hx4NUvV4Obt6c8/Y2gEtXZu1ReRg/VdQxL4tj+7suuat58Y78eonA4PUY+Zx+PXqk7bc30b8='),
			this.addDataEntry('', 48, 44.8, '', 'jVbLsqI6FP0aJ3fQFQl2t0ME9OQUAVHUgzNeHXkoloJAvv7uHTyvQde9A8tkP9da2QEm1Dz3q1t0PfE6zaoJtSfUvNV1M67OvZlV1UQjeTqh1kTTCPwm2vIv3qnykmt0yy7N/0nQxoRHVLXZaBkN92aonob7KbriMj9HAv4XWZo3UVxl5v2+aavsDq4f/4D9kd2aPIkqJ4qzal3f8yavL+CM66apzxBQoWMRJaW41e0lNeuqvoE/zf5EbdV8qWBUucDMpr6CNbpfswTJ/Mn7DGAvFBDj3UreLVgqaqIJNcattrw/xERb9GcgbK5fXO04LPT40LeJJHn0siGJVT8cmtJ0mFE+zB7JOXnwwui4OZfpOcnZy/F6fEvNmIo5y0nnFDvhBEbrbg3ibvXelaFwLda6lq+zfFEfD9UlevHnrPAHp/CJZzKRalWZrgTapk5hUzdngOk1d/UwuL8y0/id0M0sXu1E+lJ1xwBOZrXXU3NeJJTn6zwsspX9y/TLNqF+l1GXxNRoQm1+jyn7yeQ+dyXXw6KZv9c0tzOZWstfUPeRmNMi1vpHUtQFL5h0A1/3KDkzejp5XSmY1T2e/b+gWq821fHCv1jMoL9Hh1kVvr2+JOdlGR32bWouLh/r5b6N3jZyvX2dJtp+2NHFKdT267jay+OWiSxgqEDvFKVSJbNwz0AlQ1f7wEaFQVn02d980QEULe2vWrzCaaIOItT6E+g0ZxeXcJM9/jMG6sfa8QwYyXrLepb//saye8Srqj0elsOGvp6Oq6qKL/5XZcx5eTwc5UefoO/Ct03NVsdrvOqgx36ITVH42zJnK8RNCB/0mSttwSVv3WI3DQeduBKmRobAMenc3ABdQuLmOuVWKHiuay7+m2j3Kd+CLgHvGU6aLKdOYMO+FKruQCDGmI417N4zCU5ez7eqJgU/Uf7huScCp5C4Gm/49r0PkQ5OveqzmzmB3wKO0Q+TBD4J9aS31TsvCBu8BVwmgCUhzlafMotrTsE7fuAdYBMOzpmJuIQ+8kNMwK/seneAW2MlyHHKraqAWlBbcei44gC5ilMigdPwyYkBJ113rRL7D2OsGCAWNdFRG89iiId6wQlqoubAo0i0D1+RzLwVh7UgSldVYzdjlg1xhorjga1qwX6anUnDCx/qG5oTlC2XOxpKQ6i+pj64qAPwh3OAnhw59TwQkBuCHkyDmKlnQb6V4NxLiNO4dQKtkwHWA7dszAdNE+grdJgLqTBbNmKFe0Jg7Y/4rJICt96zjpAfasibS3zKYF3QAPBC/pQXAvWZPTHhGQ4eYAeNpBOM/PaFrc7bw/MCvVyVA3jVOcDs5OQZb7de4MsQ8tzCVnMJc9Axy8CZwfspIV/3xvNEH55zP/qNTvWzRr3V7Bb+ONvmRw3VB/l5weZnHIznBHupZvTMsf/zHuA8IGc2qPORAnvP3AL1LOk4Q3hX1F1roA/csWWBPZADxEpe7FAPyiXOsMoBvFznGvZjgIPD2XGFHfBhDelZfIw9qH+i7GMNxDJVHBGLilF1yFjH/6gDPs0zjWcvDja8I/xzhk3kIcQTM84uUTapNEcMwCHps/zz+bYe31DwZIK33/MVDi/PrP/rZ4AyPb8BVll9zprbACFdnjanMUL/PWadslycnlm6/uNpje6jRXzkfn5VwOL5YfG+/fyAUb5v3zf/Ag=='),
			this.addDataEntry('', 48, 48, '', 'jVbbcqM4EP0av+zDlozwTPxIgGClkAg2toPfuI3MzbhiMJev327AyaRqp3ar7BLdarVOnz5CLKhedtZHcD3zKk6KBTUXVP+oqnp6Kjs9KYqFQtJ4QY2FohD4L5SXP8wux1lyDT6SS/1/FijTgntQNMnkmRy3ui9mx+0cXPExLQMJ43MSp3UQFol+u22bIrnB1N9/gf+efNRpFBR2ECbFW3VL67S6wGRY1XVVQkCBE89BlMuPqrnEelVUHzAfJ7+Cpqh/y6AVqcSVdXUFb3C7JhEW8yvtEoD9PALRHl7y8GCqoA4WVJtM5eV2lwvluSuhYP1tI5RT/6yGx66JBpIGmy2JjOpu05jG/YryfnWPyujOM63l+nqIyyhlm9P19B7rIZVrlpLWzvbS9rRG7DQidmrrGLkUxr7hRp4y61wEx7iKDZJ++jbx9bTZVm879ohP31I/Syzzp77TJGAiybEr2Ga7iqz9ml22RbJx7z4VA8vUktHz2WnzV/siCN/UQ2ytW/so7qG17p2UL/0sGhyL/fy1m3O6eRNRt0uoICHVal9Z30LKfrCB9XzYE8eo16+pUH3v9sp07cmm0/6fmLwuPx1Pw6ft5k+hVTSn40u/pa/nk1UU4cWVp8/n7SEsC4J8xu+iiArR+kdReMrqECl7qD/vx9p1densmEwMtmYZ6+0M+NPB9kzkFfjEOfPbXHB01yw309+wvCJfUJf0le4cUQ58AS86u/9nDOQPlVMZKQcCeDqWPoEuHkzoXnv/lyp/i3jT19958brWf99WzDpdQ6uFPQ59qMvM3aEOEDchvFdVx+CSe6wRA1f9XiUiyxvhSWpnUStSrbMzk4IuKDd8yWEU2UHhGcMY1R80yVO1456sIX4QujbYmVRtyAcaXTLUWJZ3tmc2wjB7ZuAYgc0b7kUrZoxxED/G0Ye9M/zG8fKV3xPg2uwcXWtxjeOZnY1YBrcGTINjsBr277lxMOyMIV7gWl1BLTWeAz7kmE+BNYCFQ02a6rz4OLb8yNsRp2eqU61kxM5Tbd6TLCHnSpgcbN6JXl3B/hI46wTgFQZTmOHCGZLwd2k0mIhvhXsJ3DtVV9zLEQcRpezBXjrGObMznzg7rUUueIaYmAJnFXiOFOTZ8cQPz2MrWKdC3b2zw3UF456LnK9i6I/jxRXayFFSEojNKXBMoK7BMxjU43ewB9j7YWegf6+KC9a9b3kpO8TCh5cM+qkIeD9wHWt2Kdgq9BaxEzGYX6MO75PB76E2OKMu6gC4d+svjcglxzMCPYY8irMjHdNHzdSTZoCvQVN24zzUZGF/IgW4blEbfJBkyh1hvCo8Nueec+4QB/p87AvspyHPCupuij8c8fzyQTCRYp+KbNQcYGGGVs91NI4B/UGtgwZRa8Lw1TgDHaAuLD72BNYAn7IXD076BzfzqEgY90vQUQ+aaEceR0w+gb2BP7f+zh+f7ZcKtAhaYRTOGR01oiN3XAXsD16x9pGrcS9Yx2cbsMkvvkEr7/6jj9WUX8z99B/9VIArqJmRR61z7cMhM0Hbe0VsqtQe5nf40N4jerq8SbxR8fc8X7tw4SXdH6/u0TXf21ZSlUn90UNIm8b1eYpQn6ZV5ySV5/q7L7hNtvxc+fUdAA/zp8DD/PrkGOe+fZH8Aw=='),
			this.addDataEntry('', 48, 39.43, '', 'xVZNl6pGEP01brLIaQHzxiWCoz2PbkZBHdwh8JAv8Ywo0L8+txtnnOTkJTnZZMGhqOquj1u3mh7pVtUt3sPzkdVxUo70+Ui33uu6GaSqs5KyHGkki0e6PdI0gmekPf/EOlZWcg7fk1PzbzZow4ZbWF6TQTMoLk1f3hWXY3iWYlaFKd6zJM6a8FAm1uWyvpbJBaZff4H+lrw3WRSWTnhIytf6kjVZfYLxUDdNXWFBKQ2zMCrS9/p6iq26rN9hj5Mf4bVsvngwyyyVO5v6DG14OSeRLOZH1iVIe6YSMT+05EMjXYVNONLN4VN7vtzSkTbrKhRsvS65tu9nxmHXXSNBsnC5JpFd3xw91uN+orN+couq6MZys2XWVMRVlNHl/rx/i62Dnk5pRlon36SOb165Z/auZfasNwS3WUYXxzLcxXVsk4zl7MrEStBspoe7NQmVLs1esyBPFvNvlmemyIUku66ky/UkWmym9LQuk+XqFuhc0Ny4RvqqpctLGunrW2SN84PW3aK8TqMqzr7bRedYZsf8zYXac+F6xTe6JKlz4oR5M8icHHSzCbTp5aDT3+jy5RRkqeBWm3KfYU/Uf/cv6Q/PfHL0IY/P3Pyu2O/24vN7VTwdFuV1v3vu1/rLcb8oy8Nple4/5fX2UJVE4hm/8TIqeRvseOlrk22kbYBf0b96tOeW0TNf4pnK7871jDG3aJr48ynN6dVFHcDLYD6wyoyWiQKYlsWr9zIDHhXVj0e3LV6Qn4gX05Yu+CV44wJ2Edtm5oh/WjOHv2m1P/FS9cijt681Olp3PlTbY1TEfbBbn/e7CXlg0t72i20VPWI8RYtnElqzKtx1F/gfR1VbUzI/owaZM2c+u3Kf6uiP4eRzg5+C3sl5zTyj4zvYRGBQ20zVt2cQZrO7bHZOTlsuMbBXV/S4dzzIwIgJk0iZi+LK7dU46gnsK7leh77ndoE1kR4ofYp4tOOQub3RnJyBrwQ4017J81R38kDjC9YgvzEb4kFmLZP7bSrgk3ClMw0VKw8mjszRpnKdzjOp28j9E7UnZ2OVh0dkHprM1VX76YTJtXYKeUUQs4VN8DxAnnPogjHHHEkfrh0hr3nLVQ0msKNC+fML8Yi5FV98EuXTkvKxxjyOmR1rjg+8SIp1Zsu1Od4bQW3ZE+BsmS360qDmMctl/MLgvfmXa5TNI8Bs07nbQPlzdyr/CXJFnaxB3wwG7F0fmCIutwNdYqxqEAzYR+A7+pCbPXx+9FR37Rf4SyfSBmwNZQMvFIZV2rmWobk2n6EmYCrzo2PFGcw+tSmRfQNPxtx+yYHhBDOmcT+VPGq5PZdvgjMK/DBxLpioYaXxN8lDNuYVzijbJEPvVb+lvh1wjCYK0zfFDew1hlry1UT1QFP6DrFxBkkuUMyy0aF+2d9Wzjr3t5I/Av2VPeoVlwSVvscDP4GB7I2Md+c1+DPww1O9FM5HXH/VK76ISMWSHHR9uRbc+OQg8urvfMC+wW4aA4e3O2AIfpc5Qzw+YCwwC42aOf/+9kin8Cg+eCN9RBowbB1f9Q25wv8gD/P6FnR4a1y8wLcpfctZM1hmKl/3fg9rd+mwVvsv8y//Kab4Mv/ky/xrA4fu/alUf5CDPHMLiankyX2+VJ9FUpEOdgPnSuNKbIectL/N6RR85v8n7ogHd9KvZ1P/eTap/sW56p0NHuRzXfXGxxkgqOyHMZxx1AgtgvnB/037H86mZdBIzvI8Vlxhqp/zzpF1+8O8Y2bBNXDflnyct678t4ngHuvB06h/8BAzgXw3Sgb2DR/OjBS1Ce7vwTHkjv/DMMPy/EqBX0CS7PGfeh3uJLjP4L5zv7ThupR0P734KdX91rdI6ipp3nssabO4OQ4rjKdh1zHJ0uN9lz791dAHdXgZVOnn5sdFEsL9Lvnx+bizKtsfrrS/Aw=='),
			this.addDataEntry('', 38.4, 48, '', 'jVZbk6I6EP41vpyHLQTcHR8R0IlFcFTUgTduGwko1ohC8utPd5C5VO2csw8WSXe6++uvO21Ghn3qFm/x5UjrLK9Ghjsy7Le6bvrVqbPzqhrpWpGNDGek6xr8Rvr8G+1YabVL/Jafm78x0HuDe1zd8l7SC66NqB6C6zG+4LI4xQy+szwrmjipcvt63dyq/AqqH/+A/J6/NUUaV16c5NVLfS2aoj6DMqmbpj7BgQoVszgt2Vt9O2d2XdVvoM/y3/Gtaj55sKqCoWVTX0AaXy95isn8LrocYM8UEGuQaoMEXcVNPDKsfqvPr3c20mfdCRK2X559PRIzMzl0t1RqRfy80VKnvntGZmRiYlAxuaen9E651VJ7KrNTWpDn6BK9ZnZisCkptNbjO+YF1s3fWtLfmpNVwJjv7G7UYRNSzOroUJ3j5/WU8PXY45a52hKW6VWZLcCeU5CVk5VNANOy8M0wuC6JbT2lxmaSLHYse67aKIDKLPZmZk95atDipQh5vnB/2evylhrrNjd8LTGsJtSn18QgP4ncF76kZsib6eDT3k5k5sx/gd97ao95onf3lNecciL9YG2uDO1EjONx1ZaMOO39Ef8TqpfFporO9JPEDrprfJhU4evyOT3Ny/iwv2X27Py+nu9v8etGvmyX41Tfi50xO4b6/iWp9jICFvKAICsaMKhYyR3cu4bH1xO1D1xkGJhFnftFFx+A0dL9zMUSqok8sFDvjsDTlJx9jdrk/r9nwF+iRyfAqL1sSUeKpy9ZtvdkUd2iw1xsjOUxWlRVcl5/ZsaeltEhku9xgq4NXzc1WUSXZNFCjL1IbMbX27IgC8StTTxOWuiYzrfN8SpYcm9rCgq5QqdJWMtVEDaQq7ayIf8A8t6aBuVL1HUrB3U7fbWF8wGbgMz0+ZFTdZYBR1BTW+s87nY+2sF5uoU4Tiah23TlU1o6cdyb75S68u1EHHxOqLBalNOAdL0fq0O5x9PWP7Vgb7UgE+Cno1sL69EB7v57ogN+QYMSfK/NPpcdxAN/gIEGiGGnMAB23eNM94s+j1AAxu0Q3zVVfPEp/pkOuJnaF70uDAicLxktgBtlbzE6cIP+TxT4cgVwIOBewJpMfIFYGPLYwRq4nV89wEydUhAHv5YWikc9OBGAXfNRLh98caLqkgrkPIQ4rol5QG1MXK8OGGcnVrbVegHk4xBT8SJTrIXW11dx2mAPYI367+ZnErhqUkAtBl4hz7VBVW4EMYE+1WmBdVB9JFRORc+djxgQo1wjJwJiN4/vY7+sAZNU3Ant3bcXKN+D7cOGfdiqntqBXYr9NcRUGFbD/nxpqG1NsE/owQWZ1SnMUDOQIz6mevG95wB/Hwe4DTHfMdRDgzpBrX2I5Y5BP/b5GuqJE5SNfZ1+k+duwPzY7wnFySxVLf8yzx1T9wjmTI9N3SMDMOmUu/09+q+8nPRRV9ZRoe7czyCgLU55H3tl58K8o5I4kI+kH7YS80shXyb8xTdn4C5RDrkKs/NlpANf+C8DMwjPEQb9I2nx3v+Amwq4q1LhV3cAegl6j3LsvbLF2eBzqvoRevm2Csqu90V7X+Kzr1T4GF/6BHQtdebHRzzEKtQ5nBUBxTx01fOSaOs/+8N/S5jNZrtyjofe32b2J3/ENk3Kd3CviDHw8dUX5of/oBrOMiN2iK72r6oP8b+lpTumqX58DSX0EsYkVM6HuD+/zPsnz4A3gTTxmWPMHg8heILk3bePKSV6vKQWeX3KmzcBR9oia479CePph9nbHfOCHR925lMvi6/9nr3bfrzNYPF4ng3bj2eg0n15Jf4L'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 45.87, 48, '', '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'),
			this.addDataEntry('', 48, 43, '', 'jVZNk6JIEP01XvawgRTOjkcE2i7DKpoWtfHG1yAfSkeLAvXr9yXYPfZhYvdgWJVZmZX53kuiJsw6dcuP8P0o6iStJsyZMOujrptxdeqstKomupYnE2ZPdF3Db6I//cE7Hbzae/iRnpv/E6CPAbewuqajZTRcmr66Gy7H8J2W+SnM8L9Ik7wJoyq1LpfXa5Ve4Pr7L9hv6UeTx2G1DqO0eqkveZPXZzijumnqEw5U5FiEcZl91NdzYtVV/QF/kv4Kr1XzkMGs8owim/od1vDynsbUzK+8S1H2YijE/LRqnxZKFTbhhJnjVn+63LKJvuhOaNh6eZb6oV8Y0b67xkrLw+dXLbbr25olLOlnTPSzW3yKb6IwW2HNVXKKc/58eD+8JVbEsjnPtXZdbLO1b17lxtRkb8yEHWfSFlfEMJ4v6sO+OofP3pwXnloXvJU9zxK9KpNlRja2LkqyoaZVLo3Av6y4Zf6M2essWm6z5LlqDz6YWe6MxJoXMRP5Sx4U6dL5x/LKa8y8NmVSi5jZBPr8EjH+g6tdLpUwgqKZf+a0NjOV2E//IO8ttqZFpHe3uKgLUXAlfc9wmXbi7Hh02zLjdnu73/9Q1cvytTqcxYPF8rtLuJ9VwdvqOT49leF+d02sxflr/bS7hm+v6mWzmsb6rt+yxTHQdy9RtVOHDc9SnxMC/bqIB1RSm/YcKHlTaZHfIYSBLPmcb75wD0RL5xGLFdgkHLJA747Aac7PUhMWv/3nGeSP9MMJNWovG97x/Oe3LttbtKyuh/1T/8pWx8OyqqKz94iMNS8P+4P6usfv2uDttebLw3u0bHHHro+srPA2Zc6XVLemydzQZJFlwveu0vamQW/00udQzRZ4eLprGVOhnKsstlBIpgnd6aAUxm3n6vpxJiyzxTqDogyRm/CZSpyDzt0YnSh2BfywiU5awK/giENun7O1j3g7ntIeKp1FltZLy9TAgSFOosFdnegph2jEBjUiXtjD2pBqC7/HxEajOtV6QzWL0dbjHl/osOnSj5uhZtiEH9M5JfwMNq67G6on7ijWtTnlbYVa7UXh4KzZB8okm5LKG+peEyb+duwbdQ975anI5tqasFNZD+yQnxMmYwywAFYKWLSuL4+C6uwJD8LBpHMdtzCpKkCueJqetAY9G8Ajk5bBXHsl0D9NdA97K1kAHFGTLS/CLwlH1CFQz+sP3xcjP71prItAyaUgP/GGfk3EDTz0A2aKcL/3AZ6AF3CMCTMFLQA/h7DSRVEivuzjAdPtDHXPiAfEUS4l9bbB3BIvPbc95HW0pHBQB58CP2gimA3c2GU29O47qGW8G/cMviG+cAysNdcmHDKGNZPABHGzYNAi4nPwtCGtATf04PrE0xaYa6hlq8Pe4AywIR3Exic/n/+7wiEumNRFS9qjWlEfNKdB504/4pMxuaG9p9x9Sz7SI3P34MAPSCvQY0C94H9LfdNap7qlHRhDvp40s80GPUHbru0p6pe4Gvq2TUY8QxNTWTiN7Mc5oRrAMdmycWacqXzgSqp49sAVe+BKG7nKiCv1javNwFVPXLnbVrvP6KiPZ2iJZn0v2pEPTpwz1zKH/mVOOAh8H772pCWNtAT8ScOGO8wf4vyv+u4zB/xo3m0x/bQNeBQlfMFUDpwB112gkx6A7yMn5B85GWalxDfozskWnAwzOcy/ju8ExVDdLb5jOuaItK4B25m0B36gXWPq+lhD++BXoWdNqKoYuR9yQUvljLgXw324d0P/ux/fvr8/19DOQRn07GCL+8MET4K0++PjZjDdXzbLtD6lzUePI22eNMfxhPFzjDqmeXa8RxlstIWXcZ99Rf5+KWFxfyx9bn8/ygbftzfbvw=='),
			this.addDataEntry('', 48, 48, '', 'jVfRcqs2EP2avPShIwNubx4xEEcZJEKM48CbDVQG49gT44D09d2VhJM77Z12JhkhaVmdPXt2Ze7c4DguP7bnPTtVdXfnRndu8HE69ebpOAZ11905pKnu3PDOcQj83zkPv9id6V1y3n7U7/3/ecExL3xuu2ttVszCpZedXbjst2d8bI5bAeOirpp+u+vq4HJ5uXb1BbZ+/w3WP+uPvim3Xbzd1d3z6dL0zekdNnenvj8dwaDDjcW2PIiP0/W9Ck7d6QP2q/qv7bXrv3nwu0bgm/3pDKvby7kuMZi/mrEG2AsNxJ9WybSCrrb99s71zdR5uHyKO2cxHiHg4PmRO4VceLvNeC0VabaPL6QMT5+xW7mVnLtMzj/LY/nJWn9gwb2qjmVDH4tz8VYFO1fc04YMcbsWceZf+cqXSYD/VGyXr+fC2ZPnFdXzyukO1RLsW+rR1jtSd79PhoOg4aiqx+5SrBakflt0z6snUrztSexwVUoKOON3Tliw+JM+crJz/T537i87l/5BH5/e80YovhoEy9J5DCfzbH1O5OKeBnNVhZGo5UJVy/sh3vDP3fJeJs1CFg49sWAQSVheaEhHFhzANxHPGB0iyW7ofhTL12OpbvOn5+V43h1f9+Whkvnm5Vxs5oQuv55fN/Nz9cju6furKt6esnL50Bbr++vrG+9os5izljSsXV+Z8ucw98ycXXm4Jno/g7n0CFcpsCxGZC9ufZWsgNFNek8PUfPc5G29jP4MUsBjOBG5M+5LF89Frujnf9qAv51THEvnFTM00uYHMP3UcC/PLk9BNgBb3bXYPMgX92lfLLtu955+swCuDsWmULdzsnHI315OdFmcd8sB45e7QLTp6tDQJeImPaqEZRhrKXPl92zlzSFWxVXUwwhK88e4jUYmySxu0ytwIOMsgtF3aYhjSmJ4n2UHSUMYQ9+JsxS5U2uVA6f5DO2YWjs0FLBfqrjNR/QLZ82STHxhyKgXw1qp4Bn+mSpHGq6vPLAYHAZjOXDAxUMqAN+YZDCucJ4KHkCOMobrAwsLxRpP8jYVMMJ+btdza8db8EVYg75zHQvLIoUxABfocwRMgq88UkpisSCu1MP4je0a45wZPlKi4wceNB/AAw0ND3kWkRgrLJxGXzCMyfI08ZZLorEYXAR4Sm+44uwbDy7TueEhcgezlc7NjK+I5SkaIUas+mkc9JkrQtAOcgm+/YE3/q/s7L61JwzOiWSyAjvpScCGXWVEblhIf9JQfSQjbzwPMCPPkqmHPcwdsHcgttkUu465FeAfesUG8wqdrPFmJh9iTHSslIBOoNZSAmfDGLlsA/EF3ohc2HG48dkeSBIgdurxJeIRWquspcBPKXlAwMeaoB5YmyKHc476CZC39SxZQZ7bgzvlD7ToJVnUQxyKmzjnXNsC5zpXbA5coE8HOJM45/p8mGOOGtCnzonAs2a81WsqyV5ajUsxPANqIMV1NwmRZzE3eWKogWsSHsbS5EvqHGWlxgN1o/eMZpgCjic/M4aaX6ENnc4V9twF0+divuw48Qe1BBoWCereYTZW3/o2OKAvg86FsrwIy4vlPsV8SZOvErQEOW+FsBzrXGgtQy6MptcaE9QLjlCXKdrKBGumBT1gH8L3QWOgK+xLDoczwRbmB80t/y9tAU6mXv/YZRZ3VkJeI5JjLYFv0K/zTfOAMZ1hjIDRxdqGuwhtPC5vNjpG1D7E6LEN8pR6iCkBfQDGgeu8lLZHUsfEms/Lm14Q/9rij/SZv8Aj9VlywpVfdY/D94PveACHqXsn0TxgHzK2JrcR4hp5e8ARNBZN50BN5F+9aHXDJVlbtVATgL+cg1+sKayPQd+BN+wPC4vFnjlxf8A+jjhdpqq95Q/OEu6XDXIjxqk2dR/9R/z+T/Hn2O/UwWpNYxlBU+I7j6VCf6nSd4TJkeS6n4CfTWQxmLxablBfEO9aGG4e4E6gc+hxqF3LO9bJQfcgPvWgt3MfW03RcPHFFfiCNeSZQB/pdW/TudF9CXhZu1jvPNN6lnAX/cMGegDoAX3rmsX71/Y31AP05EBrurV+kGvrw7caMD4QN/QD7999+daGYp8jubz5mvjQ8Uz7wKObrOyda3oC9j3gOkf7ubmHwGYTYe0r0yfYrbfYGA3+xzMHfgfImYDcQ97XLpyP/UTXvcYdlsTUDZPoK8l0fmYsZNO9bO9jrFWB/XcGGsO+i78NMBZtl6A+AswZG3Vvz4Sje4M6OJa/yZ+9R3V+4V4juoa/fs8AtszHvqd/F0HdOCZXB6PhTHjGZj2/jaBlpm3TwdQPG7WW4R5F7Zjcw++go+hR96x9wpxajtEe9IZ3bah7OmBcm3eNXx2/OZtJe2fYuvDNXfZ2auLpN7IaPku3eH8W+I2Efwv7IQWfMPX4y48xvWS/xJb16Vj3HxJMhqbq98bC+2He2teN2Pc/r20vZi5ub3592cGD/bibpl8fkXrvp2/MvwE='),
			this.addDataEntry('', 37.33, 48, '', 'xVZLl6o4EP41bmZxDwLOtEsetqabgDb4YofAjUEQj4A8fv2thIjac+6Zu5sFJySVqtT31ZfHSDGyZn4NLkecR3E6UmYjxbjmedn/ZY0Rp+lIlmg0UsyRLEvwjeT331jH3Cpdgmt8Lv/EQe4dbkFaxf1IP1CUbSoGimNwYb80Cwi0ehzRMjiksVEUX1UaF2D68ReM3+JrScMgtYJDnC7zgpY0P4PxkJdlnsGElBn0IDyRa16dIyNP8yvYo/hnUKXlUwQtpYR5lvkFRoPiEocMzE/axJC2zhPR7qPSfYSFCspgpGh9V34vbmQk600GgI3lwpb9VlcP26YKO4kGiy8pNPObpURK1E4U3E5uYRbecKLV2Jh2URZStPAv/i4yDgqZIirVVrImlqdVtqt1tqvWODkR21xX2CQqonrub9NzsFhNUbIaW4mmOgYikZyeojn4J5iNtY6LIKcPaqt7r/hAhvYWKl+Tw3xNokVa+x5UZr5RI2OahAqmSzrpIlMjcat30XxaW1v7dphPW4fqrS+jHHfrApkzyXFrgpP1+NMryE9Xq0Jl1aBFQSD2LTTGyUFubmGSkzCL6KepgQ9RLENrsaddnFafIrO+iTyeslvOv1L/jJ9GDK8pgu0k3e8+FmH2fgq2myoy9PPw/76pgt1Xt3Q/xqG8adeKftzLm+Uh3XS+i0jsIcZEayWriU2hb/K+bCVojFnfm0F/XTlsrsn+UWUDE8DuxTclunphz1id3nqEenKYv3esroC8RvTtv2c1EPPmZ37n71jFZtTq1Awpx6NTnz6WxvTfOM3B/mbJ35lZLvQj1Jn4WVocINNo91F8Grb+CUhY5p6HJNDP2GHaadXaMY8JdlXZNkOCoRLAiIJdqXJMJCETUJthY3l9i0yttJJQtsGOmY68WYU70lquqmBzX0Ic1fYwzFk1mErCd8Z8aptKzd3X7jTZNU/cvm9Zfz9mscG/g3WH2I657oQvzJ0NudnJTAW1cb3D2jL2CBFrMwywzl4CbCpOVgRTVbK72bf2/e+Dp5UwZ7zvZhBvpcD69zmQL2ntBxei1WqG007WYEew7xgerHKcgGfI11Ul7KFS+DZP3AhfwHMiE27fYsEnxL5zOcQmY9z2vj2f99z2jcMxsn394IKtzTH0tXyp3/c2zuAM8cLK3uI798yv62vH1tdeajXwzuo51JKt/1J34F4S3HP9dHfdfG+fai/mM/xiDud+4HzgHhmcP9CGJvPac67uXHCuGD8Cp9AGz1V74tLndYfTBuzryf9S+zP+vc5T3GKqsbwnLAf4n/C9usN87gP3Ey4ZC96YRu66eNkTXCPxSWrZfoe7AvLYJIC34XMMDdYmgAVy7dYE7pPW8fi+aYEvE3dMIyfQEuTgMa1hdn7A/aFJvR+cI4Y65neQsu+wIc4UzuGs4RrtWO4YcELuHhI1ZLU8SQw/29sMG+AooU4NaFKsvy+/5YNsGfgbcpcg91N/1nSMy3XPj1hj1fIYcDdqleOFrB4sD+AU9WfK4wzcQlyuQYZRaFzwMuCAexNN7BnuBMct58tQVahlye5kpnt7d7EBF4sNbPAzje1HrivcSt90Jdo1Uf78HLzXutce8FY+9AB7dvdSAx7zsadxX2fgZNDGH2gnMFHN3wxbPOzX4W5wX87Z8n6+vtx9b5YCr55OZQ85RRdPPXhkxc1vn4t8SLwV53GexeW1hSk1jcpjP0P554ei9I7HmJKjcFTf+rGg6PtkcH48P+FHvEDv3cdLl9teHsK/AA=='),
			this.addDataEntry('', 43.73, 48, '', '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'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 44.57, 48, '', 'jVZLl6o4EP41bmYxBwHv7V4ioMYmsdHYNux43ZgA4hEQyK+fCmj3ncU9MwtPUqnXV19ViDPDLvv1LbqecZVmxcxwZ4Z9q6pm2pW9nRXFTNd4OjOcma5r8Jvpqz9o56NWu0a37NL8Hwd9crhHRZtNJ9NB3QzF46A+R1e15WXEYF1mKW+iuMjsut63RVaD6u+/4Pye3RqeRIUXxVnxXtW84dUFlHHVNFUJBoVSLKMkZ7eqvaR2VVQ30KfZr6gtmt8iWAVnyrOprnAa1dcsUcX84n0GsJcjEOt5qj1PVKioiWaGNYn6qr6zmb7sSyjYft8QPRyWZnzq20RqPNrstcSp7p6RGumwMPCwuCdlcsfC6rD9KtMy4WgTXsPP1I4N9oq41nniyDxqteRgDYSb3c7xGRaMo/W5iE5plToaH+VNeg03++r9gJ52/J0HIlu7P+2DxQCLlp36Am32i2R9fEWXfZFt/HtgEImE2SaG36FNzRJjf0/suYj1/p6IiiVlyt+cvPdsq8f0WCPHlbtD/hNtNOZdiIYPS9gTLTasJtBf69hAP9Bmewk4k8TuGKEYfJLhjdbs18F68YwJxxc22ufhKZRfsp+/xOuiDU+rYW9sz+G6KOKLz8Kv/f4jLgtN8Zl+kiIpSBecSEH1xUeiH4GHfFAc4ME0dhSBzJ7yQGig9D3I0hO+QWzEMsd9RcJtd04wR3x5DYFP/4Cgh1tOzIDWW4VoYmUp4vVKqswjW/zlv616iHkPy1CGn77Kwz1plsg4n3ddvn23X+votCiCz+0mKVd5dPpoU+dL/+Lp+yK84N+yvG+W53TNWFgWdewoBrb1m02WbwfEFHJKkeYJtyO2ZaoVly7IuYEcv93RhGHb6qCDDB/MjjhIrXMs98ITaKH2xMlb4mATbFro9gAsyR103hOsT4ULazKQE+5GvfB772BqWEA8DuyKYwMxYIW4A8QXrAE/8DdNyKV05hQL6figQQfcAR8e8pGBzAaiK7yuqfBiyp54m2e8Kf7Kgbww4ZBXHBVeHeQ5clTtfo+5Nt4W8OmJXJ0wdcHG1wJpKX+5cxKQYaIpagm1BlULcRLTo7jF0h+o4kBg4O+4ILnCc2TEVvEthacH+2HU2WMe0FuLEa+Tf/NLj2PO0e5ybTyaQ+yEkcE0sQwRhhuN5YcO3BiYkgriA679j5gCNskGj/oK44hZTSoeNODDN6BOk9C8mfqiAXfuPLY1wBrMQTYgX0dKDPoAuNVUXdKjqlfB2CsiseJgMXK77hrIrxN6VLjm2AkF2Aw7xYPI5dhbyYCLxHjs1bz0hG71kVOJ5oCPTVjMHr5CcIss6CM2ydhna0FKNTNHOXJM8YMfa5q/qeYK+gTxUt2jkEu6cqqZdeONlb7Cq6kZgjlrYM46LIAjysaew61VsQaoHXInMOcI+sDkyJNMn7yewU8n3IK+Bfp3H5UtAs6YQXQMMf0FYNXGHonxbgww4xAXDU/bVEwYIwfshWsEw4MX21J90yCv4uFRH/RMnQlXG/fUB27QnKheSjVXWKq+wgzKBGYVOIW68WK8v2qGaS4zju7PL+P79ELA1wBen8cTCo9X1v/xGR6PHm/wOqvKrLkNYNLxtDlPFqb59+Ln5HjOODs/HM2X6SyqJ5l9OX8/67B5vOxP8fsfxKj71x+MfwA='),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 48, 48, '', 'jVZbk6o4EP41vuzDVkzwnPERgdHMIUEFdfCN24nhIpaCXH79dkDnUrWndqvGCt3p7nz99ZeBCTGKdnkNLidWxkk+IdaEGNeyrManojWSPJ9gJOMJMScYI/hN8OsfdqfDLroE1+Rc/Z8EPCbcg7xORs/ouFVd/nDcTsFFPcoiELAuklhWQZgnxu22rfPkBlt//wX+e3KtZBTkdhAm+bq8yUqWZ9gMy6oqCwjI1cYiiDJxLetzbJR5eYX9OPkd1Hn1pYKeS6Eyq/IC3uB2SSLVzG/ZJgB7MQDRn1709KhSQRVMiD6a+PV2FxO8aAto2FivOD52Cy08tHXUIxmstigyy7tNYhJ3M8K62T0qojtL9YYZ8z4uIklXx8vxPTZCIuZUosZOd8L29Jq7OuKu1jhmJri5q5mZSbo85cEhLmMTyQ/fKr4cV9ty7dJnvFxLP02W1k/D1QVgQsmhzelqO4uWuzk9b/Nktbn7hPc01eqIbBq6uomIbO+RMU1D3N6jtBRREctfJpvaht5yM7tRk065m/2kKyTsM0fMXcAzRyHRKx/PbyGhP+jq7exL0UCOxrtGsNRqfnk38dvVX2wy4vjA5rXZ8XDsP+xN9hIu8/p4eO225O10XOZ5eN6I48fzdh8WOVK8xu88j3Le+Aeee3i2j/AOeMi6gQNDmzouFYlJ5zSlnZ0CjwbYnqX4BV7VnvVtLzhs5jSz5Bcsb+uxN+Hj9hQRBrxBzwa9/2cM1A/xsYjwHgGelsoX0Meb5Jrv3d4Mr7n/S5dfItbG/DsvXtv479uSLo+XcNnAGfsuNES6cZUeFG6EWKdpjskE82jNe6b5nYZ4mtXcE8ROo4ZLvbVTi4A+CDN9wWDl6R6zlKoYze91waTWMk9UEN9zQ+/tVGg21AOtTqnSWpq1tmfV3LQ6aqo1ApvVzItmoA0VB/FDHHnarunXjpfN/A4B11brGHqjchzPam2Fpd9UgKl3TFrB+R0z96adUoUXuNZm0Eul7gPrM1UPQw5gYdCTrjmvvlobdmDNgNOztLFXNGBnUn+ciaZQc8YtBjZreafN4HwBnLUc8HKTYmpu4C4J+G1I1FsK30ydxdXZUpsxL1M4EC9EB/bUMU+pnfrIcfVGccFShYliuLPAc4QVz47Hf3genUGeBn13jqvycsq8jeJ8FsN8HC8ula04SgoEsRkBjhH01XsmhX78Fs4Ae9e7pvLvNH5Wfe8aVohWYWH9awrzxHBHBTNUzxsCtgazVdgR763P1YD/K73fQW8dcK90ANxvqk+NiClTdwRmDHWw46KWGoNmqlEzwFevY3fYh56Waj4RBq4bpQ3WCzTWjlS8xj36qP2o6SocyuerucB5uuIZK92N8fuDur+s55RLNac8HTQHWKipV48+aseE+SitgwaV1rjpa3EKOlC6WLJhJpADfIqOPznpntw8Vixg3U1BRx1oohl4HDD5CM4G/jbVd/7Yw34tQYugFUrgnpFBI4bijmmA/cmr6n3gajgL8tjDBmzik2/Qyrv/nGM51uePefrPeWLgCnqm6Nnro/d+n1qg7R3mq1LavVZQcjo5fXOPyPG8FurNqv4Wj9cvvPiS9o+v8MH1eH8vk7JIqmsHIY2Mq9MYob2MWadEilP13RfcRlt8ZH5+D8DD45PgaX5+egx7375M/gE='),
			this.addDataEntry('', 48, 48, '', 'nVbZlqJIEP0aX+ZhDrJ0Vz0iUJoWmZSKZcEbW6ds4ilQlq/viARte0739Jx58JBLZMSNGzfSnClG2S0/g/ORVnFSzBRrphifVdWMo7IzkqKYyVIazxRzJssS/Gbyy29252JXOgefyan5Lwfk8cA1KC7JuDIu1E1fTAv1MTjjMC0DDt9FEqdNEBaJUdfbS5HUsPX3X7B+TT6bNAoKOwiT4q2q0yatTrAZVk1TlWBQ4MYiiHL+WV1OsVEV1Sfsx8m34FI0Dx70IuV4sqnOsBrU5yTCZL6lXQKwFwKIfluVbivoKmiCmaKPU/mlvvKZvOhKSNh4WzHZ7xdqeOgu0SClwWorRWZ1tZVYiXtNob12jcroSjO9pcbzEJdRSlb+2f+IjVDhzySVWjvbc9vVL2yn96xXNcfNOc14SpbHIjjEVWxKqZiv4rO/2lZvO3KzS99SL0uW1ldjp3PAIiWHriCrrRYt98/ktC2S1ebqKWwgmXqJlE1LVjWPlO01MuZZKHfXKKt4VMbpq0nntqF3zMxrYpI52+VfyUri9olJdLeAMZNCRW88+bkOFfKFrNYnL+UtnFFZ3wJeq311a/5tpz/Zyojjjs3tcv/gD/f5Jn8Kl8XFP7z0W2V99JdFEZ423L+Pt+9hWUjIZ/zBiqhgrXdghStr75G8Bx7yXnCwUwdqIi9czGmvSszd4H4H88HONgozCE9M65lk5EJNqpF0cfaBz82OQA3XKVM9t14jopGVRRYuXwaMLNhKn/5s1YHPq1/6g/+xgThWag9qSZTj0Wnz9ZvxXAcHrfA+1quofMmDw/slNu/7T7a8LfwTfYjytloc4yXnflnUoYkMrOtXgy1ed4Qjctclip3pMt1JkJHXeb3aOy690CzHjAfHUGXI9MJMqtqwRj88ZKqn5vZId8BQqndgJxNT5xQqbgOLjrm5OC5XvB58ZnvZzoiG/lmmTz4lOKNLeJ4OR8JSdU5dltlizsEP2A58DnNQUNSAXctwDTB4rgVfj0+xWxEXsQ9cBnvNMeODIypZZOiHDh7EtyTWY/xcmuILfKHJ8Zxku+I7oG/Ai74hx5tvXdiO2I4VRRs3koEnCXjBnAEr7USMFONHAmdSSg1N1YG5ER+/fmW7OfrXQszF3WjQqRJTPODEU+jB6uGrQbcgTvQL8a3GzngPGMB/Dt2v/9IG8GqA4eKYpN9BThC/+0eMjhmqyswC8Hto1yW51FGoLRsAnwv1MnNAokO8TQt4O7ghYBz1zlhPGOcq1p25XiPq2QtdNCOf+ljPdKxRYE58/oGjURfC5zTfq4ATNYCczyPUj7sBfUaD0M+oQZXJGNcC3qweawlYoa5EjJm5x7HGVmhD56gdx41gvB8Ac+sceAOahpyE3jSssy00RVBvEuYndJnt8Tuw4eVLCHVzTF0loGu4mbRf5tU/5mVh33RU9BHWAG9A0GS2h31LETrDWxn07TzoDLQFOe27saco9JSF+n3QguhHiHPXaIe+H3rvjiEwJMBBVSrfa9TCvuKYWD/Au7v14B/7Shr9TjEFNnLvd2Lc9THQAx37fTfeIaLfbz2NPXzLYXVmDuqx/5c7J7N+1LsHPAbyx5tJQzL4vPNBs4KCZsHHnjuoH9Q76JP9vzuqe7yjxHhpTTxP98O9HnuJCo3qox83Qt8tG5Bj2mM/UJdrQleCIwocWROWie+7L6qy6V56zyLQG/TPQz/iPTj1ozTmDrzsW8DNtTuP7qQX1G36y/srQ12Juw04Fpy7G3nqbdz/8tN/FP73yv6g4hNLWUyPMHj+JN1vH3JiaXrFLZOqTJrPHkzaNG6Oo4X6NJ46Jik/Nj+vBfU45/eTP16FMJgehrfpjweo2Pvpffod'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 38.4, 48, '', 'jVZbl6I4EP41vuzDHgScbR8R0I5DoFXQljduE4kongaF5NdvVdC+nDO9Ow8ek6pU1VdfVYqMDPvUL96Sy4HWeVGNDHdk2G913Q6rU28XVTXStTIfGc5I1zX4jfT5N9qx0mqX5K04t39ioA8Gt6S6FoNkEDStqO6C5pBccFmeEgb/syIv2yStCrtp1teqaED1918gvxVvbZkllZekRfVSN2Vb1mdQpnXb1ic4UKFilmRH9lZfz7ldV/Ub6PPiV3Kt2k8erKpkaNnWF5AmzaXIMJlfZV8A7JkCYj2k2kOCrpI2GRnWsNXnzY2N9Fl/goTtl2dfj8XMTHf9NZNamTyvtcypb56RG7mYGFRMbtkpu1FuddSeyvyUleQ5vsSvuZ0abEpKrfN4xLzQuvobS/obcxKEjPlOdKUOm5ByVse76pw8r6aEr8Yet8xgQ1iuV8d8Afacguw4CWwCmJalb+7DZkls6ykz1pN0EbH8ueriECqz2Jq5PeWZQcuXciJzx2KFmMl8Me28nX9LF1MRlDMR66SmMmqI42rBpmOUR+OfYcN+baxrZqx68tww8H3L7DFP9f6W8Zplp7z86VhgwwzPtgQNrUsgZlPidLc7jk/oXhbrKj7TTxI77JtkN6n2r8vn7DQ/JrvtNbdn5/f1fHtNXtfyZbMcZ/pWRMbssNe3L2m1lTGwUYQE2dGAScVO4eDeNTy+mqh96CLTwDDq3C+6ZAfMHl3gZM+LhfuPvTouoapaalhsr/cH4GtKzr5GbXL73zPgL9XjE2DUXjakJ+XTlyw7YLm6xru5WBvLQ7yoqvS8+syMPT3Gu1i+xwn7bv+6rskivqSLDmJsRWozvtocS7JA3NrE46SDzul92xwH4ZJ7G1NQyBU6TsJaBuG+hVy1wIb8Q8h7YxqUL1HXBw7qIj3YwPmQTUBm+vzAqToLteRE+rbWe9ztfbSD83QDcZxcQtfpyqe0dOiVq+8cdeXbiTn4nFBhdSinIekHP1aPco9nnX/qwN7qQCbAT083FtajB9zD/4k+8EMvHcH3yhxyiSAe+AMMNEQMkcIA2HWPM90vhzz2AjBuHvFdU8UXn+Kf6QM3U/ty0O1DAuePjJbAjbK3GH1wg/5PFPhyBXAgfIlrMvEFYmHIYw9r4HbeeICZOkdBHPy3tL2414MTAdg1H+Xyzhcnqi6ZQM73EMc1MQ+ojYnrYIdxIhHYVueFkI9DTMWLzLAW2lBfxWmLPYA1Gv7XP9LQVRMDavHgFfJcGVTlRhAT6DOdllgH1UdC5VQO3PmIATHKFXIiIHZ7/7/vlzVgkoo7ob379kLl+2F7t2EftqqnIrDLsL8eMRWG4LE/X1pqWxPsE7pzQWb1CjPUDOSIj6lefO85wD/EAW73mO8Y6qFBnaDWPsRyx6Af+3wF9cRJysa+Tr/JM3pgvu+3hOKElqqWf5hnxNQ9gjkzYFP3yABMOuXucI/+Ky8nu9eV9VSoO/cjDGmH097HXolcmHdUEgfykfTDVmJ+GeTLhL/45gzcJcohV2H2vox14Au/NjCD8Bxh0D+Slu/9D7ipgLsqFX51B6CXoPcox947djgbfE5VP0IvX4Pw2A++6OBLfPaVCR/jS5+ArqPO/HCPh1iFOoezIqSYh656XhJt9Xt/+NWE2Wx2gXPYDf7Ws9/5I7ZpwrcM7hUxHnx89YX54ZdUw1lmJA7R1f5V9SF+WzoaMU314+teQi9hTELl/BH3x5d5/+QZ8DaQJj53jNn9QQRPkaL/9lGlRPcX1aKoT0X7JuBIV+btYThhPP1tDnaHomSHu535NMiSZtizd9uPNxos7s+0x/bjOah0X16L/wI='),
			this.addDataEntry('', 44.57, 48, '', 'jVZLl6I4FP41bmYxBwG7q5YIqLFILDSWBTteHcNDPAJC8uvnBrSqZ9FnZuFJ7vvLd2+IM8OuhvUtup5xnWblzHBnhn2r63baVYOdleVM13g6M5yZrmvwm+mrP1jno1W7Rrfs0v6fAH0KuEdll02aSdG0onwomnN0VVteRQzWZZbyNorLzG6afVdmDZj+/gv09+zW8iQqvSjOyve64S2vL2CM67atK3AolWEZJQW71d0lteuyvoE9zX5FXdn+lsEqOVORbX0FbdRcs0Qd5hcfMoC9HIFYT6321KhUURvNDGsS9VVzZzN9OVRwYPt9Q/RQLM34NHSJ1Hi02WuJU989IzVSsTCwWNyTKrnj3Oqx/SrTKuFoE17Dz9SODfaKuNZ7+ZF51OrIwRKEm/3O8RnOGUfrcxmd0jp1ND7Km/Qabvb1+wE9/fg7D/Js7f60DxYDLFp2Gkq02S+S9fEVXfZltvHvgUEkys0uMfwebRqWGPt7Ys/zWB/uSV6zpEr5m4Pnnm0NxCka5KA5ORQ/0UZj3oVo+LCEPdFiw2oD/bWJDfQDbbaXgLMeYkwiesDr9m+0Yb8O1otnTDi+sNGhCE+h/JL94iVel114Wom9sT2H67KMLz4Lv/b7j7gqNcVn+knKpCR9cCIl1RcfiX4EHgqhOMDCNHYUgcyesiA0UPYBZOnlvkFsxDLHfUW52+2cYI748hoCn/4BQQ+3nJgBbbYK0cTKMo/XK6kqj2zxl//2GiDnPaxCGX76qg73pFkh43ze9cX23X5totOiDD63m6RaFdHpo0udL/uLp+/L8IJ/q/K+WZ7TNWNhVTaxoxjYNm82Wb4dEFPIKUWaB2wTYF6tuHJBLgzk+N2OJgzbVo8cl+GD2RMHqXWO5T73crRQe+hwRxxsgk+H6VEAS3IHnfdyNqS5C2siyAn3oz33B+9gatBdhjmwmx9byAEr5BWQP2ctxEG8aUItZTOnXEjHBw064Ap8eMhHBjITRFd4XVPhxZQ98bbPfFP+lQN1YcKhbn5UeHWQ5zCZEOsPmGvjbYGYgcjVCVMXfHwtkJaKlzsnAbkYPIo6Qi2hzkKcxPQo7rD0BVUc5Bj4Oy5IofAcGbFVfkvhGcBfjDZ7rAN2azHidYpvfulxrDn6Xa6tRwvInTAiTBPLEGG40Vh+6MCNgSmpIT/g2v+IKWCTTHjUVxhHzGpSsdCAD9+Ac5qEFu3UFw24c+exrQHWYA6yAfV6UmGwB8Ctps4lPap6FYy9IhIrDhYjt+u+hfo6oUeFa46dMAcfsVM85IUceysZcJEYj72al4HQrT5yKtEc8LEJiznAVwhukQV9xCYZ+2wtSKVm5ihHjil+8GNN8zeduYY+Qb5U9yjUkq6czsz68cZKX+HV1AzBnLUwZz3OgSPKxp7DrVW5BJwdaicw5wj6wOTIk0yfvJ4hTifcgr4F+ncflS8CzphBdAw5/QVg1cYe5ePdEDDjkBeJp2+aTxgjB/xz1wjEgxfbUn3ToK7i4XE+6JnS5a427qkP3MDXU/VSqrnCUvUVZlAmMKvAKZwbL8b7q2aYFjLj6P78Mr5PLwR8DeD1eTyh8Hhlwx+f4VH1eIPXWV1l7U2AS8/T9jx5mObfi59T4Dnj7PwINF8mXdRMMvsK/n7WYfN42Z/i9z+I0favPxj/AA=='),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 34.29, 48, '', 'jVZdd6M4DP01edmHPQScmfaRAE3cYqcEaApvBBgHAyGnQPj49StBmunsOTO7DzlYsiRfXUmOF5pR9puP6HJiVZIWC81aaMZHVTXzquyNtCgWqpIlC81cqKoCv4X69Jvd5bSrXKKP9Nz8Hwd1drhGRZvOmllRN0NxU9Sn6ILLrIwEfNdpkjXRsUiNut63RVrD1t9/gf6afjRZHBV2dEyL16rOmqw6w+axapqqBIMCN9ZRnIuPqj0nRlVUH7CfpD+itmi+RNCLTKBnU11AG9WXNMZkfmR9CrDXExD9U6t8ajBU1EQLTZ9F9am+ioW67ktI2HjdcjUc1uR46Nt4VLJou1dis7raWqIlw0pjw+oal/GVSb1jxuOYlHFGt+ElfE+MoyYeaaZ0tvSF7ektd/WBGaRjni+YFBndnIrokFSJqWSTvE0u4XZfvbr00y57zQKZbqzvhqsLwKKkh76g2/0q3viP9Lwv0q1zDTQ+UknaWHM6uq1FrO2vsbGUR7W/xrIScZlkLyZb2obeczOvqUmX3M2/060i7DNXmLuGNVeOmt4E6mN91Og3un0+B5nowIfwoQO8Vvfi1eKHqz/Y2ozjjs3r8/AQjnfZyR+Om6IND0/DXns+hZuiOJ4dEd7X+7djWSjIZ/LOi7jgXXDghaeu3mLVBx7yATjodwYZ2RiALIaJE5dozEQ570Eebelo3KAiNa1HKq2WjdaSZutLCHw6LoUaPmecBF79jIhmVtbyuHka8eSJrezhv616iHkNy3AM3x08J7NHUlLtdNp1+fOr8VhHh1URvD9v4/Ipjw5vbWLe9x9sdV+EZ/bllNft+pRshAjLoj6ayMBz/WLw9YtLBSL3PGtlS0uzXdIzLzxB1iPP9N6WTKWmLhhUkRpk4JK13PSVYCAd9/KWeXHLTKGB3RJ8OmBvyUauMum30J1jMOoCY/BMAVs62DIGhmE9Oootc8JVC86wFGoCk56D53SwbsBnxQeshCUwLpuw6MMnFsCp7MwAfHTNNaBCcsL8OzuIZ3V80P9wFmJifYBfSdEPcs1xT+GAl0vAjpyYTjPhXgbAF3R0ybpJLxGLtYS1ysd4zs8lK+CCYR4wAYihB3uI78zxzbjlnq+i/8502p0plHm9ryAv4NVXAw+xMuSgZwPihbxcHW2BS0b49tLYHgUbn8CEQW2s3jVFCxj6I+L2GIGbQNm9B9C5Qc8PFviJJdruTP8LB/G4Q75kDreLDjbOMMejX2xExzOiTjdJRvqdi3bW6gvXK+4JrLvmTr5FPfEPnDDzCfwwR7+PTOBJ6v2bBNwyH9NcgV7wOzi35wYhO+8kGWDfeT7E0IkNHACO5VQ3Se9yNPM3Qi8S5okZA9QJMCp8nDgbmAzwq0A/4j7EtLCOCvSsmHpcima2c27yiXKceFlIsLvFVW5xFex9Fc8HHPN3DEhaKsBxTKAukIelMqzxGPTIC3AOtx7psdZTfaUDPON5mDv2EPYX8IPy50xoDHtlYAPg8MStB8lqZybY48h7/y/eIZ9g4nLqX8+HuujzzI0WxNRXM/YY5lQnO18ssd6zLfaF3s39T7F/O+CimW451JnFn84EO7riG8SLN6Uy5zTNCeqC4eca8npn8x2A/HoB5jtiz+zMN4nzuUN/zwHsdJo5qJn6y2wi39iP85zfZ4GbQp3uLTP59svdiv8ZajgSfBpo69vjAf620/63D5BJdXt9bNKqTJuPAUy6LGlOs4VG/lYfZ8dTmonTzZE8zLqonmVxd/75oIHF7U3zKf58O017vzyt/gE='),
			this.addDataEntry('', 48, 48, '', 'jVfbkqq6Fv2afjkPp5DL3stHBJad3iY0LWrjGyIrgqhdLQrJ1+8xg70uVVrnVHVXzGXexpxjJjw5waGffuYfO37als2TEz05wefp1A6/Dn1QNs2TbVXbJyd8sm0L/0/29we7I7NrfeSf5bH9fwTsQeCaN5dyWBkWzq1qbgvnXf5BP6tDLjFOym3V5pumDM7nt0tTnrH13/9g/Vp+tlWRN7N8Uzavp3PVVqcjNjentj0dcKChjUle7OXn6XLcBqfm9In9bfkjvzTtbxr8ppIk2Z4+sJqfP8qCgvlR9SXcnhhH/K9V62uFVOVt/uT4w9T+fr7KJ3vSHxBw8Pos7LWauJtVfym0VeXPb1YRnq4zZ+tsledw5V2LQ3Hltd/xYKy3h6Jiz+uP9fs22DhyzCqrm9ULOUv9i5j7lpi7fRxKKcLFBTI2qyan9ao55s/JmNXJaFazTlRMbu1mv53K21rkxgGDTy+VcLP0/MIC/1vhvHmb6UJun5tunSIz06W7DcZ14fDqtfL0NvRlqSZ6Ox13s5W4bqZjFVcTtbbZievFmYWRFc87yevF6J/0LH/M/UvhJD17PkvovhbBqN7Y/bWoT7I4bKt/Qh8y0pkFvuKp/xGryZiF3fXmx2/evU7fmvWR/7YSpP05X3lN9v7yXBy+7/PV8rINJsefv78vL/n7m36dv4wKe6kWzmSX2cvXTbPU6zmTZcoICWtWFwadMqQ5U7Pa90RA+xEhDYRpL/pjL18B2X0ETLK6nEZ/B8n+BVm1No4vM7vfAa8xOwqLB+z6P89A/8ZeH+Cj9TpnPau+/RFlB5Sby3r1Xb05L7v1tGk2x+R3ZILxfr1a65920r7L3t9ObLr+2Ew72FiqTSDrZL6v2JT8thSv3A4V087qZchTfhGpP5rN3RFDBYlwr1jIaUSV+Dqe+96slh63I8TPbBYyVFkmeeB3DPWAtZGofE0VhfHuGa6oQrPWnD1wYJ6NuLKgP7H53O/53LVQP20cuC4PC8lTeRG178wwxqHvFDqC/v1IBGSHW7DT4yzJuvCtEw98G+wSKxbWz73KVZAf9gPf7M2AAWyOEs2hL3PBKthJPBo57AjNWmIcr6EjlC5hVR4sws1Fzfew7Ykpb+O56wktodci/7o43UuhTEytiSld9DjvwEafpXf8mVuIg9tcEY4RxXsnrqiFTC/ShEYtahFSXUKmF8Y+A34UV4R8ZhgLkoeehSeUb0OfgxwgTq7EoI84QFhSV+gQcw+fR1wnEjEodBXC0RMhkyJwLZFmEnZUnEYS8Wpe+ZbJfYA8KsxT3iKfPfJJ54FB0WJ0RBhJUbkO11Fr5MKM5mSH4nDhLzCO+nhukT/oIxZwXSgxt+Czj65oacO/uXWJ00zP0gg5S3oaEbOaAU+RIi6D66LlFEO6OyNXWijkqs68jMaQ2ViDHwXsSS0qssP722jjLMZCxQGdJY5wso21CF0Qa8rkaPTr98KLgeMsTWBDOiZXqd//mtO48Ci/wAH5YtLkD/FTDQ+c48gZ4tHcu18XPtWONrV5oFql/DHUiauoJrEHmYS4YInDPS4QtoueeEPcu8uFAW9tchGyr72bLsOVAWtga3QdOOVVDXlZKOQLdY0aSvfgCHG3wIg8AAfiMHS0qJsO8oRDD7+pDnqhM6ojRWe/5rf6JpvQLaEbHAwTqjvIoR7NfE8jahi1WXOS6W5+92KIbcQhA4w6rpdn+IY+T2cy4CXR44B3uKwNz1HfHBjGZJNqo5Y0jm6+WDHwEnrhUB+MCQfi0pzGxPSVOIyMPvhk5iYf4IfBh7hP8YFPhgcV4cUUcQx6DZe58SUhfNAHZWvymmYGD37jOfoHjTby1kJ2GIlPqFvCE7aH+fFDEP/R99BrGHp3poTNUZ8Z1ZccXgvoIWl06/XUvzLw3jJ9OE6Z4bdIC8LfIy7woR8OHDfc5qY3UG7RD+mF4ZpYa9RymkAm6eGrEz/TPRKhLhNlcqb32M/U3RoPyOeEsBnFK9R4Pdw/BuuA8saxX1Dvxd31srtTn53JqU6U6Q0mtgc9Py2cW9/oM8PtPeXFJqzAA3d4HVm3ewm4p8TRDPcEYZVo7BHXXKppTrimDLYK6kcezkBPhDsWfdTU255sWoab6M8xuI68usQD5Bl4wz/cP+iT9++EgLhPWGQ2J+7XCfnvGQ4G1EfNHYl97j6QN/1MoJ9hz3mACc74Bjfky75/huT3esDtpaYRfHGHuxP+pMQD1BvxXhP/v+amvnrcl725D8I96bHu+wob6KuoXdOrCdcZ1aIyth26d4kPFDunXq4jpzA9vehNnzd3iLk7KF/U58FhTvcKvTeofui3JaZ33wvtjfOk98F7ge6RyPQfnjboHQx3Lt2pmYW7dTS8awaOwK7p6bgnRzeO6Xj14J1i+hn5+fidIqgOyb/wraZcEU7AhGLsbph43GDmE06u0EttsCOf04R+o5bJRmE/eC/d9JOuwgX+FvGYcEU/HHpOyqg3AWdOc9yhphcpoZu/8NVxyFf9efb+MsLbfcwOS3u98q7raVLNtHtgzm4Xa3rbr4+vkr7n6G9y++jD51bZP/xwNEu3r8ZpeTqU7afCka7atrvhhPttkNqVldy1f67l52Euf0r++grFj9uH6Nf01wev2fvje/hf'),
			this.addDataEntry('', 37.71, 48, '', 'jVZbk6o4EP41vuzDVgxw5viI4GAsE3REHXhD4MQgijWCXH79dgedmVO1p3YfrNBJX7/+OmZkOOfW+4ivR16mWTEyZiPD+SjLavg6t05WFCNKVDoy3BGlBH4j+vqH07E+Jdf4I7tU/8eADgb3uKizYWfYuFVd8di4HeMrfqpzLGGdZqmq4kORObfbW11kNzj6+y/Yv2cflUriYhkfsmJV3lSlygscHsqqKs+gUODBNE5O8qOsL6lTFuUHnKfZr7guqm8e7EJJtKzKK+zGt2uWYDG/VJtB2lOdiP3cJc8ddBVX8ciwB5G+3u5yRKftGQp2VnNBo25qHvZtnfRExfM3krjlfWmkRtpZBu+se3JO7jy3G+5M+vScKDaPrtF76hwMOWGKNMt8K5eBXYuN3XFlEg6r7zAZe7trRI9ktWFaTmlxSj2wyVm3zNcty80zM45HvzlJ5rZ9Oi9u0WZKsvdpsdosSPR+JEsq+qRjkO/yIgh3pi9sLsjBsKuQTm4Hg/1g88UlVLIXm0byYG0tHbsTwfbqd9MJc6w+dWcy66Z96k2a5V7cD96k89W0iygrudNI301uzGUtd07gm8gVVomZBJ/Z/Yy83TnpP+XFymuvh/PumJzSLty/XaO9RZj39b3bW9d0zifssuuj90WQeK95tJ3Uu3dRMDW1eE4UIFqL4GSCbA4yA3lG9XkAcmcS0a8BbdkCgi2g3HMFqO7XE3aaqZUK88ybvThryGfARIa0PSYGxkWs2P0/dTZMHmh0TugOu9Qy9ROQXihhhsFt4QQNoFXU0f61ezMWx8grisNl/U0DsDpF+6j/jBO0Tfj+VjIvuh68BuvvDo7M15uTYh7mTVrRmdQPZtArqD9PzLCf1YAFZa4tgT0dd0+1gH4wl9fcnRHm4nkI9csGMDG5yyXfoN4WV8N35ZesTEtcQnOZc5PveTPY2nS5AVYCD7T/YFZ96ndmw4Mo4IGsfRd64TID2cyDBHI7tYO8Y6Bn8KDIl4H2N4Zcq0euFTAZ8iL9MrdbrgjkyRpR8Er7yddQizQhPtgw0GEmfw8r3zF73xU5d1B/Rn2dH0efrQiSRz1hpetRumbwJwlXtsZBDHEoTNr3uJTvQgpxW+HxBmJavrutobYO84b6LDgj/obA9CU9xOxFvkW/BvTEBC4iLpTnGlfgntQ1CjcK4LzxERPdj6T2Aw642ODLBp+hxTcEpx9myKRoB5j14MP0g5OOD7XXwOVWx99zyCUBe07RBuw7sdHx5RBvreP7c47YtIMOp76D69oEDCB/RqDGmvfheMDFHAtX42aIgMMcrY1nzOxMKo59CxLo77R8YL8HXMc8eHv0AHqGNbjgO2DYY+vZ62WgedglHdHY+w99WDX24il7HPFrgTcSfEKOszHg9uwr9NF+cmPokQO+cw5x7aesV365Qr6Qe273zF1DDosj8mHAgY31nDh2ozmtsT6ZgiI/Zj3stTzHPWZCXmDLkHsE8MA9S8xRj4+xX8BdA3nJe9yzrQ3Mm+hnVtgR6O/a0hzHGJrDW4p4wFwO89gnbZpLWGUb9raEHKCWNfxb6B49coXVeax72cIMWQIYN8yL3TAHZqqfYd7w74BcTSo9t8ABuB8w37FQzxpDnH39DTk1wn39cdgQmPM18HiIwc/IK8TMHvibY/8SnS9wF3olu4EnJ7xnQZd1upYA7ws8Qz8ng9NZh5zW/NG9tPEeqX7X0fPdPnj37Lv2qWftMx5wqg/NLyxx3pgBXBv8INaAaRg8Yim4GzcYD2sg3/0hzpWefeRCv62GGtlvMf/dj/09Vpepr/+F1fCPDjc6vBYeTx54bGTtH59NeuvxZvKy8pxVHx2oNCqtjoOG8fL3y8PwmCl5fBiaP4e9+DbI8tP46xkGH4+X2FP8evHps98ehP8A'),
			this.addDataEntry('', 48, 32.57, '', 'jVXLlqM4DP2abGbRxwHSXVkSyMMp7BSBVAp2vMoYTMgJEB5fPzKk0l2LPjMLDtKVLF1Lsj1TjaLb3oJrSso4ETN1PVONW1nWk1R0RiLETEE8nqnmTFEQfDNl8xfrfLSia3BLLvX/WaBMC+6BaJIJmYCq7sUDqNLgKkVeBAz+qyTmdRCKxKiqYyOSCkw//gH8ntxqHgXCCsJEvJUVr3l5AWNY1nVZgIOQhlUQ5exWNpfYKEV5A3ucfAaNqP+IoAvO5Mq6vAIaVNckkpv55F0CtFcjEf0LRV+IDBXUwUzVJ1XZVHc2U1ZdARs23nZU8fuVFp67JhoQD3ZHFJnl3VJjNe4XKukX96iI7iTTW2Ish7iION75V/8jNkKVLTFHrZWdmOXqDXX0/mDo3cHQFGoyjrepCM5xGZuIE5c1NLM1zFdqcD6iQGIZ42/cy5Lt+pfh6Ay4oOTcCbw7LqLtaYkvR5Hs7Lun0gFnWhOpdot3FYvU4z0y5lmodPcoK1lUxPzVJHMLclMzr7CJ59TJf+EdYtaFIuKsQKYoVPXaU5ZVqOKfeLe/eJy1sEajfctItm5f3Yp9OvqLpU48ntzcLvfP/vDU7fwl3IrGP2/6o7pP/a0Q4cVm/lM+voeFQLKe8QcVkaCtd6bCVRbvkXKC+uX9m4N7wjXgK3Um9Y46WkdMLO2dtFvZGtEes8RcL3GGG2KSBdTv6kPtbAdDD/ecap5b7SWjqSqrLNxuBpl5rBZ/+W+vDmLe/cIf/A8b8qy5NWgFVtP00Ob7N2NZBeeF8D72u6jY5MH5vYnNp/3FUo7Cv5A/srztVmm8ZcwvRBWasgL76tWgq1cHM8ncdbFiZWROHF3uWKPuJrOySKFcb7G5bohrL8CukV7vZAUOzuP/QepvuIG+29fThHk9asiANWzq4O+1hINu5p0FuUY5iwZ79Mk7yKeCz5wCTiWfXhsgRi0nmrjxAHHbgwM2yAu5YbpRczD3wBd3EoepAa72YowLOa2M9ZBnIFmKobstVUgLeksHyV2eDPBzwU9i7gmwtUJ3nrTN6Vn6TPnGWDANE5eJH3E9BNjiYB7PZIoLsj35umvgpc+tLNeogWBybIWcyPDk5p4QHn2JrMMcmyeQT5LrPDDX0A+8AK5QR72Hvox9OJgn2QcEfYF4pw7+0j4cHDjdrgc1OSlTPonbKtRO8mGwb0SzjUKA09iPQWdgb4nclxkBJzb1BGo39htiJjlCU0+hB+PtkZbjjTHow3sG1Ye60cFTgC8i5romsjYmk/8eTsVDTzHM00Bd6I/stYkZGWcEtwT6epj8pD97+P/8dj7kuVf8QZPXu7p6PABw9SbdXx+REXq8INukLJL61oNLy+M6nTy0l2lVmnCWPlapyo/FrwkOqgliz8W/HyUQHu/Sl/r7/Rtt357HfwE='),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 48, 39.43, '', 'xVZNl6pGEP01brLIaT7MG5cIjPY8uh0FdXCHwEMQxDOiQP/63G6ccZKTl+RkkwWHoqq7Pm7danpk2FU3e4/OB1YnaTky3JFhv9d1M0hVZ6dlOdJJnowMZ6TrBM9If/6JVVNWco7e01Pzbzbow4ZbVF7TQTMoLk1f3hWXQ3SWYl5FGd7TNMmbaF+m9uWyupbpBaZff4H+lr43eRyVXrRPy9f6kjd5fYJxXzdNXWFBKQ3TKD5m7/X1lNh1Wb/DnqQ/omvZfPFglXkmdzb1Gdrock5jWcyPvEuR9lQlYn1oyYdGuoqaaGRYw6f+fLllI33aVSjYfp1zfddPzf22u8aC5NF8RWKnvnlGYiT92GD9+BZX8Y0VVsvsiUiqOKfz3Xn3lth7I5vQnLResc68wLpy3+oXttWz3hTcYTmdHcpom9SJQ3JWsCsTS0HzqRFtVyRSuix/zcMinbnfbN/KkAtJt11J56txPFtP6GlVpvPlLTS4oIV5jY1lS+eXLDZWt9jWir3e3eKizuIqyb87TPNsq+PO8UIdqnH/+I3OSeadOGH+FDIne8NqQn1y2Rv0Nzp/OYV51mKPyfs2Y4Xbfg8u2Q/fevKMIY/P3ILuuNvuxOf38vi0n5XX3fa5Xxkvh92sLPenZbb7lFebfVUSiWfyxsu45G245WWgjzexvgZ+x/7Vpz23zZ4FEs9MfncL39S4TbM0cCe0oNeF40q8TBYAq9xsmTgC0/L46r9MgUdFjcNh0R5fkJ9IZpOWzvglfOMCdpE4Vu6Jf1rjwt+k2p14qXrk09vXGj29O++rzSE+Jn24XZ132zF5YNLedrNNFT9iPMWzZxLZ0yradhf41+KqrSlxz6hB5sxZwK48oAZ1XNMrXJOfwt4reM18s+Nb2ERoUsfK1LdvEuawu2x1XkFbLjFwllcWrHvPhwyMmLCIlLk4Xrmz1OKewL6U6w3oe/ABa2IjVPoM8WjHIXNnrXsFA18JcKa9kt3M8IpQ5zPWID+NDfEgs5bJ/Q4V8Em40lmmilWEY0/m6FC5zuC51K3l/rHaU4CXMg+fyDx0metC7adjJtc6GeQlQcwWNsGLEHm60IUaxxxJHwsnRl5uy1UNFrCjQvkLjuIRcyO++CTKpy3lQ4151JiT6F4AvEiGdVbLdRfvtaCO7Alwtq0WfWlQs4ZZQPwj5sL6yzXK5hNgtu4Wm1D5W2xV/mPkijpZg76ZDNgvAmCKuNwJDYmxqkEwYB+D7+hDYfXw+dFTY+G8wF82ljZgayobeKEwrLJuYZv6wuFT1ARMZX5UU5zB7GPuiewbeKJx56UAhmPMmM6DTPKo5Y4r3wRnFPhh4VywUMNS52+Sh0zjFc4oxyJD71W/pb4dcIzHCtM3xQ3sNYdaiuVY9UBX+g6xOxZILuAMss0O9cv+tnLWebCR/BHor+xRr7gkqPStDfwEBrI3Mt6d1+DPwA9f9VJ4H3GDZa/4ImIVS3JwEci14MYnB5FXf+cD9g12yxw4vNkCQ/C7LBji8QFjgVlo1MwF97dPOoXH8YM30kesA8PWC1TfkCv8D/Iwr29hh7fOxQt8W9K3nDWT5Zbyde/3sHabDWv1/zL/8p9iiS/zT77Mvz5w6N6fSvUHOcgz9ygxlTy5z5fqs0gr0sFu4lxpFhLbISf9b3M6hZ/5/4k74sGd7OvZ1H+eTap/SaF654AHhWuo3gQ4AwSV/TCHM46akU0wP1bH9P/hbJqHjeQsLxLFFab66XaerDsY5h0zC66B+47ko9su5L9NhPdYD57G/YOHmAnku1YysG/4cGZkqE3wYAeOIXf8H4YZludXBvxCkuaP/9TrcCfBfQb3nfulDdeltPvpxU+p7re+WVpXafPeY0mbJ81hWGE+DbsOaZ4d7ruMya+mMaijy6DKPjc/LpIQ7nfJj8/HnVXZ/nCl/R0='),
			this.addDataEntry('', 48, 44.8, '', 'jVZLt6I4EP41bmbRJwLOtEsELuY2AVHUCzteHXkoHgWB/PqpCt7Xos/MwmNSz6++qoTMVOM82Lf4emJNltcz1Zqpxq1p2ml1Hoy8rmcKKbKZas4UhcBvprz8QTuXWnKNb/ml/T8OyuTwiOsunyST4N6O9VNwP8VXXBbnmMP/Ks+KNk7q3Ljft12d30H14y+QP/JbW6Rx7cRJXm+ae9EWzQWUSdO2zRkMalSs4rTit6a7ZEZTNzfQZ/nvuKvbLxH0uuDo2TZXkMb3a55iMb+LIQfYKwlEf5eSdwmGitt4purTVnm5P/hMWQ1nKNjYrF0lGldachy6VJAiXm9JajYPR83UbFyobFw80nP6YKXeM2MpsnNa0HV0jd4yI1H5khakd8o9dwK9c3c6cXfa4IqQuybtXNPXaLFqomN9idf+kpb+6JQ+8QzKM6WuMpujbO6UluoWFDC9Fq4WBvdXaug/U3W7SOw9z9Z1HwXQGfugZcayTFVWbIqFyEyd5+NKZPayd47uI7GXo1esxkihDRP7OzUt4u16zsr9/Fdw5793epeq/kDXdw6xH6kxLxNleKRlw9NzVvwydfDhqmPoIwv0qzeultTsH08cX9Bt7G0dXdgXiREM9/i4qMO313V6fqni46HLjNXlY/1y6OK3rdjsXuepchj36uoUKodNUh9EtKM8DygyMThlJdnJTdxTYEvX5D6wkGlgGHXWN118BGYrCzgJy9y2/jH86hW6ShJV56EynICvJb24hBn08Z82ED9RojNgJJsdHWjx81uVPbBcd9HxZdyqr6fIruvk4n9lxlhW0TESH3mCoQ/ftg21o2ti95DjMCYGL/1dVVAbcRPCRm3hCoszwToXehWOGnEFTI8Ioca0dwsdeAmJW2gqM0POCk1x8d9Aua+yHfASsIHixIlq7gQW7Csu444EbPT5FMMaPIPgBA5sJ2OqoCdSPz73hOM0EldhLdu95yHCwemXefYLJ/A7wDHpYQpBJyCe8HZa7wVhi6eBiRSwpMTZaXNqMsUpWc+OrAds3CmpcA3ExbWpPsQE9VX94I5weswUa5wzsy4hFsSWNfRM1gC+sqZUQE3jZ00UatI016ww/zjZ8hFskRMNufFMinhULzhBTOQc6ihT5UNXpgvPZrDmRPIqY+wXcI7ATpd2LLBkLNjP8zNpWelDfF1xgqqDM6eGQucyr6GNLvIA9UMfICfDmgYWcPANgQ+qgM3cM8HfTHHuBdgpzDwB1+kI65GZFvoDpynk5RrMhZCY4VyDDZwTAmt/wmdWKtQ2eGYE/qGCdTOBtw3GBQ4AL/jPWcmRn8UTE/Zw9AA7cCScYKrvUFqy3x72C/hypQ/glX2A2SnI097qvMAXIfi5pSXnEuagp3AvMdkTXYC/5k39RB32eZj0ei/zmRPfcnZLf5pt4yOGzIP1ecH27ySY+gR7IWf0zDD/8xzgPGDNdJT9ERxzL9wS+azUaYbwrMiz1kIeOGMvJebAGsBWwD2JfKhM4AxLH8DLNKZgPgo4GPSOSeyAD2MIz2ST7VH+EymfYiCWuawRsUgbGYdMcfyPOKBTPEN/5mIgwzPCPmfYwDo4f2LG2SVSJiTniAFqSIe8+LzfNtOXCm4m+Ao+P+XwEc2HPz4HpOj5FrDz5py3txFM+iJrT5OF9nPyOuUFPz29NO3HUxrfJwn/8P18XcDi+cB4334+ZKTu2zvnXw=='),
			this.addDataEntry('', 48, 48, '', 'jVZbs6I4EP41vuzDVuSyMz4icDixSFDBC7whMAiiWIoC+fXbnXgu8zC1W6XVSXen++uvk5CJbp8H75Zej6zNi2aiuxPdvrVtp0bnwS6aZqKRKp/ozkTTCPwn2tsfrFNpJdf0Vly6/7NAUwueafMolEYp7t3YvBT3Y3rFYXVOS5DzIq+69NAU9v2+fjTFHUx//wX6Z3Hrqixt/PRQNMv2XnVVewHjoe269gwODRrmaXYqb+3jkttt097Anhe/0kfTfYtgNVWJK7v2Ctr0fi0yLOZXNRQAey6BWB9a8qHBUGmXTnRLTbW3+7OcaPPhDAXby3euJePcOOyGRyZIlb6vSea0T1/P9Xw0dTaaz+ycPVlt9cyeifycVfQ9uSb73D7o5YxWpPfrTelH1oOH1hjY+Kdl6m2viXYky5DKea41p9wD/5oatDbOVD8eg/5UUmcQ+XtzT8I5KfbzZhkuSLI/El/jIhsp4PQvnDB7/oO+c3LQrS7WZveDTv+h74tLXJWCh33JopXpQ2Yeba7BOJ9R2xS545bFOBe5N+v9HX8evNkYVPMx0WjL7L4MnOxOHTow+wSxSbnE6hBJ9InuZ+Jtz5n4nC+W3nA9nLfH7JSP8W59TXYmod7XeLszr/k7m9HLViT7RZR5b3WymT22e97Qam6ymlSs3jyYsEyYG2rOHtzZEGmPYD4ahIsVsFwOyJ5fWyIIgdHdakZPbrWs4rrw3B/2CvAoTspYG46ZjnmRK/r8Tx+Id9CSc6ZtsUMDrX4C04uKG3F0X9hRD2w1j2T3Nq71xTHxmuZwWX3zAK5OyS4Rn3mioY/365Z6yfXg9Vj/eLDLehWeKuohbjJAXVM/NKaxcB9BxEbqWCXodCZi4CMm1NkADy5I98Gck5RcuMKvM0Ed9oAdaCgdrl2Bb6n0jtKzGudSatBX5HiKMnCA608/tU7FhFh1Znzlwz6U49dc4YkjxCD1Lwm4bWvwo+9+sRmPROJVcTcE7YBVxmXRRvej7xioKddLrAq7H31gVdj96PcaVxLHSigcKBUONd+UrM4efOcizwarrA/ZS7+QTGGNFoRkgP1kco91YBdMlB0LDYKSh4YZRKeO20Yv5Yj67CXzOQP8gUPLT2ljbLeTuUHHd6zHmrC3fs00bhPJMwcsMqctMQwQH24VxJEBRrRlglXoS3u4PUBaIAkBX4NNmQax9AD5rlnPR8vA8wCYp0G0/hMmhSeEfuyvnR9lMF8fYY0uezO+OLHBXpfQG1fD3rHahVyWIddJTuFuwJ5GmYEY+IVBrdSEOILXtJO6yphy4M6v3RHqItAvHA+g1wKP9dSW3EKOGOopp8hlEAHO0IC76njHMyH33Q73noW8jRz7VgNO56T2Yr2B/CuTVXgvMKwRaj0JOEsDr1evWJgXfM493GdwziIXbuVtreJhPcgrxiDI0/Aag6TTAPrNHFnbCPsD9toKzymBuxRrITDWeM0x38jECus2mYpp4Hnmzlstsajadegz7F+G/oJFyNMGYxDm5EJKGcMliIXX8YhrmWhqZctkXwIHa3Y1Hn5iBN4WjEXQtyjG8wLnBPa72Bhq/5/k+YPYg8qLWDJZL0euohePkCPYt5X/caeL/pnpyWVZ4jcdf/PXhx8+ucXwx8eDVL1eDl7RnovuNoJLX+XdUXkYP9WqY1GVx+53XXpX8/Jz5ddLBAavx8jH9OvRI22/vYn+BQ=='),
			this.addDataEntry('', 48, 48, '', 'jVZbk6o4EP41vuzDVuRyzvERgWEyRYKOqANvCJwIolgjCOTXb3fAmTlVO7VbpZWk0/31vclMt8+9955cj6zO8mqmuzPdfq/rZtydezuvqplGimymOzNNI/CfaU/f3M7VLbkm7/ml+T8C2ihwT6o2Hykj4dYM1US4HZMrbotzImBd5lnRJIcqt2+317bKb3D1919Av+fvTZEmlZ8c8mpV34qmqC9weaibpj4DQ4UXyyQ9ife6vWR2XdXvcJ/lv5O2ar4gWFUhULKpr0BNbtc8RWd+F30OZi+VIdaDSh4UhEqaZKZb41F7ut3FTFv2Z3DYXj1zLR6WxmHft6kkRfL8SlKnvvt6pmeDqbPBvKfn9M5Kq2P2QmbntKDP8TV+y+yDLha0IJ1fboUfWi3fWENg45+KxNtdY+1IVhuqzplWnTIP+Etq0NI4U/14DLqToE4vs+fqFm+WJH9bVqvNC4nfjsTXuEwHCnb6F06YvfxJnzk56FYTaYvbQac/6PPLJSqE5JtOsHBt+qCZh9trMCwX1DZl5rgiH5Yy8xadv+f3g7cYgmI5xBqtmd2JwElv1KE9s0+ATcQKvUNLwg/rfsXe7pzKj/PLyuuvh/PumJ6yIdq/XuO9Saj3ud/tzWv2zBb0spPx20uYek9lvF20uzde0WJpspIUrNy2TFomnI3xzFrubIm6D+E8GITLNURZ9Bg9v7RksIGI7tcLenKLVRGVuef+tNdgzxgTEWn9MdVRL8aK3v+TB/AOWnxOtR1mqKfFL4j0S8GNKLy92GEH0araeP80vOovx9irqsNl/YUDYnWK97H80BP2XfT2WlMvvh68Dv0fDrYo15tTQT20m/R8YwxQIT3413PJj2xj6NRxWz5YHXUswWzSstDV/I2hBR5rwG+Db4BWKtrAQqStQR5oMkXanMujhFXyksIdNRnw8zA1FE1GyE8ChUuJwp10RIhRsgFoHXME8mnchr10YR8Zfun2/PLQ99C91QP7gYu6HnqZzgtly/c+AWZWZiWzoUucFHLqahAPIwgpnE8DykBdGBO951ATTEbDpAewT+jzPMXacAT6Iz/s3Lu9X6Zi1I06UfeEtzFIsEcsqo9xipQ+2OuBsx73IfLGmh9mP8LQBdwt+LQrAc8EOcQDWirBR5QXYB+BfkN9XTCuOsSn5ZIJFStHjDSQhZiSwFH0bqIP6qxWsBkwmbPF1WAb1GN1MEEIxB1yDxiDBb5FEF9cLZMrW9YG+zzPVY40F/Ok6NM6xn9DvvJpEAvwLe0n3Dm38R58U7juHOrjqw1ylKfGqJ8CLoGciC6ASQd576AWla2Ap+R4ofBGzAKxtvNRlwuYRNkKuiabkFdgTXVQIw3YDTE7YT1poHe092G/B3m2IbaANa0P/3S0kw/TSr6NQzv13jySVjPlFmuM+GPuNFUzzgnOW6gLV+Uca4NLd65qWkK/AC98CUzqwOpYhh9iDYn5VkZYn4bCkBbUIdSow8D2rcnd72wa7cE+zs8EaCfUMY+gJxjMbqiJDnimPsKYrXXws+WlBf3yrzzqTtnspDr6CfoNNS9KkMc6d1I1B5hDMQYwZ7HWXYPbas6M/b5R8wX7RYN6R5rJ3lT/S8g/9F4KezHyhdE0S1JznCVr5JtDr3Q8pBMf9nMsVS+i3UCbsLH/epTnjvKvU3kq1FzAOSRGG3eQC6r6DWZPO9YixgL52BSP0WeQ6dilLvzHN0t291SPLyuBbxb8LaeHDTwp8v7bx5EiTS8jL6/PefM+AEtXZM1x5DB+jVLHvBDH5k9achvP4kPy86UFm+mx9Th+PurU3R9vvn8A'),
			this.addDataEntry('', 38, 48, '', 'rVZdk6o4EP01vuzDFgLunXlEQI1D4qjMOPDG1418iSUgH7/+dic4M7tVt3YftkoLku6cnD59QmWmmWW/vgXXM63ipJhp9kwzb1XVyLeyN5OimKlKGs80a6aqCvxn6uo30bmIKtfgllya/7JAlQvuQdEmckZO1M1QTBP1Objia1oGHJ7LJE6bICwSs64PbZHUEPrzD5i/J7cmjYLCCcKkeK3qtEmrCwTDqmmqEhIKDCyDKOe3qr3EZlVUN4jHyc+gLZpvCEaRclzZVFeYDeprEmExP9M+AdpLQcR4zCqPGYQKmmCmGXKoruo7n6nLvoSCzdcNU/1hqYenvo1GJQ02ByWyqrujxVo8LDQ6LO5RGd1pZnTUfB7jMkrJxr/6H7EZavyZpErnZG/ccY2WHY1xZ+oKHSPOLJ6S9bkITnEVW0oqxpv46m8O1euRPPLS19TLkrX9wzwaHLgoyakvyOawiNZvz+RyKJLN/u5pbCSZ3kbaviObmkfa4R6Z8yxU+3uUVTwq4/TFonPHNHpm5TWxyJwd8x9ko3DnwhR6XMI7U0LNaDz1uQ418hfZbC9eyjtYo7Oh4zSzuxe35j+PxpOjSR6f3Nw+90/++Dne50/humj902o4aNuzvy6K8LLn/uf74T0sCwX1jD9YERWs806scNXFe6S+gQ75gBqwo67uLNSTD5MmC5YRjPcwVp2M9nQgPLHsZ5KRdudylaTLqw967o8EerhNme659RYZSVWWWbhejbizUCt9+vesHjDvfumP/sce9rFTZ9RLop3Puy7fvprPdXBaFN7HdhOVqzw4vbex9Rl/ctRD4V/ot11eN8tzvObcL4s6tFCBbf1isuXLkXBk7roUKtuPbDAWTkbm3mjzadyjk+hR70EVfM6hky3N3lWa8ZaNvPdc0jKLcpqCewajI5YBeQrExDptZ60y5yichXm64yK2N2epAtgedFpXmeuPMA+4vIfcgbp5I9fajcgtaSP5AC5iZ2+qyLfyEfJhvTflr07UpTivuJaN3BfMNBR4qsBNc7II+HuCR2jZUKsx0iPOQ96aAjbWyVuodf6om2Zv0GXgDbpA9zXIGaE2yLEHOUaNwBWaN4BbRL3UNCQG5lp7oRvLKHLsKGgLWnU4lm7SByb1akGjuahrtEeJrYAmwMOEuOsNgDety4UW1OV6aCrAn/S7owJ88g61Qv0fWIAB/AzQAZ9vDezdA5bAxNqoJXCRn8CD9wUd+eMdat6rgD1pwhWJYw/shPVHC/QDG3PAw97bWKsCmI3gf5KY6AmJI/gD1h56Yuu7dTdiLTvTkL1aeT34AU5cQZmpDzvEg68Y+iKGrwHsp9MT7YiJp5Q3sm5cS3Q6+QI4CF9+85z2P3tO+afnWKpr1C2g70oP3LDnGFOFzrLnOMa66p3Ut2Hiy1Jk0gOil9rEUXDCOqhFBbedJT0hdUQvC0zpGeSTGar0FJxNF32K/ZZexniSK5Ou0KcM/O/mijdgb98e51T0ZXoHbc94rgbpbVsXGnzFasfNhR+JlQtdPIyjzlIv1OChD35NRU40oPZk/k1rjEmt8076fNzDPu+Z8J38a5N/VSo5NJ/8EAv7IXSbvJ5xOIWi76J3wldffZg8A/tdqOTy6R9P3wnOfo3a7lw4s9MTdNNxX/kEbg9PQL3k4ZX0gSF9Eo22PFuZvRB+zOAsiX2rry/52N0jzb+8cry74G85XXDgapH0v70kianphrROqjJpbgOkdGncnGWG9iRXnZOUn6dV+jQX1HLMP1d+3bjgZbp0PYZflzsR+9vd7xc='),
			this.addDataEntry('', 48, 38, '', 'jVbbkqM4DP2avOzDFtfdySMBkjiDTQgkaXjjNg6EhFQHAvjrVwJ6pru2pnarusu2ZB1JRxLxQjVv/eY9flxoneXVQrUXqvle1820u/VmXlULRSqyhWotFEWC/4Wy/o1WHrXSI37P783/MVAmg1dctfkkmQTPZqhmwfMSP3Bb3GIO6yrPiiZOqtx8Pg9tlT9B9ecfIH/l702RxpUTJ3m1r59FU9R3UCZ109Q3uFChYhWnV/5et/fMrKv6HfRZ/iNuq+YTglEVHC2b+gHS+PnIU0zmR9HnEPZqDMT4kEofEoSKm3ihGtNRWT9ffKGs+hskbO63TImGlZac+zYVUhFvD1Jq1S9HzdRs0FU66K/0lr5oaXTUXIrslhZkGz2it8xMVL4khdQ55ZE7gdEy35DYoOnUunIqeEuFJ5NiVUfn6h5vvSUpqeaUVGI+4ZlSXbMN2Jee6pTXzvUJxLQrmBYGzx0xjW+petCTzZFn26qLAqjM5qRl5rJMVVrsC11klsHzYSWyzbJzzuyVbJaDW6yGSCE1FccnsWzJ9TtOy6P8PXjyH77RpqrXk+2TA/YrNeUyUfpXWtY8vWXFd8sAG646pjHQwHi4w2pJrO41x/Epuv3mUEV3+kliBv0zPutV+Lbbprf1NT6f2sxc3X/u16c2fjuIvb+TU+U0HNXVJVRO+6Q6iQjYyAOC7AATfGQnt/BMhFN6MjNRbyPT7aSzv+jiMzB7tYGTsMw39t+md91BVaVENXio9Bfga0nuTKImef3nHcBPlOgGMUp7n/Sk+PYlyw5YrtrovB4O6u4SbaoquXufmTGX1+gciZ9+gr4L3w412USPZNOBj9OQmLz0/GtBNhi3BHFpg2vRBvLR3TPtoRt01zQ6YtGWlVCPMtSJdWypFfbEIrhKqZhWvDN2W6F1rPQ487WeBQeFlrR1A0MNg7SlhQEYhNMR026+3s1KJ7ChU1PAmlYnQMxwxrQbuIfrfF4TVmgqDarS8TWdjXdtGTFcX2ppcNSdgLRMcBn0Mg3YBSZiINYYB/g3OPWlAaYAuliCXI8S5DrGN90zMM4eMTBfJzgipnoqQ8C09VAYc/w2cHNt6KCpYA94hsJMSXZKW2a2/S88Yk32EJPkBtVfiS8JVhg6+FfYhgvX1ASz2PkjN2pibOFABwlzQZ8SFSGucI/O5+gzFwoLjlBDo5/yIjr1tYGWpIFVdaFurDyq6B9mswUMebLxgA+to5AL+IN+htxhwt23RzN/QcTIXWlrvuXBykVW2hJ+RahCO2Jqiot+giviQB8hL8exlhD3gD1FJ5+o72mZgh776UMPPhUugEeZlYcSzhobxj4BX57m/MJWXCvEGBXAFMA15HBFLG3sn4DII9YgfcTPKMhZgNwT+OrZGlPolCPmG9BmjDewQUYG6Am00yjOOMQ/+510IKMC957GUB8YAvQqExmuPdxH3I5O/Ye2Og12WMN5fkjvjvgEeg04H+sDeRbaWF/IEzGVsTaDpkEugHeU3Tecv7FOvRt4ME+hOu3XNYUz1iaE/oOv/sSX8KTRh2/MuaBuzAN8EJBRfcwB5wJnW6RyOmD80JsFziL6sHvoceQb6oF88Z4O2N9Q7wHnxhOAP53VunCEdiPq5eIK/E5H9z3H32b8W80/4PDTmfe/fQSMovkFsMnrW968D3ClK7LmMt3Qvk1Wl7zgl9lKnWXxczrzn5a/XhSwmR8VH8dfj5dR9+Vt8w8='),
			this.addDataEntry('', 48, 36, '', 'jVXJkqM4EP0aX+YwIbN0t48YKCwHEnZZXuDG1gIMxmHAIL5+UuCq6p6IjpkDIeX+8qWEFqpZDc4jvGekTtJyodoL1XzUdTvvqsFMy3KhoDxZqNZCURB8C+XtD9blZEX38JHe2v8ToMwBz7Ds0lkzK5pWlC9Fk4V3uc2rkMO6TpO8DaMyNZvmvSvTBkx//wX6Z/po8zgs3TBKy13d5G1e38AY1W1bV+BQSsM6jK/8UXe3xKzL+gH2JP0ZdmX7SwajzLmMbOs7aMPmnsaymZ/5kALs9QTE+NCiD41MFbbhQjVmUXlrnnyhrIcKGjZ3G6oEYq1F56GLR5SHm3cUW/XTVRM1EbpKhP6Mq/hJCqMn5mpMqjjHm+AeXBIzUvkK56h3iyN3mdHRgyE80xDkgHnonO6BkqHdAU9yopTXxAH/Amu40CqsZpnXXzm2hjHZlE1wWKP0si53hy0KLhlyFTrGAgNO90YRMdff8YaiSDVaX1k1kYq/4c325ud8pIeeE7bXXahM2fHuifUKm/qYWDZPxXpMnFXvnukzclbCy9ciUHBNzJ57VtxgCw/EvEJuxHeyO4mEfaL7ETinKh4/5e3OGe5RdcriayL88/s9OOsIO1/701m/JxuywrfTGFy2LHbeiuC46k4XWuJ8rZMC5aQgHRmxDrI2ySwGOV5OdgZyriHPsoFlPkj23MIYPcnoeb/CVzvf5X6ROvZ3cw94Zk64rwxZrMq6kiv8/E8fyBcpQRUrJzmhAec/gOltTjWfNVuT9cBW2QXnN/GubrPAKcvotv/FA7i6Budg/KzDht6/vNfYCe6R08v+RWTyYn+45tiRuJEgQhOedW3d4lSQgyaIRTiBmbkF7in0TNiVg09PLM6lnTLeeZa0857kxiD9iJBrrNEvGezXJVH9AXhb0jErIOfLhjpqGQPMuIPTq7jMluuILeDfMrTjiJFb7HXILYipLcFvhDjNO8zyAfzoaA++QB+1epe9ch0Ar2W3L7zt3A9loIc8tjrnRfJGDNAb9F2ewVcl7M2afXBH2R7Bvvdk36ADP5VMNY8a5AC7sZzscI5lb7KOvGlzHlvy+I0xAhxhaR+p9V6A/0iljwm1GR/l2aESR3FU3MLuvXOvu4UvABfIgK0CLorjEmyIyhrFFWQbfLicy+BdAA/DusRBx5kPV/bKSkKKvayLKKPFyw6YDFXyThjEH7SBTPMm8FeQOkMP5TryMa3Q4AGHtIDe2RF0vuoLTady9tP89mLiz4rRxIUF94DN66k4yrkqkYk0mL0C8wL8R9VzbJinLbC1h1pY5umxnBHwTyXfwIEvz8ToK9gy5MyWhEnM0OcByX4ReXHFpjPDdWzNtRLgDjjRiEJ6bE44f8P27zXNv+7gbv5rwu2BP/LrWYEfejr88WmaVK93yUnrKm0fAlz6PGmz2UP7MUdlac6zV5T6bdaFzSzzz8ivdw42r6fuQ/x6Uifbby/uPw=='),
			this.addDataEntry('', 42.86, 48, '', 'jVZLd6M6DP412dzFHAKk0y4JpIlT7JRAmsKO1zgYEnIKhMevv5Ih6cxizr2LHizJ+iR9klLPNPPcrb/C64mWSVrMtNVMM7/Ksh5P585Mi2KmKlky06yZqirwN1Nf/2KdS6tyDb/SS/1/HNTR4RYWTTpqRkVV98WkqE7hFY/ZOeTwXaZJVodRkZpVtW+KtALTj39Af0u/6iwOCzuM0uK9rLI6Ky9gjMq6Ls9woUDDMoxz/lU2l8Qsi/IL7En6K2yK+jcEo8g4etblFbRhdU1jLOZX1qWQ9lImYty1yl2DUGEdzjRjFNXX6sZn6rI7Q8Hm+4apQb/Uo2PXxIOShZu9ElvlzdYSLekXGu0Xt/gc36gwWmq+DMk5zsgmuAafiRlp/IVkSmuLA7c9o2Gu0TNX75nwORU8I+tTER6TMrGUTMqb5Bps9uW7S+73svfMF+l69dN0DQ65KOmxK8hmv4jXhxdy2Rfpxrn5GhuI0JtYc1qyqXis7W+xOReR2t1iUfL4nGRvFp3bptExK6+IRebMzX+SjcLtC1Oou4QzUyLNqH31pYo08kQ224uf8RZ8dNa3kO+qffMq/ss1nm1tzOORm9flwTEYHrKTP0frogmOr/1e256CdVFEF4cHj/P+IzoXCvKZfLIiLljrH1nhqYuPWD0AD3mPHNBe76hHQObf8uCjvQN5sIWjMZPw1Fq9ELFq2JB3JFteA+DTcQn0cJsx3feqLWY0srIU0fp1wMiSrez5v28h5i04B0Pw6WCczB70M9FOp12bb9/Nlyo8Lgr/c7uJz695ePxoEuthf7bVfRFc6G9R3jfLU7LmPDgXVWQhA9vqzWTLN5dwzNzziGKLlcpMQ7WFr7I1bZhldLbArukqtUjDPA7V+y3N9MXOcjg1jYZ6xsJ29ZZ6vIFp7PDMvAOc4yERK/BfzVmOX7og1qqhQ45+LZyhu4AhAGOgamQqHXWBaYtwBvjM+hA2TiNieY4K5zkVOeCuMJ4OOfTUy2vA7XeAh3YmDiAbsB0KdGWFucCdgkINgG301NQHOgQniKPBVkBO8ZxYBubTSX8rrmV9RwrfVbtzFYh3mIOtY8Kpx86DzvMV0KnMC46s1xdUbBFz2ElMrHPEJKauUW9VU1nHqWIYY+A1TNTc7/V+55Epzj135B9rG2PEva7AnYZakIOIJT9M7CvABPtBJVYiwAe5aNlAgUeiQ60D5KTQgUP/8h7sChu5GrkTTrdzR5kJo0+E0+wsX/MHg9siV3ZQH7MQGybbIr2NsQZfe8guYGPv8N7gaMgN/IpgjS30FvuhI/8Tb9i/hw7j2ciTRaf7hWp7DtTnaJ7lox24OzQ77zDAPChydjLwEb6eCMyXzCMLvgNVCNyHLYX+jbLtjfKHgLoFHTwLZw761aO/ofkY36KY78S7D9iYUzz10q8lvxaXtcE8949ZAj5whnAedrAHkueRhzsHuB987DOvpx3BOHJHmEcWI5acB9mHNId5N+H+QDn1YsDkgz/1TXIn8wNc7KMY+wF7oONsQS4LOSNWDPt4UJmcU+wt76f6xt11x3iSdxn3oMvczsjNYeypF9/3sR5nbJw94B/qj3WoGe76CyZ3woHZwlh5f+fsm0fgCGNYOfTGqMcc9XbnIe4B+i9rhTOH3YM9FMiT0+IuAt7Emfy9aR+zIjEgN3PafVmv3APc66c/fkfx/4MaDDo+A7Tl9FCAf9Fp99fHhlRNL411Wp7T+quHK22W1Kfxhq7+eH4aHU9pxk+To/486sJqlPnD+fvxAofp/XIXv99J0vbHM+pf'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 48, 48, '', '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'),
			this.addDataEntry('', 38, 48, '', 'rVZdk6o4EP01vuzDFgLunXlEQI1D4qjMOPDG1418iSUgH7/+dic4M7tVt3YftkoLku6cnD59QmWmmWW/vgXXM63ipJhp9kwzb1XVyLeyN5OimKlKGs80a6aqCvxn6uo30bmIKtfgllya/7JAlQvuQdEmckZO1M1QTBP1Objia1oGHJ7LJE6bICwSs64PbZHUEPrzD5i/J7cmjYLCCcKkeK3qtEmrCwTDqmmqEhIKDCyDKOe3qr3EZlVUN4jHyc+gLZpvCEaRclzZVFeYDeprEmExP9M+AdpLQcR4zCqPGYQKmmCmGXKoruo7n6nLvoSCzdcNU/1hqYenvo1GJQ02ByWyqrujxVo8LDQ6LO5RGd1pZnTUfB7jMkrJxr/6H7EZavyZpErnZG/ccY2WHY1xZ+oKHSPOLJ6S9bkITnEVW0oqxpv46m8O1euRPPLS19TLkrX9wzwaHLgoyakvyOawiNZvz+RyKJLN/u5pbCSZ3kbaviObmkfa4R6Z8yxU+3uUVTwq4/TFonPHNHpm5TWxyJwd8x9ko3DnwhR6XMI7U0LNaDz1uQ418hfZbC9eyjtYo7Oh4zSzuxe35j+PxpOjSR6f3Nw+90/++Dne50/humj902o4aNuzvy6K8LLn/uf74T0sCwX1jD9YERWs806scNXFe6S+gQ75gBqwo67uLNSTD5MmC5YRjPcwVp2M9nQgPLHsZ5KRdudylaTLqw967o8EerhNme659RYZSVWWWbhejbizUCt9+vesHjDvfumP/sce9rFTZ9RLop3Puy7fvprPdXBaFN7HdhOVqzw4vbex9Rl/ctRD4V/ot11eN8tzvObcL4s6tFCBbf1isuXLkXBk7roUKtuPbDAWTkbm3mjzadyjk+hR70EVfM6hky3N3lWa8ZaNvPdc0jKLcpqCewajI5YBeQrExDptZ60y5yichXm64yK2N2epAtgedFpXmeuPMA+4vIfcgbp5I9fajcgtaSP5AC5iZ2+qyLfyEfJhvTflr07UpTivuJaN3BfMNBR4qsBNc7II+HuCR2jZUKsx0iPOQ96aAjbWyVuodf6om2Zv0GXgDbpA9zXIGaE2yLEHOUaNwBWaN4BbRL3UNCQG5lp7oRvLKHLsKGgLWnU4lm7SByb1akGjuahrtEeJrYAmwMOEuOsNgDety4UW1OV6aCrAn/S7owJ88g61Qv0fWIAB/AzQAZ9vDezdA5bAxNqoJXCRn8CD9wUd+eMdat6rgD1pwhWJYw/shPVHC/QDG3PAw97bWKsCmI3gf5KY6AmJI/gD1h56Yuu7dTdiLTvTkL1aeT34AU5cQZmpDzvEg68Y+iKGrwHsp9MT7YiJp5Q3sm5cS3Q6+QI4CF9+85z2P3tO+afnWKpr1C2g70oP3LDnGFOFzrLnOMa66p3Ut2Hiy1Jk0gOil9rEUXDCOqhFBbedJT0hdUQvC0zpGeSTGar0FJxNF32K/ZZexniSK5Ou0KcM/O/mijdgb98e51T0ZXoHbc94rgbpbVsXGnzFasfNhR+JlQtdPIyjzlIv1OChD35NRU40oPZk/k1rjEmt8076fNzDPu+Z8J38a5N/VSo5NJ/8EAv7IXSbvJ5xOIWi76J3wldffZg8A/tdqOTy6R9P3wnOfo3a7lw4s9MTdNNxX/kEbg9PQL3k4ZX0gSF9Eo22PFuZvRB+zOAsiX2rry/52N0jzb+8cry74G85XXDgapH0v70kianphrROqjJpbgOkdGncnGWG9iRXnZOUn6dV+jQX1HLMP1d+3bjgZbp0PYZflzsR+9vd7xc='),
			this.addDataEntry('', 48, 43, '', 'jVbBlqI4FP0aN7OYg4A95RKBUmwTSkEt3CHQEUTxlCgkXz/3gVVtLfrMLOqYvJeX3HfvDZWBYZ/a6Ud8ObAqzcqB4Q4M+6Oq6n50au2sLAe6lqcDwxnouoa/gf76h+ywy2qX+CM71/+nQO8L7nF5y/pIH7jWsnwErof4QsP8FAv8TrI0r+N9mdnX6+pWZlek/v4L8Xv2UedJXC7ifVa+Vde8zqszkvuqrqsTFpSUmMTJUXxUt3NqV2X1gXya/YpvZf20g1Xmgirr6oJofL1kCTXzK28zwJ50QKzPqPYZoa3iOh4YVj/VX693MdAn7QkN228zru/kxNxv21uitDyerbTEqe4LIzVSOTKYHN2TU3JnhdUwe6zSU5J7s91l957ae0OMvVxrFsVaLELrxgNL49IcMScR3GE31BhePql22/Icz5Zjr1iqReE1XHoi1ctjOhUUMxbFkWLANM+5GYXXuWdbL4mxGu2na5HOymYXQpnpxkztcZEYLH/LRyp1LJHJiUqn42ax5ff9dCz9fCJ3ulcxtb56jqv5QSNYsR7+DK/iV2DdEmPZerOrwN73xB4We729J0UlklOa/3Qs1AhjYVuShdbFl5Ox5zT3B44ndG/TVbk7s6eIHbbXeDsqo/f5LDm9HuPt5pbak/PX+HVzi99X6i2YDxN9I9fG5BDpm7d9uVG7wBNZ6BETclEkHTuZQ3MPbC2H3Ka8S0yDYcq533LxFsweXXASFdnU/cdeHudQVdsbloj09gC+xt6Za8z27v+5Bvvv9d0JGLW3wGu9/OVblw1YLm+77atcGfPDblqW+/PymRl7fNxtd+rrnLBtovdV5U13l/20wRkbubdFsQyOuTcl3JrGc1PjhRAsXN64sxxG0pQ89OCeNfhY6r5tDplyb7xYwylCY7rbwjEG9L35YSKYbTUYCzjLZLmFnKXYOWr9wGxZsSmQR4y13AZ/hYc67B16xiJEvZMMaQ63jva2JrltadDAZCdW46yWSdqD1SwARtQzpxubXK2RXxos0AinWgSEmfUxiXNCpiOm8zCpO8yIsTChdYqFAjFP9wPCk7RU6zse7dswNd+ywsVaS0bKopjiatnhXhAn4brvG7i7uVqqveNpC+JOCQnusL9HnPQ14AJcKXDR+CE/MMIpiQ/iwaJ1rWfjxqoIeyXD7KTV6NkEH4LbpuE7c4b+6WZLxBtuROARmBx+ZeGReAQOBjyrH2HIen2kZS6KSPEpozzphn4t1HU6yI4zRbw/+oBO4As8JsSZghfAn0tc6aw4ov4ok47T9Qi4R6QD6mgvxfWmZoVHukjPWWJfV0sLFzi8IfiDJ6JRp41zFF3voQss/dk4p8t19YVrYqz5DvGAb0BgGhycoG4UdV5EfQ6dAvIaeEMPfkg6rcG5BixrHfEaa8AN+SAxP/X5/N0ULmlhcJ015D3CCnzwnAafu7LnRxg8oPlS+duGcuRHw99CgzAir8CPEfWC3zX1TWOdcHMnMrv9JHlmLTo/wdu+s1TUL2nV9e1YBukMTwx54dZc9veEMEBjion+zrhD/qQVV8noSSvjSSut10qQVuqbVkGnlSSt/HWjPe5o748ZvER3fcuaXg+PNDd8fH+pf54TDwzfh685eUkjL4F/8rDpd/cPdeEXvsedA3903x02/Ix1fBRH5KIh7zQDr5tIJz+A32dNKN9r0t2VI75BD03W0KS7k9391/GdoBrC3eA7puMekdfxf8cccafTB941h36IMbwPfRV61pgqi177bi946Tgi7Vl3Hs4N6Hfz49v392UB7+yUSc8PY/J4oOBpkLV/fOR0occLZ5pVp6z+kFjS5Gl96FeYL33VIcvF4VFlGn0svvZz8VX5+8WEwePR9Dn9/Tjrct/ebv8C'),
			this.addDataEntry('', 45.87, 48, '', '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'),
			this.addDataEntry('', 48, 43.73, '', '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'),
			this.addDataEntry('', 48, 46.29, '', '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')
		]);
	};

	Sidebar.prototype.addSAPEssentialsPalette = function(s, gn, sb)
	{
		var dt = 'sap btp service icons component groups essentials ';
		var st = 'shape=mxgraph.sap.icon;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;strokeWidth=1;strokeColor=#D5DADD;fillColor=#EDEFF0;gradientColor=#FCFCFC;gradientDirection=west;aspect=fixed;SAPIcon=';		

		this.addPaletteFunctions('sapComponent Groups', 'SAP / Essentials', false,
		[
			this.addDataEntry(dt + '3rd third party provider identity management', 50, 50, '3rd party identity provider / identity management', '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'),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 200, 70), 'strokeColor=#0070F2;shadow=0;strokeWidth=2;rounded=1;absoluteArcSize=1;arcSize=20;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('SAP On-Premise\nSolutions', new mxGeometry(0, 0.5, 28, 30), 'shape=image;editableCssRules=.*;part=1;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;aspect=fixed;imageAspect=0;image=data:image/svg+xml,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii0wLjUgLTAuNSAyNi4wODQgMjgiIGhlaWdodD0iMjgiIHdpZHRoPSIyNi4wODQiPiYjeGE7CSAgPHN0eWxlIHR5cGU9InRleHQvY3NzIj4uc3QwIHsgc3RvcC1jb2xvcjogcmdiKDM1LCAxNDksIDI1NSk7IH0gLnN0MSB7IHN0b3AtY29sb3I6IHJnYigwLCA4NywgMjEwKTsgfSA8L3N0eWxlPiYjeGE7CTxkZWZzPiYjeGE7CQk8bGluZWFyR3JhZGllbnQgZ3JhZGllbnRVbml0cz0idXNlclNwYWNlT25Vc2UiIHkyPSIyMy43OTIiIHgyPSIyMy4yNTYiIHkxPSIzLjQ3NCIgeDE9IjEuODY1IiBpZD0iQSI+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QwIi8+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QxIiBvZmZzZXQ9IjEiLz4mI3hhOwkJPC9saW5lYXJHcmFkaWVudD4mI3hhOwk8L2RlZnM+JiN4YTsJPHBhdGggZmlsbD0idXJsKCNBKSIgZD0iTTI0LjEwNCA4LjEwMmE0Ljk3IDQuOTcgMCAwIDEgMS4wNDIgMS41MzRjLjI5MS41NDkuNDM4IDEuMTUyLjQzOCAxLjgxdjExLjcyNWMwIDEuMjQxLS40MjEgMi4yNjUtMS4yNjIgMy4wNjgtLjgzOC44NDItMS44OCAxLjI2MS0zLjEyMSAxLjI2MUgzLjgyN2E0LjE4IDQuMTggMCAwIDEtMy4wNjgtMS4yNjFDLS4wODEgMjUuNDM2LS41IDI0LjQxMi0uNSAyMy4xNzFWMTEuNDQ0YzAtMS4zODcuNDkxLTIuNTAyIDEuNDc4LTMuMzQyTDkuNjM4LjU5NkE0LjUgNC41IDAgMCAxIDEyLjU5NC0uNSA0LjA5IDQuMDkgMCAwIDEgMTUuNDQ0LjU5NnptLTkuMzcgNy44MzZIMTAuMzV2OC43MTNoNC4zODR6bTcuNzgyLTQuNDk0YzAtLjQ3My0uMTQ3LS44NTktLjQzOC0xLjE1bC04LjY1OC03LjUwNmMtLjYyMS0uNDczLTEuMjYxLS40NzMtMS45MTggMGwtOC42NTUgNy41MDZjLS4yOTMuMjkzLS40MzguNjc3LS40MzggMS4xNTJ2MTEuNzI1YzAgLjQzOC4xMjguODAzLjM4NCAxLjA5NmExLjUzIDEuNTMgMCAwIDAgMS4wNC4zODRoMy42MTd2LTguNzEzYzAtLjgwMy4yNzQtMS40OC44MjEtMi4wMjcuNTg2LS41ODYgMS4yOC0uODc3IDIuMDgzLS44NzdoNC4zODRhMi42NiAyLjY2IDAgMCAxIDIuMDI3Ljg3N2MuNTQ5LjU0Ny44MjIgMS4yMjQuODIyIDIuMDI3djguNzEzaDMuNjE3Yy40MzggMCAuNzg0LS4xMjggMS4wNC0uMzg0LjE0NC0uMTQzLjI1Ny0uMzE0LjMzMy0uNTAzcy4xMTEtLjM5LjEwNi0uNTkzeiIvPiYjeGE7PC9zdmc+;labelPosition=right;align=left;fontStyle=1;spacingLeft=15;fontSize=16;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(15, -15);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], 200, 70, 'SAP On-Premise Solution Box');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 150, 70), 'strokeColor=#0070F2;shadow=0;strokeWidth=2;rounded=1;absoluteArcSize=1;arcSize=20;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('3rd Party APIs \&\nApplications', new mxGeometry(0, 0, 28, 18), 'shape=image;editableCssRules=.*;part=1;imageAspect=0;image=data:image/svg+xml,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii0wLjUgLTAuNSAyOCAxOC40MTIiIGhlaWdodD0iMTguNDEyIiB3aWR0aD0iMjgiPiYjeGE7CSAgPHN0eWxlIHR5cGU9InRleHQvY3NzIj4uc3QwIHsgc3RvcC1jb2xvcjogcmdiKDM1LCAxNDksIDI1NSk7IH0gLnN0MSB7IHN0b3AtY29sb3I6IHJnYigwLCA4NywgMjEwKTsgfSA8L3N0eWxlPiYjeGE7CTxkZWZzPiYjeGE7CQk8bGluZWFyR3JhZGllbnQgZ3JhZGllbnRVbml0cz0idXNlclNwYWNlT25Vc2UiIHkyPSIyMi4wMDgiIHgyPSIxNC44NjkiIHkxPSIyLjExMyIgeDE9IjIuMDM5IiBpZD0iQSI+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QwIi8+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QxIiBvZmZzZXQ9IjEiLz4mI3hhOwkJPC9saW5lYXJHcmFkaWVudD4mI3hhOwk8L2RlZnM+JiN4YTsJPHBhdGggZmlsbD0idXJsKCNBKSIgZD0iTTUuOTAzIDYuMDQ3QzYuNDM0IDIuMzQ1IDkuNjE5LS41IDEzLjQ2Ny0uNWMyLjgwMSAwIDUuMjQ3IDEuNTA2IDYuNTc3IDMuNzQ5aC4xMjRjNC4wNDkgMCA3LjMzMSAzLjI4MiA3LjMzMSA3LjMzMXMtMy4yODIgNy4zMzEtNy4zMzEgNy4zMzFoLTQuMDU0Yy0uMDg3IDAtLjE3My0uMDAyLS4yNTktLjAwNS0uMDc4LjAwMy0uMTU1LjAwNS0uMjMzLjAwNUg1LjQzMmMtMy4yNzYgMC01LjkzMi0yLjY1Ni01LjkzMi01LjkzMnMyLjY1Ni01LjkzMiA1LjkzMi01LjkzMnpNMTMuNDY3IDIuM2MtMi42NzQgMC00Ljg0MiAyLjE2OC00Ljg0MiA0Ljg0MmE0Ljk0IDQuOTQgMCAwIDAgLjAwNi4yMzggMS40IDEuNCAwIDAgMS0xLjM5OCAxLjQ2N2gtMS44Yy0xLjczIDAtMy4xMzIgMS40MDItMy4xMzIgMy4xMzJzMS40MDIgMy4xMzIgMy4xMzIgMy4xMzJoMTAuMTlhMy4xNCAzLjE0IDAgMCAwIC4xNi0uMDA0IDEuMzkgMS4zOSAwIDAgMSAuMTMxIDBjLjA2Ny4wMDMuMTM0LjAwNC4yMDIuMDA0aDQuMDU0YTQuNTMgNC41MyAwIDEgMCAwLTkuMDYyaC0uOTc3YTEuNCAxLjQgMCAwIDEtMS4yODMtLjg0QzE3LjE2MSAzLjQ5NCAxNS40NTIgMi4zIDEzLjQ2NyAyLjN6IiBmaWxsLXJ1bGU9ImV2ZW5vZGQiLz4mI3hhOzwvc3ZnPg==;labelPosition=center;align=left;fontStyle=1;spacingLeft=0;fontSize=16;spacing=0;verticalLabelPosition=bottom;labelBackgroundColor=none;verticalAlign=top;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(10, 5);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], 150, 70, '3rd Party API\'s');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 200, 70), 'strokeColor=#0070F2;shadow=0;strokeWidth=2;rounded=1;absoluteArcSize=1;arcSize=20;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('SAP Cloud\nSolutions', new mxGeometry(0, 0.5, 34, 22), 'shape=image;editableCssRules=.*;part=1;verticalLabelPosition=middle;labelBackgroundColor=default;verticalAlign=middle;imageAspect=0;image=data:image/svg+xml,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii0wLjUgLTAuNSAyOCAxOC40MTIiIGhlaWdodD0iMTguNDEyIiB3aWR0aD0iMjgiPiYjeGE7CSAgPHN0eWxlIHR5cGU9InRleHQvY3NzIj4uc3QwIHsgc3RvcC1jb2xvcjogcmdiKDM1LCAxNDksIDI1NSk7IH0gLnN0MSB7IHN0b3AtY29sb3I6IHJnYigwLCA4NywgMjEwKTsgfSA8L3N0eWxlPiYjeGE7CTxkZWZzPiYjeGE7CQk8bGluZWFyR3JhZGllbnQgZ3JhZGllbnRVbml0cz0idXNlclNwYWNlT25Vc2UiIHkyPSIyMi4wMDgiIHgyPSIxNC44NjkiIHkxPSIyLjExMyIgeDE9IjIuMDM5IiBpZD0iQSI+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QwIi8+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QxIiBvZmZzZXQ9IjEiLz4mI3hhOwkJPC9saW5lYXJHcmFkaWVudD4mI3hhOwk8L2RlZnM+JiN4YTsJPHBhdGggZmlsbD0idXJsKCNBKSIgZD0iTTUuOTAzIDYuMDQ3QzYuNDM0IDIuMzQ1IDkuNjE5LS41IDEzLjQ2Ny0uNWMyLjgwMSAwIDUuMjQ3IDEuNTA2IDYuNTc3IDMuNzQ5aC4xMjRjNC4wNDkgMCA3LjMzMSAzLjI4MiA3LjMzMSA3LjMzMXMtMy4yODIgNy4zMzEtNy4zMzEgNy4zMzFoLTQuMDU0Yy0uMDg3IDAtLjE3My0uMDAyLS4yNTktLjAwNS0uMDc4LjAwMy0uMTU1LjAwNS0uMjMzLjAwNUg1LjQzMmMtMy4yNzYgMC01LjkzMi0yLjY1Ni01LjkzMi01LjkzMnMyLjY1Ni01LjkzMiA1LjkzMi01LjkzMnpNMTMuNDY3IDIuM2MtMi42NzQgMC00Ljg0MiAyLjE2OC00Ljg0MiA0Ljg0MmE0Ljk0IDQuOTQgMCAwIDAgLjAwNi4yMzggMS40IDEuNCAwIDAgMS0xLjM5OCAxLjQ2N2gtMS44Yy0xLjczIDAtMy4xMzIgMS40MDItMy4xMzIgMy4xMzJzMS40MDIgMy4xMzIgMy4xMzIgMy4xMzJoMTAuMTlhMy4xNCAzLjE0IDAgMCAwIC4xNi0uMDA0IDEuMzkgMS4zOSAwIDAgMSAuMTMxIDBjLjA2Ny4wMDMuMTM0LjAwNC4yMDIuMDA0aDQuMDU0YTQuNTMgNC41MyAwIDEgMCAwLTkuMDYyaC0uOTc3YTEuNCAxLjQgMCAwIDEtMS4yODMtLjg0QzE3LjE2MSAzLjQ5NCAxNS40NTIgMi4zIDEzLjQ2NyAyLjN6IiBmaWxsLXJ1bGU9ImV2ZW5vZGQiLz4mI3hhOzwvc3ZnPg==;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=15;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(15, -11);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], 200, 70, 'SAP Cloud\nSolutions');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 290, 250), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#0070F2;fillColor=#EBF8FF;arcSize=32;absoluteArcSize=1;strokeWidth=1.5;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('BTP', new mxGeometry(0, 0, 37, 19), 'image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;part=1;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(20, 20);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], 290, 250, 'BTP Base Layer');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('Big Title (L0)', new mxGeometry(0, 0, 390, 440), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#475E75;fillColor=#F5F6F7;arcSize=24;absoluteArcSize=1;imageWidth=64;imageHeight=64;strokeWidth=1.5;verticalAlign=top;align=left;fontSize=16;fontStyle=1;spacingTop=10;spacingLeft=20;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('', new mxGeometry(20, 55, 350, 365), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#475E75;fillColor=#ffffff;arcSize=24;absoluteArcSize=1;imageWidth=64;imageHeight=64;strokeWidth=1.5;part=1;');
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], bg.geometry.width, bg.geometry.height, '3rd Party Layer');
			}),

			this.addEntry(dt, function()
		   	{
			    var icon1 = new mxCell('End User', new mxGeometry(0, 0, 28, 28), 'shape=image;editableCssRules=.*;verticalLabelPosition=bottom;labelBackgroundColor=none;verticalAlign=top;aspect=fixed;imageAspect=0;image=data:image/svg+xml,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;fontStyle=0');
		    	icon1.vertex = true;
			    var icon2 = new mxCell('Application&nbsp;<div>Clients</div><div><font style="font-size: 10px;">Mobile or Desktop</font></div>', new mxGeometry(0, 90, 28, 25), 'shape=image;editableCssRules=.*;verticalLabelPosition=bottom;labelBackgroundColor=none;verticalAlign=top;aspect=fixed;imageAspect=0;html=1;image=data:image/svg+xml,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;');
		    	icon2.vertex = true;
		    	
		    	var edge1 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'edgeStyle=none;endArrow=blockThin;verticalAlign=top;labelBackgroundColor=none;endSize=6;html=1;rounded=0;targetPerimeterSpacing=10;sourcePerimeterSpacing=30;endFill=1;strokeColor=#475E75;');
		    	edge1.geometry.relative = true;
		    	edge1.edge = true;
		    	icon1.insertEdge(edge1, true);
		    	icon2.insertEdge(edge1, false);

		    	var edge2 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'edgeStyle=none;endArrow=blockThin;verticalAlign=top;labelBackgroundColor=none;endSize=6;html=1;rounded=0;targetPerimeterSpacing=10;sourcePerimeterSpacing=10;endFill=1;strokeColor=#475E75;');
		    	edge2.geometry.relative = true;
		    	edge2.edge = true;
		    	icon2.insertEdge(edge2, true);
			   	edge2.geometry.setTerminalPoint(new mxPoint(120, 102.5), false);

			   	return sb.createVertexTemplateFromCells([icon1, icon2, edge1, edge2], 100, 115, 'User and Client');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('Legend', new mxGeometry(0, 0, 340, 125), 'rounded=0;whiteSpace=wrap;html=1;strokeColor=none;strokeWidth=1.5;arcSize=16;fillColor=#F5F6F7;perimeterSpacing=0;imageHeight=24;absoluteArcSize=1;points=[];connectable=0;container=0;align=left;verticalAlign=top;fontSize=12;fontStyle=1;spacingTop=5;spacingLeft=8;');
		    	bg.vertex = true;
		    	
		    	var edge1 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=none;html=1;strokeColor=#0070F2;bendable=1;rounded=1;endFill=0;endSize=4;strokeWidth=1.5;startSize=4;part=1;');
		    	edge1.geometry.relative = true;
		    	edge1.edge = true;
			   	edge1.geometry.setTerminalPoint(new mxPoint(15, 50), true);
			   	edge1.geometry.setTerminalPoint(new mxPoint(80, 50), false);
				bg.insert(edge1);
			    var label1 = new mxCell('SAP', new mxGeometry(90, 40, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label1.vertex = true;
				bg.insert(label1);
				
		    	var edge2 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=none;html=1;strokeColor=#475E75;bendable=1;rounded=1;endFill=0;endSize=4;strokeWidth=1.5;startSize=4;');
		    	edge2.geometry.relative = true;
		    	edge2.edge = true;
			   	edge2.geometry.setTerminalPoint(new mxPoint(15, 70), true);
			   	edge2.geometry.setTerminalPoint(new mxPoint(80, 70), false);
				bg.insert(edge2);
			    var label2 = new mxCell('Non-SAP', new mxGeometry(90, 60, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label2.vertex = true;
				bg.insert(label2);
				
			    var icon1 = new mxCell('API', new mxGeometry(0, 0.73, 60, 16), 'rounded=1;whiteSpace=wrap;html=1;arcSize=50;strokeColor=#0070f3;fillColor=default;strokeWidth=1.5;fontColor=#0A74F3;fontStyle=1;fontSize=10;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(15, -8);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
			    var label3 = new mxCell('Interface', new mxGeometry(90, 80, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label3.vertex = true;
				bg.insert(label3);
				
		    	var edge4 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=blockThin;html=1;strokeColor=#CB00DC;bendable=1;rounded=0;endFill=1;endSize=4;strokeWidth=1.5;startSize=4;startArrow=none;startFill=0;');
		    	edge4.geometry.relative = true;
		    	edge4.edge = true;
			   	edge4.geometry.setTerminalPoint(new mxPoint(190, 50), true);
			   	edge4.geometry.setTerminalPoint(new mxPoint(230, 50), false);
				bg.insert(edge4);
			    var label4 = new mxCell('Trust', new mxGeometry(240, 40, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label4.vertex = true;
				bg.insert(label4);
				
		    	var edge5 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=blockThin;html=1;strokeColor=#188918;bendable=1;rounded=0;endFill=1;endSize=4;strokeWidth=1.5;startSize=4;startArrow=none;startFill=0;');
		    	edge5.geometry.relative = true;
		    	edge5.edge = true;
			   	edge5.geometry.setTerminalPoint(new mxPoint(190, 70), true);
			   	edge5.geometry.setTerminalPoint(new mxPoint(230, 70), false);
				bg.insert(edge5);
			    var label5 = new mxCell('Authentication', new mxGeometry(240, 60, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label5.vertex = true;
				bg.insert(label5);
				
		    	var edge6 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=blockThin;html=1;strokeColor=#475E75;bendable=1;rounded=0;endFill=1;endSize=4;strokeWidth=1.5;startSize=4;startArrow=none;startFill=0;');
		    	edge6.geometry.relative = true;
		    	edge6.edge = true;
			   	edge6.geometry.setTerminalPoint(new mxPoint(190, 90), true);
			   	edge6.geometry.setTerminalPoint(new mxPoint(230, 90), false);
				bg.insert(edge6);
			    var label6 = new mxCell('Data Flow', new mxGeometry(240, 80, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label6.vertex = true;
				bg.insert(label6);
				
			   	return sb.createVertexTemplateFromCells([bg], bg.geometry.width, bg.geometry.height, 'Legend');
			}),

		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#0070F2;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'Diagram Title',
		    		'Diagram Title', null, null, this.getTagsForStencil(gn, '', dt + 'diagram title').join(' ')),
		    		
			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 200, 160), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#0070F2;strokeWidth=1.5;arcSize=16;fillColor=#FFFFFF;perimeterSpacing=0;absoluteArcSize=1;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('SAP On-Premise\nSolutions', new mxGeometry(0, 0, 28, 30), 'shape=image;editableCssRules=.*;part=1;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;aspect=fixed;imageAspect=0;image=data:image/svg+xml,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii0wLjUgLTAuNSAyNi4wODQgMjgiIGhlaWdodD0iMjgiIHdpZHRoPSIyNi4wODQiPiYjeGE7CSAgPHN0eWxlIHR5cGU9InRleHQvY3NzIj4uc3QwIHsgc3RvcC1jb2xvcjogcmdiKDM1LCAxNDksIDI1NSk7IH0gLnN0MSB7IHN0b3AtY29sb3I6IHJnYigwLCA4NywgMjEwKTsgfSA8L3N0eWxlPiYjeGE7CTxkZWZzPiYjeGE7CQk8bGluZWFyR3JhZGllbnQgZ3JhZGllbnRVbml0cz0idXNlclNwYWNlT25Vc2UiIHkyPSIyMy43OTIiIHgyPSIyMy4yNTYiIHkxPSIzLjQ3NCIgeDE9IjEuODY1IiBpZD0iQSI+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QwIi8+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QxIiBvZmZzZXQ9IjEiLz4mI3hhOwkJPC9saW5lYXJHcmFkaWVudD4mI3hhOwk8L2RlZnM+JiN4YTsJPHBhdGggZmlsbD0idXJsKCNBKSIgZD0iTTI0LjEwNCA4LjEwMmE0Ljk3IDQuOTcgMCAwIDEgMS4wNDIgMS41MzRjLjI5MS41NDkuNDM4IDEuMTUyLjQzOCAxLjgxdjExLjcyNWMwIDEuMjQxLS40MjEgMi4yNjUtMS4yNjIgMy4wNjgtLjgzOC44NDItMS44OCAxLjI2MS0zLjEyMSAxLjI2MUgzLjgyN2E0LjE4IDQuMTggMCAwIDEtMy4wNjgtMS4yNjFDLS4wODEgMjUuNDM2LS41IDI0LjQxMi0uNSAyMy4xNzFWMTEuNDQ0YzAtMS4zODcuNDkxLTIuNTAyIDEuNDc4LTMuMzQyTDkuNjM4LjU5NkE0LjUgNC41IDAgMCAxIDEyLjU5NC0uNSA0LjA5IDQuMDkgMCAwIDEgMTUuNDQ0LjU5NnptLTkuMzcgNy44MzZIMTAuMzV2OC43MTNoNC4zODR6bTcuNzgyLTQuNDk0YzAtLjQ3My0uMTQ3LS44NTktLjQzOC0xLjE1bC04LjY1OC03LjUwNmMtLjYyMS0uNDczLTEuMjYxLS40NzMtMS45MTggMGwtOC42NTUgNy41MDZjLS4yOTMuMjkzLS40MzguNjc3LS40MzggMS4xNTJ2MTEuNzI1YzAgLjQzOC4xMjguODAzLjM4NCAxLjA5NmExLjUzIDEuNTMgMCAwIDAgMS4wNC4zODRoMy42MTd2LTguNzEzYzAtLjgwMy4yNzQtMS40OC44MjEtMi4wMjcuNTg2LS41ODYgMS4yOC0uODc3IDIuMDgzLS44NzdoNC4zODRhMi42NiAyLjY2IDAgMCAxIDIuMDI3Ljg3N2MuNTQ5LjU0Ny44MjIgMS4yMjQuODIyIDIuMDI3djguNzEzaDMuNjE3Yy40MzggMCAuNzg0LS4xMjggMS4wNC0uMzg0LjE0NC0uMTQzLjI1Ny0uMzE0LjMzMy0uNTAzcy4xMTEtLjM5LjEwNi0uNTkzeiIvPiYjeGE7PC9zdmc+;labelPosition=right;align=left;fontStyle=1;spacingLeft=15;fontSize=16;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(15, 15);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			    var icon2 = new mxCell('Cloud\nConnector', new mxGeometry(0.5, 1, 50, 50), 'shape=mxgraph.sap.icon;labelPosition=center;verticalLabelPosition=bottom;align=center;verticalAlign=top;strokeWidth=1;strokeColor=#D5DADD;fillColor=#EDEFF0;gradientColor=#FCFCFC;gradientDirection=west;aspect=fixed;SAPIcon=Cloud_Connector2');
			    icon2.geometry.relative = true;
			    icon2.geometry.offset = new mxPoint(-14, -95);
		    	icon2.vertex = true;
		    	bg.insert(icon2);
		    	
			   	return sb.createVertexTemplateFromCells([bg], bg.geometry.width, bg.geometry.height, 'Cloud Connector');
			}),

		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;whiteSpace=wrap;rounded=0;', 500, 50, 
		    		'<b style="color: rgb(71, 94, 117); font-family: arial; text-wrap: nowrap;">Diagram Level L1</b><div><div><span style="color: rgb(71, 94, 117); font-family: arial; text-wrap: nowrap;">Text for short description of diagram which should not exceed 3 lines of texts.</span><br style="color: rgb(71, 94, 117); font-family: arial; text-wrap: nowrap;"><span style="color: rgb(71, 94, 117); font-family: arial; text-wrap: nowrap;">Advice: Keep it short and simple and just explain what it is, not every single step of the flow.</span><b style="color: rgb(71, 94, 117); font-family: arial; text-wrap: nowrap;"></b></div></div>',
		    		'Diagram Title', null, null, this.getTagsForStencil(gn, '', dt + 'diagram title').join(' ')),

			this.addEntry(dt + 'legend compact short', function()
		   	{
			    var bg = new mxCell('Legend', new mxGeometry(0, 0, 180, 110), 'rounded=0;whiteSpace=wrap;html=1;strokeColor=none;strokeWidth=1.5;arcSize=16;fillColor=#F5F6F7;perimeterSpacing=0;imageHeight=24;absoluteArcSize=1;points=[];connectable=0;container=0;align=left;verticalAlign=top;fontSize=12;fontStyle=1;spacingTop=5;spacingLeft=8;');
		    	bg.vertex = true;
		    	
		    	var edge1 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=none;html=1;strokeColor=#0070F2;bendable=1;rounded=1;endFill=0;endSize=4;strokeWidth=1.5;startSize=4;part=1;');
		    	edge1.geometry.relative = true;
		    	edge1.edge = true;
			   	edge1.geometry.setTerminalPoint(new mxPoint(15, 50), true);
			   	edge1.geometry.setTerminalPoint(new mxPoint(80, 50), false);
				bg.insert(edge1);
			    var label1 = new mxCell('SAP', new mxGeometry(90, 40, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label1.vertex = true;
				bg.insert(label1);
				
		    	var edge2 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;fontSize=18;strokeColor=#188918;fontFamily=Helvetica;fontColor=default;targetPerimeterSpacing=15;endSize=4;startSize=4;dashed=1;endArrow=blockThin;endFill=1;strokeWidth=1.5;startArrow=none;startFill=0;');
		    	edge2.geometry.relative = true;
		    	edge2.edge = true;
			   	edge2.geometry.setTerminalPoint(new mxPoint(15, 70), true);
			   	edge2.geometry.setTerminalPoint(new mxPoint(80, 70), false);
				bg.insert(edge2);
			    var label2 = new mxCell('Authentication', new mxGeometry(90, 60, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label2.vertex = true;
				bg.insert(label2);
				
		    	var edge3 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;fontSize=18;strokeColor=#475E75;fontFamily=Helvetica;fontColor=default;targetPerimeterSpacing=15;endSize=4;startSize=4;endArrow=blockThin;endFill=1;strokeWidth=1.5;startArrow=none;startFill=0;');
		    	edge3.geometry.relative = true;
		    	edge3.edge = true;
			   	edge3.geometry.setTerminalPoint(new mxPoint(15, 90), true);
			   	edge3.geometry.setTerminalPoint(new mxPoint(80, 90), false);
				bg.insert(edge3);
			    var label3 = new mxCell('Data Flow', new mxGeometry(90, 80, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label3.vertex = true;
				bg.insert(label3);
				
			   	return sb.createVertexTemplateFromCells([bg], bg.geometry.width, bg.geometry.height, 'Legend Short');
			}),

			this.addEntry(dt, function()
		   	{
			    var icon2 = new mxCell('SAML2/OIDC', new mxGeometry(0, 84, 72, 16), 'rounded=1;whiteSpace=wrap;html=1;arcSize=50;strokeColor=#188918;fillColor=#f5fae5;fontColor=#266f3a;strokeWidth=1.5;fontSize=10;fontStyle=1');
		    	icon2.vertex = true;
		    	
		    	var edge1 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'rounded=0;orthogonalLoop=1;jettySize=auto;html=1;fontSize=18;strokeColor=#188918;fontFamily=Helvetica;fontColor=default;targetPerimeterSpacing=15;endSize=4;startSize=4;endArrow=none;endFill=0;strokeWidth=1.5;startArrow=none;startFill=0;entryX=0.5;entryY=0;entryDx=0;entryDy=0;');
		    	edge1.geometry.relative = true;
		    	edge1.edge = true;
		    	icon2.insertEdge(edge1, false);
			   	edge1.geometry.setTerminalPoint(new mxPoint(36, 0), true);

		    	var edge2 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;fontSize=18;strokeColor=#188918;fontFamily=Helvetica;fontColor=default;targetPerimeterSpacing=15;endSize=4;startSize=4;endArrow=blockThin;endFill=1;strokeWidth=1.5;startArrow=none;startFill=0;exitX=1;exitY=0.5;exitDx=0;exitDy=0;entryX=0;entryY=0.5;entryDx=0;entryDy=0;');
		    	edge2.geometry.relative = true;
		    	edge2.edge = true;
		    	icon2.insertEdge(edge2, true);
			   	edge2.geometry.setTerminalPoint(new mxPoint(120, 92), false);

			   	return sb.createVertexTemplateFromCells([icon2, edge1, edge2], 120, 100, 'SAML/OIDC');
			}),

			this.addEntry(dt, function()
		   	{
			    var icon1 = new mxCell('SAML2/OIDC', new mxGeometry(0, 20, 72, 16), 'rounded=1;whiteSpace=wrap;html=1;arcSize=50;strokeColor=#188918;fillColor=#f5fae5;fontColor=#266f3a;strokeWidth=1.5;fontSize=10;fontStyle=1');
		    	icon1.vertex = true;
			    var icon2 = new mxCell('SCIM', new mxGeometry(100, 20, 38, 16), 'rounded=1;whiteSpace=wrap;html=1;arcSize=50;strokeColor=#470BED;fillColor=#f1ecff;fontColor=#470bed;strokeWidth=1.5;fontSize=10;fontStyle=1');
		    	icon2.vertex = true;
			    var icon3 = new mxCell('', new mxGeometry(22, 60, 28, 28), 'shape=image;editableCssRules=.*;verticalLabelPosition=bottom;labelBackgroundColor=default;verticalAlign=top;aspect=fixed;imageAspect=0;image=data:image/svg+xml,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;');
		    	icon3.vertex = true;
			    var icon4 = new mxCell('3rd party identity provider /\nidentity management', new mxGeometry(60, 54, 140, 40), 'text;html=1;align=left;verticalAlign=middle;resizable=1;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=10;fontColor=#556B82;fontFamily=Helvetica;');
		    	icon4.vertex = true;
		    	
		    	var edge1 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=none;html=1;strokeColor=#188918;bendable=1;rounded=0;endFill=0;endSize=3;strokeWidth=1.5;entryX=0.5;entryY=0;entryDx=0;entryDy=0;dashed=1;');
		    	edge1.geometry.relative = true;
		    	edge1.edge = true;
			   	edge1.geometry.setTerminalPoint(new mxPoint(36, 0), true);
		    	icon1.insertEdge(edge1, false);
		    	var edge2 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=none;html=1;strokeColor=#188918;bendable=1;rounded=0;endFill=0;endSize=3;strokeWidth=1.5;dashed=1;sourcePerimeterSpacing=0;targetPerimeterSpacing=10;');
		    	edge2.geometry.relative = true;
		    	edge2.edge = true;
		    	icon1.insertEdge(edge2, true);
		    	icon3.insertEdge(edge2, false);
		    	var edge3 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=none;html=1;strokeColor=#470BED;bendable=1;rounded=0;endFill=0;endSize=3;strokeWidth=1.5;entryX=0.5;entryY=0;entryDx=0;entryDy=0;dashed=1;');
		    	edge3.geometry.relative = true;
		    	edge3.edge = true;
			   	edge3.geometry.setTerminalPoint(new mxPoint(119, 0), true);
		    	icon2.insertEdge(edge3, false);
		    	var edge4 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=none;html=1;strokeColor=#470BED;bendable=1;rounded=0;endFill=0;endSize=3;strokeWidth=1.5;dashed=1;edgeStyle=elbowEdgeStyle;exitX=0.5;exitY=1;exitDx=0;exitDy=0;');
		    	edge4.geometry.relative = true;
		    	edge4.edge = true;
		    	icon2.insertEdge(edge4, true);
		    	icon4.insertEdge(edge4, false);

			   	return sb.createVertexTemplateFromCells([icon1, icon2, icon3, icon4, edge1, edge2, edge3, edge4], 120, 100, '3rd Party IdP and Protocols');
			}),

			this.addDataEntry('https protocol', 214, 50, 'HTTPS Protocol', 'vVXLbtswEPwaHWvoGSfH1raSSwADNtD2SEtbiQgtGhQdS/36LsnVK7ZQF2h7MKCZ3VlRO2PJi1bH5lmxU/kqcxBetPGilZJSu6tjswIhvNDnuRetvTD08eeF6Uw1sFX/xBRU+h5B6ATvTJzBMS/7/Xbn2Fq3glglz1UORhR40ZdLyTXsTiwz1QseHrlSHwWVmcp2/KepJT7CWiv5BisppLLDoniZbJYJVn5wIUZ8mqQP6bJXfOW5Ls3Ihe2Vlb45A/kdHTTosLt7YO5ODwhKQzO7JEvRhp5BHkGrFltI8BQ7xYUOhCh+dFQJvCi7IQ+OY7XDRT9oMAAvyIPbfkRXflxZAVX+WSl5QVTJCqarn9/1AXXs0K9pMNQsCWspN4fqEG0wnjGj1kzpSQ/iD6ey3GQq7uLbGHw3wM6zcN2Mi+u2Qw3XVraIlyFho/zkL/zkiYhBa8BYugXF0QZQHScO9pQmETxjwlB5AV2EpNKlLGTFxGZgKUSmbxIhfMIC9OSfdEeqFAim+ft01K3QkHQrOU4M/dZ1JP5UUcuzyoCahqShG6wdtZ1MQz0/9vFDTJ1+CG3/AHflOP6jHB+EzN72Ja/+cpiDfxdmCmUwCiRFeTaNMyFy/v2vENErLQzIoYn7/QAX7KtM/T4ICIePl2sff9t+AQ=='),
			this.addDataEntry('', 71, 132, '', '1VbbjpswEP0aHhfZBnJ53CSbVR9WWimt2j5CMBetg1PjbKBf3zE2F0MSZbUPbSNF8YxnzpjxmUMcb32onkV4zF54TJnjPTneWnAu9epQrSljDkF57HgbhxAEX4dsr+ziZhcdQ0ELeU8C0QnvITtR7dGOUtbMOGgRPwrBz2AVvADnKpMHOOgGw7KUgr/RNWdcNNGeP0erpw3sRJAXRg2IChT8VMRUVUVgwd42Z6y3dvlvFel1kN/zWGYq1w1URJXLHyq6s34aXLXeVC2QMuoOVYraJJHWVmkPyEXIbz19cmNZ2a9U5AcqqTBO3Rsap9Rqd8lPYm9c3vQGmijT/mfKAVDUEHI2Twi7gb4klNE8zaTtE5SFMn+3K4alNtMOrqvwynMoTFBlzrPwXDILdFqtff5iZsPoBzCZQ7aMwQJ3uQxQ/7FxsUdsXBmKlMoJLtAprAdhRxVQDiNgMehV72rYe5nJ3gUmzxg0c5Xw5hlKTTHw/jqp8Vrhfgmr1Pw2KZE1AoOoUfxu/eWlzYEDRmMc8OnqrXs0W/1UKC6fs1zS3TFsuHQGTbBnLRR7MyYBujl6CYzWwJ9guk8S0wg7PlK1L06c6SYVklZXteUKs9uEmevfYMvSEHwwB97CRXg6CnhE1yHrLcbcoIf/nwjdQLSGmtUL1GW5KmHUZHv6iPH929csL9oNcwR8n4SZa9LD+2+qGvZmSoksPj2MUO4VNexPsTBe/j0lCyZU/VbCK4igneSCfk5DJjRGaI625Aobe8WBEZzoCo2TRaMrx/Y1qermRWo4GUYlZydJH3uUqQh19ZW/DcOfFKABCecX9IRgdz7/sKSA2f8v09c6/Nv2Bw==')
		]);
	};

	Sidebar.prototype.addSAPComponentsPalette = function(s, gn, sb)
	{
		var dt = 'sap components ';
		
		this.addPaletteFunctions('sapComponents', 'SAP / Components', false,
		[
			this.addDataEntry('3rd third party provider identity management', 50, 50, '3rd party identity provider / identity management', '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'),

			this.addEntry(dt, function()
		   	{
			    var icon1 = new mxCell('User', new mxGeometry(65, 0, 48, 48), 'shape=image;editableCssRules=.*;verticalLabelPosition=bottom;labelBackgroundColor=none;verticalAlign=top;aspect=fixed;imageAspect=0;image=data:image/svg+xml,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;fontStyle=1');
		    	icon1.vertex = true;

			    var bg1 = new mxCell('', new mxGeometry(0, 110, 170, 140), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#475E75;strokeWidth=1.5;arcSize=5;fillColor=#F5F6F7;perimeterSpacing=0;');
		    	bg1.vertex = true;
		    	
			    var icon2 = new mxCell('Mobile/Desktop<br><b><font style="font-size: 16px;">Application Clients</font></b>', new mxGeometry(0.5, 0.5, 48, 40), 'shape=image;editableCssRules=.*;verticalLabelPosition=bottom;labelBackgroundColor=none;verticalAlign=top;aspect=fixed;imageAspect=0;html=1;image=data:image/svg+xml,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;');
			    icon2.geometry.relative = true;
			    icon2.geometry.offset = new mxPoint(-24, -20);
		    	icon2.vertex = true;
		    	bg1.insert(icon2);
		    	
		    	var edge1 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'edgeStyle=none;endArrow=blockThin;verticalAlign=top;labelBackgroundColor=none;endSize=6;html=1;rounded=0;targetPerimeterSpacing=0;sourcePerimeterSpacing=30;endFill=1;strokeColor=#475E75;');
		    	edge1.geometry.relative = true;
		    	edge1.edge = true;
		    	icon1.insertEdge(edge1, true);
		    	bg1.insertEdge(edge1, false);

		    	var edge2 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'edgeStyle=none;endArrow=blockThin;verticalAlign=top;labelBackgroundColor=none;endSize=6;html=1;rounded=0;targetPerimeterSpacing=10;sourcePerimeterSpacing=0;endFill=1;strokeColor=#475E75;');
		    	edge2.geometry.relative = true;
		    	edge2.edge = true;
		    	bg1.insertEdge(edge2, true);
			   	edge2.geometry.setTerminalPoint(new mxPoint(230, 180), false);

			   	return sb.createVertexTemplateFromCells([icon1, bg1, edge1, edge2], 230, 250, '');
			}),
			
			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('Legend', new mxGeometry(0, 0, 210, 130), 'rounded=0;whiteSpace=wrap;html=1;strokeColor=none;strokeWidth=1.5;arcSize=16;fillColor=#F5F6F7;perimeterSpacing=0;imageHeight=24;absoluteArcSize=1;points=[];connectable=0;container=0;align=left;verticalAlign=top;fontSize=12;fontStyle=1;spacingTop=5;spacingLeft=8;');
		    	bg.vertex = true;
		    	
		    	var edge1 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=block;html=1;strokeColor=#354A5F;bendable=1;rounded=1;endFill=1;endSize=6;strokeWidth=1.5;');
		    	edge1.geometry.relative = true;
		    	edge1.edge = true;
			   	edge1.geometry.setTerminalPoint(new mxPoint(15, 50), true);
			   	edge1.geometry.setTerminalPoint(new mxPoint(80, 50), false);
				bg.insert(edge1);
			    var label1 = new mxCell('Description #1', new mxGeometry(90, 40, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label1.vertex = true;
				bg.insert(label1);
				
		    	var edge2 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=block;html=1;strokeColor=#354A5F;bendable=1;rounded=1;endFill=1;endSize=6;strokeWidth=1.5;');
		    	edge2.geometry.relative = true;
		    	edge2.edge = true;
			   	edge2.geometry.setTerminalPoint(new mxPoint(15, 70), true);
			   	edge2.geometry.setTerminalPoint(new mxPoint(80, 70), false);
				bg.insert(edge2);
			    var label2 = new mxCell('Description #1', new mxGeometry(90, 60, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label2.vertex = true;
				bg.insert(label2);
				
		    	var edge3 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=block;html=1;strokeColor=#354A5F;bendable=1;rounded=1;endFill=1;endSize=6;strokeWidth=1.5;');
		    	edge3.geometry.relative = true;
		    	edge3.edge = true;
			   	edge3.geometry.setTerminalPoint(new mxPoint(15, 90), true);
			   	edge3.geometry.setTerminalPoint(new mxPoint(80, 90), false);
				bg.insert(edge3);
			    var label3 = new mxCell('Description #1', new mxGeometry(90, 80, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label3.vertex = true;
				bg.insert(label3);
				
		    	var edge4 = new mxCell('', new mxGeometry(0, 0, 0, 0), 'endArrow=block;html=1;strokeColor=#354A5F;bendable=1;rounded=1;endFill=1;endSize=6;strokeWidth=1.5;');
		    	edge4.geometry.relative = true;
		    	edge4.edge = true;
			   	edge4.geometry.setTerminalPoint(new mxPoint(15, 110), true);
			   	edge4.geometry.setTerminalPoint(new mxPoint(80, 110), false);
				bg.insert(edge4);
			    var label4 = new mxCell('Description #1', new mxGeometry(90, 100, 90, 20), 'part=1;fillColor=none;strokeColor=none;align=left;fontSize=10;fontColor=#556B82;');
		    	label4.vertex = true;
				bg.insert(label4);
				
			   	return sb.createVertexTemplateFromCells([bg], bg.geometry.width, bg.geometry.height, '');
			}),
			
			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 200, 70), 'strokeColor=#0070F2;shadow=0;strokeWidth=2;rounded=1;absoluteArcSize=1;arcSize=20;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('SAP On-Premise\nSolutions', new mxGeometry(0, 0.5, 28, 30), 'shape=image;editableCssRules=.*;part=1;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;aspect=fixed;imageAspect=0;image=data:image/svg+xml,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii0wLjUgLTAuNSAyNi4wODQgMjgiIGhlaWdodD0iMjgiIHdpZHRoPSIyNi4wODQiPiYjeGE7CSAgPHN0eWxlIHR5cGU9InRleHQvY3NzIj4uc3QwIHsgc3RvcC1jb2xvcjogcmdiKDM1LCAxNDksIDI1NSk7IH0gLnN0MSB7IHN0b3AtY29sb3I6IHJnYigwLCA4NywgMjEwKTsgfSA8L3N0eWxlPiYjeGE7CTxkZWZzPiYjeGE7CQk8bGluZWFyR3JhZGllbnQgZ3JhZGllbnRVbml0cz0idXNlclNwYWNlT25Vc2UiIHkyPSIyMy43OTIiIHgyPSIyMy4yNTYiIHkxPSIzLjQ3NCIgeDE9IjEuODY1IiBpZD0iQSI+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QwIi8+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QxIiBvZmZzZXQ9IjEiLz4mI3hhOwkJPC9saW5lYXJHcmFkaWVudD4mI3hhOwk8L2RlZnM+JiN4YTsJPHBhdGggZmlsbD0idXJsKCNBKSIgZD0iTTI0LjEwNCA4LjEwMmE0Ljk3IDQuOTcgMCAwIDEgMS4wNDIgMS41MzRjLjI5MS41NDkuNDM4IDEuMTUyLjQzOCAxLjgxdjExLjcyNWMwIDEuMjQxLS40MjEgMi4yNjUtMS4yNjIgMy4wNjgtLjgzOC44NDItMS44OCAxLjI2MS0zLjEyMSAxLjI2MUgzLjgyN2E0LjE4IDQuMTggMCAwIDEtMy4wNjgtMS4yNjFDLS4wODEgMjUuNDM2LS41IDI0LjQxMi0uNSAyMy4xNzFWMTEuNDQ0YzAtMS4zODcuNDkxLTIuNTAyIDEuNDc4LTMuMzQyTDkuNjM4LjU5NkE0LjUgNC41IDAgMCAxIDEyLjU5NC0uNSA0LjA5IDQuMDkgMCAwIDEgMTUuNDQ0LjU5NnptLTkuMzcgNy44MzZIMTAuMzV2OC43MTNoNC4zODR6bTcuNzgyLTQuNDk0YzAtLjQ3My0uMTQ3LS44NTktLjQzOC0xLjE1bC04LjY1OC03LjUwNmMtLjYyMS0uNDczLTEuMjYxLS40NzMtMS45MTggMGwtOC42NTUgNy41MDZjLS4yOTMuMjkzLS40MzguNjc3LS40MzggMS4xNTJ2MTEuNzI1YzAgLjQzOC4xMjguODAzLjM4NCAxLjA5NmExLjUzIDEuNTMgMCAwIDAgMS4wNC4zODRoMy42MTd2LTguNzEzYzAtLjgwMy4yNzQtMS40OC44MjEtMi4wMjcuNTg2LS41ODYgMS4yOC0uODc3IDIuMDgzLS44NzdoNC4zODRhMi42NiAyLjY2IDAgMCAxIDIuMDI3Ljg3N2MuNTQ5LjU0Ny44MjIgMS4yMjQuODIyIDIuMDI3djguNzEzaDMuNjE3Yy40MzggMCAuNzg0LS4xMjggMS4wNC0uMzg0LjE0NC0uMTQzLjI1Ny0uMzE0LjMzMy0uNTAzcy4xMTEtLjM5LjEwNi0uNTkzeiIvPiYjeGE7PC9zdmc+;labelPosition=right;align=left;fontStyle=1;spacingLeft=15;fontSize=16;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(15, -15);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], 200, 70, 'SAP On-Premise Solution Box');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 200, 70), 'strokeColor=#0070F2;shadow=0;strokeWidth=2;rounded=1;absoluteArcSize=1;arcSize=20;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('SAP Cloud\nSolutions', new mxGeometry(0, 0.5, 34, 22), 'shape=image;editableCssRules=.*;part=1;verticalLabelPosition=middle;labelBackgroundColor=default;verticalAlign=middle;imageAspect=0;image=data:image/svg+xml,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii0wLjUgLTAuNSAyOCAxOC40MTIiIGhlaWdodD0iMTguNDEyIiB3aWR0aD0iMjgiPiYjeGE7CSAgPHN0eWxlIHR5cGU9InRleHQvY3NzIj4uc3QwIHsgc3RvcC1jb2xvcjogcmdiKDM1LCAxNDksIDI1NSk7IH0gLnN0MSB7IHN0b3AtY29sb3I6IHJnYigwLCA4NywgMjEwKTsgfSA8L3N0eWxlPiYjeGE7CTxkZWZzPiYjeGE7CQk8bGluZWFyR3JhZGllbnQgZ3JhZGllbnRVbml0cz0idXNlclNwYWNlT25Vc2UiIHkyPSIyMi4wMDgiIHgyPSIxNC44NjkiIHkxPSIyLjExMyIgeDE9IjIuMDM5IiBpZD0iQSI+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QwIi8+JiN4YTsJCQk8c3RvcCBjbGFzcz0ic3QxIiBvZmZzZXQ9IjEiLz4mI3hhOwkJPC9saW5lYXJHcmFkaWVudD4mI3hhOwk8L2RlZnM+JiN4YTsJPHBhdGggZmlsbD0idXJsKCNBKSIgZD0iTTUuOTAzIDYuMDQ3QzYuNDM0IDIuMzQ1IDkuNjE5LS41IDEzLjQ2Ny0uNWMyLjgwMSAwIDUuMjQ3IDEuNTA2IDYuNTc3IDMuNzQ5aC4xMjRjNC4wNDkgMCA3LjMzMSAzLjI4MiA3LjMzMSA3LjMzMXMtMy4yODIgNy4zMzEtNy4zMzEgNy4zMzFoLTQuMDU0Yy0uMDg3IDAtLjE3My0uMDAyLS4yNTktLjAwNS0uMDc4LjAwMy0uMTU1LjAwNS0uMjMzLjAwNUg1LjQzMmMtMy4yNzYgMC01LjkzMi0yLjY1Ni01LjkzMi01LjkzMnMyLjY1Ni01LjkzMiA1LjkzMi01LjkzMnpNMTMuNDY3IDIuM2MtMi42NzQgMC00Ljg0MiAyLjE2OC00Ljg0MiA0Ljg0MmE0Ljk0IDQuOTQgMCAwIDAgLjAwNi4yMzggMS40IDEuNCAwIDAgMS0xLjM5OCAxLjQ2N2gtMS44Yy0xLjczIDAtMy4xMzIgMS40MDItMy4xMzIgMy4xMzJzMS40MDIgMy4xMzIgMy4xMzIgMy4xMzJoMTAuMTlhMy4xNCAzLjE0IDAgMCAwIC4xNi0uMDA0IDEuMzkgMS4zOSAwIDAgMSAuMTMxIDBjLjA2Ny4wMDMuMTM0LjAwNC4yMDIuMDA0aDQuMDU0YTQuNTMgNC41MyAwIDEgMCAwLTkuMDYyaC0uOTc3YTEuNCAxLjQgMCAwIDEtMS4yODMtLjg0QzE3LjE2MSAzLjQ5NCAxNS40NTIgMi4zIDEzLjQ2NyAyLjN6IiBmaWxsLXJ1bGU9ImV2ZW5vZGQiLz4mI3hhOzwvc3ZnPg==;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=15;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(15, -11);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], 200, 70, 'SAP Cloud\nSolutions');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 290, 250), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#0070F2;fillColor=#EBF8FF;arcSize=32;absoluteArcSize=1;strokeWidth=1.5;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('BTP', new mxGeometry(0, 0, 37, 19), 'image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;part=1;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(20, 20);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], 290, 250, 'BTP Basic Layer');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('Big Title (L0)', new mxGeometry(0, 0, 390, 440), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#475E75;fillColor=#F5F6F7;arcSize=24;absoluteArcSize=1;imageWidth=64;imageHeight=64;strokeWidth=1.5;verticalAlign=top;align=left;fontSize=16;fontStyle=1;spacingTop=10;spacingLeft=20;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('', new mxGeometry(20, 55, 350, 365), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#475E75;fillColor=#ffffff;arcSize=24;absoluteArcSize=1;imageWidth=64;imageHeight=64;strokeWidth=1.5;part=1;');
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], bg.geometry.width, bg.geometry.height, 'Non-SAP Content');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 630, 440), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#0070F2;fillColor=#EBF8FF;arcSize=24;absoluteArcSize=1;imageWidth=64;imageHeight=64;strokeWidth=1.5;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('BTP', new mxGeometry(0, 0, 37, 19), 'image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;part=1;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;');
			    icon1.geometry.relative = true;
			    icon1.geometry.offset = new mxPoint(20, 20);
		    	icon1.vertex = true;
		    	bg.insert(icon1);
			    var icon2 = new mxCell('Subaccount', new mxGeometry(20, 55, 590, 365), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#475E75;fillColor=#ffffff;arcSize=24;absoluteArcSize=1;imageWidth=64;imageHeight=64;strokeWidth=1.5;part=1;verticalAlign=top;align=left;fontSize=16;fontStyle=1;spacingLeft=10;spacingTop=10;');
		    	icon2.vertex = true;
		    	bg.insert(icon2);
			    var icon3 = new mxCell('', new mxGeometry(40, 240, 180, 160), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#0070F2;fillColor=#EBF8FF;arcSize=24;absoluteArcSize=1;imageWidth=64;imageHeight=64;strokeWidth=1.5;part=1;');
		    	icon3.vertex = true;
		    	bg.insert(icon3);
			    var icon4 = new mxCell('', new mxGeometry(65, 300, 130, 20), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#0070F2;fillColor=#ffffff;arcSize=16;absoluteArcSize=1;strokeWidth=1.5;part=1;');
		    	icon4.vertex = true;
		    	bg.insert(icon4);
			    var icon5 = new mxCell('', new mxGeometry(65, 330, 130, 20), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#0070F2;fillColor=#ffffff;arcSize=16;absoluteArcSize=1;strokeWidth=1.5;part=1;');
		    	icon5.vertex = true;
		    	bg.insert(icon5);
			    var icon6 = new mxCell('', new mxGeometry(65, 360, 130, 20), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#0070F2;fillColor=#ffffff;arcSize=16;absoluteArcSize=1;strokeWidth=1.5;part=1;');
		    	icon6.vertex = true;
		    	bg.insert(icon6);
		    	
			   	return sb.createVertexTemplateFromCells([bg], 290, 250, 'Bigger SAP Box with multiple layers');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 350, 290), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#07838F;fillColor=#DAFDF5;arcSize=24;absoluteArcSize=1;imageWidth=64;imageHeight=64;strokeWidth=1.5;verticalAlign=top;align=left;fontSize=16;fontStyle=1;spacingTop=10;spacingLeft=20;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('', new mxGeometry(20, 55, 310, 215), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#07838F;fillColor=#ffffff;arcSize=24;absoluteArcSize=1;imageWidth=64;imageHeight=64;strokeWidth=1.5;part=1;');
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], bg.geometry.width, bg.geometry.height, '');
			}),

			this.addEntry(dt, function()
		   	{
			    var bg = new mxCell('', new mxGeometry(0, 0, 200, 290), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#5d36ff;fillColor=#f1ecff;arcSize=24;absoluteArcSize=1;strokeWidth=1.5;');
		    	bg.vertex = true;
			    var icon1 = new mxCell('', new mxGeometry(20, 55, 160, 215), 'rounded=1;whiteSpace=wrap;html=1;strokeColor=#5d36ff;fillColor=#FFFFFF;arcSize=24;absoluteArcSize=1;strokeWidth=1.5;');
		    	icon1.vertex = true;
		    	bg.insert(icon1);
		    	
			   	return sb.createVertexTemplateFromCells([bg], bg.geometry.width, bg.geometry.height, '');
			})
		]);
	};

	Sidebar.prototype.addSAPDefaultConnectorsPalette = function(s, gn, sb)
	{
		var dt = 'sap default connector ';
		
		this.addPaletteFunctions('sapDefault Connectors', 'SAP / Default Connectors', false,
		[
			this.addDataEntry('direct one directional', 120, 0, 'Direct one-directional', 'jVJNb4MwDP01uU4Uinre6NpTpUmbtHNoLBI1YGRCC/v1MyR8aaq0QyT7vefn2IlIsrI7k6z1BRVYkbyLJCNE56Oyy8BaEUdGieQo4jjiI+LTE3Y3slEtCSr3n4LYF9ylbcEjHmhcbwMAlXolwgdnucXr7UubSiRv2pV82+OOw8YR3iBDizSWJPtDCoeUmZyLZT46DULCtlIwtI44Y+5k7GTC2af5GZT72fLbKKcH/iUdMUluo+F8ulqFFUxYcB16+GlAFfB0QSMUtnMGLMFRz5JH6M1s6ncYaTCFdluMwEpn7lt72fi0mO3mDh9ouPEiabClKwR0/VCTsAvO4SHnQh60APenkPch+5WsHgTNWsHBatAFGn/GlC4/0MvXH/QX'),
			this.addDataEntry('direct bidirectional', 120, 0, 'Direct bidirectional', 'jVJJbsMwDHyNroVjx8i5ddKcCgRNgZ6VmLDVyKJBy1n6+lKLlxQN0IMAzXA4JCWKrGiuW5Jt/YYlaJFtRFYQog235lqA1iJNVCmytUjThI9IXx9EFz6atJLA2P8kpCHhLHUPgQlEZ286EmDKZyK8MDpoPJ4+amVE9lLbhrtdL/jaWcITFKiRfEq2XOWbVc6RAyfLg3dyQsLelOBKJ4w49qr0YMJor76dculQWcE+9sCjKHt7By2tQrOZIlxYkv2rOR+YmXs8s//qm3awN2hgoILCNccJFdgdkGrAAu1beVSmcnb5OPGnKm3tqCfHhYdzjT/8C0/Fj9gCsjPdWHKJPhzNw3clNaiqtvcc+Rc439vLLsBqtBsr7FBx4UnSYU9HiOx8JwbhNTrHnRkT41v8TuTLbIyJ8is2wGmVg3y+6T8='),
			this.addDataEntry('indirect one directional', 120, 0, 'Indirect one-directional', 'jVJJbsMwDHyNroVjx8i5dZZTgaAp0LMSEZYaWTJoOUtfX2rxkgIBehAgDmeGpERWVM1th7yV71aAZsWGFRVa6+KtuVWgNcszJVixZnme0WH59kl2EbJZyxGM+48gj4IL1z1EJAKdu+sEgBGviPZK0VHb0/lTKsOKN+ka6na9oGvn0J6hstpikBTLVQmrkjJHEvNjcPJEtL0R4EtnFFFuq/RgQtFB/Xjm0keihkPqgUZR7v4BmjtlzWbKUGGObmjOWDNiyTcb4pnzd9+0g3OSBCgyvIIENbg9oGrAAR5aflKm9m36kQTvZBhhmvxLCSc98uIJ8QH9AE//JEDpQ3ZgqQzeiXJNPpQt47dlElQt3SOG4SUuj/a8i2E92o0V9lZR4YnS2R5PkND5bgzEW3JOuzMK08P8FdJlNsYEhVUbwmmlI32+8b8='),
			this.addDataEntry('indirect bidirectional', 120, 0, 'Indirect bidirectional', 'jVJNb8IwDP01uU6lBXHeCuM0CY1JOwditRlpXLkpH/v1cz5KyzSkHSLF7z0/24lFUTaXDcm2fkMFRhRrUZSE6OKtuZRgjMgzrUSxEnme8RH56wN2FtislQTW/SchjwknaXqISAQ6dzUJAKueifDM0d7g4fhRayuKl9o13O1qxtfOER6hRIMUUor5cgHLBTN7Tpb74OSFhL1V4EtnHDH3qs1gwtFOf3vl3Eeqgl3qgUfR7voORjqNdj0yXFiS+6u5QEzMQzyx/+qbdrC3aGGAosI3xwkVuC2QbsAB7Vp50Lbydn4uJbs6zDGO/6mVqz3y5AXxFf0UDz8mQOlXNoBchq4sOScfZhfx77IadFW7e4zCc5zu7WUXw+pmd6uwRc2FR0mHPR0godMFGYSX5JwW6JaYHuZ3Il8mY4xQ2LchHPc6yqdr/wM='),
			this.addDataEntry('optional one directional', 120, 0, 'Optional one-directional', 'jVPLasMwEPwaXYtix+TcOo9TITSFnpVosdTIkpHlPPr1Xb1spxDowaCdnZndldakrNvbzrJOvBsOipQbUtbWGBdP7a0GpUhBJSflmhQFxY8U2yfZRcjSjlnQ7j+CIgouTA0QkQj07q4SAJq/WmuuGB2VOZ0/hdSkfBOuxW7XCzz2zpoz1EYZGyTlclVtVhVmjihmx+DkidYMmoMvTTHC3FaqbILRQf545tJHvIFD6gFHke7+AYo5afRmymBhZl1uThs9YsmX5njm/D20XXZOkgBFhlegoAG3BytbcGAPHTtJ3fg2/Uic9SKMME3+JbkTHnnJhD1zqNSBVVBfNl6rH+vpSwUoPdMODBa3d6Rckztmq/iYVIBshHvEbLify6M962PYjHZjhb2RWHii9GawJ0jofGMy8Zac00aNwnRdf4V4mI0xQWEBczgteqTP/4Nf'),
			this.addDataEntry('optional bidirectional', 120, 0, 'Optional bidirectional', 'jVNNb8IwDP01uU6lBXHeCuM0CY1JOwditRlpXLkpH/v1cz5KyzSkHSrFz+8924krirK5bEi29RsqMKJYi6IkRBdPzaUEY0SeaSWKlcjzjD+Rvz7IzkI2ayWBdf8R5FFwkqaHiESgc1eTALDqmQjPHO0NHo4ftbaieKldw92uZnzsHOERSjRIQVLMlwtYLjizZ7HcBydPJOytAl8644hzr9oMJhzt9Ldnzn2kKtilHngU7a7vYKTTaNdjhgtLcn81FxIT8xBP7L/6ph3sLVoYoMjwzbGgArcF0g04oF0rD9pW3s7PpWRXhznG8T+1crVHngbCVjpW2sDKM1823q2f7eFzBSi91QaQi9OVKefkztlFfNGsBl3V7h6jcEmne3vZxbC62d0qbFFz4ZHSYU8HSOh0bQbiJTmntboJ03X9FvJhMsYIhS0cwnHbI336M/wA'),
			this.addDataEntry('direct elbow', 120, 20, 'Direct elbow', 'jVPNTsMwDH6aXlHWbowrK9s4gDRpSJxDa9qwNK5cd6w8PWmTrB0wiUOl+PuxHTuNkrQ6bUnW5TPmoKNkHSUpIbI7VacUtI5iofIoeYjiWNgvijdX2NnAiloSGP6PIXaGhjsNDoG8gL0PkbjEAo3U6xFdEbYmhz6BsNGoeUKsLTiz4Acwd3v11SeRLaOFSq60Z9/RsCdndzZumPAAKWqkoYdkvlyslwuv3MhK6c4Sj6CPwCqTngiGHN5lq+11VyypAN4BqQoYaF/LTJmiL9MnA5P7qvOhqCSexJa9J8JPG75pzA4vpTIO3igdOnedvqqcyx65WYREwWrQQMC8rx+Sm3I/2qt7GiC/pC2gvQB1VkKgJavjpU82LizOurN1h8pmjMXJG/z+Ref3LS4z+Ik50/SdhDxB2GBLGfwS2nvLbiKre0FzvZ9b8XeZS/pHt15tD65ciCaDGqHhgYdw/JGcfPqffQM='),
			this.addDataEntry('optional elbow', 120, 20, 'Optional elbow', 'jVPBTsMwDP2aXlHabowrG9s4gDRpSJxDY9qwNK5Sd6x8PUmTrB0wiUOkvOf3bMdJknxVn7aGN9UzClBJvk7ylUEkv6tPK1AqyZgUSf6QZBmzK8k2V6LpEGUNN6DpP4bMG1rqFXgGRAn7ANFQhSVqrtYjuzTYaQEuAbNo1DwhNpZMLfkBRP1efrkkvCO0VEW1CtF31BSC6Z3FLRk8wAoVmqGHfLaYrxfzoNzwWqreBh5BHYFkwUMgGgS8807Z4y6JmxJoB0bWQGD2DS+kLl0Zlwy0CFVnQ1FuaIJt9N4Y/LTwTWFxeKmk9vRGqti57/RVCqocczOPiaJVo4bIBZ8bkuBtNUwsDWDHyTaoByZjrr6/CDf9q1c5UOEet4D2jKa3EgOKkzxe+njrYXnWna07lDZjxk7BEJ4I68OTYJcZwlC9afqUYp4obLEzBfwS2tHwfiJrnKC93s8t+7vMZfhHt0FtN75cRJNBjdTwByIc/5qXT7/iNw=='),
			this.addDataEntry('indirect elbow', 120, 20, 'Indirect elbow', 'jVPLTsMwEPyaXJGTtJQrLW05gFSpSJxNvCSmjjdyNqXh67Fju0mBShwieWZn9mUnyVf1aWt4Uz2jAJXk6yRfGUTyp/q0AqWSjEmR5A9JljH7JdnmSjQdoqzhBjT9x5B5Q0u9As+AKGEfIBqqsETN1XpklwY7LcAlYBaNmifExpKpJT+AqN/LL5eEd4SWqqhWIfqOmkIwvbO4JYMHWKFCM/SQzxbz9WIelBteS9XbwCOoI5AseAhEg4B33ik77pK4KYF2YGQNBGbf8ELq0pVxyUCLUHU2FOWGJljwthqGSr303hj8tPBNYXF4qaT29EaqOIZv+1UKqhxzM49Zo1WjhsgFn9uYX7nb89VLG6hwY1tAO43prcSA4iSPlz7eeliedWfrDqXNmLFTMITHwPpw+ewyQ1ifN00fTcwThS12poBfQjs37yeyxgna6/3csr/LXIZ/dBvU9uDLRTRZ1EgNrz3C8a/y8ulP9w0='),
			this.addDataEntry('plain direct', 120, 0, 'Plain direct', 'jVLLboMwEPwaXysCQTm35HGKFJVDz05YgVvjRYvJo1/f9SNAIkXqAckzOzPrNSuyor3uSHbNHivQItuIrCBEG07ttQCtRZqoSmRrkaYJfyLdvqgufDXpJIGx/zGkwXCWeoDABKK3Nx0JMNU7EV4YGTRMfjS25YuuF3zsLeEPFKiRvDpbrnJY5Vw5sk8efYgTEg6mAtc1YcS1rdJ6QqX6dcqlQ1UNZWzPUyh7+wQtrUKzmSrcWJJ9upfnZrkez5K/h7a7J0eLp4LCOdhQgz0AqRYsUNnJkzK1GyEfh/1SlW0c9ea48Fzuzi//gKfi8+8AOZluLLnEHK7m4SclDai6sY8c+eHPj/GyD7Ae48YOB1TceJL0ONAJIjvfhLvwGpPjpozG+BbPRj7Mxpgov1h3OC1wkM/3+w8='),
			this.addDataEntry('plain indirect', 120, 0, 'Plain indirect', 'jVLLboMwEPwaXysCQTm35HGKFDWHnp14BW6NFy0mj359148EEilSD0je2ZlZxl5RVO1lQ7JrtqjAiGIliooQXTy1lwqMEXmmlSiWIs8z/kS+ftGdhW7WSQLr/iPIo+AkzQARiUDvriYBYNU7EZ65smgZ/Ghcyz+6nPGxd4Q/UKFBCuxivihhUXLnwDp5CCaeSDhYBX5qxhX31tqYsdrrX8+c+0rVsE/jOYV2108w0mm0q7HDgyW5p/8K2MQ31BPn76Htbs5JEqDI8AoW1OB2QLoFB7Tv5FHb2kfwkZTsmxBhTP6llWs88uYJ8e58gJfPEaD0FhtAHkNXppyTD3fL+GJZA7pu3CNG4SZOj/ayj2V9t7tP2KHmwSOlx4GOkNDpWtyIl+Sc1uYuTBfzLOTDJMYIhS27leM2R/p02f8A'),
			this.addDataEntry('plain optional', 120, 0, 'Plain optional', 'jVO7bsMwDPwarYVjJ8jcOo8pQNAMnZWIsNXKkkHTefTrSz0cOwECdDBAHu+OokSLomyuW5RtvXMKjCjWoijROYpRcy3BGJFnWoliJfI840/kmxfVWahmrUSw9B9BHgVnaXqISAQ6upkEgFXviO7CmXWWwY+aGj7oasZhR+h+oHTGYWAX8+VivVxw5cg6eQwmnoiutwp814wzrm20MWN20L+eOfeZquCQ2vMUmm6fYCRpZ9djhRtLpKdzBWziG/KJ83fftINzkgQoMryCBRXQHlA3QICHVp60rfwIfiQluzqMME7+pRXVHnkbCHtJrLSBlWe+bbxRP9bLRwpQeqEtOG6ON6ZckjtXF/Edsxp0VdMjhuF+zo/2sotpdbe7d9g7zY1HSud6PEFCp8syEK/JOS3TXZiu61nIwWSMEQq7N6Tjjkf69Bf4Aw=='),
			this.addDataEntry('default firewall', 120, 0, 'Default firewall', 'jVJNb4MwDP01uVMy1HNHP06VJu3Qc7pYEC1gZEwL+/UzJAWqqdIOkez3np9jJ0rnVX8i05RntOCVPiidEyKHqOpz8F6libNK71WaJnJUenzBbiY2aQxBzf8pSEPBzfgOAhKAlgcfAajtjgjvktVYC/heciUX3W8kbJnwG3L0SJNav22zwzYT5ip15jqZjELCrrYwdk0kE+7ovF+yT/czKvVseXGWy4iEK4Et4OWUExRHPAFWwDSI5B5dhM3CIpISXFHyM0bgDbvbs71pQ1rMdnOHD3TSeJG02NEXRHS97Yewj87xNeZCNlQA/ymUfZthJWtGQbtWSLAadIGm532kyzcK8vUv+wU=')
		]);			
	};

	Sidebar.prototype.addSAPAreaShapesPalette = function(s, gn, sb)
	{
		var dt = 'sap area shapes ';
		
		this.addPaletteFunctions('sapArea Shapes', 'SAP / Area Shapes', false,
		[
			this.addDataEntry('', 160, 160, '', 'jZE9b8MgEIZ/DWuFIU271m6cLpkydKbx1aCcg4XPsdNfXzCQpEOkDkjH894XL0xW3bx1qtc72wAyuWGyctZSjLq5AkQmuGmYfGdCcH+YqB+oxaLyXjk40X8KRCw4KxwhkggGumACzo6nBkJ+wWQ5aUOw79UhqJPf2zNNHSZ5IGePUFm0bqmWnL/wWnjl2yDe8U1Zv9Z+q1K5w978hG5iFa5fg8WR4O2KQ1vTqRY+TUPag/Uqkw8wraaM4uycVTw9e5aeB45gfmjRgpI/W7AdkLv4lCl1ChnraCPXeeI9VEME7bX25rgPkun5evvcRfvz978='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdeJQNflumRNd5k0qYedWeMVVBIi4izpfv1MIGl3qLQDEn5ef2HDZNlMe686/eZqsEzumCy9cxhvzVSCtUxwUzP5woTgdJio7qjZrPJOeWjxPwEiBnwrO0AkEfR4sQl4N7Q1BP+MyWLUBuHQqWNQR+qbmMbGJrlH785QOuv8HC05f+KVIOXLWHvDd0WVV9RVofzxYH5CNrEJ5mfv7IDwvOKQ1jTqBB+mRk1gu1nIK5iTxgXF2otX9vBIrFa9XnsPxrtCBN8SyemZOdE0AfAI090pziiNcA+uAfQXchlTseCxjZPmemnqFqo+gtMae10KXdJeFvO6/1n78z1+AQ=='),
			this.addDataEntry('', 160, 160, '', 'jZJNT8MwDIZ/Ta4oTcbgSss6LkiTduAcFtNEpE2VumvHrydf7cZhEodI8fPazis7hFftvHeiV+9WgiF8R3jlrMV0a+cKjCGMakn4K2GM+kNYfUctokp74aDD/xSwVHAWZoREEhjwYjJwduwkhPyC8HJSGuHYi1NQJ+/bM4WtyfKAzn5DZY11sZpT+kRr5pUvbcwN35X1c+1dlcKdjvondGObEH4O1owILysObXUrGvjQEpUH281C3kA3CheU3l6yiodHz6QY1Oo9BAeBCK6LhNFgLE8AHMJ8d4oR5RHuwbaA7uJTpvxYyNimSVO1mLqFYkigWWuvS/GXvJclvO4/an++xy8='),
			this.addDataEntry('', 168, 168, '', '7VTBToQwEP2aXk1p13Wvgst68bQHz10YaWOhpAwCfr0Fyu6iEE2MNw9NOm/edObNS0p4lLcHK0r5ZFLQhO8Jj6wxON7yNgKtCaMqJfyBMEbdISxeyQZDlpbCQoE/KWBjwZvQNYzICFTYaQ9k1tSlp4FFaGetElMUkKA4TXT6dYSB6vsfwOSAtnOURqUoPWO7G8skqEziJ1BUfpJz7UWRu3hRywL59wKdviKFnh8QHjZSIRxLkfTZxhnjMIm59ukKrXmFyGhjh2pO6R2NnbzwRWl9he/DeBe7IUNhk6N6719jmz48VUbXCPdnuH9W5SKDZ7+Q7WZCHqd1DNDYe2IFN7cOWzXm2gC2bIAv8FvuZtHMHLpkDv29OZt/c1bN+QsDXHj5Wobc7Of5AA=='),
			this.addDataEntry('', 160, 160, '', 'jZFNb8MgDIZ/DdeJQNudt2ztLjv1sDNr3IBmSkScJd2vH59td6g0JCTzvLaB10y2dtl5Neh31wEy+cpk652jHNmlBUQmuOmYfGFC8LCZ2N5Rm6TyQXk40X8KRC74VjhBJhmMdMYCvJtOHcT8hsnnWRuC/aAOUZ3DuwPTZLHII3n3Ba1D51O15PyRb0VQjgbxhh/TClz5w978xG5iFY+fo8OJ4OmCY1tjVQ8fpiMdwGZVyRuYXlNF+e6a1TysAyvfA0+w3LUooeLPDpwF8ueQMpdOMWOTbeS63ngL1ZhBf6m9Oh6CYno9XoebtD+z/wU='),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhutEoOt63bK1u1Sa1MPOrHEDGgkRcZp0Tz8TIO0OlYaEhL/fNsaGybKZdl51eu8qsEy+MVl65zCemqkEa5ngpmLylQnBaTOxvaMWs8o75aHF/wSIGHBWdoBIIujxYhPwbmgrCP4Fky+jNgiHTh2DOlLdxDQ2Nsk9evcNpbPOz9GS8ye+FaScjLU3/DQv4sofD+YnZBOrYH71zg4IzwsOaU2javg0FWoC61Um72BqjRnFu7NX8fBIrFK9XmoPxodCBN8S2dAzN0RTB8AjTHe7OKPUwh24BtBfyGVMlwWPdew017moW6j6COol9joUOqS5ZPM6/1n78z1+AQ=='),
			this.addDataEntry('', 160, 160, '', 'jZJNTwMhEIZ/DVfDQq1nXW29mJj04Bm704UIywZm3a2/Xj639dBEEhLmeecrMxDemmXvxCjfbAea8BfCW2ct5pdZWtCaMKo6wp8JYzRcwnY31CapdBQOBvxPAMsB30JPkEkGHs+6AGenoYPo3xD+NEuFcBjFMapz6DswiUYX2aOzX9BabV2K5pQ+0B0LyklpfcVP6QQu3PGgfmI2tonmp7d6QnhccUyrjOjhQ3UoA9huKnkF1UusKNeuXs3dfWCd8HLtPRrvAhHckAijsbEyAXAIy80pJlRGuAdrAN05uMylWPTY5klTWZu6hsJn0K+xl6WER9lLNS/7T9qf7/EL'),
			this.addDataEntry('', 168, 168, '', 'zVRNT8QgEP01XA2FunrVateLpz14ZtvZQqSlodS2/nop0O7WrR+JMUpCwrz5YN48AqJJ2W81q/mjykEieo9oopUy/lT2CUiJCBY5oneIEGw3IukH3sh5cc00VOY7CcQnvDDZgkc80JhBBqDQqq0RvT0IKRMllXYwPbhl8VABtIF+0UWmqgoyw/ZTJXzenQsNrW1BlWD0YEM6kRseIjbXPo2DKLh5B7ImNDnnHsnaQ+C7zp1+zd1Sr3IY4yPLtOPCwK5m2ejtrGYW46aUwd0YrZ7hZEQYX+GUnI8udcviTGc78TpWI/Fo7hslWwM3MzyWFSUr4CkMZBNPyMM0Dgf5u6eo6OLyM2FOBSDrAoSEMOVhYS3EwWvi4J+LE/+VOPO7/r/i/IYA1jz+Os63+JTeAA=='),
			this.addDataEntry('', 160, 160, '', 'jZG7csMgEEW/hjYjgR51olh2k8pFamJtBJPFaNAqkvP1AYFsp/BMCmaWc/cBd5lozLJ3clBvtgNkYsdE46ylGJmlAUTGM90x8co4z/xhvH2g5quaDdLBmf5TwGPBt8QJIolgpAsm4Ox07iDk50y8zEoTHAd5Curs3+2ZIoNJHsnZL2gsWrdWi6Iud3XplU+NeMfbsq3a2nPpTkf9E7rxIlw/RosTwfMVh7bayB7edUfKg6rYyAF0r2hDcfaWlT+Fqel74AiWhxatKPmzB2uA3MWnzKlTyKiijZnaJt5DOUbQX2tvjvsgmb5db8tdtT+7/wU='),
			this.addDataEntry('', 160, 160, '', 'jZJNb4MwDIZ/Ta4TJAV63VjpLpMm9bBzVjwSLRAUzKD79XNIoN2h0g6R4uf1V+wwUbbz0clevdoaDBMHJkpnLYZbO5dgDOOJrpl4ZpwndBiv7qjpoia9dNDhfwJ4CPiWZoRAAhjwYiJwduxq8P4pE0+T0ginXp69OlHfxBS2JsoDOvsFpTXWLdFiV2SHIiPlUxtzw6usyquCuHTnk/7x2fjOmx+DNSPC44Z9Wt3KBt51jYpAvlvJC+hG4YpC7dUrffBVazmorXdvvElEcB2RPT1zTzROABzCfHeKC4ojPIJtAd2FXKZYzHvkYdKJWpu6hXIIoNlir0uhS9zLal73v2h/vscv'),
			this.addDataEntry('', 160, 160, '', 'jZJNT8QgEIZ/DVfTQj/OWrfrxcRkD55xGQuRlgamtuuvFwrtrodNPJDMPO98ZQbCmn45Wj7KVyNAE3YgrLHGYLT6pQGtCc2UIOyZUJr5R2h7R81XNRu5hQH/k0BjwjfXE0QSgcOLTsCaaRAQ4nPCnmapEE4jPwd19nN7JrHXSXZozRc0Rhu7ZrOiLg916ZVPpfUNb8u2amvPuT2f1E+oRovgfjijJ4THHYeyqucdvCuB0oOq2MgLqE7ihmLvLSp/CF0Fd3KfPThvHBHssBKaUU/TBsAiLHe3uKK0wiOYHtBefMicmoWIKm46k9tQt5C7CLo993oUb6S7bO71/qv253v8Ag=='),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwEP01vZrS8uHVxWW9eNqD5y6MtLFQUoqAv94CZVeQVRPjzUOTznsz05n3kiIaF91Bs4o/qgwkontEY62UmW5FF4OUiGCRIXqPCMH2IJJcYb2RxRXTUJqfFJCp4JXJBiZkAmrTSwfkWjUVorvaaPUCsZJKW6JUpeV3z0LKFeQ6gjbQLaZKVVlCathp7ow/TzumulEPoAowurcprcgMdxnh7VTGQeTcrEBWu6HPtZfl7cXtv60F/V4LK0WZwZDv2U1bLgwcK5YObGs9tBg3hXT0UjBEqB8F+yhYqWbxJEjCJLI40+lRvA3diD+Ep1rJxsDdGR7aioLl8OQECf0ZeZjlGKHp7TnLuwm+MuajAWTbAFfgVO4X0cIcvGUO/r05/r85V835CwNsePmFRm7xSb0D'),
			this.addDataEntry('', 160, 160, '', 'jZHLbsMgEEW/hm1lg5OsWzdJN11l0TWNJwZ1CBYe106/vjyTdBGpSEjMufOACxOtWfZODurddoBMbJlonbWUTmZpAZHxSndMvDLOK78Z3z1Q66hWg3Rwpv8U8FTwLXGCRBIY6YIZODudOwj5NRMvs9IEh0Eegzr7e3umyGCWR3L2C1qL1sVq0WxW283KKyeNeMdPcXku3fGgf0I33oTwc7Q4ETxfcWirjezhQ3ekPFg3hbyB7hUVlGaXrPopTM3PA0ewPLQoouzPHqwBchefMudOIWOdbKxUmXgP5ZhAf629Oe4P2fQS3j43an/+/hc='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdcpgfTjumVdd5lUqYedWeMGNAgRcZp0v34mkLQ7VBoSEn5eGxsbJko77r1s1YerwDCxY6L0zmE82bEEYxjPdMXEK+M8o8342wM1n9SslR4a/E8AjwEXaXqIJIIOryYB7/qmguCfM/EyKI1wbOUpqAPVTUyhNUnu0LtvKJ1xfooWxWa126xIOWtj7vh5WsSlPx31T7iNF8H86pzpEZ4XHK7VVtbwqStUBNbFTN5B1wpnFHPPXvlTyFrJTi21B+MgEcE3RLb0zC3R1AHwCOPDLk4otXAPzgL6K7kMKVnwWMdOZ2ou6h7KLoJ6ib0NhQ5pLrN5m/+k/fkevw=='),
			this.addDataEntry('', 160, 160, '', 'jZLLbsMgEEW/hm2FwUnWrZumm0qVsuiaholBBWPhce3068vLTrqIVCQk5tx5aQbCGzsfvOjVm5NgCN8T3njnML/s3IAxhFEtCX8mjNFwCXu5o1ZJpb3w0OF/AlgO+BZmhEwyGPBiCvBu7CRE/4rwp0lphGMvTlGdQt+BKbSmyAN69wWNM86naF7vNvvdJihnbcwNP6cTuPCno/6J2Vgdzc/BmRHhccUxrbaihQ8tUQWwrRfyCrpVuKBce/GqHmJVKQa19h6Nd4EIvkuEURZomQB4hPnuFBMqIzyAs4D+ElymUix6bPOkqVqauoViyKBdY69LCY+yl8W87j9pf77HLw=='),
			this.addDataEntry('', 168, 168, '', 'zVTLboMwEPwaXytjQ9JrQ5P00lMOPTuwwVYMRsYU6NfXYJMUSh9SVbWWkLwzu8vujGRE47zda1byR5WCRHSLaKyVMu6WtzFIiQgWKaL3iBBsP0R2H7DBwOKSaSjMdwqIK3hmsgaHOKAynfRAplVdIro5CSljJZW2cKEKy24qo9UZZqDvCNpAO5kqUUUBiWHHsTN+P+2Q6kfdg8rB6M6mNCI13Gesbl0ZB5FxMwNZ5Ye+1F6Xtxe//7IW9GstrBRFCn1+YDdtuDBwKFnSs4310GLc5NLTU3UQoeE62q6jmZQW3w3H4kwnB/HSdyNhHx4rJWsDdxe4bytylsGTF2QVjsjDKMcAuX+PWcFN9Jkxbw0gywb4Aq9yN4km5uAlc/DPzQn/ypzTcP61Ob9hgA2vr9DATR6pVw=='),
			this.addDataEntry('', 111, 20, '', 'jVE9T8MwEP01XpFji8JKQtOJqUNn0xyxxSWOLk6T8us5x6aBoRKDpbv3cT4/C111y4HMYN98Ayj0XuiKvA+p6pYKEIWSrhH6VSgl+QhV32GLlZWDIejDfwwqGS4GJ0hIAsZwxQyQn/oGor4QupytC3AczDmyM+/NmA0dZnoM5D+h8uhpdWspn2StbszJNcFG7cMjY4bOR/cVJxU7bj8c4i/rvqyfa168HIBcBwEo3uv6lmkZ3e+jxynAyzaF0fwgoADL3VBWKCdyAM/D6cqSOW8XFUW2WXCtzbYcpjRj6tubdYuYi5zyT7v95sr9+exv'),
			this.addDataEntry('', 111, 20, '', 'jVHBTsMwDP2aXFGaCDhDYTvttAPnsHpNhNtUrks7vh6nCSscJhEpkv2en+M8K1t3y57c4A+xAVT2VdmaYuQcdUsNiMro0Cj7oozRcpXZ3WCrldWDI+j5PwKTBZ8OJ8hIBka+YAEoTn0Dqb5S9nn2geE4uFNiZ5lbMM8dFnpkih9QR4y0qq3Wj3pnrsxbaNin2rt7wRydjuErdaoeJD0HxF/S83oEH4BCBwyU3g19K7RO6vcx4sTwtHURtHwIiGG5acoKFUf2EKU5XaRkLtOliqrIPITWF1kxU7sx5+1VulksQXH5J922uXJ/lv0N'),
			this.addDataEntry('', 111, 20, '', 'jVE9c4MwDP01XnvGLmFOaciUKUNnJ6jYV4E5YQrpr68MbmiH3HXwnfQ+ZPlZ6LKdj2R6e/I1oNAHoUvyPqxVO5eAKJR0tdCvQinJR6jqAZstrOwNQRf+Y1Cr4dPgCCuyAkO4YQLIj10NUZ8J/TJZF+Dcm2tkJ96bMRtaTPQQyH9A6dHT4tbPRX4o8jvz5upgo/YpYoauZ/cVJ2U7bt8d4i9rlVe7qmC8B3ItBKB4r+sapmV0XwaPY4D9NoXR9CCgAPPDUBYoJXIEz8PpxpIpbRcVWbJZcI1NthSmNMPaN3frFjEXKeWfdvvNhfvz2d8='),
			this.addDataEntry('', 111, 20, '', 'jVFNT8MwDP01uaI0YewMZezEaYedw+o1EW5TuSnt9utxPljhMIlIkez3/BznWei6W/ZkBvvuG0Chd0LX5H3IUbfUgCiUdI3Qr0IpyVeotztslVg5GII+/EegsuDL4AQZycAYLlgA8lPfQKyvhH6ZrQtwGMwpsjPPzZgNHRZ6DOQ/ofboKan143az225uzNE1wcbah4gZOh3cNXaqnjg9O8Rf0nM6jA9AroMAFN91fcu0jOqP0eMU4Hntwmj5EFCA5a4pCSqO7MFzc7pwyVymixVVkVlwrS2yYqY0Y87bm3S1mIPi8k+6bjNxf5b9DQ=='),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwFPw1vZrS4srVRXe9eNqD5y48abOFklIE/PWWtuwuCtHEeJOEpG/eTN/HJEU0Lfu9ZjV/VjlIRB8RTbVSxp/KPgUpEcEiR/QBEYLtj8huJRu5LK6Zhsr8REC84I3JFjzigcYMMgCFVm0daKAN9LNSmaoqyAw7TnT8tQVHDfX3oEowerCUTuSGB8Ym8TIOouDmE8ia0MlZe5nIHsJQywPS7we081U5jPwI0W3HhYFDzbIx21ljLMZNKUO6MVqdIFVSaaem+C6hiW1m+yqkvMJ37rM409lBvI+3kXgMj42SrYH7MzxeK0pWwEtYyCaekKdpHQ7ytSdWdHNrsVVjrg0gywYEQdjyMItm5uAlc/DvzYn/zVk15y8MsOHlaXG52cvzAQ=='),
			this.addDataEntry('', 160, 160, '', 'jZHBbsMgDIafhutEoGt73bK1u+zUw86scQOqKRFxmnRPPwjQdodKQ0Iy328b+M1kbaetV53+dA0gk+9M1t45SpGdakBkgpuGyTcmBA+bic0DtZpV3ikPJ/pPgUgFZ4UDJJJATxfMwLvh1EDMr5h8HbUh2HVqH9UxvDswTRaz3JN3R6gdOj9XS75ay/UhKAeDeMc38wpc+f3O/MRuYhGP373DgeDlimNbY1ULX6YhHcByUcgHmFZTQenuklU9PQeWvweeYHpo0YyyP1twFshfQsqYO8WMZbKR63LjPVR9Au219uZ4CLLp5Xgb7qz9mf0v'),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhuuUQNflumVrd5k0qYedWeMGNAgRcZZ0Tz8TIO0OlYaEhL/fNsaGidrOey979eYaMEy8MFF75zCe7FyDMYwXumHimXFe0GZ8d0MtF7XopYcO/xPAY8C3NCNEEsGAZ5OAd2PXQPAvmXialEY49PIY1InqJqbQmiQP6N0X1M44v0SL4qES1YmUkzbmiu+WRVz640H/hGx8E8zPwZkR4XHFIa22soUP3aAisN1k8gq6VZhRvDt7lXf3xBo5qLX2YLxLRPAdkYqeWRFNHQCPMN/s4oJSC/fgLKA/k8uULgse29jpQuWirqEcImjX2MtQ6JDmks3L/Bftz/f4BQ=='),
			this.addDataEntry('', 160, 160, '', 'jZLLbsMgEEW/hm2FIU2zbd0m3USqlEXXNEwMKjYWjGOnX19edtJFpCIhMefOSzMQXrfTzole7a0EQ/gb4bWzFvOrnWowhjCqJeGvhDEaLmHbO2qVVNoLBx3+J4DlgLMwA2SSgceLKcDZoZMQ/SvCX0alEQ69OEZ1DH0HprA1Rfbo7DfU1liXojl92vDNKSgnbcwN36YTuHDHg/6J2dgqml/emgHhecExrW5FA59aogpgvZrJO+hG4Yxy7dmrengMTAqvlt6j8SEQwXWJMMoCLRMAhzDdnWJCZYQ7sC2guwSXsRSLHus8aarmpm6h8Bk0S+x1KeFR9jKb1/0n7c/3+AU='),
			this.addDataEntry('', 168, 168, '', '7VQ9b4MwFPw1XitjpylrAiVdOmXo7MArtmIwMqZAf30NNkloQa1Udetgyb53975OMqJR0R00q/izykAi+ohopJUy7lZ0EUiJCBYZojEiBNuDSLISDcYorpiG0vxEQJzgjckGHOKA2vTSA7lWTeVpoA10s1KpKktIDTtNdPy1hZHq6x9AFWB0bymtyAz3jG3oZBxEzs0nkNW+k4v2OpG9+KGWB6TfD2jnKzMY+AGi+5YLA8eKpUO0tcZYjJtC+nBttDpDpKTSo5rih5CGtpn9q5DyBo93SZzcW5zp9Cjeh2xkMzxPtZKNgd0FHtKKguXw4hey3UzI07SOEXK1J1ZwN2RfNebWALJsgBf4Lfez18wcvGQO/r05m39zVs35CwPs8/q1jLHZz/MB'),
			this.addDataEntry('', 160, 160, '', 'jZFNU8MgEIZ/DVeHQK29atT20lMPnrFsAuNSMmRjUn+9EEhbD53xwMzyvPsB7zJZu2kbVGf2XgMy+cZkHbynHLmpBkQmuNVMvjIheDxMvN9Rq1nlnQpwov8UiFzwrXCATDLo6YwFBD+cNKT8ismX0ViCQ6eOSR3juyMz5LDIPQX/BbVHH+ZqyZ82ctNEpbGIN1yrRjePkatwPNif1E2s0vWz9zgQPF9wamudauHDajIRrFcL2YFtDS0oz16yqofUvXwPAsF016IZFX+24B1QOMeUsXRKGetsIzfLxFuo+gzaS+3V8RgU05frdbmz9mf3vw=='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/Ddcpga7Ldcu27lJpUg87s+IEVBIi4jTpfv1MIGl3qLQDEn5ef2HDRNlMOy87vXcKLBNvTJTeOYy3ZirBWsYzo5h4ZZxndBh/v6Pms5p10kOL/wngMeAs7QCRRNDjxSbg3dAqCP45Ey+jNgiHTh6DOlLfxDQ2Nsk9eneC0lnn52iRPRWiqEipjLU3XMlKVY/EpT8ezE/IxjfB/O6dHRCeVxzSmkbW8GUUagLbzUI+wNQaFxRrL175Q8iuZK/X3oPxKRHBt0QKemZBNE0APMJ0d4ozSiPcgWsA/YVcxlQseGzjpDO9NHULZR9BvcZel0KXtJfFvO5/1v58j18='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdeJQNf1umVbd5k0qYedWXECKoSIOEu6Xz8IkHaHSjsg2c/rL9kQXtt570Wv3p0EQ/gL4bV3DpNl5xqMIYxqSfgzYYyGR9jrDbVaVNoLDx3+J4GlhG9hRkgkgQHPJgPvxk5CjK8If5qURjj04hjVKcwdmEJrsjygdyeonXF+yeb0Ycd3TVAabcwVl6KRzX3gwh8P+idWY5vofg3OjAiPK45ltRUtfGqJKoDtppA30K3CglLvElXdxepSDGqdPTofAhF8txBGWaB5A+AR5ptbXFBe4R6cBfTnEDLlZjFimzZNVRnqGoohgXbNvRwlGPkuxb3cf9H+fI9f'),
			this.addDataEntry('', 168, 168, '', '7VTLboMwEPwaXytjJ6jXhpT00lMOPTuwxVYNRsYU6NfX2CYJLaiVqtyKhOSdnfE+RjKiSdkfNKv5s8pBIvqIaKKVMv5U9glIiQgWOaJ7RAi2PyLpSjZyWVwzDZX5jYB4wTuTLXjEA40ZZAAKrdo60EAb6GelMlVVkBl2muj4ewuOGuofQJVg9GApncgND4z43ss4iIKbLyBrQidn7WUiewhDLQ9Ifx7QzlflMPIjRHcdFwaONcvGbGeNsRg3pQzpxmj1BomSSjs13e5pnNpmdq9Cyis8dZ/Fmc6O4mO8jWzG8NQo2Rp4OMPjtaJkBbyEhcSbCXma1uEgX3tiRXdbi60ac20AWTYgCMKWh1k0MwcvmYP/bs7m35xVc25hgA0vT4vLzV6eTw=='),
			this.addDataEntry('', 160, 160, '', 'jZHBbsMgDIafhuuUQJv7lq3tZacedmbFCWimRMRZ0j39IEDbHSoNCcl8v23gNxOtXfZeDvrdKUAm3phovXOUIru0gMh4ZRQTr4zzKmzGdw/UelWrQXo4038KeCr4ljhBIgmMdMEMvJvOCmJ+zcTLrA3BcZCnqM7h3YFpspjlkbz7gtah82u12CrRdF1QOoN4x3frClz609H8xG58E4+fo8OJ4PmKY1tjZQ8fRpEOoNkUcgDTayoo3V2y6qdtYPl74AmWhxatKPuzB2eB/CWkzLlTzGiSjZUuN95DOSbQX2tvjocgm16Ot+Gu2p/Z/wI='),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhuuUQBv1umVrd6lUqYedWXECGgkRcZZ0Tz8TSNodKg0JCX+/bYwNE2UzHbzs9NEpsEy8MVF65zCemqkEaxnPjGLilXGe0WZ8/0DNZzXrpIcW/xPAY8C3tANEEkGPV5uAd0OrIPjnTLyM2iCcO3kJ6kh1E9PY2CT36N0XlM46P0eLrRJFVZFSGWvv+H5exKW/nM1PyMY3wfzsnR0Qnlcc0ppG1vBhFGoCxWYh72BqjQuKdy9e+dOWmJK9XmsPxkkigm+J7OiZO6KpA+ARpoddnFFq4QFcA+iv5DKmy4JHETud6aWoeyj7COo19jYUOqS5LOZt/rP253v8Ag=='),
			this.addDataEntry('', 160, 160, '', 'jZLLbsMgEEW/hm2FIfG+dZt0U6lSFl3TMDao2Fgwrp1+fXnZSReRioTEnDsvzUB40y9HJ0b1ZiUYwl8Ib5y1mF/90oAxhFEtCX8mjNFwCTvcUauk0lE4GPA/ASwHfAszQSYZeLyYApydBgnRvyL8aVYa4TSKc1Tn0HdgCntTZI/OfkFjjXUpmu8lr9s2KK025oYf0glcuPNJ/8RsbBfNT2/NhPC44ZhW96KDDy1RBVDvVvIKulO4olx79aoe9oFJ4dXWezTeBSK4IRFGWaBlAuAQlrtTTKiM8Ai2B3SX4DKXYtGjzpOmam3qFgqfQbfFXpcSHmUvq3ndf9L+fI9f'),
			this.addDataEntry('', 168, 168, '', '7VQ9b4MwEP01XitjJ6hrQ5p06ZShswMHtmowMkeB/voaMEloQa1UdetgyffuPd/Hk0x4lLdHK0r5bBLQhD8SHlljcLzlbQRaE0ZVQvieMEbdIeywkg2GLC2FhQJ/ImCj4E3oGkZkBCrstAcya+rS08AitLNSsSkKiFGcJzr92sJA9fWPYHJA2zlKoxKUnhHejzIJKpP4CRSV7+SivU7kLn6o5QH59wO6+YoEen5A+K6RCuFUirjPNs4Yh0nMtU9XaM0rREYbO6j5ds/Dg2tmlyqtb/A0gDhNHS5sfFLv/Wts04fnyuga4eEC98+qXGTw4hcSbibkaVrHAI21J1Zwt3XYqjG3BrBlA7zAb7mbRTNz6JI59PfmbP7NWTXnLwxw4fVrGXKzn+cD'),
			this.addDataEntry('', 160, 160, '', 'jZFNU8MgEIZ/DVcngTZ3jVovnnrwjGETGJeSIRuT+uuFAG09dMYDM8vz7ge8y0Rr14OXo353CpCJFyZa7xylyK4tIDJeGcXEM+O8Cofx1ztqvanVKD2c6D8FPBV8S5whkQQmOmMG3s0nBTG/ZuJp0YbgOMouqkt4d2CaLGZ5Iu++oHXo/FYt9ko0fR+U3iDe8L6GbuPSd0fzE7vxXbx+Tg5ngscLjm2NlQN8GEU6gGZXyBuYQVNBaXbJqh/2geXvgSdY71q0oezPAZwF8ueQsuROMaNJNla6TLyFckpguNReHQ9BNr1cr8vdtD+7/wU='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdcpgTbqdcu27jJpUg87s+AEVBIi4izpfv1MIGl3qLQDEn5ef2HDRNnORy97/e4UWCZemCi9cxhv7VyCtYxnRjHxzDjP6DD+ekfNFzXrpYcO/xPAY8C3tCNEEsGAF5uAd2OnIPjnTDxN2iCcelkFdaK+iWlsbZIH9O4MpbPOL9Fir0RR16TUxtobXudQLVz66mR+Qja+C+bX4OyI8LjhkNa0soFPo1ATKHYreQPTaFxRrL165Q97YkoOeus9GB8SEXxH5EDPPBBNEwCPMN+d4oLSCI/gWkB/IZcpFQseRZx0ptembqEcImi22OtS6JL2sprX/S/an+/xCw=='),
			this.addDataEntry('', 160, 160, '', 'jZJNb4MwDIZ/Ta4TJC33jW3tZdKkHnrOiCHREoKCKXS/fvmCdodKO0Syn9dfskNYbZaD44P8sAI0YW+E1c5aTJZZatCa0EIJwl4JpYV/hL4/UMuoFgN30ON/EmhKuHA9QSIJjHjVGTg79QJCfEnYyywVwmngTVBnP7dnEo3O8ojOfkNttXUxm+0Fq9rWK63S+o63JTSRc9ec1E+oRnfB/RqtnhCeNxzKKsM7OCuB0oNqt5IjqE7iilLvNap82nsm+Ci32YPzyRHB9ZHQgnqaNwAOYXm4xYjyCg9gDaC7+pA5NwsRVdp0Ideh7iEfE+i23NtRvJHvsrq3+0ftz/f4BQ=='),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwEP01vZrSrhuvK8p68bQHz90y0sZCSRkE/PUWKLuLQjQxe/PQpH0fnc68pITHebt3olTPNgVD+CPhsbMWx13exmAMYVSnhD8QxqhfhCUrbDSwtBQOCvyNgY2Gd2FqGJERqLAzAcicrcsgA4fQzkpJWxQgURwnOf3+hEEa6u/B5oCu85JGp6iCYns32hToTOEXUFThJSfvuSO/CU0tN8h/btD3V6TQ6yPC7xulEQ6lkD3b+GA8pjA3ga7Q2TeIrbFucHMpKU2lZ161MRd4kiQ02XlcOHnQH/1tbNMfj5U1NcLuBPfX6lxk8BIGst1MyNM0jgEaa0+q6ObWY6vBXAbAlgMIhjDlbnaahUOXwqF/D2fzH85qONcIwB/PX8vAzX6eTw=='),
			this.addDataEntry('', 160, 160, '', 'jZE9b8MgEIZ/DWuFIc2eunW6dMqQmcLFoEKw8Ll2+usLBpJ0iNQB6Xje+4D3CG/dsg9i0B9egSX8jfA2eI85cksL1hJGjSL8lTBG4yGse6A2q0oHEeCM/ylgueBb2AkyyWDEiy0g+OmsIOU3hL/M2iAcBiGTOsd3R6bR2SKPGPwXtN76sFZzKSlVMionY+0d77qOnkTkIsiD+Und2CZdP0dvJ4TdFae2xokejkahjmC7qeQdTK+xojy7ZjVPz5GV70FAWB5atKLizx68AwyXmDKXTiljm22kuk68h2LMoL/W3hyPQTG9Xm/LXbU/u/8F'),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdeJQFf1umVLd5k0qYedWXALKgkRcZZ0v34mkLQ7VNoBCT+vv7BhsmymfVCdefcaHJOvTJbBe0y3ZirBOSa41Uy+MCE4HSaqO2oxq7xTAVr8T4BIAd/KDZBIAj1eXAbBD62G6F8w+Twai3DoVB3VkfomZrBxWe4x+DOU3vkwR8u65lzXpBytcze8qip+VMRVqA/2J2YTm2h+9d4NCE8rjmlto07waTUaAtvNQt7AngwuKNVevIqHR2Ja9WbtPRofChFCS2RHz9wRzROAgDDdneKM8gj34BvAcCGXMReLHts0aW6Wpm6h6hM4rbHXpdAl72Uxr/uftT/f4xc='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdeJQNf7li3tZdKkHnZm4AY0EiJwlnS/fhBI2h0q7YBkP6+/ZEN43c0HLwb95hRYwl8Jr71zmK1ursFawqhRhL8Qxmh8hDV31GpR6SA89PifBJYTvoUdIZMMAl5sAd6NvYIUXxH+PGmDcBqETOoU545MY2eLHNC7L6iddX7J5lJSqmRUzsbaG940DT2LyIWXJ/OTqrFdcj+DsyPC04ZTWdOJFj6MQh3BfreSI5hW44py7zWqeniMTImgt9mT8y4QwfcLYZRFWjYAHmG+u8UFlRUewHWA/hJDptIsRezzpqleh7qFImTQbrnXo0Sj3GV1r/dftD/f4xc='),
			this.addDataEntry('', 168, 168, '', 'zVTBTsQgEP0arobCuvGq1V0vnvbgmaWzhUhLQ6e29eullO5utRtNjFESEubNewwzL4HwtOi2TlTqyWZgCH8gPHXW4ngquhSMIYzqjPB7whj1m7DNhWwSsrQSDkr8joCNgldhGhiREaixNxHInW2qSAOH0M1KSVuWIFHsJzr9/IRAjfW3YAtA13tKqzNUkbG+GWUKdK7wAyjq+JKj9tSRP8SmlhvkXzfo+yszGPgJ4Xet0gi7Ssgh23pjPKawMDFdo7MvkFpjXVBzKSnNpM8ctDFn+CYsjwsnd/ptuI2thnBfW9Mg3B7h4VpdiBye40DWqwl5nMYRoLH2xEqurj120ZhzA9iyAVEQp9zPopk5dMkc+nNzVn9lziGsf23Obxjgw9PXEnKzn+cd'),
			this.addDataEntry('', 160, 160, '', 'jZFNTwMhEIZ/DVfDQu1dV20vnnrwjDBdiFA27Ky79dfLZ1sPTSQhGZ53ZoB3CO/dugti1O9egSX8lfA+eI8lcmsP1hJGjSL8hTBG4ybs7Y7aZZWOIsAJ/1PASsG3sDMUUsCEZ1tB8PNJQcrvCH9etEE4jEImdYnvjkyjs1WeMPgv6L31IVdzKSlVMipHY+0NP+YVuQjyYH5SN7ZJx8/J2xnh6YJTW+PEAB9GoY5gu2lkD2bQ2FC5u2V1D4+R1e9BQFjvWpRR9WcH3gGGc0xZaqeUsS02Ut1uvIViKmC41F4dj0E1vR2vw83an9n/Ag=='),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhutEoKt63bKtu1Sq1MPOLLgBjYSIOEu6p58JJO0OlYaEhL/fNsaGybKZ9kF15uA1OCZfmSyD95hOzVSCc0xwq5l8YUJw2ky83VGLWeWdCtDifwJECvhWboBEEujx4jIIfmg1RP+CyefRWIRTp6qojlQ3MYONy3KPwX9B6Z0Pc7SsKs51RcrZOnfDz/MirkJ1sj8xm9hE87P3bkB4WnFMaxtVw4fVaAhsNwt5B1sbXFC6e/EqHh6JadWbtfZoHBUihJbIjp65I5o7AAFhutvFGeUW7sE3gOFCLmO+LHpsU6e5WYq6hapPoF5jr0OhQ57LYl7nP2t/vscv'),
			this.addDataEntry('', 160, 160, '', 'jZJNT8QgEIZ/DVdDYd27Vl0vJiZ78IxlthChNDC1XX+9fLW7HjaRhIR53vnKDIS3djl4Mao3J8EQ/kx4653D8rJLC8YQRrUk/IkwRuMl7OWG2mSVjsLDgP8JYCXgW5gJCikg4NlU4N00SEj+DeGPs9IIx1F0SZ1j35EptKbKAb37gtYZ53M07zpKZReVkzbmip/yiVz47qh/Uja2S+ZncGZCeNhwSqut6OFDS1QR7HcreQXdK1xRqb16NXf3kUkR1NZ7Mt4FIvghE0ZZpHUC4BGWm1PMqI7wAM4C+nN0mWux5LEvk6ZqbeoailBAv8VelhIfdS+redl/1v58j18=')
		]);			
	};

	Sidebar.prototype.addSAPDefaultShapesPalette = function(s, gn, sb)
	{
		var dt = 'sap default shapes ';
		
		this.addPaletteFunctions('sapDefault Shapes', 'SAP / Default Shapes', false,
		[
			this.addDataEntry('', 160, 160, '', 'jZE9b8MgEIZ/DWuFIU271m6cLpkydKbx1aCcg4XPsdNfXzCQpEOkDkjH894XL0xW3bx1qtc72wAyuWGyctZSjLq5AkQmuGmYfGdCcH+YqB+oxaLyXjk40X8KRCw4KxwhkggGumACzo6nBkJ+wWQ5aUOw79UhqJPf2zNNHSZ5IGePUFm0bqmWnL/wWnjl2yDe8U1Zv9Z+q1K5w978hG5iFa5fg8WR4O2KQ1vTqRY+TUPag/Uqkw8wraaM4uycVTw9e5aeB45gfmjRgpI/W7AdkLv4lCl1ChnraCPXeeI9VEME7bX25rgPkun5evvcRfvz978='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdeJQNflumRNd5k0qYedWeMVVBIi4izpfv1MIGl3qLQDEn5ef2HDZNlMe686/eZqsEzumCy9cxhvzVSCtUxwUzP5woTgdJio7qjZrPJOeWjxPwEiBnwrO0AkEfR4sQl4N7Q1BP+MyWLUBuHQqWNQR+qbmMbGJrlH785QOuv8HC05f+KVIOXLWHvDd0WVV9RVofzxYH5CNrEJ5mfv7IDwvOKQ1jTqBB+mRk1gu1nIK5iTxgXF2otX9vBIrFa9XnsPxrtCBN8SyemZOdE0AfAI090pziiNcA+uAfQXchlTseCxjZPmemnqFqo+gtMae10KXdJeFvO6/1n78z1+AQ=='),
			this.addDataEntry('', 160, 160, '', 'jZJNT8MwDIZ/Ta4oTcbgSss6LkiTduAcFtNEpE2VumvHrydf7cZhEodI8fPazis7hFftvHeiV+9WgiF8R3jlrMV0a+cKjCGMakn4K2GM+kNYfUctokp74aDD/xSwVHAWZoREEhjwYjJwduwkhPyC8HJSGuHYi1NQJ+/bM4WtyfKAzn5DZY11sZpT+kRr5pUvbcwN35X1c+1dlcKdjvondGObEH4O1owILysObXUrGvjQEpUH281C3kA3CheU3l6yiodHz6QY1Oo9BAeBCK6LhNFgLE8AHMJ8d4oR5RHuwbaA7uJTpvxYyNimSVO1mLqFYkigWWuvS/GXvJclvO4/an++xy8='),
			this.addDataEntry('', 168, 168, '', '7VTBToQwEP2aXk1p13Wvgst68bQHz10YaWOhpAwCfr0Fyu6iEE2MNw9NOm/edObNS0p4lLcHK0r5ZFLQhO8Jj6wxON7yNgKtCaMqJfyBMEbdISxeyQZDlpbCQoE/KWBjwZvQNYzICFTYaQ9k1tSlp4FFaGetElMUkKA4TXT6dYSB6vsfwOSAtnOURqUoPWO7G8skqEziJ1BUfpJz7UWRu3hRywL59wKdviKFnh8QHjZSIRxLkfTZxhnjMIm59ukKrXmFyGhjh2pO6R2NnbzwRWl9he/DeBe7IUNhk6N6719jmz48VUbXCPdnuH9W5SKDZ7+Q7WZCHqd1DNDYe2IFN7cOWzXm2gC2bIAv8FvuZtHMHLpkDv29OZt/c1bN+QsDXHj5Wobc7Of5AA=='),
			this.addDataEntry('', 160, 160, '', 'jZFNb8MgDIZ/DdeJQNudt2ztLjv1sDNr3IBmSkScJd2vH59td6g0JCTzvLaB10y2dtl5Neh31wEy+cpk652jHNmlBUQmuOmYfGFC8LCZ2N5Rm6TyQXk40X8KRC74VjhBJhmMdMYCvJtOHcT8hsnnWRuC/aAOUZ3DuwPTZLHII3n3Ba1D51O15PyRb0VQjgbxhh/TClz5w978xG5iFY+fo8OJ4OmCY1tjVQ8fpiMdwGZVyRuYXlNF+e6a1TysAyvfA0+w3LUooeLPDpwF8ueQMpdOMWOTbeS63ngL1ZhBf6m9Oh6CYno9XoebtD+z/wU='),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhutEoOt63bK1u1Sa1MPOrHEDGgkRcZp0Tz8TIO0OlYaEhL/fNsaGybKZdl51eu8qsEy+MVl65zCemqkEa5ngpmLylQnBaTOxvaMWs8o75aHF/wSIGHBWdoBIIujxYhPwbmgrCP4Fky+jNgiHTh2DOlLdxDQ2Nsk9evcNpbPOz9GS8ye+FaScjLU3/DQv4sofD+YnZBOrYH71zg4IzwsOaU2javg0FWoC61Um72BqjRnFu7NX8fBIrFK9XmoPxodCBN8S2dAzN0RTB8AjTHe7OKPUwh24BtBfyGVMlwWPdew017moW6j6COol9joUOqS5ZPM6/1n78z1+AQ=='),
			this.addDataEntry('', 160, 160, '', 'jZJNTwMhEIZ/DVfDQq1nXW29mJj04Bm704UIywZm3a2/Xj639dBEEhLmeecrMxDemmXvxCjfbAea8BfCW2ct5pdZWtCaMKo6wp8JYzRcwnY31CapdBQOBvxPAMsB30JPkEkGHs+6AGenoYPo3xD+NEuFcBjFMapz6DswiUYX2aOzX9BabV2K5pQ+0B0LyklpfcVP6QQu3PGgfmI2tonmp7d6QnhccUyrjOjhQ3UoA9huKnkF1UusKNeuXs3dfWCd8HLtPRrvAhHckAijsbEyAXAIy80pJlRGuAdrAN05uMylWPTY5klTWZu6hsJn0K+xl6WER9lLNS/7T9qf7/EL'),
			this.addDataEntry('', 168, 168, '', 'zVRNT8QgEP01XA2FunrVateLpz14ZtvZQqSlodS2/nop0O7WrR+JMUpCwrz5YN48AqJJ2W81q/mjykEieo9oopUy/lT2CUiJCBY5oneIEGw3IukH3sh5cc00VOY7CcQnvDDZgkc80JhBBqDQqq0RvT0IKRMllXYwPbhl8VABtIF+0UWmqgoyw/ZTJXzenQsNrW1BlWD0YEM6kRseIjbXPo2DKLh5B7ImNDnnHsnaQ+C7zp1+zd1Sr3IY4yPLtOPCwK5m2ejtrGYW46aUwd0YrZ7hZEQYX+GUnI8udcviTGc78TpWI/Fo7hslWwM3MzyWFSUr4CkMZBNPyMM0Dgf5u6eo6OLyM2FOBSDrAoSEMOVhYS3EwWvi4J+LE/+VOPO7/r/i/IYA1jz+Os63+JTeAA=='),
			this.addDataEntry('', 160, 160, '', 'jZG7csMgEEW/hjYjgR51olh2k8pFamJtBJPFaNAqkvP1AYFsp/BMCmaWc/cBd5lozLJ3clBvtgNkYsdE46ylGJmlAUTGM90x8co4z/xhvH2g5quaDdLBmf5TwGPBt8QJIolgpAsm4Ox07iDk50y8zEoTHAd5Curs3+2ZIoNJHsnZL2gsWrdWi6Iud3XplU+NeMfbsq3a2nPpTkf9E7rxIlw/RosTwfMVh7bayB7edUfKg6rYyAF0r2hDcfaWlT+Fqel74AiWhxatKPmzB2uA3MWnzKlTyKiijZnaJt5DOUbQX2tvjvsgmb5db8tdtT+7/wU='),
			this.addDataEntry('', 160, 160, '', 'jZJNb4MwDIZ/Ta4TJAV63VjpLpMm9bBzVjwSLRAUzKD79XNIoN2h0g6R4uf1V+wwUbbz0clevdoaDBMHJkpnLYZbO5dgDOOJrpl4ZpwndBiv7qjpoia9dNDhfwJ4CPiWZoRAAhjwYiJwduxq8P4pE0+T0ginXp69OlHfxBS2JsoDOvsFpTXWLdFiV2SHIiPlUxtzw6usyquCuHTnk/7x2fjOmx+DNSPC44Z9Wt3KBt51jYpAvlvJC+hG4YpC7dUrffBVazmorXdvvElEcB2RPT1zTzROABzCfHeKC4ojPIJtAd2FXKZYzHvkYdKJWpu6hXIIoNlir0uhS9zLal73v2h/vscv'),
			this.addDataEntry('', 160, 160, '', 'jZJNT8QgEIZ/DVfTQj/OWrfrxcRkD55xGQuRlgamtuuvFwrtrodNPJDMPO98ZQbCmn45Wj7KVyNAE3YgrLHGYLT6pQGtCc2UIOyZUJr5R2h7R81XNRu5hQH/k0BjwjfXE0QSgcOLTsCaaRAQ4nPCnmapEE4jPwd19nN7JrHXSXZozRc0Rhu7ZrOiLg916ZVPpfUNb8u2amvPuT2f1E+oRovgfjijJ4THHYeyqucdvCuB0oOq2MgLqE7ihmLvLSp/CF0Fd3KfPThvHBHssBKaUU/TBsAiLHe3uKK0wiOYHtBefMicmoWIKm46k9tQt5C7CLo993oUb6S7bO71/qv253v8Ag=='),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwEP01vZrS8uHVxWW9eNqD5y6MtLFQUoqAv94CZVeQVRPjzUOTznsz05n3kiIaF91Bs4o/qgwkontEY62UmW5FF4OUiGCRIXqPCMH2IJJcYb2RxRXTUJqfFJCp4JXJBiZkAmrTSwfkWjUVorvaaPUCsZJKW6JUpeV3z0LKFeQ6gjbQLaZKVVlCathp7ow/TzumulEPoAowurcprcgMdxnh7VTGQeTcrEBWu6HPtZfl7cXtv60F/V4LK0WZwZDv2U1bLgwcK5YObGs9tBg3hXT0UjBEqB8F+yhYqWbxJEjCJLI40+lRvA3diD+Ep1rJxsDdGR7aioLl8OQECf0ZeZjlGKHp7TnLuwm+MuajAWTbAFfgVO4X0cIcvGUO/r05/r85V835CwNsePmFRm7xSb0D'),
			this.addDataEntry('', 160, 160, '', 'jZHLbsMgEEW/hm1lg5OsWzdJN11l0TWNJwZ1CBYe106/vjyTdBGpSEjMufOACxOtWfZODurddoBMbJlonbWUTmZpAZHxSndMvDLOK78Z3z1Q66hWg3Rwpv8U8FTwLXGCRBIY6YIZODudOwj5NRMvs9IEh0Eegzr7e3umyGCWR3L2C1qL1sVq0WxW283KKyeNeMdPcXku3fGgf0I33oTwc7Q4ETxfcWirjezhQ3ekPFg3hbyB7hUVlGaXrPopTM3PA0ewPLQoouzPHqwBchefMudOIWOdbKxUmXgP5ZhAf629Oe4P2fQS3j43an/+/hc='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdcpgfTjumVdd5lUqYedWeMGNAgRcZp0v34mkLQ7VBoSEn5eGxsbJko77r1s1YerwDCxY6L0zmE82bEEYxjPdMXEK+M8o8342wM1n9SslR4a/E8AjwEXaXqIJIIOryYB7/qmguCfM/EyKI1wbOUpqAPVTUyhNUnu0LtvKJ1xfooWxWa126xIOWtj7vh5WsSlPx31T7iNF8H86pzpEZ4XHK7VVtbwqStUBNbFTN5B1wpnFHPPXvlTyFrJTi21B+MgEcE3RLb0zC3R1AHwCOPDLk4otXAPzgL6K7kMKVnwWMdOZ2ou6h7KLoJ6ib0NhQ5pLrN5m/+k/fkevw=='),
			this.addDataEntry('', 160, 160, '', 'jZLLbsMgEEW/hm2FwUnWrZumm0qVsuiaholBBWPhce3068vLTrqIVCQk5tx5aQbCGzsfvOjVm5NgCN8T3njnML/s3IAxhFEtCX8mjNFwCXu5o1ZJpb3w0OF/AlgO+BZmhEwyGPBiCvBu7CRE/4rwp0lphGMvTlGdQt+BKbSmyAN69wWNM86naF7vNvvdJihnbcwNP6cTuPCno/6J2Vgdzc/BmRHhccUxrbaihQ8tUQWwrRfyCrpVuKBce/GqHmJVKQa19h6Nd4EIvkuEURZomQB4hPnuFBMqIzyAs4D+ElymUix6bPOkqVqauoViyKBdY69LCY+yl8W87j9pf77HLw=='),
			this.addDataEntry('', 168, 168, '', 'zVTLboMwEPwaXytjQ9JrQ5P00lMOPTuwwVYMRsYU6NfXYJMUSh9SVbWWkLwzu8vujGRE47zda1byR5WCRHSLaKyVMu6WtzFIiQgWKaL3iBBsP0R2H7DBwOKSaSjMdwqIK3hmsgaHOKAynfRAplVdIro5CSljJZW2cKEKy24qo9UZZqDvCNpAO5kqUUUBiWHHsTN+P+2Q6kfdg8rB6M6mNCI13Gesbl0ZB5FxMwNZ5Ye+1F6Xtxe//7IW9GstrBRFCn1+YDdtuDBwKFnSs4310GLc5NLTU3UQoeE62q6jmZQW3w3H4kwnB/HSdyNhHx4rJWsDdxe4bytylsGTF2QVjsjDKMcAuX+PWcFN9Jkxbw0gywb4Aq9yN4km5uAlc/DPzQn/ypzTcP61Ob9hgA2vr9DATR6pVw=='),
			this.addDataEntry('', 111, 20, '', 'jVE9T8MwEP01XpFji8JKQtOJqUNn0xyxxSWOLk6T8us5x6aBoRKDpbv3cT4/C111y4HMYN98Ayj0XuiKvA+p6pYKEIWSrhH6VSgl+QhV32GLlZWDIejDfwwqGS4GJ0hIAsZwxQyQn/oGor4QupytC3AczDmyM+/NmA0dZnoM5D+h8uhpdWspn2StbszJNcFG7cMjY4bOR/cVJxU7bj8c4i/rvqyfa168HIBcBwEo3uv6lmkZ3e+jxynAyzaF0fwgoADL3VBWKCdyAM/D6cqSOW8XFUW2WXCtzbYcpjRj6tubdYuYi5zyT7v95sr9+exv'),
			this.addDataEntry('', 111, 20, '', 'jVHBTsMwDP2aXFGaCDhDYTvttAPnsHpNhNtUrks7vh6nCSscJhEpkv2en+M8K1t3y57c4A+xAVT2VdmaYuQcdUsNiMro0Cj7oozRcpXZ3WCrldWDI+j5PwKTBZ8OJ8hIBka+YAEoTn0Dqb5S9nn2geE4uFNiZ5lbMM8dFnpkih9QR4y0qq3Wj3pnrsxbaNin2rt7wRydjuErdaoeJD0HxF/S83oEH4BCBwyU3g19K7RO6vcx4sTwtHURtHwIiGG5acoKFUf2EKU5XaRkLtOliqrIPITWF1kxU7sx5+1VulksQXH5J922uXJ/lv0N'),
			this.addDataEntry('', 111, 20, '', 'jVE9c4MwDP01XnvGLmFOaciUKUNnJ6jYV4E5YQrpr68MbmiH3HXwnfQ+ZPlZ6LKdj2R6e/I1oNAHoUvyPqxVO5eAKJR0tdCvQinJR6jqAZstrOwNQRf+Y1Cr4dPgCCuyAkO4YQLIj10NUZ8J/TJZF+Dcm2tkJ96bMRtaTPQQyH9A6dHT4tbPRX4o8jvz5upgo/YpYoauZ/cVJ2U7bt8d4i9rlVe7qmC8B3ItBKB4r+sapmV0XwaPY4D9NoXR9CCgAPPDUBYoJXIEz8PpxpIpbRcVWbJZcI1NthSmNMPaN3frFjEXKeWfdvvNhfvz2d8='),
			this.addDataEntry('', 111, 20, '', 'jVFNT8MwDP01uaI0YewMZezEaYedw+o1EW5TuSnt9utxPljhMIlIkez3/BznWei6W/ZkBvvuG0Chd0LX5H3IUbfUgCiUdI3Qr0IpyVeotztslVg5GII+/EegsuDL4AQZycAYLlgA8lPfQKyvhH6ZrQtwGMwpsjPPzZgNHRZ6DOQ/ofboKan143az225uzNE1wcbah4gZOh3cNXaqnjg9O8Rf0nM6jA9AroMAFN91fcu0jOqP0eMU4Hntwmj5EFCA5a4pCSqO7MFzc7pwyVymixVVkVlwrS2yYqY0Y87bm3S1mIPi8k+6bjNxf5b9DQ==')
		]);			
	};

	Sidebar.prototype.addSAPNumbersPalette = function(s, gn, sb)
	{
		var dt = 'sap number default ';
		
		this.addPaletteFunctions('sapNumbers', 'SAP / Numbers', false,
		[
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#223548;strokeColor=none;gradientDirection=east;fillColor=#5b738b;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '1', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#223548;strokeColor=none;gradientDirection=east;fillColor=#5b738b;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '2', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#223548;strokeColor=none;gradientDirection=east;fillColor=#5b738b;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '3', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#223548;strokeColor=none;gradientDirection=east;fillColor=#5b738b;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '4', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#223548;strokeColor=none;gradientDirection=east;fillColor=#5b738b;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '5', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#223548;strokeColor=none;gradientDirection=east;fillColor=#5b738b;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '6', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#223548;strokeColor=none;gradientDirection=east;fillColor=#5b738b;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '7', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#0057D2;strokeColor=none;gradientDirection=east;fillColor=#2395FF;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '1', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#0057D2;strokeColor=none;gradientDirection=east;fillColor=#2395FF;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '2', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#0057D2;strokeColor=none;gradientDirection=east;fillColor=#2395FF;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '3', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#0057D2;strokeColor=none;gradientDirection=east;fillColor=#2395FF;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '4', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#0057D2;strokeColor=none;gradientDirection=east;fillColor=#2395FF;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '5', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#0057D2;strokeColor=none;gradientDirection=east;fillColor=#2395FF;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '6', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#0057D2;strokeColor=none;gradientDirection=east;fillColor=#2395FF;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '7', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#0057D2;strokeColor=none;gradientDirection=east;fillColor=#2395FF;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '8', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#470CED;strokeColor=none;gradientDirection=east;fillColor=#9B76FF;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '1', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#A100C2;strokeColor=none;gradientDirection=east;fillColor=#F65AF2;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '1', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#AA0808;strokeColor=none;gradientDirection=east;fillColor=#FF5C77;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '1', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#256F3A;strokeColor=none;gradientDirection=east;fillColor=#5DC122;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '1', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#C35500;strokeColor=none;gradientDirection=east;fillColor=#FFB300;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '1', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' ')),
			this.createVertexTemplateEntry('ellipse;whiteSpace=wrap;html=1;aspect=fixed;rotation=0;gradientColor=#07838F;strokeColor=none;gradientDirection=east;fillColor=#00CEAC;rounded=0;pointerEvents=0;fontFamily=Helvetica;fontSize=16;fontColor=#FFFFFF;spacingTop=4;spacingBottom=4;spacingLeft=4;spacingRight=4;points=[];fontStyle=1',
					 s * 30, s * 30, '1', 'Default Number', null, null, this.getTagsForStencil(gn, '', dt).join(' '))
		]);			
	};

	Sidebar.prototype.addSAPProductsPalette = function(s, gn, sb)
	{
		var dt = 'sap product ';
		
		this.addPaletteFunctions('sapProducts', 'SAP / Brand Names', false,
		[
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP Ariba',
		    		'SAP Ariba (text only)', null, null, this.getTagsForStencil(gn, '', dt + 'ariba').join(' ')),
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP Concur',
		    		'SAP Concur (text only)', null, null, this.getTagsForStencil(gn, '', dt + 'concur').join(' ')),
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP Fieldglass',
		    		'SAP Fieldglass (text only)', null, null, this.getTagsForStencil(gn, '', dt + 'fieldglass').join(' ')),
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP Signavio',
		    		'SAP Signavio (text only)', null, null, this.getTagsForStencil(gn, '', dt + 'signavio').join(' ')),
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP SuccessFactors',
		    		'SAP SuccessFactors (text only)', null, null, this.getTagsForStencil(gn, '', dt + 'success factors').join(' ')),
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP S/4HANA',
		    		'SAP S/4HANA (text only)', null, null, this.getTagsForStencil(gn, '', dt + 's4 hana').join(' ')),
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP S/4HANA Cloud',
		    		'SAP S/4HANA Cloud (text only)', null, null, this.getTagsForStencil(gn, '', dt + 's4 hana cloud').join(' ')),
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP Customer Experience',
		    		'SAP Customer Experience (text only)', null, null, this.getTagsForStencil(gn, '', dt + 'customer experience').join(' ')),
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP Business Network',
		    		'SAP Business Network (text only)', null, null, this.getTagsForStencil(gn, '', dt + 'business network').join(' ')),
		    this.createVertexTemplateEntry('text;html=1;align=left;verticalAlign=middle;resizable=0;points=[];autosize=1;strokeColor=none;fillColor=none;fontSize=16;fontColor=#1A2733;fontFamily=Helvetica;fontStyle=1', 120, 30, 
		    		'SAP BTP',
		    		'SAP BTP (text only)', null, null, this.getTagsForStencil(gn, '', dt + 'btp').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'',
		    		'SAP', null, null, this.getTagsForStencil(gn, '', dt + '').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'Concur',
		    		'SAP Concur', null, null, this.getTagsForStencil(gn, '', dt + '').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'Signavio',
		    		'SAP Signavio', null, null, this.getTagsForStencil(gn, '', dt + '').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'SuccessFactors',
		    		'SAP SuccessFactors', null, null, this.getTagsForStencil(gn, '', dt + '').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'Business Network',
		    		'SAP Business Network', null, null, this.getTagsForStencil(gn, '', dt + '').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'Customer Experience',
		    		'SAP Customer Experience', null, null, this.getTagsForStencil(gn, '', dt + '').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'S/4HANA',
		    		'SAP S/4HANA', null, null, this.getTagsForStencil(gn, '', dt + '').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'S/4HANA Cloud',
		    		'SAP s/4HANA Cloud', null, null, this.getTagsForStencil(gn, '', dt + '').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'Ariba',
		    		'SAP Ariba', null, null, this.getTagsForStencil(gn, '', dt + '').join(' ')),
		    this.createVertexTemplateEntry('image;image=img/lib/sap/SAP_Logo.svg;editableCssRules=.*;verticalLabelPosition=middle;labelBackgroundColor=none;verticalAlign=middle;imageAspect=0;labelPosition=right;align=left;fontSize=16;fontStyle=1;spacingLeft=0;fontColor=#002A86;spacing=0;', 37, 19, 
		    		'LeanIX',
		    		'SAP LeanIX', null, null, this.getTagsForStencil(gn, '', dt + '').join(' '))
		]);			
	};

	Sidebar.prototype.addSAPBuildWorkzonePalette = function(s, gn, sb)
	{
		var dt = 'sap build work zone workzone ';
		
		this.addPaletteFunctions('sapBuild Workzone', 'SAP / Build Workzone', false,
		[
			this.addDataEntry('', 920, 659, '', 'tVbbbqMwEP0apO5KqcDk0j5CmrQPrRRtKlXal5UBh1g1mDUmSffrd3xLIBAp2nYrtbWPZ84MM8cDXjgvDo8CV9sXnhHmhQsvnAvOpVkVhzlhzEM+zbzwwUPIh18PLS+cBvrUr7AgpbzGARmHHWYNMYgBavnBLCB4U2ZE2QdeGO+3VJJ1hVN1uoe8AdvKgtnjWgr+TuaccaG9Q9+f+UsEJxvKWAtfxMu7JWQVY5Gu6R/FhsZqm9ScNZJER1jR0gLn5I1mcgvAdOyQJ0LzrXSQie2sgtsJYPbxiJDkcLFEGrL1eSS8IFJ8gIl1uDcV9D/MdnxvtnsbB3Z3oTXZunxgOw0siGsD5EfmUz9gYVsy3J6w1574ddXrkK6FqwlAtMiBmNEE/tbQIbRcR6tfzzznt/UuB0OSUYkTRuZ1/aNhRCV4+x1wKIq0FVcloylmzzghbMVrKikv4aygWabixkwdxDh9z7VAXGtLXpKWe8Ro3nHTOUZ1RVIVyXdErQjC1DDG1pWRjdpueCmdIqZub2uglQeapGX+rK01sbLoKBFFd9OTpbW6SiFoWCEtDYSzvgQCKxVBGJZ0Rzr0Q7KwEVacQuCjAFFXgOhMV3yzqYnsqeqY5lVCG/eEtm4SnKbQWqCeMtWBjO5gmUtdNANBKcuOFqe/G+66NdrbWkRgUnJRYGZcrc05mfK5TFbr3iuqAFWHQaKXhkk6mjPeZI4TntvQdkOpi6FT78Gdh/zSSTieTRazSX8SbvTPf5+EA3fbXU7Jq8/et8A/Qa+KziCfuVzOoav+id8fv8HA+B2HXzB+JwNvR6OUZFCoCRcZEaPUNDfSruJmNGrj33RZ/JaNyJMbSHaupB0gs0BjZA3PxT+9IP61EouaoMh/oDgXuIDV4oCLilnXNy7e4d9PNaFPgk8uyh16JruaPpPIxSEvCCSsXjB2xlZqoOk+TGJv8qCYGsnrk6q7l8W+Q9r3xEEtUaL+iA8ylIXObokLypRqngjbEZXoJ78H2tMeDUjuHxQH29O3nhnb7U/Bvw=='),
			this.addDataEntry('', 360, 179, '', '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'),
			this.addDataEntry('', 120, 257, '', '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'),
			this.addDataEntry('', 340, 380, '', '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'),
			this.addDataEntry('', 322, 344, '', '7Vtbc6JME/413nwXWxyNXiKYSFYwKq6LNxYCiyCKxUGFX/92z6BBTdwkuzFbX7mpLZlTT/fTT7c9o9Z4ebl7iK31XIscN6zx7Rovx1GU0qflTnbDsMYxvlPjlRrHMfC/xt2/MsqSUWZtxe4qfcsCji5I0jx0aY/reO6wbEZxOo+8aGWF7efeVhxlK8dFAQy0nud0o2gNnSx0Bm6a5kO/QCFWlkbQNU+XYTmapHG0cOUojGKyJ88wd8w9ByPuypHiONpC9ypaubTn3g/DcjO6cuw76RxlfROxL8pi231yY3/ppm48XFu2v/JgWMQVqRV7bvrSKAxS49HiI/ioRNrF0y4qhnY1zkEmC0uEH9wItopzmBK7oZX6m2PpVkKb3mFeuRQst/LKhHXkr9KkIvkJO2DCjo6LdSowp81m/djTJ7ObwoXZ8EB337cqZjx3Ee68zKMSpo0VZqW1Q+kJOlqZHzo1DjbjWXTHUxzZbpJUeiSgxxJQilZnVEzm1hoflzsPA+RbYq2/+TZM5FuhNXPDpyjxyUJescEVLrCptXHj1LeBjCcTZlEK+8AEK/S9F1dI5UCKLD5l2kusVURFUhQY+QUErfS3lfb9PZoGWjs+bFMZu5fxrzKm+LFrlzpu3SRFDZM1dEH7l7/DMGsBlCoxW4GnKYF0WgI5rcAHikRHm7EKp6C7Sp6joe7u1UTxCofLBQLNI8y2RAR9XiaPuet78/S47yWSV8h2kUvCGZdaWeKvTmizXofgNcqbQ+8wzRw/uhHpt0TaIzqt4Dgt0XudR2VGgk6xVROVv8Msdp88rkAt8Y1pClBJbix6RzoigH1qAuKYu6vRpP4KTQwrWVRYIlOf3XjyFp4gdlN5r/1nEqV5vbequ68onytF8iyM7IUx91dHlTJ7TgRaKV+qu8vtBDLPitNK+9UamntbDd04r6Gbn1RDn5W9bJ05qnvZfdW8F1EaR1c9e/69xfhJec3y76rGT6b/cTneOEtgirsOIzTIzhLMKM9ZzFrBOx/juL+sLEQNrUvvff7S8sixzPFTaxa6cpIMstBFkL7970IeW/qOQ9hPMmDLshceiYM9GcvT3mlSOyw7Sy5EEWnfy+x74NmxUqvGS7TJ3Scbr8a1dhA9nPzU0blJ3hJm411mF4xvdQaMrUSbLu/wTi7yWi5u7KW90QJpq8nNwlnavtqZrCc/HXnGe03VZ7bdYOR1DSnTh1KuD4VcD0xPCzxffZiH1tiJHIXxSbvjrCedQfQ0VPfz/CffDNyH9p08lDzQhXHHu1DtDET7YdRUV4PQ7fQ3Jq8XaiBkNt/fqp3Es/nBxpbZYMbtNnYQefbS8b8rGtuVpZ2uLBJVUVl9uLhTO4zXXemMNmzBs87MeCk1uWYy49W62nlcmb63hTWCnm9B3/b2u5F4v4ZSo8tTPQ66GbvFZDwpDu3+ojF7CLPJ+D4f8I/zyUMYzlZ9b3J4HvyYLUMG8XR+6qEd6ltzrIcGJ/6wuRHgsMgRAy0XdpqhQtt7bhcmju+gXXSDPq/Lqucq7aYatDO9WOxUv7WeAJ79oQo+fPR1wTSSR9SIotIKZg/3Be5M0PIbv5+FMjeT5aSY/OzjPn63EJYqP5/3tovHJ7mZWGMxNH8+duzl/cIa/8gc5TDe6HKDcLLSKrs8dVpz58HzJsswmSmIwGPyXdZb34eqh5obhsp0gzanyxLXDUxOf9AyXZF23QC9JnCaoma64YH15lbzBbGn9D1NljLNkMTuUNhqhpcBG3f4rBsjeLYLJ2jD+jarL/BVE1WlnWnFAtdt4Rm8CzICkFFo3ExmdtoQkFZUTwf5uvIj6CIbUZbR5+CZ1YIFyG3jfgLokGvGIgW5eQ/k4bgejKAtQXQw4JU26gJzQg1sANlSrslCoRWTOezDQ1SATjarKhLqsyPrFTsl9o01eG1ve0MG9huxMLbTg35KPQ99hslAH6cbk7GeC6IWPKLMokdkop1UpioLvGa0U43YMU903KPwUmAUa+ZC3jPUcp+97og/2kb3sHOBgTmZpoAOgU3w0YNBAjJhfMSpihPAGsRiqxca4KgKYGsBOjFa4YH/FjmMMzrFimIX9He9IW3rgZQ7QT/rKSZvFpLXDRZMD+zTFZQNzFbUvIt7FSZ/aA9BNvoO5xV9HrGBLII2bsG36A8B8S9xQ/8d+nC/LuKkaOX8kOsafbCvzxuKieOA3SjrGaMC+MAQ7viwJjAFJ0B9VXamwGuhMSrMhygF/9F216DtHwHYHWiFoSDnwF85rpd4E/dXNNS3xN0E2aiTXfrSTAm+ikdsAz7nBy4BHsgh5EMP4oDgTHHYY4Dx4VE/e2kZI7gPiRHdUEUqi/CB+MFdAN9lmF9onmbYINMrzNJvBDuiH8hFPwbUHxAHAnILdBEJRxQb4nHE6YSn6FsvL+2jsTuk+xHcyb4jgei2RGxG1KeGvY/HlHKMcg/wB/ttAWyGuaaok5joA7dwr0W+x+wZR8AI91AW4BsppToK256Bckfgf2IrPHsQexCHAeLU32IsgrwSM5JvtgeuEBmgm1zGPrGXxAHGdf0oj+L7AzcpBCwDzs8vMS2nD6eT0P2VltV9WT+SEuOk2hfFeqvB/Z1qv4Gl7VEpxYhn5f/+3F8t//c10p+U/82zMqtjaF3YjIHzcKXEGrhrxCwqpd8Oi5cOiwRCvFCYVmD71BPjXeOYQULjagdIlnmhUk9Sf3W7EX/71UIFsWnixhsfD56fSpjmEWEOueQahGHPCCNHqxUitvHTW355G2OqkE2H16AMW298HWe4c86c3gIo0dLybwnnjfQh6E0pZldKOcf04fc+vQZ9zj/clcMow1sjI7ZWyTqK0wqTNGtlee7SLe/Tbmy6xCYC5PQA47QC3lXT0VX5JJwR4/alk6ML8xKga3zp5PzCXDi+MOdP7stLy0/vy8/lMCdX3OznXLyf6vulX4Nhxf9javPiX6C2+JXUFvkj5wsnyexfo/bh88V/gtr1G7UvU7v+ldSuH1Nb/Ci12RNqc59DbZ79l7J2GWaVAjd2Laxvy89G/WQdWudn6yr/3XAWbT+X+sKd2L4T/+gLAK/x/2LRwvz2CwLEeHjeV94vFOGHcv30bvjyB8KXb47PwvETA20fEHXxY5F1eslYF7+xzed/jZOAfSXOPsLuxo247yDulzGLE/4Os0DOtZjVvDHrHcwiU17SkgxU9PwyCvKnH4p9kIIg55iCn8XA8tctNwb+UW6rFrH7uuwKJSt3XAJ+OP+dXa1fLQEeALzR7xoJsHqy2l9KX+F9+TR9vZmXjROCvzEPvvurpy9v88HTETSff35Ip1d/nfgf'),
			this.addDataEntry('', 480, 642, '', '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'),
			this.addDataEntry('', 1128, 98.13, '', '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')
		]);			
	};

	Sidebar.prototype.addSAPSemanticAccentPalette = function(s, gn, sb)
	{
		var dt = 'sap semantic accent ';
		
		this.addPaletteFunctions('sapSemantic Accent', 'SAP / Semantic Accent', false,
		[
			this.addDataEntry('', 168, 168, '', '7VRNT4QwEP01vZrS4saroq4XT3vw3IWBNhZKyiDgr7fQsrsoRBPjzUOTzntvOh8vKeFJ2e+tqOWzyUAT/kB4Yo1Bfyv7BLQmjKqM8HvCGHWHsMcNNppYWgsLFf4kgfmEN6Fb8IgHGhx0AApr2jrIwCL0i1KpqSpIURxnOf3awiQN9fdgSkA7OEmnMpRBsbvxaRJUIfETKJrQySn3PJG7hKHWB+TfD+jmqzIY9RHhd51UCIdapCPbOWMcJrHUgW7QmldIjDZ2yuaZ648Kx+RK6ws8z0HkscOFTQ/qfXyNTeGxMbpFuD3B47OqFAW8hIXs4hl5mtcxQb72rIqurh22acylAWzdgJAQtjwsooU5dM0c+ntz4n9zNs35CwNceP5aJm7x83wA'),
			this.addDataEntry('', 160, 160, '', 'jZFNU8MgEIZ/DVeHQO1do7YXTz14xrIJjEvJkI1J/fUSPtp66IwHZpbn3Q94l8nWLbugBvPuNSCTr0y2wXvKkVtaQGSCW83kCxOCx8PE2x21SSofVIAT/adA5IJvhRNkksFIZywg+OmkYc1vmHyejSU4DOq4qnN8d2SGHBZ5pOC/oPXoQ6qWWnDFVVQ6i3jDuw5Ut4lchePB/qzdRLp+jh4ngqcLXttap3r4sJpMBNtNJXuwvaGK8uya1Tw8Rla+B4FguWtRQsWfHXgHFM4xZS6d1oxttpGbOvEWqjGD/lJ7dTwGxfR6vS43aX92/ws='),			
			this.addDataEntry('', 160, 160, '', 'jZJNT8MwDIZ/Ta6oTca0KxQYFySkHTibxV0i0qZKXdrx63GatBuHSRwixc/rr9gRqmqmfYDOvHmNTqhnoargPaVbM1XonJCF1UI9CSkLPkK+3FDLWS06CNjSfwJkCvgGN2AiCfR0dhkEP7Qao38p1ONoLOGhg2NUR+6bmaHGZbmn4L+w8s6HOVppWUABrNTWuSte1wj1hjmE48H+xGxyNj977wbChxXHtLaBE35YTYbBdrOQV7QnQwtKtRev8u6emYberL1H4x2IMLRMdvzMHdM8AQyE080pziiPcI++QQpndhlzseixTZMuzNLUNYQ+gdMae1kKX/JeFvOy/1n78z1+AQ=='),
			this.addDataEntry('', 160, 160, '', 'jZJNT8MwDIZ/Ta4oTcbuUGBckJB24GwWt4lImyp1acevJ1/txmESh0j28/pLdpisu+XgYdBvTqFl8pnJ2jtH2eqWGq1lghvF5BMTgofHxMsNtUoqH8BjT/9JEDnhG+yEmWQw0tkW4N3UK4zxFZOPszaExwFOUZ3D3IFp6myRR/LuC2tnnU/ZUgkOHILSGGuveNMgNLvAwZ+O5idWE8n9HJ2dCB82HMuaDlr8MIp0APvdSl7RtJpWlHuvUdXdfWAKRr3NHp13IELfJyK4CLRsAD3hcnOLCZUVHtB1SP4cQubSLEbs86a5Xoe6hjBm0G65l6MEo9xldS/3T9qf7/EL'),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwEP01vZrSrhuviu568bQHz10YaWOhpAwC/npLW3YXhWhivElC0nnzXufjJSU8Lfu9FbV8Mjlowh8IT60xGE5ln4LWhFGVE35PGKPuJ2y3kk18ltbCQoU/EbAgeBO6hYAEoMFBR6Cwpq0jDSxCPyuVmaqCDMVxotOvLXhqrL8HUwLawVE6laOMjO1NkElQhcRPoGhiJyfteSJ3iEMtD8i/H9DNV+Uw8hPC7zqpEA61yMZs54xxmMRSx3SD1rxCarSxXs1z1x8VLvOitL7Ad/5zuLDZQb2Pt7HNGB4bo1uE2xM8XqtKUcBzXMh2MyGP0zo8FGpPrOTq2mGrxlwawJYNiIK45WEWzcyhS+bQ35uz+Tdn1Zy/MMCF56fF52Yvzwc='),
			this.addDataEntry('', 160, 160, '', 'jZHBbsMgDIafhutEoOt9y9b2slMPPbPiBTRTIuI06Z5+EKDtDpWGhGS+3zbwm8nWzdugevPhNSCT70y2wXvKkZtbQGSCW83kGxOCx83E5oHaLCrvVYAT/adA5IKzwhEyyWCgCxYQ/HjSkPIbJl8nYwn2vTomdYrvjsyQwyIPFPw3tB59WKqlFlxxFZUvi3jHN8uKXIXj3v6kbmKVjp+Dx5Hg5YpTW+tUBweryUSwXlWyA9sZqijfXbOap+fIyvcgEMwPLVpQ8WcL3gGFS0yZSqeUsc42clNvvIdqyKC71t4cj0ExvR5vw120P7P/BQ=='),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhutEoKt63bK1u0ya1MPOrHgBDUJEnCXd088EknaHSkNCwt9vG2PDZO2nQ1SdeQ0aHJPPTNYxBMwnP9XgHBPcaiafmBCcNhP7G2o1q7xTEVr8T4DIAd/KDZBJBj2eXQExDK2G5F8x+Tgai3Ds1CmpI9VNzKB3Re4xhi+ogwtxjpZacMUVKZ/WuSu+nxdxFU9H+5OyiU0yP/rgBoSHFae01qsG3q1GQ2C7WcgL2MbggvLdi1d1d09Mq96stSfjTSFCbIns6Jk7oqUDEBGmm12cUWnhAYIHjGdyGctlyWObO83NUtQ1VH0GzRp7GQodylwW8zL/WfvzPX4B'),
			this.addDataEntry('', 160, 160, '', 'jZJNT8MwDIZ/Ta4oTcbuUNi4ICHtsLNZTBORNlXqrh2/nny1G4dJRIoUP6+/ZIfJup33Hnr97hRaJl+ZrL1zlF/tXKO1THCjmHxhQvBwmdjdUauk8h48dvSfAJEDzmBHzCSDgS62AO/GTmH0r5h8nrQhPPRwiuoU+g5MU2uLPJB331g763yKlkpw4BCUL2PtDd+lEzj408H8xGxiE83PwdmR8GnFMa1pocGjUaQD2G4W8oam0bSgXHvxqh4eA1Mw6LX3aHwAEfouEcFFoGUC6Annu1NMqIxwj65F8pfgMpVi0WObJ8310tQthCGDZo29LiU8yl4W87r/pP35Hr8='),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwEP01vZrSLhuviu568bQHz10YobFQUgYBf72lLbuLQjQxe5OEpPM+Op2+pIQnZb83oi6edQaK8EfCE6M1+lXZJ6AUYVRmhD8Qxqj9CdutsJFjaS0MVPgbA/OGd6Fa8IgHGhxUAHKj2zrIwCD0s1apripIURwnOf1+BCcN/fegS0AzWEknMyyCYnvrbQXIvMAvoGjCSU7e80R2EYZaHpD/PKCdr8pg1EeE33eFRDjUIh3ZzgZjsQJLFegGjX6DRCttnJunPI4ptcyrVOoC37nP4sKkB/kx7sY2Y3lstGoR7k7wuK0sRQ4v4UK2mwl5mq7DQb73pIpuYoutBnMZAFsOIBjCLQ+zahYOXQqH/j2czX84q+FcIwBbnp8Wx81enk8='),
			this.addDataEntry('', 160, 160, '', 'jZHBbsMgDIafhutEoOl9y9buslMPPbPEC2imRMRp0j39IEDbHSoNCcl8v23gN5ONXfZeDfrDdYBMvjHZeOcoRXZpAJEJbjomX5kQPGwmdg/UalX5oDyc6D8FIhWcFU6QSAIjXTAD76ZTBzG/YvJl1obgMKg2qnN4d2CaLGZ5JO++oXHo/FotW1nXnAflyyDe8d26Ale+PZif2E1s4vFzdDgRPF9xbGus6uFoOtIBbDeFvIPpNRWU7i5Z1VMdWP4eeILloUUryv7swVkgfwkpc+4UM7bJRq7LjfdQjQn019qb4yHIppfjbbir9mf2vw=='),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhutEoKl63bK1u0yq1MPOLPECKgkRcZp0Tz8TSNodKg0JCX+/bYwNk0UzHbzq9IerwDL5xmThncN4aqYCrGWCm4rJVyYEp83E/oGazSrvlIcW/xMgYsBF2QEiiaDHq03Au6GtIPhnTL6M2iCcOlUGdaS6iWlsbJJ79O4MhbPOz9GylHnOOSnfxto7vp8XceXLk/kJ2cQmmF+9swPC84pDWtOoGj5NhZrAdrOQdzC1xgXFuxev7CknVqler7UH46gQwbdEdvTMHdHUAfAI08Muzii18ACuAfRXchnTZcFjGzvN9VLUPVR9BPUaexsKHdJcFvM2/1n78z1+AQ=='),
			this.addDataEntry('', 160, 160, '', 'jZLLTsMwEEW/xlvk2E33EGi7QULqgrWJh9jCiSNnQlK+Hj/TsqiEJUuec+elGRPe9OvRiVG9WgmG8BfCG2ctple/NmAMYVRLwp8JY9Rfwg531CqqdBQOBvxPAEsB38LMkEgCE15MBs7Og4TgXxH+tCiNcB5FG9TF9+2Zwt5keUJnv6CxxroYzVte15R65VMbc8MP8XguXHvWPyEb2wXzY7JmRnjccEire9HBu5aoPNjvCjmB7hQWlGoXr+qh9kyKSW29B+NNIIIbImGUeZonAA5hvTvFiPIIj2B7QHfxLksuFjz2adJUlaZuoZgS6LbY61L8I++lmNf9R+3P9/gF'),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwEP01vZrSLmSvirpePO3BcxcG2lgoKYOAv94CZXdRiCbGm4cm7fvodOYlJTwuuoMVlXw2KWjCHwiPrTE47YouBq0Joyol/J4wRt0i7HGDDUaWVsJCiT8xsMnwJnQDEzIBNfbaA7k1TeVlYBG6RanElCUkKE6znH59wij19Q9gCkDbO0mrUpReEe0nmwSVS/wEitq/5Oy9dOQ2vqn1Bvn3Dbr+yhQGfUD4XSsVwrESycC2LhiHSSy0p2u05hVio40d3TzhYUipYzKl9RWeZdk+jRwubHJU78NtbDccT7XRDcLtGR6uVYXI4cUPJNrNyNM8jhGaas+q4CZ02GYw1wGw9QC8wU+5X5wW4dC1cOjvw9n9h7MZzl8E4I6Xr2XkFj/PBw=='),
			this.addDataEntry('', 160, 160, '', 'jZE9b8MgEIZ/DWuFIba6tm6TLp0ydKbmbFAhWPhcO/31BQNJOkTqgHQ8733Ae4S3dj14Map3J8EQ/kp4653DFNm1BWMIo1oS/kIYo+EQtr+jVptKR+HhhP8pYKngW5gZEklgwrPJwLv5JCHmV4Q/L0ojHEfRRXUJ7w5MoTVZntC7L2idcX6r5h2va0qD0mtjbnjf94+yCVz47qh/Yje2i9fPyZkZ4emCY1ttxQAfWqIKoNkV8gZ6UFhQml2yqoc6sPw98AjrXYs2lP05gLOA/hxSltwpZjTJRqrKxFsopgSGS+3V8RBk08v1utxN+7P7Xw=='),
			this.addDataEntry('', 160, 160, '', 'jZJNb4QgEIZ/DdcGYTVeW9tuL02a7KFnKqOQRTE4Vre/viDobg+b9EDCPO98MQPhVbccnRjUu5VgCH8hvHLWYrx1SwXGEEa1JPyZMEb9Iez1jpqtKh2Egx7/E8BiwLcwE0QSwYgXk4CzUy8h+GeEP81KI5wGUQd19n17prAzSR7R2TNU1li3RvOa5zmlXmm0MTe8aZpSFp4LV5/0T8jGDsH8Gq2ZEB53HNLqTrTwqSUqD4rDRt5Atwo3FGtvXtlD7pkUo9p7D8aHQATXe1L6Z5aepgmAQ1juTnFFaYRHsB2gu3iXORULHkWcNFVbU7dQjBG0e+x1Kf6S9rKZ1/2v2p/v8Qs='),
			this.addDataEntry('', 160, 160, '', 'jZJNT8QgEIZ/DVdDYdt41arrxcRkD56xTAsRSkOntuuvFwrtrodNPJDMPO98ZQbCa7scvRjUm5NgCH8mvPbOYbLsUoMxhFEtCX8ijNHwCHu5oRarSgfhocf/JLCU8C3MBIkkMOLZZODd1EuI8QXhj7PSCKdBNFGdw9yBKbQmyyN69wW1M86v2bzhZUlpUFptzBVv2/ZeVoEL35z0T6zGDtH9HJ2ZEB52HMtqKzr40BJVANVhI6+gO4UbSr23qOKuDEyKUe2zR+ddIILvV8IoCzRvADzCcnOLK8orPIKzgP4cQubcLEZUadNUbUNdQzEm0O25l6MEI99lcy/3X7U/3+MX'),
			this.addDataEntry('', 168, 168, '', '7VTBToQwEP2aXk1pdzd4VNT14mkPnrsw0GYLJaUI+PW2tOwuCtHEePPQpPPem5nOvKSIJmW/16zmLyoDiegjoolWyvhb2ScgJSJYZIg+IEKwPYg8rbDRyOKaaajMTxKIT3hjsgWPeKAxgwxAoVVbBxloA/2sVaqqClLDjpMcf33CKA3996BKMHqwkk5khgfFLvZpHETBzSeQNeEl59zLRPYShloekH4/oJ2vysDpI0TvOy4MHGqWOrazxliMm1IGujFanSBRUukxm0ZxfBvFlsmFlFd4vs0ZbC3OdHoQ764a2bjw2CjZGrg7w66sKFkBr2Ehu82EPE/rGCHfe1JFN676qjHXBpBlA0JC2PIwi2bm4CVz8O/N2fybs2rOXxhgw8vXMnKzn+cD'),
			this.addDataEntry('', 160, 160, '', 'jZE9b8MgEIZ/DWtlQxK5Y+u26dIpQ2Yanw3KESx8jp3++oKBJB0idUA6nvc+4D0majNvnezVl20AmXhnonbWUozMXAMi44VumHhjnBf+MP7xQC0XteilgxP9p4DHgrPEESKJYKALJuDseGog5JdMvE5KE+x6eQjq5N/tmSKDSR7I2SPUFq1bqkVZVc9l5ZVWI97xdt1KWHsu3WGnf0I3vgrX78HiSPByxaGtNrKDvW5IebBZZfIJulOUUZyds8qn0D19DxzB/NCiBSV/tmANkLv4lCl1ChmbaGOh8sR7KIcIumvtzXEfJNPz9bbcRfuz+18='),
			this.addDataEntry('', 160, 160, '', 'jZI9b8MgEIZ/DWtlQxK5Y+u26RKpUobONJwNKjYWnGOnv75gwEmHSB2QuOe9L+4grO7mveWDPBgBmrBXwmprDMZbN9egNaGFEoS9EEoLfwh9u6OWi1oM3EKP/wmgMeDM9QiRRODwohOwZuwFBP+SsOdJKoTjwE9BnXzfnknsdJIdWvMNtdHGLtGsrKrHsvJKo7S+4c224bD1nNvTUf2EbHQTzC9n9IjwtOKQVnW8hU8lUHqw22TyDqqVmFGsnb3Kh5BdcCfX3oPxwRHB9p5U/pmhsTQBsAjz3SkuKI1wD6YDtBfvMqViwWMXJ13I3NQt5C6Cdo29LsVf0l6yed3/ov35Hr8='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdcpgbbKjlu2dZdKk3rYmRUnoJEQgdOk+/WDAGl3qLQDkv28/pINYXU37y0f5MEI0IS9ElZbYzBa3VyD1oQWShD2Qigt/CP07Y5aLmoxcAs9/ieBxoQz1yNEEoHDi07AmrEXEOJLwp4nqRCOAz8FdfJzeyax00l2aM031EYbu2Szsqoey8orjdL6hjfbhsPWc25PR/UTqtFNcL+c0SPC04pDWdXxFj6VQOnBbpPJO6hWYkaxd44qH0J1wZ1cZw/OB0cE2y+EFtTTtAGwCPPdLS4orXAPpgO0Fx8ypWYhYhc3Xcg81C3kLoJ2zb0exRvpLtm93n/R/nyPXw=='),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwEP01vRpo1w0eFd314mkPnrsw0sZCSRkE/PWWtuwuCtHEeJOEpPM+Op2+pISlZb83vBZPOgdF2ANhqdEa/arsU1CK0EjmhN0TSiP7E7pbYWPHRjU3UOFPDNQb3rhqwSMeaHBQASiMbusgA4PQz1pluqogQ36c5NHXIzhp6L8HXQKawUo6maMIim3ibQJkIfATyJtwkpP3PJFdhKGWB2TfD2jnq3IY9TFhd52QCIeaZyPb2WAsJrBUgW7Q6FdItdLGuVmcJDdxYpkXqdQFvnOfxbnJDvJ93I1uxvLYaNUi3J7gcVtZ8gKew4VsNxPyOF2Hg3zvSRVfXVtsNZjLAOhyAMEQbnmYVbNwoqVwot+Hs/kPZzWcvwjAluenxXGzl+cD'),
			this.addDataEntry('', 160, 160, '', 'jZHBbsMgDIafhusUoKuy45at3aWnHnZmjRfQTImI06R7+kGAtjtUGhKS+X7bwG8mGztvver1zrWATL4x2XjnKEV2bgCRicq0TL4yIaqwmdjcUfmiVr3ycKT/FIhUcFI4QiIJDHTGDLwbjy3EfM7ky6QNwb5Xh6hO4d2BabKY5YG8+4bGofNLteR1/cTroHwZxBu+WVbgyh/25id2E6t4/BwcjgTPFxzbGqs6+DAt6QDWq0LewXSaCkp3lyz+8BhY/h54gvmuRQvK/mzBWSB/DilT7hQz1snGSpcbb6EaEugutVfHQ5BNL8frcBftz+x/AQ=='),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhuuUQFdlxy1bu8ukST3szIoXUEmIwFnSPf1MIGl3qDQkJPz9tjE2TNTttPey129OgWXihYnaO4fp1E41WMt4YRQTz4zzgjbjuxtqOatFLz10+J8AngK+pR0gkQQCnm0G3g2dguhfMvE0aoNw6OUxqiPVTUxja7Mc0LsT1M46P0eLsqoeyoqUL2PtFd/Ni7j0x4P5idn4JpqfwdkB4XHFMa1pZQMfRqEmsN0s5BVMo3FB6e7Fq7y7J6Zk0Gvt0XiXiOA7IhU9MxaWOwAeYbrZxRnlFu7BtYD+TC5jvix6bFOnC70UdQ1lSKBZYy9DoUOey2Je5j9rf77HLw=='),
			this.addDataEntry('', 160, 160, '', 'jZLLTsMwEEW/xlvk2KUKSwi0bJCQumBtmiG2aseRPSEpX49fScuiEpYsec6dl2ZMeGPmvRODfLMtaMJfCG+ctZhfZm5Aa8Koagl/JozRcAnb3VCrpNJBOOjxPwEsB3wLPUImGXg86wKcHfsWon9F+NMkFcJhEMeoTqHvwCQaXWSPzp6gsdq6FM2run6o6qB8Ka2v+C6dwIU7HtRPzMY20fz0Vo8IjyuOaZURHXyoFmUA281CXkF1EheUay9e1d19YK3wcu09Gu8CEVyfCKMs0DIBcAjzzSkmVEa4B2sA3Tm4TKVY9NjmSVO5NHUNhc+gW2MvSwmPspfFvOw/aX++xy8='),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwFPw1vZrS4srVRXe9eNqD5y48abOFklIE/PWWtuwuCtHEeJOEpG/eTN/HJEU0Lfu9ZjV/VjlIRB8RTbVSxp/KPgUpEcEiR/QBEYLtj8huJRu5LK6Zhsr8REC84I3JFjzigcYMMgCFVm0daKAN9LNSmaoqyAw7TnT8tQVHDfX3oEowerCUTuSGB8Ym8TIOouDmE8ia0MlZe5nIHsJQywPS7we081U5jPwI0W3HhYFDzbIx21ljLMZNKUO6MVqdIFVSaaem+C6hiW1m+yqkvMJ37rM409lBvI+3kXgMj42SrYH7MzxeK0pWwEtYyCaekKdpHQ7ytSdWdHNrsVVjrg0gywYEQdjyMItm5uAlc/DvzYn/zVk15y8MsOHlaXG52cvzAQ=='),
			this.addDataEntry('', 160, 160, '', 'jZHBbsMgDIafhutEoGt73bK1u+zUw86scQOqKRFxmnRPPwjQdodKQ0Iy328b+M1kbaetV53+dA0gk+9M1t45SpGdakBkgpuGyTcmBA+bic0DtZpV3ikPJ/pPgUgFZ4UDJJJATxfMwLvh1EDMr5h8HbUh2HVqH9UxvDswTRaz3JN3R6gdOj9XS75ay/UhKAeDeMc38wpc+f3O/MRuYhGP373DgeDlimNbY1ULX6YhHcByUcgHmFZTQenuklU9PQeWvweeYHpo0YyyP1twFshfQsqYO8WMZbKR63LjPVR9Au219uZ4CLLp5Xgb7qz9mf0v'),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhuuUQNflumVrd5k0qYedWeMGNAgRcZZ0Tz8TIO0OlYaEhL/fNsaGidrOey979eYaMEy8MFF75zCe7FyDMYwXumHimXFe0GZ8d0MtF7XopYcO/xPAY8C3NCNEEsGAZ5OAd2PXQPAvmXialEY49PIY1InqJqbQmiQP6N0X1M44v0SL4qES1YmUkzbmiu+WRVz640H/hGx8E8zPwZkR4XHFIa22soUP3aAisN1k8gq6VZhRvDt7lXf3xBo5qLX2YLxLRPAdkYqeWRFNHQCPMN/s4oJSC/fgLKA/k8uULgse29jpQuWirqEcImjX2MtQ6JDmks3L/Bftz/f4BQ=='),
			this.addDataEntry('', 160, 160, '', 'jZLLbsMgEEW/hm2FIU2zbd0m3USqlEXXNEwMKjYWjGOnX19edtJFpCIhMefOSzMQXrfTzole7a0EQ/gb4bWzFvOrnWowhjCqJeGvhDEaLmHbO2qVVNoLBx3+J4DlgLMwA2SSgceLKcDZoZMQ/SvCX0alEQ69OEZ1DH0HprA1Rfbo7DfU1liXojl92vDNKSgnbcwN36YTuHDHg/6J2dgqml/emgHhecExrW5FA59aogpgvZrJO+hG4Yxy7dmrengMTAqvlt6j8SEQwXWJMMoCLRMAhzDdnWJCZYQ7sC2guwSXsRSLHus8aarmpm6h8Bk0S+x1KeFR9jKb1/0n7c/3+AU='),
			this.addDataEntry('', 168, 168, '', '7VQ9b4MwFPw1XitjpylrAiVdOmXo7MArtmIwMqZAf30NNkloQa1Udetgyb53975OMqJR0R00q/izykAi+ohopJUy7lZ0EUiJCBYZojEiBNuDSLISDcYorpiG0vxEQJzgjckGHOKA2vTSA7lWTeVpoA10s1KpKktIDTtNdPy1hZHq6x9AFWB0bymtyAz3jG3oZBxEzs0nkNW+k4v2OpG9+KGWB6TfD2jnKzMY+AGi+5YLA8eKpUO0tcZYjJtC+nBttDpDpKTSo5rih5CGtpn9q5DyBo93SZzcW5zp9Cjeh2xkMzxPtZKNgd0FHtKKguXw4hey3UzI07SOEXK1J1ZwN2RfNebWALJsgBf4Lfez18wcvGQO/r05m39zVs35CwPs8/q1jLHZz/MB'),
			this.addDataEntry('', 160, 160, '', 'jZFNU8MgEIZ/DVeHQK29atT20lMPnrFsAuNSMmRjUn+9EEhbD53xwMzyvPsB7zJZu2kbVGf2XgMy+cZkHbynHLmpBkQmuNVMvjIheDxMvN9Rq1nlnQpwov8UiFzwrXCATDLo6YwFBD+cNKT8ismX0ViCQ6eOSR3juyMz5LDIPQX/BbVHH+ZqyZ82ctNEpbGIN1yrRjePkatwPNif1E2s0vWz9zgQPF9wamudauHDajIRrFcL2YFtDS0oz16yqofUvXwPAsF016IZFX+24B1QOMeUsXRKGetsIzfLxFuo+gzaS+3V8RgU05frdbmz9mf3vw=='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/Ddcpga7Ldcu27lJpUg87s+IEVBIi4jTpfv1MIGl3qLQDEn5ef2HDRNlMOy87vXcKLBNvTJTeOYy3ZirBWsYzo5h4ZZxndBh/v6Pms5p10kOL/wngMeAs7QCRRNDjxSbg3dAqCP45Ey+jNgiHTh6DOlLfxDQ2Nsk9eneC0lnn52iRPRWiqEipjLU3XMlKVY/EpT8ezE/IxjfB/O6dHRCeVxzSmkbW8GUUagLbzUI+wNQaFxRrL175Q8iuZK/X3oPxKRHBt0QKemZBNE0APMJ0d4ozSiPcgWsA/YVcxlQseGzjpDO9NHULZR9BvcZel0KXtJfFvO5/1v58j18='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdeJQNf1umVbd5k0qYedWXECKoSIOEu6Xz8IkHaHSjsg2c/rL9kQXtt570Wv3p0EQ/gL4bV3DpNl5xqMIYxqSfgzYYyGR9jrDbVaVNoLDx3+J4GlhG9hRkgkgQHPJgPvxk5CjK8If5qURjj04hjVKcwdmEJrsjygdyeonXF+yeb0Ycd3TVAabcwVl6KRzX3gwh8P+idWY5vofg3OjAiPK45ltRUtfGqJKoDtppA30K3CglLvElXdxepSDGqdPTofAhF8txBGWaB5A+AR5ptbXFBe4R6cBfTnEDLlZjFimzZNVRnqGoohgXbNvRwlGPkuxb3cf9H+fI9f'),
			this.addDataEntry('', 168, 168, '', '7VTLboMwEPwaXytjJ6jXhpT00lMOPTuwxVYNRsYU6NfX2CYJLaiVqtyKhOSdnfE+RjKiSdkfNKv5s8pBIvqIaKKVMv5U9glIiQgWOaJ7RAi2PyLpSjZyWVwzDZX5jYB4wTuTLXjEA40ZZAAKrdo60EAb6GelMlVVkBl2muj4ewuOGuofQJVg9GApncgND4z43ss4iIKbLyBrQidn7WUiewhDLQ9Ifx7QzlflMPIjRHcdFwaONcvGbGeNsRg3pQzpxmj1BomSSjs13e5pnNpmdq9Cyis8dZ/Fmc6O4mO8jWzG8NQo2Rp4OMPjtaJkBbyEhcSbCXma1uEgX3tiRXdbi60ac20AWTYgCMKWh1k0MwcvmYP/bs7m35xVc25hgA0vT4vLzV6eTw=='),
			this.addDataEntry('', 160, 160, '', 'jZHBbsMgDIafhuuUQJv7lq3tZacedmbFCWimRMRZ0j39IEDbHSoNCcl8v23gNxOtXfZeDvrdKUAm3phovXOUIru0gMh4ZRQTr4zzKmzGdw/UelWrQXo4038KeCr4ljhBIgmMdMEMvJvOCmJ+zcTLrA3BcZCnqM7h3YFpspjlkbz7gtah82u12CrRdF1QOoN4x3frClz609H8xG58E4+fo8OJ4PmKY1tjZQ8fRpEOoNkUcgDTayoo3V2y6qdtYPl74AmWhxatKPuzB2eB/CWkzLlTzGiSjZUuN95DOSbQX2tvjocgm16Ot+Gu2p/Z/wI='),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhuuUQBv1umVrd6lUqYedWXECGgkRcZZ0Tz8TSNodKg0JCX+/bYwNE2UzHbzs9NEpsEy8MVF65zCemqkEaxnPjGLilXGe0WZ8/0DNZzXrpIcW/xPAY8C3tANEEkGPV5uAd0OrIPjnTLyM2iCcO3kJ6kh1E9PY2CT36N0XlM46P0eLrRJFVZFSGWvv+H5exKW/nM1PyMY3wfzsnR0Qnlcc0ppG1vBhFGoCxWYh72BqjQuKdy9e+dOWmJK9XmsPxkkigm+J7OiZO6KpA+ARpoddnFFq4QFcA+iv5DKmy4JHETud6aWoeyj7COo19jYUOqS5LOZt/rP253v8Ag=='),
			this.addDataEntry('', 160, 160, '', 'jZLLbsMgEEW/hm2FIfG+dZt0U6lSFl3TMDao2Fgwrp1+fXnZSReRioTEnDsvzUB40y9HJ0b1ZiUYwl8Ib5y1mF/90oAxhFEtCX8mjNFwCTvcUauk0lE4GPA/ASwHfAszQSYZeLyYApydBgnRvyL8aVYa4TSKc1Tn0HdgCntTZI/OfkFjjXUpmu8lr9s2KK025oYf0glcuPNJ/8RsbBfNT2/NhPC44ZhW96KDDy1RBVDvVvIKulO4olx79aoe9oFJ4dXWezTeBSK4IRFGWaBlAuAQlrtTTKiM8Ai2B3SX4DKXYtGjzpOmam3qFgqfQbfFXpcSHmUvq3ndf9L+fI9f'),
			this.addDataEntry('', 168, 168, '', '7VQ9b4MwEP01XitjJ6hrQ5p06ZShswMHtmowMkeB/voaMEloQa1UdetgyffuPd/Hk0x4lLdHK0r5bBLQhD8SHlljcLzlbQRaE0ZVQvieMEbdIeywkg2GLC2FhQJ/ImCj4E3oGkZkBCrstAcya+rS08AitLNSsSkKiFGcJzr92sJA9fWPYHJA2zlKoxKUnhHejzIJKpP4CRSV7+SivU7kLn6o5QH59wO6+YoEen5A+K6RCuFUirjPNs4Yh0nMtU9XaM0rREYbO6j5ds/Dg2tmlyqtb/A0gDhNHS5sfFLv/Wts04fnyuga4eEC98+qXGTw4hcSbibkaVrHAI21J1Zwt3XYqjG3BrBlA7zAb7mbRTNz6JI59PfmbP7NWTXnLwxw4fVrGXKzn+cD'),
			this.addDataEntry('', 160, 160, '', 'jZFNU8MgEIZ/DVcngTZ3jVovnnrwjGETGJeSIRuT+uuFAG09dMYDM8vz7ge8y0Rr14OXo353CpCJFyZa7xylyK4tIDJeGcXEM+O8Cofx1ztqvanVKD2c6D8FPBV8S5whkQQmOmMG3s0nBTG/ZuJp0YbgOMouqkt4d2CaLGZ5Iu++oHXo/FYt9ko0fR+U3iDe8L6GbuPSd0fzE7vxXbx+Tg5ngscLjm2NlQN8GEU6gGZXyBuYQVNBaXbJqh/2geXvgSdY71q0oezPAZwF8ueQsuROMaNJNla6TLyFckpguNReHQ9BNr1cr8vdtD+7/wU='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdcpgTbqdcu27jJpUg87s+AEVBIi4izpfv1MIGl3qLQDEn5ef2HDRNnORy97/e4UWCZemCi9cxhv7VyCtYxnRjHxzDjP6DD+ekfNFzXrpYcO/xPAY8C3tCNEEsGAF5uAd2OnIPjnTDxN2iCcelkFdaK+iWlsbZIH9O4MpbPOL9Fir0RR16TUxtobXudQLVz66mR+Qja+C+bX4OyI8LjhkNa0soFPo1ATKHYreQPTaFxRrL165Q97YkoOeus9GB8SEXxH5EDPPBBNEwCPMN+d4oLSCI/gWkB/IZcpFQseRZx0ptembqEcImi22OtS6JL2sprX/S/an+/xCw=='),
			this.addDataEntry('', 160, 160, '', 'jZJNb4MwDIZ/Ta4TJC33jW3tZdKkHnrOiCHREoKCKXS/fvmCdodKO0Syn9dfskNYbZaD44P8sAI0YW+E1c5aTJZZatCa0EIJwl4JpYV/hL4/UMuoFgN30ON/EmhKuHA9QSIJjHjVGTg79QJCfEnYyywVwmngTVBnP7dnEo3O8ojOfkNttXUxm+0Fq9rWK63S+o63JTSRc9ec1E+oRnfB/RqtnhCeNxzKKsM7OCuB0oNqt5IjqE7iilLvNap82nsm+Ci32YPzyRHB9ZHQgnqaNwAOYXm4xYjyCg9gDaC7+pA5NwsRVdp0Ideh7iEfE+i23NtRvJHvsrq3+0ftz/f4BQ=='),
			this.addDataEntry('', 168, 168, '', '7VRNT4QwEP01vZrSrhuvK8p68bQHz90y0sZCSRkE/PUWKLuLQjQxe/PQpH0fnc68pITHebt3olTPNgVD+CPhsbMWx13exmAMYVSnhD8QxqhfhCUrbDSwtBQOCvyNgY2Gd2FqGJERqLAzAcicrcsgA4fQzkpJWxQgURwnOf3+hEEa6u/B5oCu85JGp6iCYns32hToTOEXUFThJSfvuSO/CU0tN8h/btD3V6TQ6yPC7xulEQ6lkD3b+GA8pjA3ga7Q2TeIrbFucHMpKU2lZ161MRd4kiQ02XlcOHnQH/1tbNMfj5U1NcLuBPfX6lxk8BIGst1MyNM0jgEaa0+q6ObWY6vBXAbAlgMIhjDlbnaahUOXwqF/D2fzH85qONcIwB/PX8vAzX6eTw=='),
			this.addDataEntry('', 160, 160, '', 'jZE9b8MgEIZ/DWuFIc2eunW6dMqQmcLFoEKw8Ll2+usLBpJ0iNQB6Xje+4D3CG/dsg9i0B9egSX8jfA2eI85cksL1hJGjSL8lTBG4yGse6A2q0oHEeCM/ylgueBb2AkyyWDEiy0g+OmsIOU3hL/M2iAcBiGTOsd3R6bR2SKPGPwXtN76sFZzKSlVMionY+0d77qOnkTkIsiD+Und2CZdP0dvJ4TdFae2xokejkahjmC7qeQdTK+xojy7ZjVPz5GV70FAWB5atKLizx68AwyXmDKXTiljm22kuk68h2LMoL/W3hyPQTG9Xm/LXbU/u/8F'),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdeJQFf1umVLd5k0qYedWXALKgkRcZZ0v34mkLQ7VNoBCT+vv7BhsmymfVCdefcaHJOvTJbBe0y3ZirBOSa41Uy+MCE4HSaqO2oxq7xTAVr8T4BIAd/KDZBIAj1eXAbBD62G6F8w+Twai3DoVB3VkfomZrBxWe4x+DOU3vkwR8u65lzXpBytcze8qip+VMRVqA/2J2YTm2h+9d4NCE8rjmlto07waTUaAtvNQt7AngwuKNVevIqHR2Ja9WbtPRofChFCS2RHz9wRzROAgDDdneKM8gj34BvAcCGXMReLHts0aW6Wpm6h6hM4rbHXpdAl72Uxr/uftT/f4xc='),
			this.addDataEntry('', 160, 160, '', 'jZJNb8MgDIZ/DdeJQNf7li3tZdKkHnZm4AY0EiJwlnS/fhBI2h0q7YBkP6+/ZEN43c0HLwb95hRYwl8Jr71zmK1ursFawqhRhL8Qxmh8hDV31GpR6SA89PifBJYTvoUdIZMMAl5sAd6NvYIUXxH+PGmDcBqETOoU545MY2eLHNC7L6iddX7J5lJSqmRUzsbaG940DT2LyIWXJ/OTqrFdcj+DsyPC04ZTWdOJFj6MQh3BfreSI5hW44py7zWqeniMTImgt9mT8y4QwfcLYZRFWjYAHmG+u8UFlRUewHWA/hJDptIsRezzpqleh7qFImTQbrnXo0Sj3GV1r/dftD/f4xc='),
			this.addDataEntry('', 168, 168, '', 'zVTBTsQgEP0arobCuvGq1V0vnvbgmaWzhUhLQ6e29eullO5utRtNjFESEubNewwzL4HwtOi2TlTqyWZgCH8gPHXW4ngquhSMIYzqjPB7whj1m7DNhWwSsrQSDkr8joCNgldhGhiREaixNxHInW2qSAOH0M1KSVuWIFHsJzr9/IRAjfW3YAtA13tKqzNUkbG+GWUKdK7wAyjq+JKj9tSRP8SmlhvkXzfo+yszGPgJ4Xet0gi7Ssgh23pjPKawMDFdo7MvkFpjXVBzKSnNpM8ctDFn+CYsjwsnd/ptuI2thnBfW9Mg3B7h4VpdiBye40DWqwl5nMYRoLH2xEqurj120ZhzA9iyAVEQp9zPopk5dMkc+nNzVn9lziGsf23Obxjgw9PXEnKzn+cd'),
			this.addDataEntry('', 160, 160, '', 'jZFNTwMhEIZ/DVfDQu1dV20vnnrwjDBdiFA27Ky79dfLZ1sPTSQhGZ53ZoB3CO/dugti1O9egSX8lfA+eI8lcmsP1hJGjSL8hTBG4ybs7Y7aZZWOIsAJ/1PASsG3sDMUUsCEZ1tB8PNJQcrvCH9etEE4jEImdYnvjkyjs1WeMPgv6L31IVdzKSlVMipHY+0NP+YVuQjyYH5SN7ZJx8/J2xnh6YJTW+PEAB9GoY5gu2lkD2bQ2FC5u2V1D4+R1e9BQFjvWpRR9WcH3gGGc0xZaqeUsS02Ut1uvIViKmC41F4dj0E1vR2vw83an9n/Ag=='),
			this.addDataEntry('', 160, 160, '', 'jZLBbsMgDIafhutEoKt63bKtu1Sq1MPOLLgBjYSIOEu6p58JJO0OlYaEhL/fNsaGybKZ9kF15uA1OCZfmSyD95hOzVSCc0xwq5l8YUJw2ky83VGLWeWdCtDifwJECvhWboBEEujx4jIIfmg1RP+CyefRWIRTp6qojlQ3MYONy3KPwX9B6Z0Pc7SsKs51RcrZOnfDz/MirkJ1sj8xm9hE87P3bkB4WnFMaxtVw4fVaAhsNwt5B1sbXFC6e/EqHh6JadWbtfZoHBUihJbIjp65I5o7AAFhutvFGeUW7sE3gOFCLmO+LHpsU6e5WYq6hapPoF5jr0OhQ57LYl7nP2t/vscv'),
			this.addDataEntry('', 160, 160, '', 'jZJNT8QgEIZ/DVdDYd27Vl0vJiZ78IxlthChNDC1XX+9fLW7HjaRhIR53vnKDIS3djl4Mao3J8EQ/kx4653D8rJLC8YQRrUk/IkwRuMl7OWG2mSVjsLDgP8JYCXgW5gJCikg4NlU4N00SEj+DeGPs9IIx1F0SZ1j35EptKbKAb37gtYZ53M07zpKZReVkzbmip/yiVz47qh/Uja2S+ZncGZCeNhwSqut6OFDS1QR7HcreQXdK1xRqb16NXf3kUkR1NZ7Mt4FIvghE0ZZpHUC4BGWm1PMqI7wAM4C+nN0mWux5LEvk6ZqbeoailBAv8VelhIfdS+redl/1v58j18=')
		]);			
	};

	Sidebar.prototype.addSAPTextElementsPalette = function(s, gn, sb)
	{
		var dt = 'sap texts ';
		
		this.addPaletteFunctions('sapTexts', 'SAP / Text Elements', false,
		[
			this.addDataEntry('', 120, 30, '', 'pVPNboMwDH6aSNthUkhU7oWu3WE7bS+QNgaiGcJC2tE9/ZwQilqp0qQdEPH3F1sYJst23DnVN29WAzL5zGTprPXTqR1LQGSCG83khgnB6WFie4fNIst75aDzfzGIyXBSeIQJYSJHshaVpQTBK3WYiPzrGJoqlDMKl5Ikgz/jtSZ4nwbzQ+iaBFnej1G6mPI6veNd+3+lFKYm+sN48gv+8Mof51yae397F2HTaDMsri4XHsaAN76lj7HJwsRo6o7OCFVgTuC8OShcJ7g1Wgdz4YCaVfsYxKnuren8EFJXBVttQtLR22mgGDx4Zz+htGgdIZ3tQkplEG8h6vc92USqZwkTMtNCy1m3Va3BMxEvgCcIjV6GDI3DeHdRIpS2ZAe2Be/OJPk22jdJkZaJN2DqJtlkwtQw1fXFuqwdHdLmzeWy4ZG7+gF+AQ=='),
			this.addDataEntry('', 100, 30, '', 'pVPbboMwDP2aPG4KQeW9wNa9bC/7grS4EM0hLKQd3dfPuVDUrpUmTUogPsfHiR2H5ZWeNlYO3atpAFn+xPLKGuPiSk8VIDLBVcPymgnBaTLxfIfNAssHaaF3fxGIKDhKPEBEmCiQpOXeUATB93IXieLz4A9VSqskLia5jO6Elz5e+zCqb0LX5JAVwxRcF1HRpn/Ya/uvKKVqiX6TGuZ4lO/2eg/CYkozLC42FQ4mj3dO0yXUmc8UVdvTeke1BEvAEaxTO4nrRGjVNF5eWqBjym0IxckejOrd6OOuShp0BRV/XPnvea5oz8pzV/hvLrvJZbdj0qCDH5yJdQt5jM6aD6gMGkqi7k3vj7xXiNcQlec9yUSyZxcm8qwWtW+igD9LrfBExAvgEXxVzjX1VYLpbj8GKDXjBowGZ0/k8qUa1yUPHnuWd6DaLsnyhMkx2u1ZunQ3LVKDz+bykAJ38c5+AA=='),
			this.addDataEntry('', 110, 30, '', 'jVPBcoMgEP0ajp1RaHKPpkkvObU/gGFVpotYxNT067soJjGTzPTguPt23+MBCxO5GfZOtvXBKkAm3pjInbV+isyQAyLjiVZMbBnnCX2M755U07GatNJB4/9D4BPhJLGHCWF8jUTNSksKPDlatG6srL/74CpjXKSKKwG3UNLpX1i0pYtyKY/LsnRa4lLBnxHuVrqJqvgfzRUP+4Pll8nIhhrS13Z4qHIApXtDHZ/aY9iGNC3BTdG1N2vQoRX36xI2ncsM84UR7mEIeO0N3eQ2DftEXTUUI5ShcgLn9VHiJsJGKxXImQMyLotRKKG8tbrxXVBdZWy1DUq9t/GUg3Dnnf2CPF5PY5ugUmrEe4j8fkQaj/ncoqCU/eW2d9JoPBP8DniCYPOyxWAbhqczNkJxwPZgDXh3ppYfrXwdO9JpDpMadFVHmoiY7Ka8ulCvE0tBHNo5vT6OsbZ4O38='),
			this.addDataEntry('', 130, 30, '', 'jVXNcpswEH4aZpIDHRB1fI5xk1N7yRMIWIPGQiJibXCfviskbHAM6QwM4vtZCe1qCZK07t8Nb6rfugAZJL+CJDVaoxvVfQpSBiwSRZDsA8YiugP2tsDGAxs13IDC/zEwZzhzeQKHBOxFknWXEdziRTr45fOkB1SbAkyYa6lNkLwOVvMUhlP8mXREHLTC8MBrIS9OyY3gcsL56JZS2tQz7mzF9JSi5Hgy0H6jy3nzQCIBkVbVNjwXqvzKa9NUXHkjcxhCj6FQxbCBFo+afsKgIcOBYozRFDi2E4Xu5qE62pT55NdYYQfZUVA4G7NFo48QUgSs7nQZz4+l0SdVTPfclNkT21CyUzvZZPA8WWkBuTYchVYhViI/Kmj98oQSeE3FvXaSlVXdZDkznUut+OtjxD/9p4wVRKPSP4c6s3rS+XD7qTCJC1Yk8NX7AeYsciKiP7yGMRJVuQs2n4Dg7IaxWVkz+1WEd5VA+KBMWbij00hYhTV90j6mIacyVDTOqSiAVrk7g0GRc/nqCdTW0WihsLWBNzu66OSl83uzt5nyzA+2WSHXuO0yGT9m7ud6QC4514xrvu2acbvsjBdt8dquxSu7Fq/tWvxoJXSNxWJTDf1iex0g31vfQdeA5uK6gT3LgyJxLTiqQJSVt40Yb917ebXemjUNfL8eX2//hYGb/Tb+AQ=='),
			this.addDataEntry('', 70, 30, '', 'jVNNb4MwDP01OU6CROvOBdbusJ32C7JiIJpJWEg7ul8/54NWmVppB4T9nt+LTQwT9bjsrZyGN9MCMvHMRG2NcTEalxoQGS9Uy0TDOC/oYXx3hy0DW0zSgnb/EfAoOEk8QkQY3yBJq86QAy9m9ROJzdfRN1WV15DoTh5yWlolMSuZ3Rnzmizq0zscOk9S35T4bh5iL1sqKPm03DR6Nbon3sHiVk8aPtrmRxEcR1xhnh3Mg4WoBjfSpTSlHw1VrylG6DxzAuvUQeI2waNqWy+uLFCj8iMYFZRPRmk3e9fHij023unoTPqw3nh21nxCbdBYQrTR3qVTiH8h6vc9yXjK1xLGRdnwxt9ywHdyVHgm4gXwBL7Ry5C+cVjuLkyA0rbswYzg7JlKvlXrhljxFHeqGED1Q1KJhMk55v1Fed0+CtICrul10QOX/Qe/'),
			this.addDataEntry('', 60, 30, '', 'jVPNcoMgEH4aju0gTnKP2iSX9tInoHGjTBexSFLTp+8imAypmekM6PJ9+8/C8lKPOyv79tXUgCx/YXlpjXFB0mMJiExwVbO8YkJw2kxsH7DZxPJeWujcfwxEMDhLPEFAmFgjmRZHQx4EH9RPINZfJ59Ukd1Eoo/ykNLSKomJyuAumOokUhP/U9Chl92iic/mKeSyIYVM9OOiozepYXZGVQd/aQyCQ20zLJKIwsHo8dZpuo0q8zWhajqSD9RUsAScwTp1kLiJhFZ17c0LC5Sj/JhccTr3RnVu8H5XBS26i5I/r/z3ulcUs/TcHf6Xyxa5bNknLUr85Ey8QF/H4Kz5hNKgoSKqznQ+5aNCvIeoPe/RTMTzrMJEnlWi8tM04VupFV6I2AOewXfl2lPfJRgfDuYExancgdHg7IVUvlXt2qCxDrPLW1BNG63yiMkhnJur5W3KSYiDPh9vD2rikvf2Cw=='),
			this.addDataEntry('', 120, 30, '', 'jVPLboMwEPwaHyMRI6JeA7Tppaf0Bxy8gVWMTW1DSb++fpFH20g9IHZndka7y0Lyqp93mg3dm+IgSP5M8korZWPUzxUIQWiGnOQ1oTRzD6EvD9h1YLOBaZD2PwIaBRMTI0SE0I1w0pLj5AhjzyISm4/RN1XeRW16B4UZmPxTclTSro6sR3Em+daVMI1MBGUWOINfEJl5ZXomEndgzanVapR81SihdCxBiXaRP2rFuy7YPhjSjINpNA4WJ3DZO8x2qXbruRXcwHGkX3DYzYLSu5mp9cZ52dnetVivXcgEttLFAo6emUBbbJjYJrhHzr241OD2wA7BKHP5oFBa412LkhS1dxqtirsKxsZqdYIqrqaWSnqXIwrxE3LD7ZOMpnwpITQvik35tOAv6TPVryAm8I1ehvSNw/zw0AKUrmwHqgerz67kE7ntUkU6xqwDbLskyxPGTMzbi/R6ti5Il7uk1z8kcHc/0Dc='),
			this.addDataEntry('', 50, 30, '', 'jVPLboMwEPwaH1OBEajXAE16aE/9Agc2YMXY1BhK+vVdP8g7UiUM65kdsx57SVJ081azvv1UNQiSvJGk0EoZH3VzAUIQGvGaJCWhNMJB6OYJGzs26pkGaf4joF4wMTGCRwjNBErzmk9IDOYoPJF9j7ao/Cpqwtcphp7Jh5K9kma1Zx0XR5KsMYVpzoRTRo4b+C94Zl4NHROB27Hq0Gg1ynpVKaG0T+GSm0X+rBS76oJ9sB36Ggh04pK7gH31d7CzYUHp1faogdniremwmjLGkAneSIwrtB+w3nwCbXjFxDoQHa9rK8814KbZzi0V4bxXXJrBrpvm+OCpFdFLat+nkeI/C8vd4Pdc/JCLH6+JDxY+GuVPwe1jMFodoPCml1JJW/KeC3ELoZdfQUbDfEkhNEnTLH9d8E24AOU7iAmsKydPrUswP73CDgr3dwuqA6OPmPLDa9P6jNTf8qgF3rRBlQSMDX7enJTnfsAgtMQyPbee46468w8='),
			this.addDataEntry('', 120, 30, '', 'pVPBbsMgDP0ajpMIqNm5Sdb2stP2A7RxEjQTMkK7dF8/Q2i7VKo0aYcI/Pzeww6GydJMW6eG7tXWgEy+MFk6a/28M1MJiExwXTNZMSE4fUxsHmSzmOWDctD7vwjELDgpPMKMMJEjSYvGkoPgB4vWxUz+eQxVFUxIzp95I35DvFEHWNCU0woXlNGfcckJZzyN+pvQNRGyfJgi9SbK27TGmvb/cqm0ap0yRHnXnjySKf2c/f1BhM39X2CxOFl4mALeeUM3VmWhXdRtT3uEJmRO4Lw+KFwn2Oi6DuLCAVWq9tGIUzxY3fsxuK4KtqqC09HbuZtoPHpnP6BM19DbPrg0GvEeonrfkkykuLxensxqUcsLb6OMxjMldoAnCIVemwyFw/RwmiKURmkL1oB3Z6J86dp3iZEmjneg2y7JZMLUOMftVXqbTdqk8byEt2cQc4tX8gM=')
		]);			
	};
})();
